/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.agent.SNMPAgentToolkitException;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.diagnostics.snmp.server.SNMPRuntimeStats;
import weblogic.diagnostics.snmp.server.ServerStateTrapUtil;

class ServerStateListener
extends JMXMonitorListener {
    private static final String STATE_ATTRIBUTE = "State";
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugSNMPAgent");
    private static Set shutDownStates = new HashSet();
    private String serverName;
    private boolean serverStarted;
    private boolean serverShutdown;

    private static void ensureShutdownStatesInitialized() {
        if (shutDownStates.isEmpty()) {
            shutDownStates.add("SHUTTING_DOWN");
            shutDownStates.add("FORCE_SHUTTING_DOWN");
            shutDownStates.add("SHUTDOWN");
            shutDownStates.add("UNKNOWN");
        }
    }

    public ServerStateListener(JMXMonitorLifecycle jMXMonitorLifecycle, String string, SNMPAgent sNMPAgent) {
        super(jMXMonitorLifecycle, sNMPAgent);
        this.serverName = string;
        ServerStateListener.ensureShutdownStatesInitialized();
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (notification instanceof AttributeChangeNotification) {
            String string;
            AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)notification;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Got AttributeChangeNotification from " + attributeChangeNotification.getSource());
            }
            if ((string = attributeChangeNotification.getAttributeName()).equals(STATE_ATTRIBUTE)) {
                return true;
            }
        }
        return false;
    }

    public void handleNotification(Notification notification, Object object) {
        block10: {
            if (notification instanceof AttributeChangeNotification) {
                AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)notification;
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Got AttributeChangeNotification from " + attributeChangeNotification.getSource());
                }
                Object object2 = attributeChangeNotification.getNewValue();
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Server state = " + object2 + " for " + this.serverName);
                }
                if (object2.equals("RUNNING")) {
                    try {
                        this.monitorLifecycle.serverStarted(this.serverName);
                        this.sendServerStartNotification();
                    }
                    catch (Exception exception) {
                        if (DEBUG.isDebugEnabled()) {
                            DEBUG.debug("Exception sending server start trap", (Throwable)exception);
                        }
                        break block10;
                    }
                }
                if (this.isShutdownState(object2)) {
                    try {
                        this.monitorLifecycle.serverStopped(this.serverName);
                        this.serverServerShutdownNotification();
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG.isDebugEnabled()) break block10;
                        DEBUG.debug("Exception sending server start trap", throwable);
                    }
                }
            }
        }
    }

    void updateMonitorTrapCount() {
    }

    private boolean isShutdownState(Object object) {
        return shutDownStates.contains(object);
    }

    private void sendServerStartNotification() throws SNMPAgentToolkitException {
        if (!this.serverStarted) {
            SNMPRuntimeStats sNMPRuntimeStats;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Sending serverStart trap for " + this.serverName);
            }
            if ((sNMPRuntimeStats = this.getSNMPRuntimeStats()) != null) {
                sNMPRuntimeStats.incrementServerStartTrapCount();
            }
            ServerStateTrapUtil.sendServerLifecycleNotification(this.snmpAgent, this.serverName, "wlsServerStart");
            this.serverStarted = true;
            this.serverShutdown = false;
        }
    }

    private void serverServerShutdownNotification() throws SNMPAgentToolkitException {
        if (!this.serverShutdown) {
            SNMPRuntimeStats sNMPRuntimeStats;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Sending serverStop trap for " + this.serverName);
            }
            if ((sNMPRuntimeStats = this.getSNMPRuntimeStats()) != null) {
                sNMPRuntimeStats.incrementServerStopTrapCount();
            }
            ServerStateTrapUtil.sendServerLifecycleNotification(this.snmpAgent, this.serverName, "wlsServerShutDown");
            this.serverShutdown = true;
            this.serverStarted = false;
        }
    }
}

