/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.snmp.server;

import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import weblogic.diagnostics.snmp.agent.SNMPAgent;
import weblogic.diagnostics.snmp.i18n.SNMPLogger;
import weblogic.diagnostics.snmp.server.JMXMonitorLifecycle;
import weblogic.diagnostics.snmp.server.JMXMonitorListener;
import weblogic.diagnostics.snmp.server.StringMonitorListener;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPStringMonitorMBean;
import weblogic.management.configuration.ServerMBean;

public class StringMonitorLifecycle
extends JMXMonitorLifecycle {
    public StringMonitorLifecycle(boolean bl, String string, SNMPAgent sNMPAgent, MBeanServerConnection mBeanServerConnection) {
        super(bl, string, sNMPAgent, mBeanServerConnection);
    }

    void initializeMonitorListenerList(SNMPAgentMBean sNMPAgentMBean) throws Exception {
        this.initializeStringMonitors(sNMPAgentMBean.getSNMPStringMonitors());
    }

    private void initializeStringMonitors(SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray) throws Exception {
        if (sNMPStringMonitorMBeanArray == null) {
            return;
        }
        for (int i = 0; i < sNMPStringMonitorMBeanArray.length; ++i) {
            SNMPStringMonitorMBean sNMPStringMonitorMBean = sNMPStringMonitorMBeanArray[i];
            StringMonitorListener stringMonitorListener = null;
            ServerMBean[] serverMBeanArray = sNMPStringMonitorMBean.getEnabledServers();
            int n = serverMBeanArray == null ? 0 : serverMBeanArray.length;
            boolean bl = sNMPStringMonitorMBean.getMonitoredMBeanType().endsWith("Runtime");
            if (bl && this.adminServer && n > 0) {
                for (int j = 0; j < n; ++j) {
                    stringMonitorListener = new StringMonitorListener(this, this.snmpAgent, sNMPStringMonitorMBean.getMonitoredMBeanName(), sNMPStringMonitorMBean.getMonitoredMBeanType(), this.serverName, serverMBeanArray[j].getName(), sNMPStringMonitorMBean.getMonitoredAttributeName(), sNMPStringMonitorMBean.getStringToCompare(), sNMPStringMonitorMBean.isNotifyDiffer(), sNMPStringMonitorMBean.isNotifyMatch());
                    this.monitorListenerList.add(stringMonitorListener);
                    stringMonitorListener.setName(sNMPStringMonitorMBean.getName());
                    stringMonitorListener.setPollingIntervalSeconds(sNMPStringMonitorMBean.getPollingInterval());
                }
                continue;
            }
            stringMonitorListener = new StringMonitorListener(this, this.snmpAgent, sNMPStringMonitorMBean.getMonitoredMBeanName(), sNMPStringMonitorMBean.getMonitoredMBeanType(), this.serverName, null, sNMPStringMonitorMBean.getMonitoredAttributeName(), sNMPStringMonitorMBean.getStringToCompare(), sNMPStringMonitorMBean.isNotifyDiffer(), sNMPStringMonitorMBean.isNotifyMatch());
            this.monitorListenerList.add(stringMonitorListener);
            stringMonitorListener.setName(sNMPStringMonitorMBean.getName());
            stringMonitorListener.setPollingIntervalSeconds(sNMPStringMonitorMBean.getPollingInterval());
        }
    }

    void registerMonitor(ObjectName objectName, JMXMonitorListener jMXMonitorListener) {
        StringMonitorListener stringMonitorListener = (StringMonitorListener)jMXMonitorListener;
        try {
            ObjectName objectName2 = this.getMonitorObjectName(objectName, stringMonitorListener, "StringMonitor");
            if (!this.mbeanServerConnection.isRegistered(objectName2)) {
                ObjectInstance objectInstance = this.mbeanServerConnection.createMBean("javax.management.monitor.StringMonitor", objectName2);
                objectName2 = objectInstance.getObjectName();
            } else {
                this.mbeanServerConnection.invoke(objectName2, "stop", new Object[0], new String[0]);
            }
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("GranularityPeriod", new Long(stringMonitorListener.getPollingIntervalSeconds() * 1000)));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("ObservedAttribute", stringMonitorListener.getAttributeName()));
            this.mbeanServerConnection.invoke(objectName2, "addObservedObject", new Object[]{objectName}, new String[]{"javax.management.ObjectName"});
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("StringToCompare", stringMonitorListener.getStringToCompare()));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("NotifyDiffer", new Boolean(stringMonitorListener.isNotifyDiffer())));
            this.mbeanServerConnection.setAttribute(objectName2, new Attribute("NotifyMatch", new Boolean(stringMonitorListener.isNotifyMatch())));
            this.registerMonitorListener(objectName2, stringMonitorListener, null);
            this.mbeanServerConnection.invoke(objectName2, "start", new Object[0], new String[0]);
            stringMonitorListener.setMonitor(objectName2);
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Registered " + objectName2 + " to observe " + objectName + ":" + stringMonitorListener.getAttributeName());
            }
        }
        catch (Throwable throwable) {
            SNMPLogger.logMonitorCreationError((String)stringMonitorListener.getName(), (String)"SNMPStringMonitorMBean", (String)objectName.toString(), (Throwable)throwable);
        }
    }
}

