/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import weblogic.logging.Loggable;
import weblogic.management.ManagementLogger;
import weblogic.management.NoAccessRuntimeException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AdminResource;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.RoleManager;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;

public class SecurityHelper {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static RoleManager roleManager;
    private static AdminResource adminMBeanResource;
    private static final String ADMIN_ROLENAME = "Admin";

    private SecurityHelper() {
    }

    public static void checkForAdminRole() {
        SecurityHelper.checkForRole(ADMIN_ROLENAME);
    }

    public static void checkForRole(final String string) {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            return;
        }
        final AuthenticatedSubject authenticatedSubject2 = SecurityServiceManager.seal((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
        Boolean bl = (Boolean)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Map map = SecurityHelper.getRoleManager().getRoles(authenticatedSubject2, (Resource)adminMBeanResource, null);
                return map != null && (map.get(SecurityHelper.ADMIN_ROLENAME) != null || map.get(string) != null) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (bl.booleanValue()) {
            return;
        }
        Loggable loggable = ManagementLogger.logNoAccessForSubjectRoleLoggable((String)authenticatedSubject2.toString(), (String)string);
        throw new NoAccessRuntimeException(loggable.getMessage());
    }

    private static RoleManager getRoleManager() {
        return roleManager != null ? roleManager : (roleManager = (RoleManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.ROLE));
    }

    static {
        adminMBeanResource = new AdminResource("Configuration", null, null);
    }
}

