/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import weblogic.diagnostics.i18n.DiagnosticsTextWatchTextFormatter;

public final class ConsoleUtils {
    private static final String[] RELATIONAL_OPERATORS = new String[]{"<", "<=", ">", ">=", "=", "!=", "IN", "LIKE", "MATCHES"};
    private static final String[] LOGICAL_OPERATORS = new String[]{"AND", "OR", "NOT", "("};
    private static final String ATTR_SEPARATOR = "//";
    private static final String BEGIN_ENCLOSER = "${";
    private static final String END_ENCLOSER = "}";
    private static final String TYPE_BEGIN_DELIMITER = "[";
    private static final String TYPE_END_DELIMITER = "]";

    public static String[] getRelationalOperators() {
        return RELATIONAL_OPERATORS;
    }

    public static String[] getLogicalOperators() {
        return LOGICAL_OPERATORS;
    }

    public static String buildWatchVariableExpression(String string, String string2, String string3) {
        return ConsoleUtils.buildWatchVariableExpression("ServerRuntime", string, string2, string3);
    }

    public static String buildWatchVariableExpression(String string, String string2, String string3, String string4) {
        String string5;
        String string6 = string3 == null ? null : string3.trim();
        String string7 = string2 == null ? null : string2.trim();
        String string8 = string5 = string4 == null ? null : string4.trim();
        if (string5 == null || string5.length() == 0) {
            throw new IllegalArgumentException(DiagnosticsTextWatchTextFormatter.getInstance().getEmptyWatchAttributeConsoleText());
        }
        if (!(string6 != null && string6.length() != 0 || string7 != null && string7.length() != 0)) {
            throw new IllegalArgumentException(DiagnosticsTextWatchTextFormatter.getInstance().getIncompleteWatchVariableConsoleText());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BEGIN_ENCLOSER);
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(string.trim());
            stringBuffer.append(ATTR_SEPARATOR);
        }
        if (string7 != null && string7.length() > 0) {
            stringBuffer.append(TYPE_BEGIN_DELIMITER);
            stringBuffer.append(string7);
            stringBuffer.append(TYPE_END_DELIMITER);
        }
        if (string6 != null && string6.length() > 0) {
            stringBuffer.append(string6);
        }
        stringBuffer.append(ATTR_SEPARATOR);
        stringBuffer.append(string5);
        stringBuffer.append(END_ENCLOSER);
        return stringBuffer.toString();
    }
}

