/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.adaptive.harvester.WatchedValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.WLDFHarvesterUtils;
import weblogic.diagnostics.query.UnknownVariableException;
import weblogic.diagnostics.query.VariableInstance;
import weblogic.diagnostics.query.VariableResolver;
import weblogic.diagnostics.watch.WatchConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HarvesterVariablesImpl
implements VariableResolver {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private WatchedValues watchedValues;

    HarvesterVariablesImpl(WatchConfiguration watchConfiguration) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created HarvesterVariableImpl " + this);
        }
        if (watchConfiguration != null) {
            this.watchedValues = watchConfiguration.getWatchedValues();
        }
    }

    public Object resolveVariable(String string) throws UnknownVariableException {
        throw new UnsupportedOperationException("Variable resolution is only supported by index");
    }

    public Object resolveVariable(int n) throws UnknownVariableException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Getting value for variable at index" + n);
        }
        WatchedValues.Values values = this.watchedValues.getMetric(n);
        WatchedValues.Values.ValuesData valuesData = values.getValues();
        Object object = null;
        if (valuesData != null) {
            List list = valuesData.getRawValues();
            Object[] objectArray = new Object[list.size()];
            Iterator iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                WatchedValues.Values.RawValueData rawValueData = (WatchedValues.Values.RawValueData)iterator.next();
                Object[] objectArray2 = rawValueData.getValue();
                if (objectArray2 != null) {
                    if (objectArray2 instanceof WatchedValues.AttributeTrackedDataItem) {
                        WatchedValues.AttributeTrackedDataItem attributeTrackedDataItem = (WatchedValues.AttributeTrackedDataItem)objectArray2;
                        objectArray2 = new HarvesterVariableValueInstance(rawValueData.getInstanceName(), attributeTrackedDataItem);
                    } else if (objectArray2.getClass().isArray()) {
                        objectArray2 = HarvesterVariablesImpl.getLeafValues(rawValueData, objectArray2);
                    }
                }
                objectArray[n2++] = objectArray2;
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("Raw value for (" + rawValueData.getInstanceName() + "//" + rawValueData.getAttributeName() + "): " + objectArray2);
            }
            object = objectArray != null && objectArray.length == 1 ? objectArray[0] : objectArray;
            if (debugLogger.isDebugEnabled()) {
                if (object != null && object.getClass().isArray()) {
                    debugLogger.debug("Outgoing array of values (" + ((Object[])object).length + " total): " + Arrays.toString((Object[])object));
                } else {
                    debugLogger.debug("Outgoing scalar value: " + object);
                }
            }
        }
        return object;
    }

    public static Object[] getLeafValues(WatchedValues.Values.RawValueData rawValueData, Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            HarvesterVariablesImpl.addItems(rawValueData, arrayList, objectArray);
        }
        return arrayList.toArray();
    }

    private static void addItems(WatchedValues.Values.RawValueData rawValueData, List<Object> list, Object[] objectArray) {
        for (Object object : objectArray) {
            Object object2;
            if (object == null) continue;
            if (object instanceof WatchedValues.AttributeTrackedDataItem) {
                object2 = (WatchedValues.AttributeTrackedDataItem)object;
                if (object2.getData() == null) continue;
                object = new HarvesterVariableValueInstance(rawValueData.getInstanceName(), (WatchedValues.AttributeTrackedDataItem)object2);
            }
            if (((Class)(object2 = object.getClass())).isArray()) {
                HarvesterVariablesImpl.addItems(rawValueData, list, (Object[])object);
                continue;
            }
            list.add(object);
        }
    }

    public int resolveInteger(int n) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public long resolveLong(int n) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public float resolveFloat(int n) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public double resolveDouble(int n) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public String resolveString(int n) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public int resolveInteger(String string) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public long resolveLong(String string) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public float resolveFloat(String string) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public double resolveDouble(String string) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    public String resolveString(String string) throws UnknownVariableException {
        throw new UnsupportedOperationException();
    }

    private static class HarvesterVariableValueInstance
    implements VariableInstance {
        String instanceName;
        WatchedValues.AttributeTrackedDataItem item;

        public HarvesterVariableValueInstance(String string, WatchedValues.AttributeTrackedDataItem attributeTrackedDataItem) {
            this.instanceName = string;
            this.item = attributeTrackedDataItem;
        }

        public String getAttributeName() {
            return WLDFHarvesterUtils.buildDataContextString(this.item.getDataContext());
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public Object getInstanceValue() {
            return this.item.getData();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(this.instanceName);
            stringBuilder.append("//");
            stringBuilder.append(this.getAttributeName());
            stringBuilder.append(":");
            stringBuilder.append(this.getInstanceValue());
            return stringBuilder.toString();
        }
    }
}

