/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.InvalidHarvesterInstanceNameException;
import weblogic.diagnostics.harvester.InvalidHarvesterNamespaceException;
import weblogic.diagnostics.harvester.WLDFHarvesterUtils;
import weblogic.diagnostics.i18n.DiagnosticsTextTextFormatter;
import weblogic.diagnostics.i18n.DiagnosticsTextWatchTextFormatter;
import weblogic.utils.PlatformConstants;

public class HarvesterVariablesParser {
    private static final DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private static Pattern TYPE_PAT = Pattern.compile("([a-zA-Z_$][a-zA-Z0-9_$]*\\.)*[a-zA-Z_$][a-zA-Z0-9_$]*");

    static HarvesterVariablesParser getInstance() {
        return SingletonWrapper.SINGLETON;
    }

    static String[] parse(String string, String string2) {
        Object object;
        String string3;
        if (string2 == null) {
            string2 = "Unknown";
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Get properties for " + string);
        }
        String string4 = "";
        int n = 0;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String[] stringArray = string.trim().split("//");
        if (stringArray.length < 2) {
            String string8 = DiagnosticsTextTextFormatter.getInstance().getBadHarvesterVariableName(string, string2);
            throw new IllegalArgumentException(string8);
        }
        if (stringArray.length > 2) {
            string5 = stringArray[0].trim();
            string7 = stringArray[1].trim();
            string6 = stringArray[2].trim();
        } else {
            string7 = stringArray[0].trim();
            string6 = stringArray[1].trim();
        }
        int n2 = 0;
        String string9 = null;
        String string10 = null;
        if (string7.startsWith("[")) {
            int n3 = string7.indexOf(93);
            if (n3 > 0) {
                string9 = string7.substring(1, n3).trim();
                n2 = n3 + 1;
            }
            if (n2 > 0 && n2 < string7.length()) {
                string10 = string7.substring(n2).trim();
            }
        } else {
            string10 = string7;
        }
        if (string5 != null && string5.length() > 0) {
            try {
                WLDFHarvesterUtils.validateNamespace(string5);
            }
            catch (InvalidHarvesterNamespaceException invalidHarvesterNamespaceException) {
                string4 = string4 + "" + PlatformConstants.EOL + ++n + ") " + invalidHarvesterNamespaceException.getMessage();
            }
        }
        String string11 = null;
        if (string10 != null && string10.length() > 0) {
            try {
                WLDFHarvesterUtils.normalizeInstanceName(string10);
            }
            catch (InvalidHarvesterInstanceNameException invalidHarvesterInstanceNameException) {
                string3 = DiagnosticsTextTextFormatter.getInstance().getInvalidObjectName(string10, string, string2);
                string4 = string4 + "" + PlatformConstants.EOL + ++n + ") " + string3;
            }
            string11 = WLDFHarvesterUtils.getTypeForInstance(string10);
            if (string9 == null || string9.length() == 0) {
                string9 = string11;
            }
        }
        if (string9 != null && string9.length() != 0 && !((Matcher)(object = TYPE_PAT.matcher(string9))).matches()) {
            string3 = DiagnosticsTextTextFormatter.getInstance().getBadHarvesterVariableType(string9, string, string2);
            string4 = string4 + "" + PlatformConstants.EOL + ++n + ") " + string3;
        }
        if (string9 != null && string11 != null && !string9.equals(string11)) {
            object = DiagnosticsTextTextFormatter.getInstance().getHarvesterVariableTypeMismatch(string, string10, string9, string11);
            string4 = string4 + "" + PlatformConstants.EOL + ++n + ") " + (String)object;
        }
        if (!(string10 != null && string10.length() != 0 || string9 != null && string9.length() != 0)) {
            object = DiagnosticsTextTextFormatter.getInstance().getMissingBothTypeAndInstanceName(string, string2);
            string4 = string4 + "" + PlatformConstants.EOL + ++n + ") " + (String)object;
        }
        if (string6 == null || string6.length() == 0) {
            object = DiagnosticsTextWatchTextFormatter.getInstance().getNullWatchVariableAttributeNameText(string6, string2);
            string4 = string4 + "" + PlatformConstants.EOL + ++n + ") " + (String)object;
        } else if (string6.length() == 0) {
            object = DiagnosticsTextTextFormatter.getInstance().getEmptyAttributeName(string, string2);
            string4 = string4 + "" + PlatformConstants.EOL + ++n + ") " + (String)object;
        } else {
            try {
                string6 = HarvesterVariablesParser.normalizeAttributeName(string9, string6, string10);
            }
            catch (Exception exception) {
                string3 = DiagnosticsTextTextFormatter.getInstance().getBadHarvesterVariableAttr(string6, string, string2);
                string4 = string4 + "" + PlatformConstants.EOL + ++n + ") " + string3;
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Normalized attribute: " + string6);
            }
        }
        if (n > 0) {
            object = DiagnosticsTextTextFormatter.getInstance().getErrorsOcurredParsingHarvesterVariableName(string, string2, string4, n);
            throw new IllegalArgumentException((String)object);
        }
        return new String[]{string5, string9, string10, string6};
    }

    private static String normalizeAttributeName(String string, String string2, String string3) {
        if (string != null) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Normalizing attribute " + string2 + " based on type name " + string);
            }
            string2 = WLDFHarvesterUtils.normalizeAttributeSpecification(string, string2);
        } else if (string3 != null) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Normalizing attribute " + string2 + " based on instance name " + string3);
            }
            string2 = WLDFHarvesterUtils.normalizeAttributeForInstance(string3, string2);
        } else {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Normalizing attribute " + string2 + " using default normalizer");
            }
            string2 = WLDFHarvesterUtils.normalizeAttributeSpecification(null, string2);
        }
        return string2;
    }

    private static class SingletonWrapper {
        private static HarvesterVariablesParser SINGLETON = new HarvesterVariablesParser();

        private SingletonWrapper() {
        }
    }
}

