/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.diagnostics.notifications.InvalidNotificationException;
import com.bea.diagnostics.notifications.Notification;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.image.ImageAlreadyCapturedException;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.InvalidDestinationDirectoryException;
import weblogic.diagnostics.image.InvalidLockoutTimeException;
import weblogic.diagnostics.type.DiagnosticRuntimeException;
import weblogic.diagnostics.watch.NotificationCreateException;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.diagnostics.watch.WatchNotificationListenerCommon;

final class ImageNotificationListener
extends WatchNotificationListenerCommon
implements WatchNotificationListener {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private String imageLocation;
    private int imageLockoutMinutes;

    ImageNotificationListener(String string) throws InvalidNotificationException, NotificationCreateException {
        this(string, null, -1);
    }

    ImageNotificationListener(String string, String string2, int n) throws InvalidNotificationException, NotificationCreateException {
        super(string);
        this.imageLocation = string2;
        this.imageLockoutMinutes = n;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created image notification for location: " + string2 + " lockout: " + n);
        }
    }

    ImageNotificationListener(String string, String string2) throws InvalidNotificationException, NotificationCreateException {
        this(string, string2, -1);
    }

    String getImageLocation() {
        return this.imageLocation;
    }

    int getImageLockoutMinutes() {
        return this.imageLockoutMinutes;
    }

    void setImageLocation(String string) {
        this.imageLocation = string;
    }

    void setImageLockoutMinutes(int n) {
        this.imageLockoutMinutes = n;
    }

    public void processWatchNotification(Notification notification) {
        ImageManager imageManager = ImageManager.getInstance();
        try {
            try {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Handle image notification for location: " + this.imageLocation + " lockout: " + this.imageLockoutMinutes);
                    debugLogger.debug("Watch notification: " + notification);
                }
                if (this.imageLocation != null && this.imageLockoutMinutes >= 0) {
                    imageManager.captureImage(this.imageLocation, this.imageLockoutMinutes);
                } else if (this.imageLocation != null) {
                    imageManager.captureImage(this.imageLocation);
                } else if (this.imageLockoutMinutes >= 0) {
                    imageManager.captureImage(this.imageLockoutMinutes);
                } else {
                    imageManager.captureImage();
                }
                this.getWatchRuntime().incrementTotalDIMGNotificationsPerformed();
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Capture image started successfully.");
                }
            }
            catch (InvalidLockoutTimeException invalidLockoutTimeException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Capture image failed due to invalid lockout time ", (Throwable)((Object)invalidLockoutTimeException));
                }
                DiagnosticsLogger.logInvalidNotificationLockoutMinutes((String)("" + this.imageLockoutMinutes));
                throw invalidLockoutTimeException;
            }
            catch (InvalidDestinationDirectoryException invalidDestinationDirectoryException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Capture image failed due to invalid destination ", (Throwable)((Object)invalidDestinationDirectoryException));
                }
                DiagnosticsLogger.logInvalidNotificationImageLocation((String)this.imageLocation, (String)("" + (Object)((Object)invalidDestinationDirectoryException)));
                throw invalidDestinationDirectoryException;
            }
            catch (ImageAlreadyCapturedException imageAlreadyCapturedException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Capture image failed due to already captured exception ", (Throwable)((Object)imageAlreadyCapturedException));
                }
                DiagnosticsLogger.logNotificationImageAlreadyCaptured((String)("" + (Object)((Object)imageAlreadyCapturedException)));
                throw imageAlreadyCapturedException;
            }
            catch (Exception exception) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Capture image failed with exception ", (Throwable)exception);
                }
                DiagnosticsLogger.logErrorInNotification((Throwable)exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Incrementing failed notifications ", throwable);
            }
            this.getWatchRuntime().incrementTotalFailedDIMGNotifications();
            throw new DiagnosticRuntimeException(throwable);
        }
    }

    public String toString() {
        return "ImageNotificationListener - image directory: " + this.imageLocation + " image lockout minutes: " + this.imageLockoutMinutes + " isEnabled: " + this.isEnabled();
    }
}

