/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.diagnostics.notifications.InvalidNotificationException;
import com.bea.diagnostics.notifications.JMSNotificationCustomizer;
import com.bea.diagnostics.notifications.JMSNotificationService;
import com.bea.diagnostics.notifications.Notification;
import com.bea.diagnostics.notifications.NotificationPropagationException;
import com.bea.diagnostics.notifications.NotificationServiceFactory;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.type.DiagnosticRuntimeException;
import weblogic.diagnostics.watch.NotificationCreateException;
import weblogic.diagnostics.watch.WatchNotification;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.diagnostics.watch.WatchNotificationListenerCommon;

final class JMSNotificationListener
extends WatchNotificationListenerCommon
implements WatchNotificationListener,
JMSNotificationCustomizer {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private static final String JMS_NOTIFICATION_NAME = "JMSNotificationName";
    private String destinationJNDIName;
    private String connectionFactoryJNDIName;
    private JMSNotificationService jmsService;

    JMSNotificationListener(String string, String string2) throws NotificationCreateException, InvalidNotificationException {
        this(string, string2, null);
    }

    JMSNotificationListener(String string, String string2, String string3) throws NotificationCreateException, InvalidNotificationException {
        super(string);
        if (string2 == null) {
            throw new NotificationCreateException("JNDI name for JMS Destination must be set and cannot be null");
        }
        this.destinationJNDIName = string2;
        this.connectionFactoryJNDIName = string3 == null ? "weblogic.jms.ConnectionFactory" : string3;
        try {
            this.jmsService = NotificationServiceFactory.getInstance().createJMSNotificationService(this.getNotificationName(), this.destinationJNDIName, this.connectionFactoryJNDIName, (JMSNotificationCustomizer)this);
        }
        catch (com.bea.diagnostics.notifications.NotificationCreateException notificationCreateException) {
            throw new NotificationCreateException(notificationCreateException);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created JMS notification " + this);
        }
    }

    String getDestinationJNDIName() {
        return this.destinationJNDIName;
    }

    String getConnectionFactoryJNDIName() {
        return this.connectionFactoryJNDIName;
    }

    public synchronized void processWatchNotification(Notification notification) {
        try {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Handle jms notification for " + this);
                debugLogger.debug("Watch notification: " + notification);
            }
            if (this.jmsService != null) {
                this.jmsService.send(notification);
                this.getWatchRuntime().incrementTotalJMSNotificationsPerformed();
            }
        }
        catch (Throwable throwable) {
            DiagnosticsLogger.logJMSNotificationSendMsgException((Throwable)throwable);
            this.getWatchRuntime().incrementTotalFailedJMSNotifications();
            throw new DiagnosticRuntimeException(throwable);
        }
    }

    public String toString() {
        return "JMSNotificationListener " + this.getNotificationName() + " - " + (this.jmsService != null ? this.jmsService.toString() : "");
    }

    public Message createMessage(Session session, Notification notification) throws NotificationPropagationException {
        try {
            MapMessage mapMessage = session.createMapMessage();
            WatchNotification watchNotification = (WatchNotification)notification;
            mapMessage.setString("WatchTime", watchNotification.getWatchTime());
            mapMessage.setString("WatchDomainName", watchNotification.getWatchDomainName());
            mapMessage.setString("WatchServerName", watchNotification.getWatchServerName());
            mapMessage.setString("WatchSeverityLevel", watchNotification.getWatchSeverityLevel());
            mapMessage.setString("WatchName", watchNotification.getWatchName());
            mapMessage.setString("WatchRuleType", watchNotification.getWatchRuleType());
            mapMessage.setString("WatchRule", watchNotification.getWatchRule());
            mapMessage.setString("WatchAlarmType", watchNotification.getWatchAlarmType());
            mapMessage.setString("WatchAlarmResetPeriod", watchNotification.getWatchAlarmResetPeriod());
            mapMessage.setString(JMS_NOTIFICATION_NAME, this.getNotificationName());
            mapMessage.setString("WatchData", watchNotification.getWatchDataToString());
            return mapMessage;
        }
        catch (Exception exception) {
            DiagnosticsLogger.logJMSNotificationCreateMsgException((Throwable)exception);
            throw new NotificationPropagationException((Throwable)exception);
        }
    }
}

