/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.diagnostics.notifications.InvalidNotificationException;
import com.bea.diagnostics.notifications.JMXNotificationCustomizer;
import com.bea.diagnostics.notifications.JMXNotificationProducerMBean;
import com.bea.diagnostics.notifications.JMXNotificationService;
import com.bea.diagnostics.notifications.Notification;
import com.bea.diagnostics.notifications.NotificationRuntimeException;
import com.bea.diagnostics.notifications.NotificationServiceFactory;
import java.util.Date;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.type.DiagnosticRuntimeException;
import weblogic.diagnostics.watch.JMXNotificationProducer;
import weblogic.diagnostics.watch.JMXWatchNotification;
import weblogic.diagnostics.watch.NotificationCreateException;
import weblogic.diagnostics.watch.WatchNotification;
import weblogic.diagnostics.watch.WatchNotificationInternal;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.diagnostics.watch.WatchNotificationListenerCommon;
import weblogic.management.ManagementException;
import weblogic.management.jmx.modelmbean.NotificationGenerator;

public final class JMXNotificationListener
extends WatchNotificationListenerCommon
implements WatchNotificationListener,
JMXNotificationCustomizer {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private String notificationType;
    private NotificationGenerator notificationGenerator;
    private JMXNotificationProducer notificationProducer = null;
    private JMXNotificationService jmxService;

    JMXNotificationListener(String string, JMXNotificationProducer jMXNotificationProducer) throws ManagementException, InvalidNotificationException, NotificationCreateException {
        this(string, null, jMXNotificationProducer);
    }

    JMXNotificationListener(String string, String string2, JMXNotificationProducer jMXNotificationProducer) throws ManagementException, InvalidNotificationException, NotificationCreateException {
        super(string);
        if (jMXNotificationProducer == null) {
            throw new InvalidNotificationException("Producer must be set and cannot be null");
        }
        this.notificationProducer = jMXNotificationProducer;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created JMX notification " + this);
        }
        try {
            this.jmxService = NotificationServiceFactory.getInstance().createJMXNotificationService(string, (JMXNotificationProducerMBean)jMXNotificationProducer, string2, (JMXNotificationCustomizer)this);
        }
        catch (com.bea.diagnostics.notifications.NotificationCreateException notificationCreateException) {
            throw new NotificationRuntimeException((Throwable)notificationCreateException);
        }
        this.setNotificationType(string2);
    }

    public void processWatchNotification(Notification notification) {
        try {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Handle JMX notification for " + this);
                debugLogger.debug("Watch notification: " + notification);
            }
            if (this.jmxService != null) {
                this.jmxService.send(notification);
                this.getWatchRuntime().incrementTotalJMXNotificationsPerformed();
            }
        }
        catch (Throwable throwable) {
            this.getWatchRuntime().incrementTotalFailedJMXNotifications();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("JMX send notification failed with exception ", throwable);
            }
            DiagnosticsLogger.logErrorInNotification((Throwable)throwable);
            throw new DiagnosticRuntimeException(throwable);
        }
    }

    void setNotificationGenerator(NotificationGenerator notificationGenerator) {
        this.notificationGenerator = notificationGenerator;
    }

    public String toString() {
        return "JMXNotificationListener - notification runtime mbean name: " + this.notificationName;
    }

    public void setNotificationType(String string) {
        this.notificationType = string;
        this.jmxService.setNotificationType(string);
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public javax.management.Notification createJMXNotification(Notification notification) {
        JMXWatchNotification jMXWatchNotification = null;
        if (notification instanceof WatchNotificationInternal) {
            WatchNotificationInternal watchNotificationInternal = (WatchNotificationInternal)notification;
            try {
                WatchNotification watchNotification = watchNotificationInternal.createWatchNotificationExternal();
                jMXWatchNotification = new JMXWatchNotification(this.getNotificationType(), watchNotification.getWatchName(), 0L, new Date().getTime(), watchNotification.getMessage(), watchNotification);
            }
            catch (Exception exception) {
                throw new NotificationRuntimeException((Throwable)exception);
            }
        }
        return jMXWatchNotification;
    }
}

