/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.diagnostics.notifications.InvalidNotificationException;
import com.bea.diagnostics.notifications.JMXNotificationProducerMBean;
import javax.management.Notification;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.type.DiagnosticRuntimeException;
import weblogic.diagnostics.watch.WatchNotificationRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.jmx.modelmbean.NotificationGenerator;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WLDFWatchJMXNotificationRuntimeMBean;

public final class JMXNotificationProducer
extends RuntimeMBeanDelegate
implements WLDFWatchJMXNotificationRuntimeMBean,
JMXNotificationProducerMBean {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private static long sequenceNumber = 0L;
    private NotificationGenerator notificationGenerator;
    private static JMXNotificationProducer singleton = null;

    static JMXNotificationProducer getInstance() {
        if (singleton == null) {
            try {
                singleton = new JMXNotificationProducer("DiagnosticsJMXNotificationSource");
                WatchNotificationRuntimeMBeanImpl.getInstance().setWatchJMXNotificationRuntime(singleton);
            }
            catch (ManagementException managementException) {
                throw new RuntimeException(managementException);
            }
        }
        return singleton;
    }

    private JMXNotificationProducer(String string) throws ManagementException, InvalidNotificationException {
        super(string, (RuntimeMBean)WatchNotificationRuntimeMBeanImpl.getInstance());
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created JMX notification producer " + this);
        }
    }

    private void postJMXNotification(Notification notification) {
        if (this.notificationGenerator != null && this.notificationGenerator.isSubscribed()) {
            try {
                this.notificationGenerator.sendNotification(notification);
            }
            catch (Exception exception) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("JMX send notification failed with exception ", (Throwable)exception);
                }
                DiagnosticsLogger.logErrorInNotification((Throwable)exception);
                throw new DiagnosticRuntimeException(exception);
            }
        }
    }

    void setNotificationGenerator(NotificationGenerator notificationGenerator) {
        this.notificationGenerator = notificationGenerator;
    }

    public String toString() {
        return "JMXNotificationProducer - notification runtime mbean name: " + this.getName();
    }

    public void sendNotification(Notification notification) {
        this.postJMXNotification(notification);
    }

    public long generateSequenceNumber() {
        return sequenceNumber++;
    }
}

