/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.diagnostics.notifications.InvalidNotificationException;
import com.bea.diagnostics.notifications.Notification;
import com.bea.diagnostics.notifications.NotificationServiceFactory;
import com.bea.diagnostics.notifications.SMTPNotificationCustomizer;
import com.bea.diagnostics.notifications.SMTPNotificationService;
import javax.mail.Session;
import javax.naming.InitialContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.i18n.DiagnosticsTextTextFormatter;
import weblogic.diagnostics.notifications.i18n.NotificationsTextTextFormatter;
import weblogic.diagnostics.watch.NotificationCreateException;
import weblogic.diagnostics.watch.WatchNotification;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.diagnostics.watch.WatchNotificationListenerCommon;
import weblogic.diagnostics.watch.WatchUtils;

final class SMTPNotificationListener
extends WatchNotificationListenerCommon
implements WatchNotificationListener,
SMTPNotificationCustomizer {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private static final String SMTP_NOTIFICATION_NAME = "SMTPNotificationName";
    private String[] smtpRecipients;
    private String smtpSubject;
    private String smtpBody;
    private String mailSessionJNDIName;
    private Session mailSession;
    private SMTPNotificationService smtpService;

    SMTPNotificationListener(String string, String string2, String[] stringArray) throws NotificationCreateException, InvalidNotificationException {
        this(string, string2, stringArray, null, null);
    }

    SMTPNotificationListener(String string, String string2, String[] stringArray, String string3, String string4) throws NotificationCreateException {
        super(string);
        if (stringArray == null) {
            throw new InvalidNotificationException("Email destination must be set and cannot be null");
        }
        if (string2 == null) {
            throw new InvalidNotificationException("Mail Session JNDI Name must be set and cannot be null");
        }
        this.smtpRecipients = stringArray;
        this.smtpSubject = string3;
        this.smtpBody = string4;
        this.mailSessionJNDIName = string2;
        this.mailSession = null;
        this.initializeSMTP();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created smtp notification " + this);
        }
    }

    String[] getSMTPRecipients() {
        return this.smtpRecipients;
    }

    String getSMTPSubject() {
        return this.smtpSubject;
    }

    String getSMTPBody() {
        return this.smtpBody;
    }

    String getMailSessionJNDIName() {
        return this.mailSessionJNDIName;
    }

    void setSMTPRecipients(String[] stringArray) {
        this.smtpRecipients = stringArray;
        if (this.smtpService != null) {
            String string = WatchUtils.getToAddresses(this.smtpRecipients);
            this.smtpService.setSMTPRecipients(string);
        }
    }

    void setSMTPSubject(String string) {
        this.smtpSubject = string;
        try {
            this.initializeSMTP();
        }
        catch (NotificationCreateException notificationCreateException) {
            // empty catch block
        }
    }

    void setSMTPBody(String string) {
        this.smtpBody = string;
        try {
            this.initializeSMTP();
        }
        catch (NotificationCreateException notificationCreateException) {
            // empty catch block
        }
    }

    void setMailSessionJNDIName(String string) {
        this.mailSessionJNDIName = string;
        try {
            this.initializeSMTP();
        }
        catch (NotificationCreateException notificationCreateException) {
            // empty catch block
        }
    }

    public synchronized void processWatchNotification(Notification notification) {
        try {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Handle smtp notification for " + this);
                debugLogger.debug("Watch notification: " + notification);
            }
            this.getSMTPService().send(notification);
            this.getWatchRuntime().incrementTotalSMTPNotificationsPerformed();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("SMTP send of message suceeded.");
            }
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("SMTP create of message or send failed with exception ", (Throwable)exception);
            }
            this.getWatchRuntime().incrementTotalFailedSMTPNotifications();
            DiagnosticsLogger.logMessagingExceptionInNotification((Throwable)exception);
        }
    }

    public String toString() {
        return "SMTPNotificationListener - email recipients: " + this.smtpRecipients + " subject: " + this.smtpSubject + " body: " + this.smtpBody + " mailSession: " + this.mailSession + " ndi name: " + this.mailSessionJNDIName;
    }

    private String getDefaultSubject(WatchNotification watchNotification) {
        DiagnosticsTextTextFormatter diagnosticsTextTextFormatter = DiagnosticsTextTextFormatter.getInstance();
        String string = diagnosticsTextTextFormatter.getSMTPDefaultSubject(watchNotification.getWatchName(), watchNotification.getWatchSeverityLevel(), watchNotification.getWatchServerName(), watchNotification.getWatchTime());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultBody(WatchNotification watchNotification) {
        StringBuffer stringBuffer;
        NotificationsTextTextFormatter notificationsTextTextFormatter = NotificationsTextTextFormatter.getInstance();
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchTime", watchNotification.getWatchTime()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchDomainName", watchNotification.getWatchDomainName()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchServerName", watchNotification.getWatchServerName()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchSeverityLevel", watchNotification.getWatchSeverityLevel()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchName", watchNotification.getWatchName()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchRuleType", watchNotification.getWatchRuleType()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchRule", watchNotification.getWatchRule()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchData", watchNotification.getWatchDataToString()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchAlarmType", watchNotification.getWatchAlarmType()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchAlarmResetPeriod", watchNotification.getWatchAlarmResetPeriod()));
            stringBuffer.append(notificationsTextTextFormatter.getSMTPDefaultBodyLine(SMTP_NOTIFICATION_NAME, this.getNotificationName()));
        }
        return stringBuffer.toString();
    }

    private synchronized void initializeSMTP() throws NotificationCreateException, InvalidNotificationException {
        Object object;
        try {
            object = new InitialContext();
            this.mailSession = (Session)((InitialContext)object).lookup(this.mailSessionJNDIName);
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Mail session lookup failed with exception ", (Throwable)exception);
            }
            DiagnosticsLogger.logErrorInMailNotification((Throwable)exception);
            throw new NotificationCreateException(exception);
        }
        if (this.smtpRecipients == null) {
            return;
        }
        object = WatchUtils.getToAddresses(this.smtpRecipients);
        this.getSMTPService().setSMTPRecipients((String)object);
    }

    private SMTPNotificationService getSMTPService() throws NotificationCreateException {
        if (this.smtpService == null) {
            try {
                this.smtpService = NotificationServiceFactory.getInstance().createSMTPNotificationService(this.getNotificationName(), this.mailSession, null, this.smtpSubject, this.smtpBody, (SMTPNotificationCustomizer)this);
            }
            catch (com.bea.diagnostics.notifications.NotificationCreateException notificationCreateException) {
                throw new NotificationCreateException(notificationCreateException);
            }
        }
        return this.smtpService;
    }

    public String getSubject(Notification notification) {
        return this.getDefaultSubject((WatchNotification)notification);
    }

    public String getBody(Notification notification) {
        return this.getDefaultBody((WatchNotification)notification);
    }
}

