/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.diagnostics.notifications.InvalidNotificationException;
import com.bea.diagnostics.notifications.Notification;
import com.bea.diagnostics.notifications.NotificationServiceFactory;
import com.bea.diagnostics.notifications.SNMPNotificationCustomizer;
import com.bea.diagnostics.notifications.SNMPNotificationService;
import java.util.LinkedList;
import java.util.List;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.snmp.agent.SNMPTrapException;
import weblogic.diagnostics.snmp.agent.SNMPTrapSender;
import weblogic.diagnostics.snmp.agent.SNMPTrapUtil;
import weblogic.diagnostics.type.DiagnosticRuntimeException;
import weblogic.diagnostics.watch.NotificationCreateException;
import weblogic.diagnostics.watch.WatchNotification;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.diagnostics.watch.WatchNotificationListenerCommon;

final class SNMPNotificationListener
extends WatchNotificationListenerCommon
implements WatchNotificationListener,
SNMPNotificationCustomizer {
    private static final String WATCH_NOTIFICATION_TRAP_NAME = "wlsWatchNotification";
    private SNMPNotificationService snmpService;
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");

    SNMPNotificationListener(String string) throws InvalidNotificationException, NotificationCreateException {
        super(string);
        try {
            this.snmpService = NotificationServiceFactory.getInstance().createSNMPotificationService(string, WATCH_NOTIFICATION_TRAP_NAME, null, null, (SNMPNotificationCustomizer)this);
        }
        catch (com.bea.diagnostics.notifications.NotificationCreateException notificationCreateException) {
            throw new NotificationCreateException(notificationCreateException);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created snmp notification " + this);
        }
    }

    public void processWatchNotification(Notification notification) {
        try {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Handle snmp notification for " + this);
                debugLogger.debug("Watch notification: " + notification);
            }
            if (this.snmpService != null) {
                this.snmpService.send(notification);
                this.getWatchRuntime().incrementTotalSNMPNotificationsPerformed();
            }
        }
        catch (Throwable throwable) {
            this.getWatchRuntime().incrementTotalFailedSNMPNotifications();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("SNMP trap send failed with exception ", throwable);
            }
            DiagnosticsLogger.logErrorInSNMPNotification((Throwable)throwable);
            throw new DiagnosticRuntimeException(throwable);
        }
    }

    public List processNotification(Notification notification) {
        if (notification instanceof WatchNotification) {
            WatchNotification watchNotification = (WatchNotification)notification;
            LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
            linkedList.add(new Object[]{"trapTime", watchNotification.getWatchTime()});
            linkedList.add(new Object[]{"trapDomainName", watchNotification.getWatchDomainName()});
            linkedList.add(new Object[]{"trapServerName", watchNotification.getWatchServerName()});
            linkedList.add(new Object[]{"trapWatchSeverity", watchNotification.getWatchSeverityLevel()});
            linkedList.add(new Object[]{"trapWatchName", watchNotification.getWatchName()});
            linkedList.add(new Object[]{"trapWatchRuleType", watchNotification.getWatchRuleType()});
            linkedList.add(new Object[]{"trapWatchRule", watchNotification.getWatchRule()});
            linkedList.add(new Object[]{"trapWatchData", watchNotification.getWatchDataToString()});
            linkedList.add(new Object[]{"trapWatchAlarmType", watchNotification.getWatchAlarmType()});
            linkedList.add(new Object[]{"trapWatchAlarmResetPeriod", watchNotification.getWatchAlarmResetPeriod()});
            linkedList.add(new Object[]{"trapWatchSNMPNotificationName", this.getNotificationName()});
            SNMPTrapSender sNMPTrapSender = SNMPTrapUtil.getInstance().getSNMPTrapSender();
            if (sNMPTrapSender != null) {
                try {
                    sNMPTrapSender.sendTrap(WATCH_NOTIFICATION_TRAP_NAME, linkedList);
                }
                catch (SNMPTrapException sNMPTrapException) {
                    DiagnosticsLogger.logErrorInSNMPNotification((Throwable)sNMPTrapException);
                }
            }
        }
        return null;
    }
}

