/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.adaptive.harvester.WatchedValues;
import com.bea.logging.BaseLogEntry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.InstanceNameNormalizer;
import weblogic.diagnostics.harvester.InvalidHarvesterInstanceNameException;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.i18n.DiagnosticsTextWatchTextFormatter;
import weblogic.diagnostics.logging.LogVariablesImpl;
import weblogic.diagnostics.notifications.i18n.NotificationsTextTextFormatter;
import weblogic.diagnostics.query.Query;
import weblogic.diagnostics.query.QueryFactory;
import weblogic.diagnostics.query.UnknownVariableException;
import weblogic.diagnostics.query.VariableDeclarator;
import weblogic.diagnostics.query.VariableIndexResolver;
import weblogic.diagnostics.query.VariableResolver;
import weblogic.diagnostics.watch.EventDataVariablesImpl;
import weblogic.diagnostics.watch.HarvesterVariablesImpl;
import weblogic.diagnostics.watch.HarvesterVariablesParser;
import weblogic.diagnostics.watch.InvalidWatchException;
import weblogic.diagnostics.watch.WatchConfiguration;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.diagnostics.watch.WatchNotification;
import weblogic.diagnostics.watch.WatchNotificationInternal;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.diagnostics.watch.WatchNotificationRuntimeMBeanImpl;
import weblogic.logging.LogEntry;
import weblogic.management.ManagementException;

class Watch
implements VariableIndexResolver {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private static final int STATE_ENABLED = 0;
    private static final int STATE_DISABLED = 1;
    private static final int STATE_ALARM = 2;
    private String watchName;
    private String watchRuleExpression;
    private int watchRuleType;
    private int watchSeverity;
    private String[] watchNotifications;
    private int watchAlarmType;
    private int watchAlarmResetPeriod;
    private boolean alarm = false;
    private WatchNotificationListener[] watchNotificationListeners;
    private Query watchQuery;
    private VariableDeclarator variableDeclarator;
    private VariableIndexResolver variableIndexResolver;
    private VariableResolver variableResolver;
    private int watchState;
    private long watchResetTime;
    private WatchNotificationRuntimeMBeanImpl wnRuntime;
    WatchedValues watchedValues;
    int countOfInstValuesSetLastCycle = 0;
    int countOfInstValuesSetThisCycle = 0;
    boolean containedTypeValuesInThisCycle = false;
    boolean containedTypeValuesInLastCycle = false;
    boolean isDirty = false;
    private boolean lastPerformedEvaluationResult = false;

    Watch(String string, int n, String string2, int n2, int n3, int n4, String[] stringArray, WatchNotificationListener[] watchNotificationListenerArray, WatchConfiguration watchConfiguration) throws ManagementException, InvalidWatchException {
        this.setWatchName(string);
        this.watchedValues = watchConfiguration.getWatchedValues();
        this.watchRuleType = n;
        switch (n) {
            case 1: {
                LogVariablesImpl logVariablesImpl = LogVariablesImpl.getInstance();
                this.variableDeclarator = logVariablesImpl;
                this.variableIndexResolver = logVariablesImpl;
                break;
            }
            case 2: {
                HarvesterVariablesImpl harvesterVariablesImpl = new HarvesterVariablesImpl(watchConfiguration);
                this.variableIndexResolver = this;
                this.variableResolver = harvesterVariablesImpl;
                break;
            }
            case 3: {
                EventDataVariablesImpl eventDataVariablesImpl = new EventDataVariablesImpl();
                this.variableDeclarator = eventDataVariablesImpl;
                this.variableIndexResolver = eventDataVariablesImpl;
                this.variableResolver = eventDataVariablesImpl;
                break;
            }
            default: {
                throw new InvalidWatchException("Unknown rule type " + n);
            }
        }
        this.setRuleExpression(string2);
        this.setSeverity(n2);
        this.setAlarmType(n3);
        this.setAlarmResetPeriod(n4);
        this.watchNotifications = stringArray;
        this.watchNotificationListeners = watchNotificationListenerArray;
        this.wnRuntime = (WatchNotificationRuntimeMBeanImpl)WatchManager.getInstance().getWatchNotificationRuntime();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created watch: " + this);
        }
    }

    public WatchedValues.Values addVariable(String string, String string2) throws UnknownVariableException {
        String[] stringArray = HarvesterVariablesParser.parse(string, string2);
        boolean bl = false;
        boolean bl2 = false;
        WatchedValues.Values values = null;
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        String string6 = stringArray[3];
        try {
            if (string5 != null) {
                InstanceNameNormalizer instanceNameNormalizer = new InstanceNameNormalizer(string5);
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Normalizing instance name " + string5);
                }
                string5 = instanceNameNormalizer.translateHarvesterSpec();
                bl2 = instanceNameNormalizer.isRegexPattern();
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Normalized instance name: " + string5 + ", isPattern: " + bl2);
                }
            }
            values = this.watchedValues.addMetric(string3, string4, string5, string6, bl, bl2, false, true);
        }
        catch (InvalidHarvesterInstanceNameException invalidHarvesterInstanceNameException) {
            DiagnosticsLogger.logInvalidWatchVariableInstanceNameSpecification((String)string5, (String)this.getWatchName());
            throw new UnknownVariableException(invalidHarvesterInstanceNameException.getMessage(), (Throwable)invalidHarvesterInstanceNameException);
        }
        return values;
    }

    public int getVariableIndex(String string) throws UnknownVariableException {
        WatchedValues.Values values;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Getting index for " + string);
        }
        if ((values = this.addVariable(string, this.getWatchName())) == null) {
            throw new UnknownVariableException(DiagnosticsTextWatchTextFormatter.getInstance().getUnknownWatchVariableExceptionText(this.getWatchName(), string));
        }
        int n = values.getVID();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Returning index for " + string + " idx is " + n);
        }
        return n;
    }

    String getWatchName() {
        return this.watchName;
    }

    String getRuleExpression() {
        return this.watchRuleExpression;
    }

    int getRuleType() {
        return this.watchRuleType;
    }

    int getSeverity() {
        return this.watchSeverity;
    }

    String[] getNotifications() {
        return this.watchNotifications;
    }

    int getAlarmType() {
        return this.watchAlarmType;
    }

    boolean hasAlarm() {
        return this.getAlarmType() != 0;
    }

    boolean hasAutomaticResetAlarm() {
        return this.getAlarmType() == 2;
    }

    boolean hasManualResetAlarm() {
        return this.getAlarmType() == 1;
    }

    int getAlarmResetPeriod() {
        return this.watchAlarmResetPeriod;
    }

    WatchNotificationListener[] getNotificationListeners() {
        return this.watchNotificationListeners;
    }

    boolean isEnabled() {
        return this.watchState == 0;
    }

    boolean isDisabled() {
        return this.watchState == 1;
    }

    boolean isAlarm() {
        return this.alarm;
    }

    long getResetTime() {
        return this.watchResetTime;
    }

    void setWatchName(String string) throws InvalidWatchException {
        if (string == null) {
            throw new InvalidWatchException("Name can not be null");
        }
        if (string.length() == 0) {
            throw new InvalidWatchException("Name can not be empty");
        }
        this.watchName = string;
    }

    void setRuleExpression(String string) throws InvalidWatchException {
        if (string == null) {
            throw new InvalidWatchException("Rule expression can not be null");
        }
        if ((long)string.length() == 0L) {
            throw new InvalidWatchException("Rule expression can not be empty");
        }
        try {
            this.watchQuery = QueryFactory.createQuery((VariableIndexResolver)this.variableIndexResolver, (String)string);
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Parsing of watch rule failed: ", (Throwable)exception);
            }
            throw new InvalidWatchException("Invalid watch rule expression", exception);
        }
        this.watchRuleExpression = string;
    }

    void setSeverity(int n) throws InvalidWatchException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                this.watchSeverity = n;
                break;
            }
            default: {
                throw new InvalidWatchException("Invalid severity " + n);
            }
        }
    }

    void setAlarmType(int n) throws InvalidWatchException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.watchAlarmType = n;
                break;
            }
            default: {
                throw new InvalidWatchException("Invalid alarm type " + n);
            }
        }
    }

    void setAlarmResetPeriod(int n) throws InvalidWatchException {
        if (n < 0) {
            throw new InvalidWatchException("Invalid reset period " + n);
        }
        this.watchAlarmResetPeriod = n;
    }

    void setNotifications(String[] stringArray) {
        this.watchNotifications = stringArray;
    }

    void setNotificationListeners(WatchNotificationListener[] watchNotificationListenerArray) {
        this.watchNotificationListeners = watchNotificationListenerArray;
    }

    void setEnabled() {
        this.setState(0);
    }

    void setDisabled() {
        this.setState(1);
    }

    synchronized void setAlarm(boolean bl) {
        this.alarm = bl;
    }

    void setResetTime(long l) {
        this.watchResetTime = l;
    }

    boolean evaluateHarvesterRuleWatch(boolean bl) {
        boolean bl2 = false;
        if (!bl) {
            try {
                bl2 = this.watchQuery.executeQuery(this.variableResolver);
            }
            catch (Exception exception) {
                DiagnosticsLogger.logWatchEvaluationFailed((String)this.watchName, (Throwable)exception);
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Evaluated watch " + this.watchName + " to " + bl2);
            }
        } else {
            bl2 = bl;
        }
        if (bl2) {
            this.performNotifications(this.watchQuery.getLastExecutionTrace().getEvaluatedVariables());
        }
        return bl2;
    }

    boolean evaluateLogRuleWatch(LogEntry logEntry) {
        LogVariablesImpl.LogVariablesResolver logVariablesResolver = LogVariablesImpl.getInstance().getLogVariablesResolver((BaseLogEntry)logEntry);
        boolean bl = false;
        try {
            bl = this.watchQuery.executeQuery((VariableResolver)logVariablesResolver);
        }
        catch (Exception exception) {
            DiagnosticsLogger.logWatchEvaluationFailed((String)this.watchName, (Throwable)exception);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Evaluated watch " + this.watchName + " to " + bl + " for LogEntry " + logEntry);
        }
        if (bl) {
            this.performNotifications(logVariablesResolver.getVariableData());
        }
        return bl;
    }

    boolean evaluateEventDataRuleWatch(DataRecord dataRecord) {
        EventDataVariablesImpl eventDataVariablesImpl = (EventDataVariablesImpl)this.variableResolver;
        eventDataVariablesImpl.setDataRecord(dataRecord);
        boolean bl = false;
        try {
            bl = this.watchQuery.executeQuery(this.variableResolver);
        }
        catch (Exception exception) {
            DiagnosticsLogger.logWatchEvaluationFailed((String)this.watchName, (Throwable)exception);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Evaluated watch " + this.watchName + " to " + bl);
        }
        if (bl) {
            this.performNotifications(eventDataVariablesImpl.getWatchData());
        }
        return bl;
    }

    private void performNotifications(Map map) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Performing notification for watch: " + this.watchName);
        }
        try {
            WatchNotificationInternal watchNotificationInternal = new WatchNotificationInternal(this, System.currentTimeMillis(), map);
            DiagnosticsLogger.logWatchEvaluatedToTrue((String)watchNotificationInternal.getWatchName(), (String)watchNotificationInternal.getWatchSeverityLevel(), (String)watchNotificationInternal.getWatchServerName(), (String)watchNotificationInternal.getWatchTime(), (String)this.recordWatchNotificationDetails(watchNotificationInternal));
            if (this.watchNotificationListeners == null || this.watchNotificationListeners.length == 0) {
                return;
            }
            for (int i = 0; i < this.watchNotificationListeners.length; ++i) {
                try {
                    if (this.watchNotificationListeners[i].isDisabled()) continue;
                    this.watchNotificationListeners[i].processWatchNotification(watchNotificationInternal);
                    continue;
                }
                catch (Exception exception) {
                    DiagnosticsLogger.logNotificationError((String)this.watchName, (String)this.watchNotifications[i], (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            DiagnosticsLogger.logWatchNotificationError((String)this.watchName, (Throwable)exception);
        }
    }

    private String recordWatchNotificationDetails(WatchNotification watchNotification) {
        StringWriter stringWriter;
        block2: {
            NotificationsTextTextFormatter notificationsTextTextFormatter = NotificationsTextTextFormatter.getInstance();
            stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            try {
                bufferedWriter.newLine();
                bufferedWriter.write(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchRuleType", watchNotification.getWatchRuleType()));
                bufferedWriter.write(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchRule", this.escapeComparisonOperators(watchNotification.getWatchRule())));
                bufferedWriter.write(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchData", watchNotification.getWatchDataToString()));
                bufferedWriter.write(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchAlarmType", watchNotification.getWatchAlarmType()));
                bufferedWriter.write(notificationsTextTextFormatter.getSMTPDefaultBodyLine("WatchAlarmResetPeriod", watchNotification.getWatchAlarmResetPeriod()));
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                if (!debugLogger.isDebugEnabled()) break block2;
                debugLogger.debug("Caught IOException building WatchNotification details string", (Throwable)iOException);
            }
        }
        return stringWriter.toString();
    }

    private String escapeComparisonOperators(String string) {
        return string.replaceAll("> ", ">");
    }

    private void setState(int n) {
        this.watchState = n;
    }

    boolean isModified() {
        return this.isDirty;
    }

    void initTypeValue(String string, boolean bl, Object object, Object object2) {
        this.containedTypeValuesInThisCycle = true;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Marking watch " + this.getWatchName() + " modified " + "because a type-based metric is set (" + string + ").");
        }
        this.isDirty = true;
    }

    void newInstanceValue(String string, boolean bl, Object object, Object object2) {
        ++this.countOfInstValuesSetThisCycle;
        if (!this.isDirty) {
            if (bl) {
                --this.countOfInstValuesSetLastCycle;
                if (object != null) {
                    if (!object.equals(object2)) {
                        if (debugLogger.isDebugEnabled()) {
                            debugLogger.debug("Marking watch " + this.getWatchName() + " modified because the value of variable " + string + " has changed: " + object + " ---> " + object2);
                        }
                        this.isDirty = true;
                    } else if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("The newly set value of variable " + string + " in watch " + this.getWatchName() + "(" + object2 + ") is unchanged from " + "the previous value.");
                    }
                } else if (object2 != null) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Marking watch " + this.getWatchName() + " modified because the value of variable " + string + " has changed: " + object + " ---> " + object2);
                    }
                    this.isDirty = true;
                } else if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("The newly set value of variable " + string + " in watch " + this.getWatchName() + "(" + object2 + ") is unchanged from " + "the previous value.");
                }
            } else {
                debugLogger.debug("Marking watch " + this.getWatchName() + " modified because this is the first time " + " variable " + string + "has been set since " + "the latest WLDF config was loaded. ");
                this.isDirty = true;
            }
        }
    }

    boolean finalizeCollectionCycle() {
        if (!this.isDirty) {
            this.isDirty = this.countOfInstValuesSetLastCycle != 0 || this.containedTypeValuesInLastCycle || this.containedTypeValuesInThisCycle;
        }
        return this.isDirty;
    }

    void resetCollectionData() {
        this.resetCollectionData(false);
    }

    void resetCollectionData(boolean bl) {
        this.isDirty = bl;
        this.countOfInstValuesSetLastCycle = this.countOfInstValuesSetThisCycle;
        this.countOfInstValuesSetThisCycle = 0;
        this.containedTypeValuesInLastCycle = this.containedTypeValuesInThisCycle;
        this.containedTypeValuesInThisCycle = false;
    }

    boolean getLastPerformedEvaluationResult() {
        return this.lastPerformedEvaluationResult;
    }

    void setLastPerformedEvaluationResult(boolean bl) {
        this.lastPerformedEvaluationResult = bl;
    }

    public String toString() {
        String string = "Watch: " + this.watchName + " rule: " + this.watchRuleExpression + " ruleType: " + this.watchRuleType + " severity: " + this.watchSeverity + " alarmType: " + this.watchAlarmType + " alarmReset: " + this.watchAlarmResetPeriod + " state: " + this.watchState + " notifications: ";
        for (int i = 0; this.watchNotifications != null && i < this.watchNotifications.length; ++i) {
            string = string + " " + this.watchNotifications[i];
        }
        return string;
    }
}

