/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.adaptive.harvester.WatchedValues;
import com.bea.diagnostics.notifications.InvalidNotificationException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.watch.InvalidWatchException;
import weblogic.diagnostics.watch.JMXNotificationProducer;
import weblogic.diagnostics.watch.NotificationAlreadyDisabledException;
import weblogic.diagnostics.watch.NotificationAlreadyEnabledException;
import weblogic.diagnostics.watch.NotificationInUseException;
import weblogic.diagnostics.watch.NotificationNotFoundException;
import weblogic.diagnostics.watch.Watch;
import weblogic.diagnostics.watch.WatchNotFoundException;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.logging.Severities;

public final class WatchConfiguration {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private Map<String, WatchNotificationListener> enabledNotifications = new Hashtable<String, WatchNotificationListener>();
    private Map<String, WatchNotificationListener> disabledNotifications = new Hashtable<String, WatchNotificationListener>();
    private Map<String, Watch> allWatches = new Hashtable<String, Watch>();
    private ArrayList<Watch> enabledHarvesterWatches = new ArrayList();
    private ArrayList<Watch> enabledLogWatches = new ArrayList();
    private ArrayList<Watch> enabledEventDataWatches = new ArrayList();
    private int logEventHandlerSeverity = 16;
    private WatchedValues watchedValues;
    private boolean watchNotificationEnabled = true;
    JMXNotificationProducer notificationProducer = null;

    public WatchConfiguration(WatchedValues watchedValues) {
        this.watchedValues = watchedValues;
    }

    WatchConfiguration() {
    }

    boolean isWatchNotificationEnabled() {
        return this.watchNotificationEnabled;
    }

    void setJMXNotificationProducer(JMXNotificationProducer jMXNotificationProducer) {
        this.notificationProducer = jMXNotificationProducer;
    }

    void setWatchNotificationEnabled(boolean bl) {
        this.watchNotificationEnabled = bl;
    }

    public void addWatch(Watch watch) {
        if (watch == null) {
            throw new InvalidWatchException("Watch can not be null");
        }
        String string = watch.getWatchName();
        if (string == null) {
            throw new InvalidWatchException("Watch name can not be null");
        }
        Watch watch2 = this.allWatches.get(string);
        if (watch2 != null) {
            DiagnosticsLogger.logDuplicateWatch((String)string);
            return;
        }
        this.allWatches.put(string, watch);
        if (watch.isEnabled()) {
            this.addEnabledWatch(watch);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Added watch " + string);
        }
    }

    public Watch getWatch(String string) throws WatchNotFoundException {
        if (string == null) {
            throw new WatchNotFoundException("Watch name can not be null");
        }
        Watch watch = this.allWatches.get(string);
        if (watch != null) {
            return watch;
        }
        throw new WatchNotFoundException("Watch " + string + " is not a registered watch");
    }

    public boolean isWatchEnabled(String string) throws WatchNotFoundException {
        Watch watch = this.getWatch(string);
        return watch.isEnabled();
    }

    public boolean isWatchDisabled(String string) throws WatchNotFoundException {
        Watch watch = this.getWatch(string);
        return watch.isDisabled();
    }

    public boolean isWatchAlarmActive(String string) throws WatchNotFoundException {
        Watch watch = this.getWatch(string);
        return watch.isAlarm();
    }

    public Watch[] getWatches() {
        Watch[] watchArray = new Watch[this.allWatches.size()];
        this.allWatches.values().toArray(watchArray);
        return watchArray;
    }

    public ArrayList getEnabledHarvesterWatches() {
        return this.enabledHarvesterWatches;
    }

    public ArrayList getEnabledLogWatches() {
        return this.enabledLogWatches;
    }

    public ArrayList getEnabledEventDataWatches() {
        return this.enabledEventDataWatches;
    }

    private synchronized void addEnabledWatch(Watch watch) {
        watch.setEnabled();
        switch (watch.getRuleType()) {
            case 2: {
                this.enabledHarvesterWatches.add(watch);
                break;
            }
            case 1: {
                this.enabledLogWatches.add(watch);
                break;
            }
            case 3: {
                this.enabledEventDataWatches.add(watch);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown rule type" + watch.getRuleType()));
            }
        }
    }

    public void addNotificationListener(WatchNotificationListener watchNotificationListener) {
        if (watchNotificationListener == null) {
            throw new InvalidNotificationException("Notification can not be null");
        }
        String string = watchNotificationListener.getNotificationName();
        if (string == null) {
            throw new InvalidNotificationException("Notification name can not be null");
        }
        WatchNotificationListener watchNotificationListener2 = this.enabledNotifications.get(string);
        if (watchNotificationListener2 == null) {
            watchNotificationListener2 = this.disabledNotifications.get(string);
        }
        if (watchNotificationListener2 != null) {
            DiagnosticsLogger.logDuplicateNotification((String)watchNotificationListener.getNotificationName());
            return;
        }
        if (watchNotificationListener.isEnabled()) {
            this.enabledNotifications.put(string, watchNotificationListener);
        } else {
            this.disabledNotifications.put(string, watchNotificationListener);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Added notification " + watchNotificationListener);
        }
    }

    public synchronized void removeNotification(String string) throws NotificationNotFoundException, NotificationInUseException {
        WatchNotificationListener watchNotificationListener = this.getNotification(string);
        if (watchNotificationListener.isEnabled()) {
            this.enabledNotifications.remove(string);
        } else {
            this.disabledNotifications.remove(string);
        }
        Watch[] watchArray = this.getWatches();
        for (int i = 0; watchArray != null && i < watchArray.length; ++i) {
            String[] stringArray = watchArray[i].getNotifications();
            for (int j = 0; stringArray != null && j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                throw new NotificationInUseException("Notification " + string + " can not be deleted as it is used by watch " + watchArray[i].getWatchName() + ". Remove the notification from the watch.");
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Removed notification " + string);
        }
    }

    public synchronized WatchNotificationListener getNotification(String string) throws NotificationNotFoundException {
        if (string == null) {
            throw new NotificationNotFoundException("Notification name can not be null");
        }
        WatchNotificationListener watchNotificationListener = this.enabledNotifications.get(string);
        if (watchNotificationListener == null) {
            watchNotificationListener = this.disabledNotifications.get(string);
        }
        if (watchNotificationListener == null) {
            throw new NotificationNotFoundException("Notification " + string + " has is not a registered notification");
        }
        return watchNotificationListener;
    }

    void enableNotification(String string) throws NotificationNotFoundException, NotificationAlreadyEnabledException {
        WatchNotificationListener watchNotificationListener = this.getNotification(string);
        if (watchNotificationListener.isEnabled()) {
            throw new NotificationAlreadyEnabledException("Notification " + string + " is already enabled");
        }
        this.disabledNotifications.remove(string);
        watchNotificationListener.setEnabled();
        this.enabledNotifications.put(string, watchNotificationListener);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Enabled notification " + string);
        }
    }

    void disableNotification(String string) throws NotificationNotFoundException, NotificationAlreadyDisabledException {
        WatchNotificationListener watchNotificationListener = this.getNotification(string);
        if (watchNotificationListener.isDisabled()) {
            throw new NotificationAlreadyDisabledException("Notification " + string + " is already disabled");
        }
        this.enabledNotifications.remove(string);
        watchNotificationListener.setDisabled();
        this.disabledNotifications.put(string, watchNotificationListener);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Disabled notification " + string);
        }
    }

    public boolean isNotificationEnabled(String string) throws NotificationNotFoundException {
        WatchNotificationListener watchNotificationListener = this.getNotification(string);
        return watchNotificationListener.isEnabled();
    }

    public boolean isNotificationDisabled(String string) throws NotificationNotFoundException {
        WatchNotificationListener watchNotificationListener = this.getNotification(string);
        return watchNotificationListener.isDisabled();
    }

    public WatchNotificationListener[] getNotifications() {
        int n = this.enabledNotifications.size() + this.disabledNotifications.size();
        WatchNotificationListener[] watchNotificationListenerArray = new WatchNotificationListener[n];
        WatchNotificationListener[] watchNotificationListenerArray2 = new WatchNotificationListener[this.disabledNotifications.size()];
        this.enabledNotifications.values().toArray(watchNotificationListenerArray);
        System.arraycopy(this.disabledNotifications.values().toArray(watchNotificationListenerArray2), 0, watchNotificationListenerArray, this.enabledNotifications.size(), this.disabledNotifications.size());
        return watchNotificationListenerArray;
    }

    public WatchNotificationListener[] getEnabledNotifications() {
        WatchNotificationListener[] watchNotificationListenerArray = new WatchNotificationListener[this.enabledNotifications.size()];
        this.enabledNotifications.values().toArray(watchNotificationListenerArray);
        return watchNotificationListenerArray;
    }

    public WatchNotificationListener[] getDisabledNotifications() {
        WatchNotificationListener[] watchNotificationListenerArray = new WatchNotificationListener[this.disabledNotifications.size()];
        this.disabledNotifications.values().toArray(watchNotificationListenerArray);
        return watchNotificationListenerArray;
    }

    public int getEventHandlerSeverity() {
        return this.logEventHandlerSeverity;
    }

    public void initializeLogEventHandlerSeverity(String string) {
        this.logEventHandlerSeverity = Severities.severityStringToNum((String)string);
    }

    WatchedValues getWatchedValues() {
        return this.watchedValues;
    }
}

