/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.logging.WLErrorManager;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogger;

public class WatchLogHandler
extends Handler {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private WatchManager watchManager;

    WatchLogHandler(WatchManager watchManager, int n) {
        this.watchManager = watchManager;
        this.setErrorManager(new WLErrorManager(this));
        this.setLevel(WLLevel.getLevel((int)n));
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Set Watch log handler with severity " + n);
        }
    }

    public void close() {
    }

    public void flush() {
    }

    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        this.watchManager.evaluateLogEventRules(WLLogger.normalizeLogRecord(logRecord));
    }
}

