/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Handler;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.watch.WatchLogHandler;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.logging.JDKLoggerFactory;
import weblogic.logging.LoggingHelper;

final class WatchLogService {
    private static Object logHandler = null;

    WatchLogService() {
    }

    static void registerToServerLogger(WatchManager watchManager, int n) {
        if (JDKLoggerFactory.isLog4jEnabled()) {
            try {
                Class<?> clazz = Class.forName("weblogic.logging.log4j.Log4jLoggingHelper", true, Thread.currentThread().getContextClassLoader());
                Method method = clazz.getMethod("getLog4jServerLogger", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Class<?> clazz2 = Class.forName("org.apache.log4j.Logger", true, Thread.currentThread().getContextClassLoader());
                Class<?> clazz3 = Class.forName("weblogic.diagnostics.watch.WatchLogAppender", true, Thread.currentThread().getContextClassLoader());
                Constructor<?> constructor = clazz3.getConstructor(clazz2, WatchManager.class, Integer.TYPE);
                Object obj = constructor.newInstance(object, watchManager, new Integer(n));
                Method method2 = clazz2.getMethod("addAppender", Class.forName("org.apache.log4j.Appender", true, Thread.currentThread().getContextClassLoader()));
                method2.invoke(object, obj);
                logHandler = obj;
                return;
            }
            catch (Exception exception) {
                DiagnosticsLogger.logWatchErrorInvokingLog4j((Throwable)exception);
            }
        } else {
            logHandler = new WatchLogHandler(watchManager, n);
            LoggingHelper.getServerLogger().addHandler((Handler)logHandler);
        }
    }

    static void deregisterFromServerLogger() {
        if (logHandler == null) {
            return;
        }
        if (JDKLoggerFactory.isLog4jEnabled()) {
            try {
                Class<?> clazz = Class.forName("weblogic.logging.log4j.Log4jLoggingHelper", true, Thread.currentThread().getContextClassLoader());
                Method method = clazz.getMethod("getLog4jServerLogger", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Class<?> clazz2 = Class.forName("org.apache.log4j.Logger", true, Thread.currentThread().getContextClassLoader());
                Method method2 = clazz2.getMethod("removeAppender", Class.forName("org.apache.log4j.Appender", true, Thread.currentThread().getContextClassLoader()));
                method2.invoke(object, logHandler);
            }
            catch (Exception exception) {
                DiagnosticsLogger.logWatchErrorInvokingLog4j((Throwable)exception);
            }
        } else {
            LoggingHelper.getServerLogger().removeHandler((Handler)logHandler);
        }
    }
}

