/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.adaptive.harvester.HarvestCallback;
import com.bea.adaptive.harvester.WatchedValues;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.HarvesterInternalAccess;
import weblogic.diagnostics.harvester.WLDFToHarvester;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.instrumentation.InstrumentationEventListener;
import weblogic.diagnostics.instrumentation.InstrumentationManager;
import weblogic.diagnostics.module.SubModuleRegistry;
import weblogic.diagnostics.module.WLDFModuleException;
import weblogic.diagnostics.module.WLDFSubModule;
import weblogic.diagnostics.watch.ImageNotificationListener;
import weblogic.diagnostics.watch.Watch;
import weblogic.diagnostics.watch.WatchConfiguration;
import weblogic.diagnostics.watch.WatchLogService;
import weblogic.diagnostics.watch.WatchNotActiveAlarmException;
import weblogic.diagnostics.watch.WatchNotFoundException;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.diagnostics.watch.WatchNotificationRuntimeMBeanImpl;
import weblogic.diagnostics.watch.WatchSource;
import weblogic.diagnostics.watch.WatchSubModule;
import weblogic.logging.LogEntry;
import weblogic.management.ManagementException;
import weblogic.management.runtime.WLDFWatchNotificationRuntimeMBean;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.collections.CircularQueue;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class WatchManager
implements TimerListener,
HarvestCallback,
Runnable,
InstrumentationEventListener {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private static WatchManager watchManager = null;
    private WatchConfiguration watchConfig = null;
    private Map<String, Watch> alarmWatches = new Hashtable<String, Watch>();
    private WatchNotificationRuntimeMBeanImpl wnRuntime;
    private TimerManagerFactory timerManagerFactory;
    private TimerManager timerManager;
    private Timer alarmResetTimer;
    private static final String WORK_MANAGER_NAME = "WatchManagerEvents";
    private static final int MAX_THREADS = 1;
    private Thread asyncLogThread;
    private CircularQueue eventQueue = new CircularQueue();
    private WorkManager workManager;
    private WLDFSubModule watchSubModule = null;
    private WLDFToHarvester wldf2Hv;
    private int wvid;
    private int numActiveImageNotifications;

    private WatchManager() throws ManagementException {
        this.wnRuntime = WatchNotificationRuntimeMBeanImpl.getInstance();
        ImageManager imageManager = ImageManager.getInstance();
        imageManager.registerImageSource("WatchSource", new WatchSource());
        this.workManager = WorkManagerFactory.getInstance().findOrCreate(WORK_MANAGER_NAME, 1, 1);
        this.wldf2Hv = HarvesterInternalAccess.getInstance();
    }

    public static synchronized WatchManager getInstance() throws ManagementException {
        if (watchManager == null) {
            watchManager = new WatchManager();
        }
        return watchManager;
    }

    public synchronized void moduleActivated(WatchConfiguration watchConfiguration) throws WLDFModuleException {
        this.watchConfig = watchConfiguration;
        this.identifyActiveImageNotifications();
        this.initializeEventListener();
        this.initializeLogEventHandler();
        this.activateConfiguration();
    }

    private void identifyActiveImageNotifications() {
        for (Watch watch : this.watchConfig.getWatches()) {
            WatchNotificationListener[] watchNotificationListenerArray = watch.getNotificationListeners();
            if (watchNotificationListenerArray == null) continue;
            for (WatchNotificationListener watchNotificationListener : watchNotificationListenerArray) {
                if (!(watchNotificationListener instanceof ImageNotificationListener)) continue;
                ++this.numActiveImageNotifications;
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Number of active Diagnostic Image listeners: " + this.numActiveImageNotifications);
        }
    }

    public int getNumActiveImageNotifications() {
        return this.numActiveImageNotifications;
    }

    public synchronized void moduleDeactivated() {
        this.watchConfig = null;
        this.deinitializeEventListener();
        this.deinitializeLogEventHandler();
    }

    public void activateConfiguration() {
        if (this.watchConfig != null && this.watchConfig.isWatchNotificationEnabled()) {
            if (this.wldf2Hv.isActivated()) {
                WatchedValues watchedValues;
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Activating WatchedNotification Configuration.");
                }
                if ((watchedValues = this.watchConfig.getWatchedValues()) == null) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("No watched metrics configured.");
                    }
                } else if (watchedValues.getId() > -1) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Watched Values already appears initialized, value: " + watchedValues.getId());
                    }
                } else if (watchedValues.getAllMetricValues().size() > 0) {
                    this.wvid = this.wldf2Hv.addWatchedValues(watchedValues);
                } else if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("No watched metrics configured.");
                }
            } else {
                debugLogger.debug("Watch activation deferred, harvester is not yet activated");
            }
        } else if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Watch not enabled in configuration, no watched values registered with harvester.");
        }
    }

    synchronized WatchConfiguration getWatchConfiguration() {
        return this.watchConfig;
    }

    public WLDFWatchNotificationRuntimeMBean getWatchNotificationRuntime() {
        return this.wnRuntime;
    }

    public WLDFSubModule getWatchSubModule() {
        if (this.watchSubModule == null) {
            WLDFSubModule[] wLDFSubModuleArray = SubModuleRegistry.getWLDFSubModules();
            for (int i = 0; i < wLDFSubModuleArray.length; ++i) {
                if (!WatchSubModule.class.isAssignableFrom(SubModuleRegistry.getWLDFSubModuleType(wLDFSubModuleArray[i]))) continue;
                this.watchSubModule = wLDFSubModuleArray[i];
                break;
            }
        }
        return this.watchSubModule;
    }

    public void newDataHarvested() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateHarvesterRules() {
        this.wnRuntime.incrementTotalHarvesterEvaluationCycles();
        WatchConfiguration watchConfiguration = this.getWatchConfiguration();
        if (watchConfiguration == null || !watchConfiguration.isWatchNotificationEnabled()) {
            return;
        }
        ArrayList arrayList = watchConfiguration.getEnabledHarvesterWatches();
        if (arrayList.isEmpty()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("No harvester rules configured");
            }
            this.updateWatchNotificationRuntime();
            return;
        }
        boolean bl = false;
        long l = System.nanoTime();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Evaluating harvester watch rules ");
            WatchedValues watchedValues = this.watchConfig.getWatchedValues();
            debugLogger.debug(watchedValues.dump("", true, false, true));
        }
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            boolean bl2;
            boolean bl3;
            Watch watch = (Watch)arrayList.get(i);
            if (watch.isAlarm()) {
                watch.resetCollectionData(true);
                continue;
            }
            ++n;
            boolean bl4 = bl3 = this.getWatchConfiguration().getWatchedValues().getMostRecentValuesCount() > 0L;
            if (!bl3) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Values are unchanged for watch " + watch.getWatchName() + ". " + "Using previous evaluation result: " + watch.getLastPerformedEvaluationResult());
                }
                if (bl2 = watch.getLastPerformedEvaluationResult()) {
                    watch.evaluateHarvesterRuleWatch(true);
                }
            } else {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Evaluating watch " + watch);
                }
                if (watch.evaluateHarvesterRuleWatch(false)) {
                    bl2 = true;
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Evaluated watch to true " + watch.getWatchName());
                    }
                } else {
                    bl2 = false;
                }
                watch.setLastPerformedEvaluationResult(bl2);
            }
            watch.resetCollectionData();
            if (!bl2) continue;
            this.wnRuntime.incrementTotalHarvesterWatchesTriggered();
            if (!watch.hasAlarm()) continue;
            WatchManager watchManager = this;
            synchronized (watchManager) {
                bl = this.setAlarm(watch);
                continue;
            }
        }
        if (n > 0) {
            this.wnRuntime.incrementTotalHarvesterWatchEvaluations(n);
        }
        if (bl) {
            this.resetAlarmTimer();
        }
        long l2 = System.nanoTime() - l;
        this.wnRuntime.incrementTotalHarvesterWatchEvaluationTime(l2 * 1000000L);
        this.updateWatchNotificationRuntime();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Finished evaluating harvester watch rules in " + l2 + " nanos");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateLogEventRules(LogEntry logEntry) {
        WatchConfiguration watchConfiguration = this.getWatchConfiguration();
        if (watchConfiguration == null || !watchConfiguration.isWatchNotificationEnabled()) {
            return;
        }
        if (logEntry.getSeverity() == 128) {
            return;
        }
        this.wnRuntime.incrementTotalLogEvaluationCycles();
        ArrayList arrayList = watchConfiguration.getEnabledLogWatches();
        if (arrayList.isEmpty()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("No log rules configured");
            }
            return;
        }
        CircularQueue circularQueue = this.eventQueue;
        synchronized (circularQueue) {
            if (this.asyncLogThread != null && Thread.currentThread().equals(this.asyncLogThread)) {
                return;
            }
            this.eventQueue.add((Object)logEntry);
            if (this.eventQueue.size() > 1) {
                return;
            }
        }
        this.workManager.schedule((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInstrumentationEvent(DataRecord dataRecord) {
        this.wnRuntime.incrementTotalEventDataEvaluationCycles();
        WatchConfiguration watchConfiguration = this.getWatchConfiguration();
        if (watchConfiguration == null || !watchConfiguration.isWatchNotificationEnabled()) {
            return;
        }
        ArrayList arrayList = watchConfiguration.getEnabledEventDataWatches();
        if (arrayList.isEmpty()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("No event data rules configured");
            }
            return;
        }
        CircularQueue circularQueue = this.eventQueue;
        synchronized (circularQueue) {
            this.eventQueue.add((Object)dataRecord);
            if (this.eventQueue.size() > 1) {
                return;
            }
        }
        this.workManager.schedule((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (true) {
            CircularQueue circularQueue = this.eventQueue;
            synchronized (circularQueue) {
                this.asyncLogThread = null;
                if (this.eventQueue.isEmpty()) {
                    return;
                }
                object = this.eventQueue.remove();
                if (object instanceof LogEntry) {
                    this.asyncLogThread = Thread.currentThread();
                }
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Executing event " + object);
            }
            if (object instanceof LogEntry) {
                this.evaluateLogEventRulesAsync((LogEntry)object);
                continue;
            }
            if (!(object instanceof DataRecord)) break;
            this.evaluateEventDataRulesAsync((DataRecord)object);
        }
        throw new AssertionError((Object)("Unknown event work" + object));
    }

    public Watch[] getActiveAlarmWatches() {
        Watch[] watchArray = new Watch[this.alarmWatches.size()];
        this.alarmWatches.values().toArray(watchArray);
        return watchArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        try {
            long l = System.currentTimeMillis();
            Map<String, Watch> map = this.alarmWatches;
            synchronized (map) {
                Iterator<Map.Entry<String, Watch>> iterator = this.alarmWatches.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Watch> entry = iterator.next();
                    Watch watch = entry.getValue();
                    if (watch.getAlarmType() != 2 || watch.getResetTime() > l) continue;
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Reset watch " + watch.getWatchName());
                    }
                    iterator.remove();
                    watch.setAlarm(false);
                }
                this.alarmResetTimer = null;
            }
        }
        catch (Exception exception) {
            DiagnosticsLogger.logUnexpectedException((String)("" + timer), (Throwable)exception);
        }
        finally {
            this.resetAlarmTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetWatchAlarm(String string) throws WatchNotFoundException, WatchNotActiveAlarmException {
        WatchConfiguration watchConfiguration = this.getWatchConfiguration();
        if (watchConfiguration == null) {
            return;
        }
        Watch watch = watchConfiguration.getWatch(string);
        if (!watch.isAlarm()) {
            throw new WatchNotActiveAlarmException("Watch " + string + " is not an active alarm");
        }
        Map<String, Watch> map = this.alarmWatches;
        synchronized (map) {
            this.alarmWatches.remove(string);
        }
        watch.setAlarm(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setAlarm(Watch watch) {
        boolean bl = false;
        if (watch.getAlarmType() == 0) {
            return false;
        }
        watch.setAlarm(true);
        if (watch.getAlarmType() == 2) {
            watch.setResetTime(System.currentTimeMillis() + (long)watch.getAlarmResetPeriod());
            bl = true;
            this.wnRuntime.incrementTotalActiveAutomaticResetAlarms();
        } else {
            this.wnRuntime.incrementTotalActiveManualResetAlarms();
        }
        Map<String, Watch> map = this.alarmWatches;
        synchronized (map) {
            this.alarmWatches.put(watch.getWatchName(), watch);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAlarmTimer() {
        if (this.timerManager == null) {
            this.timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
            this.timerManager = this.timerManagerFactory.getDefaultTimerManager();
        }
        Map<String, Watch> map = this.alarmWatches;
        synchronized (map) {
            long l = 0L;
            for (Watch watch : this.alarmWatches.values()) {
                long l2;
                if (watch.getAlarmType() != 2 || (l2 = watch.getResetTime()) >= l && l != 0L) continue;
                l = l2;
            }
            if (l > 0L) {
                long l3;
                if (this.alarmResetTimer != null) {
                    boolean bl = this.alarmResetTimer.cancel();
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Canceled timer with result " + bl);
                    }
                }
                if ((l3 = l - System.currentTimeMillis()) < 0L) {
                    l3 = 0L;
                }
                this.alarmResetTimer = this.timerManager.schedule((TimerListener)this, l3);
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Scheduled timer for delay of " + l3);
                }
            } else {
                this.alarmResetTimer = null;
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("No timer scheduled");
                }
            }
        }
    }

    private void initializeEventListener() {
        InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
        instrumentationManager.removeInstrumentationEventListener(this);
        instrumentationManager.addInstrumentationEventListener(this);
    }

    private void initializeLogEventHandler() {
        WatchLogService.deregisterFromServerLogger();
        WatchLogService.registerToServerLogger(this, this.watchConfig.getEventHandlerSeverity());
    }

    private void deinitializeEventListener() {
        InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
        instrumentationManager.removeInstrumentationEventListener(this);
    }

    private void deinitializeLogEventHandler() {
        WatchLogService.deregisterFromServerLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateLogEventRulesAsync(LogEntry logEntry) {
        WatchConfiguration watchConfiguration;
        boolean bl = false;
        long l = System.currentTimeMillis();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Evaluating log watch rules in separate thread ");
        }
        if ((watchConfiguration = this.getWatchConfiguration()) == null) {
            return;
        }
        ArrayList arrayList = watchConfiguration.getEnabledLogWatches();
        int n = 0;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Evaluating " + arrayList.size() + " watches");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Watch watch = (Watch)arrayList.get(i);
            if (watch.isAlarm()) continue;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Evaluating watch " + watch);
            }
            ++n;
            if (!watch.evaluateLogRuleWatch(logEntry)) continue;
            this.wnRuntime.incrementTotalLogWatchesTriggered();
            if (!watch.hasAlarm()) continue;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Handling alarm for watch " + watch.getWatchName());
            }
            WatchManager watchManager = this;
            synchronized (watchManager) {
                bl = this.setAlarm(watch);
                continue;
            }
        }
        this.wnRuntime.incrementTotalLogWatchEvaluations(n);
        if (bl) {
            this.resetAlarmTimer();
        }
        long l2 = System.currentTimeMillis() - l;
        this.wnRuntime.incrementTotalLogWatchEvaluationTime(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateEventDataRulesAsync(DataRecord dataRecord) {
        WatchConfiguration watchConfiguration;
        long l = System.currentTimeMillis();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Evaluating event data watch rules in separate thread ");
        }
        if ((watchConfiguration = this.getWatchConfiguration()) == null) {
            return;
        }
        ArrayList arrayList = watchConfiguration.getEnabledEventDataWatches();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            Watch watch = (Watch)arrayList.get(i);
            if (watch.isAlarm()) continue;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Evaluating watch " + watch);
            }
            ++n;
            if (!watch.evaluateEventDataRuleWatch(dataRecord)) continue;
            this.wnRuntime.incrementTotalEventDataWatchesTriggered();
            if (!watch.hasAlarm()) continue;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Handling alarm for watch " + watch.getWatchName());
            }
            WatchManager watchManager = this;
            synchronized (watchManager) {
                bl = this.setAlarm(watch);
                continue;
            }
        }
        this.wnRuntime.incrementTotalEventDataWatchEvaluations(n);
        if (bl) {
            this.resetAlarmTimer();
        }
        long l2 = System.currentTimeMillis() - l;
        this.wnRuntime.incrementTotalEventDataWatchEvaluationTime(l2);
    }

    private void updateWatchNotificationRuntime() {
        int n = this.alarmWatches.size();
        this.wnRuntime.setCurrentActiveAlarmsCount(n);
    }
}

