/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.diagnostics.notifications.Notification;
import com.bea.diagnostics.notifications.NotificationSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.diagnostics.watch.NotificationCreateException;
import weblogic.diagnostics.watch.Watch;
import weblogic.diagnostics.watch.WatchNotification;
import weblogic.diagnostics.watch.WatchUtils;

public class WatchNotificationInternal
extends WatchNotification
implements Notification {
    static final long serialVersionUID = -2415851253529341071L;
    private static transient ArrayList<Object> watchKeySet;
    private transient Map<Object, Object> dataMap;
    private transient WatchNotificationSourceImpl source;
    private transient long watchTimeMillis;

    WatchNotificationInternal(Watch watch, long l, Map map) throws NotificationCreateException {
        if (watch == null) {
            throw new NotificationCreateException("Watch can not be null");
        }
        this.watchTimeMillis = l;
        this.dataMap = new HashMap<Object, Object>();
        this.source = new WatchNotificationSourceImpl(watch.getWatchName());
        super.setWatchData(map);
        super.setWatchDataString(WatchUtils.getWatchDataString(map));
        WatchUtils.setWatchTimeInDateFormat(this, l);
        WatchUtils.populateFromWatch(this, watch);
    }

    WatchNotification createWatchNotificationExternal() {
        WatchNotification watchNotification = new WatchNotification();
        watchNotification.setMessage(this.getMessage());
        watchNotification.setWatchAlarmResetPeriod(this.getWatchAlarmResetPeriod());
        watchNotification.setWatchAlarmType(this.getWatchAlarmType());
        watchNotification.setWatchDataString(this.getWatchDataToString());
        watchNotification.setWatchDomainName(this.getWatchDomainName());
        watchNotification.setWatchName(this.getWatchName());
        watchNotification.setWatchRule(this.getWatchRule());
        watchNotification.setWatchRuleType(this.getWatchRuleType());
        watchNotification.setWatchServerName(this.getWatchServerName());
        watchNotification.setWatchSeverityLevel(this.getWatchSeverityLevel());
        watchNotification.setWatchTime(this.getWatchTime());
        watchNotification.setWatchData(this.getWatchData());
        return watchNotification;
    }

    public NotificationSource getSource() {
        return this.source;
    }

    public void setSource(NotificationSource notificationSource) {
        throw new UnsupportedOperationException();
    }

    public Object getValue(Object object) {
        return this.dataMap.get(object);
    }

    public void setValue(Object object, Object object2) {
        this.dataMap.put(object, object2);
    }

    protected Map getData() {
        return this.dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List keyList() {
        WatchNotificationInternal watchNotificationInternal = this;
        synchronized (watchNotificationInternal) {
            if (watchKeySet == null) {
                watchKeySet = new ArrayList(10);
                watchKeySet.add("WatchName");
                watchKeySet.add("WatchDomainName");
                watchKeySet.add("WatchServerName");
                watchKeySet.add("WatchRuleType");
                watchKeySet.add("WatchRule");
                watchKeySet.add("WatchTime");
                watchKeySet.add("WatchSeverityLevel");
                watchKeySet.add("WatchData");
                watchKeySet.add("WatchAlarmType");
                watchKeySet.add("WatchAlarmResetPeriod");
            }
        }
        return watchKeySet;
    }

    protected long getWatchTimeMillis() {
        return this.watchTimeMillis;
    }

    private static class WatchNotificationSourceImpl
    implements NotificationSource {
        static final long serialVersionUID = 8733358832295734061L;
        private String watchName;

        public WatchNotificationSourceImpl() {
        }

        public WatchNotificationSourceImpl(String string) {
            this.watchName = string;
        }

        public String getName() {
            return this.watchName;
        }

        public void setName(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

