/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.diagnostics.notifications.InvalidNotificationException;
import weblogic.diagnostics.watch.NotificationCreateException;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.diagnostics.watch.WatchNotificationRuntimeMBeanImpl;
import weblogic.management.ManagementException;

abstract class WatchNotificationListenerCommon {
    protected String notificationName;
    protected boolean notificationEnabled;
    protected long notificationsPerformed;
    private WatchNotificationRuntimeMBeanImpl watchRuntime = null;

    WatchNotificationListenerCommon(String string) throws InvalidNotificationException, NotificationCreateException {
        if (string == null) {
            throw new InvalidNotificationException("Name can not be null");
        }
        this.notificationName = string;
        try {
            this.watchRuntime = (WatchNotificationRuntimeMBeanImpl)WatchManager.getInstance().getWatchNotificationRuntime();
        }
        catch (ManagementException managementException) {
            throw new NotificationCreateException(managementException);
        }
    }

    public String getNotificationName() {
        return this.notificationName;
    }

    public boolean isEnabled() {
        return this.notificationEnabled;
    }

    public boolean isDisabled() {
        return !this.notificationEnabled;
    }

    public void setEnabled() {
        this.notificationEnabled = true;
    }

    public void setDisabled() {
        this.notificationEnabled = false;
    }

    protected WatchNotificationRuntimeMBeanImpl getWatchRuntime() {
        return this.watchRuntime;
    }
}

