/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import java.security.AccessController;
import weblogic.diagnostics.watch.JMXNotificationProducer;
import weblogic.diagnostics.watch.Watch;
import weblogic.diagnostics.watch.WatchException;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WLDFWatchJMXNotificationRuntimeMBean;
import weblogic.management.runtime.WLDFWatchNotificationRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class WatchNotificationRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WLDFWatchNotificationRuntimeMBean {
    private long totalHarvesterEvaluationCycles;
    private long totalHarvesterWatchEvaluations;
    private long totalHarvesterWatchesTriggered;
    private long totalHarvesterWatchEvaluationTime;
    private long minHarvesterWatchEvaluationTime;
    private long maxHarvesterWatchEvaluationTime;
    private long totalLogEvaluationCycles;
    private long totalLogWatchEvaluations;
    private long totalLogWatchesTriggered;
    private long totalLogWatchEvaluationTime;
    private long minLogWatchEvaluationTime;
    private long maxLogWatchEvaluationTime;
    private long totalEventDataEvaluationCycles;
    private long totalEventDataWatchEvaluations;
    private long totalEventDataWatchesTriggered;
    private long totalEventDataWatchEvaluationTime;
    private long minEventDataWatchEvaluationTime;
    private long maxEventDataWatchEvaluationTime;
    private int currentActiveAlarmsCount;
    private int maximumActiveAlarmsCount;
    private long totalActiveManualResetAlarms;
    private long totalActiveAutomaticResetAlarms;
    private long totalNotificationsPerformed;
    private long totalFailedNotifications;
    private long totalJMXNotificationsPerformed;
    private long totalFailedJMXNotifications;
    private long totalSMTPNotificationsPerformed;
    private long totalFailedSMTPNotifications;
    private long totalDIMGNotificationsPerformed;
    private long totalFailedDIMGNotifications;
    private long totalSNMPNotificationsPerformed;
    private long totalFailedSNMPNotifications;
    private long totalFailedJMSNotifications;
    private long totalJMSNotificationsPerformed;
    private WLDFWatchJMXNotificationRuntimeMBean notificationProducer;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    static WatchNotificationRuntimeMBeanImpl getInstance() throws ManagementException {
        return WatchNotificationRuntimeMBeanFactory.getSingleton();
    }

    private WatchNotificationRuntimeMBeanImpl() throws ManagementException {
        super("WatchNotification", (RuntimeMBean)ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getWLDFRuntime());
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getWLDFRuntime().setWLDFWatchNotificationRuntime(this);
    }

    public long getTotalHarvesterEvaluationCycles() {
        return this.totalHarvesterEvaluationCycles;
    }

    public long getTotalHarvesterWatchEvaluations() {
        return this.totalHarvesterWatchEvaluations;
    }

    public long getTotalHarvesterWatchesTriggered() {
        return this.totalHarvesterWatchesTriggered;
    }

    public long getAverageHarvesterWatchEvaluationTime() {
        return this.totalHarvesterEvaluationCycles > 0L ? this.totalHarvesterWatchEvaluationTime / this.totalHarvesterEvaluationCycles : 0L;
    }

    public long getTotalLogEvaluationCycles() {
        return this.totalLogEvaluationCycles;
    }

    public long getTotalLogWatchEvaluations() {
        return this.totalLogWatchEvaluations;
    }

    public long getTotalLogWatchesTriggered() {
        return this.totalLogWatchesTriggered;
    }

    public long getAverageLogWatchEvaluationTime() {
        return this.totalLogEvaluationCycles > 0L ? this.totalLogWatchEvaluationTime / this.totalLogEvaluationCycles : 0L;
    }

    public long getTotalEventDataEvaluationCycles() {
        return this.totalEventDataEvaluationCycles;
    }

    public long getTotalEventDataWatchEvaluations() {
        return this.totalEventDataWatchEvaluations;
    }

    public long getTotalEventDataWatchesTriggered() {
        return this.totalEventDataWatchesTriggered;
    }

    public long getAverageEventDataWatchEvaluationTime() {
        return this.totalEventDataEvaluationCycles > 0L ? this.totalEventDataWatchEvaluationTime / this.totalEventDataEvaluationCycles : 0L;
    }

    public int getCurrentActiveAlarmsCount() {
        return this.currentActiveAlarmsCount;
    }

    public int getMaximumActiveAlarmsCount() {
        return this.maximumActiveAlarmsCount;
    }

    public long getTotalActiveManualResetAlarms() {
        return this.totalActiveManualResetAlarms;
    }

    public long getTotalActiveAutomaticResetAlarms() {
        return this.totalActiveAutomaticResetAlarms;
    }

    public long getTotalNotificationsPerformed() {
        return this.totalNotificationsPerformed;
    }

    public String[] getActiveAlarmWatches() throws ManagementException {
        Watch[] watchArray = WatchManager.getInstance().getActiveAlarmWatches();
        if (watchArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[watchArray.length];
        for (int i = 0; i < watchArray.length; ++i) {
            stringArray[i] = watchArray[i].getWatchName();
        }
        return stringArray;
    }

    public void resetWatchAlarm(String string) throws ManagementException {
        try {
            WatchManager.getInstance().resetWatchAlarm(string);
        }
        catch (WatchException watchException) {
            throw new ManagementException((Throwable)((Object)watchException));
        }
    }

    public WLDFWatchJMXNotificationRuntimeMBean getWLDFWatchJMXNotificationRuntime() {
        return this.notificationProducer;
    }

    void incrementTotalHarvesterEvaluationCycles() {
        ++this.totalHarvesterEvaluationCycles;
    }

    void incrementTotalHarvesterWatchEvaluations(int n) {
        this.totalHarvesterWatchEvaluations += (long)n;
    }

    void incrementTotalHarvesterWatchesTriggered() {
        ++this.totalHarvesterWatchesTriggered;
    }

    void incrementTotalHarvesterWatchEvaluationTime(long l) {
        this.totalHarvesterWatchEvaluationTime += l;
        this.minHarvesterWatchEvaluationTime = Math.min(this.minHarvesterWatchEvaluationTime, l);
        this.maxHarvesterWatchEvaluationTime = Math.max(this.maxHarvesterWatchEvaluationTime, l);
    }

    void incrementTotalLogEvaluationCycles() {
        ++this.totalLogEvaluationCycles;
    }

    void incrementTotalLogWatchEvaluations(int n) {
        this.totalLogWatchEvaluations += (long)n;
    }

    void incrementTotalLogWatchesTriggered() {
        ++this.totalLogWatchesTriggered;
    }

    void incrementTotalLogWatchEvaluationTime(long l) {
        this.totalLogWatchEvaluationTime += l;
        this.minLogWatchEvaluationTime = Math.min(this.minLogWatchEvaluationTime, l);
        this.maxLogWatchEvaluationTime = Math.max(this.maxLogWatchEvaluationTime, l);
    }

    void incrementTotalEventDataEvaluationCycles() {
        ++this.totalEventDataEvaluationCycles;
    }

    void incrementTotalEventDataWatchEvaluations(int n) {
        this.totalEventDataWatchEvaluations += (long)n;
    }

    void incrementTotalEventDataWatchesTriggered() {
        ++this.totalEventDataWatchesTriggered;
    }

    void incrementTotalEventDataWatchEvaluationTime(long l) {
        this.totalEventDataWatchEvaluationTime += l;
        this.minEventDataWatchEvaluationTime = Math.min(this.minEventDataWatchEvaluationTime, l);
        this.maxEventDataWatchEvaluationTime = Math.max(this.maxEventDataWatchEvaluationTime, l);
    }

    void setCurrentActiveAlarmsCount(int n) {
        this.currentActiveAlarmsCount = n;
        this.maximumActiveAlarmsCount = Math.max(this.maximumActiveAlarmsCount, n);
    }

    void incrementTotalActiveManualResetAlarms() {
        ++this.totalActiveManualResetAlarms;
    }

    void incrementTotalActiveAutomaticResetAlarms() {
        ++this.totalActiveAutomaticResetAlarms;
    }

    synchronized void incrementTotalNotificationsPerformed() {
        ++this.totalNotificationsPerformed;
    }

    synchronized void incrementTotalFailedNotifications() {
        ++this.totalFailedNotifications;
    }

    public long getTotalFailedNotifications() {
        return this.totalFailedNotifications;
    }

    synchronized void setWatchJMXNotificationRuntime(WLDFWatchJMXNotificationRuntimeMBean wLDFWatchJMXNotificationRuntimeMBean) {
        this.notificationProducer = wLDFWatchJMXNotificationRuntimeMBean;
    }

    public long getMinimumHarvesterWatchEvaluationTime() {
        return this.minHarvesterWatchEvaluationTime;
    }

    public long getMaximumHarvesterWatchEvaluationTime() {
        return this.maxHarvesterWatchEvaluationTime;
    }

    public long getMinimumLogWatchEvaluationTime() {
        return this.minLogWatchEvaluationTime;
    }

    public long getMaximumLogWatchEvaluationTime() {
        return this.maxLogWatchEvaluationTime;
    }

    public long getMinimumEventDataWatchEvaluationTime() {
        return this.minEventDataWatchEvaluationTime;
    }

    public long getMaximumEventDataWatchEvaluationTime() {
        return this.maxEventDataWatchEvaluationTime;
    }

    void incrementTotalDIMGNotificationsPerformed() {
        ++this.totalDIMGNotificationsPerformed;
        this.incrementTotalNotificationsPerformed();
    }

    public long getTotalDIMGNotificationsPerformed() {
        return this.totalDIMGNotificationsPerformed;
    }

    void incrementTotalFailedDIMGNotifications() {
        ++this.totalFailedDIMGNotifications;
        this.incrementTotalFailedNotifications();
    }

    public long getTotalFailedDIMGNotifications() {
        return this.totalFailedDIMGNotifications;
    }

    void incrementTotalJMXNotificationsPerformed() {
        ++this.totalJMXNotificationsPerformed;
        this.incrementTotalNotificationsPerformed();
    }

    public long getTotalJMXNotificationsPerformed() {
        return this.totalJMXNotificationsPerformed;
    }

    void incrementTotalFailedJMXNotifications() {
        ++this.totalFailedJMXNotifications;
        this.incrementTotalFailedNotifications();
    }

    public long getTotalFailedJMXNotifications() {
        return this.totalFailedJMXNotifications;
    }

    void incrementTotalSMTPNotificationsPerformed() {
        ++this.totalSMTPNotificationsPerformed;
        this.incrementTotalNotificationsPerformed();
    }

    public long getTotalSMTPNotificationsPerformed() {
        return this.totalSMTPNotificationsPerformed;
    }

    void incrementTotalFailedSMTPNotifications() {
        ++this.totalFailedSMTPNotifications;
        this.incrementTotalFailedNotifications();
    }

    public long getTotalFailedSMTPNotifications() {
        return this.totalFailedSMTPNotifications;
    }

    void incrementTotalSNMPNotificationsPerformed() {
        ++this.totalSNMPNotificationsPerformed;
        this.incrementTotalNotificationsPerformed();
    }

    public long getTotalSNMPNotificationsPerformed() {
        return this.totalSNMPNotificationsPerformed;
    }

    void incrementTotalFailedSNMPNotifications() {
        ++this.totalFailedSNMPNotifications;
        this.incrementTotalFailedNotifications();
    }

    public long getTotalFailedSNMPNotifications() {
        return this.totalFailedSNMPNotifications;
    }

    void incrementTotalJMSNotificationsPerformed() {
        ++this.totalJMSNotificationsPerformed;
        this.incrementTotalNotificationsPerformed();
    }

    public long getTotalJMSNotificationsPerformed() {
        return this.totalJMSNotificationsPerformed;
    }

    void incrementTotalFailedJMSNotifications() {
        ++this.totalFailedJMSNotifications;
        this.incrementTotalFailedNotifications();
    }

    public long getTotalFailedJMSNotifications() {
        return this.totalFailedJMSNotifications;
    }

    static class WatchNotificationRuntimeMBeanFactory {
        private static WatchNotificationRuntimeMBeanImpl SINGLETON = null;

        WatchNotificationRuntimeMBeanFactory() {
        }

        private static WatchNotificationRuntimeMBeanImpl getSingleton() throws ManagementException {
            if (SINGLETON == null) {
                SINGLETON = new WatchNotificationRuntimeMBeanImpl();
                JMXNotificationProducer.getInstance();
            }
            return SINGLETON;
        }
    }
}

