/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import java.io.OutputStream;
import java.util.Date;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.diagnostics.image.descriptor.WatchAlarmStateBean;
import weblogic.diagnostics.image.descriptor.WatchImageSourceBean;
import weblogic.diagnostics.watch.Watch;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.management.ManagementException;

class WatchSource
implements ImageSource {
    private WatchImageSourceBean root;
    private boolean timeoutRequested;

    WatchSource() {
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        DescriptorManager descriptorManager = new DescriptorManager();
        Descriptor descriptor = descriptorManager.createDescriptorRoot(WatchImageSourceBean.class);
        this.root = (WatchImageSourceBean)descriptor.getRootBean();
        try {
            this.writeWatchAlarms();
            descriptorManager.writeDescriptorBeanAsXML((DescriptorBean)this.root, outputStream);
        }
        catch (Exception exception) {
            throw new ImageSourceCreationException((Throwable)exception);
        }
    }

    public void timeoutImageCreation() {
        this.timeoutRequested = true;
    }

    private void writeWatchAlarms() throws ManagementException {
        Watch[] watchArray = WatchManager.getInstance().getActiveAlarmWatches();
        for (int i = 0; watchArray != null && i < watchArray.length && !this.timeoutRequested; ++i) {
            Watch watch = watchArray[i];
            WatchAlarmStateBean watchAlarmStateBean = this.root.createWatchAlarmState();
            watchAlarmStateBean.setWatchName(watch.getWatchName());
            if (watch.getAlarmType() == 2) {
                watchAlarmStateBean.setAlarmResetType("AutomaticReset");
                watchAlarmStateBean.setAlarmResetPeriod(new Date(watch.getResetTime()).toString());
                continue;
            }
            watchAlarmStateBean.setAlarmResetType("ManualReset");
        }
    }
}

