/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import com.bea.adaptive.harvester.WatchedValues;
import weblogic.application.ApplicationContext;
import weblogic.descriptor.DescriptorDiff;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.descriptor.WLDFImageNotificationBean;
import weblogic.diagnostics.descriptor.WLDFJMSNotificationBean;
import weblogic.diagnostics.descriptor.WLDFJMXNotificationBean;
import weblogic.diagnostics.descriptor.WLDFNotificationBean;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.descriptor.WLDFSMTPNotificationBean;
import weblogic.diagnostics.descriptor.WLDFWatchBean;
import weblogic.diagnostics.descriptor.WLDFWatchNotificationBean;
import weblogic.diagnostics.harvester.HarvesterException;
import weblogic.diagnostics.harvester.HarvesterInternalAccess;
import weblogic.diagnostics.harvester.WLDFToHarvester;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.module.WLDFModuleException;
import weblogic.diagnostics.module.WLDFSubModule;
import weblogic.diagnostics.watch.ImageNotificationListener;
import weblogic.diagnostics.watch.JMSNotificationListener;
import weblogic.diagnostics.watch.JMXNotificationListener;
import weblogic.diagnostics.watch.JMXNotificationProducer;
import weblogic.diagnostics.watch.NotificationNotFoundException;
import weblogic.diagnostics.watch.SMTPNotificationListener;
import weblogic.diagnostics.watch.SNMPNotificationListener;
import weblogic.diagnostics.watch.Watch;
import weblogic.diagnostics.watch.WatchConfiguration;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.diagnostics.watch.WatchNotificationListener;
import weblogic.diagnostics.watch.WatchUtils;
import weblogic.logging.Severities;

public final class WatchSubModule
implements WLDFSubModule {
    private static final String WATCHED_VALUES_NAME = "WLDFWatchedValues";
    private static WatchManager watchManager = null;
    private static final DebugLogger DBG = DebugLogger.getDebugLogger((String)"DebugDiagnosticWatch");
    private WatchConfiguration currentWatchConfiguration;
    WLDFResourceBean rootBean;
    private JMXNotificationProducer jmxNotificationProducer;
    private WLDFToHarvester wldf2Hv;

    private WatchSubModule() {
        try {
            watchManager = WatchManager.getInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.rootBean = null;
        this.jmxNotificationProducer = null;
    }

    public static final WLDFSubModule createInstance() {
        return new WatchSubModule();
    }

    WLDFResourceBean getRootBean() {
        return this.rootBean;
    }

    private void identifyNotifications(WLDFWatchNotificationBean wLDFWatchNotificationBean, WatchConfiguration watchConfiguration) throws WLDFModuleException {
        this.identifyImageNotifications(wLDFWatchNotificationBean.getImageNotifications(), watchConfiguration);
        this.identifyJMSNotifications(wLDFWatchNotificationBean.getJMSNotifications(), watchConfiguration);
        this.identifyJMXNotifications(wLDFWatchNotificationBean.getJMXNotifications(), watchConfiguration);
        this.identifySMTPNotifications(wLDFWatchNotificationBean.getSMTPNotifications(), watchConfiguration);
        this.identifySNMPNotifications(wLDFWatchNotificationBean.getSNMPNotifications(), watchConfiguration);
    }

    private void identifyWatches(WLDFWatchBean[] wLDFWatchBeanArray, WatchConfiguration watchConfiguration) throws WLDFModuleException {
        if (wLDFWatchBeanArray == null || wLDFWatchBeanArray.length == 0) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("No configured watches");
            }
            return;
        }
        int n = wLDFWatchBeanArray.length;
        for (int i = 0; i < n; ++i) {
            String string = wLDFWatchBeanArray[i].getName();
            int n2 = WatchUtils.convertRuleTypeToInt(wLDFWatchBeanArray[i].getRuleType());
            int n3 = Severities.severityStringToNum((String)wLDFWatchBeanArray[i].getSeverity());
            int n4 = WatchUtils.convertAlarmResetTypeToInt(wLDFWatchBeanArray[i].getAlarmType());
            int n5 = wLDFWatchBeanArray[i].getAlarmResetPeriod();
            try {
                WLDFNotificationBean[] wLDFNotificationBeanArray = wLDFWatchBeanArray[i].getNotifications();
                WatchNotificationListener[] watchNotificationListenerArray = null;
                boolean bl = false;
                if (wLDFNotificationBeanArray != null && wLDFNotificationBeanArray.length > 0) {
                    watchNotificationListenerArray = new WatchNotificationListener[wLDFNotificationBeanArray.length];
                    for (int j = 0; j < wLDFNotificationBeanArray.length; ++j) {
                        try {
                            watchNotificationListenerArray[j] = watchConfiguration.getNotification(wLDFNotificationBeanArray[j].getName());
                            continue;
                        }
                        catch (NotificationNotFoundException notificationNotFoundException) {
                            bl = true;
                            DiagnosticsLogger.logInvalidNotification((String)string, (String)wLDFNotificationBeanArray[j].getName());
                        }
                    }
                }
                if (bl) continue;
                Watch watch = new Watch(string, n2, wLDFWatchBeanArray[i].getRuleExpression(), n3, n4, n5, WatchUtils.getNotificationNames(wLDFWatchBeanArray[i].getNotifications()), watchNotificationListenerArray, watchConfiguration);
                if (wLDFWatchBeanArray[i].isEnabled()) {
                    watch.setEnabled();
                } else {
                    watch.setDisabled();
                }
                watchConfiguration.addWatch(watch);
                if (!DBG.isDebugEnabled()) continue;
                DBG.debug("Loaded watch " + string);
                continue;
            }
            catch (Exception exception) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("Error creating watch ", (Throwable)exception);
                }
                throw new WLDFModuleException(DiagnosticsLogger.logCreateWatchErrorLoggable((String)string, (Throwable)exception).getMessage());
            }
        }
        if (DBG.isDebugEnabled()) {
            DBG.debug("Loaded " + n + " watches ");
        }
        if (DBG.isDebugEnabled()) {
            String string = this.currentWatchConfiguration.getWatchedValues().dump("", false, true, true);
            DBG.debug(string);
        }
    }

    private void identifyImageNotifications(WLDFImageNotificationBean[] wLDFImageNotificationBeanArray, WatchConfiguration watchConfiguration) throws WLDFModuleException {
        if (wLDFImageNotificationBeanArray == null || wLDFImageNotificationBeanArray.length == 0) {
            return;
        }
        int n = wLDFImageNotificationBeanArray.length;
        for (int i = 0; i < n; ++i) {
            WLDFImageNotificationBean wLDFImageNotificationBean = wLDFImageNotificationBeanArray[i];
            String string = wLDFImageNotificationBeanArray[i].getName();
            String string2 = wLDFImageNotificationBean.getImageDirectory();
            Integer n2 = new Integer(wLDFImageNotificationBean.getImageLockout());
            boolean bl = wLDFImageNotificationBean.isEnabled();
            ImageNotificationListener imageNotificationListener = null;
            try {
                imageNotificationListener = string2 != null && n2 != null ? new ImageNotificationListener(string, string2, n2) : (string2 != null ? new ImageNotificationListener(string, string2) : (n2 != null ? new ImageNotificationListener(string, null, n2) : new ImageNotificationListener(string)));
                if (bl) {
                    imageNotificationListener.setEnabled();
                } else {
                    imageNotificationListener.setDisabled();
                }
                watchConfiguration.addNotificationListener(imageNotificationListener);
                continue;
            }
            catch (Exception exception) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("Error creating Image notification ", (Throwable)exception);
                }
                throw new WLDFModuleException(exception);
            }
        }
    }

    private void identifyJMSNotifications(WLDFJMSNotificationBean[] wLDFJMSNotificationBeanArray, WatchConfiguration watchConfiguration) throws WLDFModuleException {
        if (wLDFJMSNotificationBeanArray == null || wLDFJMSNotificationBeanArray.length == 0) {
            return;
        }
        int n = wLDFJMSNotificationBeanArray.length;
        for (int i = 0; i < n; ++i) {
            WLDFJMSNotificationBean wLDFJMSNotificationBean = wLDFJMSNotificationBeanArray[i];
            String string = wLDFJMSNotificationBean.getName();
            String string2 = wLDFJMSNotificationBean.getDestinationJNDIName();
            String string3 = wLDFJMSNotificationBean.getConnectionFactoryJNDIName();
            boolean bl = wLDFJMSNotificationBeanArray[i].isEnabled();
            JMSNotificationListener jMSNotificationListener = null;
            try {
                jMSNotificationListener = string3 != null ? new JMSNotificationListener(string, string2, string3) : new JMSNotificationListener(string, string2);
                if (bl) {
                    jMSNotificationListener.setEnabled();
                } else {
                    jMSNotificationListener.setDisabled();
                }
                watchConfiguration.addNotificationListener(jMSNotificationListener);
                continue;
            }
            catch (Exception exception) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("Error creating JMS Notification ", (Throwable)exception);
                }
                throw new WLDFModuleException(exception);
            }
        }
    }

    private void identifyJMXNotifications(WLDFNotificationBean[] wLDFNotificationBeanArray, WatchConfiguration watchConfiguration) throws WLDFModuleException {
        this.jmxNotificationProducer = JMXNotificationProducer.getInstance();
        if (wLDFNotificationBeanArray == null || wLDFNotificationBeanArray.length == 0) {
            return;
        }
        int n = wLDFNotificationBeanArray.length;
        for (int i = 0; i < n; ++i) {
            WLDFJMXNotificationBean wLDFJMXNotificationBean = (WLDFJMXNotificationBean)wLDFNotificationBeanArray[i];
            String string = wLDFJMXNotificationBean.getName();
            String string2 = wLDFJMXNotificationBean.getNotificationType();
            boolean bl = wLDFJMXNotificationBean.isEnabled();
            try {
                JMXNotificationListener jMXNotificationListener = new JMXNotificationListener(string, string2, this.jmxNotificationProducer);
                if (bl) {
                    jMXNotificationListener.setEnabled();
                } else {
                    jMXNotificationListener.setDisabled();
                }
                watchConfiguration.addNotificationListener(jMXNotificationListener);
                continue;
            }
            catch (Exception exception) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("Error creating JMX Notification ", (Throwable)exception);
                }
                throw new WLDFModuleException(exception);
            }
        }
    }

    private void identifySMTPNotifications(WLDFNotificationBean[] wLDFNotificationBeanArray, WatchConfiguration watchConfiguration) throws WLDFModuleException {
        if (wLDFNotificationBeanArray == null || wLDFNotificationBeanArray.length == 0) {
            return;
        }
        int n = wLDFNotificationBeanArray.length;
        for (int i = 0; i < n; ++i) {
            WLDFSMTPNotificationBean wLDFSMTPNotificationBean = (WLDFSMTPNotificationBean)wLDFNotificationBeanArray[i];
            String string = wLDFSMTPNotificationBean.getName();
            String string2 = wLDFSMTPNotificationBean.getMailSessionJNDIName();
            String[] stringArray = wLDFSMTPNotificationBean.getRecipients();
            String string3 = wLDFSMTPNotificationBean.getSubject();
            String string4 = wLDFSMTPNotificationBean.getBody();
            boolean bl = wLDFSMTPNotificationBean.isEnabled();
            SMTPNotificationListener sMTPNotificationListener = null;
            try {
                sMTPNotificationListener = string3 == null && string4 == null ? new SMTPNotificationListener(string, string2, stringArray) : new SMTPNotificationListener(string, string2, stringArray, string3, string4);
                if (bl) {
                    sMTPNotificationListener.setEnabled();
                } else {
                    sMTPNotificationListener.setDisabled();
                }
                watchConfiguration.addNotificationListener(sMTPNotificationListener);
                continue;
            }
            catch (Exception exception) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("Error creating SMTP Notification ", (Throwable)exception);
                }
                throw new WLDFModuleException(exception);
            }
        }
    }

    private void identifySNMPNotifications(WLDFNotificationBean[] wLDFNotificationBeanArray, WatchConfiguration watchConfiguration) throws WLDFModuleException {
        if (wLDFNotificationBeanArray == null || wLDFNotificationBeanArray.length == 0) {
            return;
        }
        int n = wLDFNotificationBeanArray.length;
        for (int i = 0; i < n; ++i) {
            String string = wLDFNotificationBeanArray[i].getName();
            boolean bl = wLDFNotificationBeanArray[i].isEnabled();
            SNMPNotificationListener sNMPNotificationListener = null;
            try {
                sNMPNotificationListener = new SNMPNotificationListener(string);
                if (bl) {
                    sNMPNotificationListener.setEnabled();
                } else {
                    sNMPNotificationListener.setDisabled();
                }
                watchConfiguration.addNotificationListener(sNMPNotificationListener);
                continue;
            }
            catch (Exception exception) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("Error creating SNMP Notification ", (Throwable)exception);
                }
                throw new WLDFModuleException(exception);
            }
        }
    }

    private void initializeFromConfiguration(WLDFResourceBean wLDFResourceBean) throws WLDFModuleException {
        this.wldf2Hv = HarvesterInternalAccess.getInstance();
        if (DBG.isDebugEnabled()) {
            DBG.debug("Creating new WatchNotification configuration object for " + wLDFResourceBean.getWatchNotification());
        }
        if (this.currentWatchConfiguration != null) {
            DBG.debug("Deleting current watched values set for W&N");
            try {
                this.deleteWatchedValues();
            }
            catch (HarvesterException harvesterException) {
                throw new WLDFModuleException((Throwable)((Object)harvesterException));
            }
        }
        WatchedValues watchedValues = this.wldf2Hv.createWatchedValues(WATCHED_VALUES_NAME);
        this.currentWatchConfiguration = new WatchConfiguration(watchedValues);
        this.currentWatchConfiguration.initializeLogEventHandlerSeverity(wLDFResourceBean.getWatchNotification().getLogWatchSeverity());
        this.currentWatchConfiguration.setWatchNotificationEnabled(wLDFResourceBean.getWatchNotification().isEnabled());
        this.identifyNotifications(wLDFResourceBean.getWatchNotification(), this.currentWatchConfiguration);
        this.identifyWatches(wLDFResourceBean.getWatchNotification().getWatches(), this.currentWatchConfiguration);
        if (DBG.isDebugEnabled()) {
            boolean bl = this.currentWatchConfiguration.isWatchNotificationEnabled();
            DBG.debug("Current WatchNotification configuration is " + (bl ? "enabled" : "disabled"));
        }
    }

    private void deleteWatchedValues() throws HarvesterException {
        if (this.currentWatchConfiguration != null) {
            WatchedValues watchedValues = this.currentWatchConfiguration.getWatchedValues();
            if (watchedValues.getId() > -1) {
                this.wldf2Hv.deleteWatchedValues(watchedValues);
            } else if (DBG.isDebugEnabled()) {
                DBG.debug("WatchSubModule.deleteWatchedValues(): Watched values ID invalid, does not appear to have been registered");
            }
        }
    }

    public void init(ApplicationContext applicationContext, WLDFResourceBean wLDFResourceBean) {
        this.rootBean = wLDFResourceBean;
    }

    public void prepare() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WatchSubModule.prepare");
        }
    }

    public void activate() throws WLDFModuleException {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WatchSubModule.activate");
        }
        this.initializeFromConfiguration(this.rootBean);
        watchManager.moduleActivated(this.currentWatchConfiguration);
    }

    public void deactivate() {
        block3: {
            if (DBG.isDebugEnabled()) {
                DBG.debug("In WatchSubModule.deactivate");
            }
            try {
                this.deleteWatchedValues();
            }
            catch (HarvesterException harvesterException) {
                if (!DBG.isDebugEnabled()) break block3;
                DBG.debug("Caught unexpected exception deleting watched values", (Throwable)((Object)harvesterException));
            }
        }
        watchManager.moduleDeactivated();
    }

    public void unprepare() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WatchSubModule.unprepare");
        }
    }

    public void destroy() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WatchSubModule.destroy");
        }
    }

    public void prepareUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) throws WLDFModuleException {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WatchSubModule.prepareUpdate");
        }
        this.initializeFromConfiguration(wLDFResourceBean);
    }

    public void activateUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) throws WLDFModuleException {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WatchSubModule.activateUpdate");
        }
        watchManager.moduleActivated(this.currentWatchConfiguration);
    }

    public void rollbackUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WatchSubModule.rollbackUpdate");
        }
    }
}

