/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import java.security.AccessController;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import weblogic.diagnostics.descriptor.WLDFNotificationBean;
import weblogic.diagnostics.query.VariableInstance;
import weblogic.diagnostics.watch.NotificationCreateException;
import weblogic.diagnostics.watch.Watch;
import weblogic.diagnostics.watch.WatchNotification;
import weblogic.logging.SeverityI18N;
import weblogic.management.WebLogicMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

final class WatchUtils {
    static final String IMAGE_NOTIFICATION_TYPE = "WLDFImageNotification";
    static final String JMX_NOTIFICATION_TYPE = "WLDFJMXNotification";
    static final String JMS_NOTIFICATION_TYPE = "WLDFJMSNotification";
    static final String SNMP_NOTIFICATION_TYPE = "WLDFSNMPNotification";
    static final String SMTP_NOTIFICATION_TYPE = "WLDFSMTPNotification";
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static String domainName = null;
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 0, Locale.getDefault());

    WatchUtils() {
    }

    public static int convertRuleTypeToInt(String string) {
        int n = 2;
        if (string != null) {
            if (string.equals("Harvester")) {
                n = 2;
            } else if (string.equals("Log")) {
                n = 1;
            } else if (string.equals("EventData")) {
                n = 3;
            }
        }
        return n;
    }

    public static int convertAlarmResetTypeToInt(String string) {
        int n = 1;
        if (string != null) {
            n = string.equals("ManualReset") ? 1 : (string.equals("AutomaticReset") ? 2 : 0);
        }
        return n;
    }

    public static String[] getNotificationNames(WLDFNotificationBean[] wLDFNotificationBeanArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (wLDFNotificationBeanArray != null) {
            for (int i = 0; i < wLDFNotificationBeanArray.length; ++i) {
                arrayList.add(wLDFNotificationBeanArray[i].getName());
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static WLDFNotificationBean[] getNotificationsOfType(WLDFNotificationBean[] wLDFNotificationBeanArray, String string) {
        ArrayList<WLDFNotificationBean> arrayList = new ArrayList<WLDFNotificationBean>();
        if (wLDFNotificationBeanArray != null) {
            for (int i = 0; i < wLDFNotificationBeanArray.length; ++i) {
                if (!((WebLogicMBean)wLDFNotificationBeanArray[i]).getType().equals(string)) continue;
                arrayList.add(wLDFNotificationBeanArray[i]);
            }
        }
        WLDFNotificationBean[] wLDFNotificationBeanArray2 = new WLDFNotificationBean[arrayList.size()];
        arrayList.toArray(wLDFNotificationBeanArray2);
        return wLDFNotificationBeanArray2;
    }

    static String getCurrentDomainName() {
        if (domainName != null) {
            return domainName;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
        if (runtimeAccess != null) {
            domainName = runtimeAccess.getDomainName();
        }
        return domainName;
    }

    static String getToAddresses(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    static WatchNotification setWatchTimeInDateFormat(WatchNotification watchNotification, long l) {
        watchNotification.setWatchTime(DATE_FORMAT.format(new Date(l)));
        return watchNotification;
    }

    static WatchNotification populateFromWatch(WatchNotification watchNotification, Watch watch) throws NotificationCreateException {
        String string = "WatchName: " + (watch != null ? watch.getWatchName() : "") + " " + "WatchSeverityLevel" + ": " + SeverityI18N.severityNumToString((int)(watch != null ? watch.getSeverity() : 0));
        watchNotification.setMessage(string);
        watchNotification.setWatchName(watch.getWatchName());
        switch (watch.getRuleType()) {
            case 1: {
                watchNotification.setWatchRuleType("Log");
                break;
            }
            case 2: {
                watchNotification.setWatchRuleType("Harvester");
                break;
            }
            case 3: {
                watchNotification.setWatchRuleType("EventData");
                break;
            }
            default: {
                throw new NotificationCreateException("Invalid rule type");
            }
        }
        watchNotification.setWatchRule(watch.getRuleExpression());
        watchNotification.setWatchSeverityLevel(SeverityI18N.severityNumToString((int)watch.getSeverity()));
        watchNotification.setWatchAlarmResetPeriod("" + watch.getAlarmResetPeriod());
        if (!watch.hasAlarm()) {
            watchNotification.setWatchAlarmType("None");
        } else if (watch.hasManualResetAlarm()) {
            watchNotification.setWatchAlarmType("ManualReset");
        } else if (watch.hasAutomaticResetAlarm()) {
            watchNotification.setWatchAlarmType("AutomaticReset");
        } else {
            throw new NotificationCreateException("Invalid alarm type");
        }
        watchNotification.setWatchDomainName(WatchDataStaticInitializer.DOMAIN_NAME);
        watchNotification.setWatchServerName(WatchDataStaticInitializer.SERVER_NAME);
        return watchNotification;
    }

    static String getWatchDataString(Map map) {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) continue;
                if (v.getClass().isArray()) {
                    Object[] objectArray = (Object[])v;
                    for (int i = 0; i < objectArray.length; ++i) {
                        WatchUtils.appendVariableInstance(stringBuilder, k, objectArray[i]);
                    }
                    continue;
                }
                WatchUtils.appendVariableInstance(stringBuilder, k, v);
            }
        }
        return stringBuilder.toString();
    }

    private static void appendVariableInstance(StringBuilder stringBuilder, Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        if (object2 instanceof VariableInstance) {
            VariableInstance variableInstance = (VariableInstance)object2;
            if (variableInstance.getInstanceValue() == null) {
                return;
            }
            stringBuilder.append(variableInstance.getInstanceName());
            stringBuilder.append("//");
            stringBuilder.append(variableInstance.getAttributeName());
            stringBuilder.append(" = ");
            stringBuilder.append(variableInstance.getInstanceValue());
        } else {
            stringBuilder.append(object);
            stringBuilder.append(" = ");
            stringBuilder.append(object2);
        }
        stringBuilder.append(" ");
    }

    static /* synthetic */ AuthenticatedSubject access$000() {
        return KERNEL_ID;
    }

    private static class WatchDataStaticInitializer {
        private static final String DOMAIN_NAME = ManagementService.getRuntimeAccess(WatchUtils.access$000()).getDomainName();
        private static final String SERVER_NAME = ManagementService.getRuntimeAccess(WatchUtils.access$000()).getServerName();

        private WatchDataStaticInitializer() {
        }
    }
}

