/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.watch;

import java.security.AccessController;
import java.util.HashSet;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import weblogic.diagnostics.descriptor.WLDFNotificationBean;
import weblogic.diagnostics.descriptor.WLDFWatchBean;
import weblogic.diagnostics.descriptor.WLDFWatchNotificationBean;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.query.QueryFactory;
import weblogic.diagnostics.query.QueryParsingException;
import weblogic.diagnostics.query.VariableIndexResolver;
import weblogic.diagnostics.watch.FixedSetVariableValidator;
import weblogic.diagnostics.watch.HarvesterVariableValidator;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MailSessionMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class WatchValidator {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static void validateWatch(WLDFWatchBean wLDFWatchBean) {
        WatchValidator.validateWatchRule(wLDFWatchBean.getName(), wLDFWatchBean.getRuleType(), wLDFWatchBean.getRuleExpression());
    }

    public static void validateWatchRule(String string, String string2) {
        WatchValidator.validateWatchRule(null, string, string2);
    }

    public static void validateWatchRule(String string, String string2, String string3) {
        try {
            Object object = null;
            if (string2.equals("Harvester")) {
                object = new HarvesterVariableValidator(string);
            } else if (string2.equals("Log")) {
                object = new FixedSetVariableValidator(3);
            } else if (string2.equals("EventData")) {
                object = new FixedSetVariableValidator(1);
            }
            QueryFactory.createQuery((VariableIndexResolver)object, (String)string3);
        }
        catch (QueryParsingException queryParsingException) {
            String string4 = DiagnosticsLogger.logInvalidWatchRuleExpressionLoggable((String)string3, (Throwable)queryParsingException).getMessage();
            throw new IllegalArgumentException(string4);
        }
    }

    public static void validateRecipients(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        try {
            InternetAddress.parse((String)stringBuffer.toString(), (boolean)false);
        }
        catch (AddressException addressException) {
            throw new IllegalArgumentException(addressException);
        }
    }

    public static void validateWatchNotificationBean(WLDFWatchNotificationBean wLDFWatchNotificationBean) {
        HashSet<String> hashSet = new HashSet<String>();
        WLDFNotificationBean[] wLDFNotificationBeanArray = wLDFWatchNotificationBean.getNotifications();
        if (wLDFNotificationBeanArray == null) {
            return;
        }
        for (int i = 0; i < wLDFNotificationBeanArray.length; ++i) {
            String string = wLDFNotificationBeanArray[i].getName();
            if (hashSet.contains(string)) {
                String string2 = DiagnosticsLogger.logNotificationNameExistingLoggable((String)string).getMessage();
                throw new IllegalArgumentException(string2);
            }
            hashSet.add(string);
        }
    }

    private static MailSessionMBean getMailSessionMBean(String string) {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        DomainMBean domainMBean = runtimeAccess.getDomain();
        MailSessionMBean[] mailSessionMBeanArray = domainMBean.getMailSessions();
        for (int i = 0; i < mailSessionMBeanArray.length; ++i) {
            MailSessionMBean mailSessionMBean = mailSessionMBeanArray[i];
            String string2 = mailSessionMBean.getJNDIName();
            if (!string.equals(string2)) continue;
            return mailSessionMBean;
        }
        return null;
    }
}

