/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.ejb.EJBException;
import javax.ejb.EnterpriseBean;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import weblogic.logging.LogOutputStream;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;

public abstract class GenericEnterpriseBean
implements EnterpriseBean {
    private static final long serialVersionUID = 2011822578998863408L;
    private transient Context ic;
    private boolean tracingEnabled = false;
    private final String beanClassName = this.getClass().getName();
    private transient LogOutputStream log = new LogOutputStream(this.beanClassName);

    public GenericEnterpriseBean() {
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException namingException) {
            throw new EJBException((Exception)namingException);
        }
        try {
            Boolean bl = (Boolean)this.ic.lookup("java:/comp/env/_WL_TracingEnabled");
            this.tracingEnabled = bl;
        }
        catch (NamingException namingException) {
            this.tracingEnabled = false;
        }
        catch (ClassCastException classCastException) {
            throw new EJBException("_WL_TracingEnabled was found in your  environment entries, but it's type was not Boolean. Please modify your ejb-jar.xml and change the env-entry-type to be java.lang.Boolean.");
        }
    }

    protected final boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    protected void setTracingEnabled(boolean bl) {
        this.tracingEnabled = bl;
    }

    private String buildTraceString(String string) {
        return "Method: " + string + " called in bean class: " + this.beanClassName + " SystemIdentityHashCode: " + System.identityHashCode(this) + " Trasaction ID: " + this.getCurrentXID();
    }

    protected void trace(String string) {
        this.logDebugMessage(this.buildTraceString(string));
    }

    protected void trace(String string, Object object) {
        this.logDebugMessage(this.buildTraceString(string) + " Primary Key: " + object);
    }

    protected void logDebugMessage(String string) {
        this.log.debug(string);
    }

    protected void logDebugMessage(String string, Throwable throwable) {
        this.log.debug(string, throwable);
    }

    protected void logErrorMessage(String string) {
        this.log.error(string);
    }

    protected void logErrorMessage(String string, Throwable throwable) {
        this.log.error(string, throwable);
    }

    protected Context getInitialContext() {
        return this.ic;
    }

    protected Object getEnvEntry(String string) {
        try {
            return this.ic.lookup("java:comp/env/" + string);
        }
        catch (NamingException namingException) {
            throw new EJBException((Exception)namingException);
        }
    }

    protected Transaction getCurrentTransaction() {
        return TxHelper.getTransaction();
    }

    protected String getCurrentXID() {
        Transaction transaction = this.getCurrentTransaction();
        if (transaction == null) {
            return TxHelper.status2String(6);
        }
        return transaction.getXID().toString();
    }

    protected TransactionManager getTransactionManager() {
        return TxHelper.getTransactionManager();
    }

    protected String getCurrentTransactionStatus() {
        Transaction transaction = TxHelper.getTransaction();
        if (transaction == null) {
            return TxHelper.status2String(6);
        }
        try {
            return TxHelper.status2String(transaction.getStatus());
        }
        catch (SystemException systemException) {
            throw new EJBException((Exception)((Object)systemException));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException namingException) {
            throw new EJBException((Exception)namingException);
        }
        this.log = new LogOutputStream(this.beanClassName);
    }
}

