/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container;

import java.security.AccessController;
import java.util.Set;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.configuration.EJBContainerMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class ReadConfig {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static Set m_ejbContainerMBeans = null;

    public static String getJavaCompilerPreClassPath(EJBComponentMBean eJBComponentMBean) {
        String string = null;
        if (eJBComponentMBean != null) {
            string = eJBComponentMBean.getJavaCompilerPreClassPath();
        }
        if (null == string && null != ReadConfig.getEJBContainerMBean()) {
            string = ReadConfig.getEJBContainerMBean().getJavaCompilerPreClassPath();
        }
        if (null == string && null != ReadConfig.getServerMBean()) {
            string = ReadConfig.getServerMBean().getJavaCompilerPreClassPath();
        }
        return string;
    }

    public static String getJavaCompilerPostClassPath(EJBComponentMBean eJBComponentMBean) {
        String string = null;
        if (eJBComponentMBean != null) {
            string = eJBComponentMBean.getJavaCompilerPostClassPath();
        }
        if (null == string && null != ReadConfig.getEJBContainerMBean()) {
            string = ReadConfig.getEJBContainerMBean().getJavaCompilerPostClassPath();
        }
        if (null == string && null != ReadConfig.getServerMBean()) {
            string = ReadConfig.getServerMBean().getJavaCompilerPostClassPath();
        }
        return string;
    }

    public static String getJavaCompiler(EJBComponentMBean eJBComponentMBean) {
        String string = null;
        if (eJBComponentMBean != null) {
            string = eJBComponentMBean.getJavaCompiler();
        }
        if (null == string && null != ReadConfig.getEJBContainerMBean()) {
            string = ReadConfig.getEJBContainerMBean().getJavaCompiler();
        }
        if (string == null) {
            string = "jdt";
        }
        if (null == string && null != ReadConfig.getServerMBean()) {
            string = ReadConfig.getServerMBean().getJavaCompiler();
            String string2 = ReadConfig.getServerMBean().getExtraEjbcOptions();
            if (null == string2 && "javac".equalsIgnoreCase(string)) {
                string = null;
            }
        }
        return string;
    }

    public static String getExtraEjbcOptions(EJBComponentMBean eJBComponentMBean) {
        String string = null;
        if (eJBComponentMBean != null) {
            string = eJBComponentMBean.getExtraEjbcOptions();
        }
        if (null == string && null != ReadConfig.getEJBContainerMBean()) {
            string = ReadConfig.getEJBContainerMBean().getExtraEjbcOptions();
        }
        if (null == string && null != ReadConfig.getServerMBean()) {
            string = ReadConfig.getServerMBean().getExtraEjbcOptions();
        }
        return string;
    }

    public static boolean isVerboseEJBDeploymentEnabled() {
        return ReadConfig.isVerboseEJBDeploymentEnabled(null);
    }

    public static boolean isVerboseEJBDeploymentEnabled(EJBComponentMBean eJBComponentMBean) {
        String string = null;
        if (null != eJBComponentMBean) {
            string = eJBComponentMBean.getVerboseEJBDeploymentEnabled();
        }
        if (null == string && null != ReadConfig.getEJBContainerMBean()) {
            string = ReadConfig.getEJBContainerMBean().getVerboseEJBDeploymentEnabled();
        }
        if (null == string && null != ReadConfig.getServerMBean()) {
            string = ReadConfig.getServerMBean().getVerboseEJBDeploymentEnabled();
        }
        return "true".equalsIgnoreCase(string);
    }

    public static boolean getForceGeneration(EJBComponentMBean eJBComponentMBean) {
        if (null != eJBComponentMBean && eJBComponentMBean.getApplication().isInternalApp()) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (null != eJBComponentMBean) {
            bl = eJBComponentMBean.getForceGeneration();
            bl2 = eJBComponentMBean.isSet("ForceGeneration");
        }
        if (!bl2 && null != ReadConfig.getEJBContainerMBean()) {
            bl = ReadConfig.getEJBContainerMBean().getForceGeneration();
        }
        return bl;
    }

    private static EJBContainerMBean getEJBContainerMBean() {
        if (Kernel.isServer()) {
            return ManagementService.getRuntimeAccess(kernelId).getDomain().getEJBContainer();
        }
        return null;
    }

    private static ServerMBean getServerMBean() {
        if (Kernel.isServer()) {
            return ManagementService.getRuntimeAccess(kernelId).getServer();
        }
        return null;
    }
}

