/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import java.util.HashMap;
import java.util.Set;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.CacheScrubberTimer;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.container.interfaces.SingleInstanceCache;
import weblogic.ejb.spi.ScrubbedCache;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;

public abstract class BaseCache
implements SingleInstanceCache,
ScrubbedCache,
TimerListener {
    protected static final DebugLogger debugLogger = EJBDebugService.cachingLogger;
    protected static boolean dumpCache = System.getProperty("ejb.enableCacheDump") != null;
    private boolean usesMaxBeansInCache = false;
    private long maxCacheSize = 0L;
    protected long currentCacheSize = 0L;
    protected HashMap cache;
    protected String cacheName = null;
    protected long scrubIntervalMillisDD;
    protected long scrubIntervalMillis;
    protected int scrubCount = 0;
    protected CacheScrubberTimer scrubberTimer;

    public BaseCache(String string, long l) {
        this.maxCacheSize = l;
        this.usesMaxBeansInCache = false;
        this.setup(string);
    }

    public BaseCache(String string, int n) {
        this.maxCacheSize = n;
        this.usesMaxBeansInCache = true;
        this.setup(string);
    }

    private void setup(String string) {
        assert (string != null);
        this.cacheName = string;
        this.cache = new HashMap();
        this.scrubberTimer = new CacheScrubberTimer(this, 0L, string);
    }

    public int getMaxBeansInCache() {
        return (int)this.maxCacheSize;
    }

    public void setMaxBeansInCache(int n) {
        this.maxCacheSize = n;
    }

    public boolean usesMaxBeansInCache() {
        return this.usesMaxBeansInCache;
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(long l) {
        this.maxCacheSize = l;
    }

    protected String getCacheUnits() {
        if (this.usesMaxBeansInCache()) {
            return "beans";
        }
        return "bytes";
    }

    public synchronized long getCurrentSize() {
        return this.currentCacheSize;
    }

    public synchronized boolean contains(CacheKey cacheKey) {
        assert (this.validateDataStructures());
        return this.cache.get(cacheKey) != null;
    }

    public synchronized void release(CacheKey cacheKey) {
        assert (this.validateDataStructures());
        Node node = (Node)this.cache.get(cacheKey);
        if (node == null) {
            return;
        }
        assert (node.isActive());
        assert (node.pinned());
        node.unpin();
        EnterpriseBean enterpriseBean = node.getBean();
        if (node.getCallback().needsRemoval(enterpriseBean)) {
            this.remove(cacheKey);
        }
        this.releaseEntityBean(node);
        assert (this.validateDataStructures());
    }

    public synchronized void clear() {
        for (CacheKey cacheKey : this.cache.keySet()) {
            EnterpriseBean enterpriseBean = this.get(cacheKey);
            try {
                if (!(enterpriseBean instanceof SessionBean)) continue;
                SessionBean sessionBean = (SessionBean)enterpriseBean;
                sessionBean.ejbRemove();
            }
            catch (Throwable throwable) {
                EJBLogger.logExceptionDuringEJBRemove((Throwable)throwable);
            }
        }
        this.cache.clear();
        this.currentCacheSize = 0L;
    }

    public void setScrubInterval(int n) {
        if (n > 0) {
            long l = (long)n * 1000L;
            if (this.scrubIntervalMillisDD <= 0L) {
                this.scrubIntervalMillisDD = l;
            } else if (l < this.scrubIntervalMillisDD) {
                this.scrubIntervalMillisDD = l;
            }
            this.scrubIntervalMillis = this.scrubIntervalMillisDD;
            this.scrubberTimer.setScrubInterval(this.scrubIntervalMillisDD);
        }
    }

    public void startScrubber() {
        this.scrubCount = 0;
        this.scrubberTimer.startScrubber();
    }

    public void stopScrubber() {
        this.scrubberTimer.stopScrubber();
    }

    public void timerExpired(Timer timer) {
        this.cacheScrubber();
    }

    public void updateIdleTimeoutSeconds(int n) {
        this.scrubberTimer.resetScrubInterval((long)n * 1000L);
    }

    abstract void cacheScrubber();

    abstract void releaseEntityBean(Node var1);

    protected void passivateNode(Node node) {
        if (debugLogger.isDebugEnabled()) {
            BaseCache.debug("passivateNode key: " + node.getKey());
        }
        assert (!node.pinned());
        assert (node.getBean() != null);
        assert (node.getKey() != null);
        assert (node.getCallback() != null);
        CacheKey cacheKey = node.getKey();
        EnterpriseBean enterpriseBean = node.getBean();
        node.getCallback().swapOut(cacheKey, enterpriseBean);
    }

    protected String cacheDump() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.cache.isEmpty()) {
            stringBuffer.append("Dumping EJBCache for: ");
            stringBuffer.append(this.cacheName);
            stringBuffer.append(" [ Cache size: ");
            stringBuffer.append(this.cache.size());
            stringBuffer.append(" ]");
            Set set = this.cache.keySet();
            for (CacheKey cacheKey : set) {
                stringBuffer.append(" [ Key: ");
                stringBuffer.append(cacheKey);
                Node node = (Node)this.cache.get(cacheKey);
                if (node.pinned()) {
                    stringBuffer.append(" Locked by: ");
                    stringBuffer.append("owner");
                }
                stringBuffer.append(" ] ");
            }
        } else {
            stringBuffer.append("Cache is empty for: " + this.cacheName + "\n");
        }
        return stringBuffer.toString();
    }

    protected abstract boolean validateDataStructures();

    private static void debug(String string) {
        debugLogger.debug("[BaseCache] " + string);
    }

    protected static class Node {
        private EnterpriseBean bean = null;
        private CacheKey key = null;
        private CachingManager callback = null;
        private int size;
        private final int FREE = 0;
        private final int INACTIVE = 1;
        private final int ACTIVE = 2;
        private int state = 0;
        private long lastTouchedAt;
        private boolean pinned = false;
        Node prev = null;
        Node next = null;

        Node() {
            this.touch();
        }

        void touch() {
            this.lastTouchedAt = System.currentTimeMillis();
        }

        long timeSinceLastTouch() {
            return Math.abs(System.currentTimeMillis() - this.lastTouchedAt);
        }

        boolean idleLongerThan(long l) {
            long l2 = this.timeSinceLastTouch();
            return l2 > l;
        }

        void pin() {
            if (debugLogger.isDebugEnabled()) {
                BaseCache.debug("PINNING key: " + this.key);
            }
            this.pinned = true;
        }

        void unpin() {
            if (debugLogger.isDebugEnabled()) {
                BaseCache.debug("UNPINNING key: " + this.key);
            }
            assert (this.pinned);
            this.pinned = false;
        }

        boolean pinned() {
            return this.pinned;
        }

        EnterpriseBean getBean() {
            return this.bean;
        }

        void setBean(EnterpriseBean enterpriseBean) {
            this.bean = enterpriseBean;
        }

        CacheKey getKey() {
            return this.key;
        }

        void setKey(CacheKey cacheKey) {
            this.key = cacheKey;
            if (this.key != null) {
                this.callback = cacheKey.getCallback();
                this.size = this.callback.getBeanSize();
            } else {
                this.callback = null;
            }
        }

        CachingManager getCallback() {
            return this.callback;
        }

        int getSize() {
            return this.size;
        }

        boolean olderThan(long l) {
            return this.lastTouchedAt < l;
        }

        void setActive() {
            this.state = 2;
        }

        void setInActive() {
            this.state = 1;
        }

        void setFree() {
            this.state = 0;
        }

        boolean isActive() {
            return this.state == 2;
        }

        boolean isFree() {
            return this.state == 0;
        }

        boolean isInActive() {
            return this.state == 1;
        }
    }
}

