/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import weblogic.ejb.container.interfaces.CachingManager;

public final class CacheKey {
    private final Object pk;
    private final CachingManager callback;
    private final int hashCode;

    public CacheKey(Object object, CachingManager cachingManager) {
        assert (object != null);
        assert (cachingManager != null);
        this.pk = object;
        this.callback = cachingManager;
        this.hashCode = object.hashCode() ^ cachingManager.hashCode();
        assert (this.equals(this));
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CacheKey) {
            CacheKey cacheKey = (CacheKey)object;
            return this.hashCode == cacheKey.hashCode && CacheKey.eq(this.pk, cacheKey.pk) && CacheKey.eq(this.callback, cacheKey.callback);
        }
        return false;
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public CachingManager getCallback() {
        return this.callback;
    }

    public String toString() {
        return "(" + this.pk + ", " + this.callback + ")";
    }
}

