/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public class CacheScrubberTimer {
    private TimerListener listener;
    private static final DebugLogger debugLogger = EJBDebugService.cachingLogger;
    private Timer timer;
    private String cacheName;
    private long scrubInterval;

    public CacheScrubberTimer(TimerListener timerListener, long l, String string) {
        this.listener = timerListener;
        this.cacheName = string;
        this.scrubInterval = l;
    }

    public void setScrubInterval(long l) {
        this.scrubInterval = l;
    }

    public void resetScrubInterval(long l) {
        if (this.timer == null) {
            this.startScrubber(l, l);
            return;
        }
        assert (this.timer != null);
        while (!this.timer.isCancelled()) {
            try {
                this.timer.cancel();
            }
            catch (Exception exception) {
                EJBLogger.logErrorStoppingCacheTimer((String)this.cacheName, (String)exception.getMessage());
            }
        }
        long l2 = this.timer.getTimeout() - System.currentTimeMillis();
        long l3 = l - l2;
        if (l3 < 0L) {
            l3 = 0L;
        }
        this.timer = null;
        this.startScrubber(l, l3);
    }

    public void stopScrubber() {
        if (this.timer != null) {
            if (debugLogger.isDebugEnabled()) {
                this.debug(this.cacheName + "  " + " STOP SCRUBBER \n");
            }
            try {
                this.timer.cancel();
            }
            catch (Exception exception) {
                EJBLogger.logErrorStoppingCacheTimer((String)this.cacheName, (String)exception.getMessage());
            }
            this.timer = null;
        }
    }

    public void startScrubber() {
        this.startScrubber(this.scrubInterval, this.scrubInterval);
    }

    private void startScrubber(long l, long l2) {
        if (l <= 0L) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            this.debug(this.cacheName + " startScrubber()  period == " + l + " delay == " + l2 + " register timer.");
        }
        if (this.timer != null) {
            return;
        }
        try {
            TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
            TimerManager timerManager = timerManagerFactory.getDefaultTimerManager();
            this.timer = timerManager.scheduleAtFixedRate(this.listener, l2, l);
        }
        catch (Exception exception) {
            EJBLogger.logErrorStartingCacheTimer((String)this.cacheName, (String)exception.getMessage());
        }
    }

    private void debug(String string) {
        debugLogger.debug("[" + this.getClass().getName() + "]" + string);
    }
}

