/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.transaction.Transaction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.CacheScrubberTimer;
import weblogic.ejb.container.cache.EntityPassivator;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.container.interfaces.MultiVersionCache;
import weblogic.ejb.container.interfaces.PassivatibleEntityCache;
import weblogic.ejb.container.interfaces.WLEntityBean;
import weblogic.ejb.container.manager.TTLManager;
import weblogic.ejb.container.persistence.spi.CMPBean;
import weblogic.ejb.container.persistence.spi.RSInfo;
import weblogic.ejb.spi.CachingManagerBase;
import weblogic.ejb.spi.ReInitializableCache;
import weblogic.ejb.spi.ScrubbedCache;
import weblogic.ejb20.cache.CacheFullException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.utils.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityCache
implements MultiVersionCache,
PassivatibleEntityCache,
ReInitializableCache,
ScrubbedCache,
TimerListener {
    private static final DebugLogger debugLogger = EJBDebugService.cachingLogger;
    private final ConcurrentHashMap<CacheKey, KeyData> cachedEntitiesByKey = new ConcurrentHashMap();
    private final SizeTracker sizeTracker = new SizeTracker();
    private final boolean usesMaxBeansInCache;
    private long limit;
    private final String cacheName;
    private List<CachingManagerBase> cachingManagers = new ArrayList<CachingManagerBase>();
    private boolean disableReadyCache = false;
    private long scrubIntervalMillisDD;
    private long scrubIntervalMillis;
    private EntityPassivator passivator;
    private CacheScrubberTimer scrubberTimer;

    public EntityCache(String string, int n) {
        this.cacheName = string;
        this.limit = n;
        this.usesMaxBeansInCache = true;
        this.passivator = new EntityPassivator(this);
        this.scrubberTimer = new CacheScrubberTimer(this, 0L, this.cacheName);
        if (debugLogger.isDebugEnabled()) {
            EntityCache.debug(this.cacheName + " Creating EntityCache for " + string + " with " + this.limit);
        }
    }

    public EntityCache(String string, long l) {
        this.cacheName = string;
        this.limit = l;
        this.usesMaxBeansInCache = false;
        this.passivator = new EntityPassivator(this);
        this.scrubberTimer = new CacheScrubberTimer(this, 0L, this.cacheName);
        if (debugLogger.isDebugEnabled()) {
            EntityCache.debug(this.cacheName + " Creating EntityCache for " + string + " with " + this.limit);
        }
    }

    @Override
    public void register(CachingManagerBase cachingManagerBase) {
        if (debugLogger.isDebugEnabled()) {
            EntityCache.debug(this.cacheName + " register CachingManager " + cachingManagerBase);
        }
        if (!this.cachingManagers.contains(cachingManagerBase)) {
            this.cachingManagers.add(cachingManagerBase);
        }
    }

    @Override
    public List<CachingManagerBase> getCachingManagers() {
        return this.cachingManagers;
    }

    @Override
    public int getMaxBeansInCache() {
        return (int)this.limit;
    }

    @Override
    public void setMaxBeansInCache(int n) {
        this.limit = n;
    }

    @Override
    public boolean usesMaxBeansInCache() {
        return this.usesMaxBeansInCache;
    }

    @Override
    public long getMaxCacheSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxCacheSize(long l) {
    }

    public void setDisableReadyCache(boolean bl) {
        this.disableReadyCache = bl;
    }

    @Override
    public long getCurrentSize() {
        return this.sizeTracker.getSize();
    }

    @Override
    public boolean contains(Object object, CacheKey cacheKey) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        return keyData != null && keyData.contains(object);
    }

    @Override
    public EntityBean get(Object object, CacheKey cacheKey, boolean bl) throws InternalException {
        return this.get(object, cacheKey, null, bl);
    }

    public EntityBean getValid(Object object, CacheKey cacheKey, boolean bl) throws InternalException {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        return keyData == null ? null : keyData.getValid(object, bl);
    }

    @Override
    public EntityBean get(Object object, CacheKey cacheKey, RSInfo rSInfo, boolean bl) throws InternalException {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        return keyData == null ? null : keyData.get(object, rSInfo, bl);
    }

    @Override
    public EntityBean getActive(Object object, CacheKey cacheKey, boolean bl) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        return keyData == null ? null : keyData.getActive(object, bl);
    }

    @Override
    public EntityBean getIfNotTimedOut(Object object, CacheKey cacheKey, boolean bl) throws InternalException {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        return keyData == null ? null : keyData.getIfNotTimedOut(object, bl);
    }

    public CMPBean getLastLoadedValidInstance(CacheKey cacheKey) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        return keyData == null ? null : keyData.getLastLoadedValidInstance();
    }

    @Override
    public void put(Object object, CacheKey cacheKey, EntityBean entityBean, CachingManager cachingManager, boolean bl) throws CacheFullException {
        KeyData keyData;
        int n = cachingManager.getBeanSize();
        Transaction transaction = null;
        if (!this.disableReadyCache) {
            if (object instanceof Transaction) {
                transaction = (Transaction)object;
            }
            keyData = this.sizeTracker.acquireSpace(transaction, this.limit, n, n);
            while (keyData != null) {
                keyData.shrink();
                keyData = this.sizeTracker.acquireSpace(transaction, this.limit, n, 0);
            }
        }
        if ((keyData = this.cachedEntitiesByKey.get(cacheKey)) == null) {
            keyData = new KeyData(cachingManager, cacheKey);
        }
        while (keyData != null) {
            keyData = keyData.add(entityBean, object, bl);
        }
    }

    public void unpin(Object object, CacheKey cacheKey) {
        if (this.disableReadyCache) {
            return;
        }
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        if (keyData == null) {
            return;
        }
        keyData.unpin(object);
    }

    @Override
    public void release(Object object, CacheKey cacheKey) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        if (keyData != null) {
            if (this.disableReadyCache) {
                keyData.backToPool(object);
            } else {
                keyData.release(object);
            }
        }
    }

    public int passivateUnModifiedBean(Transaction transaction, CacheKey cacheKey) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        if (debugLogger.isDebugEnabled() && keyData == null) {
            EntityCache.debug(this.cacheName + " passivateUnModifiedBean  pk " + cacheKey.getPrimaryKey() + " is not in cache");
        }
        return keyData == null ? 0 : keyData.passivateUnModifiedBean(transaction);
    }

    public int passivateModifiedBean(Transaction transaction, CacheKey cacheKey, boolean bl) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        if (debugLogger.isDebugEnabled() && keyData == null) {
            EntityCache.debug(this.cacheName + " passivateModifiedBean  pk " + cacheKey.getPrimaryKey() + " is not in cache");
        }
        return keyData == null ? 0 : keyData.passivateModifiedBean(transaction, bl);
    }

    @Override
    public void removeOnError(Object object, CacheKey cacheKey) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        if (keyData != null) {
            keyData.remove(object, true);
        }
    }

    @Override
    public void remove(Object object, CacheKey cacheKey) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        if (keyData != null) {
            keyData.remove(object, false);
        }
    }

    public void invalidate(Object object, CacheKey cacheKey) {
        KeyData keyData = this.cachedEntitiesByKey.get(cacheKey);
        if (keyData == null) {
            return;
        }
        if (debugLogger.isDebugEnabled() && object != null) {
            EntityCache.debug(this.cacheName + " invalidate: skipping invalidate, txOrThread- " + object + ", key- " + cacheKey);
        }
        keyData.invalidate(object);
    }

    public void invalidate(Object object, Collection<CacheKey> collection) {
        for (CacheKey cacheKey : collection) {
            this.invalidate(object, cacheKey);
        }
    }

    public void invalidateAll(Object object) {
        this.invalidate(object, this.cachedEntitiesByKey.keySet());
    }

    public void beanImplClassChangeNotification() {
        Iterator<KeyData> iterator = this.cachedEntitiesByKey.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().keepEnrolled(iterator);
        }
    }

    @Override
    public void updateMaxBeansInCache(int n) {
        if (this.usesMaxBeansInCache) {
            this.limit = n;
        }
    }

    @Override
    public void updateMaxCacheSize(int n) {
        if (!this.usesMaxBeansInCache) {
            this.limit = n;
        }
    }

    @Override
    public void setScrubInterval(int n) {
        if (n > 0) {
            long l = (long)n * 1000L;
            if (this.scrubIntervalMillisDD <= 0L) {
                this.scrubIntervalMillisDD = l;
            } else if (l < this.scrubIntervalMillisDD) {
                this.scrubIntervalMillisDD = l;
            }
            this.scrubIntervalMillis = this.scrubIntervalMillisDD;
            this.scrubberTimer.setScrubInterval(this.scrubIntervalMillisDD);
        }
    }

    @Override
    public void startScrubber() {
        this.scrubberTimer.startScrubber();
    }

    @Override
    public void stopScrubber() {
        this.scrubberTimer.stopScrubber();
    }

    public void timerExpired(Timer timer) {
        int n = this.scrubCache(true);
        if (n <= 0) {
            if (this.scrubIntervalMillis < 120000L) {
                if (debugLogger.isDebugEnabled()) {
                    EntityCache.debug(this.cacheName + " scrubIntervalMillis: " + this.scrubIntervalMillis + " is less than 2 minutes and we've scrubbed" + " no beans.  Doubling the interval till next scrubbing.");
                }
                this.scrubIntervalMillis += this.scrubIntervalMillis;
                this.scrubberTimer.stopScrubber();
                this.scrubberTimer.setScrubInterval(this.scrubIntervalMillis);
                this.scrubberTimer.startScrubber();
            }
        } else if (this.scrubIntervalMillis != this.scrubIntervalMillisDD) {
            if (debugLogger.isDebugEnabled()) {
                EntityCache.debug(this.cacheName + " scrubIntervalMillis: " + this.scrubIntervalMillis + " is not equal to the deployed value " + " and we've scrubbed some beans during this scrubbing event. " + " Resetting scrubInterval to its deployed value: " + this.scrubIntervalMillisDD);
            }
            this.resetScrubberTimerToDeployedValue();
        }
    }

    private void resetScrubberTimerToDeployedValue() {
        this.scrubIntervalMillis = this.scrubIntervalMillisDD;
        this.scrubberTimer.stopScrubber();
        this.scrubberTimer.setScrubInterval(this.scrubIntervalMillis);
        this.scrubberTimer.startScrubber();
    }

    private int scrubCache(boolean bl) {
        long l;
        long l2 = l = System.currentTimeMillis();
        int n = 0;
        long l3 = 0L;
        if (debugLogger.isDebugEnabled()) {
            l3 = this.sizeTracker.getSize();
            EntityCache.debug("\n\n" + this.cacheName + " scrubCache() at " + l + ", cache size: " + l3 + (this.usesMaxBeansInCache ? " beans" : " bytes") + ", start cacheScrub");
        }
        Iterator<KeyData> iterator = this.cachedEntitiesByKey.values().iterator();
        while (iterator.hasNext()) {
            long l4;
            KeyData keyData = iterator.next();
            if (bl) {
                int n2 = keyData.cachingManager.getIdleTimeoutSeconds();
                if (n2 <= 0 || keyData.oldestTimestamp() <= 0L) continue;
                l2 = l - (long)n2 * 1000L;
            }
            if ((l4 = keyData.oldestTimestamp()) <= 0L || l4 > l2) continue;
            n += keyData.shrinkIfExpired(l2, iterator);
        }
        if (debugLogger.isDebugEnabled()) {
            long l5 = System.currentTimeMillis() - l;
            EntityCache.debug(this.cacheName + " scrubCache() completed.  Scrubbed " + n + " beans from cache in " + l5 + " ms." + "  size of cache is now: " + this.sizeTracker.getSize() + (this.usesMaxBeansInCache ? " beans" : " bytes") + " from orig size " + l3 + (this.usesMaxBeansInCache ? " beans" : " bytes") + "\n\n");
        }
        return n;
    }

    @Override
    public void reInitializeCacheAndPools() {
        if (debugLogger.isDebugEnabled()) {
            EntityCache.debug(this.cacheName + " reInitializeCacheAndPools");
        }
        this.reInitializeCache();
        for (CachingManagerBase cachingManagerBase : this.cachingManagers) {
            ((BeanManager)((Object)cachingManagerBase)).reInitializePool();
        }
    }

    public void reInitializeCache() {
        this.scrubCache(false);
        if (this.scrubIntervalMillis != this.scrubIntervalMillisDD) {
            this.resetScrubberTimerToDeployedValue();
        }
    }

    public synchronized void printDataStructures() {
        System.out.println("ready--------------------------------------------");
        for (KeyData keyData : this.cachedEntitiesByKey.values()) {
            keyData.print(true);
        }
        System.out.println("active--------------------------------------------");
        for (KeyData keyData : this.cachedEntitiesByKey.values()) {
            keyData.print(false);
        }
        System.out.println("-------------------------------------------------");
    }

    public void updateIdleTimeoutSeconds(int n) {
        this.scrubberTimer.resetScrubInterval((long)n * 1000L);
    }

    private static void debug(String string) {
        debugLogger.debug("[EntityCache] " + string);
    }

    static final class BeanData
    extends MRUElement {
        BeanData next;
        final EntityBean bean;
        Object txOrThread;
        long timestamp;
        int pinCount;

        BeanData(EntityBean entityBean, Object object) {
            this.txOrThread = object;
            this.bean = entityBean;
        }

        public boolean associatedWith(Object object) {
            return object == this.txOrThread || object.equals(this.txOrThread);
        }

        void enroll(Object object) {
            this.txOrThread = object;
            super.remove();
        }

        void release() {
            this.txOrThread = null;
            this.timestamp = System.currentTimeMillis();
            this.pinCount = 0;
        }

        int pin() {
            return this.pinCount++;
        }

        int unpin() {
            assert (this.pinCount > 0) : " Error ! attempt to unpin bean with pinCount == " + this.pinCount + ", bean: " + this.bean;
            return this.pinCount--;
        }

        boolean isPinned() {
            return this.pinCount > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyData
    extends MRUElement {
        final CacheKey key;
        final CachingManager cachingManager;
        final boolean attemptCopy;
        final boolean categoryEnabled;
        private final Ring readyRing = new Ring();
        private BeanData activeBeanList;

        KeyData(CachingManager cachingManager, CacheKey cacheKey) {
            this.cachingManager = cachingManager;
            this.key = cacheKey;
            if (cachingManager instanceof TTLManager) {
                this.attemptCopy = ((TTLManager)cachingManager).supportsCopy();
                this.categoryEnabled = ((TTLManager)cachingManager).isCategoryEnabled();
            } else {
                this.attemptCopy = false;
                this.categoryEnabled = false;
            }
        }

        boolean isEmpty() {
            return this.activeBeanList == null && this.readyRing.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KeyData add(EntityBean entityBean, Object object, boolean bl) {
            BeanData beanData = new BeanData(entityBean, object);
            KeyData keyData = this;
            synchronized (keyData) {
                if (bl && !EntityCache.this.disableReadyCache) {
                    beanData.pin();
                }
                boolean bl2 = !this.isEmpty();
                beanData.next = this.activeBeanList;
                this.activeBeanList = beanData;
                if (bl2) {
                    return null;
                }
                return EntityCache.this.cachedEntitiesByKey.putIfAbsent(this.key, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(Object object) {
            BeanData beanData;
            boolean bl = false;
            Object object2 = this;
            synchronized (object2) {
                beanData = this.getAndUnlinkBeanForTxOrThread(object);
                if (beanData == null) {
                    return;
                }
                if (!this.cachingManager.needsRemoval((EnterpriseBean)beanData.bean)) {
                    if (this.readyRing.isEmpty()) {
                        EntityCache.this.sizeTracker.insertKeyData(this);
                    } else {
                        EntityCache.this.sizeTracker.moveKeyDataToHead(this);
                    }
                    beanData.release();
                    this.readyRing.insert(beanData);
                    bl = true;
                }
                if (!bl) {
                    EntityCache.this.sizeTracker.decrementSize(this.cachingManager.getBeanSize());
                    if (this.isEmpty()) {
                        EntityCache.this.cachedEntitiesByKey.remove(this.key);
                    }
                }
            }
            if (!bl) {
                this.cachingManager.selectedForReplacement(this.key, beanData.bean);
            }
            if (this.categoryEnabled) {
                object2 = (TTLManager)this.cachingManager;
                Object object3 = ((TTLManager)object2).getCategoryValue((CMPBean)beanData.bean);
                long l = ((WLEntityBean)beanData.bean).__WL_getLastLoadTime();
                ((TTLManager)object2).registerCategoryTimer(object3, l);
            }
        }

        BeanData getBeanForTxOrThread(Object object) {
            BeanData beanData = this.activeBeanList;
            while (beanData != null && !beanData.associatedWith(object)) {
                beanData = beanData.next;
            }
            return beanData;
        }

        BeanData getAndUnlinkBeanForTxOrThread(Object object) {
            BeanData beanData = this.activeBeanList;
            BeanData beanData2 = null;
            while (beanData != null && !beanData.associatedWith(object)) {
                beanData2 = beanData;
                beanData = beanData.next;
            }
            if (beanData != null) {
                if (beanData == this.activeBeanList) {
                    this.activeBeanList = beanData.next;
                } else {
                    beanData2.next = beanData.next;
                }
            }
            return beanData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        EntityBean getIfNotTimedOut(Object object, boolean bl) throws InternalException {
            EntityBean entityBean = null;
            BeanData beanData = null;
            KeyData keyData = this;
            synchronized (keyData) {
                block17: {
                    BeanData beanData2;
                    beanData = this.getBeanForTxOrThread(object);
                    if (beanData != null) {
                        return beanData.bean;
                    }
                    MRUElement mRUElement = this.readyRing.fwd;
                    if (mRUElement == this.readyRing) {
                        return null;
                    }
                    while (mRUElement != this.readyRing) {
                        beanData2 = (BeanData)mRUElement;
                        WLEntityBean wLEntityBean = (WLEntityBean)beanData2.bean;
                        if (wLEntityBean.__WL_isBeanStateValid()) {
                            beanData = beanData2;
                            break block17;
                        }
                        mRUElement = mRUElement.fwd;
                    }
                    if (!this.attemptCopy) return null;
                    beanData2 = null;
                    long l = -1L;
                    BeanData beanData3 = this.activeBeanList;
                    while (beanData3 != null) {
                        long l2 = ((WLEntityBean)beanData3.bean).__WL_getLastLoadTime();
                        if (l2 > l) {
                            l = l2;
                            beanData2 = beanData3;
                        }
                        beanData3 = beanData3.next;
                    }
                    if (beanData2 == null || !((WLEntityBean)beanData2.bean).__WL_isBeanStateValid()) return null;
                    beanData = (BeanData)this.readyRing.fwd;
                    try {
                        ((TTLManager)this.cachingManager).doCopy((CMPBean)beanData2.bean, (CMPBean)beanData.bean);
                    }
                    catch (InternalException internalException) {
                        mRUElement.remove();
                        this.cleanupFailedBean((BeanData)mRUElement);
                        throw internalException;
                    }
                }
                entityBean = this.enroll(beanData, object, bl);
            }
            try {
                keyData = null;
                if (object instanceof Transaction) {
                    keyData = (Transaction)object;
                }
                ((TTLManager)this.cachingManager).enrollNotTimedOutBean((Transaction)keyData, this.key, entityBean);
                return entityBean;
            }
            catch (InternalException internalException) {
                this.cachingManager.removedOnError(this.key, (EnterpriseBean)entityBean);
                if (!EntityCache.this.disableReadyCache) {
                    EntityCache.this.sizeTracker.decrementSize(this.cachingManager.getBeanSize());
                }
                if (!this.isEmpty()) throw internalException;
                EntityCache.this.cachedEntitiesByKey.remove(this.key);
                throw internalException;
            }
        }

        private void cleanupFailedBean(BeanData beanData) {
            this.cachingManager.removedOnError(this.key, (EnterpriseBean)beanData.bean);
            if (!EntityCache.this.disableReadyCache) {
                if (this.readyRing.isEmpty()) {
                    EntityCache.this.sizeTracker.removeKeyData(this, this.cachingManager.getBeanSize());
                } else {
                    EntityCache.this.sizeTracker.decrementSize(this.cachingManager.getBeanSize());
                }
            }
            if (this.isEmpty()) {
                EntityCache.this.cachedEntitiesByKey.remove(this.key);
            }
        }

        public synchronized CMPBean getLastLoadedValidInstance() {
            long l;
            WLEntityBean wLEntityBean;
            WLEntityBean wLEntityBean2 = null;
            long l2 = -1L;
            MRUElement mRUElement = this.activeBeanList;
            while (mRUElement != null) {
                wLEntityBean = (WLEntityBean)mRUElement.bean;
                l = wLEntityBean.__WL_getLastLoadTime();
                if (l > l2) {
                    l2 = l;
                    wLEntityBean2 = wLEntityBean;
                }
                mRUElement = mRUElement.next;
            }
            if (wLEntityBean2 != null && wLEntityBean2.__WL_isBeanStateValid()) {
                return (CMPBean)wLEntityBean2;
            }
            wLEntityBean2 = null;
            mRUElement = this.readyRing.fwd;
            while (mRUElement != this.readyRing) {
                wLEntityBean = (WLEntityBean)mRUElement.bean;
                l = wLEntityBean.__WL_getLastLoadTime();
                if (l > l2) {
                    l2 = l;
                    wLEntityBean2 = wLEntityBean;
                }
                mRUElement = mRUElement.fwd;
            }
            if (wLEntityBean2 != null && !wLEntityBean2.__WL_isBeanStateValid()) {
                wLEntityBean2 = null;
            }
            return (CMPBean)wLEntityBean2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void backToPool(Object object) {
            BeanData beanData;
            KeyData keyData = this;
            synchronized (keyData) {
                beanData = this.activeBeanList;
                if (beanData == null) {
                    return;
                }
                if (object == beanData.txOrThread || object.equals(beanData.txOrThread)) {
                    this.activeBeanList = beanData.next;
                } else {
                    do {
                        BeanData beanData2 = beanData;
                        beanData = beanData.next;
                        if (beanData != null) continue;
                        return;
                    } while (object != beanData.txOrThread && !object.equals(beanData.txOrThread));
                    beanData2.next = beanData.next;
                }
                if (this.isEmpty()) {
                    EntityCache.this.cachedEntitiesByKey.remove(this.key);
                }
            }
            this.cachingManager.passivateAndBacktoPool(this.key, beanData.bean);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Object object, boolean bl) {
            BeanData beanData;
            KeyData keyData = this;
            synchronized (keyData) {
                beanData = this.activeBeanList;
                if (beanData == null) {
                    return;
                }
                if (object == beanData.txOrThread || object.equals(beanData.txOrThread)) {
                    this.activeBeanList = beanData.next;
                } else {
                    do {
                        BeanData beanData2 = beanData;
                        beanData = beanData.next;
                        if (beanData != null) continue;
                        return;
                    } while (object != beanData.txOrThread && !object.equals(beanData.txOrThread));
                    beanData2.next = beanData.next;
                }
                if (this.isEmpty()) {
                    EntityCache.this.cachedEntitiesByKey.remove(this.key);
                }
                EntityCache.this.sizeTracker.decrementSize(this.cachingManager.getBeanSize());
            }
            if (bl) {
                this.cachingManager.removedOnError(this.key, (EnterpriseBean)beanData.bean);
            } else {
                this.cachingManager.removedFromCache(this.key, (EnterpriseBean)beanData.bean);
            }
        }

        synchronized void invalidate(Object object) {
            MRUElement mRUElement = this.activeBeanList;
            while (mRUElement != null) {
                if (object == null || object != mRUElement.txOrThread && !object.equals(mRUElement.txOrThread)) {
                    ((WLEntityBean)mRUElement.bean).__WL_setBeanStateValid(false);
                }
                mRUElement = mRUElement.next;
            }
            mRUElement = this.readyRing.fwd;
            while (mRUElement != this.readyRing) {
                ((WLEntityBean)mRUElement.bean).__WL_setBeanStateValid(false);
                mRUElement = mRUElement.fwd;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntityBean get(Object object, RSInfo rSInfo, boolean bl) throws InternalException {
            EntityBean entityBean = this.getActive(object, bl);
            if (entityBean != null) {
                if (rSInfo != null) {
                    this.cachingManager.loadBeanFromRS(this.key, entityBean, rSInfo);
                }
                return entityBean;
            }
            if (EntityCache.this.disableReadyCache) {
                return null;
            }
            KeyData keyData = this;
            synchronized (keyData) {
                BeanData beanData;
                block16: {
                    BeanData beanData2;
                    MRUElement mRUElement = this.readyRing.fwd;
                    if (mRUElement == this.readyRing) {
                        return null;
                    }
                    beanData = null;
                    while (mRUElement != this.readyRing) {
                        beanData2 = (BeanData)mRUElement;
                        WLEntityBean wLEntityBean = (WLEntityBean)beanData2.bean;
                        if (wLEntityBean.__WL_isBeanStateValid()) {
                            beanData = beanData2;
                            break block16;
                        }
                        mRUElement = mRUElement.fwd;
                    }
                    beanData = (BeanData)this.readyRing.fwd;
                    if (this.attemptCopy) {
                        beanData2 = null;
                        long l = -1L;
                        BeanData beanData3 = this.activeBeanList;
                        while (beanData3 != null) {
                            long l2 = ((WLEntityBean)beanData3.bean).__WL_getLastLoadTime();
                            if (l2 > l) {
                                l = l2;
                                beanData2 = beanData3;
                            }
                            beanData3 = beanData3.next;
                        }
                        if (beanData2 != null && ((WLEntityBean)beanData2.bean).__WL_isBeanStateValid()) {
                            try {
                                ((TTLManager)this.cachingManager).doCopy((CMPBean)beanData2.bean, (CMPBean)beanData.bean);
                            }
                            catch (InternalException internalException) {
                                mRUElement.remove();
                                this.cleanupFailedBean((BeanData)mRUElement);
                                throw internalException;
                            }
                        }
                    }
                }
                entityBean = this.enroll(beanData, object, bl);
            }
            keyData = null;
            if (!(object instanceof Transaction)) {
                return entityBean;
            }
            keyData = (Transaction)object;
            this.cachingManager.enrollInTransaction((Transaction)keyData, this.key, entityBean, rSInfo);
            return entityBean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntityBean getValid(Object object, boolean bl) throws InternalException {
            EntityBean entityBean = this.getActive(object, bl);
            if (entityBean != null) {
                return entityBean;
            }
            if (EntityCache.this.disableReadyCache) {
                return null;
            }
            KeyData keyData = this;
            synchronized (keyData) {
                MRUElement mRUElement = this.readyRing.fwd;
                if (mRUElement == this.readyRing) {
                    return null;
                }
                while (mRUElement != this.readyRing && !((WLEntityBean)((BeanData)mRUElement).bean).__WL_isBeanStateValid()) {
                    mRUElement = mRUElement.fwd;
                }
                if (mRUElement == this.readyRing) {
                    return null;
                }
                entityBean = this.enroll((BeanData)mRUElement, object, bl);
            }
            keyData = null;
            if (!(object instanceof Transaction)) {
                return entityBean;
            }
            keyData = (Transaction)object;
            this.cachingManager.enrollInTransaction((Transaction)keyData, this.key, entityBean, null);
            return entityBean;
        }

        private final EntityBean enroll(BeanData beanData, Object object, boolean bl) {
            beanData.next = this.activeBeanList;
            this.activeBeanList = beanData;
            beanData.enroll(object);
            if (bl && !EntityCache.this.disableReadyCache) {
                beanData.pin();
            }
            if (this.readyRing.fwd == this.readyRing) {
                EntityCache.this.sizeTracker.removeKeyData(this);
            }
            return beanData.bean;
        }

        synchronized EntityBean getActive(Object object, boolean bl) {
            if (object == null) {
                return null;
            }
            BeanData beanData = this.getBeanForTxOrThread(object);
            if (beanData != null) {
                if (bl && !EntityCache.this.disableReadyCache) {
                    beanData.pin();
                }
                return beanData.bean;
            }
            return null;
        }

        boolean contains(Object object) {
            return this.getBeanForTxOrThread(object) != null;
        }

        synchronized void unpin(Object object) {
            if (EntityCache.this.disableReadyCache) {
                return;
            }
            BeanData beanData = this.getBeanForTxOrThread(object);
            if (beanData != null) {
                beanData.unpin();
            }
        }

        int passivateUnModifiedBean(Transaction transaction) {
            return this.passivateBean(transaction, false, false);
        }

        int passivateModifiedBean(Transaction transaction, boolean bl) {
            return this.passivateBean(transaction, true, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int passivateBean(Transaction transaction, boolean bl, boolean bl2) {
            BeanData beanData = null;
            KeyData keyData = this;
            synchronized (keyData) {
                beanData = this.getBeanForTxOrThread(transaction);
                if (beanData == null) {
                    if (debugLogger.isDebugEnabled()) {
                        EntityCache.debug(EntityCache.this.cacheName + " passivateBean: bean pk " + this.key + ", is not in cache.  Cannot passivate.");
                    }
                    return 0;
                }
                if (beanData.isPinned()) {
                    if (debugLogger.isDebugEnabled()) {
                        EntityCache.debug(EntityCache.this.cacheName + " passivateBean: bean pk " + this.key + ", is pinned.  Cannot passivate.");
                    }
                    return 0;
                }
                boolean bl3 = false;
                bl3 = bl ? this.cachingManager.passivateLockedModifiedBean(transaction, this.key.getPrimaryKey(), bl2, beanData.bean) : this.cachingManager.passivateLockedUnModifiedBean(transaction, this.key.getPrimaryKey(), beanData.bean);
                if (!bl3) {
                    if (debugLogger.isDebugEnabled()) {
                        EntityCache.debug(EntityCache.this.cacheName + " passivateBean: bean pk " + this.key + ", is not passivatible.");
                    }
                    return 0;
                }
                this.getAndUnlinkBeanForTxOrThread(transaction);
                if (this.isEmpty()) {
                    EntityCache.this.cachedEntitiesByKey.remove(this.key);
                }
                if (!EntityCache.this.disableReadyCache) {
                    EntityCache.this.sizeTracker.decrementSize(this.cachingManager.getBeanSize());
                }
            }
            this.cachingManager.passivateAndRelease(this.key, beanData.bean);
            return this.cachingManager.getBeanSize();
        }

        synchronized void keepEnrolled(Iterator<KeyData> iterator) {
            int n = this.cachingManager.getBeanSize();
            int n2 = 0;
            MRUElement mRUElement = this.readyRing.fwd;
            while (mRUElement != this.readyRing) {
                this.cachingManager.selectedForReplacement(this.key, ((BeanData)mRUElement).bean);
                n2 += n;
                mRUElement = mRUElement.fwd;
            }
            EntityCache.this.sizeTracker.removeKeyData(this, n2);
            this.readyRing.reset();
            if (this.activeBeanList == null) {
                iterator.remove();
            }
        }

        synchronized void print(boolean bl) {
            if (bl) {
                BeanData beanData = this.activeBeanList;
                while (beanData != null) {
                    System.out.println("key= " + this.key + ", bean= " + beanData.bean);
                    beanData = beanData.next;
                }
                return;
            }
            MRUElement mRUElement = this.readyRing.fwd;
            while (mRUElement != this.readyRing) {
                System.out.println("key= " + this.key + ", bean= " + ((BeanData)mRUElement).bean);
                mRUElement = mRUElement.fwd;
            }
        }

        synchronized int validateDataStructures(CacheKey cacheKey, SizeTracker sizeTracker) {
            Debug.assertion((boolean)this.key.equals(cacheKey));
            int n = 0;
            MRUElement mRUElement = this.activeBeanList;
            while (mRUElement != null) {
                Debug.assertion((mRUElement.txOrThread != null ? 1 : 0) != 0);
                ++n;
                mRUElement = mRUElement.next;
            }
            mRUElement = this.readyRing.fwd;
            while (mRUElement != this.readyRing) {
                Debug.assertion((mRUElement.txOrThread == null ? 1 : 0) != 0);
                ++n;
                mRUElement = mRUElement.fwd;
            }
            Debug.assertion((this.readyRing.isEmpty() != sizeTracker.contains(this) ? 1 : 0) != 0);
            return n;
        }

        long oldestTimestamp() {
            MRUElement mRUElement = this.readyRing.bwd;
            if (mRUElement == this.readyRing) {
                return 0L;
            }
            return ((BeanData)mRUElement).timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shrink() {
            MRUElement mRUElement;
            KeyData keyData = this;
            synchronized (keyData) {
                mRUElement = this.readyRing.bwd;
                if (mRUElement == this.readyRing) {
                    return;
                }
                if (debugLogger.isDebugEnabled()) {
                    EntityCache.debug(EntityCache.this.cacheName + " shrink:  removing " + this.key.getPrimaryKey() + " from active ring ");
                }
                mRUElement.remove();
                if (this.readyRing.isEmpty()) {
                    EntityCache.this.sizeTracker.removeKeyData(this, this.cachingManager.getBeanSize());
                    if (this.activeBeanList == null) {
                        EntityCache.this.cachedEntitiesByKey.remove(this.key);
                    }
                } else {
                    EntityCache.this.sizeTracker.decrementSize(this.cachingManager.getBeanSize());
                }
            }
            this.cachingManager.selectedForReplacement(this.key, ((BeanData)mRUElement).bean);
        }

        synchronized int shrinkIfExpired(long l, Iterator<KeyData> iterator) {
            int n = 0;
            MRUElement mRUElement = this.readyRing.bwd;
            int n2 = this.cachingManager.getBeanSize();
            while (mRUElement != this.readyRing && ((BeanData)mRUElement).timestamp < l) {
                mRUElement.remove();
                ++n;
                if (this.readyRing.isEmpty()) {
                    if (!EntityCache.this.disableReadyCache) {
                        EntityCache.this.sizeTracker.removeKeyData(this, n2);
                    }
                    if (this.activeBeanList == null) {
                        iterator.remove();
                    }
                } else if (!EntityCache.this.disableReadyCache) {
                    EntityCache.this.sizeTracker.decrementSize(n2);
                }
                this.cachingManager.selectedForReplacement(this.key, ((BeanData)mRUElement).bean);
                mRUElement = this.readyRing.bwd;
            }
            return n;
        }
    }

    final class SizeTracker
    extends Ring {
        private long size = 0L;

        SizeTracker() {
        }

        synchronized void decrementSize(int n) {
            this.size -= (long)n;
        }

        synchronized void insertKeyData(KeyData keyData) {
            this.insert(keyData);
        }

        synchronized void removeKeyData(KeyData keyData) {
            keyData.remove();
        }

        synchronized void removeKeyData(KeyData keyData, int n) {
            keyData.remove();
            this.size -= (long)n;
        }

        synchronized void moveKeyDataToHead(KeyData keyData) {
            keyData.remove();
            this.insert(keyData);
        }

        synchronized long getSize() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected KeyData acquireSpace(Transaction transaction, long l, int n, int n2) throws CacheFullException {
            Object object = this;
            synchronized (object) {
                this.size += (long)n2;
                if (debugLogger.isDebugEnabled()) {
                    EntityCache.debug(EntityCache.this.cacheName + " shrinkNext: increased cache size is now " + this.size + ", size limit is " + l);
                }
                if (this.size <= l) {
                    return null;
                }
                MRUElement mRUElement = this.bwd;
                if (mRUElement != this) {
                    mRUElement.remove();
                    this.insert(mRUElement);
                    return (KeyData)mRUElement;
                }
            }
            object = EntityCache.this.passivator;
            synchronized (object) {
                if (this.size <= l) {
                    return null;
                }
                if (debugLogger.isDebugEnabled()) {
                    EntityCache.debug(EntityCache.this.cacheName + " cache full at size: " + this.size + ", begin passivation of beans in tx. ");
                }
                long l2 = EntityCache.this.passivator.passivate(transaction, l, n);
                if (debugLogger.isDebugEnabled()) {
                    EntityCache.debug(EntityCache.this.cacheName + " after passivate, cache size is now " + this.size);
                }
                if (l2 >= (long)n) {
                    return null;
                }
                this.decrementSize(n);
                throw new CacheFullException("cache size after cleaning=" + this.size + ", max allowable cache size=" + l + ", extra free space required but not obtainable = " + n);
            }
        }
    }

    static class Ring
    extends MRUElement {
        Ring() {
            this.reset();
        }

        final boolean isEmpty() {
            return this.fwd == this;
        }

        final void reset() {
            this.fwd = this.bwd = this;
        }

        final synchronized boolean contains(MRUElement mRUElement) {
            MRUElement mRUElement2 = this.fwd;
            while (mRUElement2 != this) {
                if (mRUElement2 == mRUElement) {
                    return true;
                }
                mRUElement2 = mRUElement2.fwd;
            }
            return false;
        }

        final void insert(MRUElement mRUElement) {
            mRUElement.fwd = this.fwd;
            mRUElement.bwd = this;
            this.fwd.bwd = mRUElement;
            this.fwd = mRUElement;
        }
    }

    static class MRUElement {
        MRUElement fwd;
        MRUElement bwd;

        MRUElement() {
        }

        final void remove() {
            this.bwd.fwd = this.fwd;
            this.fwd.bwd = this.bwd;
            this.bwd = null;
            this.fwd = null;
        }
    }
}

