/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.Transaction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.TxKey;
import weblogic.ejb.container.cache.TxPk;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.container.interfaces.PassivatibleEntityCache;
import weblogic.ejb.container.utils.PartialOrderSet;

public final class EntityPassivator {
    static final String DISABLE_ENTITY_PASSIVATION_IN_TX_PROP = "weblogic.ejb.container.cache.disable_entity_passivation_in_tx";
    private static final boolean disable_entity_passivation_in_tx = System.getProperty("weblogic.ejb.container.cache.disable_entity_passivation_in_tx") != null;
    private static final DebugLogger debugLogger = EJBDebugService.cachingLogger;
    private final PassivatibleEntityCache cache;

    public EntityPassivator(PassivatibleEntityCache passivatibleEntityCache) {
        this.cache = passivatibleEntityCache;
    }

    public long passivate(Transaction transaction, long l, int n) {
        long l2;
        if (disable_entity_passivation_in_tx) {
            if (debugLogger.isDebugEnabled()) {
                EntityPassivator.debug("Passivation of Entity Beans in a transaction is disabled.  Skipping Entity passivation.");
            }
            return 0L;
        }
        assert (n > 0) : "Bean Size " + n + " is <= 0, it must be greater than 0 !!";
        long l3 = (long)((double)(l / (long)n) * 0.01);
        long l4 = 10 * n;
        long l5 = l2 = l3 > l4 ? l3 : l4;
        if (debugLogger.isDebugEnabled()) {
            EntityPassivator.debug(" passivate in our tx with target: " + l2);
        }
        long l6 = 0L;
        l6 = this.passivateInOurTx(transaction, l2);
        if (debugLogger.isDebugEnabled()) {
            EntityPassivator.debug(" After passivation in our tx we've freed " + l6);
        }
        if (l6 >= l2) {
            return l6;
        }
        l6 += this.passivateNotInOurTx(transaction, l2 - l6);
        if (debugLogger.isDebugEnabled()) {
            EntityPassivator.debug(" After passivation NOT in our tx we've freed " + l6);
        }
        return l6;
    }

    private long passivateInOurTx(Transaction transaction, long l) {
        boolean bl;
        boolean bl2;
        Object object;
        LinkedList<CacheKey> linkedList;
        ArrayList arrayList;
        CachingManager cachingManager22;
        long l2;
        block25: {
            l2 = 0L;
            cachingManager22 = null;
            arrayList = new ArrayList();
            this.setInTxManagers(transaction, arrayList);
            if (debugLogger.isDebugEnabled()) {
                EntityPassivator.debug("\n\n+++ begin passivation in our Tx of unModified ops complete beans.\n\n");
            }
            linkedList = new LinkedList<CacheKey>();
            for (CachingManager cachingManager22 : arrayList) {
                PartialOrderSet partialOrderSet = cachingManager22.getTxManager().getEnrolledKeys(transaction);
                if (partialOrderSet == null) continue;
                Iterator object2 = partialOrderSet.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (cachingManager22.isFlushPending(transaction, object)) continue;
                    if (cachingManager22.beanIsOpsComplete(transaction, object)) {
                        l2 += (long)cachingManager22.passivateUnModifiedBean(transaction, object);
                        if (debugLogger.isDebugEnabled()) {
                            EntityPassivator.debug("passivate target is " + l + ", and we have freed = " + l2 + ", after opsComplete cm.passivateUnModifiedBean on pk " + object);
                        }
                        if (l2 < l) continue;
                        return l2;
                    }
                    linkedList.add(new CacheKey(object, cachingManager22));
                }
            }
            if (debugLogger.isDebugEnabled()) {
                EntityPassivator.debug("\n\n+++ begin passivation in our Tx of unModified non-ops complete beans.\n");
            }
            if (linkedList.size() > 0) {
                for (CacheKey bl22 : linkedList) {
                    l2 += (long)bl22.getCallback().passivateUnModifiedBean(transaction, bl22.getPrimaryKey());
                    if (debugLogger.isDebugEnabled()) {
                        EntityPassivator.debug("passivate target is " + l + ", and we have freed = " + l2 + ", after non-opsComplete cm.passivateUnModifiedBean on pk " + bl22.getPrimaryKey());
                    }
                    if (l2 < l) continue;
                    return l2;
                }
            }
            if (cachingManager22 == null) {
                return l2;
            }
            if (debugLogger.isDebugEnabled()) {
                EntityPassivator.debug("\n\n+++ begin passivation in our Tx of modified beans.\n");
            }
            bl2 = false;
            try {
                if (debugLogger.isDebugEnabled()) {
                    EntityPassivator.debug("\n\n+++ flush modified beans \n");
                }
                cachingManager22.getTxManager().flushModifiedBeans(transaction, true);
                bl2 = true;
            }
            catch (Throwable throwable) {
                if (!debugLogger.isDebugEnabled()) break block25;
                EntityPassivator.debug("\n flushModifiedBeans, ourTx " + transaction + "\n resulted in Throwable " + throwable.toString() + "\n");
            }
        }
        if (debugLogger.isDebugEnabled()) {
            EntityPassivator.debug("\n flush modified success: " + (bl2 ? "true" : "false"));
        }
        linkedList.clear();
        boolean bl3 = false;
        Iterator iterator = arrayList.iterator();
        block5: while (iterator.hasNext() && !bl) {
            cachingManager22 = (CachingManager)iterator.next();
            object = cachingManager22.getTxManager().getFlushedKeys(transaction);
            if (object == null || object.size() <= 0) continue;
            if (debugLogger.isDebugEnabled()) {
                EntityPassivator.debug("\n\n+++ processing " + object.size() + " flushed ops complete beans\n");
            }
            for (Object e : object) {
                if (cachingManager22.beanIsOpsComplete(transaction, e)) {
                    l2 += (long)cachingManager22.passivateModifiedBean(transaction, e, bl2);
                    if (debugLogger.isDebugEnabled()) {
                        EntityPassivator.debug("passivate target is " + l + ", and we have freed = " + l2 + ", after flushed bean cm.passivateModifiedBean on pk " + e);
                    }
                    if (l2 < l) continue;
                    bl = true;
                    continue block5;
                }
                linkedList.add(new CacheKey(e, cachingManager22));
            }
        }
        if (bl) {
            return l2;
        }
        if (debugLogger.isDebugEnabled()) {
            EntityPassivator.debug("\n\n+++ begin passivation in our Tx of modified non-ops complete beans.\n");
        }
        if (linkedList.size() > 0) {
            for (CacheKey cacheKey : linkedList) {
                l2 += (long)cacheKey.getCallback().passivateModifiedBean(transaction, cacheKey.getPrimaryKey(), bl2);
                if (debugLogger.isDebugEnabled()) {
                    EntityPassivator.debug("passivate target is " + l + ", and we have freed = " + l2 + ", after flushed bean cm.passivateModifiedBean on pk " + cacheKey.getPrimaryKey());
                }
                if (l2 < l) continue;
                break;
            }
        }
        return l2;
    }

    private long passivateNotInOurTx(Transaction transaction, long l) {
        if (debugLogger.isDebugEnabled()) {
            EntityPassivator.debug("\n\n +++ passivateNotInOurTx  entered. \n");
        }
        LinkedList<TxKey> linkedList = new LinkedList<TxKey>();
        long l2 = 0L;
        for (CachingManager object : this.cache.getCachingManagers()) {
            ArrayList arrayList = object.getTxManager().getNotModifiedOtherTxKeys(transaction);
            if (debugLogger.isDebugEnabled()) {
                EntityPassivator.debug("\n passivateNotInOurTx got a list of " + arrayList.size() + " not modified, not in our Tx Beans ");
            }
            for (TxPk txPk : arrayList) {
                Object object2;
                Transaction transaction2 = txPk.getTx();
                if (object.beanIsOpsComplete(transaction2, object2 = txPk.getPk())) {
                    l2 += (long)object.passivateUnModifiedBean(transaction2, object2);
                    if (debugLogger.isDebugEnabled()) {
                        EntityPassivator.debug("passivate target is " + l + ", and we have freed = " + l2 + ", after opsComplete, not in our Tx, cm.passivateUnModifiedBean on pk " + object2);
                    }
                    if (l2 < l) continue;
                    return l2;
                }
                linkedList.add(new TxKey(transaction2, new CacheKey(object2, object)));
            }
        }
        if (linkedList.size() > 0) {
            for (TxKey txKey : linkedList) {
                l2 += (long)txKey.getKey().getCallback().passivateUnModifiedBean(txKey.getTx(), txKey.getKey().getPrimaryKey());
                if (debugLogger.isDebugEnabled()) {
                    EntityPassivator.debug("passivate target is " + l + ", and we have freed = " + l2 + ", after non-opsComplete, not in our Tx, cm.passivateUnModifiedBean on pk " + txKey.getKey().getPrimaryKey());
                }
                if (l2 < l) continue;
                return l2;
            }
        }
        return l2;
    }

    private void setInTxManagers(Transaction transaction, List list) {
        if (transaction == null) {
            return;
        }
        for (CachingManager cachingManager : this.cache.getCachingManagers()) {
            if (!cachingManager.hasBeansEnrolledInTx(transaction)) continue;
            if (debugLogger.isDebugEnabled()) {
                EntityPassivator.debug(" adding CachingManager in inTxManagerList: " + cachingManager);
            }
            list.add(cachingManager);
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[EntityPassivator] " + string);
    }
}

