/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EnterpriseBean;
import weblogic.ejb.container.cache.BaseCache;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.spi.CachingManagerBase;
import weblogic.ejb.spi.ReInitializableCache;
import weblogic.ejb20.cache.CacheFullException;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;

public final class LRUCache
extends BaseCache
implements ReInitializableCache {
    private BaseCache.Node lruChainHead;
    private BaseCache.Node lruChainTail;
    private CachingManager cachingManager;

    public LRUCache(String string, int n) {
        super(string, n);
        this.setLruChainTail(null);
        this.setLruChainHead(null);
    }

    public LRUCache(String string, long l) {
        super(string, l);
        this.setLruChainTail(null);
        this.setLruChainHead(null);
    }

    public void register(CachingManagerBase cachingManagerBase) {
        this.cachingManager = (CachingManager)cachingManagerBase;
    }

    public synchronized EnterpriseBean get(CacheKey cacheKey) {
        assert (this.validateDataStructures());
        BaseCache.Node node = null;
        node = (BaseCache.Node)this.cache.get(cacheKey);
        if (node != null) {
            node.touch();
            node.pin();
            this.lruUse(node);
            assert (this.validateDataStructures());
            return node.getBean();
        }
        return null;
    }

    public void releaseEntityBean(BaseCache.Node node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(CacheKey cacheKey, EnterpriseBean enterpriseBean) throws CacheFullException {
        block14: {
            assert (!this.contains(cacheKey));
            List list = null;
            int n = cacheKey.getCallback().getBeanSize();
            long l = this.currentCacheSize + (long)n - this.getMaxCacheSize();
            try {
                if (l > 0L) {
                    list = this.attemptToFreeSpace(l);
                }
                if (this.currentCacheSize + (long)n > this.getMaxCacheSize()) {
                    throw new CacheFullException();
                }
                BaseCache.Node node = new BaseCache.Node();
                node.setBean(enterpriseBean);
                node.setKey(cacheKey);
                node.setActive();
                node.pin();
                BaseCache.Node node2 = this.cache.put(cacheKey, node);
                if (node2 != null) {
                    this.cache.put(cacheKey, node2);
                    throw new AssertionError("Attempt to replace ctx - old ctx: '" + node2 + "', new ctx: " + node + "'");
                }
                this.currentCacheSize += (long)n;
                this.prependToLRU(node);
                if (debugLogger.isDebugEnabled()) {
                    LRUCache.debug("node " + node.getKey() + " is added to cache, size:" + this.currentCacheSize);
                }
                Object var10_8 = null;
                if (list == null) break block14;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (list != null) {
                    for (BaseCache.Node node : list) {
                        assert (!this.inLRUChain(node));
                        node.getCallback().swapOut(node.getKey(), node.getBean());
                        if (!debugLogger.isDebugEnabled()) continue;
                        LRUCache.debug("node " + node.getKey() + " is passivated.");
                    }
                }
                assert (this.validateDataStructures());
                throw throwable;
            }
            for (BaseCache.Node node : list) {
                assert (!this.inLRUChain(node));
                node.getCallback().swapOut(node.getKey(), node.getBean());
                if (!debugLogger.isDebugEnabled()) continue;
                LRUCache.debug("node " + node.getKey() + " is passivated.");
            }
        }
        assert (this.validateDataStructures());
    }

    public void removeOnError(CacheKey cacheKey) {
        throw new AssertionError("removeOnError in LRUCache");
    }

    public synchronized void remove(CacheKey cacheKey) {
        assert (this.validateDataStructures());
        BaseCache.Node node = (BaseCache.Node)this.cache.remove(cacheKey);
        if (debugLogger.isDebugEnabled()) {
            LRUCache.debug("*** Removing key: " + cacheKey);
        }
        if (node == null) {
            return;
        }
        this.currentCacheSize -= (long)node.getSize();
        assert (node.getKey().equals(cacheKey));
        if (node.pinned()) {
            node.unpin();
        }
        this.removeFromLRU(node);
        node.setFree();
        node.getCallback().removedFromCache(cacheKey, node.getBean());
        assert (!this.contains(cacheKey));
    }

    synchronized void cacheScrubber() {
        Iterator iterator = this.getPassivationList();
        if (debugLogger.isDebugEnabled()) {
            LRUCache.debug(" Timer passivating: " + this.cacheName);
        }
        while (iterator.hasNext()) {
            BaseCache.Node node = (BaseCache.Node)iterator.next();
            this.passivateNode(node);
        }
        if (dumpCache) {
            Debug.say((String)this.cacheDump());
        }
    }

    public Iterator getPassivationList() {
        ArrayList<BaseCache.Node> arrayList = new ArrayList<BaseCache.Node>();
        boolean bl = ++this.scrubCount % 5 == 0;
        BaseCache.Node node = this.lruChainTail;
        long l = System.currentTimeMillis() - this.scrubIntervalMillis;
        while (node != null) {
            assert (this.inLRUChain(node));
            BaseCache.Node node2 = node.prev;
            if (node.olderThan(l) && !node.pinned()) {
                this.remove(node.getKey());
                arrayList.add(node);
            } else if (!bl) break;
            node = node2;
        }
        return arrayList.iterator();
    }

    public void reInitializeCacheAndPools() {
        if (debugLogger.isDebugEnabled()) {
            LRUCache.debug(this.cacheName + " reInitializeCacheAndPools, cache size is " + this.cache.size());
        }
        ((BeanManager)((Object)this.cachingManager)).reInitializePool();
        this.reInitializeCache();
        if (debugLogger.isDebugEnabled()) {
            LRUCache.debug(this.cacheName + " cache reInitialization complete, size is " + this.cache.size());
        }
    }

    private synchronized void reInitializeCache() {
        BaseCache.Node node = this.lruChainTail;
        while (node != null) {
            assert (this.inLRUChain(node));
            BaseCache.Node node2 = node.prev;
            if (!node.pinned()) {
                this.remove(node.getKey());
                this.passivateNode(node);
            }
            node = node2;
        }
        if (dumpCache) {
            Debug.say((String)this.cacheDump());
        }
    }

    public void beanImplClassChangeNotification() {
        throw new AssertionError("LRUCache doesn't support bean impl changes");
    }

    public synchronized void updateMaxBeansInCache(int n) {
        if (this.usesMaxBeansInCache()) {
            List list = null;
            this.setMaxBeansInCache(n);
            if (this.getCurrentSize() > (long)n) {
                list = this.attemptToFreeSpace(this.getCurrentSize() - (long)n);
            }
            if (list != null) {
                for (BaseCache.Node node : list) {
                    node.getCallback().swapOut(node.getKey(), node.getBean());
                }
            }
        }
    }

    public void updateMaxCacheSize(int n) {
        throw new AssertionError("LRUCache doesn't support max-cache-size");
    }

    private List attemptToFreeSpace(long l) {
        ArrayList<BaseCache.Node> arrayList = null;
        BaseCache.Node node = this.lruChainTail;
        long l2 = 0L;
        while (l2 < l) {
            while (node != null && node.pinned()) {
                node = node.prev;
            }
            if (node == null) {
                return arrayList;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<BaseCache.Node>();
            }
            arrayList.add(node);
            BaseCache.Node node2 = node;
            node = node.prev;
            this.remove(node2.getKey());
            if (!debugLogger.isDebugEnabled()) continue;
            LRUCache.debug("node " + node.getKey() + " is removed from cache, size:" + this.cache.size());
        }
        return arrayList;
    }

    protected String cacheDump() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.cache.isEmpty()) {
            stringBuffer.append("Dumping EJBCache for: ");
            stringBuffer.append(this.cacheName);
            stringBuffer.append(" [ Cache size: ");
            stringBuffer.append(this.cache.size());
            stringBuffer.append(" ]");
            BaseCache.Node node = this.lruChainHead;
            while (node != null) {
                CacheKey cacheKey = node.getKey();
                stringBuffer.append(" [ PK: ");
                stringBuffer.append(cacheKey);
                if (node.pinned()) {
                    stringBuffer.append(" Locked by: ");
                    stringBuffer.append("owner");
                }
                stringBuffer.append(" ] ");
                node = node.next;
            }
        } else {
            stringBuffer.append("Cache is empty for: " + this.cacheName + "\n");
        }
        return stringBuffer.toString();
    }

    private void chain(BaseCache.Node node, BaseCache.Node node2) {
        if (node != null) {
            node.next = node2;
        }
        if (node2 != null) {
            node2.prev = node;
        }
        if (node2 == this.lruChainHead && node != null) {
            this.setLruChainHead(node);
        }
        if (node == this.lruChainTail && node2 != null) {
            this.setLruChainTail(node2);
        }
    }

    private void prependToLRU(BaseCache.Node node) {
        assert (!this.inLRUChain(node));
        this.chain(null, node);
        this.chain(node, this.lruChainHead);
    }

    private void removeFromLRU(BaseCache.Node node) {
        assert (this.inLRUChain(node));
        BaseCache.Node node2 = node.prev;
        BaseCache.Node node3 = node.next;
        this.chain(node2, node3);
        node.next = null;
        node.prev = null;
        if (node == this.lruChainHead) {
            this.setLruChainHead(node3);
        }
        if (node == this.lruChainTail) {
            this.setLruChainTail(node2);
        }
    }

    private void setLruChainHead(BaseCache.Node node) {
        this.lruChainHead = node;
    }

    private void setLruChainTail(BaseCache.Node node) {
        this.lruChainTail = node;
    }

    private void lruUse(BaseCache.Node node) {
        assert (this.lruUse_assertion(node));
        if (node == this.lruChainHead || node.prev == null) {
            return;
        }
        BaseCache.Node node2 = node.prev;
        BaseCache.Node node3 = node.next;
        this.chain(node2, node3);
        if (node == this.lruChainHead) {
            this.setLruChainHead(node3);
        }
        if (node == this.lruChainTail) {
            this.setLruChainTail(node2);
        }
        this.chain(null, node);
        this.chain(node, this.lruChainHead);
        assert (this.validateDataStructures());
    }

    private boolean lruUse_assertion(BaseCache.Node node) {
        assert (this.inLRUChain(node));
        assert (this.validateDataStructures());
        return true;
    }

    protected boolean validateDataStructures() {
        this.validateLRUChain();
        this.validateCache();
        return true;
    }

    private boolean inLRUChain(BaseCache.Node node) {
        BaseCache.Node node2 = node;
        while (node2 != null) {
            if (node2 == this.lruChainHead) {
                return true;
            }
            node2 = node2.prev;
        }
        return false;
    }

    private void validateCache() {
        BaseCache.Node node = this.lruChainHead;
        int n = 0;
        HashSet<EnterpriseBean> hashSet = new HashSet<EnterpriseBean>();
        long l = 0L;
        while (node != null) {
            EnterpriseBean enterpriseBean = node.getBean();
            assert (this.cache.get(node.getKey()) != null);
            assert (hashSet.add(enterpriseBean));
            l += (long)node.getSize();
            node = node.next;
            ++n;
        }
        assert (n == this.cache.size());
        assert (l == this.currentCacheSize);
    }

    private void validateLRUChain() {
        if (this.lruChainHead == null) {
            assert (this.lruChainTail == null && this.cache.size() == 0 && this.currentCacheSize == 0L) : "lruChainTail = " + this.lruChainTail + ", size = " + this.cache.size() + ", currentCacheSize= " + this.currentCacheSize;
            return;
        }
        if (this.lruChainTail == null) {
            assert (this.lruChainHead == null && this.cache.size() == 0 && this.currentCacheSize == 0L) : "lruChainHead = " + this.lruChainHead + ", size = " + this.cache.size() + ", currentCacheSize= " + this.currentCacheSize;
            return;
        }
        if (this.cache.size() == 0) {
            assert (this.lruChainHead == null && this.lruChainTail == null && this.currentCacheSize == 0L) : "lruChainHead = " + this.lruChainHead + ", lruChainTail = " + this.lruChainTail + ", size = " + this.cache.size() + ", currentCacheSize= " + this.currentCacheSize;
            return;
        }
        if (this.currentCacheSize == 0L) {
            assert (this.lruChainHead == null && this.lruChainTail == null && this.cache.size() == 0) : "lruChainHead = " + this.lruChainHead + ", lruChainTail = " + this.lruChainTail + ", size = " + this.cache.size() + ", currentCacheSize= " + this.currentCacheSize;
            return;
        }
        assert (this.lruChainHead.prev == null);
        assert (this.lruChainTail.next == null);
        int n = 0;
        HashSet<BaseCache.Node> hashSet = new HashSet<BaseCache.Node>();
        BaseCache.Node node = this.lruChainHead;
        while (node != null) {
            ++n;
            assert (hashSet.add(node));
            node = node.next;
        }
        assert (n == this.cache.size());
    }

    private static void debug(String string) {
        debugLogger.debug("[LRUCache] " + string);
    }
}

