/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.SessionBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cache.BaseCache;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.spi.CachingManagerBase;
import weblogic.ejb.spi.ReInitializableCache;
import weblogic.ejb20.cache.CacheFullException;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;

public final class NRUCache
extends BaseCache
implements ReInitializableCache {
    private final Queue freeQueue = new Queue();
    private final Queue activeQueue = new Queue();
    private final Queue inActiveQueue = new Queue();
    private static final int MIN_CAPACITY = 8;
    private long minFreeSize;
    private long targetFreeSize;
    private long targetInactiveSize;
    private int maxBeanSize = 0;
    private List cachingManagers = new ArrayList();
    private boolean isEntityCache = false;

    public NRUCache(String string, int n) {
        super(string, n);
    }

    public NRUCache(String string, long l) {
        super(string, l);
    }

    public void setMaxBeansInCache(int n) {
        super.setMaxBeansInCache(n);
        this.updateCacheValues();
    }

    public void register(CachingManagerBase cachingManagerBase) {
        CachingManager cachingManager = (CachingManager)cachingManagerBase;
        if (!this.cachingManagers.contains(cachingManager)) {
            this.cachingManagers.add(cachingManager);
        }
        this.isEntityCache = cachingManager.isEntityManager();
        this.maxBeanSize = Math.max(this.maxBeanSize, cachingManager.getBeanSize());
        this.updateCacheValues();
    }

    public void updateCacheValues() {
        this.setMaxCacheSize(Math.max((long)(8 * this.maxBeanSize), this.getMaxCacheSize()));
        this.minFreeSize = Math.min(this.getMaxCacheSize() / 8L, (long)(20 * this.maxBeanSize));
        this.targetFreeSize = Math.min(this.getMaxCacheSize() / 8L, (long)(10 * this.maxBeanSize));
        this.targetInactiveSize = this.getMaxCacheSize() / 8L;
        if (debugLogger.isDebugEnabled()) {
            NRUCache.debug("cache values for: " + this.cacheName);
            NRUCache.debug("maxCacheSize- " + this.getMaxCacheSize());
            NRUCache.debug("maxBeanSize- " + this.maxBeanSize);
            NRUCache.debug("minFreeSize- " + this.minFreeSize);
            NRUCache.debug("targetFreeSize- " + this.targetFreeSize);
            NRUCache.debug("targetInactiveSize- " + this.targetInactiveSize);
        }
    }

    public synchronized EnterpriseBean get(CacheKey cacheKey, boolean bl) {
        EnterpriseBean enterpriseBean;
        assert (this.validateDataStructures());
        BaseCache.Node node = (BaseCache.Node)this.cache.get(cacheKey);
        if (node == null) {
            assert (this.findKeyInQueues(cacheKey) == null);
            return null;
        }
        if (node.isFree()) {
            assert (this.freeQueue.contains(node));
            node.setActive();
            enterpriseBean = node.getBean();
            CachingManager cachingManager = node.getCallback();
            cachingManager.swapIn(cacheKey, enterpriseBean);
            this.freeQueue.remove(node);
            this.activeQueue.push(node);
        } else if (node.isInActive()) {
            assert (this.inActiveQueue.contains(node));
            node.setActive();
            this.inActiveQueue.remove(node);
            this.activeQueue.push(node);
        } else assert (this.activeQueue.contains(node));
        enterpriseBean = node.getBean();
        assert (this.activeQueue.contains(node));
        assert (this.validateDataStructures());
        if (bl) {
            node.pin();
        }
        return enterpriseBean;
    }

    public EnterpriseBean get(CacheKey cacheKey) {
        return this.get(cacheKey, true);
    }

    private BaseCache.Node getFreeNode(int n) throws CacheFullException {
        CachingManager cachingManager;
        EnterpriseBean enterpriseBean;
        CacheKey cacheKey;
        int n2;
        BaseCache.Node node = null;
        if (this.freeQueue.size() >= (long)n) {
            for (n2 = 0; n2 < n; n2 += node.getSize()) {
                node = this.freeQueue.pop();
                cacheKey = node.getKey();
                enterpriseBean = node.getBean();
                cachingManager = node.getCallback();
                if (enterpriseBean == null) continue;
                this.cache.remove(cacheKey);
                this.currentCacheSize -= (long)node.getSize();
                cachingManager.removedFromCache(cacheKey, enterpriseBean);
            }
        }
        if (this.currentCacheSize + (long)n <= this.getMaxCacheSize()) {
            if (node == null) {
                node = new BaseCache.Node();
            }
        } else {
            this.reclaimNodes(this.currentCacheSize + (long)n - this.getMaxCacheSize());
            if (this.freeQueue.size() < (long)n) {
                throw new CacheFullException("Cache '" + this.cacheName + "' is at its limit of: " + this.getMaxCacheSize() + " *active* " + this.getCacheUnits() + ".");
            }
            for (n2 = 0; n2 < n; n2 += node.getSize()) {
                node = this.freeQueue.pop();
                cacheKey = node.getKey();
                enterpriseBean = node.getBean();
                cachingManager = node.getCallback();
                if (enterpriseBean == null) continue;
                this.cache.remove(cacheKey);
                this.currentCacheSize -= (long)node.getSize();
                cachingManager.removedFromCache(cacheKey, enterpriseBean);
            }
            if (node == null) {
                node = new BaseCache.Node();
            }
        }
        assert (node != null);
        return node;
    }

    private void initializeNode(EnterpriseBean enterpriseBean, CacheKey cacheKey, BaseCache.Node node) {
        node.setBean(enterpriseBean);
        node.setKey(cacheKey);
        node.setActive();
        node.pin();
        this.activeQueue.push(node);
        BaseCache.Node node2 = this.cache.put(cacheKey, node);
        this.currentCacheSize += (long)node.getSize();
        assert (node2 == null) : "Adding bean:" + enterpriseBean + " with key: " + cacheKey + " that was already in cache '" + this.cacheName + "' .";
        assert (this.cache.get(cacheKey) == node);
        assert (node.getKey().equals(cacheKey));
        assert (this.validateDataStructures());
    }

    public synchronized void releaseEntityBean(BaseCache.Node node) {
        if (this.isEntityCache) {
            node.touch();
        }
    }

    public synchronized void put(CacheKey cacheKey, EnterpriseBean enterpriseBean) throws CacheFullException {
        if (debugLogger.isDebugEnabled()) {
            NRUCache.debug("Putting key: " + cacheKey + " into cache, current size is: " + this.getCurrentSize());
        }
        assert (this.validateDataStructures());
        assert (!this.contains(cacheKey));
        int n = cacheKey.getCallback().getBeanSize();
        BaseCache.Node node = this.getFreeNode(n);
        this.initializeNode(enterpriseBean, cacheKey, node);
        assert (this.validateDataStructures());
    }

    public synchronized void remove(CacheKey cacheKey) {
        this.remove(cacheKey, false);
    }

    public synchronized void removeOnError(CacheKey cacheKey) {
        this.remove(cacheKey, true);
    }

    private void remove(CacheKey cacheKey, boolean bl) {
        assert (this.validateDataStructures());
        BaseCache.Node node = (BaseCache.Node)this.cache.remove(cacheKey);
        if (debugLogger.isDebugEnabled()) {
            NRUCache.debug("*** Removing key: " + cacheKey);
        }
        if (node == null) {
            return;
        }
        this.currentCacheSize -= (long)node.getSize();
        if (bl) {
            node.getCallback().removedOnError(cacheKey, node.getBean());
        } else {
            node.getCallback().removedFromCache(cacheKey, node.getBean());
        }
        assert (node != null);
        assert (node.getKey().equals(cacheKey));
        if (node.pinned()) {
            node.unpin();
        }
        if (node.isActive()) {
            assert (this.activeQueue.contains(node));
            this.activeQueue.remove(node);
            node.setFree();
            this.freeQueue.push(node);
        } else if (node.isInActive()) {
            assert (this.inActiveQueue.contains(node));
            this.inActiveQueue.remove(node);
            node.setFree();
            this.freeQueue.push(node);
        } else assert (this.freeQueue.contains(node));
        node.setBean(null);
        node.setKey(null);
        assert (this.findKeyInQueues(cacheKey) == null);
        assert (this.validateDataStructures());
    }

    void cacheScrubber() {
        int n = this.scrubCache(true);
        if (this.isEntityCache) {
            if (debugLogger.isDebugEnabled()) {
                NRUCache.debug(this.cacheName + " after cache scrub, we've scrubbed " + n + " beans.");
            }
            if (n <= 0) {
                if (this.scrubIntervalMillis < 120000L) {
                    this.scrubIntervalMillis += this.scrubIntervalMillis;
                    if (debugLogger.isDebugEnabled()) {
                        NRUCache.debug(this.cacheName + "  " + " scrubIntervalMillis: " + this.scrubIntervalMillis + " is less than 2 minutes " + "and we've scrubbed no beans.  Doubling the interval till next scrubbing to " + this.scrubIntervalMillis);
                    }
                    this.scrubberTimer.stopScrubber();
                    this.scrubberTimer.setScrubInterval(this.scrubIntervalMillis);
                    this.scrubberTimer.startScrubber();
                }
            } else if (this.scrubIntervalMillis != this.scrubIntervalMillisDD) {
                if (debugLogger.isDebugEnabled()) {
                    NRUCache.debug(this.cacheName + "  " + " scrubIntervalMillis: " + this.scrubIntervalMillis + " is not equal to the deployed value " + " and we've scrubbed some beans during this scrubbing event.  Resetting scrubInterval to it's " + " deployed value: " + this.scrubIntervalMillisDD);
                }
                this.scrubIntervalMillis = this.scrubIntervalMillisDD;
                this.scrubberTimer.stopScrubber();
                this.scrubberTimer.setScrubInterval(this.scrubIntervalMillis);
                this.scrubberTimer.startScrubber();
            }
        }
    }

    private int scrubCache(boolean bl) {
        if (this.isEntityCache) {
            return this.newScrubber(bl);
        }
        if (bl) {
            return this.legacyScrubber(bl);
        }
        return this.newScrubber(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int legacyScrubber(boolean bl) {
        if (bl) {
            int n = 0;
            NRUCache nRUCache = this;
            synchronized (nRUCache) {
                long l = this.freeQueue.size() + (this.getMaxCacheSize() - this.getCurrentSize());
                if (l < this.minFreeSize) {
                    n += this.reclaimNodes(this.targetFreeSize);
                }
            }
            if (dumpCache) {
                Debug.say((String)this.cacheDump());
            }
            return n;
        }
        throw new AssertionError(" legacyScrubber called with idleTimeout = " + bl + ", it should only be called with idleTimeout==true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newScrubber(boolean bl) {
        long l;
        ArrayList<BaseCache.Node> arrayList = new ArrayList<BaseCache.Node>();
        long l2 = l = System.currentTimeMillis();
        int n = 0;
        NRUCache nRUCache = this;
        synchronized (nRUCache) {
            int n2;
            BaseCache.Node node;
            int n3;
            int n4 = (int)this.activeQueue.size();
            for (n3 = 0; n3 < n4; ++n3) {
                node = this.activeQueue.pop();
                if (!node.pinned()) {
                    if (bl) {
                        n2 = node.getCallback().getIdleTimeoutSeconds();
                        if (n2 <= 0) {
                            this.activeQueue.push(node);
                            continue;
                        }
                        if (!node.idleLongerThan(n2 * 1000)) {
                            this.activeQueue.push(node);
                            continue;
                        }
                    }
                    this.removeNode(node);
                    arrayList.add(node);
                    ++n;
                    if (this.isEntityCache) continue;
                    node.getCallback().removedFromCache(node.getKey(), node.getBean());
                    continue;
                }
                this.activeQueue.push(node);
            }
            n4 = (int)this.inActiveQueue.size();
            for (n3 = 0; n3 < n4; ++n3) {
                node = this.inActiveQueue.pop();
                if (node.pinned()) continue;
                if (bl) {
                    n2 = node.getCallback().getIdleTimeoutSeconds();
                    if (n2 <= 0) {
                        this.inActiveQueue.push(node);
                        continue;
                    }
                    if (!node.idleLongerThan(n2 * 1000)) {
                        this.inActiveQueue.push(node);
                        continue;
                    }
                }
                this.removeNode(node);
                arrayList.add(node);
                ++n;
                if (this.isEntityCache) continue;
                node.getCallback().removedFromCache(node.getKey(), node.getBean());
            }
            n4 = (int)this.freeQueue.size();
            for (n3 = 0; n3 < n4; ++n3) {
                node = this.freeQueue.pop();
                if (node.getBean() != null) {
                    if (bl) {
                        n2 = node.getCallback().getIdleTimeoutSeconds();
                        if (n2 <= 0) {
                            this.freeQueue.push(node);
                            continue;
                        }
                        if (!node.idleLongerThan(n2 * 1000)) {
                            this.freeQueue.push(node);
                            continue;
                        }
                    }
                    node.getCallback().removedFromCache(node.getKey(), node.getBean());
                }
                this.removeNode(node);
                ++n;
            }
        }
        if (this.isEntityCache) {
            for (BaseCache.Node node : arrayList) {
                CachingManager cachingManager = node.getCallback();
                cachingManager.swapOut(node.getKey(), (EnterpriseBean)((EntityBean)node.getBean()));
                cachingManager.removedFromCache(node.getKey(), (EnterpriseBean)((EntityBean)node.getBean()));
            }
        }
        return n;
    }

    public void reInitializeCacheAndPools() {
        if (debugLogger.isDebugEnabled()) {
            NRUCache.debug(this.cacheName + " reInitializeCacheAndPools, cache size is " + this.cache.size());
        }
        for (BeanManager beanManager : this.cachingManagers) {
            beanManager.reInitializePool();
        }
        this.reInitializeCache();
        if (debugLogger.isDebugEnabled()) {
            NRUCache.debug(this.cacheName + " cache reInitialization complete, size is " + this.cache.size());
        }
    }

    public void reInitializeCache() {
        this.scrubCache(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beanImplClassChangeNotification() {
        ArrayList<BaseCache.Node> arrayList = new ArrayList<BaseCache.Node>();
        NRUCache nRUCache = this;
        synchronized (nRUCache) {
            long l;
            long l2;
            long l3 = this.freeQueue.size();
            for (l2 = 0L; l2 < l3; ++l2) {
                BaseCache.Node node = this.freeQueue.pop();
                this.removeNode(node);
                CachingManager cachingManager = node.getCallback();
                cachingManager.removedFromCache(node.getKey(), node.getBean());
            }
            l2 = this.inActiveQueue.size();
            for (l = 0L; l < l2; ++l) {
                BaseCache.Node node = this.inActiveQueue.pop();
                this.removeNode(node);
                arrayList.add(node);
            }
            l = this.activeQueue.size();
            for (long i = 0L; i < l; ++i) {
                BaseCache.Node node = this.activeQueue.pop();
                if (!node.pinned()) {
                    this.removeNode(node);
                    arrayList.add(node);
                    continue;
                }
                this.activeQueue.push(node);
            }
            assert (this.validateDataStructures());
        }
        for (BaseCache.Node node : arrayList) {
            CachingManager cachingManager = node.getCallback();
            cachingManager.swapOut(node.getKey(), (EnterpriseBean)((EntityBean)node.getBean()));
            cachingManager.removedFromCache(node.getKey(), (EnterpriseBean)((EntityBean)node.getBean()));
        }
    }

    public synchronized void updateMaxBeansInCache(int n) {
        if (this.usesMaxBeansInCache()) {
            this.setMaxBeansInCache(n);
            this.cacheScrubber();
        }
    }

    public void updateMaxCacheSize(int n) {
        if (!this.usesMaxBeansInCache()) {
            this.setMaxCacheSize(n);
            this.updateCacheValues();
            this.cacheScrubber();
        }
    }

    private void removeNode(BaseCache.Node node) {
        CacheKey cacheKey = node.getKey();
        EnterpriseBean enterpriseBean = node.getBean();
        if (enterpriseBean != null) {
            this.cache.remove(cacheKey);
            this.currentCacheSize -= (long)node.getSize();
        }
    }

    private void moveActiveToInactive() {
        BaseCache.Node node;
        for (long i = this.activeQueue.size(); i > 0L; i -= (long)node.getSize()) {
            if (this.inActiveQueue.size() >= this.targetInactiveSize) {
                return;
            }
            node = this.activeQueue.pop();
            assert (node != null);
            if (node.pinned()) {
                this.activeQueue.push(node);
                continue;
            }
            if (!this.isEntityCache) {
                node.touch();
            }
            node.setInActive();
            this.inActiveQueue.push(node);
        }
    }

    private int moveInActiveToFree(long l) {
        int n = 0;
        while (this.freeQueue.size() < l) {
            BaseCache.Node node = this.inActiveQueue.pop();
            if (node == null) {
                return n;
            }
            EnterpriseBean enterpriseBean = node.getBean();
            if (enterpriseBean instanceof SessionBean && node.idleLongerThan(this.scrubIntervalMillis)) {
                CacheKey cacheKey = node.getKey();
                this.cache.remove(cacheKey);
                int n2 = node.getSize();
                this.currentCacheSize -= (long)n2;
                n += n2;
                SessionBean sessionBean = (SessionBean)enterpriseBean;
                try {
                    sessionBean.ejbRemove();
                }
                catch (Throwable throwable) {
                    EJBLogger.logExceptionDuringEJBRemove((Throwable)throwable);
                }
                node.getCallback().removedFromCache(cacheKey, enterpriseBean);
                node.setBean(null);
                node.setKey(null);
            } else {
                assert (!node.pinned());
                assert (node.getBean() != null);
                assert (node.getKey() != null);
                assert (node.getCallback() != null);
                n += node.getSize();
                node.getCallback().swapOut(node.getKey(), node.getBean());
            }
            node.setFree();
            this.freeQueue.push(node);
        }
        return n;
    }

    private int reclaimNodes(long l) {
        assert (this.validateDataStructures());
        int n = 0;
        n += this.moveInActiveToFree(l);
        this.moveActiveToInactive();
        if (this.freeQueue.size() == 0L) {
            n += this.moveInActiveToFree(this.targetFreeSize);
        }
        return n;
    }

    protected boolean validateDataStructures() {
        EnterpriseBean enterpriseBean;
        CacheKey cacheKey2;
        int n = 0;
        BaseCache.Node node = this.freeQueue.head;
        while (node != null) {
            ++n;
            node = node.next;
        }
        node = this.inActiveQueue.head;
        while (node != null) {
            ++n;
            node = node.next;
        }
        node = this.activeQueue.head;
        while (node != null) {
            ++n;
            node = node.next;
        }
        if (n < this.cache.size()) {
            throw new AssertionError("nodeCnt was :" + n + " but cache size is " + this.cache.size());
        }
        Debug.assertion((n >= this.cache.size() ? 1 : 0) != 0);
        Debug.assertion((n <= this.getMaxBeansInCache() ? 1 : 0) != 0);
        Debug.assertion((this.freeQueue.size() >= 0L ? 1 : 0) != 0);
        Debug.assertion((this.inActiveQueue.size() >= 0L ? 1 : 0) != 0);
        Debug.assertion((this.activeQueue.size() >= 0L ? 1 : 0) != 0);
        Debug.assertion((this.currentCacheSize >= 0L ? 1 : 0) != 0);
        long l = this.freeQueue.size() + this.inActiveQueue.size() + this.activeQueue.size();
        if (l < this.currentCacheSize) {
            throw new AssertionError("listSize was :" + l + " but cache size is " + this.currentCacheSize);
        }
        long l2 = 0L;
        for (CacheKey cacheKey2 : this.cache.keySet()) {
            node = (BaseCache.Node)this.cache.get(cacheKey2);
            l2 += (long)node.getSize();
            Debug.assertion((cacheKey2 == node.getKey() ? 1 : 0) != 0);
            int n2 = 0;
            if (this.activeQueue.contains(node)) {
                ++n2;
            }
            if (this.inActiveQueue.contains(node)) {
                ++n2;
            }
            if (this.freeQueue.contains(node)) {
                ++n2;
            }
            Debug.assertion((n2 == 1 ? 1 : 0) != 0);
        }
        Debug.assertion((l2 == this.currentCacheSize ? 1 : 0) != 0);
        l2 = 0L;
        node = this.activeQueue.head;
        while (node != null) {
            enterpriseBean = node.getBean();
            Debug.assertion((enterpriseBean != null ? 1 : 0) != 0);
            cacheKey2 = node.getKey();
            Debug.assertion((cacheKey2 != null ? 1 : 0) != 0);
            Debug.assertion((node == this.cache.get(cacheKey2) ? 1 : 0) != 0);
            l2 += (long)node.getSize();
            node = node.next;
        }
        Debug.assertion((l2 == this.activeQueue.size() ? 1 : 0) != 0);
        l2 = 0L;
        node = this.inActiveQueue.head;
        while (node != null) {
            enterpriseBean = node.getBean();
            Debug.assertion((enterpriseBean != null ? 1 : 0) != 0);
            cacheKey2 = node.getKey();
            Debug.assertion((cacheKey2 != null ? 1 : 0) != 0);
            Debug.assertion((node == this.cache.get(cacheKey2) ? 1 : 0) != 0);
            l2 += (long)node.getSize();
            node = node.next;
        }
        Debug.assertion((l2 == this.inActiveQueue.size() ? 1 : 0) != 0);
        l2 = 0L;
        node = this.freeQueue.head;
        while (node != null) {
            enterpriseBean = node.getBean();
            if (enterpriseBean != null) {
                cacheKey2 = node.getKey();
                Debug.assertion((cacheKey2 != null ? 1 : 0) != 0);
                Debug.assertion((node == this.cache.get(cacheKey2) ? 1 : 0) != 0);
            }
            l2 += (long)node.getSize();
            node = node.next;
        }
        Debug.assertion((l2 == this.freeQueue.size() ? 1 : 0) != 0);
        node = this.inActiveQueue.head;
        while (node != null) {
            Debug.assertion((!node.pinned() ? 1 : 0) != 0);
            node = node.next;
        }
        node = this.freeQueue.head;
        while (node != null) {
            Debug.assertion((!node.pinned() ? 1 : 0) != 0);
            node = node.next;
        }
        return true;
    }

    private BaseCache.Node findKeyInQueue(Queue queue, CacheKey cacheKey) {
        BaseCache.Node node = queue.head;
        while (node != null) {
            if (cacheKey.equals(node.getKey())) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    private BaseCache.Node findKeyInQueues(CacheKey cacheKey) {
        BaseCache.Node node = this.findKeyInQueue(this.activeQueue, cacheKey);
        if (node != null) {
            return node;
        }
        node = this.findKeyInQueue(this.inActiveQueue, cacheKey);
        if (node != null) {
            return node;
        }
        return this.findKeyInQueue(this.freeQueue, cacheKey);
    }

    private static void debug(String string) {
        debugLogger.debug("[NRUCache] " + string);
    }

    private static class Queue {
        private BaseCache.Node head = null;
        private BaseCache.Node tail = null;
        private long size = 0L;

        Queue() {
        }

        public boolean contains(BaseCache.Node node) {
            BaseCache.Node node2 = this.head;
            while (node2 != null) {
                if (node2 == node) {
                    return true;
                }
                node2 = node2.next;
            }
            return false;
        }

        final void remove(BaseCache.Node node) {
            assert (this.contains(node));
            this.size -= (long)node.getSize();
            if (this.head == node) {
                this.head = node.next;
            } else {
                node.prev.next = node.next;
            }
            if (this.tail == node) {
                this.tail = node.prev;
            } else {
                node.next.prev = node.prev;
            }
            assert (!this.contains(node));
            assert (this.tail == null || this.contains(this.tail));
            assert (this.head == null || this.contains(this.head));
        }

        long size() {
            return this.size;
        }

        final void push(BaseCache.Node node) {
            assert (!this.contains(node));
            this.size += (long)node.getSize();
            if (this.tail == null) {
                assert (this.head == null);
                this.head = node;
                this.tail = node;
                node.prev = null;
                node.next = null;
            } else {
                assert (this.head != null);
                assert (this.tail.next == null);
                this.tail.next = node;
                node.prev = this.tail;
                node.next = null;
                this.tail = node;
            }
        }

        final BaseCache.Node pop() {
            if (this.head == null) {
                assert (this.tail == null);
                assert (this.size == 0L);
                return null;
            }
            assert (this.size > 0L);
            this.size -= (long)this.head.getSize();
            BaseCache.Node node = this.head;
            this.head = this.head.next;
            if (this.head == null) {
                assert (this.size == 0L);
                this.tail = null;
            } else {
                this.head.prev = null;
            }
            assert (!this.contains(node));
            return node;
        }
    }
}

