/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.cache.QueryCacheElement;
import weblogic.ejb.container.cache.QueryCacheKey;
import weblogic.ejb.container.manager.TTLManager;
import weblogic.ejb.container.monitoring.QueryCacheRuntimeMBeanImpl;
import weblogic.ejb.container.persistence.spi.EloWrapper;
import weblogic.ejb.container.persistence.spi.EoWrapper;
import weblogic.ejb20.utils.OrderedSet;
import weblogic.management.ManagementException;
import weblogic.management.runtime.QueryCacheRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;

public class QueryCache
implements weblogic.ejb.container.interfaces.QueryCache {
    private static final DebugLogger debugLogger = EJBDebugService.cachingLogger;
    private ConcurrentHashMap queryAxis;
    private ConcurrentHashMap primaryKeyAxis;
    private LRUList lrulist;
    private int capacity;
    private QueryCacheRuntimeMBeanImpl rtmMBean;
    private String name;

    public QueryCache(String string, int n) {
        this.name = string;
        this.capacity = n;
        this.queryAxis = new ConcurrentHashMap();
        this.primaryKeyAxis = new ConcurrentHashMap();
        this.lrulist = new LRUList(string, n);
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(string, "Capacity: " + n);
        }
    }

    public QueryCacheRuntimeMBean createRuntimeMBean(String string, RuntimeMBean runtimeMBean) throws ManagementException {
        this.rtmMBean = new QueryCacheRuntimeMBeanImpl(string, runtimeMBean);
        return this.rtmMBean;
    }

    public void setRuntimeMBean(QueryCacheRuntimeMBean queryCacheRuntimeMBean) {
        this.rtmMBean = (QueryCacheRuntimeMBeanImpl)queryCacheRuntimeMBean;
    }

    public Object get(Object object, QueryCacheKey queryCacheKey, boolean bl, boolean bl2) throws InternalException {
        this.rtmMBean.incrementCacheAccessCount();
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(this.name, "Get: " + queryCacheKey + " at: " + System.currentTimeMillis());
        }
        QueryAxisNode queryAxisNode = (QueryAxisNode)this.queryAxis.get(queryCacheKey);
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(this.name, "QueryAxis size: " + this.queryAxis.size());
        }
        if (queryAxisNode == null) {
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.name, "Cache miss: Not found: " + queryCacheKey);
            }
            this.rtmMBean.incrementCacheMissCount();
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.name, "Got null QueryAxisNode for " + queryCacheKey);
            }
            return null;
        }
        Object object2 = queryAxisNode.get(object, bl, bl2);
        if (object2 == null) {
            queryAxisNode.delink();
            this.lrulist.remove(queryAxisNode);
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.name, "Cache miss: Timed out: " + queryCacheKey);
            }
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.name, "Got null from QueryAxisNode for " + queryCacheKey);
            }
            return null;
        }
        this.lrulist.addMRU(queryAxisNode);
        this.rtmMBean.incrementCacheHitCount();
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(this.name, "Returning " + object2.getClass() + " for " + queryCacheKey);
        }
        return object2;
    }

    public boolean put(QueryCacheKey queryCacheKey, Collection collection) {
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(this.name, "Put(coll): " + queryCacheKey + " size: " + collection.size() + " at: " + System.currentTimeMillis());
        }
        QueryAxisNode queryAxisNode = new QueryAxisNode(queryCacheKey, this);
        QueryAxisNode queryAxisNode2 = queryAxisNode.set(collection);
        this.lrulist.addMRU(queryAxisNode2);
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(this.name, "Putting collection for " + queryCacheKey + " " + (queryAxisNode == queryAxisNode2));
        }
        return queryAxisNode == queryAxisNode2;
    }

    public boolean put(QueryCacheKey queryCacheKey, QueryCacheElement queryCacheElement) {
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(this.name, "Put: " + queryCacheKey + " at: " + System.currentTimeMillis());
        }
        QueryAxisNode queryAxisNode = new QueryAxisNode(queryCacheKey, this);
        QueryAxisNode queryAxisNode2 = queryAxisNode.set(queryCacheElement);
        this.lrulist.addMRU(queryAxisNode2);
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(this.name, "Putting singleton for " + queryCacheKey + " " + (queryAxisNode == queryAxisNode2));
        }
        return queryAxisNode == queryAxisNode2;
    }

    public void invalidate(CacheKey cacheKey) {
        this.invalidate(new QueryCacheElement(cacheKey));
    }

    public void invalidateAll() {
        Iterator iterator = this.primaryKeyAxis.keySet().iterator();
        while (iterator.hasNext()) {
            this.invalidate((QueryCacheElement)iterator.next());
        }
    }

    protected void invalidate(QueryCacheKey queryCacheKey) {
        QueryAxisNode queryAxisNode = (QueryAxisNode)this.queryAxis.remove(queryCacheKey);
        if (queryAxisNode != null) {
            queryAxisNode.delink();
            this.lrulist.remove(queryAxisNode);
        }
    }

    protected boolean enrollQuery(Object object, QueryCacheKey queryCacheKey) throws InternalException {
        QueryAxisNode queryAxisNode = (QueryAxisNode)this.queryAxis.get(queryCacheKey);
        if (queryAxisNode == null) {
            return false;
        }
        boolean bl = queryAxisNode.enroll(object);
        if (bl) {
            this.lrulist.addMRU(queryAxisNode);
        } else {
            queryAxisNode.delink();
            this.lrulist.remove(queryAxisNode);
        }
        if (debugLogger.isDebugEnabled()) {
            QueryCache.debug(this.name, "Enrolling for " + queryCacheKey + ": " + bl);
        }
        return bl;
    }

    private void invalidate(QueryCacheElement queryCacheElement) {
        PrimaryKeyAxisNode primaryKeyAxisNode = (PrimaryKeyAxisNode)this.primaryKeyAxis.remove(queryCacheElement);
        if (primaryKeyAxisNode == null) {
            return;
        }
        primaryKeyAxisNode.clearAll();
    }

    private static void debug(String string, String string2) {
        debugLogger.debug("[QueryCache:" + string + "] " + string2);
    }

    private static class LRUList {
        private QueryAxisNode mostRecent;
        private QueryAxisNode leastRecent;
        private String name;
        private final int capacity;
        private int size;

        public LRUList(String string, int n) {
            this.capacity = n;
            this.size = 0;
            this.name = string;
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.name, "Capacity is: " + this.capacity);
            }
        }

        public int size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMRU(QueryAxisNode queryAxisNode) {
            if (this.capacity == 0) {
                return;
            }
            QueryAxisNode queryAxisNode2 = null;
            LRUList lRUList = this;
            synchronized (lRUList) {
                if (queryAxisNode == this.mostRecent) {
                    return;
                }
                if (this.mostRecent == null) {
                    this.mostRecent = queryAxisNode;
                    this.mostRecent.older = this.leastRecent;
                    this.mostRecent.newer = null;
                    this.leastRecent = this.mostRecent;
                    this.leastRecent.newer = this.mostRecent;
                    this.leastRecent.older = null;
                    this.size = 1;
                    return;
                }
                if (queryAxisNode == this.mostRecent || queryAxisNode == this.leastRecent || queryAxisNode.older != null && queryAxisNode.newer != null) {
                    if (queryAxisNode == this.leastRecent) {
                        this.leastRecent = queryAxisNode.newer;
                        this.leastRecent.older = null;
                        queryAxisNode.newer = null;
                    } else {
                        queryAxisNode.newer.older = queryAxisNode.older;
                        queryAxisNode.older.newer = queryAxisNode.newer;
                        queryAxisNode.newer = null;
                        queryAxisNode.older = null;
                    }
                } else if (++this.size > this.capacity) {
                    queryAxisNode2 = this.shrink();
                }
                queryAxisNode.older = this.mostRecent;
                this.mostRecent.newer = queryAxisNode;
                this.mostRecent = queryAxisNode;
            }
            if (queryAxisNode2 != null) {
                queryAxisNode2.delink();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(QueryAxisNode queryAxisNode) {
            if (this.capacity == 0) {
                return;
            }
            LRUList lRUList = this;
            synchronized (lRUList) {
                if (queryAxisNode == this.mostRecent || queryAxisNode == this.leastRecent || queryAxisNode.older != null && queryAxisNode.newer != null) {
                    if (queryAxisNode.newer != null) {
                        queryAxisNode.newer.older = queryAxisNode.older;
                    }
                    if (queryAxisNode.older != null) {
                        queryAxisNode.older.newer = queryAxisNode.newer;
                    }
                    if (queryAxisNode == this.mostRecent) {
                        this.mostRecent = queryAxisNode.older;
                        if (this.mostRecent != null) {
                            this.mostRecent.newer = null;
                        }
                    }
                    if (queryAxisNode == this.leastRecent) {
                        this.leastRecent = queryAxisNode.newer;
                        if (this.leastRecent != null) {
                            this.leastRecent.older = null;
                        }
                    }
                    queryAxisNode.newer = null;
                    queryAxisNode.older = null;
                    --this.size;
                }
            }
        }

        private QueryAxisNode shrink() {
            QueryAxisNode queryAxisNode = this.leastRecent;
            if (this.leastRecent.newer != null) {
                this.leastRecent.newer.older = null;
            } else if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.name, "No newer");
            }
            this.leastRecent = this.leastRecent.newer;
            this.leastRecent.older = null;
            --this.size;
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.name, "LRUList size is " + this.size);
            }
            return queryAxisNode;
        }
    }

    private static class QueryElementNode {
        public QueryCacheKey qckey;
        public QueryCacheElement qcelement;
        public QueryElementNode up;
        public QueryElementNode left;
        public QueryElementNode right;
        public PrimaryKeyAxisNode qcelnode;

        public QueryElementNode(QueryCacheKey queryCacheKey, QueryCacheElement queryCacheElement) {
            this.qckey = queryCacheKey;
            this.qcelement = queryCacheElement;
        }
    }

    private static class PrimaryKeyAxisNode {
        private QueryElementNode head;
        private QueryElementNode tail;
        private QueryCache cache;
        private QueryCacheElement key;
        private int size = 0;

        public PrimaryKeyAxisNode(QueryCacheElement queryCacheElement, QueryCache queryCache) {
            this.key = queryCacheElement;
            this.cache = queryCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void add(QueryElementNode queryElementNode) {
            block4: {
                block3: {
                    try {
                        if (this.head == null) {
                            this.tail = this.head = queryElementNode;
                            this.tail.left = this.head;
                            this.tail.right = null;
                            queryElementNode.left = null;
                            queryElementNode.right = null;
                            ++this.size;
                            Object var3_2 = null;
                            break block3;
                        }
                        this.tail.right = queryElementNode;
                        queryElementNode.left = this.tail;
                        this.tail = queryElementNode;
                        this.tail.right = null;
                        ++this.size;
                        break block4;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        if (!debugLogger.isDebugEnabled()) throw throwable;
                        this.validate("add");
                        throw throwable;
                    }
                }
                if (!debugLogger.isDebugEnabled()) return;
                this.validate("add");
                return;
            }
            Object var3_3 = null;
            if (!debugLogger.isDebugEnabled()) return;
            this.validate("add");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAll() {
            Object object;
            ArrayList<QueryAxisNode> arrayList = new ArrayList<QueryAxisNode>();
            PrimaryKeyAxisNode primaryKeyAxisNode = this;
            synchronized (primaryKeyAxisNode) {
                try {
                    object = this.head;
                    while (object != null) {
                        QueryAxisNode queryAxisNode = (QueryAxisNode)this.cache.queryAxis.remove(((QueryElementNode)object).qckey);
                        if (queryAxisNode != null) {
                            arrayList.add(queryAxisNode);
                        }
                        object = ((QueryElementNode)object).right;
                    }
                    this.size = 0;
                    this.head = null;
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (debugLogger.isDebugEnabled()) {
                        this.validate("clearAll");
                    }
                    throw throwable;
                }
                if (debugLogger.isDebugEnabled()) {
                    this.validate("clearAll");
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (QueryAxisNode)arrayList.get(i);
                ((QueryAxisNode)object).delink();
                this.cache.lrulist.remove((QueryAxisNode)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delink(QueryElementNode queryElementNode) {
            Object object = this;
            synchronized (object) {
                try {
                    if (queryElementNode.left != null) {
                        queryElementNode.left.right = queryElementNode.right;
                    } else {
                        this.head = queryElementNode.right;
                    }
                    if (queryElementNode.right != null) {
                        queryElementNode.right.left = queryElementNode.left;
                    } else {
                        this.tail = queryElementNode.left;
                    }
                    queryElementNode.left = null;
                    queryElementNode.right = null;
                    queryElementNode.qcelnode = null;
                    --this.size;
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (debugLogger.isDebugEnabled()) {
                        this.validate("delink");
                    }
                    throw throwable;
                }
                if (debugLogger.isDebugEnabled()) {
                    this.validate("delink");
                }
            }
            if (this.size == 0) {
                object = this.cache.primaryKeyAxis;
                synchronized (object) {
                    Object v = this.cache.primaryKeyAxis.remove(this.key);
                    if (v != null && v != this) {
                        this.cache.primaryKeyAxis.put(this.key, v);
                    }
                }
            }
        }

        private void validate(String string) {
            int n = 0;
            Object object = this.head;
            while (object != null) {
                ++n;
                object = ((QueryElementNode)object).right;
            }
            if (n != this.size) {
                object = new StringBuffer();
                ((StringBuffer)object).append("PrimaryKeyAxisNode." + string + " FAIL: got " + n + ", expected " + this.size);
                QueryElementNode queryElementNode = this.head;
                while (queryElementNode != null) {
                    ((StringBuffer)object).append(queryElementNode.qckey + ", " + queryElementNode.qcelement);
                    queryElementNode = queryElementNode.right;
                }
                QueryCache.debug(this.cache.name, ((StringBuffer)object).toString());
            }
        }
    }

    private static class QueryAxisNode {
        public QueryCacheKey key;
        private QueryElementNode head;
        private Lock rlock;
        private Lock wlock;
        private QueryCache cache;
        private boolean containsEmptyResult = false;
        private int size;
        private long expirationTime = 0L;
        private TTLManager manager;
        private Set sourceQueries;
        private Set destinationQueries;
        private Set dependentQueries;
        public QueryAxisNode older;
        public QueryAxisNode newer;

        public QueryAxisNode(QueryCacheKey queryCacheKey, QueryCache queryCache) {
            this.key = queryCacheKey;
            this.cache = queryCache;
            this.manager = queryCacheKey.getOwnerManager();
            this.sourceQueries = queryCacheKey.getSourceQueries();
            this.destinationQueries = queryCacheKey.getDestinationQueries();
            this.dependentQueries = queryCacheKey.getDependentQueries();
            ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
            this.rlock = reentrantReadWriteLock.readLock();
            this.wlock = reentrantReadWriteLock.writeLock();
            if (queryCacheKey.getTimeoutMillis() != 0) {
                this.expirationTime = System.currentTimeMillis() + (long)queryCacheKey.getTimeoutMillis();
                if (debugLogger.isDebugEnabled()) {
                    QueryCache.debug(this.cache.name, "Expiration of: " + this.key + " at: " + this.expirationTime);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueryAxisNode set(QueryCacheElement queryCacheElement) {
            block13: {
                QueryAxisNode queryAxisNode;
                this.wlock.lock();
                try {
                    QueryAxisNode queryAxisNode2 = this.cache.queryAxis.putIfAbsent(this.key, this);
                    if (queryAxisNode2 == null || queryAxisNode2 == this || queryAxisNode2.hasTimedOut()) break block13;
                    if (debugLogger.isDebugEnabled()) {
                        QueryCache.debug(this.cache.name, "Cache put fail: Already exists: " + this.key);
                    }
                    if (this.sourceQueries != null) {
                        if (queryAxisNode2.sourceQueries == null) {
                            queryAxisNode2.sourceQueries = this.sourceQueries;
                        } else {
                            queryAxisNode2.sourceQueries.addAll(this.sourceQueries);
                        }
                    }
                    queryAxisNode = queryAxisNode2;
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (debugLogger.isDebugEnabled()) {
                        this.validate("set(QueryCacheElement)");
                    }
                    this.wlock.unlock();
                    throw throwable;
                }
                if (debugLogger.isDebugEnabled()) {
                    this.validate("set(QueryCacheElement)");
                }
                this.wlock.unlock();
                return queryAxisNode;
            }
            this.head = new QueryElementNode(this.key, queryCacheElement);
            if (queryCacheElement.isInvalidatable()) {
                PrimaryKeyAxisNode primaryKeyAxisNode = new PrimaryKeyAxisNode(this.head.qcelement, this.cache);
                PrimaryKeyAxisNode primaryKeyAxisNode2 = this.cache.primaryKeyAxis.putIfAbsent(this.head.qcelement, primaryKeyAxisNode);
                if (primaryKeyAxisNode2 != null) {
                    primaryKeyAxisNode = primaryKeyAxisNode2;
                }
                this.head.qcelnode = primaryKeyAxisNode;
                primaryKeyAxisNode.add(this.head);
            }
            this.size = 1;
            Object var6_6 = null;
            if (debugLogger.isDebugEnabled()) {
                this.validate("set(QueryCacheElement)");
            }
            this.wlock.unlock();
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.cache.name, "Size: " + this.cache.lrulist.size());
            }
            this.cache.rtmMBean.incrementTotalCachedQueriesCount();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public QueryAxisNode set(Collection collection) {
            block29: {
                QueryAxisNode queryAxisNode;
                block28: {
                    QueryAxisNode queryAxisNode2;
                    block27: {
                        QueryAxisNode queryAxisNode3;
                        block26: {
                            this.wlock.lock();
                            try {
                                Class<?> clazz;
                                block30: {
                                    QueryAxisNode queryAxisNode4;
                                    block31: {
                                        queryAxisNode4 = this.cache.queryAxis.putIfAbsent(this.key, this);
                                        if (queryAxisNode4 == null || queryAxisNode4 == this) break block30;
                                        if (!queryAxisNode4.hasTimedOut()) break block31;
                                        clazz = Thread.currentThread().getClass();
                                        if (!clazz.getSimpleName().contains("EagerRefresh")) {
                                            if (debugLogger.isDebugEnabled()) {
                                                QueryCache.debug(this.cache.name, "Replacing timed out result: " + this.key);
                                            }
                                            queryAxisNode4.delink();
                                            queryAxisNode4 = this.cache.queryAxis.putIfAbsent(this.key, this);
                                            break block30;
                                        } else {
                                            if (debugLogger.isDebugEnabled()) {
                                                QueryCache.debug(this.cache.name, "Cache put skip: EagerRefresh: " + this.key);
                                            }
                                            queryAxisNode3 = queryAxisNode4;
                                            Object var11_8 = null;
                                            break block26;
                                        }
                                    }
                                    if (debugLogger.isDebugEnabled()) {
                                        QueryCache.debug(this.cache.name, "Cache put fail: Already exists: " + this.key);
                                    }
                                    if (!queryAxisNode4.containsEmptyResult && this.sourceQueries != null) {
                                        if (queryAxisNode4.sourceQueries == null) {
                                            queryAxisNode4.sourceQueries = this.sourceQueries;
                                        } else {
                                            queryAxisNode4.sourceQueries.addAll(this.sourceQueries);
                                        }
                                    }
                                    queryAxisNode2 = queryAxisNode4;
                                    break block27;
                                }
                                this.size = 0;
                                clazz = null;
                                this.head = null;
                                if (collection.size() == 0) {
                                    if (debugLogger.isDebugEnabled()) {
                                        QueryCache.debug(this.cache.name, "Setting empty result: " + this.key);
                                    }
                                    this.containsEmptyResult = true;
                                    if (debugLogger.isDebugEnabled()) {
                                        QueryCache.debug(this.cache.name, "Size: " + this.cache.lrulist.size());
                                    }
                                    this.cache.rtmMBean.incrementTotalCachedQueriesCount();
                                    queryAxisNode = this;
                                    break block28;
                                }
                                Iterator iterator = collection.iterator();
                                HashMap<QueryCacheElement, QueryCacheElement> hashMap = new HashMap<QueryCacheElement, QueryCacheElement>();
                                boolean bl = false;
                                while (iterator.hasNext()) {
                                    QueryCacheElement queryCacheElement = (QueryCacheElement)iterator.next();
                                    if (this.head == null) {
                                        this.head = new QueryElementNode(this.key, queryCacheElement);
                                        clazz = this.head;
                                    } else {
                                        ((QueryElementNode)((Object)clazz)).up = new QueryElementNode(this.key, queryCacheElement);
                                        clazz = ((QueryElementNode)((Object)clazz)).up;
                                    }
                                    if (this.key.getReturnType() == 3 && queryCacheElement.isIncludable()) {
                                        if (bl) {
                                            throw new AssertionError((Object)"Multiple includables found for singleton return query ");
                                        }
                                        bl = true;
                                    }
                                    if (!hashMap.containsKey(queryCacheElement) && queryCacheElement.isInvalidatable()) {
                                        PrimaryKeyAxisNode primaryKeyAxisNode = new PrimaryKeyAxisNode(((QueryElementNode)((Object)clazz)).qcelement, this.cache);
                                        PrimaryKeyAxisNode primaryKeyAxisNode2 = this.cache.primaryKeyAxis.putIfAbsent(((QueryElementNode)((Object)clazz)).qcelement, primaryKeyAxisNode);
                                        if (primaryKeyAxisNode2 != null) {
                                            primaryKeyAxisNode = primaryKeyAxisNode2;
                                        }
                                        ((QueryElementNode)((Object)clazz)).qcelnode = primaryKeyAxisNode;
                                        primaryKeyAxisNode.add((QueryElementNode)((Object)clazz));
                                        hashMap.put(queryCacheElement, queryCacheElement);
                                    }
                                    ++this.size;
                                }
                                break block29;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                if (debugLogger.isDebugEnabled()) {
                                    this.validate("set(Collection)");
                                }
                                this.wlock.unlock();
                                throw throwable;
                            }
                        }
                        if (debugLogger.isDebugEnabled()) {
                            this.validate("set(Collection)");
                        }
                        this.wlock.unlock();
                        return queryAxisNode3;
                    }
                    Object var11_9 = null;
                    if (debugLogger.isDebugEnabled()) {
                        this.validate("set(Collection)");
                    }
                    this.wlock.unlock();
                    return queryAxisNode2;
                }
                Object var11_10 = null;
                if (debugLogger.isDebugEnabled()) {
                    this.validate("set(Collection)");
                }
                this.wlock.unlock();
                return queryAxisNode;
            }
            Object var11_11 = null;
            if (debugLogger.isDebugEnabled()) {
                this.validate("set(Collection)");
            }
            this.wlock.unlock();
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.cache.name, "Size: " + this.cache.lrulist.size());
            }
            this.cache.rtmMBean.incrementTotalCachedQueriesCount();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object get(Object object, boolean bl, boolean bl2) throws InternalException {
            Object object2;
            block39: {
                Object var7_21;
                block38: {
                    Object var7_20;
                    block37: {
                        Object var9_25;
                        block36: {
                            ArrayList arrayList;
                            block35: {
                                Object object3;
                                block34: {
                                    Object var4_4;
                                    block33: {
                                        if (this.hasTimedOut()) {
                                            if (debugLogger.isDebugEnabled()) {
                                                QueryCache.debug(this.cache.name, "Cache miss: Timeout: " + this.key);
                                            }
                                            this.cache.rtmMBean.incrementCacheMissByTimeoutCount();
                                            return null;
                                        }
                                        this.rlock.lock();
                                        try {
                                            if (!this.containsEmptyResult && this.head == null) {
                                                if (debugLogger.isDebugEnabled()) {
                                                    QueryCache.debug(this.cache.name, "Cache miss: Invalidatad or evicted: " + this.key);
                                                }
                                                var4_4 = null;
                                                Object var11_6 = null;
                                                break block33;
                                            }
                                            Object object4 = null;
                                            if (this.key.getReturnType() == 3) {
                                                object4 = this.getFirstIncludable().getReturnValue(object, bl);
                                                if (object4 == null) {
                                                    if (debugLogger.isDebugEnabled()) {
                                                        QueryCache.debug(this.cache.name, "Cache miss: Single-valued return is null: " + this.key);
                                                    }
                                                    this.cache.rtmMBean.incrementCacheMissByBeanEvictionCount();
                                                }
                                                object3 = object4;
                                                break block34;
                                            }
                                            ArrayList arrayList2 = null;
                                            arrayList2 = this.key.getReturnType() == 1 ? new OrderedSet() : new ArrayList(this.size);
                                            if (this.containsEmptyResult) {
                                                if (debugLogger.isDebugEnabled()) {
                                                    QueryCache.debug(this.cache.name, "Returning empty result: " + this.key);
                                                }
                                                arrayList = arrayList2;
                                                break block35;
                                            }
                                            QueryElementNode queryElementNode = this.head;
                                            for (int i = 0; i < this.size; ++i) {
                                                if (queryElementNode.qcelement.isIncludable()) {
                                                    Object object5 = queryElementNode.qcelement.getReturnValue(object, bl);
                                                    if (object5 == null) {
                                                        if (debugLogger.isDebugEnabled()) {
                                                            QueryCache.debug(this.cache.name, "Cache miss: Multi-valued return at " + i + " is null: " + this.key);
                                                        }
                                                        this.cache.rtmMBean.incrementCacheMissByBeanEvictionCount();
                                                        var9_25 = null;
                                                        break block36;
                                                    }
                                                    if (this.key.getReturnType() == 1) {
                                                        object5 = bl ? new EloWrapper((EJBLocalObject)object5) : new EoWrapper((EJBObject)object5);
                                                    }
                                                    if (object5 == NULL_VALUE) {
                                                        arrayList2.add(null);
                                                    } else {
                                                        arrayList2.add(object5);
                                                    }
                                                }
                                                queryElementNode = queryElementNode.up;
                                            }
                                            if (arrayList2.isEmpty()) {
                                                if (!debugLogger.isDebugEnabled()) throw new AssertionError((Object)"multi-valued get, but no includable results");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                queryElementNode = this.head;
                                                int n = 0;
                                                while (true) {
                                                    if (n >= this.size) {
                                                        QueryCache.debug(this.cache.name, stringBuffer.toString());
                                                        throw new AssertionError((Object)"multi-valued get, but no includable results");
                                                    }
                                                    stringBuffer.append("For key: ").append(this.key).append(", Unincludable: ").append(queryElementNode.qcelement).append("\n");
                                                    queryElementNode = queryElementNode.up;
                                                    ++n;
                                                }
                                            }
                                            object4 = arrayList2;
                                            if (!this.enrollDestinationQueries(object)) {
                                                if (debugLogger.isDebugEnabled()) {
                                                    QueryCache.debug(this.cache.name, "Cache miss: destination query enrollment failure: " + this.key);
                                                }
                                                this.cache.rtmMBean.incrementCacheMissByRelatedQueryMissCount();
                                                var7_20 = null;
                                                break block37;
                                            }
                                            if (!this.enrollDependentQueries(object)) {
                                                if (debugLogger.isDebugEnabled()) {
                                                    QueryCache.debug(this.cache.name, "Cache miss: peer query enrollment failure: " + this.key);
                                                }
                                                this.cache.rtmMBean.incrementCacheMissByDependentQueryMissCount();
                                                var7_21 = null;
                                                break block38;
                                            }
                                            object2 = object4;
                                            break block39;
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_13 = null;
                                            if (debugLogger.isDebugEnabled()) {
                                                this.validate("get");
                                            }
                                            this.rlock.unlock();
                                            throw throwable;
                                        }
                                    }
                                    if (debugLogger.isDebugEnabled()) {
                                        this.validate("get");
                                    }
                                    this.rlock.unlock();
                                    return var4_4;
                                }
                                Object var11_7 = null;
                                if (debugLogger.isDebugEnabled()) {
                                    this.validate("get");
                                }
                                this.rlock.unlock();
                                return object3;
                            }
                            Object var11_8 = null;
                            if (debugLogger.isDebugEnabled()) {
                                this.validate("get");
                            }
                            this.rlock.unlock();
                            return arrayList;
                        }
                        Object var11_9 = null;
                        if (debugLogger.isDebugEnabled()) {
                            this.validate("get");
                        }
                        this.rlock.unlock();
                        return var9_25;
                    }
                    Object var11_10 = null;
                    if (debugLogger.isDebugEnabled()) {
                        this.validate("get");
                    }
                    this.rlock.unlock();
                    return var7_20;
                }
                Object var11_11 = null;
                if (debugLogger.isDebugEnabled()) {
                    this.validate("get");
                }
                this.rlock.unlock();
                return var7_21;
            }
            Object var11_12 = null;
            if (debugLogger.isDebugEnabled()) {
                this.validate("get");
            }
            this.rlock.unlock();
            return object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean enroll(Object object) throws InternalException {
            int n;
            block28: {
                block27: {
                    block26: {
                        boolean bl;
                        block25: {
                            boolean bl2;
                            block24: {
                                boolean bl3;
                                block23: {
                                    boolean bl4;
                                    block22: {
                                        if (this.hasTimedOut()) {
                                            if (debugLogger.isDebugEnabled()) {
                                                QueryCache.debug(this.cache.name, "Cache enroll fail: Timeout for " + this.key);
                                            }
                                            this.cache.rtmMBean.incrementCacheMissByTimeoutCount();
                                            return false;
                                        }
                                        this.rlock.lock();
                                        try {
                                            if (this.head == null) {
                                                if (debugLogger.isDebugEnabled()) {
                                                    QueryCache.debug(this.cache.name, "Cache enroll fail: null head for " + this.key);
                                                }
                                                bl4 = false;
                                                Object var6_6 = null;
                                                break block22;
                                            }
                                            if (this.key.getReturnType() == 3) {
                                                if (!this.getFirstIncludable().enroll(object)) {
                                                    if (debugLogger.isDebugEnabled()) {
                                                        QueryCache.debug(this.cache.name, "Cache single-value enroll fail: for " + this.key);
                                                    }
                                                    this.cache.rtmMBean.incrementCacheMissByBeanEvictionCount();
                                                    bl3 = false;
                                                    break block23;
                                                }
                                                bl2 = true;
                                                break block24;
                                            }
                                            QueryElementNode queryElementNode = this.head;
                                            for (n = 0; n < this.size; n += 1) {
                                                if (!queryElementNode.qcelement.enroll(object)) {
                                                    if (debugLogger.isDebugEnabled()) {
                                                        QueryCache.debug(this.cache.name, "Cache multi-value enroll fail: for " + this.key);
                                                    }
                                                    this.cache.rtmMBean.incrementCacheMissByBeanEvictionCount();
                                                    bl = false;
                                                    break block25;
                                                }
                                                queryElementNode = queryElementNode.up;
                                            }
                                            if (!this.enrollDestinationQueries(object)) {
                                                this.cache.rtmMBean.incrementCacheMissByRelatedQueryMissCount();
                                                n = 0;
                                                break block26;
                                            }
                                            if (!this.enrollDependentQueries(object)) {
                                                this.cache.rtmMBean.incrementCacheMissByDependentQueryMissCount();
                                                n = 0;
                                                break block27;
                                            }
                                            n = 1;
                                            break block28;
                                        }
                                        catch (Throwable throwable) {
                                            Object var6_13 = null;
                                            if (debugLogger.isDebugEnabled()) {
                                                this.validate("get");
                                            }
                                            this.rlock.unlock();
                                            throw throwable;
                                        }
                                    }
                                    if (debugLogger.isDebugEnabled()) {
                                        this.validate("get");
                                    }
                                    this.rlock.unlock();
                                    return bl4;
                                }
                                Object var6_7 = null;
                                if (debugLogger.isDebugEnabled()) {
                                    this.validate("get");
                                }
                                this.rlock.unlock();
                                return bl3;
                            }
                            Object var6_8 = null;
                            if (debugLogger.isDebugEnabled()) {
                                this.validate("get");
                            }
                            this.rlock.unlock();
                            return bl2;
                        }
                        Object var6_9 = null;
                        if (debugLogger.isDebugEnabled()) {
                            this.validate("get");
                        }
                        this.rlock.unlock();
                        return bl;
                    }
                    Object var6_10 = null;
                    if (debugLogger.isDebugEnabled()) {
                        this.validate("get");
                    }
                    this.rlock.unlock();
                    return n != 0;
                }
                Object var6_11 = null;
                if (debugLogger.isDebugEnabled()) {
                    this.validate("get");
                }
                this.rlock.unlock();
                return n != 0;
            }
            Object var6_12 = null;
            if (debugLogger.isDebugEnabled()) {
                this.validate("get");
            }
            this.rlock.unlock();
            return n != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delink() {
            if (debugLogger.isDebugEnabled()) {
                QueryCache.debug(this.cache.name, "Size: " + this.cache.lrulist.size());
            }
            this.cache.rtmMBean.decrementTotalCachedQueriesCount();
            this.wlock.lock();
            try {
                Object object = this.cache.queryAxis;
                synchronized (object) {
                    Object v = this.cache.queryAxis.remove(this.key);
                    if (v != null && v != this) {
                        this.cache.queryAxis.put(this.key, v);
                    }
                }
                object = this.head;
                while (object != null) {
                    if (((QueryElementNode)object).qcelnode != null) {
                        ((QueryElementNode)object).qcelnode.delink((QueryElementNode)object);
                    }
                    object = ((QueryElementNode)object).up;
                }
                this.head = null;
                this.size = 0;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (debugLogger.isDebugEnabled()) {
                    this.validate("delink");
                }
                this.wlock.unlock();
                throw throwable;
            }
            if (debugLogger.isDebugEnabled()) {
                this.validate("delink");
            }
            this.wlock.unlock();
            this.invalidateSourceQueries();
            this.invalidateDependentQueries();
        }

        private boolean enrollDestinationQueries(Object object) throws InternalException {
            if (this.destinationQueries != null) {
                for (QueryCacheKey queryCacheKey : this.destinationQueries) {
                    QueryCache queryCache = (QueryCache)queryCacheKey.getOwnerManager().getQueryCache();
                    if (queryCache.enrollQuery(object, queryCacheKey)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean enrollDependentQueries(Object object) throws InternalException {
            if (this.dependentQueries != null) {
                for (QueryCacheKey queryCacheKey : this.dependentQueries) {
                    QueryCache queryCache = (QueryCache)queryCacheKey.getOwnerManager().getQueryCache();
                    if (queryCache.enrollQuery(object, queryCacheKey)) continue;
                    return false;
                }
            }
            return true;
        }

        private void invalidateSourceQueries() {
            if (this.sourceQueries != null) {
                for (QueryCacheKey queryCacheKey : this.sourceQueries) {
                    QueryCache queryCache = (QueryCache)queryCacheKey.getOwnerManager().getQueryCache();
                    queryCache.invalidate(queryCacheKey);
                }
            }
        }

        private void invalidateDependentQueries() {
            if (this.dependentQueries != null) {
                for (QueryCacheKey queryCacheKey : this.dependentQueries) {
                    QueryCache queryCache = (QueryCache)queryCacheKey.getOwnerManager().getQueryCache();
                    queryCache.invalidate(queryCacheKey);
                }
            }
        }

        private boolean hasTimedOut() {
            return this.expirationTime != 0L && System.currentTimeMillis() > this.expirationTime;
        }

        private QueryCacheElement getFirstIncludable() {
            QueryElementNode queryElementNode = this.head;
            while (queryElementNode != null) {
                if (queryElementNode.qcelement.isIncludable()) {
                    return queryElementNode.qcelement;
                }
                queryElementNode = queryElementNode.up;
            }
            return null;
        }

        private void validate(String string) {
            int n = 0;
            Object object = this.head;
            while (object != null) {
                ++n;
                object = ((QueryElementNode)object).up;
            }
            if (n != this.size) {
                object = new StringBuffer();
                ((StringBuffer)object).append("QueryAxisNode.").append(string).append(" FAIL: got ").append(n).append(", expected ").append(this.size).append(", capacity ").append(this.cache.capacity).append("\n");
                QueryElementNode queryElementNode = this.head;
                while (queryElementNode != null) {
                    ((StringBuffer)object).append(queryElementNode.qckey).append(", ").append(queryElementNode.qcelement);
                    queryElementNode = queryElementNode.up;
                }
                QueryCache.debug(this.cache.name, ((StringBuffer)object).toString());
            }
        }
    }
}

