/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import javax.ejb.EntityBean;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.CacheKey;
import weblogic.ejb.container.interfaces.QueryCache;
import weblogic.ejb.container.manager.TTLManager;

public class QueryCacheElement {
    protected TTLManager beanManager;
    protected Object value;
    protected boolean isInvalidatable = true;
    protected boolean isIncludable = true;
    protected boolean isPrimaryKey = true;
    private int hashcode;

    public QueryCacheElement(Object object) {
        this.value = object == null ? QueryCache.NULL_VALUE : object;
        this.isInvalidatable = false;
        this.isPrimaryKey = false;
    }

    public QueryCacheElement(Object object, TTLManager tTLManager) {
        this.value = object;
        this.beanManager = tTLManager;
        this.hashcode = this.value.hashCode() ^ this.beanManager.hashCode();
    }

    protected QueryCacheElement(CacheKey cacheKey) {
        this.value = cacheKey.getPrimaryKey();
        this.beanManager = (TTLManager)cacheKey.getCallback();
        this.hashcode = this.value.hashCode() ^ this.beanManager.hashCode();
    }

    public Object getReturnValue(Object object, boolean bl) throws InternalException {
        if (this.isPrimaryKey) {
            EntityBean entityBean = this.beanManager.enrollIfNotTimedOut(object, new CacheKey(this.value, this.beanManager));
            if (entityBean != null) {
                return this.beanManager.finderGetEoFromBeanOrPk(entityBean, null, bl);
            }
        } else {
            return this.value;
        }
        return null;
    }

    public boolean enroll(Object object) throws InternalException {
        if (this.isPrimaryKey) {
            return this.beanManager.enrollIfNotTimedOut(object, new CacheKey(this.value, this.beanManager)) != null;
        }
        return true;
    }

    public void setInvalidatable(boolean bl) {
        this.isInvalidatable = bl;
    }

    public void setIncludable(boolean bl) {
        this.isIncludable = bl;
    }

    public boolean isInvalidatable() {
        return this.isInvalidatable;
    }

    public boolean isIncludable() {
        return this.isIncludable;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof QueryCacheElement) {
            QueryCacheElement queryCacheElement = (QueryCacheElement)object;
            return this.hashcode == queryCacheElement.hashcode && this.eq(this.value, queryCacheElement.value) && this.eq(this.beanManager, queryCacheElement.beanManager);
        }
        return false;
    }

    private boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public String toString() {
        if (this.beanManager != null) {
            return this.value.toString() + "#" + this.beanManager.toString();
        }
        return this.value.toString();
    }
}

