/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cache;

import java.util.HashSet;
import java.util.Set;
import weblogic.ejb.container.manager.TTLManager;

public class QueryCacheKey {
    public static final int RET_TYPE_UNKNOWN = 0;
    public static final int RET_TYPE_SET = 1;
    public static final int RET_TYPE_COLLECTION = 2;
    public static final int RET_TYPE_SINGLETON = 3;
    private final String methodIdOrQueryString;
    private final Object[] arguments;
    private final int maxelements;
    private final TTLManager manager;
    private int timeoutMillis = 0;
    private int hash;
    private int returnType;
    private Set sourceQueries;
    private Set destinationQueries;
    private Set dependentQueries;

    public QueryCacheKey(String string, int n, TTLManager tTLManager, int n2) {
        this.methodIdOrQueryString = string;
        this.arguments = new Object[0];
        this.maxelements = n;
        this.manager = tTLManager;
        this.returnType = n2;
        this.hash = this.methodIdOrQueryString.hashCode() ^ this.maxelements ^ this.manager.hashCode();
    }

    public QueryCacheKey(String string, Object[] objectArray, TTLManager tTLManager, int n) {
        this.methodIdOrQueryString = string;
        this.arguments = objectArray == null ? new Object[]{} : objectArray;
        this.maxelements = 0;
        this.manager = tTLManager;
        this.returnType = n;
        this.hash = this.methodIdOrQueryString.hashCode() ^ this.manager.hashCode();
        for (int i = 0; i < this.arguments.length; ++i) {
            this.hash ^= (i + 1) * this.arguments[i].hashCode();
        }
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getMethodId() {
        return this.methodIdOrQueryString;
    }

    public void setTimeoutMillis(int n) {
        this.timeoutMillis = n;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public TTLManager getOwnerManager() {
        return this.manager;
    }

    public void addSourceQuery(QueryCacheKey queryCacheKey) {
        if (this.sourceQueries == null) {
            this.sourceQueries = new HashSet();
        }
        if (!queryCacheKey.equals(this)) {
            this.sourceQueries.add(queryCacheKey);
        }
    }

    public void addDestinationQuery(QueryCacheKey queryCacheKey) {
        if (this.destinationQueries == null) {
            this.destinationQueries = new HashSet();
        }
        if (!queryCacheKey.equals(this)) {
            this.destinationQueries.add(queryCacheKey);
        }
    }

    public void addDependentQuery(QueryCacheKey queryCacheKey) {
        if (this.dependentQueries == null) {
            this.dependentQueries = new HashSet();
        }
        if (!queryCacheKey.equals(this)) {
            this.dependentQueries.add(queryCacheKey);
        }
    }

    protected Set getSourceQueries() {
        return this.sourceQueries;
    }

    protected Set getDestinationQueries() {
        return this.destinationQueries;
    }

    protected Set getDependentQueries() {
        return this.dependentQueries;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof QueryCacheKey) {
            QueryCacheKey queryCacheKey = (QueryCacheKey)object;
            if (this.arguments.length != queryCacheKey.arguments.length) {
                return false;
            }
            if (!this.manager.equals(queryCacheKey.manager)) {
                return false;
            }
            if (!this.methodIdOrQueryString.equals(queryCacheKey.methodIdOrQueryString)) {
                return false;
            }
            if (this.maxelements != queryCacheKey.maxelements) {
                return false;
            }
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].equals(queryCacheKey.arguments[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.methodIdOrQueryString;
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i == 0) {
                string = string + ", L[";
            }
            string = string + this.arguments[i] + ";";
        }
        string = string + "], " + this.maxelements + ", " + this.timeoutMillis + ", " + this.manager;
        return string;
    }
}

