/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.EntityBeanQuery;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.j2ee.descriptor.wl.CompatibilityBean;
import weblogic.j2ee.descriptor.wl.MethodParamsBean;
import weblogic.j2ee.descriptor.wl.QueryMethodBean;
import weblogic.j2ee.descriptor.wl.WeblogicQueryBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;

public final class DefaultHelper {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private boolean isSet_checkExistsOnMethod = false;
    private Set queriesWithIncludeUpdatesSet = null;
    private boolean isSet_orderDatabaseOperations = false;
    private boolean isSet_enableBatchOperations = false;
    private float version = 0.0f;

    public void setVersion(float f) {
        this.version = f;
    }

    public float getVersion() {
        return this.version;
    }

    public void setIsSet_checkExistsOnMethod(boolean bl, String string) {
        if (debugLogger.isDebugEnabled()) {
            DefaultHelper.debug("checkExistsOnMethod has been explicitely set in the DD to '" + string + "'");
        }
        this.isSet_checkExistsOnMethod = bl;
    }

    public boolean isSet_checkExistsOnMethod() {
        return this.isSet_checkExistsOnMethod;
    }

    public void addQueryWithIncludeUpdates(WeblogicQueryBean weblogicQueryBean, String string) {
        if (this.queriesWithIncludeUpdatesSet == null) {
            this.queriesWithIncludeUpdatesSet = new HashSet();
        }
        this.queriesWithIncludeUpdatesSet.add(weblogicQueryBean);
        if (debugLogger.isDebugEnabled()) {
            DefaultHelper.debug("added WeblogicQueryMBean for query '" + weblogicQueryBean.getQueryMethod().getMethodName() + "' to QueryWithIncludeUpdates List with include-updates " + "set in the DD to '" + string + "'");
        }
    }

    public boolean isSet_IncludeUpdates(WeblogicQueryBean weblogicQueryBean) {
        if (this.queriesWithIncludeUpdatesSet == null) {
            return false;
        }
        return this.queriesWithIncludeUpdatesSet.contains(weblogicQueryBean);
    }

    public void setIsSet_orderDatabaseOperations(boolean bl, String string) {
        if (debugLogger.isDebugEnabled()) {
            DefaultHelper.debug("orderDatabaseOperations has been explicitely set in the DD to '" + string + "'");
        }
        this.isSet_orderDatabaseOperations = bl;
    }

    public boolean isSet_orderDatabaseOperations() {
        return this.isSet_orderDatabaseOperations;
    }

    public void setIsSet_enableBatchOperations(boolean bl, String string) {
        if (debugLogger.isDebugEnabled()) {
            DefaultHelper.debug("enableBatchOperations has been set to true, since delay-database-insert-until has been explicitely set in the DD to '" + string + "'");
        }
        this.isSet_enableBatchOperations = bl;
    }

    public boolean isSet_enableBatchOperations() {
        return this.isSet_enableBatchOperations;
    }

    public void adjustDefaults(String string, Collection collection, int n, WeblogicRdbmsJarBean weblogicRdbmsJarBean, WeblogicRdbmsBeanBean weblogicRdbmsBeanBean) throws RDBMSException {
        CompatibilityBean compatibilityBean;
        if (debugLogger.isDebugEnabled()) {
            DefaultHelper.debug("adjustDefaults: ejbName- " + weblogicRdbmsBeanBean.getEjbName());
            DefaultHelper.debug("version- " + this.getVersion());
        }
        if (this.getVersion() < 8.1f) {
            if (!this.isSet_orderDatabaseOperations()) {
                if (debugLogger.isDebugEnabled()) {
                    DefaultHelper.debug(" order-database-operations not set, setting pre 8.1 default 'False'");
                }
                weblogicRdbmsJarBean.setOrderDatabaseOperations(false);
            }
            if (!this.isSet_enableBatchOperations()) {
                if (debugLogger.isDebugEnabled()) {
                    DefaultHelper.debug(" enable-batch-operations not set, setting pre 8.1 default 'False'");
                }
                weblogicRdbmsJarBean.setEnableBatchOperations(false);
            }
            if (!this.isSet_checkExistsOnMethod()) {
                if (debugLogger.isDebugEnabled()) {
                    DefaultHelper.debug(" check-exists-on-method  not set, setting pre J2EE default 'False'");
                }
                weblogicRdbmsBeanBean.setCheckExistsOnMethod(false);
            }
        }
        if ((compatibilityBean = weblogicRdbmsJarBean.getCompatibility()) == null) {
            compatibilityBean = weblogicRdbmsJarBean.createCompatibility();
        }
        compatibilityBean.setSerializeCharArrayToBytes(true);
        compatibilityBean.setDisableStringTrimming(true);
        compatibilityBean.setFindersReturnNulls(false);
        WeblogicQueryBean[] weblogicQueryBeanArray = weblogicRdbmsBeanBean.getWeblogicQueries();
        for (EntityBeanQuery entityBeanQuery : collection) {
            this.processIncludeUpdatesForQuery(weblogicQueryBeanArray, entityBeanQuery, n, weblogicRdbmsBeanBean);
        }
    }

    private void processIncludeUpdatesForQuery(WeblogicQueryBean[] weblogicQueryBeanArray, EntityBeanQuery entityBeanQuery, int n, WeblogicRdbmsBeanBean weblogicRdbmsBeanBean) throws RDBMSException {
        WeblogicQueryBean weblogicQueryBean;
        String string = entityBeanQuery.getMethodName();
        String[] stringArray = entityBeanQuery.getMethodParams();
        if (debugLogger.isDebugEnabled()) {
            DefaultHelper.debug("processIncludeUpdatesForQuery checking method: " + DDUtils.getMethodSignature(string, stringArray));
        }
        if ((weblogicQueryBean = this.getWLQueryMBeanForEntityBeanQuery(entityBeanQuery, weblogicQueryBeanArray)) != null) {
            if (this.isSet_IncludeUpdates(weblogicQueryBean)) {
                if (debugLogger.isDebugEnabled()) {
                    DefaultHelper.debug("existing weblogic-query has include-updates set.  leaving setting as is.");
                }
                return;
            }
            if (debugLogger.isDebugEnabled()) {
                DefaultHelper.debug("existing weblogic-query does NOT have include-updates set.  setting pre J2EE defaults");
            }
            if (this.getVersion() < 8.1f) {
                if (debugLogger.isDebugEnabled()) {
                    DefaultHelper.debug("pre 8.1: setting default include-updates to false");
                }
                weblogicQueryBean.setIncludeUpdates(false);
            }
        } else {
            if (debugLogger.isDebugEnabled()) {
                DefaultHelper.debug("no matching weblogic-query found. setting include-updates to default value. ");
            }
            weblogicQueryBean = weblogicRdbmsBeanBean.createWeblogicQuery();
            QueryMethodBean queryMethodBean = weblogicQueryBean.createQueryMethod();
            queryMethodBean.setMethodName(string);
            MethodParamsBean methodParamsBean = queryMethodBean.createMethodParams();
            methodParamsBean.setMethodParams(stringArray);
            if (this.getVersion() < 8.1f) {
                if (debugLogger.isDebugEnabled()) {
                    DefaultHelper.debug("pre 8.1: setting default include-updates to false");
                }
                weblogicQueryBean.setIncludeUpdates(false);
            }
        }
    }

    private WeblogicQueryBean getWLQueryMBeanForEntityBeanQuery(EntityBeanQuery entityBeanQuery, WeblogicQueryBean[] weblogicQueryBeanArray) {
        if (weblogicQueryBeanArray.length <= 0) {
            return null;
        }
        String string = entityBeanQuery.getMethodName();
        String[] stringArray = entityBeanQuery.getMethodParams();
        for (int i = 0; i < weblogicQueryBeanArray.length; ++i) {
            String[] stringArray2;
            WeblogicQueryBean weblogicQueryBean = weblogicQueryBeanArray[i];
            QueryMethodBean queryMethodBean = weblogicQueryBean.getQueryMethod();
            if (!string.equals(queryMethodBean.getMethodName()) || stringArray.length != (stringArray2 = queryMethodBean.getMethodParams().getMethodParams()).length) continue;
            if (stringArray.length == 0 && stringArray2.length == 0) {
                return weblogicQueryBean;
            }
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                String string3 = stringArray2[j];
                if (string2.equals(string3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return weblogicQueryBean;
        }
        return null;
    }

    private static void debug(String string) {
        debugLogger.debug("[DefaultHelper] " + string);
    }
}

