/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.FinderException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.CMPDDParser;
import weblogic.ejb.container.cmp.rdbms.DefaultHelper;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSDeployment;
import weblogic.ejb.container.cmp.rdbms.RDBMSDeploymentInfo;
import weblogic.ejb.container.cmp.rdbms.RDBMSDescriptor;
import weblogic.ejb.container.cmp.rdbms.RDBMSPersistenceManager;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.RelationshipCaching;
import weblogic.ejb.container.cmp.rdbms.codegen.RDBMSCodeGenerator;
import weblogic.ejb.container.cmp.rdbms.compliance.RDBMSBeanChecker;
import weblogic.ejb.container.cmp.rdbms.compliance.RDBMSComplianceChecker;
import weblogic.ejb.container.cmp.rdbms.finders.EjbqlFinder;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.EJBDescriptorMBeanUtils;
import weblogic.ejb.container.deployer.EntityBeanQueryImpl;
import weblogic.ejb.container.interfaces.EntityBeanQuery;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.CMPCodeGenerator;
import weblogic.ejb.container.persistence.spi.CMPDeployer;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.JarDeployment;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.ejb20.cmp.rdbms.finders.EJBQLCompilerException;
import weblogic.ejb20.cmp.rdbms.finders.InvalidFinderException;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.QueryBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;
import weblogic.j2ee.validation.ComplianceException;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.ProcessorFactoryException;
import weblogic.xml.process.XMLProcessor;

public final class Deployer
implements CMPDeployer {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private RDBMSBean currBean = null;
    private List fieldList = null;
    private List finderList = null;
    private List localFinderList = null;
    private List finderObjectList = null;
    private List primaryKeyList = null;
    private Map parameterMap = null;
    private Class ejbClass = null;
    private Class primaryKeyClass = null;
    private boolean isCompoundPK = true;
    private CMPBeanDescriptor bd = null;
    private Map beanMap = null;
    private Relationships relationships = null;
    private Map dependentMap = null;
    private Map rdbmsRelationMap = null;
    private Map rdbmsDependentMap = null;
    private RDBMSDeployment rdbmsDeployment = null;
    private static final String DOCTYPE_DECL_START = "<!DOCTYPE";

    public void setup(JarDeployment jarDeployment) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called setup()");
        }
        assert (jarDeployment != null);
        this.currBean = null;
        this.rdbmsDeployment = (RDBMSDeployment)jarDeployment;
    }

    public void setCMPBeanDescriptor(CMPBeanDescriptor cMPBeanDescriptor) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called setCMPBeanDescriptor()");
        }
        this.bd = cMPBeanDescriptor;
        this.ejbClass = cMPBeanDescriptor.getBeanClass();
        this.primaryKeyClass = cMPBeanDescriptor.getPrimaryKeyClass();
        if (cMPBeanDescriptor.hasRemoteClientView()) {
            this.finderList = MethodUtils.getFinderMethodList(cMPBeanDescriptor.getHomeInterfaceClass());
        }
        if (cMPBeanDescriptor.hasLocalClientView()) {
            this.localFinderList = MethodUtils.getFinderMethodList(cMPBeanDescriptor.getLocalHomeInterfaceClass());
        }
        this.primaryKeyList = new ArrayList(cMPBeanDescriptor.getPrimaryKeyFieldNames());
        this.isCompoundPK = cMPBeanDescriptor.hasComplexPrimaryKey();
        this.fieldList = new ArrayList(cMPBeanDescriptor.getCMFieldNames());
    }

    public void setBeanMap(Map map) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called setBeanMap()");
        }
        this.beanMap = map;
    }

    public void setRelationships(Relationships relationships) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called setRelationships()");
        }
        this.relationships = relationships;
    }

    public void setDependentMap(Map map) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called setDependentMap()");
        }
        this.dependentMap = map;
    }

    public void setParameters(Map map) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called setParameters()");
        }
        this.parameterMap = new HashMap(map);
    }

    public void initializePersistenceManager(PersistenceManager persistenceManager) throws WLDeploymentException {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called  initializePersistenceManager()");
        }
        RDBMSPersistenceManager rDBMSPersistenceManager = (RDBMSPersistenceManager)persistenceManager;
        rDBMSPersistenceManager.setRdbmsBean(this.currBean);
        this.currBean.setRDBMSPersistenceManager(rDBMSPersistenceManager);
    }

    private boolean fieldListContainsField(String string) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp.rdbms.Deployer.fieldListContainsField()");
        }
        for (String string2 : this.fieldList) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean currBeanContainsField(String string) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp.rdbms.Deployer.currBeanContainsField()");
        }
        for (String string2 : this.currBean.getCmpFieldNames()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public RDBMSBean getTypeSpecificData() {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called getTypeSpecificData()");
        }
        return this.currBean;
    }

    public void setTypeSpecificData(RDBMSBean rDBMSBean) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called setTypeSpecificData()");
        }
        this.currBean = rDBMSBean;
    }

    private static void adjustDefaults(CMPDDParser cMPDDParser, EjbDescriptorBean ejbDescriptorBean, Map map) throws RDBMSException, WLDeploymentException {
        WeblogicRdbmsJarBean weblogicRdbmsJarBean = cMPDDParser.getDescriptorMBean();
        WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
        for (int i = 0; i < weblogicRdbmsBeanBeanArray.length; ++i) {
            Object object;
            Object object2;
            Loggable loggable;
            Object object3;
            String string = weblogicRdbmsBeanBeanArray[i].getEjbName();
            DefaultHelper defaultHelper = cMPDDParser.getDefaultHelper(string);
            Debug.assertion((defaultHelper != null ? 1 : 0) != 0);
            if (map != null) {
                object3 = (CMPBeanDescriptor)map.get(string);
                Debug.assertion((object3 != null ? 1 : 0) != 0);
                defaultHelper.adjustDefaults(object3.getPrimaryKeyClassName(), object3.getAllQueries(), object3.getConcurrencyStrategy(), weblogicRdbmsJarBean, weblogicRdbmsBeanBeanArray[i]);
                continue;
            }
            object3 = EJBDescriptorMBeanUtils.getEnterpriseMBean(string, ejbDescriptorBean);
            if (object3 == null) {
                loggable = EJBLogger.logmissingEnterpriseBeanMBeanLoggable((String)string);
                throw new RDBMSException(loggable.getMessage());
            }
            loggable = null;
            if (!(object3 instanceof EntityBeanBean) || !"2.x".equals(((EntityBeanBean)object3).getCmpVersion())) {
                object2 = EJBLogger.logentityMBeanWrongVersionLoggable((String)string, (String)"ejb20");
                throw new RDBMSException(object2.getMessage());
            }
            loggable = (EntityBeanBean)object3;
            object2 = loggable.getPrimKeyClass();
            ArrayList<EntityBeanQueryImpl> arrayList = new ArrayList<EntityBeanQueryImpl>();
            QueryBean[] queryBeanArray = loggable.getQueries();
            for (int j = 0; j < queryBeanArray.length; ++j) {
                object = new EntityBeanQueryImpl(queryBeanArray[j]);
                arrayList.add((EntityBeanQueryImpl)object);
            }
            WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = EJBDescriptorMBeanUtils.getWeblogicEnterpriseMBean(string, ejbDescriptorBean);
            object = new CompositeMBeanDescriptor((EnterpriseBeanBean)object3, weblogicEnterpriseBeanBean, ejbDescriptorBean);
            String string2 = ((CompositeMBeanDescriptor)object).getConcurrencyStrategy();
            int n = DDUtils.concurrencyStringToInt(string2);
            defaultHelper.adjustDefaults((String)object2, arrayList, n, weblogicRdbmsJarBean, weblogicRdbmsBeanBeanArray[i]);
        }
    }

    public void readTypeSpecificData(VirtualJarFile virtualJarFile, String string) throws Exception {
        ProcessorFactory processorFactory;
        if (this.rdbmsDeployment.needToReadFile(string)) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (debugLogger.isDebugEnabled()) {
                Deployer.debug("processing RDBMS CMP XML for bean: " + this.bd.getEJBName() + " file- " + string);
            }
            this.rdbmsDeployment.addFileName(string);
            processorFactory = new ProcessorFactory();
            WeblogicRdbmsJarBean weblogicRdbmsJarBean = this.parseXMLFile(virtualJarFile, string, this.bd.getEjbDescriptorBean());
            RDBMSDeploymentInfo rDBMSDeploymentInfo = new RDBMSDeploymentInfo(weblogicRdbmsJarBean, this.beanMap, string);
            Map map = rDBMSDeploymentInfo.getRDBMSBeanMap();
            if (rDBMSDeploymentInfo.getRDBMSBean(this.bd.getEJBName()) == null) {
                Loggable loggable = EJBLogger.logUnableToFindBeanInRDBMSDescriptorLoggable((String)this.bd.getEJBName(), (String)string);
                throw new RDBMSException(loggable.getMessage());
            }
            String string2 = weblogicRdbmsJarBean.getDefaultDbmsTablesDdl();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                object5 = (RDBMSBean)iterator.next().getValue();
                ((RDBMSBean)object5).setDatabaseType(MethodUtils.dbmsType2int(weblogicRdbmsJarBean.getDatabaseType()));
                ((RDBMSBean)object5).setOrderDatabaseOperations(weblogicRdbmsJarBean.isOrderDatabaseOperations());
                ((RDBMSBean)object5).setEnableBatchOperations(weblogicRdbmsJarBean.isEnableBatchOperations());
                ((RDBMSBean)object5).setCreateDefaultDBMSTables(weblogicRdbmsJarBean.getCreateDefaultDbmsTables());
                ((RDBMSBean)object5).setValidateDbSchemaWith(weblogicRdbmsJarBean.getValidateDbSchemaWith());
                ((RDBMSBean)object5).setDefaultDbmsTablesDdl(string2);
                object4 = weblogicRdbmsJarBean.getCompatibility();
                if (object4 == null) continue;
                ((RDBMSBean)object5).setByteArrayIsSerializedToOracleBlob(object4.isSerializeByteArrayToOracleBlob());
                ((RDBMSBean)object5).setAllowReadonlyCreateAndRemove(object4.isAllowReadonlyCreateAndRemove());
                ((RDBMSBean)object5).setCharArrayIsSerializedToBytes(object4.isSerializeCharArrayToBytes());
                ((RDBMSBean)object5).setDisableStringTrimming(object4.isDisableStringTrimming());
                ((RDBMSBean)object5).setFindersReturnNulls(object4.isFindersReturnNulls());
                ((RDBMSBean)object5).setLoadRelatedBeansFromDbInPostCreate(object4.isLoadRelatedBeansFromDbInPostCreate());
            }
            if (string2 != null) {
                RDBMSBean.deleteDefaultDbmsTableDdlFile(string2);
            }
            this.rdbmsDeployment.addRdbmsBeans(map);
            this.rdbmsDeployment.addRdbmsRelations(rDBMSDeploymentInfo.getRDBMSRelationMap());
            this.rdbmsDeployment.addDescriptorMBean(weblogicRdbmsJarBean);
            object5 = new RDBMSComplianceChecker(this.beanMap, this.relationships, this.dependentMap, rDBMSDeploymentInfo.getRDBMSBeanMap(), rDBMSDeploymentInfo.getRDBMSRelationMap(), new HashMap(), weblogicRdbmsJarBean);
            ((RDBMSComplianceChecker)object5).checkCompliance();
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                object4 = (RDBMSBean)iterator.next().getValue();
                assert (!object4.normalizeMultiTables_done());
                object3 = (CMPBeanDescriptor)this.beanMap.get(object4.getEjbName());
                object2 = object3.getPrimaryKeyFieldNames();
                object = new ArrayList(object2);
                object4.setPrimaryKeyFields((List)object);
                object4.normalizeMultiTables((CMPBeanDescriptor)this.beanMap.get(object4.getEjbName()));
            }
            iterator = map.entrySet().iterator();
            object4 = null;
            while (iterator.hasNext()) {
                object3 = (RDBMSBean)iterator.next().getValue();
                object2 = ((RDBMSBean)object3).getEjbName();
                object = (CMPBeanDescriptor)this.beanMap.get(object2);
                if (this.rdbmsDeployment.getRDBMSRelationMap().size() == 0) {
                    this.relationships = null;
                }
                assert (!((RDBMSBean)object3).initialized());
                ((RDBMSBean)object3).processDescriptors(this.beanMap, this.relationships, this.dependentMap, this.rdbmsDeployment.getRDBMSBeanMap(), this.rdbmsDeployment.getRDBMSRelationMap(), this.rdbmsDeployment.getRDBMSDependentMap());
                try {
                    this.processFinders((RDBMSBean)object3, (CMPBeanDescriptor)object, this.beanMap);
                }
                catch (Exception exception) {
                    if (object4 == null) {
                        object4 = new ErrorCollectionException();
                    }
                    object4.add((Throwable)exception);
                }
                ((RDBMSBean)object3).setupAutoKeyGen();
                ((RDBMSBean)object3).setupFieldGroupIndexes();
            }
            if (object4 != null && object4.getExceptions().size() > 0) {
                throw object4;
            }
            this.validateFinderQueries();
            this.checkIsValidRelationshipCaching();
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                object3 = (RDBMSBean)iterator.next().getValue();
                ((RDBMSBean)object3).generateFinderSQLStatements(((RDBMSBean)object3).getFinders());
                ((RDBMSBean)object3).createRelationFinders();
                ((RDBMSBean)object3).createRelationFinders2();
                ((RDBMSBean)object3).generateFinderSQLStatements(((RDBMSBean)object3).getRelationFinders());
                ((RDBMSBean)object3).setupRelatedBeanMap();
                this.processEjbSelect(((RDBMSBean)object3).getFinders());
                this.processEjbSelect(((RDBMSBean)object3).getRelationFinders());
                if (string2 == null) continue;
                ((RDBMSBean)object3).addTableDefToDDLFile();
            }
            if (string2 != null) {
                EJBLogger.logDDLFileCreated((String)string2);
            }
        }
        this.currBean = this.rdbmsDeployment.getRDBMSBean(this.bd.getEJBName());
        if (this.currBean == null) {
            processorFactory = EJBLogger.logUnableToFindBeanInRDBMSDescriptor1Loggable((String)this.bd.getEJBName());
            throw new RDBMSException(processorFactory.getMessage());
        }
        this.checkResultTypeMapping(this.currBean.getFinders());
    }

    private void checkResultTypeMapping(Iterator iterator) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        while (iterator.hasNext()) {
            WLDeploymentException wLDeploymentException;
            Finder finder = (Finder)iterator.next();
            if (!finder.isSelect() || finder.getQueryType() != 4 && finder.getQueryType() != 2) continue;
            RDBMSBean rDBMSBean = finder.getSelectBeanTarget();
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
            EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
            if (finder.hasLocalResultType()) {
                if (cMPBeanDescriptor.hasLocalClientView()) continue;
                wLDeploymentException = new WLDeploymentException(eJBComplianceTextFormatter.INVALID_RESULT_TYPE_LOCAL(finder.getRDBMSBean().getEjbName(), DDUtils.getMethodSignature(finder.getName(), finder.getParameterClassNames()), rDBMSBean.getEjbName()));
                errorCollectionException.add((Throwable)wLDeploymentException);
                continue;
            }
            if (!finder.hasRemoteResultType() || cMPBeanDescriptor.hasRemoteClientView()) continue;
            wLDeploymentException = new WLDeploymentException(eJBComplianceTextFormatter.INVALID_RESULT_TYPE_REMOTE(finder.getRDBMSBean().getEjbName(), DDUtils.getMethodSignature(finder.getName(), finder.getParameterClassNames()), rDBMSBean.getEjbName()));
            errorCollectionException.add((Throwable)wLDeploymentException);
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private boolean methodMatchesQuery(Method method, EntityBeanQuery entityBeanQuery) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("methodMatchesQuery called for: " + method.getName() + ", " + entityBeanQuery.getMethodName());
        }
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = entityBeanQuery.getMethodParams();
        if (!method.getName().equals(entityBeanQuery.getMethodName())) {
            if (debugLogger.isDebugEnabled()) {
                Deployer.debug("\tmethodMatchesQuery: returning false");
            }
            return false;
        }
        if (classArray.length != stringArray.length) {
            if (debugLogger.isDebugEnabled()) {
                Deployer.debug("\tmethodMatchesQuery: returning false");
            }
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            String string = MethodUtils.decodeArrayTypes(classArray[i]);
            if (string.equals(stringArray[i])) continue;
            if (debugLogger.isDebugEnabled()) {
                Deployer.debug("\tmethodMatchesQuery: returning false");
            }
            return false;
        }
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("\tmethodMatchesQuery: returning true");
        }
        return true;
    }

    private Method[] getMethodsForQuery(String string, EntityBeanQuery entityBeanQuery, List list, List list2) throws Exception {
        boolean bl = false;
        Method[] methodArray = new Method[2];
        int n = 0;
        Iterator iterator = null;
        EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
        if (entityBeanQuery.getMethodName().startsWith("find")) {
            iterator = list.iterator();
        } else if (entityBeanQuery.getMethodName().startsWith("ejbSelect")) {
            iterator = list2.iterator();
            bl = true;
        } else {
            throw new InvalidFinderException(8, eJBComplianceTextFormatter.INVALID_QUERY_NAME(string, DDUtils.getMethodSignature(entityBeanQuery.getMethodName(), entityBeanQuery.getMethodParams())), new DescriptorErrorInfo("<ejb-ql>", (Object)string, (Object)entityBeanQuery.getMethodName()));
        }
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!this.methodMatchesQuery(method, entityBeanQuery)) continue;
            methodArray[n] = method;
            if (!bl && ++n != 2) continue;
            break;
        }
        if (n == 0) {
            throw new InvalidFinderException(8, eJBComplianceTextFormatter.QUERY_NOT_FOUND(string, entityBeanQuery.getMethodSignature()), new DescriptorErrorInfo("<ejb-ql>", (Object)string, (Object)entityBeanQuery.getMethodName()));
        }
        return methodArray;
    }

    private Method getFindByPrimaryKeyMethod(List list) {
        for (Method method : list) {
            if (!method.getName().equals("findByPrimaryKey")) continue;
            return method;
        }
        throw new AssertionError("Method 'findByPrimaryKey' not found on Home interface.");
    }

    private void processFinders(RDBMSBean rDBMSBean, CMPBeanDescriptor cMPBeanDescriptor, Map map) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Collection collection = cMPBeanDescriptor.getAllQueries();
        if (collection == null) {
            Loggable loggable = EJBLogger.logFinderCollectionIsNullLoggable((String)"Deployer.readTypeSpecificData");
            throw new Exception(loggable.getMessage());
        }
        Iterator iterator = collection.iterator();
        Finder finder = null;
        Class clazz = cMPBeanDescriptor.getBeanClass();
        Class clazz2 = cMPBeanDescriptor.getHomeInterfaceClass();
        Class clazz3 = cMPBeanDescriptor.getLocalHomeInterfaceClass();
        List list = MethodUtils.getFinderMethodList(clazz2, clazz3);
        List list2 = MethodUtils.getSelectMethodList(clazz);
        while (iterator.hasNext()) {
            object3 = (EntityBeanQuery)iterator.next();
            try {
                if (debugLogger.isDebugEnabled()) {
                    Deployer.debug("\n ++++++++  about to create new finder for: " + object3.getMethodName() + "  " + object3.getQueryText());
                }
                finder = rDBMSBean.createFinder(object3.getMethodName(), object3.getMethodParams(), object3.getQueryText());
            }
            catch (InvalidFinderException invalidFinderException) {
                if (debugLogger.isDebugEnabled()) {
                    Deployer.debug("getRDBMSBean returned exception " + invalidFinderException);
                }
                invalidFinderException.setDescriptorErrorInfo(new DescriptorErrorInfo("<query-method>", (Object)rDBMSBean.getEjbName(), (Object)object3.getMethodName()));
                throw invalidFinderException;
            }
            object2 = this.getMethodsForQuery(cMPBeanDescriptor.getEJBName(), (EntityBeanQuery)object3, list, list2);
            finder.setMethods((Method[])object2);
            finder.setFinderLoadsBean(cMPBeanDescriptor.getFindersLoadBean());
            if (finder.isSelect()) {
                finder.setResultTypeMapping(object3.getResultTypeMapping());
            }
            rDBMSBean.perhapsSetQueryCachingEnabled(finder);
            rDBMSBean.addFinder(finder);
        }
        object3 = null;
        if (RDBMSBeanChecker.validateCategoryFieldAvailible(rDBMSBean)) {
            object3 = rDBMSBean.getCategoryCmpField();
        }
        if (object3 != null) {
            if (debugLogger.isDebugEnabled()) {
                Deployer.debug("category-cmp-field " + (String)object3 + " is set to EJB " + rDBMSBean.getEjbName());
            }
            object2 = "findByCategory__WL_";
            object = rDBMSBean.getCmpFieldClass((String)object3);
            String[] stringArray = new String[]{((Class)object).getName()};
            String string = "SELECT Object(bean) FROM " + rDBMSBean.getAbstractSchemaName() + " AS bean WHERE bean." + (String)object3 + " = ?1";
            Finder finder2 = rDBMSBean.createFinder((String)object2, stringArray, string);
            finder2.setReturnClassType(Collection.class);
            finder2.setExceptionClassTypes(new Class[]{FinderException.class});
            finder2.setModifierString("public ");
            finder2.setParameterClassTypes(new Class[]{object});
            finder2.setFinderLoadsBean(true);
            if (debugLogger.isDebugEnabled()) {
                Deployer.debug("categoryFinder created: " + finder2);
            }
            rDBMSBean.addFinder(finder2);
        }
        object2 = null;
        if (cMPBeanDescriptor.hasRemoteClientView()) {
            object = MethodUtils.getFinderMethodList(cMPBeanDescriptor.getHomeInterfaceClass());
            try {
                this.checkClassFinderForXMLFinder(cMPBeanDescriptor.getEJBName(), object.iterator(), collection);
            }
            catch (Exception exception) {
                if (object2 == null) {
                    object2 = new ErrorCollectionException();
                }
                object2.add((Throwable)exception);
            }
        }
        if (cMPBeanDescriptor.hasLocalClientView()) {
            object = MethodUtils.getFinderMethodList(cMPBeanDescriptor.getLocalHomeInterfaceClass());
            try {
                this.checkClassFinderForXMLFinder(cMPBeanDescriptor.getEJBName(), object.iterator(), collection);
            }
            catch (Exception exception) {
                if (object2 == null) {
                    object2 = new ErrorCollectionException();
                }
                object2.add((Throwable)exception);
            }
        }
        try {
            this.checkClassFinderForXMLFinder(cMPBeanDescriptor.getEJBName(), list2.iterator(), collection);
        }
        catch (Exception exception) {
            if (object2 == null) {
                object2 = new ErrorCollectionException();
            }
            object2.add((Throwable)exception);
        }
        if (object2 != null) {
            throw object2;
        }
        object = this.generateFindByPrimaryKeyFinder(rDBMSBean);
        ((Finder)object).setFinderLoadsBean(cMPBeanDescriptor.getFindersLoadBean());
        rDBMSBean.addFinder((Finder)object);
    }

    private void processEjbSelect(Iterator iterator) {
        while (iterator.hasNext()) {
            Finder finder = (Finder)iterator.next();
            if (!finder.isSelect() && !finder.isSelectInEntity() || finder.getQueryType() != 4 && finder.getQueryType() != 2) continue;
            RDBMSBean rDBMSBean = finder.getSelectBeanTarget();
            CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
            finder.setFinderLoadsBean(cMPBeanDescriptor.getFindersLoadBean());
            rDBMSBean.addToEjbSelectInternalList(finder);
        }
    }

    private void checkClassFinderForXMLFinder(String string, Iterator iterator, Collection collection) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = null;
        EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (method.getName().equals("findByPrimaryKey")) continue;
            Iterator iterator2 = collection.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                EntityBeanQuery entityBeanQuery = (EntityBeanQuery)iterator2.next();
                if (!this.methodMatchesQuery(method, entityBeanQuery)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (errorCollectionException == null) {
                errorCollectionException = new ErrorCollectionException();
            }
            errorCollectionException.add((Throwable)new InvalidFinderException(8, eJBComplianceTextFormatter.MISSING_QUERY_IN_EJBJAR(string, DDUtils.getMethodSignature(method)), new DescriptorErrorInfo("<ejb-ql>", (Object)string, (Object)DDUtils.getMethodSignature(method))));
        }
        if (errorCollectionException != null) {
            throw errorCollectionException;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WeblogicRdbmsJarBean parseXMLFile(VirtualJarFile var1_1, String var2_2, EjbDescriptorBean var3_3) throws Exception {
        block22: {
            block23: {
                block21: {
                    var4_4 = null;
                    if (Deployer.debugLogger.isDebugEnabled()) {
                        Deployer.debug("called parseXMLFile() fileName=" + var2_2);
                    }
                    var5_5 = null;
                    try {
                        try {
                            if (var1_1 == null) {
                                var4_4 = this.parseXMLFileWithSchema(null, var2_2, var3_3);
                                if (var4_4 == null) {
                                    var6_6 = EJBLogger.logRdbmsDescriptorNotFoundInJarLoggable((String)var2_2);
                                    throw new RDBMSException(var6_6.getMessage());
                                }
                                var6_7 = var4_4;
                                var10_11 = null;
                                break block21;
                            }
                            var7_21 = var1_1.getEntry(var2_2);
                            if (var7_21 != null) {
                                var6_8 = var1_1.getInputStream(var7_21);
                                var5_5 = new BufferedInputStream(var6_8);
                                var6_8 = Deployer.parseXMLFile(var5_5, var2_2, var3_3, this.beanMap);
                                break block22;
                            }
                            var4_4 = this.parseXMLFileWithSchema(var1_1, var2_2, var3_3);
                            if (var4_4 == null) {
                                var8_26 = EJBLogger.logRdbmsDescriptorNotFoundInJarLoggable((String)var2_2);
                                throw new RDBMSException(var8_26.getMessage());
                            }
                            var8_27 = var4_4;
                            break block23;
                        }
                        catch (ProcessorFactoryException var6_9) {
                            if (var5_5 == null) throw var6_9;
                            try {
                                var5_5.reset();
                                var4_4 = this.parseXMLFileWithSchema(var1_1, var2_2, var3_3);
                                if (var4_4 == null) {
                                    var7_22 = EJBLogger.logRdbmsDescriptorNotFoundInJarLoggable((String)var2_2);
                                    throw new RDBMSException(var7_22.getMessage());
                                }
                                var7_23 = var4_4;
                            }
                            catch (RDBMSException var7_24) {
                                throw var7_24;
                            }
                            catch (Exception var7_25) {
                                throw new RDBMSException(StackTraceUtils.throwable2StackTrace((Throwable)var7_25));
                            }
                            var10_14 = null;
                            try {
                                if (var5_5 == null) return var7_23;
                                var5_5.close();
                                return var7_23;
                            }
                            catch (IOException var11_19) {
                                // empty catch block
                            }
                            return var7_23;
                        }
                        catch (IOException var6_10) {
                            throw new RDBMSException(StackTraceUtils.throwable2StackTrace((Throwable)var6_10));
                        }
                    }
                    catch (Throwable var9_28) {
                        var10_15 = null;
                        try {}
                        catch (IOException var11_20) {
                            throw var9_28;
                        }
                        if (var5_5 == null) throw var9_28;
                        var5_5.close();
                        throw var9_28;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [13 : 288->301)] { 
lbl65:
                // 1 sources

                if (var5_5 == null) return var6_7;
                var5_5.close();
                return var6_7;
lbl68:
                // 1 sources

                catch (IOException var11_16) {
                    // empty catch block
                }
                return var6_7;
            }
            var10_12 = null;
            ** try [egrp 3[TRYBLOCK] [13 : 288->301)] { 
lbl74:
            // 1 sources

            if (var5_5 == null) return var8_27;
            var5_5.close();
            return var8_27;
lbl77:
            // 1 sources

            catch (IOException var11_17) {
                // empty catch block
            }
            return var8_27;
        }
        var10_13 = null;
        try {}
        catch (IOException var11_18) {
            // empty catch block
            return var6_8;
        }
        if (var5_5 == null) return var6_8;
        var5_5.close();
        return var6_8;
    }

    public static WeblogicRdbmsJarBean parseXMLFile(BufferedInputStream bufferedInputStream, String string, EjbDescriptorBean ejbDescriptorBean, Map map) throws Exception {
        CMPDDParser cMPDDParser = null;
        ProcessorFactory processorFactory = new ProcessorFactory();
        String string2 = DDUtils.getXMLEncoding(bufferedInputStream, string);
        bufferedInputStream.mark(0x100000);
        if (Deployer.isSchemaBasedDD(bufferedInputStream)) {
            throw new ProcessorFactoryException("This is a Schema based DD");
        }
        bufferedInputStream.reset();
        bufferedInputStream.mark(0x100000);
        XMLProcessor xMLProcessor = processorFactory.getProcessor(bufferedInputStream, RDBMSUtils.validRdbmsCmp20JarPublicIds);
        bufferedInputStream.reset();
        if (!(xMLProcessor instanceof CMPDDParser)) {
            Loggable loggable = EJBLogger.logCmp20DDHasWrongDocumentTypeLoggable();
            String string3 = loggable.getMessage() + "\n";
            for (int i = 0; i < RDBMSUtils.validRdbmsCmp20JarPublicIds.length; ++i) {
                string3 = string3 + "\"" + RDBMSUtils.validRdbmsCmp20JarPublicIds[i] + "\"\n";
            }
            throw new RDBMSException(string3);
        }
        cMPDDParser = (CMPDDParser)((Object)xMLProcessor);
        if (null != cMPDDParser) {
            cMPDDParser.setFileName(string);
            cMPDDParser.setEJBDescriptor(ejbDescriptorBean);
            cMPDDParser.process(bufferedInputStream);
            Deployer.adjustDefaults(cMPDDParser, ejbDescriptorBean, map);
            return cMPDDParser.getDescriptorMBean();
        }
        throw new AssertionError("Couldn't find a loader RDBMS CMP deployment descriptor '" + string + "'. The document probably references an unknown DTD.");
    }

    private WeblogicRdbmsJarBean parseXMLFileWithSchema(VirtualJarFile virtualJarFile, String string, EjbDescriptorBean ejbDescriptorBean) throws Exception {
        try {
            WeblogicRdbmsJarBean weblogicRdbmsJarBean = null;
            RDBMSDescriptor rDBMSDescriptor = new RDBMSDescriptor(virtualJarFile, string, ejbDescriptorBean.getAppName(), ejbDescriptorBean.getUri(), ejbDescriptorBean.getDeploymentPlan(), ejbDescriptorBean.getConfigDirectory());
            weblogicRdbmsJarBean = ejbDescriptorBean.isReadOnly() ? (WeblogicRdbmsJarBean)rDBMSDescriptor.getDescriptorBean() : (WeblogicRdbmsJarBean)rDBMSDescriptor.getEditableDescriptorBean();
            ejbDescriptorBean.addWeblogicRdbmsJarBean(weblogicRdbmsJarBean);
            return weblogicRdbmsJarBean;
        }
        catch (Exception exception) {
            throw new RDBMSException(StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
    }

    public void preCodeGeneration(CMPCodeGenerator cMPCodeGenerator) throws ErrorCollectionException {
        assert (cMPCodeGenerator instanceof RDBMSCodeGenerator);
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called preCodeGeneration()");
        }
        RDBMSCodeGenerator rDBMSCodeGenerator = (RDBMSCodeGenerator)cMPCodeGenerator;
        rDBMSCodeGenerator.setCMPBeanDescriptor(this.bd);
        rDBMSCodeGenerator.setRDBMSBean(this.currBean);
        rDBMSCodeGenerator.setFinderList(this.currBean.getFinderList());
        rDBMSCodeGenerator.setEjbSelectInternalList(this.currBean.getEjbSelectInternalList());
        rDBMSCodeGenerator.setParameterMap(this.parameterMap);
    }

    public void postCodeGeneration(CMPCodeGenerator cMPCodeGenerator) {
        assert (cMPCodeGenerator instanceof RDBMSCodeGenerator);
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called postCodeGeneration()");
        }
    }

    private void validateFinderQueries() throws ErrorCollectionException {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called validateFinderQueries.");
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Map map = this.rdbmsDeployment.getRDBMSBeanMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            RDBMSBean rDBMSBean = (RDBMSBean)iterator.next().getValue();
            Iterator iterator2 = rDBMSBean.getFinders();
            while (iterator2.hasNext()) {
                Finder finder = (Finder)iterator2.next();
                try {
                    if (!(finder instanceof EjbqlFinder)) continue;
                    ((EjbqlFinder)finder).parseExpression();
                }
                catch (EJBQLCompilerException eJBQLCompilerException) {
                    errorCollectionException.add((Throwable)eJBQLCompilerException);
                }
            }
        }
        if (errorCollectionException.getExceptions().size() > 0) {
            throw errorCollectionException;
        }
    }

    private void checkIsValidRelationshipCaching() throws ErrorCollectionException {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("called checkIsValidRelationshipCaching.");
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Map map = this.rdbmsDeployment.getRDBMSBeanMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            RDBMSBean rDBMSBean = (RDBMSBean)iterator.next().getValue();
            for (RelationshipCaching relationshipCaching : rDBMSBean.getRelationshipCachings()) {
                Iterator iterator2 = relationshipCaching.getCachingElements().iterator();
                this.checkIsValidRelationshipCachingForCachingElements(rDBMSBean, iterator2, relationshipCaching, errorCollectionException, rDBMSBean);
            }
        }
        if (errorCollectionException.getExceptions().size() > 0) {
            throw errorCollectionException;
        }
    }

    private void checkIsValidRelationshipCachingForCachingElements(RDBMSBean rDBMSBean, Iterator iterator, RelationshipCaching relationshipCaching, ErrorCollectionException errorCollectionException, RDBMSBean rDBMSBean2) {
        EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
        Map map = this.rdbmsDeployment.getRDBMSBeanMap();
        while (iterator.hasNext()) {
            Iterator iterator22;
            RelationshipCaching.CachingElement cachingElement = (RelationshipCaching.CachingElement)iterator.next();
            String string = cachingElement.getCmrField();
            String string2 = cachingElement.getGroupName();
            if (!rDBMSBean.getAllCmrFields().contains(string)) {
                errorCollectionException.add((Throwable)new ComplianceException(eJBComplianceTextFormatter.RELATIONSHIP_CACHING_CONTAINS_UNDEFINED_CMR_FIELD(rDBMSBean.getEjbName(), relationshipCaching.getCachingName(), string), new DescriptorErrorInfo("<relationship-caching>", (Object)rDBMSBean.getEjbName(), (Object)relationshipCaching.getCachingName())));
                continue;
            }
            RDBMSBean rDBMSBean3 = rDBMSBean.getRelatedRDBMSBean(string);
            if (rDBMSBean3.getFieldGroup(string2) == null) {
                errorCollectionException.add((Throwable)new ComplianceException(eJBComplianceTextFormatter.RELATIONSHIP_CACHING_CONTAINS_UNDEFINED_GROUP_NAME(rDBMSBean.getEjbName(), relationshipCaching.getCachingName(), rDBMSBean3.getEjbName(), string2), new DescriptorErrorInfo("<relationship-caching>", (Object)rDBMSBean.getEjbName(), (Object)relationshipCaching.getCachingName())));
            }
            if (rDBMSBean2.isOptimistic() && !rDBMSBean3.isOptimistic() && !rDBMSBean3.isReadOnly()) {
                errorCollectionException.add((Throwable)new ComplianceException(eJBComplianceTextFormatter.RELATIONSHIP_CACHING_INCONSISTENT_CONCURRENCY_STRATEGY(rDBMSBean2.getEjbName(), relationshipCaching.getCachingName(), rDBMSBean3.getEjbName()), new DescriptorErrorInfo("<relationship-caching>", (Object)rDBMSBean2.getEjbName(), (Object)relationshipCaching.getCachingName())));
            }
            for (Iterator iterator22 : this.relationships.getAllEjbRelations().values()) {
                Iterator iterator3 = iterator22.getAllEjbRelationshipRoles().iterator();
                EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator3.next();
                EjbRelationshipRole ejbRelationshipRole2 = (EjbRelationshipRole)iterator3.next();
                boolean bl = false;
                if (ejbRelationshipRole.getCmrField() != null) {
                    bl = string.equals(ejbRelationshipRole.getCmrField().getName());
                }
                if (ejbRelationshipRole2.getCmrField() != null) {
                    boolean bl2 = bl = bl || string.equals(ejbRelationshipRole2.getCmrField().getName());
                }
                if (!bl) continue;
                RDBMSBean rDBMSBean4 = (RDBMSBean)map.get(ejbRelationshipRole.getRoleSource().getEjbName());
                RDBMSBean rDBMSBean5 = (RDBMSBean)map.get(ejbRelationshipRole2.getRoleSource().getEjbName());
                if ((rDBMSBean != rDBMSBean4 || rDBMSBean3 != rDBMSBean5) && (rDBMSBean != rDBMSBean5 || rDBMSBean3 != rDBMSBean4) || !ejbRelationshipRole.getMultiplicity().equalsIgnoreCase("many") || !ejbRelationshipRole2.getMultiplicity().equalsIgnoreCase("many")) continue;
                errorCollectionException.add((Throwable)new ComplianceException(eJBComplianceTextFormatter.RELATIONSHIP_CACHING_CANNOT_BE_SPECIFIED(rDBMSBean.getEjbName(), relationshipCaching.getCachingName(), rDBMSBean3.getEjbName())));
            }
            iterator22 = cachingElement.getCachingElements().iterator();
            if (!iterator22.hasNext()) continue;
            this.checkIsValidRelationshipCachingForCachingElements(rDBMSBean3, iterator22, relationshipCaching, errorCollectionException, rDBMSBean2);
        }
    }

    private Finder generateFindByPrimaryKeyFinder(RDBMSBean rDBMSBean) throws Exception {
        Class<?>[] classArray;
        Object object;
        CMPBeanDescriptor cMPBeanDescriptor;
        assert (this.primaryKeyClass != null) : "PrimaryKeyClass is null";
        assert (this.ejbClass != null) : "ejbClass is null";
        assert (rDBMSBean != null) : "currBean is null";
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp.rdbms.Deployer.generateFindByPrimaryKeyFinder()");
        }
        if ((cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor()) == null) {
            Loggable loggable = EJBLogger.logCmpBeanDescriptorIsNullLoggable((String)"Deployer.generateFindByPrimaryKeyFinder", (String)rDBMSBean.getEjbName());
            throw new Exception(loggable.getMessage());
        }
        Class clazz = cMPBeanDescriptor.getPrimaryKeyClass();
        String string = "findByPrimaryKey";
        String string2 = rDBMSBean.findByPrimaryKeyQuery();
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("Created findByPrimaryKey query of " + string2);
        }
        Method method = null;
        try {
            object = null;
            object = cMPBeanDescriptor.hasRemoteClientView() ? cMPBeanDescriptor.getHomeInterfaceClass() : cMPBeanDescriptor.getLocalHomeInterfaceClass();
            classArray = MethodUtils.getFinderMethodList((Class)object);
            method = this.getFindByPrimaryKeyMethod((List)classArray);
        }
        catch (Exception exception) {
            throw new AssertionError("Caught an Exception while setting in generated finder props: " + exception.toString());
        }
        object = null;
        try {
            classArray = method.getParameterTypes();
            String[] stringArray = new String[classArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
            object = (EjbqlFinder)rDBMSBean.createFinder(string, stringArray, string2);
        }
        catch (InvalidFinderException invalidFinderException) {
            throw new AssertionError("Caught an InvalidFinderException in generated finder: " + invalidFinderException);
        }
        ((Finder)object).setKeyFinder(true);
        ((EjbqlFinder)object).setKeyBean(rDBMSBean);
        ((EjbqlFinder)object).setMethods(new Method[]{method});
        return object;
    }

    public String toString() {
        Object object;
        Iterator<Object> iterator;
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("[weblogic.cmp.rdbms.Deployer =\n");
        stringBuffer.append("\tbean class = " + (this.ejbClass != null ? this.ejbClass.getName() : "null"));
        stringBuffer.append("\n");
        stringBuffer.append("\tprimary key class = " + (this.primaryKeyClass != null ? this.primaryKeyClass.getName() : "null"));
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("\tparameterMap = {");
        if (this.parameterMap == null || this.parameterMap.keySet() == null) {
            stringBuffer.append("null}\n");
        } else {
            iterator = this.parameterMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuffer.append("(" + (String)object + "," + "value" + ")");
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append("}\n");
            }
        }
        stringBuffer.append("\tfieldList = {");
        if (this.fieldList == null) {
            stringBuffer.append("null}\n");
        } else {
            iterator = this.fieldList.iterator();
            while (iterator.hasNext()) {
                object = (Field)iterator.next();
                stringBuffer.append(((Field)object).getName());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append("}\n");
            }
        }
        stringBuffer.append("\tfinderList = {");
        if (this.finderList == null) {
            stringBuffer.append("null}\n");
        } else {
            iterator = this.finderList.iterator();
            while (iterator.hasNext()) {
                object = (Method)iterator.next();
                stringBuffer.append(((Method)object).getName());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append("}\n");
            }
        }
        stringBuffer.append("\tprimaryKeyList = {");
        if (this.primaryKeyList == null) {
            stringBuffer.append("null}\n");
        } else {
            iterator = this.primaryKeyList.iterator();
            while (iterator.hasNext()) {
                object = (Field)iterator.next();
                stringBuffer.append(((Field)object).getName());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append("}\n");
            }
        }
        if (this.currBean == null) {
            stringBuffer.append("\tcurrBean = null\n");
        } else {
            stringBuffer.append("\t" + this.currBean.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public RDBMSDeployment getJarDeployment() {
        return this.rdbmsDeployment;
    }

    public static boolean isSchemaBasedDD(BufferedInputStream bufferedInputStream) throws ProcessorFactoryException, IOException {
        byte[] byArray = new byte[1000];
        bufferedInputStream.read(byArray, 0, 1000);
        String string = new String(byArray);
        return string.indexOf(DOCTYPE_DECL_START) == -1;
    }

    private static void debug(String string) {
        debugLogger.debug("[Deployer] " + string);
    }
}

