/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.EJBQLParsingException;
import weblogic.ejb.container.cmp.rdbms.FieldGroup;
import weblogic.ejb.container.cmp.rdbms.RDBMSPersistenceManager;
import weblogic.ejb.container.cmp.rdbms.RDBMSRelation;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.RelationshipCaching;
import weblogic.ejb.container.cmp.rdbms.SqlShape;
import weblogic.ejb.container.cmp.rdbms.finders.EjbqlFinder;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.cmp.rdbms.finders.RDBMSFinder;
import weblogic.ejb.container.cmp.rdbms.finders.SqlFinder;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.Log;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.CmrField;
import weblogic.ejb.container.persistence.spi.EjbEntityRef;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.container.persistence.spi.RoleSource;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.ejb20.cmp.rdbms.finders.EJBQLCompilerException;
import weblogic.ejb20.cmp.rdbms.finders.InvalidFinderException;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StackTraceUtils;

public final class RDBMSBean
implements Cloneable {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private String dataSourceName = null;
    private List cmpFieldNames = null;
    private Map cmpFieldClasses = null;
    private Map tableNames = null;
    private List tableNamesList = null;
    private Map tableName2cmpFieldName2columnName = null;
    private Map tableName2verifyRows = null;
    private Map tableName2verifyColumns = null;
    private Map tableName2optimisticColumn = null;
    private Map tableName2optimisticColumnTrigger = null;
    private Map tableName2versionColumnInitialValue = null;
    private boolean verifyReads = false;
    private List cmpColumnNames = null;
    private Map fieldName2columnName = null;
    private Map columnName2fieldName = null;
    private Map fieldName2columnTypeName = null;
    private Map cmpFieldName2groupName = null;
    private Set dbmsDefaultValueFields = null;
    private List fieldGroups = null;
    private List relationshipCachings = null;
    private Map rdbmsFinders = null;
    private String delayInsertUntil = "ejbPostCreate";
    private boolean useSelectForUpdate = false;
    private int lockOrder = 0;
    private String instanceLockOrder = "AccessOrder";
    private short genKeyType = (short)-1;
    private String genKeyGeneratorName = null;
    private int genKeyCacheSize = 0;
    private boolean selectFirstSeqKeyBeforeUpdate = false;
    protected boolean orderDatabaseOperations = true;
    protected boolean enableBatchOperations = true;
    private String createDefaultDBMSTables = "Disabled";
    private String ddlFileName = null;
    private int databaseType = 0;
    private boolean checkExistsOnMethod = true;
    private boolean hasBlobColumn = false;
    private boolean hasClobColumn = false;
    private boolean hasNClobColumn = false;
    private boolean hasBlobClobColumn = false;
    private boolean byteArrayIsSerializedToOracleBlob = false;
    private boolean loadRelatedBeansFromDbInPostCreate = false;
    private boolean allowReadonlyCreateAndRemove = false;
    private boolean charArrayIsSerializedToBytes = false;
    private boolean disableStringTrimming = false;
    private boolean findersReturnNulls = true;
    private String validateDbSchemaWith = "";
    private Map sqlShapes = null;
    private CMPBeanDescriptor bd = null;
    private String ejbName = null;
    private List primaryKeyFieldList = null;
    private List finderList = null;
    private boolean hasResultSetFinder = false;
    private Map beanMap = null;
    private Relationships relationships = null;
    private Map dependentMap = null;
    private Map rdbmsBeanMap = null;
    private Map rdbmsRelationMap = null;
    private Map rdbmsDependentMap = null;
    private boolean normalizeMultiTables_done = false;
    private boolean fieldsLoadedViaMultiTable = true;
    private Map table2cmpf2columnPKsOnly = null;
    private Map table2cmpf2columnNoPKs = null;
    private Map table2column2cmpf = null;
    private Map table2column2variable = null;
    private Map cmpf2Table = null;
    private Map pkCmpF2Table2Column = null;
    private Map column2tables = null;
    private Map variableName2table = null;
    private Map variableName2cmrField = null;
    int numFields = 0;
    private Map fieldNameToIsModifiedIndex = null;
    private Map isModifiedIndexToFieldName = null;
    private List isModifiedPKIndexList = null;
    private List isModifiedIndexToTableNumber = new ArrayList();
    private List[] tableIndexToFieldList;
    private List[] tableIndexToNonPKFieldList;
    private List[] tableIndexToCMPFieldList;
    private List[] tableIndexToCMRFieldList;
    private boolean synthesized = false;
    private Map fieldName2class = null;
    private List cmrFieldNames = null;
    private List fkFieldNames = null;
    private List fkPkFieldNames = null;
    private List fkCmpFieldNames = null;
    private List declaredFieldNames = null;
    private List remoteFieldNames = null;
    private Set one2one = null;
    private Set one2many = null;
    private Set many2many = null;
    private Set biDirectional = null;
    private Map fieldName2cascadeDelete = null;
    private Map fieldName2DBCascadeDelete = null;
    private boolean selfRelationship = false;
    private Map fieldName2selfRel = null;
    private Map fkField2fkColumns = null;
    private Map fkField2fkColumn2Class = null;
    private Map fkField2fkColumn2FieldName = null;
    private Map fieldName2relatedDescriptor = null;
    private Map fieldName2relatedMultiplicity = null;
    private Map fieldName2relatedFieldOwnsFk = null;
    private Map fieldName2relatedClassName = null;
    private Map fieldName2relatedRDBMSBean = null;
    private Map fieldName2RelatedFieldName = null;
    private Map fieldName2groupName = null;
    private Map variableName2columnName = null;
    private Map fieldName2tableName = null;
    private Map groupName2tableNames = null;
    private Map fieldName2entityRef = null;
    private Map fieldName2remoteColumn = null;
    private Map fkField2symColumn2FieldName = null;
    private Map fkField2symColumns = null;
    private Set cmrMappedcmpFields = null;
    private Map cmrMapeedRelationFinder = null;
    private Map table2cmrf = null;
    private Map cmrf2table = null;
    private List cmrfHasMultiPkTable = null;
    private Map cmrf2pkTable2fkColumn2pkColumn = null;
    private Map fkField2pkTable2symColumns = null;
    private Map fkField2pktable2symColumn2field = null;
    private Map fkField2pkTable2symFkColumn2pkColumn = null;
    private Map table2fkCol2fkClass = null;
    private Map table2fkCol2RelatedBean = null;
    private List ejbSelectInternalList = null;
    private String synthAbstractSchemaName = null;
    private boolean genKeyBeforeInsert = true;
    private boolean genKeyExcludePKColumn = false;
    private String genKeyDefaultColumnVal = null;
    private String genKeyWLGeneratorQuery = "";
    private String genKeyWLGeneratorUpdatePrefix = "";
    private String genKeyPKField = null;
    private short genKeyPKFieldClassType;
    private Class generatedBeanInterface = null;
    private RDBMSPersistenceManager pm = null;
    private int sqlFinderCount = 0;
    private Set qcEnabledCmrFields = null;
    private Log log;
    private EJBComplianceTextFormatter fmt;
    private boolean hasSqlFinder = false;
    private boolean clusterInvalidationDisabled = false;
    private boolean useInnerJoin = false;
    private String categoryCmpField = null;
    private List relFinders = null;

    public RDBMSBean() {
        this("");
    }

    public RDBMSBean(String string) {
        this.setDataSourceName(string);
        this.finderList = new LinkedList();
        this.cmpFieldNames = new ArrayList();
        this.cmpFieldClasses = new HashMap();
        this.cmpColumnNames = new ArrayList();
        this.fieldName2columnName = new HashMap();
        this.columnName2fieldName = new HashMap();
        this.fieldName2columnTypeName = new HashMap();
        this.cmpFieldName2groupName = new HashMap();
        this.fieldGroups = new ArrayList();
        this.relationshipCachings = new ArrayList();
        this.rdbmsFinders = new HashMap();
        this.tableNames = new HashMap();
        this.tableNamesList = new ArrayList();
        this.tableName2cmpFieldName2columnName = new HashMap();
        this.tableName2verifyRows = new HashMap();
        this.tableName2verifyColumns = new HashMap();
        this.tableName2optimisticColumn = new HashMap();
        this.tableName2optimisticColumnTrigger = new HashMap();
        this.tableName2versionColumnInitialValue = new HashMap();
        this.table2cmpf2columnPKsOnly = new HashMap();
        this.table2cmpf2columnNoPKs = new HashMap();
        this.table2column2cmpf = new HashMap();
        this.table2column2variable = new HashMap();
        this.cmpf2Table = new HashMap();
        this.pkCmpF2Table2Column = new HashMap();
        this.column2tables = new HashMap();
        this.table2cmrf = new HashMap();
        this.cmrf2table = new HashMap();
        this.cmrfHasMultiPkTable = new ArrayList();
        this.cmrf2pkTable2fkColumn2pkColumn = new HashMap();
        this.fkField2pkTable2symFkColumn2pkColumn = new HashMap();
        this.variableName2table = new HashMap();
        this.variableName2cmrField = new HashMap();
        this.table2fkCol2fkClass = new HashMap();
        this.table2fkCol2RelatedBean = new HashMap();
        this.fieldNameToIsModifiedIndex = new HashMap();
        this.isModifiedIndexToFieldName = new HashMap();
        this.isModifiedPKIndexList = new ArrayList();
        this.fkField2fkColumn2Class = new HashMap();
        this.one2one = new HashSet();
        this.one2many = new HashSet();
        this.many2many = new HashSet();
        this.biDirectional = new HashSet();
        this.fieldName2cascadeDelete = new HashMap();
        this.fieldName2DBCascadeDelete = new HashMap();
        this.fieldName2selfRel = new HashMap();
        this.fieldName2RelatedFieldName = new HashMap();
        this.fkField2fkColumn2FieldName = new HashMap();
        this.fkField2symColumn2FieldName = new HashMap();
        this.fieldName2relatedDescriptor = new HashMap();
        this.fieldName2relatedMultiplicity = new HashMap();
        this.fieldName2relatedFieldOwnsFk = new HashMap();
        this.fieldName2relatedClassName = new HashMap();
        this.fieldName2groupName = new HashMap();
        this.variableName2columnName = new HashMap();
        this.cmrFieldNames = new ArrayList();
        this.declaredFieldNames = new ArrayList();
        this.fkFieldNames = new ArrayList();
        this.fkPkFieldNames = new ArrayList();
        this.fkCmpFieldNames = new ArrayList();
        this.fieldName2class = new HashMap();
        this.fkField2fkColumns = new HashMap();
        this.fkField2symColumns = new HashMap();
        this.fieldName2relatedRDBMSBean = new HashMap();
        this.fieldName2tableName = new HashMap();
        this.groupName2tableNames = new HashMap();
        this.fieldName2entityRef = new HashMap();
        this.remoteFieldNames = new ArrayList();
        this.fieldName2remoteColumn = new HashMap();
        this.cmrMappedcmpFields = new HashSet();
        this.cmrMapeedRelationFinder = new HashMap();
        this.log = new Log();
        this.fmt = new EJBComplianceTextFormatter();
    }

    public void setRDBMSPersistenceManager(RDBMSPersistenceManager rDBMSPersistenceManager) {
        this.pm = rDBMSPersistenceManager;
    }

    public RDBMSPersistenceManager getRDBMSPersistenceManager() {
        return this.pm;
    }

    public String getAbstractSchemaName() {
        if (this.bd.getAbstractSchemaName() != null) {
            return this.bd.getAbstractSchemaName();
        }
        if (this.synthAbstractSchemaName == null) {
            this.synthAbstractSchemaName = this.genSynthAbstractSchemaName();
        }
        return this.synthAbstractSchemaName;
    }

    private String genSynthAbstractSchemaName() {
        return "_WL_abstractSchemaName_" + this.getEjbName().replace('.', '_');
    }

    public Map getBeanMap() {
        return this.beanMap;
    }

    public CMPBeanDescriptor getCMPBeanDescriptor() {
        assert (this.bd != null);
        return this.bd;
    }

    public void setEjbName(String string) {
        this.ejbName = string;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void addToEjbSelectInternalList(Finder finder) {
        if (this.ejbSelectInternalList == null) {
            this.ejbSelectInternalList = new ArrayList();
        }
        this.ejbSelectInternalList.add(finder);
    }

    public List getEjbSelectInternalList() {
        if (this.ejbSelectInternalList == null) {
            this.ejbSelectInternalList = new ArrayList();
        }
        return this.ejbSelectInternalList;
    }

    public boolean hasAutoKeyGeneration() {
        return this.genKeyType != -1;
    }

    public boolean getGenKeyBeforeInsert() {
        return this.genKeyBeforeInsert;
    }

    public String getGenKeyDefaultColumnVal() {
        return this.genKeyDefaultColumnVal;
    }

    public boolean genKeyExcludePKColumn() {
        return this.genKeyExcludePKColumn;
    }

    public void setGenKeyCacheSize(int n) {
        this.genKeyCacheSize = n;
    }

    public int getGenKeyCacheSize() {
        return this.genKeyCacheSize;
    }

    public void setGenKeyGeneratorName(String string) {
        this.genKeyGeneratorName = string;
    }

    public String getGenKeyGeneratorName() {
        return this.genKeyGeneratorName;
    }

    public String getGenKeyPKField() {
        return this.genKeyPKField;
    }

    public String getGenKeyPKClassName() {
        return this.getCmpFieldClass(this.genKeyPKField).getName();
    }

    public short getGenKeyPKFieldClassType() {
        return this.genKeyPKFieldClassType;
    }

    public void setGenKeyType(String string) {
        this.genKeyType = RDBMSUtils.getGenKeyTypeAsConstant(string);
    }

    public short getGenKeyType() {
        return this.genKeyType;
    }

    public String getGenKeyGeneratorQuery() {
        return this.genKeyWLGeneratorQuery;
    }

    public String getGenKeyGeneratorUpdatePrefix() {
        return this.genKeyWLGeneratorUpdatePrefix;
    }

    public boolean getSelectFirstSeqKeyBeforeUpdate() {
        return this.selectFirstSeqKeyBeforeUpdate;
    }

    public void setSelectFirstSeqKeyBeforeUpdate(boolean bl) {
        this.selectFirstSeqKeyBeforeUpdate = bl;
    }

    public boolean hasMultipleTables() {
        return this.tableNamesList.size() > 1;
    }

    public int tableCount() {
        return this.tableNamesList.size();
    }

    public void addTable(String string) {
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug("adding table name: '" + string + "'");
        }
        if (this.hasTable(string)) {
            throw new AssertionError("a duplicate tablename was detected: tableName-" + string + " ejbName-" + this.getEjbName());
        }
        this.tableNames.put(string, string);
        this.tableNamesList.add(string);
    }

    public boolean hasTable(String string) {
        return this.tableNames.containsKey(string);
    }

    public List getTables() {
        return this.tableNamesList;
    }

    public String tableAt(int n) {
        if (n >= this.tableNamesList.size()) {
            return null;
        }
        return (String)this.tableNamesList.get(n);
    }

    public int tableIndex(String string) {
        return this.tableNamesList.indexOf(string);
    }

    public String chooseTableAsJoinTarget() {
        String string = this.getTableName();
        List list = (List)this.table2cmrf.get(string);
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        for (String string2 : this.getTables()) {
            list = (List)this.table2cmrf.get(string2);
            int n2 = 0;
            if (list != null) {
                n2 = list.size();
            }
            if (n2 <= n) continue;
            string = string2;
        }
        return string;
    }

    public List getTableNamesForColumn(String string) {
        return (List)this.column2tables.get(string);
    }

    public Map getPKCmpf2ColumnForTable(String string) {
        return (Map)this.table2cmpf2columnPKsOnly.get(string);
    }

    public String getPKColumnName(String string, String string2) {
        Map map = (Map)this.table2cmpf2columnPKsOnly.get(string);
        return (String)map.get(string2);
    }

    public boolean cmrfIsMultiPKTable(String string) {
        return this.cmrfHasMultiPkTable.contains(string);
    }

    public String getTableForCmrField(String string) {
        return (String)this.cmrf2table.get(string);
    }

    public int getTableIndexForCmrf(String string) {
        String string2 = this.getTableForCmrField(string);
        if (string2 == null) {
            return -1;
        }
        return this.tableIndex(string2);
    }

    public List getCmrFields(String string) {
        return (List)this.table2cmrf.get(string);
    }

    public String getField(String string) {
        if (this.fieldName2columnName.get(string) != null) {
            return string;
        }
        return (String)this.variableName2cmrField.get(string);
    }

    public Map getColumnMapForCmrfAndPkTable(String string, String string2) {
        Map map = (Map)this.cmrf2pkTable2fkColumn2pkColumn.get(string);
        if (map == null) {
            return null;
        }
        return (Map)map.get(string2);
    }

    public Map getSymColumnMapForCmrfAndPkTable(String string, String string2) {
        Map map = (Map)this.fkField2pkTable2symFkColumn2pkColumn.get(string);
        if (map == null) {
            return null;
        }
        return (Map)map.get(string2);
    }

    public void setPrimaryKeyFields(List list) {
        this.primaryKeyFieldList = list;
    }

    public List getPrimaryKeyFields() {
        return this.primaryKeyFieldList;
    }

    public boolean isPrimaryKeyField(String string) {
        return this.primaryKeyFieldList.contains(string);
    }

    public String getTableName() {
        return this.tableAt(0);
    }

    public String getQuotedTableName() {
        return RDBMSUtils.escQuotedID(this.getTableName());
    }

    public void addFieldGroup(FieldGroup fieldGroup) {
        this.fieldGroups.add(fieldGroup);
    }

    public List getFieldGroups() {
        return this.fieldGroups;
    }

    public FieldGroup getFieldGroup(String string) {
        for (FieldGroup fieldGroup : this.getFieldGroups()) {
            if (!fieldGroup.getName().equals(string)) continue;
            return fieldGroup;
        }
        return null;
    }

    public void setupFieldGroupIndexes() {
        int n = 0;
        for (FieldGroup fieldGroup : this.getFieldGroups()) {
            fieldGroup.setIndex(n++);
        }
    }

    public void addCmpFieldGroupNameMapping(String string, String string2) {
        this.cmpFieldName2groupName.put(string, string2);
    }

    public String getGroupNameForCmpField(String string) {
        String string2 = null;
        string2 = (String)this.cmpFieldName2groupName.get(string);
        if (string2 != null) {
            return string2;
        }
        for (FieldGroup fieldGroup : this.getFieldGroups()) {
            boolean bl = fieldGroup.getCmpFields().contains(string);
            if (!(bl |= fieldGroup.getCmrFields().contains(string))) continue;
            string2 = fieldGroup.getName();
            return string2;
        }
        throw new AssertionError("RDBMSBean.getGroupNameForCmpField didn't find a group for field '" + string + "'.");
    }

    public void addRelationshipCaching(RelationshipCaching relationshipCaching) {
        this.relationshipCachings.add(relationshipCaching);
    }

    public List getRelationshipCachings() {
        return this.relationshipCachings;
    }

    public RelationshipCaching getRelationshipCaching(String string) {
        for (RelationshipCaching relationshipCaching : this.getRelationshipCachings()) {
            if (!relationshipCaching.getCachingName().equals(string)) continue;
            return relationshipCaching;
        }
        return null;
    }

    public void setVerifyRows(String string, String string2) {
        this.tableName2verifyRows.put(string, string2);
        this.verifyReads = "read".equalsIgnoreCase(string2);
    }

    public String getVerifyRows(String string) {
        return (String)this.tableName2verifyRows.get(string);
    }

    public boolean getVerifyReads() {
        return this.verifyReads;
    }

    public void setVerifyColumns(String string, String string2) {
        this.tableName2verifyColumns.put(string, string2);
    }

    public String getVerifyColumns(String string) {
        return (String)this.tableName2verifyColumns.get(string);
    }

    public RDBMSBean getRDBMSBeanForAbstractSchema(String string) {
        String string2 = this.getAbstractSchemaName();
        if (string2.equals(string)) {
            return this;
        }
        Map map = this.getBeanMap();
        for (String string3 : map.keySet()) {
            RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string3);
            string2 = rDBMSBean.getAbstractSchemaName();
            if (string2 == null || !string2.equals(string)) continue;
            return rDBMSBean;
        }
        return null;
    }

    public boolean containsRdbmsFinder(RDBMSFinder rDBMSFinder) {
        return this.rdbmsFinders.containsKey(new RDBMSFinder.FinderKey(rDBMSFinder));
    }

    public void addRdbmsFinder(RDBMSFinder rDBMSFinder) {
        this.rdbmsFinders.put(new RDBMSFinder.FinderKey(rDBMSFinder), rDBMSFinder);
    }

    public Map getRdbmsFinders() {
        return this.rdbmsFinders;
    }

    public boolean isQueryCachingEnabledForCMRField(String string) {
        CMPBeanDescriptor cMPBeanDescriptor = this.getRelatedDescriptor(string);
        if (!cMPBeanDescriptor.isReadOnly()) {
            return false;
        }
        if (this.qcEnabledCmrFields != null && this.qcEnabledCmrFields.contains(string)) {
            String string2;
            RDBMSBean rDBMSBean = this.getRelatedRDBMSBean(string);
            if (!rDBMSBean.relatedFieldIsFkOwner(string2 = this.getRelatedFieldName(string)) || this.isManyToManyRelation(string)) {
                return true;
            }
            this.qcEnabledCmrFields.remove(string);
        }
        return false;
    }

    private String methodPrefix() {
        return "findBy";
    }

    public String finderMethodName(CMPBeanDescriptor cMPBeanDescriptor, String string) {
        String string2 = MethodUtils.tail(cMPBeanDescriptor.getGeneratedBeanClassName());
        return this.methodPrefix() + string2 + "_" + string + "__WL_";
    }

    public String variableForField(String string, String string2, String string3) {
        Debug.assertion((string != null ? 1 : 0) != 0);
        Debug.assertion((string2 != null ? 1 : 0) != 0);
        Debug.assertion((string3 != null ? 1 : 0) != 0);
        String string4 = null;
        if (this.hasCmpField(string2, string3)) {
            string4 = this.getCmpField(string2, string3);
        } else {
            string4 = "__WL_" + string;
            if (!this.isRemoteField(string)) {
                string4 = string4 + "_" + this.getRelatedPkFieldName(string, string3);
            }
        }
        return string4;
    }

    private void addReverseColumnMapping(String string, String string2, String string3) {
        HashMap<String, String> hashMap = (HashMap<String, String>)this.table2column2variable.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            this.table2column2variable.put(string, hashMap);
        }
        hashMap.put(string2, string3);
    }

    public boolean isReadOnly() {
        return this.bd.isReadOnly();
    }

    public boolean isOptimistic() {
        return this.bd.isOptimistic();
    }

    public boolean getCacheBetweenTransactions() {
        return this.bd.getCacheBetweenTransactions();
    }

    public boolean hasOptimisticColumn(String string) {
        if (!"version".equalsIgnoreCase(this.getVerifyColumns(string)) && !"timestamp".equalsIgnoreCase(this.getVerifyColumns(string))) {
            return false;
        }
        assert (this.tableName2optimisticColumn.get(string) != null);
        return this.tableName2optimisticColumn.get(string) != null;
    }

    public String getOptimisticColumn(String string) {
        return (String)this.tableName2optimisticColumn.get(string);
    }

    public boolean normalizeMultiTables_done() {
        return this.normalizeMultiTables_done;
    }

    private void addOptimisticFields() {
        for (Object object : this.bd.getCMFieldNames()) {
            Object object2 = this.bd.getFieldClass((String)object);
            this.cmpFieldClasses.put(object, object2);
        }
        for (Object object2 : this.tableNamesList) {
            String string;
            if (!this.hasOptimisticColumn((String)object2) || (string = this.getCmpField((String)object2, this.getOptimisticColumn((String)object2))) != null) continue;
            string = "__WL_optimisticField" + this.tableIndex((String)object2);
            this.addTableFieldColumnMapping((String)object2, string, this.getOptimisticColumn((String)object2));
            if (this.getVerifyColumns((String)object2).equalsIgnoreCase("version")) {
                this.cmpFieldClasses.put(string, Long.class);
                continue;
            }
            if (this.getVerifyColumns((String)object2).equalsIgnoreCase("timestamp")) {
                this.cmpFieldClasses.put(string, Timestamp.class);
                continue;
            }
            throw new AssertionError("invalid value for verify-columns: " + this.getVerifyColumns((String)object2));
        }
    }

    public void normalizeMultiTables(CMPBeanDescriptor cMPBeanDescriptor) {
        if (this.normalizeMultiTables_done) {
            return;
        }
        this.normalizeMultiTables_done = true;
        this.bd = cMPBeanDescriptor;
        this.addOptimisticFields();
        for (String string : this.tableNamesList) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            Map map = (Map)this.tableName2cmpFieldName2columnName.get(string);
            for (String string2 : map.keySet()) {
                String string3 = (String)map.get(string2);
                if (this.primaryKeyFieldList.contains(string2)) {
                    hashMap.put(string2, string3);
                    HashMap<String, String> hashMap3 = (HashMap<String, String>)this.pkCmpF2Table2Column.get(string2);
                    if (hashMap3 == null) {
                        hashMap3 = new HashMap<String, String>();
                        this.pkCmpF2Table2Column.put(string2, hashMap3);
                    }
                    hashMap3.put(string, string3);
                    continue;
                }
                hashMap2.put(string2, string3);
            }
            this.table2cmpf2columnPKsOnly.put(string, hashMap);
            this.table2cmpf2columnNoPKs.put(string, hashMap2);
        }
    }

    public boolean initialized() {
        return this.synthesized;
    }

    public void processDescriptors(Map map, Relationships relationships, Map map2, Map map3, Map map4, Map map5) throws RDBMSException {
        Object object8;
        Object object2;
        Object object3;
        Object object42;
        Object object52;
        Object object62;
        Object object72;
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug("called RDBMSBean.processDescriptors");
        }
        assert (map != null);
        assert (map3 != null);
        assert (map4 != null);
        if (this.synthesized) {
            return;
        }
        this.synthesized = true;
        this.beanMap = map;
        this.relationships = relationships;
        this.dependentMap = map2;
        this.rdbmsBeanMap = map3;
        this.rdbmsRelationMap = map4;
        this.rdbmsDependentMap = map5;
        assert (this.bd != null);
        if (relationships != null) {
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing relationships...");
            }
            Map map6 = relationships.getAllEjbRelations();
            for (Object object72 : map6.keySet()) {
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug("processing relationship: " + (String)object72);
                }
                object62 = (EjbRelation)map6.get(object72);
                object52 = (RDBMSRelation)map4.get(object72);
                assert (object52 != null);
                object42 = object62.getAllEjbRelationshipRoles().iterator();
                object3 = (EjbRelationshipRole)object42.next();
                object2 = (EjbRelationshipRole)object42.next();
                assert (object3 != null);
                assert (object2 != null);
                RDBMSRelation.RDBMSRole rDBMSRole = ((RDBMSRelation)object52).getRole1();
                RDBMSRelation.RDBMSRole rDBMSRole2 = ((RDBMSRelation)object52).getRole2();
                Debug.assertion((rDBMSRole != null ? 1 : 0) != 0);
                if (!rDBMSRole.getName().equals(object3.getName())) {
                    RDBMSRelation.RDBMSRole rDBMSRole3 = rDBMSRole;
                    rDBMSRole = rDBMSRole2;
                    rDBMSRole2 = rDBMSRole3;
                }
                assert (rDBMSRole == null || object3.getName().equals(rDBMSRole.getName()));
                assert (rDBMSRole2 == null || object2.getName().equals(rDBMSRole2.getName()));
                if (rDBMSRole != null && rDBMSRole.getColumnMap().size() > 0) {
                    this.processRole((EjbRelationshipRole)object3, (EjbRelationshipRole)object2, rDBMSRole, rDBMSRole2, (RDBMSRelation)object52);
                    this.processRole((EjbRelationshipRole)object2, (EjbRelationshipRole)object3, rDBMSRole2, rDBMSRole, (RDBMSRelation)object52);
                    continue;
                }
                this.processRole((EjbRelationshipRole)object2, (EjbRelationshipRole)object3, rDBMSRole2, rDBMSRole, (RDBMSRelation)object52);
                this.processRole((EjbRelationshipRole)object3, (EjbRelationshipRole)object2, rDBMSRole, rDBMSRole2, (RDBMSRelation)object52);
            }
        }
        this.calculateLoadModifyIndex();
        for (Object object8 : this.getFieldGroups()) {
            object72 = new HashSet();
            this.groupName2tableNames.put(((FieldGroup)object8).getName(), object72);
            object62 = ((FieldGroup)object8).getCmrFields().iterator();
            while (object62.hasNext()) {
                object52 = (String)object62.next();
                if (this.isForeignKeyField((String)object52) && this.containsFkField((String)object52)) continue;
                object62.remove();
            }
            for (Object object42 : (Collection)((FieldGroup)object8).getCmpFields().clone()) {
                object3 = this.getTableForCmpField((String)object42);
                object72.add(object3);
                if (!this.hasOptimisticColumn((String)object3)) continue;
                object2 = this.getCmpField((String)object3, this.getOptimisticColumn((String)object3));
                if (((FieldGroup)object8).getCmpFields().contains(object2)) continue;
                ((FieldGroup)object8).addCmpField((String)object2);
            }
            for (Object object42 : (Collection)((FieldGroup)object8).getCmrFields().clone()) {
                object3 = this.getTableForCmrField((String)object42);
                object72.add(object3);
                if (!this.hasOptimisticColumn((String)object3)) continue;
                object2 = this.getCmpField((String)object3, this.getOptimisticColumn((String)object3));
                if (((FieldGroup)object8).getCmpFields().contains(object2)) continue;
                ((FieldGroup)object8).addCmpField((String)object2);
            }
        }
        if (this.isOptimistic()) {
            object8 = new HashSet();
            for (Object object62 : this.tableName2optimisticColumnTrigger.keySet()) {
                if (!this.getTriggerUpdatesOptimisticColumn((String)object62) || !"timestamp".equalsIgnoreCase(this.getVerifyColumns((String)object62))) continue;
                object8.add(object62);
            }
            if (!object8.isEmpty()) {
                object62 = new FieldGroup();
                ((FieldGroup)object62).setName("optimisticTimestampTriggerGroup");
                this.groupName2tableNames.put(((FieldGroup)object62).getName(), object8);
                object52 = object8.iterator();
                while (object52.hasNext()) {
                    object42 = (String)object52.next();
                    object3 = this.getCmpField((String)object42, this.getOptimisticColumn((String)object42));
                    if (object3 == null) {
                        object3 = "__WL_optimisticField" + this.tableIndex((String)object42);
                    }
                    ((FieldGroup)object62).addCmpField((String)object3);
                }
                this.addFieldGroup((FieldGroup)object62);
            }
        }
        object8 = new FieldGroup();
        ((FieldGroup)object8).setName("defaultGroup");
        object72 = new HashSet();
        this.groupName2tableNames.put(((FieldGroup)object8).getName(), object72);
        for (Object object52 : this.getCmpFieldNames()) {
            object42 = this.getTableForCmpField((String)object52);
            object72.add(object42);
            ((FieldGroup)object8).addCmpField((String)object52);
        }
        for (Object object42 : this.getForeignKeyFieldNames()) {
            if (!this.containsFkField((String)object42)) continue;
            object3 = this.getTableForCmrField((String)object42);
            object72.add(object3);
            ((FieldGroup)object8).addCmrField((String)object42);
        }
        this.addFieldGroup((FieldGroup)object8);
        if (debugLogger.isDebugEnabled()) {
            this.printDebugInfo();
        }
        if (debugLogger.isDebugEnabled()) {
            this.printCmpFieldDebugInfo();
        }
    }

    private void processRole(EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, RDBMSRelation.RDBMSRole rDBMSRole, RDBMSRelation.RDBMSRole rDBMSRole2, RDBMSRelation rDBMSRelation) throws RDBMSException {
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug("processing role: " + ejbRelationshipRole.getName());
            RDBMSBean.debug("other role is: " + ejbRelationshipRole2.getName());
            RDBMSBean.debug(rDBMSRole == null ? "wlRole is null" : "wlRole=" + rDBMSRole.getName());
            RDBMSBean.debug(rDBMSRole2 == null ? "wlOther is null" : "wlOther=" + rDBMSRole2.getName());
        }
        RoleSource roleSource = ejbRelationshipRole.getRoleSource();
        String string = roleSource.getEjbName();
        if (!this.getEjbName().equals(string)) {
            return;
        }
        CmrField cmrField = ejbRelationshipRole.getCmrField();
        RoleSource roleSource2 = ejbRelationshipRole2.getRoleSource();
        String string2 = roleSource2.getEjbName();
        CmrField cmrField2 = ejbRelationshipRole2.getCmrField();
        Class<Set> clazz = null;
        String string3 = null;
        boolean bl = ejbRelationshipRole.getMultiplicity().equals("Many") && ejbRelationshipRole2.getMultiplicity().equals("Many");
        boolean bl2 = ejbRelationshipRole.getMultiplicity().equals("One") && ejbRelationshipRole2.getMultiplicity().equals("Many");
        boolean bl3 = ejbRelationshipRole.getMultiplicity().equals("One") && ejbRelationshipRole2.getMultiplicity().equals("One");
        String string4 = RDBMSUtils.getCmrFieldName(ejbRelationshipRole, ejbRelationshipRole2);
        if (this.cmrFieldNames.contains(string4)) {
            this.processSymmetricRole(bl3, bl, string4, ejbRelationshipRole, ejbRelationshipRole2, rDBMSRole, rDBMSRole2);
            return;
        }
        this.cmrFieldNames.add(string4);
        RDBMSBean rDBMSBean = null;
        rDBMSBean = bl ? this : (RDBMSBean)this.rdbmsBeanMap.get(string2);
        if (rDBMSBean.hasMultipleTables()) {
            this.cmrfHasMultiPkTable.add(string4);
        }
        if (!bl && string.equalsIgnoreCase(string2)) {
            this.fieldName2selfRel.put(string4, new Boolean(true));
            this.selfRelationship = true;
        } else {
            this.fieldName2selfRel.put(string4, new Boolean(false));
        }
        this.fieldName2cascadeDelete.put(string4, new Boolean(ejbRelationshipRole2.getCascadeDelete()));
        if (rDBMSRole2 != null) {
            this.fieldName2DBCascadeDelete.put(string4, new Boolean(rDBMSRole2.getDBCascadeDelete()));
        } else {
            this.fieldName2DBCascadeDelete.put(string4, new Boolean(false));
        }
        if (cmrField != null) {
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing declared field: " + ejbRelationshipRole.getName());
            }
            string3 = cmrField.getType();
            this.declaredFieldNames.add(string4);
        }
        if (string3 == null) {
            clazz = bl2 || bl ? Collection.class : this.getElementalClass(ejbRelationshipRole2);
        } else if ("java.util.Collection".equals(string3)) {
            clazz = Collection.class;
        } else if ("java.util.Set".equals(string3)) {
            clazz = Set.class;
        } else {
            throw new AssertionError("invalid className: " + string3);
        }
        this.fieldName2class.put(string4, clazz);
        this.calculateRelationshipType(string4, ejbRelationshipRole, ejbRelationshipRole2, rDBMSRole, rDBMSRole2);
        if (rDBMSRole != null) {
            this.processWeblogicRole_PhaseOne(string4, ejbRelationshipRole, rDBMSRole, bl, rDBMSBean);
            this.processWeblogicRole_PhaseTwo(string4, ejbRelationshipRole, ejbRelationshipRole2, rDBMSRole, rDBMSRole2, rDBMSRelation, bl, bl2, roleSource2);
            if (rDBMSRole.isQueryCachingEnabled()) {
                String string5 = cmrField.getName();
                if (!rDBMSBean.isReadOnly()) {
                    this.log.logWarning(this.fmt.QUERY_CACHING_ENABLED_FOR_CMR_TO_RW_BEAN(this.getEjbName(), rDBMSRole.getName(), this.getRelatedRDBMSBean(string5).getEjbName()));
                } else {
                    if (this.qcEnabledCmrFields == null) {
                        this.qcEnabledCmrFields = new HashSet();
                    }
                    this.qcEnabledCmrFields.add(string5);
                }
            }
        }
    }

    public boolean isSelfRelationship(String string) {
        return (Boolean)this.fieldName2selfRel.get(string);
    }

    public boolean isSelfRelationship() {
        return this.selfRelationship;
    }

    private void processWeblogicRole_PhaseOne(String string, EjbRelationshipRole ejbRelationshipRole, RDBMSRelation.RDBMSRole rDBMSRole, boolean bl, RDBMSBean rDBMSBean) throws RDBMSException {
        this.initializeRole(rDBMSRole, bl);
        if (rDBMSRole.getGroupName() != null) {
            this.fieldName2groupName.put(string, rDBMSRole.getGroupName());
        }
        assert (rDBMSRole.getColumnMap() != null);
        if (rDBMSRole.getColumnMap().size() > 0) {
            List<String> list;
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing foreign key owner: " + ejbRelationshipRole.getName());
                RDBMSBean.debug("foreign key field name: " + string);
            }
            String string2 = rDBMSRole.getForeignKeyTableName();
            if (!bl) {
                list = (List)this.table2cmrf.get(string2);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.table2cmrf.put(string2, list);
                }
                list.add(string);
                this.cmrf2table.put(string, string2);
            }
            list = rDBMSRole.getColumnMap();
            this.normalizeColumnNames(bl, string2, (Map)((Object)list));
            ArrayList arrayList = new ArrayList(list.keySet());
            this.fkField2fkColumns.put(string, arrayList);
            Debug.assertion((this.cmrf2pkTable2fkColumn2pkColumn.get(string) == null ? 1 : 0) != 0);
            HashMap hashMap = new HashMap();
            this.cmrf2pkTable2fkColumn2pkColumn.put(string, hashMap);
            String string3 = rDBMSRole.getPrimaryKeyTableName();
            if (string3 == null) {
                string3 = rDBMSBean.getTableName();
            }
            Debug.assertion((string3 != null ? 1 : 0) != 0);
            for (String string4 : rDBMSBean.getTables()) {
                Debug.assertion((hashMap.get(string4) == null ? 1 : 0) != 0);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap.put(string4, hashMap2);
                for (String string5 : list.keySet()) {
                    String string6 = (String)list.get(string5);
                    if (!string3.equalsIgnoreCase(string4)) {
                        String string7 = rDBMSBean.getCmpField(string3, string6);
                        string6 = rDBMSBean.getColumnForCmpFieldAndTable(string7, string4);
                    }
                    hashMap2.put(string5, string6);
                }
            }
        }
    }

    private void processWeblogicRole_PhaseTwo(String string, EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, RDBMSRelation.RDBMSRole rDBMSRole, RDBMSRelation.RDBMSRole rDBMSRole2, RDBMSRelation rDBMSRelation, boolean bl, boolean bl2, RoleSource roleSource) throws RDBMSException {
        assert (rDBMSRole.getColumnMap() != null);
        if (rDBMSRole.getColumnMap().size() > 0) {
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing foreign key owner: " + ejbRelationshipRole.getName());
                RDBMSBean.debug("foreign key field name: " + string);
            }
            this.fkFieldNames.add(string);
            RDBMSBean rDBMSBean = this.getTargetBean(bl, string, rDBMSRelation, roleSource, rDBMSRole2);
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
            String string2 = rDBMSRole.getForeignKeyTableName();
            Map map = rDBMSRole.getColumnMap();
            String string3 = null;
            string3 = rDBMSBean.hasMultipleTables() ? rDBMSRole.getPrimaryKeyTableName() : rDBMSBean.getTableName();
            assert (string3 != null);
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            this.fkField2fkColumn2Class.put(string, hashMap);
            this.fkField2fkColumn2FieldName.put(string, hashMap2);
            if (rDBMSRelation.getTableName() != null) {
                this.table2fkCol2fkClass.put(rDBMSRelation.getTableName(), hashMap);
            } else {
                this.table2fkCol2fkClass.put(string2, hashMap);
            }
            assert (this.getForeignKeyColNames(string) != null);
            Iterator iterator = this.getForeignKeyColNames(string).iterator();
            boolean bl3 = false;
            boolean bl4 = false;
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                String string5 = (String)map.get(string4);
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug("processing column pair ( Fk Column: '" + string4 + "', Pk Column '" + string5 + "') and primary key table-" + string3);
                }
                String string6 = rDBMSBean.getCmpField(string3, string5);
                assert (string6 != null);
                assert (cMPBeanDescriptor.getPrimaryKeyFieldNames().contains(string6));
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug("found key column field pair (" + string5 + " " + string6 + ")");
                }
                hashMap2.put(string4, string6);
                Class clazz = cMPBeanDescriptor.getFieldClass(string6);
                Class clazz2 = ClassUtils.getObjectClass(clazz);
                if (!bl) {
                    String string7 = this.variableForField(string, string2, string4);
                    this.variableName2columnName.put(string7, string4);
                    this.variableName2table.put(string7, string2);
                    this.variableName2cmrField.put(string7, string);
                    this.addReverseColumnMapping(string2, string4, string7);
                    if (this.hasCmpField(string2, string4)) {
                        String string8 = this.getCmpField(string2, string4);
                        bl4 = true;
                        this.cmrMappedcmpFields.add(string8);
                        clazz2 = this.bd.getFieldClass(string8);
                        if (this.bd.getPrimaryKeyFieldNames().contains(string8)) {
                            bl3 = true;
                        }
                    }
                }
                hashMap.put(string4, clazz2);
            }
            if (bl3) {
                this.fkPkFieldNames.add(string);
            }
            if (bl4) {
                this.fkCmpFieldNames.add(string);
            }
        }
    }

    private void calculateLoadModifyIndex() {
        List list;
        List list2;
        int n = this.tableCount();
        this.tableIndexToFieldList = new List[n];
        this.tableIndexToCMPFieldList = new List[n];
        this.tableIndexToCMRFieldList = new List[n];
        this.tableIndexToNonPKFieldList = new List[n];
        Iterator iterator = this.getTables().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            iterator.next();
            this.tableIndexToFieldList[n2] = new ArrayList();
            this.tableIndexToCMPFieldList[n2] = new ArrayList();
            this.tableIndexToCMRFieldList[n2] = new ArrayList();
            this.tableIndexToNonPKFieldList[n2] = new ArrayList();
            ++n2;
        }
        for (Object object : this.cmpFieldNames) {
            this.fieldNameToIsModifiedIndex.put(object, new Integer(this.numFields));
            this.isModifiedIndexToFieldName.put(new Integer(this.numFields), object);
            String string = this.getTableForCmpField((String)object);
            n2 = this.tableIndex(string);
            this.isModifiedIndexToTableNumber.add(new Integer(n2));
            if (this.isPrimaryKeyField((String)object)) {
                this.isModifiedPKIndexList.add(new Integer(this.numFields));
                for (int i = 0; i < this.tableCount(); ++i) {
                    list2 = this.tableIndexToFieldList[i];
                    list2.add(object);
                    list = this.tableIndexToCMPFieldList[i];
                    list.add(object);
                }
            } else {
                List list3 = this.tableIndexToFieldList[n2];
                list3.add(object);
                list2 = this.tableIndexToCMPFieldList[n2];
                list2.add(object);
                list = this.tableIndexToNonPKFieldList[n2];
                list.add(object);
            }
            ++this.numFields;
        }
        for (String string : this.getForeignKeyFieldNames()) {
            if (!this.containsFkField(string) || this.isForeignCmpField(string)) continue;
            this.fieldNameToIsModifiedIndex.put(string, new Integer(this.numFields));
            this.isModifiedIndexToFieldName.put(new Integer(this.numFields), string);
            String string2 = this.getTableForCmrField(string);
            n2 = this.tableIndex(string2);
            this.isModifiedIndexToTableNumber.add(new Integer(n2));
            list2 = this.tableIndexToFieldList[n2];
            list2.add(string);
            list = this.tableIndexToCMRFieldList[n2];
            list.add(string);
            List list4 = this.tableIndexToNonPKFieldList[n2];
            list4.add(string);
            ++this.numFields;
        }
    }

    public void setupRelatedBeanMap() {
        if (this.relationships != null) {
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing relationships...");
            }
            Map map = this.relationships.getAllEjbRelations();
            for (String string : map.keySet()) {
                boolean bl;
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug("processing relationship: " + string);
                }
                EjbRelation ejbRelation = (EjbRelation)map.get(string);
                RDBMSRelation rDBMSRelation = (RDBMSRelation)this.rdbmsRelationMap.get(string);
                if (rDBMSRelation.getTableName() == null) continue;
                assert (rDBMSRelation != null);
                Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
                EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator.next();
                EjbRelationshipRole ejbRelationshipRole2 = (EjbRelationshipRole)iterator.next();
                if (debugLogger.isDebugEnabled()) {
                    Debug.assertion((ejbRelationshipRole != null ? 1 : 0) != 0);
                }
                if (debugLogger.isDebugEnabled()) {
                    Debug.assertion((ejbRelationshipRole2 != null ? 1 : 0) != 0);
                }
                RDBMSRelation.RDBMSRole rDBMSRole = rDBMSRelation.getRole1();
                RDBMSRelation.RDBMSRole rDBMSRole2 = rDBMSRelation.getRole2();
                Debug.assertion((rDBMSRole != null ? 1 : 0) != 0);
                if (!rDBMSRole.getName().equals(ejbRelationshipRole.getName())) {
                    RDBMSRelation.RDBMSRole rDBMSRole3 = rDBMSRole;
                    rDBMSRole = rDBMSRole2;
                    rDBMSRole2 = rDBMSRole3;
                }
                boolean bl2 = bl = ejbRelationshipRole.getMultiplicity().equals("Many") && ejbRelationshipRole2.getMultiplicity().equals("Many");
                if (!bl) continue;
                RoleSource roleSource = ejbRelationshipRole.getRoleSource();
                String string2 = roleSource.getEjbName();
                if (this.getEjbName().equals(string2)) {
                    this.createRelatedBeanMap(ejbRelationshipRole, ejbRelationshipRole2, rDBMSRole, rDBMSRole2, rDBMSRelation);
                    continue;
                }
                this.createRelatedBeanMap(ejbRelationshipRole2, ejbRelationshipRole, rDBMSRole2, rDBMSRole, rDBMSRelation);
            }
        }
    }

    private void createRelatedBeanMap(EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, RDBMSRelation.RDBMSRole rDBMSRole, RDBMSRelation.RDBMSRole rDBMSRole2, RDBMSRelation rDBMSRelation) {
        RoleSource roleSource = ejbRelationshipRole2.getRoleSource();
        String string = roleSource.getEjbName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        String string2 = rDBMSRelation.getTableName();
        HashMap<String, RDBMSBean> hashMap = new HashMap<String, RDBMSBean>();
        Map map = rDBMSRole2.getColumnMap();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            hashMap.put(string3, rDBMSBean);
        }
        this.table2fkCol2RelatedBean.put(string2, hashMap);
    }

    private void initializeRole(RDBMSRelation.RDBMSRole rDBMSRole, boolean bl) {
        if (!bl && rDBMSRole.getColumnMap().size() > 0 && !this.hasMultipleTables()) {
            rDBMSRole.setForeignKeyTableName(this.getTableName());
        }
    }

    private void processSymmetricRole(boolean bl, boolean bl2, String string, EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, RDBMSRelation.RDBMSRole rDBMSRole, RDBMSRelation.RDBMSRole rDBMSRole2) {
        Debug.assertion((bl || bl2 ? 1 : 0) != 0);
        if (bl2) {
            this.computeSymmetricColumnInfo(string, rDBMSRole, ejbRelationshipRole2);
        }
        if (bl) {
            this.fieldName2cascadeDelete.put(string, new Boolean(ejbRelationshipRole.getCascadeDelete() || ejbRelationshipRole2.getCascadeDelete()));
            boolean bl3 = rDBMSRole == null ? false : rDBMSRole.getDBCascadeDelete();
            boolean bl4 = rDBMSRole2 == null ? false : rDBMSRole2.getDBCascadeDelete();
            this.fieldName2DBCascadeDelete.put(string, new Boolean(bl3 || bl4));
        }
    }

    private RDBMSBean getTargetBean(boolean bl, String string, RDBMSRelation rDBMSRelation, RoleSource roleSource, RDBMSRelation.RDBMSRole rDBMSRole) throws RDBMSException {
        String string2 = roleSource.getEjbName();
        RDBMSBean rDBMSBean = null;
        if (bl) {
            this.fieldName2tableName.put(string, rDBMSRelation.getTableName());
            rDBMSBean = this;
        } else {
            String string3 = rDBMSRelation.getTableName();
            if (string3 != null && string3.length() > 0) {
                Loggable loggable = EJBLogger.logshouldNotDefineJoinTableForOneToManyLoggable((String)rDBMSRelation.getName(), (String)string3);
                throw new RDBMSException(loggable.getMessage());
            }
            rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string2);
        }
        return rDBMSBean;
    }

    private void normalizeColumnNames(boolean bl, String string, Map map) {
        if (!bl) {
            Map map2 = (Map)((HashMap)map).clone();
            Map map3 = (Map)this.table2column2cmpf.get(string);
            block0: for (String string2 : map2.keySet()) {
                for (String string3 : map3.keySet()) {
                    if (!string3.equalsIgnoreCase(string2) || string3.equals(string2)) continue;
                    String string4 = (String)map.get(string2);
                    map.remove(string2);
                    map.put(string3, string4);
                    continue block0;
                }
            }
        }
    }

    private void calculateRelationshipType(String string, EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, RDBMSRelation.RDBMSRole rDBMSRole, RDBMSRelation.RDBMSRole rDBMSRole2) {
        if (ejbRelationshipRole.getMultiplicity().equals("One")) {
            if (ejbRelationshipRole2.getMultiplicity().equals("One")) {
                this.one2one.add(string);
            } else {
                this.one2many.add(string);
            }
        } else if (ejbRelationshipRole2.getMultiplicity().equals("Many")) {
            this.many2many.add(string);
        } else {
            this.one2many.add(string);
        }
        if (ejbRelationshipRole.getCmrField() != null && ejbRelationshipRole2.getCmrField() != null) {
            this.biDirectional.add(string);
        }
        this.fieldName2relatedMultiplicity.put(string, ejbRelationshipRole2.getMultiplicity());
        this.fieldName2relatedFieldOwnsFk.put(string, new Boolean(rDBMSRole2 != null && rDBMSRole2.getColumnMap().size() > 0));
        String string2 = RDBMSUtils.getCmrFieldName(ejbRelationshipRole2, ejbRelationshipRole);
        this.fieldName2RelatedFieldName.put(string, string2);
        RoleSource roleSource = ejbRelationshipRole2.getRoleSource();
        String string3 = roleSource.getEjbName();
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(string3);
        this.fieldName2relatedDescriptor.put(string, cMPBeanDescriptor);
        this.fieldName2relatedRDBMSBean.put(string, this.rdbmsBeanMap.get(string3));
        this.fieldName2relatedClassName.put(string, cMPBeanDescriptor.getGeneratedBeanClassName());
    }

    private Class getElementalClass(EjbRelationshipRole ejbRelationshipRole) throws RDBMSException {
        RoleSource roleSource = ejbRelationshipRole.getRoleSource();
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(roleSource.getEjbName());
        Debug.assertion((cMPBeanDescriptor != null ? 1 : 0) != 0);
        if (cMPBeanDescriptor.hasLocalClientView()) {
            return cMPBeanDescriptor.getLocalInterfaceClass();
        }
        if (cMPBeanDescriptor.isEJB30()) {
            return cMPBeanDescriptor.getBeanClass();
        }
        return cMPBeanDescriptor.getRemoteInterfaceClass();
    }

    private void computeSymmetricColumnInfo(String string, RDBMSRelation.RDBMSRole rDBMSRole, EjbRelationshipRole ejbRelationshipRole) {
        Object object;
        Object object2;
        Map map3;
        Map map2 = rDBMSRole.getColumnMap();
        ArrayList arrayList = new ArrayList(map2.keySet());
        this.fkField2symColumns.put(string, arrayList);
        HashMap hashMap = new HashMap();
        this.fkField2symColumn2FieldName.put(string, hashMap);
        for (Map map3 : arrayList) {
            object2 = (String)map2.get(map3);
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing column pair (" + map3 + " " + (String)object2 + ")");
            }
            object = this.getCmpFieldForColumn((String)object2);
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("found key column field pair (" + (String)object2 + " " + (String)object + ")");
            }
            assert (object != null);
            hashMap.put(map3, object);
        }
        map3 = (Map)this.fkField2pkTable2symFkColumn2pkColumn.get(string);
        if (map3 == null) {
            map3 = new HashMap();
            this.fkField2pkTable2symFkColumn2pkColumn.put(string, map3);
        }
        object2 = this;
        object = rDBMSRole.getColumnMap();
        String string2 = null;
        string2 = rDBMSRole.getPrimaryKeyTableName() != null ? rDBMSRole.getPrimaryKeyTableName() : ((RDBMSBean)object2).getTableName();
        for (String string3 : ((RDBMSBean)object2).getTables()) {
            HashMap<String, String> hashMap2 = (HashMap<String, String>)map3.get(string3);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, String>();
                map3.put(string3, hashMap2);
            }
            for (String string4 : object.keySet()) {
                String string5;
                String string6 = (String)object.get(string4);
                if (!string3.equals(string2)) {
                    string5 = ((RDBMSBean)object2).getCmpField(string2, string6);
                    string6 = ((RDBMSBean)object2).getColumnForCmpFieldAndTable(string5, string3);
                }
                string5 = this.getCmpField(string3, string6);
                hashMap2.put(string4, string6);
            }
        }
    }

    public void printDebugInfo() {
        Object object;
        String string;
        RDBMSBean.debug("ejbName- " + this.getEjbName());
        Iterator<Object> iterator = this.cmrFieldNames.iterator();
        RDBMSBean.debug("All Field Names-------------------------------------");
        while (iterator.hasNext()) {
            RDBMSBean.debug((String)iterator.next());
        }
        iterator = this.declaredFieldNames.iterator();
        RDBMSBean.debug("Declared Field Names--------------------------------");
        while (iterator.hasNext()) {
            RDBMSBean.debug((String)iterator.next());
        }
        iterator = this.fkFieldNames.iterator();
        RDBMSBean.debug("Foreign Key Field Names-----------------------------");
        while (iterator.hasNext()) {
            RDBMSBean.debug((String)iterator.next());
        }
        iterator = this.fkPkFieldNames.iterator();
        RDBMSBean.debug("Foreign Key Primary Key Field Names-----------------");
        while (iterator.hasNext()) {
            RDBMSBean.debug((String)iterator.next());
        }
        iterator = this.fkCmpFieldNames.iterator();
        RDBMSBean.debug("Foreign Key CMP Field Names-------------------------");
        while (iterator.hasNext()) {
            RDBMSBean.debug((String)iterator.next());
        }
        iterator = this.fieldName2class.keySet().iterator();
        RDBMSBean.debug("Field Name To Class Mapping-------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            Debug.assertion((this.fieldName2class.get(string) != null ? 1 : 0) != 0);
            RDBMSBean.debug(string + ", \t" + ((Class)this.fieldName2class.get(string)).getName());
        }
        iterator = this.fkField2fkColumns.keySet().iterator();
        RDBMSBean.debug("FK Field Name To Column Name Mapping----------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = ((List)this.fkField2fkColumns.get(string)).iterator();
            while (object.hasNext()) {
                RDBMSBean.debug(string + ", \t" + (String)object.next());
            }
        }
        iterator = this.fieldName2relatedClassName.keySet().iterator();
        RDBMSBean.debug("Field Name To Related Class Name  Mapping-----------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + (String)this.fieldName2relatedClassName.get(string));
        }
        iterator = this.fieldName2relatedFieldOwnsFk.keySet().iterator();
        RDBMSBean.debug("Field Name To Related Field Owns FK Mapping---------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + this.fieldName2relatedFieldOwnsFk.get(string));
        }
        iterator = this.fieldName2relatedMultiplicity.keySet().iterator();
        RDBMSBean.debug("Field Name To Related Multiplicity Mapping----------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + this.fieldName2relatedMultiplicity.get(string));
        }
        iterator = this.fieldName2relatedDescriptor.keySet().iterator();
        RDBMSBean.debug("Field Name To Related Descriptor Mapping------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + ((CMPBeanDescriptor)this.fieldName2relatedDescriptor.get(string)).getEJBName());
        }
        iterator = this.fieldName2relatedRDBMSBean.keySet().iterator();
        RDBMSBean.debug("Field Name To Related RDBMS Bean  Mapping------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + ((RDBMSBean)this.fieldName2relatedRDBMSBean.get(string)).getEjbName());
        }
        iterator = this.cmrf2table.keySet().iterator();
        RDBMSBean.debug("CMR Field Name To Table Mapping----------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + (String)this.cmrf2table.get(string));
        }
        iterator = this.fkField2fkColumn2FieldName.keySet().iterator();
        RDBMSBean.debug("FK Field Name To Column Name Mapping----------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (Map)this.fkField2fkColumn2FieldName.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug(string + ", \t" + string2 + ", \t" + (String)object.get(string2));
            }
        }
        iterator = this.fieldName2RelatedFieldName.keySet().iterator();
        RDBMSBean.debug("Field Name To Related Field Name  Mapping-----------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + (String)this.fieldName2RelatedFieldName.get(string));
        }
        iterator = this.biDirectional.iterator();
        RDBMSBean.debug("Bidirectional fields--------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string);
        }
        iterator = this.one2one.iterator();
        RDBMSBean.debug("1 to 1 fields--------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string);
        }
        iterator = this.one2many.iterator();
        RDBMSBean.debug("1 to N fields--------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string);
        }
        iterator = this.many2many.iterator();
        RDBMSBean.debug("N to M fields--------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string);
        }
        iterator = this.fkField2fkColumn2Class.keySet().iterator();
        RDBMSBean.debug("FK Field Name To Column To Class-------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (Map)this.fkField2fkColumn2Class.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug(string + ", \t" + string2 + ", \t" + ((Class)object.get(string2)).getName());
            }
        }
        iterator = this.fkField2symColumns.keySet().iterator();
        RDBMSBean.debug("Symmetric M-N Field To FK Columns------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string);
            object = (List)this.fkField2symColumns.get(string);
            Iterator<Object> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                String string2;
                string2 = (String)iterator2.next();
                RDBMSBean.debug(" \t" + string2);
            }
        }
        iterator = this.fkField2symColumn2FieldName.keySet().iterator();
        RDBMSBean.debug("Symmetric M-N Field To FK Column To Field--------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (Map)this.fkField2symColumn2FieldName.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug(string + ", \t" + string2 + ", \t" + (String)object.get(string2));
            }
        }
        iterator = this.fkField2pkTable2symFkColumn2pkColumn.keySet().iterator();
        RDBMSBean.debug("Symmetric M-N Field To PK Table To FK Column To PK Column ----");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(" Symmetric CMR Field: " + string);
            object = (Map)this.fkField2pkTable2symFkColumn2pkColumn.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug("    Dest PK Table: " + string2);
                Map map = (Map)object.get(string2);
                for (String string3 : map.keySet()) {
                    RDBMSBean.debug("      FK Column: " + string3 + "   PK Column: " + map.get(string3));
                }
            }
        }
        iterator = this.fieldName2columnName.keySet().iterator();
        RDBMSBean.debug("CMP Field Name To Column Mapping------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + (String)this.fieldName2columnName.get(string));
        }
        iterator = this.fieldName2columnTypeName.keySet().iterator();
        RDBMSBean.debug("CMP Field Name To ColumnType Mapping------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + (String)this.fieldName2columnTypeName.get(string));
        }
        iterator = this.cmpFieldName2groupName.keySet().iterator();
        RDBMSBean.debug("CMP Field Name To GroupName Mapping------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + (String)this.cmpFieldName2groupName.get(string));
        }
        iterator = this.fieldName2tableName.keySet().iterator();
        RDBMSBean.debug("CMR Field Name To Join Table Name Mapping------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string + ", \t" + (String)this.fieldName2tableName.get(string));
        }
        iterator = this.remoteFieldNames.iterator();
        RDBMSBean.debug("RemoteField Names--------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(string);
        }
        iterator = this.remoteFieldNames.iterator();
        RDBMSBean.debug("RemoteField Names To Remote Column----------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (String)this.fieldName2remoteColumn.get(string);
            if (null == object) continue;
            RDBMSBean.debug(string + ", \t" + (String)object);
        }
        iterator = this.fieldName2entityRef.keySet().iterator();
        RDBMSBean.debug("Field Name To Remote Name--------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (EjbEntityRef)this.fieldName2entityRef.get(string);
            RDBMSBean.debug(string + ", " + object.getRemoteEjbName());
        }
        iterator = this.fieldName2groupName.keySet().iterator();
        RDBMSBean.debug("Field Name To Group Name--------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (String)this.fieldName2groupName.get(string);
            RDBMSBean.debug(string + ", " + (String)object);
        }
        iterator = this.fieldName2cascadeDelete.keySet().iterator();
        RDBMSBean.debug("Field Name To Cascade Delete--------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (Boolean)this.fieldName2cascadeDelete.get(string);
            RDBMSBean.debug(string + ", " + ((Boolean)object).toString());
        }
        RDBMSBean.debug("*****************************************************");
    }

    public void printCmpFieldDebugInfo() {
        Object object;
        String string;
        RDBMSBean.debug("*****************************************************");
        RDBMSBean.debug("      CMP FIELD information ");
        RDBMSBean.debug("*****************************************************");
        RDBMSBean.debug("ejbName- " + this.getEjbName());
        Iterator iterator = this.tableName2cmpFieldName2columnName.keySet().iterator();
        RDBMSBean.debug("Table Name To cmp-field To DBMS Column Name  ALL--------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(" Table Name: " + string);
            object = (Map)this.tableName2cmpFieldName2columnName.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug("      " + string2 + ", " + object.get(string2));
            }
        }
        iterator = this.table2cmpf2columnPKsOnly.keySet().iterator();
        RDBMSBean.debug("Table Name To cmp-field To DBMS Column Name  PKs only --------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(" Table Name: " + string);
            object = (Map)this.table2cmpf2columnPKsOnly.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug("      " + string2 + ", " + object.get(string2));
            }
        }
        iterator = this.table2cmpf2columnNoPKs.keySet().iterator();
        RDBMSBean.debug("Table Name To cmp-field To DBMS Column Name  No PKs ----------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(" Table Name: " + string);
            object = (Map)this.table2cmpf2columnNoPKs.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug("      " + string2 + ", " + object.get(string2));
            }
        }
        iterator = this.cmpf2Table.keySet().iterator();
        RDBMSBean.debug("cmp-field To Table--------------------------------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug("      " + string + ", " + this.cmpf2Table.get(string));
        }
        iterator = this.pkCmpF2Table2Column.keySet().iterator();
        RDBMSBean.debug("PK cmp-field To Table Name To DBMS Column Name----------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(" PK cmp-field: " + string);
            object = (Map)this.pkCmpF2Table2Column.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug("      " + string2 + ", " + object.get(string2));
            }
        }
        iterator = this.column2tables.keySet().iterator();
        RDBMSBean.debug("DBMS Column To Tables Containing the Column-------------------");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(" DBMS Column: " + string);
            object = (List)this.column2tables.get(string);
            Iterator<Object> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                String string2;
                string2 = (String)iterator2.next();
                RDBMSBean.debug("      " + string2);
            }
        }
        iterator = this.cmrf2pkTable2fkColumn2pkColumn.keySet().iterator();
        RDBMSBean.debug("CMR Field To PKTable (or JoinTable) To FKColumn to PKColumn----");
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            RDBMSBean.debug(" CMR Field: " + string);
            object = (Map)this.cmrf2pkTable2fkColumn2pkColumn.get(string);
            for (String string2 : object.keySet()) {
                RDBMSBean.debug("    Dest PK Table: " + string2);
                Map map = (Map)object.get(string2);
                for (String string3 : map.keySet()) {
                    RDBMSBean.debug("      FK Column: " + string3 + "   PK Column: " + map.get(string3));
                }
            }
        }
        RDBMSBean.debug("*****************************************************\n");
    }

    public void addTableFieldColumnMapping(String string, String string2, String string3) {
        Map<String, String> map;
        this.fieldsLoadedViaMultiTable = true;
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug(" adding TableFieldColumn Mapping for table: '" + string + "', field: '" + string2 + "', column: '" + string3 + "'");
        }
        if ((map = (HashMap<String, String>)this.tableName2cmpFieldName2columnName.get(string)) == null) {
            map = new HashMap<String, String>();
            this.tableName2cmpFieldName2columnName.put(string, map);
        }
        map.put(string2, string3);
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug(" added TableFieldColumn Mapping for table: '" + string + "' done.");
        }
        if ((map = (Map)this.table2column2cmpf.get(string)) == null) {
            map = new HashMap();
            this.table2column2cmpf.put(string, map);
        }
        map.put(string3, string2);
        this.addReverseColumnMapping(string, string3, string2);
        ArrayList<String> arrayList = (ArrayList<String>)this.column2tables.get(string3);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.column2tables.put(string3, arrayList);
        }
        arrayList.add(string);
        this.cmpf2Table.put(string2, string);
        if (!this.cmpFieldNames.contains(string2)) {
            this.cmpFieldNames.add(string2);
        }
        this.columnName2fieldName.put(string3, string2);
        this.fieldName2columnName.put(string2, string3);
        this.cmpColumnNames.add(string3);
    }

    public void setOptimisticColumn(String string, String string2) {
        this.tableName2optimisticColumn.put(string, string2);
    }

    public void setTriggerUpdatesOptimisticColumn(String string, boolean bl) {
        this.tableName2optimisticColumnTrigger.put(string, new Boolean(bl));
    }

    public boolean getTriggerUpdatesOptimisticColumn(String string) {
        Boolean bl = (Boolean)this.tableName2optimisticColumnTrigger.get(string);
        return bl;
    }

    public void setVersionColumnInitialValue(String string, int n) {
        this.tableName2versionColumnInitialValue.put(string, new Integer(n));
    }

    public int getVersionColumnInitialValue(String string) {
        Integer n = (Integer)this.tableName2versionColumnInitialValue.get(string);
        return n;
    }

    public void addFieldColumnTypeMapping(String string, String string2) {
        if (string2.equals("Blob")) {
            this.hasBlobColumn = true;
        } else if (string2.equals("Clob")) {
            this.hasClobColumn = true;
        } else if (string2.equals("NClob")) {
            this.hasClobColumn = true;
            this.hasNClobColumn = true;
        }
        if (this.hasBlobColumn || this.hasClobColumn) {
            this.hasBlobClobColumn = true;
        }
        this.fieldName2columnTypeName.put(string, string2);
    }

    public void addDbmsDefaultValueField(String string) {
        if (this.dbmsDefaultValueFields == null) {
            this.dbmsDefaultValueFields = new HashSet();
        }
        this.dbmsDefaultValueFields.add(string);
    }

    public boolean isDbmsDefaultValueField(String string) {
        if (this.dbmsDefaultValueFields == null) {
            return false;
        }
        return this.dbmsDefaultValueFields.contains(string) && !this.isPrimaryKeyField(string);
    }

    public boolean allowReadonlyCreateAndRemove() {
        return this.allowReadonlyCreateAndRemove;
    }

    public void setAllowReadonlyCreateAndRemove(boolean bl) {
        this.allowReadonlyCreateAndRemove = bl;
    }

    public void setByteArrayIsSerializedToOracleBlob(boolean bl) {
        this.byteArrayIsSerializedToOracleBlob = bl;
    }

    public boolean getByteArrayIsSerializedToOracleBlob() {
        return this.byteArrayIsSerializedToOracleBlob;
    }

    public void setLoadRelatedBeansFromDbInPostCreate(boolean bl) {
        this.loadRelatedBeansFromDbInPostCreate = bl;
    }

    public boolean getLoadRelatedBeansFromDbInPostCreate() {
        return this.loadRelatedBeansFromDbInPostCreate;
    }

    public boolean hasBlobClobColumn() {
        return this.hasBlobClobColumn;
    }

    public boolean hasBlobColumn() {
        return this.hasBlobColumn;
    }

    public boolean hasClobColumn() {
        return this.hasClobColumn;
    }

    public boolean hasNClobColumn() {
        return this.hasNClobColumn;
    }

    public String getTableForCmpField(String string) {
        return (String)this.cmpf2Table.get(string);
    }

    public int getTableIndexForCmpField(String string) {
        String string2 = this.getTableForCmpField(string);
        if (string2 == null) {
            return -1;
        }
        return this.tableIndex(string2);
    }

    public Map getCmpField2ColumnMap(String string) {
        return (Map)this.tableName2cmpFieldName2columnName.get(string);
    }

    public Map getTableName2CmpField2ColumnMap() {
        return this.tableName2cmpFieldName2columnName;
    }

    public String getColumnForCmpFieldAndTable(String string, String string2) {
        Map map = (Map)this.tableName2cmpFieldName2columnName.get(string2);
        if (map == null) {
            return null;
        }
        return (String)map.get(string);
    }

    public String getCmpColumnForField(String string) {
        return (String)this.fieldName2columnName.get(string);
    }

    public String getCmpFieldForColumn(String string) {
        return (String)this.columnName2fieldName.get(string);
    }

    public String getPkCmpFieldForColumn(String string) {
        for (String string2 : this.table2cmpf2columnPKsOnly.keySet()) {
            Map map = (Map)this.table2cmpf2columnPKsOnly.get(string2);
            for (String string3 : map.keySet()) {
                String string4 = (String)map.get(string3);
                if (!string4.equals(string)) continue;
                return string3;
            }
        }
        return null;
    }

    public boolean hasCmpField(String string, String string2) {
        return this.getCmpField(string, string2) != null;
    }

    public String getCmpField(String string, String string2) {
        Map map = (Map)this.table2column2cmpf.get(string);
        if (map == null) {
            return null;
        }
        return (String)map.get(string2);
    }

    public String getVariable(String string, String string2) {
        Map map = (Map)this.table2column2variable.get(string);
        if (map == null) {
            return null;
        }
        return (String)map.get(string2);
    }

    public String getCmpColumnTypeForField(String string) {
        return (String)this.fieldName2columnTypeName.get(string);
    }

    public boolean isBlobCmpColumnTypeForField(String string) {
        return "Blob".equalsIgnoreCase(this.getCmpColumnTypeForField(string));
    }

    public boolean isClobCmpColumnTypeForField(String string) {
        return "Clob".equalsIgnoreCase(this.getCmpColumnTypeForField(string)) || this.isNClobCmpColumnTypeForField(string);
    }

    public boolean isNClobCmpColumnTypeForField(String string) {
        return "NClob".equalsIgnoreCase(this.getCmpColumnTypeForField(string));
    }

    public boolean isBlobCmpColumnTypeForColumn(String string) {
        String string2 = (String)this.columnName2fieldName.get(string);
        return this.isBlobCmpColumnTypeForField(string2);
    }

    public boolean isClobCmpColumnTypeForColumn(String string) {
        String string2 = (String)this.columnName2fieldName.get(string);
        return this.isClobCmpColumnTypeForField(string2);
    }

    public Map getCmpColumnToFieldMap() {
        return this.columnName2fieldName;
    }

    public Map getCmpFieldToColumnMap() {
        return this.fieldName2columnName;
    }

    public Map getCmpFieldToColumnTypeMap() {
        return this.fieldName2columnTypeName;
    }

    public Class getCmpFieldClass(String string) {
        assert (this.cmpFieldClasses.get(string) != null);
        return (Class)this.cmpFieldClasses.get(string);
    }

    public List getCmpFieldNames() {
        return this.cmpFieldNames;
    }

    public List getCmpColumnNames() {
        return this.cmpColumnNames;
    }

    public boolean isCmpFieldName(String string) {
        return this.cmpFieldNames.contains(string);
    }

    public boolean hasCmpField(String string) {
        return this.fieldName2columnName.get(string) != null;
    }

    public boolean hasCmpColumnType(String string) {
        return this.fieldName2columnTypeName.get(string) != null;
    }

    public boolean hasPkColumn(String string) {
        return this.getPkCmpFieldForColumn(string) != null;
    }

    public boolean isCmrMappedCmpField(String string) {
        return this.cmrMappedcmpFields.contains(string);
    }

    public String getTableForVariable(String string) {
        return (String)this.variableName2table.get(string);
    }

    public String getCmpColumnForVariable(String string) {
        return (String)this.variableName2columnName.get(string);
    }

    public boolean isJoinTable(String string) {
        return this.fieldName2tableName.containsValue(string);
    }

    public String getCmrFieldForJoinTable(String string) {
        for (String string2 : this.fieldName2tableName.keySet()) {
            String string3 = (String)this.fieldName2tableName.get(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public Map getJoinTableMap() {
        return this.fieldName2tableName;
    }

    public Map getFkColumn2ClassMapForFkField(String string) {
        return (Map)this.fkField2fkColumn2Class.get(string);
    }

    public void setOrderDatabaseOperations(boolean bl) {
        this.orderDatabaseOperations = bl;
    }

    public boolean getOrderDatabaseOperations() {
        return this.orderDatabaseOperations;
    }

    public void setEnableBatchOperations(boolean bl) {
        this.enableBatchOperations = bl;
        if (this.getDelayInsertUntil().equals("commit")) {
            this.enableBatchOperations = true;
        }
        if (this.enableBatchOperations) {
            this.orderDatabaseOperations = true;
        }
        if (this.hasAutoKeyGeneration() && this.genKeyType == 1) {
            this.enableBatchOperations = false;
            this.orderDatabaseOperations = false;
        }
    }

    public boolean getEnableBatchOperations() {
        return this.enableBatchOperations;
    }

    public String getValidateDbSchemaWith() {
        return this.validateDbSchemaWith;
    }

    public void setValidateDbSchemaWith(String string) {
        this.validateDbSchemaWith = string;
    }

    public String getCreateDefaultDBMSTables() {
        return this.createDefaultDBMSTables;
    }

    public void setCreateDefaultDBMSTables(String string) {
        this.createDefaultDBMSTables = string;
    }

    public String getDefaultDbmsTablesDdl() {
        return this.ddlFileName;
    }

    public void setDefaultDbmsTablesDdl(String string) {
        this.ddlFileName = string;
    }

    public int getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(int n) {
        this.databaseType = n;
    }

    public void setCheckExistsOnMethod(boolean bl) {
        this.checkExistsOnMethod = bl;
    }

    public boolean getCheckExistsOnMethod() {
        return this.checkExistsOnMethod;
    }

    public void setClusterInvalidationDisabled(boolean bl) {
        this.clusterInvalidationDisabled = bl;
    }

    public boolean isClusterInvalidationDisabled() {
        return this.clusterInvalidationDisabled;
    }

    public void setDelayInsertUntil(String string) {
        this.delayInsertUntil = string;
    }

    public String getDelayInsertUntil() {
        return this.delayInsertUntil;
    }

    public void setUseSelectForUpdate(boolean bl) {
        this.useSelectForUpdate = bl;
    }

    public boolean getUseSelectForUpdate() {
        return this.useSelectForUpdate;
    }

    public void setLockOrder(int n) {
        this.lockOrder = n;
    }

    public int getLockOrder() {
        return this.lockOrder;
    }

    public void setInstanceLockOrder(String string) {
        this.instanceLockOrder = string;
    }

    public String getInstanceLockOrder() {
        return this.instanceLockOrder;
    }

    public int getFieldCount() {
        return this.numFields;
    }

    public Integer getIsModifiedIndex(String string) {
        return (Integer)this.fieldNameToIsModifiedIndex.get(string);
    }

    public Map getFieldNameToIsModifiedIndex() {
        return this.fieldNameToIsModifiedIndex;
    }

    public String getFieldName(Integer n) {
        return (String)this.isModifiedIndexToFieldName.get(n);
    }

    public List getNonPKFields(int n) {
        return this.tableIndexToNonPKFieldList[n];
    }

    public List getFields(int n) {
        return this.tableIndexToFieldList[n];
    }

    public List getCMPFields(int n) {
        return this.tableIndexToCMPFieldList[n];
    }

    public List getCMRFields(int n) {
        return this.tableIndexToCMRFieldList[n];
    }

    public List getIsModifiedIndices_PK() {
        return this.isModifiedPKIndexList;
    }

    public Integer getTableNumber(int n) {
        return (Integer)this.isModifiedIndexToTableNumber.get(n);
    }

    public List getIsModifiedIndexToTableNumber() {
        return this.isModifiedIndexToTableNumber;
    }

    public void addFinder(Finder finder) {
        this.finderList.add(finder);
        if (finder.isResultSetFinder()) {
            this.hasResultSetFinder = true;
        }
        if (finder.isSqlFinder()) {
            this.hasSqlFinder = true;
        }
    }

    public Finder createFinder(String string, String[] stringArray, String string2) throws InvalidFinderException {
        Finder finder;
        RDBMSFinder rDBMSFinder = (RDBMSFinder)this.getRdbmsFinders().get(new RDBMSFinder.FinderKey(string, stringArray));
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug("******************** ejb- " + this.getEjbName() + ", finder - " + string);
        }
        if (rDBMSFinder != null) {
            if (rDBMSFinder.getSqlQueries() != null) {
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug("sql ******************** ejb- " + this.getEjbName() + ", finder - " + string);
                }
                SqlFinder sqlFinder = new SqlFinder(string, rDBMSFinder.getSqlQueries(), rDBMSFinder.getSqlShapeName(), this);
                finder = sqlFinder;
            } else {
                EjbqlFinder ejbqlFinder = new EjbqlFinder(string, string2);
                if (rDBMSFinder.getEjbQlQuery() != null) {
                    if (debugLogger.isDebugEnabled()) {
                        RDBMSBean.debug("wl ql ******************** ejb- " + this.getEjbName() + ", finder - " + string);
                    }
                    ejbqlFinder.setEjbQuery(rDBMSFinder.getEjbQlQuery());
                }
                ejbqlFinder.setGroupName(rDBMSFinder.getGroupName());
                ejbqlFinder.setCachingName(rDBMSFinder.getCachingName());
                ejbqlFinder.setSqlSelectDistinct(rDBMSFinder.getSqlSelectDistinct());
                ejbqlFinder.setIncludeResultCacheHint(rDBMSFinder.isIncludeResultCacheHint());
                finder = ejbqlFinder;
            }
            finder.setMaxElements(rDBMSFinder.getMaxElements());
            finder.setIncludeUpdates(rDBMSFinder.getIncludeUpdates());
        } else {
            finder = new EjbqlFinder(string, string2);
        }
        finder.setRDBMSBean(this);
        return finder;
    }

    public void perhapsSetQueryCachingEnabled(Finder finder) {
        RDBMSFinder rDBMSFinder = (RDBMSFinder)this.getRdbmsFinders().get(new RDBMSFinder.FinderKey(finder));
        if (rDBMSFinder != null) {
            finder.setQueryCachingEnabled(rDBMSFinder, this);
        } else {
            finder.setQueryCachingEnabled(false);
        }
    }

    public Iterator getFinders() {
        return this.finderList.iterator();
    }

    public List getFinderList() {
        return this.finderList;
    }

    public void setFinderList(List list) {
        this.finderList = list;
    }

    public boolean hasResultSetFinder() {
        return this.hasResultSetFinder;
    }

    public void generateFinderSQLStatements(Iterator iterator) throws ErrorCollectionException {
        EJBQLParsingException eJBQLParsingException = new EJBQLParsingException();
        while (iterator.hasNext()) {
            Finder finder = (Finder)iterator.next();
            if (!(finder instanceof EjbqlFinder)) continue;
            EjbqlFinder ejbqlFinder = (EjbqlFinder)finder;
            try {
                ejbqlFinder.computeSQLQuery(this);
                if (!debugLogger.isDebugEnabled()) continue;
                String string = finder.getSQLQuery();
                if (string == null) {
                    RDBMSBean.debug("finder.computSQLQuery: None generated.  NULL !");
                    continue;
                }
                RDBMSBean.debug("finder.computSQLQuery: " + string);
            }
            catch (EJBQLCompilerException eJBQLCompilerException) {
                eJBQLParsingException.add(eJBQLCompilerException);
            }
        }
        if (eJBQLParsingException.getExceptions().size() > 0) {
            throw eJBQLParsingException;
        }
    }

    public List getCmrFieldNames() {
        return this.cmrFieldNames;
    }

    public List getDeclaredFieldNames() {
        return this.declaredFieldNames;
    }

    public List getForeignKeyFieldNames() {
        return this.fkFieldNames;
    }

    public List getForeignPrimaryKeyFieldNames() {
        return this.fkPkFieldNames;
    }

    public List getRemoteFieldNames() {
        return this.remoteFieldNames;
    }

    public boolean isRemoteField(String string) {
        return this.remoteFieldNames.contains(string);
    }

    public EjbEntityRef getEjbEntityRef(String string) {
        return (EjbEntityRef)this.fieldName2entityRef.get(string);
    }

    public Class getForeignKeyColClass(String string, String string2) {
        assert (this.fkField2fkColumn2Class.get(string) != null);
        assert (((Map)this.fkField2fkColumn2Class.get(string)).get(string2) != null);
        return (Class)((Map)this.fkField2fkColumn2Class.get(string)).get(string2);
    }

    public List getForeignKeyColNames(String string) {
        assert (this.fkField2fkColumns.get(string) != null);
        return (List)this.fkField2fkColumns.get(string);
    }

    public Class getJavaClassTypeForFkCol(String string, String string2) {
        Map map = (Map)this.table2fkCol2fkClass.get(string);
        if (map == null) {
            return null;
        }
        return (Class)map.get(string2);
    }

    public boolean hasCmrField(String string, String string2) {
        return this.getJavaClassTypeForFkCol(string, string2) != null;
    }

    public RDBMSBean getRelatedBean(String string, String string2) {
        Map map = (Map)this.table2fkCol2RelatedBean.get(string);
        if (map == null) {
            return null;
        }
        return (RDBMSBean)map.get(string2);
    }

    public List getSymmetricKeyColNames(String string) {
        assert (this.fkField2fkColumns.get(string) != null);
        assert (this.fkField2symColumns.get(string) != null);
        return (List)this.fkField2symColumns.get(string);
    }

    public Map getSymmetricColumn2FieldName(String string) {
        return (Map)this.fkField2symColumn2FieldName.get(string);
    }

    public boolean isSymmetricField(String string) {
        return this.fkField2symColumns.get(string) != null;
    }

    public Class getCmrFieldClass(String string) {
        return (Class)this.fieldName2class.get(string);
    }

    public boolean isDeclaredField(String string) {
        return this.declaredFieldNames.contains(string);
    }

    public boolean isForeignKeyField(String string) {
        return this.fkFieldNames.contains(string);
    }

    public boolean isForeignPrimaryKeyField(String string) {
        return this.fkPkFieldNames.contains(string);
    }

    public boolean isForeignCmpField(String string) {
        return this.fkCmpFieldNames.contains(string);
    }

    public boolean isOneToOneRelation(String string) {
        return this.one2one.contains(string);
    }

    public boolean isOneToManyRelation(String string) {
        return this.one2many.contains(string);
    }

    public boolean isManyToManyRelation(String string) {
        return this.many2many.contains(string);
    }

    public boolean isBiDirectional(String string) {
        return this.biDirectional.contains(string);
    }

    public boolean isCascadeDelete(String string) {
        return (Boolean)this.fieldName2cascadeDelete.get(string);
    }

    public boolean isCascadeDelete() {
        for (String string : this.getCmrFieldNames()) {
            if (!this.isCascadeDelete(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isDBCascadeDelete(String string) {
        return (Boolean)this.fieldName2DBCascadeDelete.get(string);
    }

    public String getRemoteColumn(String string) {
        assert (this.fieldName2remoteColumn.get(string) != null);
        return (String)this.fieldName2remoteColumn.get(string);
    }

    public String getRelatedFieldName(String string) {
        return (String)this.fieldName2RelatedFieldName.get(string);
    }

    public String getRelatedPkFieldName(String string, String string2) {
        assert (this.isForeignKeyField(string));
        assert (this.fkField2fkColumn2FieldName.get(string) != null);
        assert (((Map)this.fkField2fkColumn2FieldName.get(string)).get(string2) != null);
        return (String)((Map)this.fkField2fkColumn2FieldName.get(string)).get(string2);
    }

    public CMPBeanDescriptor getRelatedDescriptor(String string) {
        assert (this.fieldName2relatedDescriptor.get(string) != null);
        return (CMPBeanDescriptor)this.fieldName2relatedDescriptor.get(string);
    }

    public RDBMSBean getRelatedRDBMSBean(String string) {
        assert (this.fieldName2relatedRDBMSBean.get(string) != null);
        return (RDBMSBean)this.fieldName2relatedRDBMSBean.get(string);
    }

    public Set getAllCmrFields() {
        return this.fieldName2relatedRDBMSBean.keySet();
    }

    public String getRelatedMultiplicity(String string) {
        return (String)this.fieldName2relatedMultiplicity.get(string);
    }

    public boolean relatedFieldIsFkOwner(String string) {
        assert (this.fieldName2relatedFieldOwnsFk.get(string) != null);
        return (Boolean)this.fieldName2relatedFieldOwnsFk.get(string);
    }

    public String getRelatedBeanClassName(String string) {
        assert (this.fieldName2relatedClassName.get(string) != null);
        return (String)this.fieldName2relatedClassName.get(string);
    }

    public String getJoinTableName(String string) {
        assert (this.fieldName2tableName.get(string) != null);
        return (String)this.fieldName2tableName.get(string);
    }

    public String getGroupName(String string) {
        return (String)this.fieldName2groupName.get(string);
    }

    public Set getTableNamesForGroup(String string) {
        return (Set)this.groupName2tableNames.get(string);
    }

    public boolean containsFkField(String string) {
        assert (this.isForeignKeyField(string));
        boolean bl = this.isOneToOneRelation(string);
        boolean bl2 = this.isOneToManyRelation(string) && this.getRelatedMultiplicity(string).equals("One");
        return bl || bl2;
    }

    public String findByPrimaryKeyQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT OBJECT(bean) ");
        stringBuffer.append("FROM ").append(this.getAbstractSchemaName());
        stringBuffer.append(" AS bean ");
        stringBuffer.append("WHERE ");
        int n = 1;
        Iterator iterator = this.bd.getPrimaryKeyFieldNames().iterator();
        assert (iterator.hasNext());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            assert (string != null);
            String string2 = " ( bean." + string + " = ?" + n++ + " ) ";
            stringBuffer.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        return stringBuffer.toString();
    }

    private String findByForeignKeyQuery(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet<String> treeSet = new TreeSet<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : this.getForeignKeyColNames(string)) {
            object = this.getRelatedPkFieldName(string, string2);
            treeSet.add((String)object);
            hashMap.put((String)object, string2);
        }
        stringBuffer.append("SELECT OBJECT(bean) ");
        stringBuffer.append("FROM ").append(this.getAbstractSchemaName());
        stringBuffer.append(" AS bean ");
        stringBuffer.append("WHERE (");
        int n = 1;
        object = treeSet.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            String string4 = (String)hashMap.get(string3);
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing foreign key column: " + string4);
            }
            stringBuffer.append("bean.");
            stringBuffer.append(this.variableForField(string, this.getTableForCmrField(string), string4) + " = ?" + n++);
            if (!object.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        stringBuffer.append(")");
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug("relation Finder query: " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void createRelationFinders() {
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug("createRelationFinders() called...");
        }
        this.relFinders = new ArrayList();
        Iterator iterator = this.getCmrFieldNames().iterator();
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug(iterator.hasNext() ? "have a field" : "no fields");
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing field: " + string);
            }
            if (this.isRemoteField(string) || !this.isOneToOneRelation(string) && !this.isOneToManyRelation(string)) continue;
            String string2 = null;
            string2 = this.relatedFieldIsFkOwner(string) ? this.findByPrimaryKeyQuery() : this.findByForeignKeyQuery(string);
            EjbqlFinder ejbqlFinder = null;
            RDBMSBean rDBMSBean = this.getRelatedRDBMSBean(string);
            CMPBeanDescriptor cMPBeanDescriptor = this.getRelatedDescriptor(string);
            String string3 = this.getRelatedFieldName(string);
            try {
                ejbqlFinder = new EjbqlFinder(this.finderMethodName(cMPBeanDescriptor, string3), string2);
                ejbqlFinder.setIncludeUpdates(false);
                ejbqlFinder.parseExpression();
            }
            catch (Exception exception) {
                throw new AssertionError(StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            ejbqlFinder.setModifierString("public ");
            Class clazz = rDBMSBean.getCmrFieldClass(string3);
            assert (clazz != null);
            if (Collection.class.isAssignableFrom(clazz)) {
                ejbqlFinder.setReturnClassType(Collection.class);
            } else {
                ejbqlFinder.setReturnClassType(clazz);
            }
            ejbqlFinder.setExceptionClassTypes(new Class[]{Exception.class});
            ejbqlFinder.setKeyFinder(true);
            if (this.relatedFieldIsFkOwner(string)) {
                ejbqlFinder.setParameterClassTypes(new Class[]{this.bd.getPrimaryKeyClass()});
                ejbqlFinder.setKeyBean(this);
            } else {
                ejbqlFinder.setParameterClassTypes(new Class[]{cMPBeanDescriptor.getPrimaryKeyClass()});
                ejbqlFinder.setKeyBean(rDBMSBean);
            }
            ejbqlFinder.setFinderLoadsBean(this.bd.getFindersLoadBean());
            ejbqlFinder.setRDBMSBean(this);
            ejbqlFinder.setGroupName(this.getGroupName(string));
            ejbqlFinder.setIsGeneratedRelationFinder(true);
            this.relFinders.add(ejbqlFinder);
            if (this.isCascadeDelete(string)) {
                ejbqlFinder.setCachingName(this.getRelationshipCachingForField(string));
            }
            this.cmrMapeedRelationFinder.put(string, ejbqlFinder);
        }
    }

    public Finder getRelatedFinder(String string) {
        return (Finder)this.cmrMapeedRelationFinder.get(string);
    }

    public String getRelationshipCachingForField(String string) {
        for (RelationshipCaching relationshipCaching : this.getRelationshipCachings()) {
            for (RelationshipCaching.CachingElement cachingElement : relationshipCaching.getCachingElements()) {
                if (cachingElement.getCmrField() == null || !cachingElement.getCmrField().equals(string)) continue;
                return relationshipCaching.getCachingName();
            }
        }
        return null;
    }

    public void createRelationFinders2() {
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug("createRelationFinders2() called...");
        }
        Iterator iterator = this.getForeignKeyFieldNames().iterator();
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug(iterator.hasNext() ? "have a foreign key" : "no foreign keys");
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("processing foreign key field: " + string);
            }
            if (!this.isManyToManyRelation(string) || this.isRemoteField(string)) continue;
            RDBMSBean rDBMSBean = this.getRelatedRDBMSBean(string);
            String string2 = this.getRelatedFieldName(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT OBJECT(bean." + string + ") ");
            stringBuffer.append("FROM ").append(this.getAbstractSchemaName());
            stringBuffer.append(" AS bean ");
            String string3 = stringBuffer.toString();
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug("relation Finder query: " + string3);
            }
            EjbqlFinder ejbqlFinder = null;
            try {
                String string4 = this.finderMethodName(this.bd, string);
                ejbqlFinder = new EjbqlFinder(string4, string3);
                ejbqlFinder.setIncludeUpdates(false);
                ejbqlFinder.parseExpression();
            }
            catch (Exception exception) {
                throw new AssertionError(StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            ejbqlFinder.setParameterClassTypes(new Class[0]);
            ejbqlFinder.setModifierString("public ");
            ejbqlFinder.setReturnClassType(Collection.class);
            ejbqlFinder.setExceptionClassTypes(new Class[]{Exception.class});
            ejbqlFinder.setIsSelectInEntity(true);
            ejbqlFinder.setQueryType(4);
            ejbqlFinder.setFinderLoadsBean(this.bd.getFindersLoadBean());
            ejbqlFinder.setRDBMSBean(this);
            ejbqlFinder.setIsGeneratedRelationFinder(true);
            this.relFinders.add(ejbqlFinder);
        }
    }

    public List getRelationFinderList() {
        if (this.relFinders == null) {
            this.relFinders = new ArrayList();
        }
        return this.relFinders;
    }

    public Iterator getRelationFinders() {
        return this.getRelationFinderList().iterator();
    }

    public void cleanup() {
        this.dataSourceName = null;
        this.finderList = null;
        this.cmpFieldNames = null;
        this.cmpFieldClasses = null;
        this.cmpColumnNames = null;
        this.cmpFieldName2groupName = null;
        this.fieldGroups = null;
        this.relationshipCachings = null;
        this.rdbmsFinders = null;
        this.dbmsDefaultValueFields = null;
        this.tableName2verifyRows = null;
        this.tableName2optimisticColumnTrigger = null;
        this.tableName2versionColumnInitialValue = null;
        this.table2cmpf2columnNoPKs = null;
        this.cmpf2Table = null;
        this.pkCmpF2Table2Column = null;
        this.column2tables = null;
        this.cmrf2table = null;
        this.cmrfHasMultiPkTable = null;
        this.cmrf2pkTable2fkColumn2pkColumn = null;
        this.fkField2pkTable2symFkColumn2pkColumn = null;
        this.variableName2table = null;
        this.fkField2fkColumn2Class = null;
        this.one2one = null;
        this.one2many = null;
        this.many2many = null;
        this.biDirectional = null;
        this.fieldName2cascadeDelete = null;
        this.fieldName2DBCascadeDelete = null;
        this.fieldName2selfRel = null;
        this.fieldName2RelatedFieldName = null;
        this.fkField2fkColumn2FieldName = null;
        this.fkField2symColumn2FieldName = null;
        this.fieldName2relatedDescriptor = null;
        this.fieldName2relatedMultiplicity = null;
        this.fieldName2relatedFieldOwnsFk = null;
        this.fieldName2relatedClassName = null;
        this.fieldName2groupName = null;
        this.variableName2columnName = null;
        this.cmrFieldNames = null;
        this.declaredFieldNames = null;
        this.fkFieldNames = null;
        this.fkPkFieldNames = null;
        this.fkCmpFieldNames = null;
        this.fieldName2class = null;
        this.fkField2symColumns = null;
        this.fieldName2relatedRDBMSBean = null;
        this.fieldName2tableName = null;
        this.groupName2tableNames = null;
        this.fieldName2entityRef = null;
        this.remoteFieldNames = null;
        this.fieldName2remoteColumn = null;
        this.cmrMappedcmpFields = null;
        if (!this.hasSqlFinder) {
            this.table2cmrf = null;
            this.fkField2fkColumns = null;
            this.columnName2fieldName = null;
            this.tableName2cmpFieldName2columnName = null;
        }
    }

    public void setupAutoKeyGen() throws RDBMSException {
        if (!this.hasAutoKeyGeneration()) {
            return;
        }
        this.setGenKeyPKField();
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug(" AutoKey Generation is ON");
        }
        switch (this.getGenKeyType()) {
            case 2: {
                if (this.genKeyGeneratorName == null) {
                    Loggable loggable = EJBLogger.logBadAutoKeyGeneratorNameLoggable((String)"Sequence", (String)"database Sequence");
                    throw new RDBMSException(loggable.getMessage());
                }
                this.genKeyBeforeInsert = true;
                this.genKeyExcludePKColumn = false;
                this.genKeyDefaultColumnVal = null;
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug(" Generated Key Query: for Oracle, this is deferred to deployment time");
                }
                return;
            }
            case 1: {
                this.genKeyBeforeInsert = false;
                this.genKeyExcludePKColumn = true;
                this.genKeyDefaultColumnVal = null;
                if (this.databaseType == 2) {
                    this.genKeyWLGeneratorQuery = "SELECT @@IDENTITY";
                } else if (this.databaseType == 7) {
                    this.genKeyWLGeneratorQuery = "SELECT SCOPE_IDENTITY()";
                }
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug(" Generated Key Query: " + this.genKeyWLGeneratorQuery);
                }
                return;
            }
            case 3: {
                this.genKeyBeforeInsert = true;
                this.genKeyExcludePKColumn = false;
                this.genKeyDefaultColumnVal = null;
                if (this.genKeyGeneratorName == null) {
                    Loggable loggable = EJBLogger.logBadAutoKeyGeneratorNameLoggable((String)"SequenceTable", (String)"database sequence table");
                    throw new RDBMSException(loggable.getMessage());
                }
                this.perhapsSetGenKeyCacheDefault();
                this.genKeyWLGeneratorQuery = "SELECT SEQUENCE FROM " + this.genKeyGeneratorName;
                this.genKeyWLGeneratorUpdatePrefix = "UPDATE " + this.genKeyGeneratorName + " SET SEQUENCE = SEQUENCE + ";
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug(" Generated Key Query:  " + this.genKeyWLGeneratorQuery);
                }
                if (debugLogger.isDebugEnabled()) {
                    RDBMSBean.debug(" Generated Key Update: " + this.genKeyWLGeneratorUpdatePrefix);
                }
                return;
            }
        }
        throw new AssertionError("Unknown auto-key generator for " + this.ejbName);
    }

    String getOracleSequenceGeneratorQuery(String string) {
        return "SELECT " + string + ".nextval FROM DUAL";
    }

    String getInformixSequenceGeneratorQuery(String string) {
        return "SELECT " + string + ".nextval FROM SYSTABLES WHERE tabid=1";
    }

    String getDB2SequenceGeneratorQuery(String string) {
        return "SELECT NEXTVAL for " + string + " FROM SYSIBM.SYSDUMMY1";
    }

    private void setGenKeyPKField() throws RDBMSException {
        Class clazz;
        Iterator iterator = this.bd.getPrimaryKeyFieldNames().iterator();
        assert (iterator.hasNext());
        this.genKeyPKField = (String)iterator.next();
        if (this.isForeignPrimaryKeyField(this.genKeyPKField)) {
            Loggable loggable = EJBLogger.logAutoKeyCannotBePartOfFKLoggable();
            throw new RDBMSException(loggable.getMessage());
        }
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug(" Gen Key PK Field: " + this.genKeyPKField);
        }
        if ((clazz = this.getCmpFieldClass(this.genKeyPKField)).equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            this.genKeyPKFieldClassType = 0;
        } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            this.genKeyPKFieldClassType = 1;
        } else {
            throw new AssertionError("invalid pk class: " + clazz.getName());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RDBMSBean)) {
            return false;
        }
        RDBMSBean rDBMSBean = (RDBMSBean)object;
        if (!this.dataSourceName.equals(rDBMSBean.getDataSourceName())) {
            return false;
        }
        return ((Object)this.finderList).equals(rDBMSBean.getFinderList());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("[weblogic.cmp.rdbms.RDBMSBean {");
        stringBuffer.append("\n\tname = " + this.ejbName);
        stringBuffer.append("\n\tdata source = " + this.dataSourceName);
        stringBuffer.append("\n\ttableNames = ");
        Iterator<Object> iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next() + ", ");
        }
        stringBuffer.append("\n\tfinderList = " + this.finderList);
        stringBuffer.append("\n\tField Name to Column Name = ");
        if (this.fieldName2columnName != null) {
            for (String string : this.fieldName2columnName.keySet()) {
                stringBuffer.append("\n\t\tfield- " + string + " column- " + this.fieldName2columnName.get(string));
            }
        }
        stringBuffer.append("\n} end RDBMSBean ]\n");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.dataSourceName.hashCode() ^ this.getTableName().hashCode();
    }

    private void perhapsSetGenKeyCacheDefault() {
        if (this.genKeyCacheSize <= 0) {
            this.genKeyCacheSize = 10;
        }
    }

    public static void deleteDefaultDbmsTableDdlFile(String string) {
        try {
            File file = new File(string);
            file.delete();
        }
        catch (Exception exception) {
            EJBLogger.logUnableToDeleteDDLFile((String)string);
        }
    }

    public void addTableDefToDDLFile() {
        try {
            Iterator<Object> iterator = this.getTables().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                string = RDBMSUtils.escQuotedID(string);
                this.createDefaultDBMSTable(string, stringBuffer);
            }
            for (String string : this.getJoinTableMap().values()) {
                this.createDefaultDBMSTable(string, stringBuffer);
            }
            this.writeToDDLFile(stringBuffer.toString());
        }
        catch (Exception exception) {
            EJBLogger.logUnableToWriteToDDLFile((String)this.ddlFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeToDDLFile(String string) {
        block8: {
            BufferedWriter bufferedWriter = null;
            bufferedWriter = new BufferedWriter(new FileWriter(this.ddlFileName, true));
            bufferedWriter.write(string + "\n\n");
            bufferedWriter.flush();
            Object var5_3 = null;
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
            break block8;
            {
                catch (Exception exception) {
                    EJBLogger.logUnableToCreateDDLFile((Exception)exception);
                    Object var5_4 = null;
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void createDefaultDBMSTable(String string, StringBuffer stringBuffer) throws Exception {
        stringBuffer.append("\n DROP TABLE " + string + "\n");
        stringBuffer.append("\nCREATE TABLE " + string + " (");
        this.addBeanOrJoinTableColumns(string, stringBuffer);
        stringBuffer.append(" )\n");
    }

    private void addSequenceTableColumns(String string, StringBuffer stringBuffer) throws Exception {
        if (this.hasAutoKeyGeneration() && this.getGenKeyType() == 3) {
            String string2 = this.getGenKeyGeneratorName();
            if (string2 != null && string != null) {
                if (string2.equals(string)) {
                    stringBuffer.append("SEQUENCE ").append("DECIMAL");
                }
            } else {
                throw new RDBMSException(" in getSequenceTableColumns: either the SEQUENCE_TABLE name in the RDBMSBean or the passed in table Name  is NULL for bean: " + this.ejbName);
            }
        }
    }

    private void addBeanOrJoinTableColumns(String string, StringBuffer stringBuffer) throws Exception {
        HashSet hashSet = new HashSet();
        if (this.isJoinTable(string)) {
            this.addJoinTableColumns(string, stringBuffer, hashSet);
        } else {
            this.addBeanTableColumns(string, stringBuffer, hashSet);
        }
        if (hashSet.size() > 0) {
            stringBuffer.append(",");
            if (this.databaseType == 2 || this.databaseType == 7) {
                stringBuffer.append(" CONSTRAINT pk_" + string);
            }
            stringBuffer.append(" PRIMARY KEY (");
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                stringBuffer.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
    }

    private void addJoinTableColumns(String string, StringBuffer stringBuffer, Set set) throws Exception {
        Iterator iterator;
        Object object;
        Object object22;
        String string2;
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug(" createDefaultDBMSTable: processing Join Table: " + string);
        }
        if (null == (string2 = this.getCmrFieldForJoinTable(string))) {
            throw new RDBMSException(" Bean: " + this.ejbName + ", could not get cmrField for Join Table " + string);
        }
        Map map = this.getFkColumn2ClassMapForFkField(string2);
        if (null == map) {
            throw new RDBMSException(" Bean: " + this.ejbName + ", could not get Column To Class Map for FK Field " + string2);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : map.keySet()) {
            object = (Class)map.get(object22);
            stringBuffer.append((String)object22 + " ");
            stringBuffer.append(this.getDefaultDBMSColType((Class)object));
            if (this.databaseType == 2 || this.databaseType == 7) {
                stringBuffer.append(" NOT NULL ");
            }
            stringBuffer.append(", ");
            set.add(object22);
            arrayList.add(object22);
        }
        if (this.isRemoteField(string2)) {
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug(" Do REMOTE RHS of Join Table ");
            }
            object22 = this.getEjbEntityRef(string2);
            object = null;
            String string3 = this.getRemoteColumn(string2);
            stringBuffer.append(string3 + " ");
            Class<?> clazz = object;
            if (!this.isValidSQLType((Class)object) && Serializable.class.isAssignableFrom((Class<?>)object)) {
                byte[] byArray = new byte[]{};
                clazz = byArray.getClass();
            }
            stringBuffer.append(this.getDefaultDBMSColType(clazz));
            set.add(string3);
        } else if (this.isSymmetricField(string2)) {
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug(" Do Symmetric RHS of Join Table ");
            }
            if (null == (object22 = this.getSymmetricColumn2FieldName(string2))) {
                throw new RDBMSException(" Bean: " + this.ejbName + ", could not get Symmetric Column To Class " + "Map for FK Field " + string2);
            }
            iterator = object22.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (arrayList.contains(object)) continue;
                stringBuffer.append((String)object + " ");
                String string4 = (String)object22.get(object);
                Class clazz = this.getCmpFieldClass(string4);
                stringBuffer.append(this.getDefaultDBMSColType(clazz));
                set.add(object);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        } else {
            if (debugLogger.isDebugEnabled()) {
                RDBMSBean.debug(" Do Normal non-Remote non-Symmetric RHS of Join Table ");
            }
            if (null == (map = ((RDBMSBean)(object22 = this.getRelatedRDBMSBean(string2))).getFkColumn2ClassMapForFkField((String)(object = this.getRelatedFieldName(string2))))) {
                throw new RDBMSException(" Bean: " + ((RDBMSBean)object22).getEjbName() + ", could not get Column To Class Map for FK Field " + (String)object);
            }
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                if (arrayList.contains(string5)) continue;
                Class clazz = (Class)map.get(string5);
                stringBuffer.append(string5 + " ");
                stringBuffer.append(this.getDefaultDBMSColType(clazz));
                set.add(string5);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
    }

    private void addBeanTableColumns(String string, StringBuffer stringBuffer, Set set) throws Exception {
        Object object;
        String string2;
        Object object2;
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug(" createDefaultDBMSTable: processing Bean Table: " + string);
        }
        List list = this.getPrimaryKeyFields();
        HashSet<String> hashSet = new HashSet<String>();
        Map map = this.getCmpField2ColumnMap(string);
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            string2 = (String)map.get(object2);
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            stringBuffer.append(string2 + " ");
            object = this.getCmpFieldClass((String)object2);
            stringBuffer.append(this.getDefaultDBMSColType((Class)object));
            if (list.contains(object2)) {
                set.add(string2);
                if (this.databaseType == 2 || this.databaseType == 7 || this.databaseType == 4 || this.databaseType == 9) {
                    stringBuffer.append(" NOT NULL ");
                }
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        object2 = this.getCmrFields(string);
        if (object2 != null) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!this.containsFkField(string2)) continue;
                object = this.getForeignKeyColNames(string2).iterator();
                Map map2 = this.getFkColumn2ClassMapForFkField(string2);
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    if (hashSet.contains(string3)) continue;
                    stringBuffer.append(", ");
                    hashSet.add(string3);
                    stringBuffer.append(string3 + " ");
                    Class clazz = (Class)map2.get(string3);
                    stringBuffer.append(this.getDefaultDBMSColType(clazz));
                    if (!list.contains(string2)) continue;
                    set.add(string3);
                    if (this.databaseType != 2 && this.databaseType != 7) continue;
                    stringBuffer.append(" NOT NULL ");
                }
            }
        }
    }

    public void setCharArrayIsSerializedToBytes(boolean bl) {
        this.charArrayIsSerializedToBytes = bl;
    }

    public void setDisableStringTrimming(boolean bl) {
        this.disableStringTrimming = bl;
    }

    public void setFindersReturnNulls(boolean bl) {
        this.findersReturnNulls = bl;
    }

    public boolean isFindersReturnNulls() {
        return this.findersReturnNulls;
    }

    public boolean isStringTrimmingEnabled() {
        return !this.disableStringTrimming;
    }

    public boolean isCharArrayMappedToString(Class clazz) {
        return clazz.isArray() && clazz.getComponentType() == Character.TYPE && !this.charArrayIsSerializedToBytes;
    }

    public String getDefaultDBMSColType(Class clazz) throws Exception {
        if (this.isCharArrayMappedToString(clazz)) {
            clazz = String.class;
        }
        return MethodUtils.getDefaultDBMSColType(clazz, this.databaseType);
    }

    public boolean isValidSQLType(Class clazz) {
        return ClassUtils.isValidSQLType(clazz) || this.isCharArrayMappedToString(clazz);
    }

    private static void p(String string) {
        System.out.println("***<RDBMSBean> " + string);
    }

    public void addSqlShape(SqlShape sqlShape) {
        if (this.sqlShapes == null) {
            this.sqlShapes = new HashMap();
        }
        this.sqlShapes.put(sqlShape.getSqlShapeName(), sqlShape);
    }

    public SqlShape getSqlShape(String string) {
        if (this.sqlShapes == null) {
            return null;
        }
        return (SqlShape)this.sqlShapes.get(string);
    }

    public Map getSqlShapes() {
        return this.sqlShapes;
    }

    public Map getRdbmsBeanMap() {
        return this.rdbmsBeanMap;
    }

    public EjbRelation getEjbRelation(String string) {
        if (this.relationships == null) {
            return null;
        }
        return this.relationships.getEjbRelation(string);
    }

    private static void debug(String string) {
        debugLogger.debug("[RDBMSBean] " + string);
    }

    public Class getBeanInterface() {
        try {
            if (this.generatedBeanInterface == null) {
                this.generatedBeanInterface = Thread.currentThread().getContextClassLoader().loadClass(this.bd.getGeneratedBeanInterfaceName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Could not find generated bean interface name:" + this.bd.getGeneratedBeanInterfaceName());
        }
        return this.generatedBeanInterface;
    }

    public Method getBeanInterfaceMethod(Method method) {
        Class clazz = this.getBeanInterface();
        Method method2 = null;
        try {
            method2 = clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("Could not find bean interface method:" + method.getName());
        }
        return method2;
    }

    public void computeAllTableColumns(Map map) {
        for (String string : this.getTables()) {
            TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.computeVariablesAndColumns(string, null, null, treeMap);
            map.put(string, treeMap);
        }
    }

    public void computeVariablesAndColumns(String string, List list, List list2, Map map) {
        String string2;
        Object object;
        Object object2;
        Map map2 = this.getCmpField2ColumnMap(string);
        if (map2 != null) {
            object2 = map2.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string2 = (String)map2.get(object);
                assert (string2 != null);
                if (list != null) {
                    list.add(object);
                }
                if (list2 != null) {
                    list2.add(string2);
                }
                if (map == null) continue;
                map.put(string2, string2);
            }
        }
        if ((object2 = this.getCmrFields(string)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                for (String string3 : this.getForeignKeyColNames(string2)) {
                    String string4;
                    if (list != null && !list.contains(string4 = this.variableForField(string2, string, string3))) {
                        list.add(string4);
                    }
                    if (list2 != null && !list2.contains(string3)) {
                        list2.add(string3);
                    }
                    if (map == null || map.containsKey(string3)) continue;
                    map.put(string3, string3);
                }
            }
        }
    }

    public boolean isUseInnerJoin() {
        return this.useInnerJoin;
    }

    public void setUseInnerJoin(boolean bl) {
        this.useInnerJoin = bl;
    }

    public String getCategoryCmpField() {
        return this.categoryCmpField;
    }

    public void setCategoryCmpField(String string) {
        this.categoryCmpField = string;
    }
}

