/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSRelation;
import weblogic.ejb.container.persistence.spi.JarDeployment;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;

public final class RDBMSDeployment
implements JarDeployment {
    private Map m_beans = new HashMap();
    private Map m_dependents = new HashMap();
    private Map m_relations = new HashMap();
    private Set fileNames = new HashSet();
    private Set cmpDescriptors = new HashSet();

    public boolean needToReadFile(String string) {
        return !this.fileNames.contains(string);
    }

    public void addFileName(String string) {
        this.fileNames.add(string);
    }

    public RDBMSBean getRDBMSBean(String string) {
        assert (this.m_beans.get(string) != null);
        return (RDBMSBean)this.m_beans.get(string);
    }

    public void addRdbmsBeans(Map map) throws RDBMSException {
        for (RDBMSBean rDBMSBean : map.values()) {
            if (this.m_beans.containsKey(rDBMSBean.getEjbName())) {
                String string = EJBLogger.logDuplicateBeanOrRelationLoggable((String)"weblogic-rdbms-bean", (String)rDBMSBean.getEjbName()).getMessage();
                Iterator iterator = this.fileNames.iterator();
                while (iterator.hasNext()) {
                    string = string + (String)iterator.next();
                    if (!iterator.hasNext()) continue;
                    string = string + ", ";
                }
                string = string + ".";
                throw new RDBMSException(string);
            }
            this.m_beans.put(rDBMSBean.getEjbName(), rDBMSBean);
        }
    }

    public void addRdbmsRelations(Map map) throws RDBMSException {
        for (RDBMSRelation rDBMSRelation : map.values()) {
            if (this.m_relations.containsKey(rDBMSRelation.getName())) {
                String string = EJBLogger.logDuplicateBeanOrRelationLoggable((String)"weblogic-rdbms-relation", (String)rDBMSRelation.getName()).getMessage();
                Iterator iterator = this.fileNames.iterator();
                while (iterator.hasNext()) {
                    string = string + (String)iterator.next();
                    if (!iterator.hasNext()) continue;
                    string = string + ", ";
                }
                string = string + ".";
                throw new RDBMSException(string);
            }
            this.m_relations.put(rDBMSRelation.getName(), rDBMSRelation);
        }
    }

    public Map getRDBMSBeanMap() {
        return this.m_beans;
    }

    public Map getRDBMSRelationMap() {
        return this.m_relations;
    }

    public Map getRDBMSDependentMap() {
        return null;
    }

    public void addDescriptorMBean(WeblogicRdbmsJarBean weblogicRdbmsJarBean) {
        this.cmpDescriptors.add(weblogicRdbmsJarBean);
    }

    public WeblogicRdbmsJarBean getDescriptorMBean(String string) {
        for (WeblogicRdbmsJarBean weblogicRdbmsJarBean : this.cmpDescriptors) {
            WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
            for (int i = 0; i < weblogicRdbmsBeanBeanArray.length; ++i) {
                if (!weblogicRdbmsBeanBeanArray[i].getEjbName().equals(string)) continue;
                return weblogicRdbmsJarBean;
            }
        }
        return null;
    }

    public WeblogicRdbmsBeanBean getWeblogicRDBMSBeanMBean(String string) {
        for (WeblogicRdbmsJarBean weblogicRdbmsJarBean : this.cmpDescriptors) {
            WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
            for (int i = 0; i < weblogicRdbmsBeanBeanArray.length; ++i) {
                if (!weblogicRdbmsBeanBeanArray[i].getEjbName().equals(string)) continue;
                return weblogicRdbmsBeanBeanArray[i];
            }
        }
        return null;
    }

    public WeblogicRdbmsJarBean[] getDescriptorMBeans() {
        return this.cmpDescriptors.toArray(new WeblogicRdbmsJarBean[this.cmpDescriptors.size()]);
    }
}

