/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import weblogic.ejb.container.cmp.rdbms.FieldGroup;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSRelation;
import weblogic.ejb.container.cmp.rdbms.RelationshipCaching;
import weblogic.ejb.container.cmp.rdbms.SqlShape;
import weblogic.ejb.container.cmp.rdbms.finders.RDBMSFinder;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.j2ee.descriptor.wl.AutomaticKeyGenerationBean;
import weblogic.j2ee.descriptor.wl.CachingElementBean;
import weblogic.j2ee.descriptor.wl.ColumnMapBean;
import weblogic.j2ee.descriptor.wl.DatabaseSpecificSqlBean;
import weblogic.j2ee.descriptor.wl.FieldGroupBean;
import weblogic.j2ee.descriptor.wl.FieldMapBean;
import weblogic.j2ee.descriptor.wl.QueryMethodBean;
import weblogic.j2ee.descriptor.wl.RelationshipCachingBean;
import weblogic.j2ee.descriptor.wl.RelationshipRoleMapBean;
import weblogic.j2ee.descriptor.wl.SqlQueryBean;
import weblogic.j2ee.descriptor.wl.SqlShapeBean;
import weblogic.j2ee.descriptor.wl.TableBean;
import weblogic.j2ee.descriptor.wl.TableMapBean;
import weblogic.j2ee.descriptor.wl.WeblogicQueryBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsRelationBean;
import weblogic.j2ee.descriptor.wl.WeblogicRelationshipRoleBean;

public final class RDBMSDeploymentInfo {
    private WeblogicRdbmsJarBean wlJar;
    private Map rdbmsBeanMap = new HashMap();
    private Map rdbmsRelationMap = new HashMap();
    private String fileName;
    protected static EJBComplianceTextFormatter fmt;

    public RDBMSDeploymentInfo(WeblogicRdbmsJarBean weblogicRdbmsJarBean, Map map, String string) throws RDBMSException {
        this.wlJar = weblogicRdbmsJarBean;
        this.fileName = string;
        fmt = new EJBComplianceTextFormatter();
        WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
        for (int i = 0; i < weblogicRdbmsBeanBeanArray.length; ++i) {
            RDBMSBean rDBMSBean;
            CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)map.get(weblogicRdbmsBeanBeanArray[i].getEjbName());
            if (cMPBeanDescriptor == null) continue;
            boolean bl = false;
            if (cMPBeanDescriptor.getPrimaryKeyClassName().equals("java.lang.Object")) {
                rDBMSBean = weblogicRdbmsBeanBeanArray[i].getUnknownPrimaryKeyField();
                if (rDBMSBean == null) {
                    throw new RDBMSException(fmt.UNKNOWN_PK_NEVER_ASSIGNED(weblogicRdbmsBeanBeanArray[i].getEjbName()));
                }
                bl = !cMPBeanDescriptor.getCMFieldNames().contains(rDBMSBean.getCmpField());
                cMPBeanDescriptor.setPrimaryKeyField(rDBMSBean.getCmpField());
            }
            rDBMSBean = new RDBMSBean();
            rDBMSBean.setEjbName(weblogicRdbmsBeanBeanArray[i].getEjbName());
            rDBMSBean.setDataSourceName(weblogicRdbmsBeanBeanArray[i].getDataSourceJndiName());
            this.processTableMaps(weblogicRdbmsBeanBeanArray[i], rDBMSBean);
            this.processFieldGroups(weblogicRdbmsBeanBeanArray[i], rDBMSBean);
            this.processRelationshipCaching(weblogicRdbmsBeanBeanArray[i], rDBMSBean);
            this.processSqlShapes(weblogicRdbmsBeanBeanArray[i], rDBMSBean);
            this.processQueries(weblogicRdbmsBeanBeanArray[i], rDBMSBean, cMPBeanDescriptor);
            rDBMSBean.setDelayInsertUntil(weblogicRdbmsBeanBeanArray[i].getDelayDatabaseInsertUntil());
            rDBMSBean.setUseSelectForUpdate(weblogicRdbmsBeanBeanArray[i].isUseSelectForUpdate());
            rDBMSBean.setLockOrder(weblogicRdbmsBeanBeanArray[i].getLockOrder());
            rDBMSBean.setInstanceLockOrder(weblogicRdbmsBeanBeanArray[i].getInstanceLockOrder());
            rDBMSBean.setCheckExistsOnMethod(weblogicRdbmsBeanBeanArray[i].isCheckExistsOnMethod());
            rDBMSBean.setClusterInvalidationDisabled(weblogicRdbmsBeanBeanArray[i].isClusterInvalidationDisabled());
            rDBMSBean.setUseInnerJoin(weblogicRdbmsBeanBeanArray[i].isUseInnerJoin());
            rDBMSBean.setCategoryCmpField(weblogicRdbmsBeanBeanArray[i].getCategoryCmpField());
            this.processAutoKeyGeneration(weblogicRdbmsBeanBeanArray[i], rDBMSBean);
            if (bl && !rDBMSBean.hasAutoKeyGeneration()) {
                throw new RDBMSException(fmt.UNKNOWN_PK_WITHOUT_AUTO_KEY(weblogicRdbmsBeanBeanArray[i].getEjbName()));
            }
            this.rdbmsBeanMap.put(rDBMSBean.getEjbName(), rDBMSBean);
        }
        this.processRelations(weblogicRdbmsJarBean);
    }

    public RDBMSBean getRDBMSBean(String string) {
        return (RDBMSBean)this.rdbmsBeanMap.get(string);
    }

    public Map getRDBMSBeanMap() {
        return this.rdbmsBeanMap;
    }

    public Map getRDBMSRelationMap() {
        return this.rdbmsRelationMap;
    }

    private void processRelations(WeblogicRdbmsJarBean weblogicRdbmsJarBean) throws RDBMSException {
        WeblogicRdbmsRelationBean[] weblogicRdbmsRelationBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsRelations();
        for (int i = 0; i < weblogicRdbmsRelationBeanArray.length; ++i) {
            RDBMSRelation rDBMSRelation = new RDBMSRelation();
            rDBMSRelation.setName(weblogicRdbmsRelationBeanArray[i].getRelationName());
            rDBMSRelation.setTableName(weblogicRdbmsRelationBeanArray[i].getTableName());
            WeblogicRelationshipRoleBean[] weblogicRelationshipRoleBeanArray = weblogicRdbmsRelationBeanArray[i].getWeblogicRelationshipRoles();
            HashSet<String> hashSet = new HashSet<String>();
            for (int j = 0; j < weblogicRelationshipRoleBeanArray.length; ++j) {
                RDBMSRelation.RDBMSRole rDBMSRole = new RDBMSRelation.RDBMSRole();
                String string = weblogicRelationshipRoleBeanArray[j].getRelationshipRoleName();
                if (!hashSet.add(string)) {
                    throw new RDBMSException(fmt.DuplicateRelationshipRoleNamesDetected(weblogicRdbmsRelationBeanArray[i].getRelationName(), string));
                }
                rDBMSRole.setName(string);
                rDBMSRole.setGroupName(weblogicRelationshipRoleBeanArray[j].getGroupName());
                rDBMSRole.setDBCascadeDelete(weblogicRelationshipRoleBeanArray[j].getDbCascadeDelete() != null);
                rDBMSRole.setQueryCachingEnabled(weblogicRelationshipRoleBeanArray[j].getEnableQueryCaching());
                RelationshipRoleMapBean relationshipRoleMapBean = weblogicRelationshipRoleBeanArray[j].getRelationshipRoleMap();
                if (relationshipRoleMapBean != null) {
                    rDBMSRole.setForeignKeyTableName(relationshipRoleMapBean.getForeignKeyTable());
                    rDBMSRole.setPrimaryKeyTableName(relationshipRoleMapBean.getPrimaryKeyTable());
                    ColumnMapBean[] columnMapBeanArray = relationshipRoleMapBean.getColumnMaps();
                    for (int k = 0; k < columnMapBeanArray.length; ++k) {
                        Map map = rDBMSRole.getColumnMap();
                        map.put(columnMapBeanArray[k].getForeignKeyColumn(), columnMapBeanArray[k].getKeyColumn());
                    }
                }
                if (null == rDBMSRelation.getRole1()) {
                    rDBMSRelation.setRole1(rDBMSRole);
                    continue;
                }
                rDBMSRelation.setRole2(rDBMSRole);
            }
            this.rdbmsRelationMap.put(rDBMSRelation.getName(), rDBMSRelation);
        }
    }

    private void processAutoKeyGeneration(WeblogicRdbmsBeanBean weblogicRdbmsBeanBean, RDBMSBean rDBMSBean) {
        AutomaticKeyGenerationBean automaticKeyGenerationBean = weblogicRdbmsBeanBean.getAutomaticKeyGeneration();
        if (automaticKeyGenerationBean != null) {
            rDBMSBean.setGenKeyType(automaticKeyGenerationBean.getGeneratorType());
            rDBMSBean.setGenKeyGeneratorName(automaticKeyGenerationBean.getGeneratorName());
            rDBMSBean.setGenKeyCacheSize(automaticKeyGenerationBean.getKeyCacheSize());
            rDBMSBean.setSelectFirstSeqKeyBeforeUpdate(automaticKeyGenerationBean.getSelectFirstSequenceKeyBeforeUpdate());
        }
    }

    private void processQueries(WeblogicRdbmsBeanBean weblogicRdbmsBeanBean, RDBMSBean rDBMSBean, CMPBeanDescriptor cMPBeanDescriptor) throws RDBMSException {
        WeblogicQueryBean[] weblogicQueryBeanArray = weblogicRdbmsBeanBean.getWeblogicQueries();
        for (int i = 0; i < weblogicQueryBeanArray.length; ++i) {
            RDBMSFinder rDBMSFinder = new RDBMSFinder();
            QueryMethodBean queryMethodBean = weblogicQueryBeanArray[i].getQueryMethod();
            rDBMSFinder.setFinderName(queryMethodBean.getMethodName());
            rDBMSFinder.setFinderParams(queryMethodBean.getMethodParams().getMethodParams());
            if (weblogicQueryBeanArray[i].getEjbQlQuery() != null) {
                rDBMSFinder.setEjbQlQuery(weblogicQueryBeanArray[i].getEjbQlQuery().getWeblogicQl());
                rDBMSFinder.setGroupName(weblogicQueryBeanArray[i].getEjbQlQuery().getGroupName());
                rDBMSFinder.setCachingName(weblogicQueryBeanArray[i].getEjbQlQuery().getCachingName());
            } else if (weblogicQueryBeanArray[i].getSqlQuery() != null) {
                SqlQueryBean sqlQueryBean = weblogicQueryBeanArray[i].getSqlQuery();
                rDBMSFinder.setSqlShapeName(sqlQueryBean.getSqlShapeName());
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                if (sqlQueryBean.getSql() != null) {
                    hashMap.put(new Integer(0), sqlQueryBean.getSql());
                }
                DatabaseSpecificSqlBean[] databaseSpecificSqlBeanArray = sqlQueryBean.getDatabaseSpecificSqls();
                for (int j = 0; j < databaseSpecificSqlBeanArray.length; ++j) {
                    int n = MethodUtils.dbmsType2int(databaseSpecificSqlBeanArray[j].getDatabaseType());
                    hashMap.put(new Integer(n), databaseSpecificSqlBeanArray[j].getSql());
                }
                rDBMSFinder.setSqlQueries(hashMap);
            }
            rDBMSFinder.setMaxElements(weblogicQueryBeanArray[i].getMaxElements());
            if (cMPBeanDescriptor.getConcurrencyStrategy() == 6) {
                if (weblogicQueryBeanArray[i].isIncludeUpdatesSet()) {
                    rDBMSFinder.setIncludeUpdates(weblogicQueryBeanArray[i].isIncludeUpdates());
                } else {
                    rDBMSFinder.setIncludeUpdates(false);
                }
            } else {
                rDBMSFinder.setIncludeUpdates(weblogicQueryBeanArray[i].isIncludeUpdates());
            }
            rDBMSFinder.setSqlSelectDistinct(weblogicQueryBeanArray[i].isSqlSelectDistinct());
            rDBMSFinder.setQueryCachingEnabled(weblogicQueryBeanArray[i].getEnableQueryCaching());
            rDBMSFinder.setEnableEagerRefresh(weblogicQueryBeanArray[i].getEnableEagerRefresh());
            rDBMSFinder.setIncludeResultCacheHint(weblogicQueryBeanArray[i].isIncludeResultCacheHint());
            if (rDBMSBean.containsRdbmsFinder(rDBMSFinder)) {
                throw new RDBMSException(fmt.DuplicateWeblogicQueryElementsDetected(rDBMSFinder.toString(), rDBMSBean.getEjbName(), this.fileName));
            }
            rDBMSBean.addRdbmsFinder(rDBMSFinder);
        }
    }

    private void processRelationshipCaching(WeblogicRdbmsBeanBean weblogicRdbmsBeanBean, RDBMSBean rDBMSBean) throws RDBMSException {
        HashSet<String> hashSet = new HashSet<String>();
        RelationshipCachingBean[] relationshipCachingBeanArray = weblogicRdbmsBeanBean.getRelationshipCachings();
        for (int i = 0; i < relationshipCachingBeanArray.length; ++i) {
            RelationshipCaching relationshipCaching = new RelationshipCaching();
            if (!hashSet.add(relationshipCachingBeanArray[i].getCachingName())) {
                throw new RDBMSException("Duplicate caching name '" + relationshipCachingBeanArray[i].getCachingName() + "' found in RDBMS CMP deployment descriptor '" + this.fileName + "' while reading information for '" + weblogicRdbmsBeanBean.getEjbName() + "'.");
            }
            relationshipCaching.setCachingName(relationshipCachingBeanArray[i].getCachingName());
            CachingElementBean[] cachingElementBeanArray = relationshipCachingBeanArray[i].getCachingElements();
            for (int j = 0; j < cachingElementBeanArray.length; ++j) {
                relationshipCaching.addCachingElement(this.processCachingElement(cachingElementBeanArray[j]));
            }
            rDBMSBean.addRelationshipCaching(relationshipCaching);
        }
    }

    private RelationshipCaching.CachingElement processCachingElement(CachingElementBean cachingElementBean) {
        RelationshipCaching.CachingElement cachingElement = new RelationshipCaching.CachingElement();
        cachingElement.setCmrField(cachingElementBean.getCmrField());
        cachingElement.setGroupName(cachingElementBean.getGroupName());
        if (cachingElementBean.getGroupName() == null || cachingElementBean.getGroupName().length() == 0) {
            cachingElement.setGroupName("defaultGroup");
        }
        CachingElementBean[] cachingElementBeanArray = cachingElementBean.getCachingElements();
        for (int i = 0; i < cachingElementBeanArray.length; ++i) {
            cachingElement.addCachingElement(this.processCachingElement(cachingElementBeanArray[i]));
        }
        return cachingElement;
    }

    private void processSqlShapes(WeblogicRdbmsBeanBean weblogicRdbmsBeanBean, RDBMSBean rDBMSBean) throws RDBMSException {
        HashSet<String> hashSet = new HashSet<String>();
        SqlShapeBean[] sqlShapeBeanArray = weblogicRdbmsBeanBean.getSqlShapes();
        for (int i = 0; i < sqlShapeBeanArray.length; ++i) {
            SqlShape sqlShape = new SqlShape();
            if (!hashSet.add(sqlShapeBeanArray[i].getSqlShapeName())) {
                throw new RDBMSException(fmt.DUPLICATE_SQL_CACHING_NAME(weblogicRdbmsBeanBean.getEjbName(), this.fileName, sqlShapeBeanArray[i].getSqlShapeName()));
            }
            sqlShape.setSqlShapeName(sqlShapeBeanArray[i].getSqlShapeName());
            TableBean[] tableBeanArray = sqlShapeBeanArray[i].getTables();
            for (int j = 0; j < tableBeanArray.length; ++j) {
                SqlShape.Table table = new SqlShape.Table();
                table.setName(tableBeanArray[j].getTableName());
                List<Object> list = Arrays.asList((Object[])tableBeanArray[j].getDbmsColumns());
                table.setColumns(list);
                if (tableBeanArray[j].getEjbRelationshipRoleName() != null) {
                    table.addEjbRelationshipRoleName(tableBeanArray[j].getEjbRelationshipRoleName());
                }
                sqlShape.addTable(table);
            }
            sqlShape.setEjbRelationNames(sqlShapeBeanArray[i].getEjbRelationNames());
            sqlShape.setPassThroughColumns(sqlShapeBeanArray[i].getPassThroughColumns());
            rDBMSBean.addSqlShape(sqlShape);
        }
    }

    private void processFieldGroups(WeblogicRdbmsBeanBean weblogicRdbmsBeanBean, RDBMSBean rDBMSBean) throws RDBMSException {
        HashSet<String> hashSet = new HashSet<String>();
        FieldGroupBean[] fieldGroupBeanArray = weblogicRdbmsBeanBean.getFieldGroups();
        for (int i = 0; i < fieldGroupBeanArray.length; ++i) {
            if (!hashSet.add(fieldGroupBeanArray[i].getGroupName())) {
                throw new RDBMSException("Duplicate group name '" + fieldGroupBeanArray[i].getGroupName() + "' found in RDBMS CMP deployment descriptor '" + this.fileName + "' while reading information for '" + weblogicRdbmsBeanBean.getEjbName() + "'.");
            }
            FieldGroup fieldGroup = new FieldGroup();
            fieldGroup.setName(fieldGroupBeanArray[i].getGroupName());
            String[] stringArray = fieldGroupBeanArray[i].getCmpFields();
            for (int j = 0; j < stringArray.length; ++j) {
                fieldGroup.addCmpField(stringArray[j]);
            }
            String[] stringArray2 = fieldGroupBeanArray[i].getCmrFields();
            for (int j = 0; j < stringArray2.length; ++j) {
                fieldGroup.addCmrField(stringArray2[j]);
            }
            rDBMSBean.addFieldGroup(fieldGroup);
        }
    }

    private void processTableMaps(WeblogicRdbmsBeanBean weblogicRdbmsBeanBean, RDBMSBean rDBMSBean) throws RDBMSException {
        TableMapBean[] tableMapBeanArray = weblogicRdbmsBeanBean.getTableMaps();
        for (int i = 0; i < tableMapBeanArray.length; ++i) {
            String string = tableMapBeanArray[i].getTableName();
            if (rDBMSBean.hasTable(string)) {
                throw new RDBMSException("In EJB, " + weblogicRdbmsBeanBean.getEjbName() + ", an attempt was made to specify a <table-name> of, " + string + ", in multiple <table-map> elements. " + "Each <table-map> element must specify a unique <table-name> " + "and should contain all <field-map> elements for that table.");
            }
            rDBMSBean.addTable(string);
            FieldMapBean[] fieldMapBeanArray = tableMapBeanArray[i].getFieldMaps();
            for (int j = 0; j < fieldMapBeanArray.length; ++j) {
                rDBMSBean.addTableFieldColumnMapping(string, fieldMapBeanArray[j].getCmpField(), fieldMapBeanArray[j].getDbmsColumn());
                if (fieldMapBeanArray[j].getDbmsColumnType() != null) {
                    rDBMSBean.addFieldColumnTypeMapping(fieldMapBeanArray[j].getCmpField(), fieldMapBeanArray[j].getDbmsColumnType());
                }
                if (!fieldMapBeanArray[j].isDbmsDefaultValue()) continue;
                rDBMSBean.addDbmsDefaultValueField(fieldMapBeanArray[j].getCmpField());
            }
            if (tableMapBeanArray[i].getVerifyRows() != null) {
                rDBMSBean.setVerifyRows(string, tableMapBeanArray[i].getVerifyRows());
            }
            if (tableMapBeanArray[i].getVerifyColumns() != null) {
                rDBMSBean.setVerifyColumns(string, tableMapBeanArray[i].getVerifyColumns());
            }
            if (tableMapBeanArray[i].getOptimisticColumn() != null) {
                rDBMSBean.setOptimisticColumn(string, tableMapBeanArray[i].getOptimisticColumn());
            }
            rDBMSBean.setTriggerUpdatesOptimisticColumn(string, tableMapBeanArray[i].isTriggerUpdatesOptimisticColumn());
            rDBMSBean.setVersionColumnInitialValue(string, tableMapBeanArray[i].getVersionColumnInitialValue());
        }
    }
}

