/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import weblogic.dbeans.ConversationImpl;
import weblogic.dbeans.DataBeansException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.OptimisticConcurrencyException;
import weblogic.ejb.PreparedQuery;
import weblogic.ejb.WLQueryProperties;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cache.MultiValueQueryCacheElement;
import weblogic.ejb.container.cache.QueryCacheElement;
import weblogic.ejb.container.cache.QueryCacheKey;
import weblogic.ejb.container.cmp.rdbms.DynamicEJBQLArgumentWrapper;
import weblogic.ejb.container.cmp.rdbms.FieldGroup;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSObjectInputStream;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.SqlShape;
import weblogic.ejb.container.cmp.rdbms.finders.EjbqlFinder;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.cmp.rdbms.finders.ParamNode;
import weblogic.ejb.container.cmp.rdbms.finders.SqlFinder;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.WLCMPPersistenceManager;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.EntityEJBContextImpl;
import weblogic.ejb.container.internal.QueryCachingHandler;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.manager.TTLManager;
import weblogic.ejb.container.persistence.RSInfoImpl;
import weblogic.ejb.container.persistence.spi.CMPBean;
import weblogic.ejb.container.persistence.spi.CMPBeanManager;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.container.persistence.spi.RSInfo;
import weblogic.ejb.container.utils.TableVerifier;
import weblogic.ejb.container.utils.TableVerifierMetaData;
import weblogic.ejb.container.utils.TableVerifierSqlQuery;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.ejb20.cmp.rdbms.finders.InvalidFinderException;
import weblogic.ejb20.persistence.spi.PersistenceRuntimeException;
import weblogic.jdbc.common.internal.DataSourceMetaData;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.RowSetFactory;
import weblogic.jdbc.rowset.WLCachedRowSet;
import weblogic.logging.Loggable;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArraySet;
import weblogic.utils.collections.ConcurrentHashMap;

public final class RDBMSPersistenceManager
implements PersistenceManager,
WLCMPPersistenceManager {
    private static final DebugLogger deploymentLogger = EJBDebugService.cmpDeploymentLogger;
    private static final DebugLogger runtimeLogger = EJBDebugService.cmpRuntimeLogger;
    private static final String EOL = "\n";
    private TableVerifier verifier;
    private RDBMSBean rbean = null;
    private int databaseType = 0;
    private Map variable2SQLType = new HashMap();
    private Map variable2nullable = new HashMap();
    private Map fkFieldNullableMap = new HashMap();
    private boolean fkColsNullable = true;
    private String[] snapshotStrings = null;
    private String[] nullSnapshotStrings = null;
    private Context ctx = null;
    private DataSource ds = null;
    private ClassLoader classLoader = null;
    private BaseEntityManager beanManager = null;
    private short genKeyType;
    private String genKeyWLGeneratorQuery = null;
    private String genKeyWLGeneratorUpdatePrefix = null;
    private String genKeyWLGeneratorUpdate = null;
    private String genKeyGeneratorName = null;
    private Map finderMap;
    private int genKeyCacheSize = 1;
    private int genKeyCurrCacheSize = 0;
    private int genKeyCurrValueInt = 0;
    private long genKeyCurrValueLong = 0L;
    private short genKeyPKFieldClassType;
    private boolean enableBatchOperations = true;
    private boolean orderDatabaseOperations = true;
    private boolean isOptimistic = false;
    private boolean findersReturnNulls = true;
    private int transactionTimeoutMS = 0;
    private String dataSourceName = null;
    private String ejbName = null;
    private boolean selectForUpdateSupported = false;
    private boolean selectFirstSeqKeyBeforeUpdate = false;
    private TransactionManager tm = null;
    private String[] verifyText = null;
    private String[] verifyTextWithXLock = null;
    private int[] verifyCount = null;
    private int[] verifyCur = null;
    private static final String ORACLE_JDBC_DRIVER_NAME = "Oracle JDBC driver";
    private String databaseProductName = "";
    private String databaseProductVersion = "";
    private String driverName = "";
    private String driverVersion = "";
    private int driverMajorVersion = -1;
    private int driverMinorVersion = -1;
    private boolean initialized = false;
    private static final byte[] byteArray = new byte[0];
    private static final char[] charArray = new char[0];

    public void setup(BeanManager beanManager) throws Exception {
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("RDBMSPersistenceManager.setup");
        }
        if (this.initialized) {
            return;
        }
        assert (this.rbean != null) : "rbean != null failed";
        this.beanManager = (BaseEntityManager)beanManager;
        this.classLoader = this.beanManager.getBeanInfo().getClassLoader();
        this.verifier = "MetaData".equalsIgnoreCase(this.getValidateDbSchemaWith()) ? new TableVerifierMetaData() : new TableVerifierSqlQuery();
        try {
            this.ctx = new InitialContext();
        }
        catch (NamingException namingException) {
            throw new AssertionError((Throwable)namingException);
        }
        this.enableBatchOperations = this.rbean.getEnableBatchOperations();
        this.orderDatabaseOperations = this.rbean.getOrderDatabaseOperations();
        this.isOptimistic = this.rbean().getCMPBeanDescriptor().isOptimistic();
        this.transactionTimeoutMS = this.rbean().getCMPBeanDescriptor().getTransactionTimeoutMS();
        this.dataSourceName = this.rbean().getDataSourceName();
        this.ejbName = this.rbean().getEjbName();
        this.databaseType = this.rbean.getDatabaseType();
        this.findersReturnNulls = this.rbean.isFindersReturnNulls();
        try {
            this.ds = (DataSource)this.ctx.lookup("java:/app/jdbc/" + this.dataSourceName);
        }
        catch (NamingException namingException) {
            try {
                this.ds = (DataSource)this.ctx.lookup(this.dataSourceName);
            }
            catch (NamingException namingException2) {
                Loggable loggable = EJBLogger.logDataSourceNotFoundLoggable((String)this.dataSourceName);
                throw new WLDeploymentException(loggable.getMessage());
            }
        }
        this.verifyTXDataSource();
        this.tm = TxHelper.getTransactionManager();
        this.genKeyType = this.rbean().getGenKeyType();
        this.verifyDatabaseType();
        this.verifyTablesExist();
        this.verifyBatchUpdatesSupported();
        this.selectForUpdateSupported = this.verifySelectForUpdateSupported();
        if (this.rbean.getUseSelectForUpdate() && !this.selectForUpdateSupported) {
            Loggable loggable = EJBLogger.logselectForUpdateNotSupportedLoggable((String)this.ejbName);
            throw new WLDeploymentException(loggable.getMessage());
        }
        this.populateSnapShotStrings();
        this.populateFieldSQLTypeMap();
        this.populateVerifyRows();
        this.genKeySetup();
        this.sqlFinderSetup();
        this.initialized = true;
        this.initializeDBProductAndDriverInfo();
    }

    private void sqlFinderSetup() throws WLDeploymentException {
        Iterator iterator = this.rbean.getFinders();
        while (iterator.hasNext()) {
            Finder finder = (Finder)iterator.next();
            if (this.finderMap == null) {
                this.finderMap = new ConcurrentHashMap();
            }
            if (!(finder instanceof SqlFinder)) continue;
            SqlFinder sqlFinder = (SqlFinder)finder;
            sqlFinder.setup(this.databaseType);
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment("EJB-" + this.rbean.getEjbName() + ": add a method to map- " + sqlFinder.getName());
                RDBMSPersistenceManager.debugDeployment("method- " + sqlFinder.getMethod());
            }
            if (sqlFinder.isSelect()) {
                this.finderMap.put(this.rbean.getBeanInterfaceMethod(sqlFinder.getMethod()), sqlFinder);
                continue;
            }
            this.finderMap.put(sqlFinder.getMethod(), sqlFinder);
            if (sqlFinder.getSecondMethod() == null) continue;
            this.finderMap.put(sqlFinder.getSecondMethod(), sqlFinder);
        }
    }

    public boolean isFindersReturnNulls() {
        return this.findersReturnNulls;
    }

    public Object findByPrimaryKey(EntityBean entityBean, Method method, Object object) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.findByPrimaryKey");
        }
        Debug.assertion((entityBean != null ? 1 : 0) != 0);
        Debug.assertion((method != null ? 1 : 0) != 0);
        Debug.assertion((object != null ? 1 : 0) != 0);
        Object[] objectArray = new Object[]{object};
        try {
            return method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public EntityBean findByPrimaryKeyLoadBean(EntityBean entityBean, Method method, Object object) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.findByPrimaryKeyLoadBean");
        }
        try {
            Object[] objectArray = new Object[]{object};
            return (EntityBean)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Object scalarFinder(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.scalarFinder");
        }
        try {
            SqlFinder sqlFinder;
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("---------------------------searching for method- " + method);
            }
            if ((sqlFinder = (SqlFinder)this.finderMap.get(method)) != null) {
                return this.processSqlFinder(sqlFinder, objectArray, ((WLEnterpriseBean)entityBean).__WL_getIsLocal());
            }
            return method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Map scalarFinderLoadBean(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.scalarFinderLoadBean");
        }
        try {
            return (Map)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Enumeration enumFinder(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.enumFinder");
        }
        try {
            return (Enumeration)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Collection collectionFinder(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.collectionFinder");
        }
        try {
            SqlFinder sqlFinder;
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("---------------------------searching for method- " + method);
            }
            if ((sqlFinder = (SqlFinder)this.finderMap.get(method)) != null) {
                return (Collection)this.processSqlFinder(sqlFinder, objectArray, ((WLEnterpriseBean)entityBean).__WL_getIsLocal());
            }
            return (Collection)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Object dynamicSqlQuery(String string, Object[] objectArray, WLQueryProperties wLQueryProperties, boolean bl, Class clazz, ConversationImpl conversationImpl) {
        SqlFinder sqlFinder = null;
        String string2 = null;
        int n = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        try {
            string2 = wLQueryProperties.getSqlShapeName();
            if (string2 != null && this.rbean.getSqlShape(string2) == null) {
                String string3 = "";
                if (this.rbean.getSqlShapes() != null) {
                    Iterator iterator = this.rbean.getSqlShapes().values().iterator();
                    while (iterator.hasNext()) {
                        SqlShape sqlShape = (SqlShape)iterator.next();
                        string3 = string3 + sqlShape.getSqlShapeName();
                        if (!iterator.hasNext()) continue;
                        string3 = string3 + ", ";
                    }
                }
                throw new EJBException(EJBLogger.logSqlShapeDoesNotExist((String)this.rbean.getEjbName(), (String)"Dynamic SQL Query", (String)string2, (String)string3));
            }
        }
        catch (FinderException finderException) {
            throw new AssertionError("should never get here");
        }
        try {
            n = wLQueryProperties.getMaxElements();
        }
        catch (FinderException finderException) {
            throw new AssertionError("should never get here");
        }
        try {
            bl2 = wLQueryProperties.getIncludeUpdates();
        }
        catch (FinderException finderException) {
            throw new AssertionError("should never get here");
        }
        try {
            if (bl && wLQueryProperties.isResultTypeRemote()) {
                bl = false;
            }
        }
        catch (FinderException finderException) {
            throw new AssertionError("should never get here");
        }
        try {
            bl3 = wLQueryProperties.getEnableQueryCaching();
        }
        catch (FinderException finderException) {
            throw new AssertionError("should never get here");
        }
        try {
            assert (this.rbean != null);
            sqlFinder = new SqlFinder("execute", null, string2, this.rbean, conversationImpl);
            sqlFinder.setReturnClassType(clazz);
            sqlFinder.setMaxElements(n);
            sqlFinder.setIncludeUpdates(bl2);
        }
        catch (InvalidFinderException invalidFinderException) {
            throw new DataBeansException(invalidFinderException);
        }
        try {
            sqlFinder.setupDynamic(string);
        }
        catch (WLDeploymentException wLDeploymentException) {
            throw new DataBeansException(wLDeploymentException);
        }
        sqlFinder.setQueryCachingEnabled(bl3);
        try {
            return this.processSqlFinder(sqlFinder, objectArray, bl);
        }
        catch (FinderException finderException) {
            throw new DataBeansException(finderException);
        }
    }

    public Object processSqlFinder(Method method, Object[] objectArray, boolean bl) throws FinderException {
        SqlFinder sqlFinder = (SqlFinder)this.finderMap.get(method);
        if (sqlFinder != null) {
            return this.processSqlFinder(sqlFinder, objectArray, bl);
        }
        throw new AssertionError("no SqlFinder found for method:" + method);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object processSqlFinder(SqlFinder var1_1, Object[] var2_2, boolean var3_3) throws FinderException {
        block56: {
            block55: {
                var4_4 = null;
                var5_5 = null;
                var6_6 = null;
                if (var1_1.getIncludeUpdates()) {
                    this.flushModifiedBeans();
                }
                try {
                    var4_4 = this.getConnection();
                    if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " got connection.");
                    }
                }
                catch (Exception var7_7) {
                    this.releaseResources(var4_4, var5_5, var6_6);
                    var8_9 = EJBLogger.logDuringFindCannotGetConnectionLoggable((String)var1_1.getName(), (String)var7_7.toString(), (String)RDBMSUtils.throwable2StackTrace(var7_7));
                    throw new FinderException(var8_9.getMessage());
                }
                var7_8 = new String[1];
                try {
                    var5_5 = this.getStatement(var4_4, var1_1, var7_8);
                }
                catch (Exception var8_10) {
                    this.releaseResources(var4_4, var5_5, var6_6);
                    var9_14 = EJBLogger.logExceptionWhilePrepareingQueryLoggable((String)var1_1.getName(), (String)var7_8[0], (String)var8_10.toString(), (String)RDBMSUtils.throwable2StackTrace(var8_10));
                    throw new FinderException(var9_14.getMessage());
                }
                try {
                    this.setParameters(var5_5, var1_1, var2_2);
                }
                catch (Exception var8_11) {
                    this.releaseResources(var4_4, var5_5, var6_6);
                    var9_15 = EJBLogger.logErrorSetQueryParametorLoggable((String)var1_1.getName(), (String)var7_8[0], (String)var8_11.toString(), (String)RDBMSUtils.throwable2StackTrace(var8_11));
                    throw new FinderException(var9_15.getMessage());
                }
                try {
                    var6_6 = this.getResultSet(var5_5, var1_1);
                }
                catch (Exception var8_12) {
                    this.releaseResources(var4_4, var5_5, var6_6);
                    var9_16 = EJBLogger.logErrorExecuteQueryLoggable((String)var1_1.getName(), (String)var8_12.toString(), (String)RDBMSUtils.throwable2StackTrace(var8_12));
                    throw new FinderException(var9_16.getMessage());
                }
                var8_13 = null;
                var9_17 = null;
                var10_18 = null;
                var11_19 = new ArrayList<Object[]>();
                try {
                    try {
                        var1_1.initializeMapping(var6_6);
                        var12_20 = null;
                        var12_20 = var1_1.isQueryCachingEnabled() != false ? var1_1.getQueryCachingHandler(var2_2, (TTLManager)this.getBeanManager()) : var1_1.getQueryCachingHandler(null, null);
                        if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " mappings have been initialized.");
                        }
                        if (Collection.class.isAssignableFrom(var1_1.getReturnClassType())) {
                            if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " is returning a collection.");
                            }
                            var9_17 = new ArrayList<Object>();
                        } else if (ResultSet.class.isAssignableFrom(var1_1.getReturnClassType())) {
                            if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " is returning a ResultSet.");
                            }
                            var13_24 = RowSetFactory.newInstance();
                            var10_18 = var13_24.newCachedRowSet();
                            var14_25 = new CachedRowSetMetaData();
                            var14_25.setColumnCount(var1_1.getResultColumnCount());
                            var10_18.populate((ResultSetMetaData)var14_25);
                            var10_18.moveToInsertRow();
                        }
                        while (var6_6.next() && !var1_1.maxElementsReached(var9_17, var10_18)) {
                            if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                RDBMSPersistenceManager.debugRuntime(var1_1.getName() + "result set contains data");
                            }
                            var13_24 = var1_1.getBeans();
                            var14_25 = var1_1.getPrimaryKey();
                            try {
                                this.processSQLRow(var6_6, var1_1, var13_24, var14_25);
                                if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                    RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " processed row successfully.");
                                }
                            }
                            catch (Exception var15_27) {
                                var1_1.releaseBeans(var13_24, 0);
                                throw var15_27;
                            }
                            var15_26 = null;
                            var16_28 = null;
                            var17_29 = null;
                            var18_30 = null;
                            for (var19_31 = 0; var19_31 < var13_24.length; ++var19_31) {
                                var20_32 = null;
                                var21_33 = var1_1.getManager(var19_31);
                                if (var21_33 != null) {
                                    var22_34 = (CMPBean)var13_24[var19_31];
                                    var23_35 = var14_25[var19_31];
                                    var24_36 = new RSInfoImpl(var22_34, var23_35);
                                    var25_37 = null;
                                    try {
                                        if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                            RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " caching bean " + var23_35 + ".");
                                        }
                                        if ((var25_37 = (CMPBean)var21_33.getBeanFromRS(var23_35, var24_36)) != var22_34) {
                                            if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                                RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " returning bean " + var23_35 + " to the pool.");
                                            }
                                            var21_33.releaseBeanToPool((EntityBean)var22_34);
                                            var13_24[var19_31] = var25_37;
                                        }
                                    }
                                    catch (Exception var26_39) {
                                        var1_1.releaseBeans(var13_24, var19_31);
                                        throw var26_39;
                                    }
                                    try {
                                        var20_32 = var21_33.isBeanClassAbstract() != false ? var21_33.finderGetEoFromBeanOrPk((EntityBean)var25_37, var23_35, var3_3) : var25_37;
                                        if (!var1_1.isQueryCachingEnabled()) ** GOTO lbl115
                                        var26_38 = (TTLManager)var21_33;
                                        var27_41 = new QueryCacheElement(var23_35, var26_38);
                                        var27_41.setIncludable(false);
                                        var12_20.addQueryCachingEntry(var26_38, var27_41);
                                        var17_29 = new QueryCacheElement(var23_35, var26_38);
                                        var17_29.setInvalidatable(false);
                                    }
                                    catch (Exception var26_40) {
                                        var1_1.releaseBeans(var13_24, var19_31 + 1);
                                        throw var26_40;
                                    }
                                } else {
                                    var20_32 = var13_24[var19_31];
                                    if (var1_1.isQueryCachingEnabled()) {
                                        var17_29 = new QueryCacheElement(var13_24[var19_31]);
                                    }
                                }
lbl115:
                                // 5 sources

                                if (var9_17 != null) {
                                    if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                        RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " adding to collection result...." + var20_32);
                                    }
                                    if (var13_24.length > 1 && !var1_1.usesRelationshipCaching()) {
                                        if (var19_31 == 0) {
                                            var15_26 = new Object[var13_24.length];
                                            var9_17.add(var15_26);
                                            if (var1_1.isQueryCachingEnabled()) {
                                                var16_28 = new QueryCacheElement[var13_24.length];
                                                var18_30 = new MultiValueQueryCacheElement(var16_28);
                                            }
                                        }
                                        var15_26[var19_31] = var20_32;
                                        if (!var1_1.isQueryCachingEnabled()) continue;
                                        var16_28[var19_31] = var17_29;
                                        continue;
                                    }
                                    if (var19_31 != 0) continue;
                                    var9_17.add(var20_32);
                                    if (!var1_1.isQueryCachingEnabled()) continue;
                                    var18_30 = var17_29;
                                    continue;
                                }
                                if (var10_18 != null) {
                                    if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                        RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " adding to ResultSet result. " + var20_32);
                                    }
                                    if (var19_31 != 0 && var1_1.usesRelationshipCaching()) continue;
                                    var10_18.updateObject(var19_31 + 1, var20_32);
                                    continue;
                                }
                                if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                    RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " adding to single result.");
                                }
                                if (var19_31 == 0) {
                                    if (var8_13 != null && (var21_33 == null ? var8_13.equals(var20_32) == false : var8_13 != var20_32)) {
                                        throw new FinderException("Error in '" + var1_1.getName() + "'.  The finder returns a single value, " + "but multiple rows were returned by the query " + "from the database (" + var7_8[0] + ").");
                                    }
                                    var8_13 = var20_32;
                                    if (!var1_1.isQueryCachingEnabled()) continue;
                                    var18_30 = var17_29;
                                    continue;
                                }
                                if (var1_1.usesRelationshipCaching()) continue;
                                throw new FinderException("Error in '" + var1_1.getName() + "'.  The finder returns a single value, " + "but multiple values are selected for each row " + "in the database.  The selected values must be mapped " + "to a single bean or relationship caching must be " + "used.");
                            }
                            var11_19.add(var14_25);
                            if (var1_1.isQueryCachingEnabled()) {
                                var12_20.addQueryCachingEntry((TTLManager)this.getBeanManager(), var18_30);
                            }
                            if (var10_18 != null) {
                                if (RDBMSPersistenceManager.runtimeLogger.isDebugEnabled()) {
                                    RDBMSPersistenceManager.debugRuntime(var1_1.getName() + " adding row to ResultSet result.");
                                }
                                var10_18.insertRow();
                            }
                            this.processRelationshipCaching(var1_1, var13_24, var12_20);
                        }
                        this.unpin(var11_19, var1_1);
                        var12_20.putInQueryCache();
                        if (var9_17 != null) {
                            var13_24 = var9_17;
                            var29_42 = null;
                            this.releaseResources(var4_4, var5_5, var6_6);
                            return var13_24;
                        }
                        if (var10_18 != null) {
                            var10_18.moveToCurrentRow();
                            var13_24 = var10_18;
                            break block55;
                        }
                        if (var11_19.size() == 0) {
                            throw new ObjectNotFoundException("Bean not found in " + var1_1.getName() + ".");
                        }
                        var13_24 = var8_13;
                        break block56;
                    }
                    catch (SQLException var12_21) {
                        throw new FinderException("Exception in finder " + var1_1.getName() + " while using " + "result set: '" + var6_6 + "'" + "\n" + var12_21.toString() + "\n" + RDBMSUtils.throwable2StackTrace(var12_21));
                    }
                    catch (ObjectNotFoundException var12_22) {
                        throw var12_22;
                    }
                    catch (Exception var12_23) {
                        throw new FinderException("Exception executing finder " + var1_1.getName() + " : " + "\n" + var12_23.toString() + "\n" + RDBMSUtils.throwable2StackTrace(var12_23));
                    }
                }
                catch (Throwable var28_46) {
                    var29_45 = null;
                    this.releaseResources(var4_4, var5_5, var6_6);
                    throw var28_46;
                }
            }
            var29_43 = null;
            this.releaseResources(var4_4, var5_5, var6_6);
            return var13_24;
        }
        var29_44 = null;
        this.releaseResources(var4_4, var5_5, var6_6);
        return var13_24;
    }

    private void unpin(Collection collection, SqlFinder sqlFinder) {
        int n = sqlFinder.getColumnCount();
        Object object = EJBRuntimeUtils.getInvokeTxOrThread();
        for (Object[] objectArray : collection) {
            for (int i = 0; i < objectArray.length; ++i) {
                BaseEntityManager baseEntityManager = sqlFinder.getManager(i);
                if (baseEntityManager == null) continue;
                baseEntityManager.unpin(object, objectArray[i]);
            }
        }
    }

    private ResultSet getResultSet(PreparedStatement preparedStatement, SqlFinder sqlFinder) throws SQLException {
        ResultSet resultSet = null;
        if (sqlFinder.usesStoredFunction()) {
            CallableStatement callableStatement = (CallableStatement)preparedStatement;
            callableStatement.execute();
            resultSet = (ResultSet)callableStatement.getObject(1);
        } else {
            resultSet = preparedStatement.executeQuery();
        }
        return resultSet;
    }

    private PreparedStatement getStatement(Connection connection, SqlFinder sqlFinder, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement = null;
        int n = this.getSelectForUpdateValue();
        stringArray[0] = sqlFinder.getQuery(n);
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " got query: " + stringArray[0]);
        }
        preparedStatement = sqlFinder.usesStoredProcedure() || sqlFinder.usesStoredFunction() ? connection.prepareCall(stringArray[0]) : connection.prepareStatement(stringArray[0]);
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " got PreparedStatement.");
        }
        return preparedStatement;
    }

    private void setParameters(PreparedStatement preparedStatement, SqlFinder sqlFinder, Object[] objectArray) throws SQLException {
        int n = 1;
        if (sqlFinder.usesStoredFunction()) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " setting out parameter for stored function.");
            }
            CallableStatement callableStatement = (CallableStatement)preparedStatement;
            switch (this.databaseType) {
                case 1: {
                    if (runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " setting output parameter for Oracle.");
                    }
                    callableStatement.registerOutParameter(n, -10);
                    break;
                }
                default: {
                    throw new EJBException("Attempt to use stored function in '" + sqlFinder.getName() + "'.  Stored functions are only supported for Oracle.");
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < sqlFinder.getNumQueryParams()) {
            int n3 = sqlFinder.getMethodIndex(n2);
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("------------------------------------" + sqlFinder.getName() + ": query parameter" + n + ": method parameter" + n3 + " bound with value :" + objectArray[n3]);
            }
            if (objectArray[n3] != null && objectArray[n3].getClass().equals(Character.class)) {
                preparedStatement.setString(n, objectArray[n3].toString());
            } else {
                preparedStatement.setObject(n, objectArray[n3]);
            }
            ++n2;
            ++n;
        }
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " done setting input parameters");
        }
    }

    private void processSQLRow(ResultSet resultSet, SqlFinder sqlFinder, Object[] objectArray, Object[] objectArray2) throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " processing row: column count-" + sqlFinder.getColumnCount());
        }
        for (int i = 0; i < sqlFinder.getColumnCount(); ++i) {
            int n = sqlFinder.getResultIndex(i);
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " results index- " + n);
            }
            Object object = this.processSqlColumn(sqlFinder, resultSet, i, (CMPBean)objectArray[n]);
            if (objectArray[n] == null) {
                objectArray[n] = object;
                continue;
            }
            if (!sqlFinder.setsPrimaryKey(i)) continue;
            if (objectArray2[n] == null) {
                objectArray2[n] = object;
                continue;
            }
            Field field = sqlFinder.getPrimaryKeyField(i);
            field.set(objectArray2[n], object);
            Debug.assertion((object != null ? 1 : 0) != 0);
        }
    }

    private void processRelationshipCaching(SqlFinder sqlFinder, Object[] objectArray, QueryCachingHandler queryCachingHandler) {
        if (!sqlFinder.usesRelationshipCaching()) {
            return;
        }
        int n = sqlFinder.getRelationCount();
        int[] nArray = sqlFinder.getRelationIndex1();
        int[] nArray2 = sqlFinder.getRelationIndex2();
        Method[] methodArray = sqlFinder.getRelationMethod1();
        Method[] methodArray2 = sqlFinder.getRelationMethod2();
        for (int i = 0; i < n; ++i) {
            QueryCacheElement queryCacheElement;
            QueryCacheKey queryCacheKey;
            Object object;
            TTLManager tTLManager;
            Object[] objectArray2;
            String string;
            Object object2 = objectArray[nArray[i]];
            Object object3 = objectArray[nArray2[i]];
            Object object4 = object2;
            Object object5 = object3;
            RDBMSBean rDBMSBean = sqlFinder.getRDBMSBean(nArray[i]);
            RDBMSBean rDBMSBean2 = sqlFinder.getRDBMSBean(nArray2[i]);
            if (rDBMSBean2.getCMPBeanDescriptor().isBeanClassAbstract()) {
                object5 = ((EntityEJBContextImpl)((CMPBean)object3).__WL_getEntityContext()).__WL_getEJBLocalObject();
            }
            try {
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime("------------------setting relationship between " + rDBMSBean.getEjbName() + " and " + rDBMSBean2.getEjbName());
                    RDBMSPersistenceManager.debugRuntime("------------------ primary key " + ((CMPBean)object2).__WL_getPrimaryKey());
                    RDBMSPersistenceManager.debugRuntime("------------------ primary key " + ((CMPBean)object3).__WL_getPrimaryKey());
                }
                methodArray[i].invoke(object2, object5);
            }
            catch (Exception exception) {
                throw new AssertionError("exception while invoking method-" + DDUtils.getMethodSignature(methodArray[i]), (Throwable)exception);
            }
            if (rDBMSBean.getCMPBeanDescriptor().isBeanClassAbstract()) {
                object4 = ((EntityEJBContextImpl)((CMPBean)object2).__WL_getEntityContext()).__WL_getEJBLocalObject();
            }
            try {
                methodArray2[i].invoke(object3, object4);
            }
            catch (Exception exception) {
                throw new AssertionError("exception while invoking method-" + DDUtils.getMethodSignature(methodArray2[i]), (Throwable)exception);
            }
            if (sqlFinder.getCmrFieldFinderMethodName1(i) != null) {
                string = sqlFinder.getCmrFieldFinderMethodName1(i);
                objectArray2 = new Object[]{((CMPBean)object2).__WL_getPrimaryKey()};
                tTLManager = (TTLManager)sqlFinder.getManager(nArray2[i]);
                object = ((CMPBean)object3).__WL_getPrimaryKey();
                queryCacheKey = new QueryCacheKey(string, objectArray2, tTLManager, sqlFinder.getCmrFieldFinderReturnType1(i));
                queryCacheElement = new QueryCacheElement(object, tTLManager);
                queryCachingHandler.addQueryCachingEntry(tTLManager, queryCacheKey, queryCacheElement);
            }
            if (sqlFinder.getCmrFieldFinderMethodName2(i) == null) continue;
            string = sqlFinder.getCmrFieldFinderMethodName2(i);
            objectArray2 = new Object[]{((CMPBean)object3).__WL_getPrimaryKey()};
            tTLManager = (TTLManager)sqlFinder.getManager(nArray[i]);
            object = ((CMPBean)object2).__WL_getPrimaryKey();
            queryCacheKey = new QueryCacheKey(string, objectArray2, tTLManager, sqlFinder.getCmrFieldFinderReturnType2(i));
            queryCacheElement = new QueryCacheElement(object, tTLManager);
            queryCachingHandler.addQueryCachingEntry(tTLManager, queryCacheKey, queryCacheElement);
        }
    }

    private Object processSqlColumn(SqlFinder sqlFinder, ResultSet resultSet, int n, CMPBean cMPBean) throws SQLException, IOException, IllegalAccessException, ClassNotFoundException {
        Class clazz = sqlFinder.getColumnClass(n);
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " targetClass-" + clazz);
        }
        int n2 = n + 1;
        Object object = null;
        byte[] byArray = null;
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                object = new Boolean(resultSet.getBoolean(n2));
            } else if (clazz == Byte.TYPE) {
                object = new Byte(resultSet.getByte(n2));
            } else if (clazz == Character.TYPE) {
                String string = resultSet.getString(n2);
                object = resultSet.wasNull() || string == null || string.length() == 0 ? new Character('\u0000') : new Character(string.charAt(0));
            } else if (clazz == Short.TYPE) {
                object = new Short(resultSet.getShort(n2));
            } else if (clazz == Integer.TYPE) {
                object = new Integer(resultSet.getInt(n2));
            } else if (clazz == Long.TYPE) {
                object = new Long(resultSet.getLong(n2));
            } else if (clazz == Float.TYPE) {
                object = new Float(resultSet.getFloat(n2));
            } else if (clazz == Double.TYPE) {
                object = new Double(resultSet.getDouble(n2));
            }
        } else if (clazz == String.class) {
            if (sqlFinder.isClobColumn(n)) {
                object = this.processClobColumn(clazz, n2, resultSet);
            } else {
                object = resultSet.getString(n2);
                if (resultSet.wasNull()) {
                    object = null;
                }
            }
        } else if (clazz == BigDecimal.class) {
            object = resultSet.getBigDecimal(n2);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (clazz == Boolean.class) {
            boolean bl = resultSet.getBoolean(n2);
            object = resultSet.wasNull() ? null : new Boolean(bl);
        } else if (clazz == Byte.class) {
            byte by = resultSet.getByte(n2);
            object = resultSet.wasNull() ? null : new Byte(by);
        } else if (clazz == byteArray.getClass()) {
            if (sqlFinder.isBlobColumn(n)) {
                object = this.processBlobColumn(clazz, n2, resultSet);
            } else {
                object = resultSet.getBytes(n2);
                if (resultSet.wasNull()) {
                    object = null;
                }
            }
        } else if (clazz == Character.class) {
            String string = resultSet.getString(n2);
            object = resultSet.wasNull() || string == null || string.length() == 0 ? null : new Character(string.charAt(0));
        } else if (clazz == java.sql.Date.class) {
            object = resultSet.getDate(n2);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (clazz == Double.class) {
            double d = resultSet.getDouble(n2);
            object = resultSet.wasNull() ? null : new Double(d);
        } else if (clazz == Float.class) {
            float f = resultSet.getFloat(n2);
            object = resultSet.wasNull() ? null : new Float(f);
        } else if (clazz == Integer.class) {
            int n3 = resultSet.getInt(n2);
            object = resultSet.wasNull() ? null : new Integer(n3);
        } else if (clazz == Long.class) {
            long l = resultSet.getLong(n2);
            object = resultSet.wasNull() ? null : new Long(l);
        } else if (clazz == Short.class) {
            short s = resultSet.getShort(n2);
            object = resultSet.wasNull() ? null : new Short(s);
        } else if (clazz == Time.class) {
            object = resultSet.getTime(n2);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (clazz == Date.class) {
            Timestamp timestamp = resultSet.getTimestamp(n2);
            object = resultSet.wasNull() || timestamp == null ? null : new Date(timestamp.getTime());
        } else if (sqlFinder.isCharArrayMappedToString(clazz)) {
            if (sqlFinder.isClobColumn(n)) {
                object = this.processClobColumn(clazz, n2, resultSet);
            } else {
                String string = resultSet.getString(n2);
                object = resultSet.wasNull() || string == null ? null : (Object)string.toCharArray();
            }
        } else if (cMPBean == null) {
            object = resultSet.getObject(n2);
            if (resultSet.wasNull()) {
                object = null;
            }
        } else if (sqlFinder.isBlobColumn(n)) {
            object = this.processBlobColumn(clazz, n2, resultSet);
        } else {
            byArray = resultSet.getBytes(n2);
            if (resultSet.wasNull() || byArray == null || byArray.length == 0) {
                object = null;
                byArray = null;
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                RDBMSObjectInputStream rDBMSObjectInputStream = new RDBMSObjectInputStream(byteArrayInputStream, this.classLoader);
                object = rDBMSObjectInputStream.readObject();
            }
        }
        if (runtimeLogger.isDebugEnabled()) {
            if (object != null) {
                RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " processing column-" + n + " value- " + object + "type- " + object.getClass().getName());
            } else {
                RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " processing column-" + n + " value- null ");
            }
        }
        if (cMPBean != null) {
            AccessibleObject accessibleObject;
            if (sqlFinder.hasField(n)) {
                accessibleObject = sqlFinder.getField(n);
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime(sqlFinder.getName() + " setting field: field- " + ((Field)accessibleObject).getName() + " bean- " + cMPBean.getClass().getName());
                }
                ((Field)accessibleObject).set(cMPBean, object);
            } else {
                accessibleObject = sqlFinder.getMethod(n);
                try {
                    ((Method)accessibleObject).invoke(cMPBean, object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new AssertionError("exception while invoking method-" + accessibleObject);
                }
            }
            if (sqlFinder.isOptimistic(n)) {
                accessibleObject = sqlFinder.getOptimisticField(n);
                if (byArray == null) {
                    if (Date.class.isAssignableFrom(clazz) && object != null) {
                        ((Field)accessibleObject).set(cMPBean, ((Date)object).clone());
                    } else if (clazz == byteArray.getClass() && object != null) {
                        ((Field)accessibleObject).set(cMPBean, ((byte[])object).clone());
                    } else if (clazz == charArray.getClass() && object != null) {
                        ((Field)accessibleObject).set(cMPBean, ((char[])object).clone());
                    } else {
                        ((Field)accessibleObject).set(cMPBean, object);
                    }
                } else {
                    ((Field)accessibleObject).set(cMPBean, byArray);
                }
            }
            cMPBean.__WL_setLoaded(sqlFinder.getIsLoadedIndex(n), true);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object processBlobColumn(Class clazz, int n, ResultSet resultSet) throws SQLException, IOException, ClassNotFoundException {
        Object object = null;
        try {
            Blob blob = resultSet.getBlob(n);
            if (blob == null) {
                if (!runtimeLogger.isDebugEnabled()) return object;
                RDBMSPersistenceManager.debugRuntime("got NULL Blob, set result to null.");
                return object;
            }
            int n2 = (int)blob.length();
            if (n2 == 0) {
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime("got zero length Blob");
                }
                if (!byteArray.getClass().equals(clazz)) return object;
                return new byte[0];
            }
            byte[] byArray = new byte[n2];
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("got: " + n2 + " length Blob, now read data.");
            }
            InputStream inputStream = blob.getBinaryStream();
            inputStream.read(byArray);
            inputStream.close();
            if (byteArray.getClass().equals(clazz)) {
                return byArray;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n2);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                try {
                    object = objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!runtimeLogger.isDebugEnabled()) throw classNotFoundException;
                    RDBMSPersistenceManager.debugRuntime("ClassNotFoundException for Blob" + classNotFoundException.getMessage());
                    throw classNotFoundException;
                }
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                byteArrayInputStream.close();
                objectInputStream.close();
                throw throwable;
            }
            byteArrayInputStream.close();
            objectInputStream.close();
            return object;
        }
        catch (IOException iOException) {
            if (!runtimeLogger.isDebugEnabled()) throw iOException;
            RDBMSPersistenceManager.debugRuntime("IOException for Blob" + iOException.getMessage());
            throw iOException;
        }
        catch (SQLException sQLException) {
            if (!runtimeLogger.isDebugEnabled()) throw sQLException;
            RDBMSPersistenceManager.debugRuntime("SQLException for Blob" + sQLException.getMessage());
            throw sQLException;
        }
    }

    private Object processClobColumn(Class clazz, int n, ResultSet resultSet) throws SQLException, IOException, ClassNotFoundException {
        Object object = null;
        try {
            Clob clob = resultSet.getClob(n);
            if (clob == null) {
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime("got NULL Clob, set result to null.");
                }
            } else {
                int n2 = (int)clob.length();
                if (n2 == 0) {
                    if (runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime("got zero length Clob.");
                    }
                    object = clazz == String.class ? (Object)new String("") : new char[]{};
                } else {
                    char[] cArray = new char[n2];
                    if (runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime("got: " + n2 + " length Clob, now read data.");
                    }
                    Reader reader = clob.getCharacterStream();
                    reader.read(cArray);
                    reader.close();
                    object = clazz == String.class ? (Object)new String(cArray) : cArray;
                }
            }
        }
        catch (IOException iOException) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("IOException for Blob/Clob" + iOException.getMessage());
            }
            throw iOException;
        }
        catch (SQLException sQLException) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("SQLException for Blob/Clob" + sQLException.getMessage());
            }
            throw sQLException;
        }
        return object;
    }

    public Map collectionFinderLoadBean(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.collectionFinderLoadBean");
        }
        try {
            return (Map)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public void loadBeanFromRS(EntityBean entityBean, RSInfo rSInfo) throws InternalException {
        try {
            if (rSInfo.usesCmpBean()) {
                CMPBean cMPBean = (CMPBean)entityBean;
                CMPBean cMPBean2 = rSInfo.getCmpBean();
                cMPBean.__WL_copyFrom(cMPBean2, true);
            } else {
                ((CMPBean)entityBean).__WL_loadGroupByIndex(rSInfo.getGroupIndex(), rSInfo.getRS(), rSInfo.getOffset(), rSInfo.getPK(), entityBean);
                if (rSInfo.getCmrField() != null) {
                    ((CMPBean)entityBean).__WL_loadCMRFieldByCmrField(rSInfo.getCmrField(), rSInfo.getRS(), rSInfo.getCmrFieldOffset(), entityBean);
                }
            }
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("Error load bean states from ResultSet", exception);
        }
    }

    public void updateClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setRdbmsBean(RDBMSBean rDBMSBean) {
        assert (rDBMSBean != null);
        assert (rDBMSBean.getDataSourceName() != null) : "No data source set for this RDBMS bean.";
        assert (rDBMSBean.getTableName() != null) : "No table name set for this RDBMS bean.";
        this.rbean = rDBMSBean;
    }

    public void cleanup() {
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("**************************************cleanup()- " + this.ejbName);
        }
        assert (!((EntityBeanInfo)this.beanManager.getEJBHome().getBeanInfo()).isDynamicQueriesEnabled());
        this.rbean.cleanup();
    }

    private RDBMSBean rbean() {
        if (this.rbean == null) {
            throw new AssertionError("Internal error: RDBMSBean is null in RDBMSPersistenceManager()");
        }
        return this.rbean;
    }

    public boolean getVerifyReads() {
        return this.rbean().getVerifyReads();
    }

    public void setupParentBeanManagers() {
        for (String string : this.rbean().getForeignKeyFieldNames()) {
            if (this.rbean.isManyToManyRelation(string)) continue;
            RDBMSBean rDBMSBean = this.rbean().getRelatedRDBMSBean(string);
            boolean bl = true;
            BaseEntityManager baseEntityManager = rDBMSBean.getRDBMSPersistenceManager().getBeanManager();
            if (!this.isSelfRelationship(string)) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment(this.rbean.getEjbName() + ": adding " + rDBMSBean.getEjbName() + " to its parentBeanManager");
                }
                this.beanManager.addParentBeanManager(baseEntityManager);
                baseEntityManager.addChildBeanManager(this.beanManager);
            }
            List list = this.rbean().getForeignKeyColNames(string);
            String string2 = this.rbean().getTableForCmrField(string);
            for (String string3 : list) {
                String string4 = this.rbean().getVariable(string2, string3);
                bl &= ((Boolean)this.variable2nullable.get(string4)).booleanValue();
            }
            this.fkFieldNullableMap.put(string, new Boolean(bl));
            this.fkColsNullable &= bl;
            if (this.isSelfRelationship(string) || bl) continue;
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment(this.rbean.getEjbName() + ": adding " + rDBMSBean.getEjbName() + " to its notNullableParentBeanManager");
            }
            this.beanManager.addNotNullableParentBeanManager(baseEntityManager);
            baseEntityManager.addNotNullableChildBeanManager(this.beanManager);
        }
    }

    public boolean isSelfRelationship(String string) {
        return this.rbean().isSelfRelationship(string);
    }

    public boolean isSelfRelationship() {
        return this.rbean().isSelfRelationship();
    }

    public boolean isFkColsNullable(String string) {
        return (Boolean)this.fkFieldNullableMap.get(string);
    }

    public boolean isFkColsNullable() {
        return this.fkColsNullable;
    }

    public void setCycleExists() {
        HashSet hashSet = new HashSet();
        this.getBeanManager().setCycleExists(hashSet);
    }

    public void setupM2NBeanManagers() {
        for (String string : this.rbean().getAllCmrFields()) {
            if (!this.rbean().isDeclaredField(string) || !this.rbean().isManyToManyRelation(string)) continue;
            RDBMSBean rDBMSBean = this.rbean.getRelatedRDBMSBean(string);
            String string2 = rDBMSBean.getEjbName();
            BaseEntityManager baseEntityManager = rDBMSBean.getRDBMSPersistenceManager().getBeanManager();
            String string3 = this.rbean.getEjbName();
            if (this.rbean().isSymmetricField(string)) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("  adding M2N Bean Manager " + this.rbean.getEjbName() + " to exec delayed INSERTS for symmetric cmrf: " + string);
                }
                this.beanManager.addM2NInsertSet(string);
                continue;
            }
            if (this.rbean().equals(rDBMSBean) && this.rbean().isBiDirectional(string)) {
                String string4 = this.rbean().getRelatedFieldName(string);
                if (this.beanManager.isM2NInsertSet(string) || this.beanManager.isM2NInsertSet(string4)) continue;
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("  adding M2N Bean Manager " + this.rbean.getEjbName() + " to exec delayed INSERTS for self-reflected" + " none-symmetric cmrf: " + string);
                }
                this.beanManager.addM2NInsertSet(string);
                continue;
            }
            if (!this.rbean().isBiDirectional(string)) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("  adding M2N Bean Manager '" + this.rbean().getEjbName() + "' to exec delayed INSERTS forunidirectional cmrf: '" + string + "', parent bean manager is: '" + string2 + "'");
                }
                this.beanManager.addM2NInsertSet(string);
                this.beanManager.addParentBeanManager(baseEntityManager);
                baseEntityManager.addChildBeanManager(this.beanManager);
                continue;
            }
            if (string3.compareTo(string2) <= 0) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("  adding M2N Bean Manager " + string3 + " to exec delayed INSERTS for bidirectional cmrf: " + string + ", parent bean manager is: '" + string2 + "'");
                }
                this.beanManager.addM2NInsertSet(string);
                this.beanManager.addParentBeanManager(baseEntityManager);
                baseEntityManager.addChildBeanManager(this.beanManager);
                continue;
            }
            if (!deploymentLogger.isDebugEnabled()) continue;
            RDBMSPersistenceManager.debugDeployment("  " + string3 + "  will defer to other M2N Bean Manager " + string2 + " to exec delayed INSERTS for cmrf: " + string);
        }
    }

    private String getCreateDefaultDBMSTables() {
        return this.rbean().getCreateDefaultDBMSTables();
    }

    private String getValidateDbSchemaWith() {
        return this.rbean().getValidateDbSchemaWith();
    }

    private String getDefaultDbmsTablesDdl() {
        return this.rbean().getDefaultDbmsTablesDdl();
    }

    private void populateVerifyRows() {
        if (this.isOptimistic && this.rbean().getVerifyReads() || this.needsBatchOperationsWorkaround()) {
            int n;
            if (!this.selectForUpdateSupported) {
                EJBLogger.logAnomalousRRBehaviorPossible((String)this.ejbName);
            }
            this.verifyText = new String[this.rbean().tableCount()];
            this.verifyTextWithXLock = new String[this.rbean().tableCount()];
            this.verifyCount = new int[this.rbean().tableCount()];
            this.verifyCur = new int[this.rbean().tableCount()];
            for (n = 0; n < this.rbean().tableCount(); ++n) {
                String string = this.rbean().tableAt(n);
                this.verifyText[n] = "SELECT 7 FROM " + string;
                this.verifyTextWithXLock[n] = this.verifyText[n];
                if (this.selectForUpdateSupported) {
                    switch (this.databaseType) {
                        case 2: 
                        case 7: {
                            int n2 = n;
                            this.verifyTextWithXLock[n2] = this.verifyTextWithXLock[n2] + " WITH(UPDLOCK) ";
                            break;
                        }
                        case 5: {
                            int n3 = n;
                            this.verifyTextWithXLock[n3] = this.verifyTextWithXLock[n3] + " HOLDLOCK ";
                        }
                    }
                }
                int n4 = n;
                this.verifyText[n4] = this.verifyText[n4] + " WHERE ";
                int n5 = n;
                this.verifyTextWithXLock[n5] = this.verifyTextWithXLock[n5] + " WHERE ";
                this.verifyCount[n] = 0;
                this.verifyCur[n] = 1;
            }
            if (deploymentLogger.isDebugEnabled()) {
                for (n = 0; n < this.verifyText.length; ++n) {
                    RDBMSPersistenceManager.debugDeployment("verifyText[" + n + "]: " + this.verifyText[n]);
                    RDBMSPersistenceManager.debugDeployment("verifyTextWithXLock[" + n + "]: " + this.verifyTextWithXLock[n]);
                }
            }
        }
    }

    private void populateSnapShotStrings() {
        Object object;
        List list = this.rbean().getCmpFieldNames();
        List list2 = this.rbean().getForeignKeyFieldNames();
        if (this.rbean().getCMPBeanDescriptor().isOptimistic()) {
            this.snapshotStrings = new String[list.size() + list2.size()];
            this.nullSnapshotStrings = new String[list.size() + list2.size()];
        }
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = this.rbean().getCmpColumnForField(string);
            if (this.rbean().getCMPBeanDescriptor().isOptimistic()) {
                this.snapshotStrings[n] = (String)object + " = ?";
                this.nullSnapshotStrings[n] = (String)object + " is null";
            }
            ++n;
        }
        for (String string : list2) {
            if (!this.rbean().containsFkField(string) || this.rbean().isForeignCmpField(string)) continue;
            object = this.rbean().getForeignKeyColNames(string).iterator();
            if (this.rbean().getCMPBeanDescriptor().isOptimistic()) {
                this.snapshotStrings[n] = "";
                this.nullSnapshotStrings[n] = "";
            }
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!this.rbean().getCMPBeanDescriptor().isOptimistic()) continue;
                int n2 = n;
                this.snapshotStrings[n2] = this.snapshotStrings[n2] + string2 + " = ?";
                int n3 = n;
                this.nullSnapshotStrings[n3] = this.nullSnapshotStrings[n3] + string2 + " is null";
                if (!object.hasNext()) continue;
                int n4 = n;
                this.snapshotStrings[n4] = this.snapshotStrings[n4] + " AND ";
                int n5 = n;
                this.nullSnapshotStrings[n5] = this.nullSnapshotStrings[n5] + " AND ";
            }
            ++n;
        }
    }

    private void computeVariablesAndColumns(String string, List list, List list2) {
        String string2;
        Object object;
        Object object2;
        Map map = this.rbean().getCmpField2ColumnMap(string);
        if (map != null) {
            object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string2 = (String)map.get(object);
                assert (string2 != null);
                list.add(object);
                list2.add(string2);
            }
        }
        if ((object2 = this.rbean().getCmrFields(string)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                for (String string3 : this.rbean().getForeignKeyColNames(string2)) {
                    String string4 = this.rbean().variableForField(string2, string, string3);
                    if (!list.contains(string4)) {
                        list.add(string4);
                    }
                    if (list2.contains(string3)) continue;
                    list2.add(string3);
                }
            }
        }
    }

    private List getJoinTableColumns(String string) {
        if (!this.rbean().isJoinTable(string)) {
            throw new AssertionError(" Bean: '" + this.ejbName + "', passed in table name: '" + string + "'.  We were expecting a JoinTable " + "but apparently this isn't a JoinTable.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = this.rbean().getCmrFieldForJoinTable(string);
        Map map = this.rbean().getFkColumn2ClassMapForFkField(string2);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (this.rbean().isRemoteField(string2)) {
            String string3 = this.rbean().getRemoteColumn(string2);
            arrayList.add(string3);
        } else if (this.rbean().isSymmetricField(string2)) {
            Map map2 = this.rbean().getSymmetricColumn2FieldName(string2);
            for (String string4 : map2.keySet()) {
                arrayList.add(string4);
            }
        } else {
            RDBMSBean rDBMSBean = this.rbean().getRelatedRDBMSBean(string2);
            String string5 = this.rbean().getRelatedFieldName(string2);
            map = rDBMSBean.getFkColumn2ClassMapForFkField(string5);
            for (String string6 : map.keySet()) {
                arrayList.add(string6);
            }
        }
        return arrayList;
    }

    private void populateFieldSQLTypeMap() throws WLDeploymentException {
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("RDBMSPersistenceManager.populateFieldSQLTypeMap");
        }
        if (this.variable2SQLType.size() > 0) {
            return;
        }
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                for (String string : this.rbean().getTables()) {
                    string = RDBMSUtils.escQuotedID(string);
                    if (deploymentLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugDeployment(" populateFieldSQLTypeMap call verify on Table: '" + string + "'");
                    }
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    this.rbean.computeVariablesAndColumns(string, arrayList, arrayList2, null);
                    this.verifier.verifyOrCreateOrAlterTable(this, connection, string, arrayList2, true, arrayList, this.variable2SQLType, this.variable2nullable, null, false);
                }
                if (this.variable2SQLType.size() <= 0) {
                    String string;
                    string = EJBLogger.logCouldNotInitializeFieldSQLTypeMapWithoutExceptionLoggable();
                    throw new WLDeploymentException(string.getMessage());
                }
                Object var7_8 = null;
                this.releaseResources(connection, null, null);
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logCouldNotInitializeFieldSQLTypeMapLoggable((Exception)exception);
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.releaseResources(connection, null, null);
            throw throwable;
        }
    }

    private void verifyTablesExist() throws WLDeploymentException {
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                for (Object object : this.rbean().getTables()) {
                    object = RDBMSUtils.escQuotedID((String)object);
                    if (deploymentLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugDeployment(" verifyTablesExist call verify on Main Table: '" + (String)object + "'");
                    }
                    Object object2 = new ArrayList();
                    ArrayList arrayList = new ArrayList();
                    this.rbean.computeVariablesAndColumns((String)object, (List)object2, arrayList, null);
                    boolean bl = this.rbean().getTriggerUpdatesOptimisticColumn((String)object);
                    this.verifier.verifyOrCreateOrAlterTable(this, connection, (String)object, arrayList, true, (List)object2, this.variable2SQLType, this.variable2nullable, this.rbean().getCreateDefaultDBMSTables(), bl);
                }
                for (Object object2 : this.rbean().getJoinTableMap().values()) {
                    if (deploymentLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugDeployment(" verifyTablesExist call verify on Join Table: '" + (String)object2 + "'");
                    }
                    this.verifier.verifyOrCreateOrAlterTable(this, connection, (String)object2, this.getJoinTableColumns((String)object2), false, new ArrayList(), null, null, this.rbean().getCreateDefaultDBMSTables(), false);
                }
                Object var8_9 = null;
                this.releaseResources(connection, null, null);
            }
            catch (WLDeploymentException wLDeploymentException) {
                throw wLDeploymentException;
            }
            catch (Exception exception) {
                EJBLogger.logStackTraceAndMessage((String)exception.getMessage(), (Throwable)exception);
                throw new WLDeploymentException(exception.getMessage(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseResources(connection, null, null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifySelectForUpdateSupported() {
        Connection connection = null;
        Statement statement = null;
        boolean bl = false;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                switch (this.databaseType) {
                    case 2: 
                    case 7: {
                        statement.executeQuery("SELECT 7 FROM " + this.rbean().getTableName() + " WITH(UPDLOCK) WHERE (1=0)");
                        break;
                    }
                    case 5: {
                        statement.executeQuery("SELECT 7 FROM " + this.rbean().getTableName() + " HOLDLOCK WHERE (1=0)");
                        break;
                    }
                    case 4: 
                    case 9: {
                        if (!this.rbean.getUseSelectForUpdate() && !this.isOptimistic) {
                            boolean bl2 = false;
                            Object var7_7 = null;
                            this.releaseResources(connection, statement, null);
                            return bl2;
                        }
                        Iterator iterator = this.rbean().getCMPBeanDescriptor().getPrimaryKeyFieldNames().iterator();
                        String string = this.rbean().getColumnForCmpFieldAndTable((String)iterator.next(), this.rbean().getTableName()) + " is null";
                        statement.executeQuery("SELECT 7 FROM " + this.rbean().getTableName() + " WHERE " + string + " FOR UPDATE");
                        break;
                    }
                    case 1: {
                        statement.executeQuery("SELECT 7 FROM " + this.rbean().getTableName() + " WHERE ROWNUM < 1 FOR UPDATE");
                        break;
                    }
                    default: {
                        statement.executeQuery("SELECT 7 FROM " + this.rbean().getTableName() + " WHERE (1=0) FOR UPDATE");
                    }
                }
                bl = true;
            }
            catch (SQLException sQLException) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("Exception while verifying select for update support: " + sQLException.getMessage());
                }
                Object var7_9 = null;
                this.releaseResources(connection, statement, null);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.releaseResources(connection, statement, null);
            throw throwable;
        }
        Object var7_8 = null;
        this.releaseResources(connection, statement, null);
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private void genKeySetup() throws WLDeploymentException {
        block24: {
            if (!this.rbean().hasAutoKeyGeneration()) {
                return;
            }
            this.genKeyPKFieldClassType = this.rbean().getGenKeyPKFieldClassType();
            this.genKeyWLGeneratorQuery = this.rbean().getGenKeyGeneratorQuery();
            if (this.genKeyType == 2) {
                this.genKeyGeneratorName = this.rbean().getGenKeyGeneratorName();
                this.genKeyCacheSize = this.rbean().getGenKeyCacheSize();
                this.genKeyCurrCacheSize = 0;
                var1_1 = null;
                try {
                    try {
                        var1_1 = this.getConnection();
                        this.genKeyGeneratorName = this.verifier.verifyOrCreateOrAlterSequence(var1_1, this.genKeyGeneratorName, this.genKeyCacheSize, this.rbean().getCreateDefaultDBMSTables(), this.databaseType);
                        if (RDBMSPersistenceManager.deploymentLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugDeployment("RDBMSPersistenceManager will use sequence: '" + this.genKeyGeneratorName + "'");
                        }
                        switch (this.databaseType) {
                            case 1: {
                                this.genKeyWLGeneratorQuery = this.rbean.getOracleSequenceGeneratorQuery(this.genKeyGeneratorName);
                                ** break;
                            }
                            case 4: {
                                this.genKeyWLGeneratorQuery = this.rbean.getDB2SequenceGeneratorQuery(this.genKeyGeneratorName);
                                ** break;
                            }
                            case 3: {
                                this.genKeyWLGeneratorQuery = this.rbean.getInformixSequenceGeneratorQuery(this.genKeyGeneratorName);
                                ** break;
                            }
                            default: {
                                throw new AssertionError("Database Type: " + DDConstants.getDBNameForType(this.databaseType) + " does not support the SEQUENCE key generator");
lbl28:
                                // 3 sources

                            }
                        }
                    }
                    catch (Exception var2_7) {
                        var3_9 = EJBLogger.logSequenceSetupFailureLoggable((String)this.genKeyGeneratorName, (String)Integer.toString(this.genKeyCacheSize), (String)var2_7.getMessage());
                        throw new WLDeploymentException(var3_9.getMessage(), var2_7);
                    }
                    var5_3 = null;
                    this.releaseResources(var1_1, null, null);
                    break block24;
                }
                catch (Throwable var4_11) {
                    var5_4 = null;
                    this.releaseResources(var1_1, null, null);
                    throw var4_11;
                }
            }
            if (this.genKeyType != 1 && this.genKeyType == 3) {
                this.genKeyCacheSize = this.rbean().getGenKeyCacheSize();
                this.genKeyWLGeneratorUpdatePrefix = this.rbean().getGenKeyGeneratorUpdatePrefix();
                this.genKeyWLGeneratorUpdate = this.genKeyWLGeneratorUpdatePrefix + this.genKeyCacheSize;
                this.genKeyGeneratorName = this.rbean().getGenKeyGeneratorName();
                this.selectFirstSeqKeyBeforeUpdate = this.rbean().getSelectFirstSeqKeyBeforeUpdate();
                var1_2 = null;
                var2_8 = null;
                var3_10 = null;
                var4_12 = null;
                try {
                    try {
                        if (TxHelper.getTransaction() == null) {
                            var4_12 = TxHelper.getTransactionManager();
                            var4_12.setTransactionTimeout(60);
                            var4_12.begin();
                        }
                        if ((var5_5 = this.verifier.checkTableAndColumns(this, var1_2 = this.getConnection(), this.genKeyGeneratorName, new String[]{"SEQUENCE"}, false, null, null, null)) == 0 && !this.getCreateDefaultDBMSTables().equalsIgnoreCase("Disabled")) {
                            var6_13 = new ArrayList();
                            var6_13.add("SEQUENCE");
                            this.verifier.verifyOrCreateOrAlterTable(this, var1_2, this.genKeyGeneratorName, (List)var6_13, false, null, null, null, this.getCreateDefaultDBMSTables(), false);
                            var2_8 = var1_2.createStatement();
                            var2_8.executeUpdate("INSERT INTO " + this.genKeyGeneratorName + " (SEQUENCE) VALUES (0)");
                            var2_8.close();
                            if (var4_12 != null) {
                                var4_12.commit();
                            }
                        }
                        if (!(var3_10 = (var2_8 = var1_2.createStatement()).executeQuery(this.genKeyWLGeneratorQuery)).next()) {
                            var3_10.close();
                            var2_8.close();
                            var6_13 = EJBLogger.logGenKeySequenceTableEmptyLoggable((String)this.genKeyGeneratorName);
                            throw new WLDeploymentException(var6_13.getMessage());
                        }
                        var8_16 = null;
                        this.releaseResources(var1_2, null, null);
                    }
                    catch (Exception var5_6) {
                        try {
                            if (var4_12 != null) {
                                var4_12.rollback();
                            }
                        }
                        catch (Exception var6_14) {
                            // empty catch block
                        }
                        var6_15 = EJBLogger.logGenKeySequenceTableSetupFailureLoggable((String)(this.genKeyGeneratorName + "  " + var5_6.getMessage()));
                        throw new WLDeploymentException(var6_15.getMessage(), var5_6);
                    }
                }
                catch (Throwable var7_18) {
                    var8_17 = null;
                    this.releaseResources(var1_2, null, null);
                    throw var7_18;
                }
            }
        }
    }

    private Set createPrimaryKeyCols(String string) {
        Map map = this.rbean().getCmpField2ColumnMap(string);
        if (map == null) {
            return new ArraySet();
        }
        List list = this.rbean().getPrimaryKeyFields();
        Iterator iterator = map.keySet().iterator();
        ArraySet arraySet = new ArraySet();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (!list.contains(string2)) continue;
            arraySet.add((Object)string3);
        }
        return arraySet;
    }

    private String getSqltypeForCol(String string, String string2) throws WLDeploymentException {
        String string3 = this.rbean().getCmpField(string, string2);
        Class clazz = null;
        if (string3 != null) {
            clazz = this.rbean().getCmpFieldClass(string3);
        } else {
            clazz = this.rbean().getJavaClassTypeForFkCol(string, string2);
            if (clazz == null) {
                RDBMSBean rDBMSBean = this.rbean().getRelatedBean(string, string2);
                if (rDBMSBean == null) {
                    throw new WLDeploymentException(" Bean: " + this.rbean().getEjbName() + ", could not get Column To Field Map for column " + string2);
                }
                clazz = rDBMSBean.getJavaClassTypeForFkCol(string, string2);
            }
        }
        if (null == clazz) {
            throw new WLDeploymentException(" Bean: " + this.ejbName + ", could not get Column To Field Map for column " + string2);
        }
        try {
            return this.rbean.getDefaultDBMSColType(clazz);
        }
        catch (Exception exception) {
            throw new WLDeploymentException("No Field class found for " + string2);
        }
    }

    private boolean getSequenceTableColumns(String string, StringBuffer stringBuffer) throws Exception {
        if (this.rbean().hasAutoKeyGeneration() && this.genKeyType == 3) {
            String string2 = this.rbean().getGenKeyGeneratorName();
            if (string2 != null && string != null) {
                if (string2.equals(string)) {
                    stringBuffer.append("SEQUENCE ").append(this.getGenKeySequenceDBColType());
                    return true;
                }
                return false;
            }
            throw new RDBMSException(" in getSequenceTableColumns: either the SEQUENCE_TABLE name in the RDBMSBean or the passed in table Name  is NULL for bean: " + this.ejbName);
        }
        return false;
    }

    private boolean getBeanOrJoinTableColumns(String string, StringBuffer stringBuffer) throws Exception {
        Iterator<Object> iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Object object6;
        Object object7;
        Iterator iterator2;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.rbean().isJoinTable(string)) {
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment(" createDefaultDBMSTable: processing Join Table: " + string);
            }
            if (null == (iterator2 = this.rbean().getCmrFieldForJoinTable(string))) {
                throw new RDBMSException(" Bean: " + this.ejbName + ", could not get cmrField for Join Table " + string);
            }
            object7 = this.rbean().getFkColumn2ClassMapForFkField((String)((Object)iterator2));
            if (null == object7) {
                throw new RDBMSException(" Bean: " + this.ejbName + ", could not get Column To Class Map for FK Field " + (String)((Object)iterator2));
            }
            object6 = new ArrayList();
            for (Object object52 : object7.keySet()) {
                object4 = (Class)object7.get(object52);
                stringBuffer.append((String)object52 + " ");
                stringBuffer.append(this.rbean.getDefaultDBMSColType((Class)object4));
                if (this.databaseType == 2 || this.databaseType == 7 || this.databaseType == 5 || this.databaseType == 4 || this.databaseType == 9) {
                    stringBuffer.append(" NOT NULL ");
                }
                stringBuffer.append(", ");
                hashSet.add(object52);
                object6.add(object52);
            }
            if (this.rbean().isRemoteField((String)((Object)iterator2))) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment(" Do REMOTE RHS of Join Table ");
                }
                object52 = this.rbean().getEjbEntityRef((String)((Object)iterator2));
                object4 = null;
                object3 = this.rbean().getRemoteColumn((String)((Object)iterator2));
                stringBuffer.append(object3 + " ");
                object2 = object4;
                if (!this.rbean.isValidSQLType((Class)object4) && Serializable.class.isAssignableFrom((Class<?>)object4)) {
                    object = new byte[0];
                    object2 = object.getClass();
                }
                stringBuffer.append(this.rbean.getDefaultDBMSColType((Class)object2));
                if (this.databaseType == 2 || this.databaseType == 7 || this.databaseType == 5) {
                    stringBuffer.append(" NOT NULL ");
                }
                hashSet.add(object3);
            } else if (this.rbean().isSymmetricField((String)((Object)iterator2))) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment(" Do Symmetric RHS of Join Table ");
                }
                if (null == (object52 = this.rbean().getSymmetricColumn2FieldName((String)((Object)iterator2)))) {
                    throw new RDBMSException(" Bean: " + this.ejbName + ", could not get Symmetric Column To Class " + "Map for FK Field " + iterator2);
                }
                iterator = object52.keySet().iterator();
                while (iterator.hasNext()) {
                    object4 = (String)iterator.next();
                    if (object6.contains(object4)) continue;
                    stringBuffer.append((String)object4 + " ");
                    object3 = (String)object52.get(object4);
                    object2 = this.rbean().getCmpFieldClass((String)object3);
                    stringBuffer.append(this.rbean.getDefaultDBMSColType((Class)object2));
                    if (this.databaseType == 2 || this.databaseType == 7 || this.databaseType == 5) {
                        stringBuffer.append(" NOT NULL ");
                    }
                    hashSet.add(object4);
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
            } else {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment(" Do Normal non-Remote non-Symmetric RHS of Join Table ");
                }
                if (null == (object7 = ((RDBMSBean)(object52 = this.rbean().getRelatedRDBMSBean((String)((Object)iterator2)))).getFkColumn2ClassMapForFkField((String)(object4 = this.rbean().getRelatedFieldName((String)((Object)iterator2)))))) {
                    throw new RDBMSException(" Bean: " + ((RDBMSBean)object52).getEjbName() + ", could not get Column To Class Map for FK Field " + (String)object4);
                }
                iterator = object7.keySet().iterator();
                while (iterator.hasNext()) {
                    object3 = (String)iterator.next();
                    if (object6.contains(object3)) continue;
                    object2 = (Class)object7.get(object3);
                    stringBuffer.append((String)object3 + " ");
                    stringBuffer.append(this.rbean.getDefaultDBMSColType((Class)object2));
                    hashSet.add(object3);
                    if (this.databaseType == 2 || this.databaseType == 7 || this.databaseType == 5 || this.databaseType == 4 || this.databaseType == 9) {
                        stringBuffer.append(" NOT NULL ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
            }
        } else {
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment(" createDefaultDBMSTable: processing Bean Table: " + string);
            }
            iterator2 = this.rbean().getPrimaryKeyFields();
            object7 = new HashSet();
            object6 = this.rbean().getCmpField2ColumnMap(string);
            iterator = object6.keySet().iterator();
            while (iterator.hasNext()) {
                object52 = (String)iterator.next();
                object4 = (String)object6.get(object52);
                if (object7.contains(object4)) continue;
                object7.add(object4);
                object3 = this.rbean().getCmpFieldClass((String)object52);
                object2 = null;
                object2 = this.rbean.isClobCmpColumnTypeForField((String)object52) ? "Clob" : (this.rbean.isBlobCmpColumnTypeForField((String)object52) ? "Blob" : this.rbean.getDefaultDBMSColType((Class)object3));
                stringBuffer.append((String)object4 + " ");
                if (!iterator2.contains(object52)) {
                    stringBuffer.append((String)object2);
                    if (this.databaseType == 5 && !"BIT".equals(object2)) {
                        stringBuffer.append(" NULL ");
                    } else if (this.databaseType == 5 && "BIT".equals(object2)) {
                        stringBuffer.append(" NOT NULL ");
                    }
                } else {
                    hashSet.add(object4);
                    switch (this.databaseType) {
                        case 1: {
                            stringBuffer.append((String)object2);
                            stringBuffer.append(" NOT NULL ");
                            break;
                        }
                        case 2: 
                        case 7: {
                            stringBuffer.append((String)object2);
                            stringBuffer.append(" NOT NULL ");
                            if (this.genKeyType != 1) break;
                            stringBuffer.append("IDENTITY ");
                            break;
                        }
                        case 4: 
                        case 9: {
                            stringBuffer.append((String)object2);
                            stringBuffer.append(" NOT NULL ");
                            if (this.genKeyType != 1) break;
                            stringBuffer.append("GENERATED ALWAYS AS IDENTITY ");
                            break;
                        }
                        case 5: {
                            if (this.genKeyType == 1) {
                                stringBuffer.append("NUMERIC IDENTITY");
                            } else {
                                stringBuffer.append((String)object2);
                            }
                            stringBuffer.append(" NOT NULL ");
                            break;
                        }
                        case 6: {
                            stringBuffer.append((String)object2);
                            if (this.genKeyType == 1) {
                                stringBuffer.append(" IDENTITY");
                            }
                            stringBuffer.append(" NOT NULL ");
                            break;
                        }
                        case 3: {
                            if (this.genKeyType == 1) {
                                stringBuffer.append("SERIAL");
                            } else {
                                stringBuffer.append((String)object2);
                            }
                            stringBuffer.append(" NOT NULL ");
                            break;
                        }
                        case 8: {
                            stringBuffer.append((String)object2);
                            stringBuffer.append(" NOT NULL ");
                            break;
                        }
                        case 0: {
                            stringBuffer.append((String)object2);
                            break;
                        }
                        default: {
                            throw new AssertionError("Unknown DB Type: " + this.databaseType);
                        }
                    }
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            object52 = this.rbean().getCmrFields(string);
            if (object52 != null) {
                iterator = object52.iterator();
                while (iterator.hasNext()) {
                    object4 = (String)iterator.next();
                    if (!this.rbean().containsFkField((String)object4)) continue;
                    object3 = this.rbean().getForeignKeyColNames((String)object4).iterator();
                    object2 = this.rbean().getFkColumn2ClassMapForFkField((String)object4);
                    while (object3.hasNext()) {
                        object = (String)object3.next();
                        if (object7.contains(object)) continue;
                        stringBuffer.append(", ");
                        object7.add(object);
                        stringBuffer.append((String)object + " ");
                        Class clazz = (Class)object2.get(object);
                        stringBuffer.append(this.rbean.getDefaultDBMSColType(clazz));
                        if (iterator2.contains(object4)) {
                            hashSet.add(object);
                            if (this.databaseType != 2 && this.databaseType != 7 && this.databaseType != 5) continue;
                            stringBuffer.append(" NOT NULL ");
                            continue;
                        }
                        if (this.databaseType != 5) continue;
                        stringBuffer.append(" NULL ");
                    }
                }
            }
        }
        if (hashSet.size() > 0) {
            stringBuffer.append(",");
            if (this.databaseType == 6 || this.databaseType == 8 || this.databaseType == 2 || this.databaseType == 7 || this.databaseType == 5) {
                stringBuffer.append(" CONSTRAINT pk_" + string);
            }
            stringBuffer.append(" PRIMARY KEY (");
            iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                object7 = (String)iterator2.next();
                stringBuffer.append((String)object7);
                if (!iterator2.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        return true;
    }

    private Finder createDynamicFinder(String string, WLQueryProperties wLQueryProperties, boolean bl, boolean bl2, Class clazz) throws Exception {
        EjbqlFinder ejbqlFinder = null;
        if (bl2) {
            ejbqlFinder = new EjbqlFinder("execute", string);
            ejbqlFinder.setIsSelect(true);
        } else {
            ejbqlFinder = new EjbqlFinder("find", string);
        }
        ejbqlFinder.parseExpression();
        ejbqlFinder.setFinderLoadsBean(this.rbean().getCMPBeanDescriptor().getFindersLoadBean());
        if (bl) {
            ejbqlFinder.setResultTypeMapping("Local");
        } else {
            ejbqlFinder.setResultTypeMapping("Remote");
        }
        ejbqlFinder.setRDBMSBean(this.rbean());
        if (wLQueryProperties != null) {
            ejbqlFinder.setMaxElements(wLQueryProperties.getMaxElements());
            ejbqlFinder.setIncludeUpdates(wLQueryProperties.getIncludeUpdates());
            ejbqlFinder.setSqlSelectDistinct(wLQueryProperties.getSQLSelectDistinct());
            if (!bl2) {
                String string2;
                String string3 = wLQueryProperties.getRelationshipCachingName();
                if (string3 != null) {
                    if (this.rbean().getRelationshipCaching(string3) == null) {
                        Loggable loggable = EJBLogger.logInvalidRelationshipCachingNameLoggable((String)string3);
                        throw new FinderException(loggable.getMessage());
                    }
                    ejbqlFinder.setCachingName(string3);
                }
                if ((string2 = wLQueryProperties.getFieldGroupName()) != null) {
                    if (this.rbean().getFieldGroup(string2) == null) {
                        Loggable loggable = EJBLogger.loginvalidFieldGroupNameLoggable((String)string2);
                        throw new FinderException(loggable.getMessage());
                    }
                    ejbqlFinder.setGroupName(string2);
                }
                if (bl && wLQueryProperties.isResultTypeRemote()) {
                    ejbqlFinder.setResultTypeMapping("Remote");
                }
            }
        } else {
            ejbqlFinder.setNativeQuery(true);
        }
        ejbqlFinder.setReturnClassType(clazz);
        ejbqlFinder.setParameterClassTypes(new Class[0]);
        if (wLQueryProperties != null) {
            ejbqlFinder.setQueryCachingEnabled(wLQueryProperties.getEnableQueryCaching());
        }
        ejbqlFinder.computeSQLQuery(this.rbean());
        return ejbqlFinder;
    }

    private Object getDynamicQueryResult(ResultSet resultSet, Finder finder, boolean bl, boolean bl2) throws Exception {
        if (bl2) {
            RowSetFactory rowSetFactory = RowSetFactory.newInstance();
            WLCachedRowSet wLCachedRowSet = rowSetFactory.newCachedRowSet();
            wLCachedRowSet.populate(resultSet);
            return wLCachedRowSet;
        }
        boolean bl3 = finder.hasLocalResultType();
        this.checkResultTypeMapping(this.rbean(), bl3);
        QueryCachingHandler queryCachingHandler = null;
        queryCachingHandler = finder.isQueryCachingEnabled() ? finder.getQueryCachingHandler(null, (TTLManager)this.getBeanManager()) : finder.getQueryCachingHandler(null, null);
        Collection collection = this.loadBeansFromRS(resultSet, finder, this.rbean(), this.beanManager, bl3, queryCachingHandler);
        queryCachingHandler.putInQueryCache();
        return collection;
    }

    private void checkResultTypeMapping(RDBMSBean rDBMSBean, boolean bl) throws FinderException {
        if (bl) {
            if (!rDBMSBean.getCMPBeanDescriptor().hasLocalClientView()) {
                Loggable loggable = EJBLogger.loginvalidResultTypeMappingLoggable((String)rDBMSBean.getEjbName(), (String)"Local");
                throw new FinderException(loggable.getMessage());
            }
        } else if (!rDBMSBean.getCMPBeanDescriptor().hasRemoteClientView()) {
            Loggable loggable = EJBLogger.loginvalidResultTypeMappingLoggable((String)rDBMSBean.getEjbName(), (String)"Remote");
            throw new FinderException(loggable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection loadBeansFromRS(ResultSet resultSet, Finder finder, RDBMSBean rDBMSBean, BeanManager beanManager, boolean bl, QueryCachingHandler queryCachingHandler) throws Exception {
        Collection<Object> collection = new ArrayList();
        CMPBeanManager cMPBeanManager = (CMPBeanManager)((Object)beanManager);
        boolean bl2 = finder.isSelectDistinct();
        HashSet<Object> hashSet = null;
        boolean bl3 = false;
        if (bl2) {
            hashSet = new HashSet<Object>();
        }
        CMPBean cMPBean = (CMPBean)cMPBeanManager.getBeanFromPool();
        try {
            if (finder.finderLoadsBean()) {
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime("FinderLoadsBean == true");
                }
                Debug.assertion((boolean)(finder instanceof EjbqlFinder));
                if (((EjbqlFinder)finder).getCachingName() != null) {
                    bl3 = true;
                }
                String string = ((EjbqlFinder)finder).getGroupName();
                int n = rDBMSBean.getFieldGroup(string).getIndex();
                int n2 = this.getGroupColumnCount(rDBMSBean, string);
                EntityBean entityBean = null;
                Transaction transaction = TxHelper.getTransactionManager().getTransaction();
                int n3 = 1;
                while (resultSet.next()) {
                    TTLManager tTLManager;
                    RSInfoImpl rSInfoImpl;
                    if (runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime("Loading Bean: " + n3++);
                    }
                    Object object = cMPBean.__WL_getPKFromRSInstance(resultSet, new Integer(0), this.classLoader);
                    if (bl2) {
                        if (hashSet.add(object)) {
                            rSInfoImpl = new RSInfoImpl(resultSet, n, 0, object);
                            entityBean = ((BaseEntityManager)((Object)cMPBeanManager)).getBeanFromRS(transaction, object, rSInfoImpl);
                            collection.add(cMPBeanManager.finderGetEoFromBeanOrPk(entityBean, object, finder.hasLocalResultType()));
                            if (finder.isQueryCachingEnabled()) {
                                tTLManager = (TTLManager)cMPBeanManager;
                                queryCachingHandler.addQueryCachingEntry(tTLManager, new QueryCacheElement(object, tTLManager));
                            }
                        } else if (runtimeLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugRuntime("Bean was already loaded ");
                        }
                    } else {
                        rSInfoImpl = new RSInfoImpl(resultSet, n, 0, object);
                        entityBean = ((BaseEntityManager)((Object)cMPBeanManager)).getBeanFromRS(transaction, object, rSInfoImpl);
                        collection.add(cMPBeanManager.finderGetEoFromBeanOrPk(entityBean, object, finder.hasLocalResultType()));
                        if (finder.isQueryCachingEnabled()) {
                            tTLManager = (TTLManager)cMPBeanManager;
                            queryCachingHandler.addQueryCachingEntry(tTLManager, new QueryCacheElement(object, tTLManager));
                        }
                    }
                    if (!bl3) continue;
                    if (runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime("Dynamic finder has RelationshipCaching turned on, load the related beans");
                    }
                    ((CMPBean)entityBean).__WL_loadBeansRelatedToCachingName(((EjbqlFinder)finder).getCachingName(), resultSet, (CMPBean)entityBean, n2, queryCachingHandler);
                }
            } else {
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime("FinderLoadsBean == false");
                }
                while (resultSet.next()) {
                    TTLManager tTLManager;
                    if (runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime("Loading PK");
                    }
                    Object object = cMPBean.__WL_getPKFromRSInstance(resultSet, new Integer(0), this.classLoader);
                    if (bl2) {
                        if (!hashSet.add(object)) continue;
                        collection.add(object);
                        if (!finder.isQueryCachingEnabled()) continue;
                        tTLManager = (TTLManager)cMPBeanManager;
                        queryCachingHandler.addQueryCachingEntry(tTLManager, new QueryCacheElement(object, tTLManager));
                        continue;
                    }
                    collection.add(object);
                    if (!finder.isQueryCachingEnabled()) continue;
                    tTLManager = (TTLManager)cMPBeanManager;
                    queryCachingHandler.addQueryCachingEntry(tTLManager, new QueryCacheElement(object, tTLManager));
                }
                collection = ((BaseEntityManager)((Object)cMPBeanManager)).pkCollToColl(collection, finder.hasLocalResultType());
            }
            Object var23_24 = null;
            ((BaseEntityManager)((Object)cMPBeanManager)).releaseBeanToPool((EntityBean)cMPBean);
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            ((BaseEntityManager)((Object)cMPBeanManager)).releaseBeanToPool((EntityBean)cMPBean);
            throw throwable;
        }
        return collection;
    }

    public int getGroupColumnCount(RDBMSBean rDBMSBean, String string) {
        FieldGroup fieldGroup = rDBMSBean.getFieldGroup(string);
        if (fieldGroup == null) {
            return rDBMSBean.getPrimaryKeyFields().size();
        }
        HashSet<String> hashSet = new HashSet<String>();
        TreeSet treeSet = new TreeSet(fieldGroup.getCmpFields());
        treeSet.addAll(rDBMSBean.getPrimaryKeyFields());
        for (Object object : treeSet) {
            hashSet.add(rDBMSBean.getCmpColumnForField((String)object));
        }
        for (String string2 : fieldGroup.getCmrFields()) {
            for (String string3 : rDBMSBean.getForeignKeyColNames(string2)) {
                hashSet.add(string3);
            }
        }
        return hashSet.size();
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public BaseEntityManager getBeanManager() {
        return this.beanManager;
    }

    public EntityBean getBeanFromPool() throws InternalException {
        return this.beanManager.getBeanFromPool();
    }

    public EntityBean getBeanFromRS(Object object, RSInfo rSInfo) throws InternalException {
        return this.beanManager.getBeanFromRS(object, rSInfo);
    }

    public Object finderGetEoFromBeanOrPk(EntityBean entityBean, Object object, boolean bl) throws InternalException {
        return this.beanManager.finderGetEoFromBeanOrPk(entityBean, object, bl);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String nativeQuery(String string) throws FinderException {
        String string3;
        String string2 = null;
        Finder finder = null;
        try {
            finder = this.createDynamicFinder(string, null, true, true, Collection.class);
            string2 = finder.getSQLQuery();
        }
        catch (Exception exception) {
            throw new FinderException("Error constructing query: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
        }
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("EJB-QL produced SQL: " + string2);
        }
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
            }
            catch (Exception exception) {
                throw new FinderException("Couldn't get connection: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
            }
            try {
                string3 = connection.nativeSQL(string2);
            }
            catch (SQLException sQLException) {
                throw new FinderException("Error getting native SQL: \n" + sQLException.toString() + EOL + RDBMSUtils.throwable2StackTrace(sQLException));
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                this.releaseConnection(connection);
                throw throwable;
            }
            catch (SQLException sQLException2) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            // empty catch block
            return string3;
        }
        this.releaseConnection(connection);
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDatabaseProductName() throws FinderException {
        String string;
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
            }
            catch (Exception exception) {
                throw new FinderException("Couldn't get connection: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
            }
            try {
                string = connection.getMetaData().getDatabaseProductName();
            }
            catch (SQLException sQLException) {
                throw new FinderException("Error calling getDatabaseProductName: \n" + sQLException.toString() + EOL + RDBMSUtils.throwable2StackTrace(sQLException));
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.releaseConnection(connection);
                throw throwable;
            }
            catch (SQLException sQLException2) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            // empty catch block
            return string;
        }
        this.releaseConnection(connection);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDatabaseProductVersion() throws FinderException {
        String string;
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
            }
            catch (Exception exception) {
                throw new FinderException("Couldn't get connection: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
            }
            try {
                string = connection.getMetaData().getDatabaseProductVersion();
            }
            catch (SQLException sQLException) {
                throw new FinderException("Error calling getDatabaseProductVersion: \n" + sQLException.toString() + EOL + RDBMSUtils.throwable2StackTrace(sQLException));
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.releaseConnection(connection);
                throw throwable;
            }
            catch (SQLException sQLException2) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            // empty catch block
            return string;
        }
        this.releaseConnection(connection);
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executePreparedQuery(String object, boolean bl, boolean bl2, Map map, Map map2, PreparedQuery preparedQuery) throws FinderException {
        String string;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Iterator<Object> iterator;
        int n;
        Object object5;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        EjbqlFinder ejbqlFinder = null;
        Object[] objectArray = new Object[3];
        Map<Integer, Serializable> map3 = new TreeMap();
        if (object != null) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("\nEJBQL was already parsed and converted to SQL");
            }
            try {
                ejbqlFinder = bl2 ? new EjbqlFinder("execute", "dummy") : new EjbqlFinder("find", "dummy");
            }
            catch (Exception exception) {
                throw new FinderException("Error constructing dummy query while  executing PreparedStatement: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
            }
            map3 = map2;
        } else {
            boolean bl3;
            void var14_33;
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("\nParsing EJBQL for the first time");
            }
            try {
                Class[] classArray;
                if (bl2) {
                    ejbqlFinder = new EjbqlFinder("execute", preparedQuery.getEjbql());
                    ejbqlFinder.setIsSelect(true);
                } else {
                    ejbqlFinder = new EjbqlFinder("find", preparedQuery.getEjbql());
                }
                ejbqlFinder.setIsPreparedQueryFinder(true);
                ejbqlFinder.parseExpression();
                ejbqlFinder.setFinderLoadsBean(this.rbean().getCMPBeanDescriptor().getFindersLoadBean());
                ejbqlFinder.setRDBMSBean(this.rbean());
                if (preparedQuery != null) {
                    classArray = (Class[])preparedQuery;
                    ejbqlFinder.setSqlSelectDistinct(classArray.getSQLSelectDistinct());
                    if (!bl2) {
                        String string2;
                        String string3 = classArray.getRelationshipCachingName();
                        if (string3 != null) {
                            if (this.rbean().getRelationshipCaching(string3) == null) {
                                Loggable loggable = EJBLogger.logInvalidRelationshipCachingNameLoggable((String)string3);
                                throw new FinderException(loggable.getMessage());
                            }
                            ejbqlFinder.setCachingName(string3);
                        }
                        if ((string2 = classArray.getFieldGroupName()) != null) {
                            if (this.rbean().getFieldGroup(string2) == null) {
                                Loggable loggable = EJBLogger.loginvalidFieldGroupNameLoggable((String)string2);
                                throw new FinderException(loggable.getMessage());
                            }
                            ejbqlFinder.setGroupName(string2);
                        }
                    }
                }
                classArray = new Class[map.size()];
                Iterator iterator2 = map.values().iterator();
                boolean bl4 = false;
                while (iterator2.hasNext()) {
                    void var15_42;
                    object5 = iterator2.next();
                    classArray[var15_42] = object5 instanceof EJBObject || object5 instanceof EJBLocalObject ? object5.getClass().getInterfaces()[0] : object5.getClass();
                    if (runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime("parameter class type " + (int)var15_42 + " : set to: " + classArray[var15_42]);
                    }
                    ++var15_42;
                }
                ejbqlFinder.setParameterClassTypes(classArray);
                ejbqlFinder.computeSQLQuery(this.rbean());
            }
            catch (Exception exception) {
                throw new FinderException("Error constructing prepared query: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
            }
            n = this.getUpdateLockType();
            Object var14_26 = null;
            switch (n) {
                case 5: {
                    String string4 = ejbqlFinder.getSQLQueryForUpdateSelective();
                    if (string4 != null) break;
                    if (this.rbean.getUseSelectForUpdate()) {
                        String string5 = ejbqlFinder.getSQLQueryForUpdate();
                        break;
                    }
                    String string6 = ejbqlFinder.getSQLQuery();
                    break;
                }
                case 6: {
                    String string7 = ejbqlFinder.getSQLQueryForUpdate();
                    break;
                }
                case 7: {
                    String string8 = ejbqlFinder.getSQLQueryForUpdateNoWait();
                    break;
                }
                case 4: {
                    String string9 = ejbqlFinder.getSQLQuery();
                    break;
                }
                default: {
                    throw new AssertionError("Undefined update lock value");
                }
            }
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("EJBQL converted to SQL: " + (String)var14_33);
            }
            object = var14_33;
            objectArray[0] = var14_33;
            boolean bl5 = false;
            object5 = ejbqlFinder.getExternalMethodParmList();
            iterator = object5.iterator();
            int n2 = 1;
            while (iterator.hasNext()) {
                object4 = (ParamNode)iterator.next();
                if (((ParamNode)object4).hasCompoundKey()) {
                    serializable = new TreeMap();
                    object3 = ((ParamNode)object4).getParamSubList();
                    int n3 = 1;
                    Iterator iterator3 = object3.iterator();
                    while (iterator3.hasNext()) {
                        object2 = (ParamNode)iterator3.next();
                        string = ((ParamNode)object2).getId();
                        serializable.put(new Integer(n3), new DynamicEJBQLArgumentWrapper(string, ((ParamNode)object2).isOracleNLSDataType()));
                        ++n3;
                    }
                    bl3 = true;
                    map3.put(new Integer(n2), serializable);
                } else {
                    map3.put(new Integer(n2), new DynamicEJBQLArgumentWrapper(((ParamNode)object4).getParamName(), ((ParamNode)object4).isOracleNLSDataType()));
                }
                ++n2;
            }
            if (bl3 && runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("\n-------------------------");
                RDBMSPersistenceManager.debugRuntime("The arguments have a compoundPK, the Flattened argument Map is: \n" + map3);
                RDBMSPersistenceManager.debugRuntime("-------------------------\n");
            }
            objectArray[1] = map3;
        }
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("findersLoadBean: " + this.rbean().getCMPBeanDescriptor().getFindersLoadBean());
            RDBMSPersistenceManager.debugRuntime("isLocal: " + bl);
            RDBMSPersistenceManager.debugRuntime("isResultTypeRemote: " + preparedQuery.isResultTypeRemote());
            RDBMSPersistenceManager.debugRuntime("isSelect: " + bl2);
        }
        ejbqlFinder.setFinderLoadsBean(this.rbean().getCMPBeanDescriptor().getFindersLoadBean());
        if (bl) {
            ejbqlFinder.setResultTypeMapping("Local");
        } else {
            ejbqlFinder.setResultTypeMapping("Remote");
        }
        if (bl && preparedQuery != null && preparedQuery.isResultTypeRemote()) {
            ejbqlFinder.setResultTypeMapping("Remote");
        }
        if (bl2) {
            ejbqlFinder.setReturnClassType(ResultSet.class);
        } else {
            ejbqlFinder.setReturnClassType(Collection.class);
        }
        if (preparedQuery != null && preparedQuery.getIncludeUpdates()) {
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("Flushing modified beans before running the Dyn Query with PrepStmt");
            }
            this.flushModifiedBeans();
        }
        try {
            connection = this.getConnection();
        }
        catch (Exception exception) {
            this.releaseResources(connection, null, null);
            throw new FinderException("Couldn't get connection: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
        }
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("Creating PreparedStatement with sql: " + (String)object);
        }
        try {
            preparedStatement = connection.prepareStatement((String)object);
        }
        catch (Exception exception) {
            this.releaseResources(connection, preparedStatement, null);
            throw new FinderException("Exception in executePreparedQuery while preparing statement: " + preparedStatement + "'\n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
        }
        try {
            if (preparedQuery != null && preparedQuery.getMaxElements() != 0) {
                preparedStatement.setMaxRows(preparedQuery.getMaxElements());
            }
            if (map3 != null) {
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime("arguments have a compound PK");
                }
                n = 1;
                for (Map.Entry entry : map3.entrySet()) {
                    DynamicEJBQLArgumentWrapper dynamicEJBQLArgumentWrapper;
                    int n4 = (Integer)entry.getKey();
                    iterator = entry.getValue();
                    if (iterator instanceof Map) {
                        dynamicEJBQLArgumentWrapper = map.get(new Integer(n4));
                        object4 = ((EJBLocalObject)dynamicEJBQLArgumentWrapper).getPrimaryKey();
                        serializable = object4.getClass();
                        object3 = ((Map)((Object)iterator)).entrySet().iterator();
                    } else {
                        dynamicEJBQLArgumentWrapper = (DynamicEJBQLArgumentWrapper)((Object)iterator);
                        iterator = map.get(new Integer(n4));
                        if (runtimeLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugRuntime("paramIndex: " + n + " binded with value: " + iterator);
                        }
                        if (dynamicEJBQLArgumentWrapper.isOracleNLSDataType()) {
                            this.invokeOracleSetFormOfUse(n, preparedStatement);
                        }
                        if (iterator.getClass().equals(Character.class)) {
                            preparedStatement.setString(n, iterator.toString());
                        } else {
                            preparedStatement.setObject(n, iterator);
                        }
                        ++n;
                        continue;
                    }
                    while (object3.hasNext()) {
                        Map.Entry entry2 = (Map.Entry)object3.next();
                        int n5 = (Integer)entry2.getKey();
                        object2 = (DynamicEJBQLArgumentWrapper)entry2.getValue();
                        string = ((DynamicEJBQLArgumentWrapper)object2).getArgumentName();
                        Field field = ((Class)serializable).getField(string);
                        Object object6 = field.get(object4);
                        if (runtimeLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugRuntime("paramIndex: " + n + " binded with value: " + object6);
                        }
                        if (((DynamicEJBQLArgumentWrapper)object2).isOracleNLSDataType()) {
                            this.invokeOracleSetFormOfUse(n, preparedStatement);
                        }
                        if (object6.getClass().equals(Character.class)) {
                            preparedStatement.setString(n, object6.toString());
                        } else {
                            preparedStatement.setObject(n, object6);
                        }
                        ++n;
                    }
                }
            } else {
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime("arguments do not have a compound PK");
                }
                for (Map.Entry entry : map.entrySet()) {
                    int n6 = (Integer)entry.getKey();
                    object5 = entry.getValue();
                    if (object5 instanceof EJBObject) {
                        object5 = ((EJBObject)object5).getPrimaryKey();
                    }
                    if (object5 instanceof EJBLocalObject) {
                        object5 = ((EJBLocalObject)object5).getPrimaryKey();
                    }
                    if (runtimeLogger.isDebugEnabled()) {
                        RDBMSPersistenceManager.debugRuntime("paramIndex: " + n6 + " binded with value: " + object5);
                    }
                    if (object5.getClass().equals(Character.class)) {
                        preparedStatement.setString(n6, object5.toString());
                        continue;
                    }
                    preparedStatement.setObject(n6, object5);
                }
            }
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            this.releaseResources(connection, preparedStatement, resultSet);
            throw new FinderException("Error in executing PreparedQuery: PreparedStatement: '" + preparedStatement + "'\n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
        }
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("Dynamic Query with PreparedStatement executed ");
        }
        try {
            try {
                Object object7;
                objectArray[2] = object7 = this.getDynamicQueryResult(resultSet, ejbqlFinder, bl, bl2);
                Object[] objectArray2 = objectArray;
                Object var29_65 = null;
                this.releaseResources(connection, preparedStatement, resultSet);
                return objectArray2;
            }
            catch (SQLException sQLException) {
                throw new FinderException("Exception in executePreparedQuery while using result set: '" + resultSet + "'\n" + sQLException.toString() + EOL + RDBMSUtils.throwable2StackTrace(sQLException));
            }
            catch (Exception exception) {
                throw new FinderException("Exception executing executePreparedQuery: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
            }
        }
        catch (Throwable throwable) {
            Object var29_66 = null;
            this.releaseResources(connection, preparedStatement, resultSet);
            throw throwable;
        }
    }

    private void invokeOracleSetFormOfUse(int n, PreparedStatement preparedStatement) throws Exception {
        Method method;
        if ("oracle.jdbc.OraclePreparedStatement".equals(preparedStatement.getClass().getName()) && (method = preparedStatement.getClass().getMethod("setFormOfUse", Integer.TYPE, Short.TYPE)) != null) {
            method.invoke((Object)preparedStatement, n, new Short(2));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object dynamicQuery(String string, WLQueryProperties wLQueryProperties, boolean bl, boolean bl2) throws FinderException {
        Finder finder;
        String string2;
        block23: {
            string2 = null;
            finder = null;
            try {
                if (bl2) {
                    finder = this.createDynamicFinder(string, wLQueryProperties, bl, bl2, ResultSet.class);
                    string2 = finder.getSQLQuery();
                    break block23;
                }
                finder = this.createDynamicFinder(string, wLQueryProperties, bl, bl2, Collection.class);
                int n = this.getUpdateLockType();
                switch (n) {
                    case 5: {
                        string2 = finder.getSQLQueryForUpdateSelective();
                        if (string2 == null) {
                            if (this.rbean.getUseSelectForUpdate()) {
                                string2 = finder.getSQLQueryForUpdate();
                                break;
                            }
                            string2 = finder.getSQLQuery();
                        }
                        break;
                    }
                    case 6: {
                        string2 = finder.getSQLQueryForUpdate();
                        break;
                    }
                    case 7: {
                        string2 = finder.getSQLQueryForUpdateNoWait();
                        break;
                    }
                    case 4: {
                        string2 = finder.getSQLQuery();
                        break;
                    }
                    default: {
                        throw new AssertionError("Undefined update lock value");
                    }
                }
            }
            catch (Exception exception) {
                throw new FinderException("Error constructing query: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
            }
        }
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("Dynamic Query produced statement string " + string2);
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (finder.getIncludeUpdates()) {
            this.flushModifiedBeans();
        }
        try {
            connection = this.getConnection();
        }
        catch (Exception exception) {
            this.releaseResources(connection, preparedStatement, resultSet);
            throw new FinderException("Couldn't get connection: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
        }
        try {
            preparedStatement = connection.prepareStatement(string2);
            if (finder.getMaxElements() != 0) {
                preparedStatement.setMaxRows(finder.getMaxElements());
            }
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            this.releaseResources(connection, preparedStatement, resultSet);
            throw new FinderException("Exception in dynamicQuery while preparing or executing statement: '" + preparedStatement + "'\n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
        }
        try {
            try {
                Object object = this.getDynamicQueryResult(resultSet, finder, bl, bl2);
                Object var12_17 = null;
                this.releaseResources(connection, preparedStatement, resultSet);
                return object;
            }
            catch (SQLException sQLException) {
                throw new FinderException("Exception in dynamicQuery while using result set: '" + resultSet + "'\n" + sQLException.toString() + EOL + RDBMSUtils.throwable2StackTrace(sQLException));
            }
            catch (Exception exception) {
                throw new FinderException("Exception executing dynamicQuery: \n" + exception.toString() + EOL + RDBMSUtils.throwable2StackTrace(exception));
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            this.releaseResources(connection, preparedStatement, resultSet);
            throw throwable;
        }
    }

    public Connection getConnection() throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.getConnection");
        }
        assert (this.ds != null);
        Connection connection = this.ds.getConnection();
        if (connection == null) {
            Loggable loggable = EJBLogger.logCouldNotGetConnectionFromDataSourceLoggable((String)this.dataSourceName);
            throw new SQLException(loggable.getMessage());
        }
        return connection;
    }

    public Connection getConnection(Transaction transaction) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.getConnection");
        }
        assert (this.ds != null);
        Connection connection = this.ds.getConnection();
        if (connection == null) {
            Loggable loggable = EJBLogger.logCouldNotGetConnectionFromDataSourceLoggable((String)this.dataSourceName);
            throw new SQLException(loggable.getMessage());
        }
        return connection;
    }

    public Integer getTransactionIsolationLevel() {
        weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
        if (transaction == null && Thread.currentThread() == EJBRuntimeUtils.getInvokeTxOrThread()) {
            return null;
        }
        return (Integer)((TransactionImpl)transaction).getProperty("ISOLATION LEVEL");
    }

    public Transaction suspendTransaction() throws PersistenceRuntimeException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("suspendTransaction");
        }
        if (TxHelper.getTransaction() == null && Thread.currentThread() == EJBRuntimeUtils.getInvokeTxOrThread()) {
            return null;
        }
        assert (this.tm != null);
        assert (TxHelper.getTransaction() != null);
        try {
            return this.tm.suspend();
        }
        catch (Exception exception) {
            throw new PersistenceRuntimeException(exception);
        }
    }

    public void resumeTransaction(Transaction transaction) throws PersistenceRuntimeException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("resumeTransaction");
        }
        if (transaction == null) {
            return;
        }
        assert (this.tm != null);
        assert (transaction != null);
        try {
            this.tm.resume(transaction);
        }
        catch (Exception exception) {
            throw new PersistenceRuntimeException(exception);
        }
    }

    public boolean needsBatchOperationsWorkaround() {
        return this.isOptimistic && this.databaseType == 1 && this.enableBatchOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perhapsUseSendBatchForOracle() {
        boolean bl;
        block8: {
            bl = false;
            Connection connection = null;
            try {
                block7: {
                    try {
                        connection = this.getConnection();
                        if (!this.driverName.equalsIgnoreCase(ORACLE_JDBC_DRIVER_NAME) || !"oracle.jdbc.OracleConnection".equals(connection.getClass().getName())) break block7;
                        bl = true;
                    }
                    catch (SQLException sQLException) {
                        if (deploymentLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugDeployment("SQLException while checking for sendBatch API usage:" + sQLException.getMessage());
                        }
                        Object var5_4 = null;
                        this.releaseResources(connection, null, null);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        if (deploymentLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugDeployment("Exception while checking for sendBatch API usage:" + throwable.getMessage());
                        }
                        Object var5_5 = null;
                        this.releaseResources(connection, null, null);
                    }
                }
                Object var5_3 = null;
                this.releaseResources(connection, null, null);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.releaseResources(connection, null, null);
                throw throwable;
            }
        }
        return this.isOptimistic && this.databaseType == 1 && this.enableBatchOperations && bl;
    }

    public int[] getVerifyCount() {
        return (int[])this.verifyCount.clone();
    }

    public int[] getVerifyCur() {
        return (int[])this.verifyCur.clone();
    }

    public StringBuffer[] getVerifySql(boolean bl) {
        StringBuffer[] stringBufferArray = new StringBuffer[this.verifyText.length];
        if (bl) {
            for (int i = 0; i < stringBufferArray.length; ++i) {
                stringBufferArray[i] = new StringBuffer(this.verifyTextWithXLock[i]);
            }
        } else {
            for (int i = 0; i < stringBufferArray.length; ++i) {
                stringBufferArray[i] = new StringBuffer(this.verifyText[i]);
            }
        }
        return stringBufferArray;
    }

    public PreparedStatement[] prepareStatement(Connection connection, StringBuffer[] stringBufferArray, int[] nArray, boolean bl) throws SQLException {
        PreparedStatement[] preparedStatementArray = new PreparedStatement[stringBufferArray.length];
        for (int i = 0; i < stringBufferArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("prepareStatement: sql=" + stringBufferArray[i].toString());
            }
            if (bl && this.selectForUpdateSupported && this.databaseType != 2 && this.databaseType != 7) {
                stringBufferArray[i].append(" FOR UPDATE");
            }
            preparedStatementArray[i] = connection.prepareStatement(stringBufferArray[i].toString());
        }
        return preparedStatementArray;
    }

    public ResultSet[] executeQuery(PreparedStatement[] preparedStatementArray) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[preparedStatementArray.length];
        for (int i = 0; i < resultSetArray.length; ++i) {
            if (preparedStatementArray[i] == null) continue;
            resultSetArray[i] = preparedStatementArray[i].executeQuery();
        }
        return resultSetArray;
    }

    public void checkResults(ResultSet[] resultSetArray, int[] nArray) throws SQLException, OptimisticConcurrencyException {
        for (int i = 0; i < resultSetArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            int n = 0;
            while (resultSetArray[i].next()) {
                ++n;
            }
            if (n == nArray[i]) continue;
            Loggable loggable = EJBLogger.logoptimisticUpdateFailedLoggable((String)this.ejbName, (String)"<unknown>");
            throw new OptimisticConcurrencyException(loggable.getMessage());
        }
    }

    public String getSnapshotPredicate(int n) {
        return this.snapshotStrings[n];
    }

    public String getSnapshotPredicate(int n, Object object) {
        assert (this.nullSnapshotStrings[n] != null);
        assert (this.snapshotStrings[n] != null);
        if (object == null) {
            return this.nullSnapshotStrings[n];
        }
        return this.snapshotStrings[n];
    }

    private void verifyDatabaseType() throws WLDeploymentException {
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                this.databaseType = this.verifier.verifyDatabaseType(connection, this.databaseType);
                this.rbean.setDatabaseType(this.databaseType);
            }
            catch (Exception exception) {
                throw new WLDeploymentException(exception.getMessage());
            }
            Object var4_2 = null;
            this.releaseResources(connection, null, null);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseResources(connection, null, null);
            throw throwable;
        }
    }

    private void verifyTXDataSource() throws WLDeploymentException {
        if (this.ds instanceof DataSourceMetaData) {
            if (((DataSourceMetaData)this.ds).isTxDataSource()) {
                return;
            }
            Loggable loggable = EJBLogger.logcmpBeanMustHaveTXDataSourceSpecifiedLoggable((String)this.dataSourceName, (String)this.ejbName);
            throw new WLDeploymentException(loggable.getMessage());
        }
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                if (connection.getAutoCommit()) {
                    Loggable loggable = EJBLogger.logcmpBeanMustHaveTXDataSourceSpecifiedLoggable((String)this.dataSourceName, (String)this.ejbName);
                    throw new WLDeploymentException(loggable.getMessage());
                }
                Object var4_5 = null;
                this.releaseResources(connection, null, null);
            }
            catch (SQLException sQLException) {
                throw new WLDeploymentException(sQLException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.releaseResources(connection, null, null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyBatchUpdatesSupported() {
        boolean bl;
        block11: {
            if (!this.enableBatchOperations) {
                return;
            }
            bl = false;
            Connection connection = null;
            try {
                try {
                    connection = this.getConnection();
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    bl = databaseMetaData.supportsBatchUpdates();
                }
                catch (SQLException sQLException) {
                    bl = false;
                    Object var5_7 = null;
                    this.releaseResources(connection, null, null);
                    break block11;
                }
                catch (AbstractMethodError abstractMethodError) {
                    bl = false;
                    Object var5_8 = null;
                    this.releaseResources(connection, null, null);
                }
                Object var5_6 = null;
                this.releaseResources(connection, null, null);
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.releaseResources(connection, null, null);
                throw throwable;
            }
        }
        if (deploymentLogger.isDebugEnabled()) {
            if (!bl) {
                RDBMSPersistenceManager.debugDeployment("The database or JDBC driver doesn't support batch update.");
            } else {
                RDBMSPersistenceManager.debugDeployment("The database or JDBC driver supports batch update.");
            }
        }
        if (this.orderDatabaseOperations && this.enableBatchOperations) {
            this.orderDatabaseOperations = bl;
            this.enableBatchOperations = bl;
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment("The orderDatabaseOperations and enableBatchOperations are set to " + bl);
            }
        }
    }

    public boolean getEnableBatchOperations() {
        return this.enableBatchOperations;
    }

    public boolean getOrderDatabaseOperations() {
        return this.orderDatabaseOperations;
    }

    public boolean setParamNull(PreparedStatement preparedStatement, int n, Object object, String string) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.setParamNull");
        }
        if (object == null) {
            assert (this.variable2SQLType != null);
            assert (this.variable2SQLType.get(string) != null) : "No field->SQLType mapping for field " + string;
            Integer n2 = (Integer)this.variable2SQLType.get(string);
            int n3 = n2;
            if (runtimeLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugRuntime("setting field- " + string + " null (" + n + ", " + RDBMSUtils.sqlTypeToString(n3) + ")");
            }
            if (n3 != 2007) {
                preparedStatement.setNull(n, n3);
            } else {
                preparedStatement.setNull(n, 2007, "XMLTYPE");
            }
            return true;
        }
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("field- " + string + " is not null.");
        }
        return false;
    }

    public Object getNextSequenceKey() throws EJBException {
        return this.getNextGenKeyPreFetch(2);
    }

    public Object getNextSequenceTableKey() throws EJBException {
        return this.getNextGenKeyPreFetch(3);
    }

    public synchronized Object getNextGenKeyPreFetch(int n) throws EJBException {
        if (this.genKeyCurrCacheSize <= 0) {
            switch (this.genKeyPKFieldClassType) {
                case 0: {
                    if (n == 2) {
                        this.genKeyCurrValueInt = (Integer)this.execGenKeyQuery();
                    } else if (n == 3) {
                        this.genKeyCurrValueInt = (Integer)this.execGenKeySequenceTableUpdateAndQuery();
                    } else {
                        throw new EJBException(" Internal Error, unknown genKeyType: " + n);
                    }
                    if (!runtimeLogger.isDebugEnabled()) break;
                    RDBMSPersistenceManager.debugRuntime("  refresh Key Cache.  New Value: " + this.genKeyCurrValueInt);
                    break;
                }
                case 1: {
                    if (n == 2) {
                        this.genKeyCurrValueLong = (Long)this.execGenKeyQuery();
                    } else if (n == 3) {
                        this.genKeyCurrValueLong = (Long)this.execGenKeySequenceTableUpdateAndQuery();
                    } else {
                        throw new EJBException(" Internal Error, unknown genKeyType: " + n);
                    }
                    if (!runtimeLogger.isDebugEnabled()) break;
                    RDBMSPersistenceManager.debugRuntime("  refresh Key Cache.  New Value: " + this.genKeyCurrValueLong);
                    break;
                }
                default: {
                    throw new EJBException(" Internal Error, unknown genKeyPKFieldClassType: " + this.genKeyPKFieldClassType);
                }
            }
            this.genKeyCurrCacheSize = this.genKeyCacheSize;
        }
        if (--this.genKeyCurrCacheSize < 0) {
            if (this.genKeyPKFieldClassType == 0) {
                this.genKeyCurrValueLong = this.genKeyCurrValueInt;
            }
            throw new EJBException("Error in auto PK generator key caching  genKeyCurrCacheSize = " + this.genKeyCurrCacheSize + "  is less than zero !   " + "genKeyCurrVal Integer/Long = " + this.genKeyCurrValueLong + ", genKeyCacheSize = " + this.genKeyCacheSize);
        }
        switch (this.genKeyPKFieldClassType) {
            case 0: {
                return new Integer(this.genKeyCurrValueInt++);
            }
            case 1: {
                return new Long(this.genKeyCurrValueLong++);
            }
        }
        throw new EJBException(" Internal Error, unknown genKeyPKFieldClassType: " + this.genKeyPKFieldClassType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object execGenKeyQuery() throws EJBException {
        Long l;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(this.genKeyWLGeneratorQuery);
                if (!resultSet.next()) {
                    Loggable loggable = EJBLogger.logExecGenKeyErrorLoggable((String)this.genKeyWLGeneratorQuery);
                    throw new EJBException(loggable.getMessage());
                }
                switch (this.genKeyPKFieldClassType) {
                    case 0: {
                        Integer n = new Integer(resultSet.getInt(1));
                        Object var8_9 = null;
                        this.releaseResources(connection, statement, resultSet);
                        return n;
                    }
                    case 1: {
                        l = new Long(resultSet.getLong(1));
                        break;
                    }
                    default: {
                        throw new EJBException(" Internal Error, unknown genKeyPKFieldClassType: " + this.genKeyPKFieldClassType);
                    }
                }
            }
            catch (SQLException sQLException) {
                EJBException eJBException = new EJBException(sQLException.getMessage());
                throw eJBException;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.releaseResources(connection, statement, resultSet);
            throw throwable;
        }
        Object var8_10 = null;
        this.releaseResources(connection, statement, resultSet);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Object execGenKeySequenceTableUpdateAndQuery() throws EJBException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl2 = false;
        weblogic.transaction.Transaction transaction2 = null;
        Transaction transaction = null;
        try {
            boolean bl;
            Number number;
            block36: {
                try {
                    Number number2;
                    weblogic.transaction.TransactionManager transactionManager = TxHelper.getTransactionManager();
                    transaction2 = TxHelper.getTransaction();
                    try {
                        transactionManager.suspend();
                        if (runtimeLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugRuntime("execGenKeySequenceTableUpdateAndQuery: suspended Caller TX");
                        }
                        int n = 120000;
                        if (this.transactionTimeoutMS <= 0) {
                            if (runtimeLogger.isDebugEnabled()) {
                                RDBMSPersistenceManager.debugRuntime("execGenKeySequenceTableUpdateAndQuery:  WARNING !  transactionTimeoutMS = " + this.transactionTimeoutMS + " forcing to " + n);
                            }
                            this.transactionTimeoutMS = n;
                        }
                        transactionManager.setTransactionTimeout(this.transactionTimeoutMS / 1000);
                        transactionManager.begin();
                        transaction = transactionManager.getTransaction();
                        if (runtimeLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugRuntime("execGenKeySequenceTableUpdateAndQuery: began and obtained new Local TX for UPDATE and QUERY");
                        }
                        ((weblogic.transaction.Transaction)transaction).setProperty("LOCAL_ENTITY_TX", (Serializable)((Object)"true"));
                    }
                    catch (Exception exception) {
                        try {
                            transactionManager.resume((Transaction)transaction2);
                        }
                        catch (Exception exception2) {
                            if (runtimeLogger.isDebugEnabled()) {
                                RDBMSPersistenceManager.debugRuntime("execGenKeySequenceTableUpdateAndQuery:  Error encountered while attempting to Resume caller's TX.  Do forceResume of Caller's TX after encountering Exception: " + exception2.getMessage());
                            }
                            transactionManager.forceResume((Transaction)transaction2);
                        }
                        Loggable loggable = EJBLogger.logGenKeySequenceTableNewTxFailureLoggable((String)exception.getMessage());
                        throw new EJBException(loggable.getMessage());
                    }
                    connection = this.getConnection();
                    statement = connection.createStatement();
                    String string = this.genKeyWLGeneratorUpdate;
                    try {
                        int n = statement.executeUpdate(string);
                        if (n < 1) {
                            Loggable loggable = EJBLogger.logExecGenKeyErrorLoggable((String)string);
                            throw new EJBException(loggable.getMessage());
                        }
                        resultSet = statement.executeQuery(this.genKeyWLGeneratorQuery);
                        if (!resultSet.next()) {
                            Loggable loggable = EJBLogger.logExecGenKeyErrorLoggable((String)this.genKeyWLGeneratorQuery);
                            throw new EJBException(loggable.getMessage());
                        }
                        switch (this.genKeyPKFieldClassType) {
                            case 0: {
                                if (this.selectFirstSeqKeyBeforeUpdate) {
                                    number2 = new Integer(resultSet.getInt(1) - this.genKeyCacheSize + 1);
                                    break;
                                }
                                number2 = new Integer(resultSet.getInt(1));
                                break;
                            }
                            case 1: {
                                if (this.selectFirstSeqKeyBeforeUpdate) {
                                    number2 = new Long(resultSet.getLong(1) - (long)this.genKeyCacheSize + 1L);
                                    break;
                                }
                                number2 = new Long(resultSet.getLong(1));
                                break;
                            }
                            default: {
                                throw new EJBException(" Internal Error, unknown genKeyPKFieldClassType: " + this.genKeyPKFieldClassType);
                            }
                        }
                    }
                    catch (Exception exception) {
                        Loggable loggable = EJBLogger.logGenKeySequenceTableUpdateFailureLoggable((String)this.genKeyGeneratorName, (String)exception.toString());
                        throw new SQLException(loggable.getMessage());
                    }
                    try {
                        transaction.commit();
                    }
                    catch (Exception exception) {
                        Loggable loggable = EJBLogger.logGenKeySequenceTableLocalCommitFailureLoggable((String)this.genKeyGeneratorName, (String)exception.getMessage());
                        throw new SQLException(loggable.getMessage());
                    }
                    number = number2;
                    Object var13_24 = null;
                    bl = false;
                    if (transaction2 == null || transaction == null) break block36;
                }
                catch (SQLException sQLException) {
                    if (transaction == null) throw new EJBException((Exception)sQLException);
                    try {
                        transaction.rollback();
                        throw new EJBException((Exception)sQLException);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new EJBException((Exception)sQLException);
                }
                try {
                    try {
                        if (runtimeLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugRuntime("execGenKeySequenceTableUpdateAndQuery: in finally: Now resume Caller TX");
                        }
                        EJBRuntimeUtils.resumeCallersTransaction((Transaction)transaction2, transaction);
                    }
                    catch (InternalException internalException) {
                        Loggable loggable = EJBLogger.logGenKeySequenceTableTxResumeFailureLoggable((String)this.genKeyGeneratorName, (String)internalException.getMessage());
                        throw new EJBException(loggable.getMessage());
                    }
                    Object var18_28 = null;
                    this.releaseResources(connection, statement, resultSet);
                    bl = true;
                }
                catch (Throwable throwable) {
                    Object var18_29 = null;
                    this.releaseResources(connection, statement, resultSet);
                    bl = true;
                    throw throwable;
                }
            }
            if (bl) return number;
            this.releaseResources(connection, statement, resultSet);
            return number;
        }
        catch (Throwable throwable) {
            Object var13_25 = null;
            boolean bl3 = false;
            if (transaction2 != null && transaction != null) {
                try {}
                catch (Throwable throwable2) {
                    Object var18_31 = null;
                    this.releaseResources(connection, statement, resultSet);
                    bl3 = true;
                    throw throwable2;
                }
                try {}
                catch (InternalException internalException) {
                    Loggable loggable = EJBLogger.logGenKeySequenceTableTxResumeFailureLoggable((String)this.genKeyGeneratorName, (String)internalException.getMessage());
                    throw new EJBException(loggable.getMessage());
                }
                if (runtimeLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugRuntime("execGenKeySequenceTableUpdateAndQuery: in finally: Now resume Caller TX");
                }
                EJBRuntimeUtils.resumeCallersTransaction((Transaction)transaction2, transaction);
                Object var18_30 = null;
                this.releaseResources(connection, statement, resultSet);
                bl3 = true;
            }
            if (bl3) throw throwable;
            this.releaseResources(connection, statement, resultSet);
            bl3 = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeyCacheSize(int n) {
        if (this.genKeyType == 3) {
            if (n <= 0) {
                n = 10;
            }
            RDBMSPersistenceManager rDBMSPersistenceManager = this;
            synchronized (rDBMSPersistenceManager) {
                this.genKeyCacheSize = n;
                this.genKeyWLGeneratorUpdate = this.genKeyWLGeneratorUpdatePrefix + this.genKeyCacheSize;
            }
        }
    }

    public String getGenKeySequenceDBColType() {
        return "DECIMAL";
    }

    public int getUpdateLockType() {
        if (this.isOptimistic) {
            return 4;
        }
        try {
            Transaction transaction = this.tm.getTransaction();
            TransactionImpl transactionImpl = (TransactionImpl)transaction;
            if (transactionImpl == null) {
                return 5;
            }
            Integer n = (Integer)transactionImpl.getProperty("ISOLATION LEVEL");
            if (n != null && n == 8) {
                return 4;
            }
            n = (Integer)transactionImpl.getProperty("SELECT_FOR_UPDATE");
            if (n == null) {
                return 5;
            }
            if (n == 1) {
                return 6;
            }
            if (n == 2) {
                return 7;
            }
            return 5;
        }
        catch (Exception exception) {
            throw new PersistenceRuntimeException(exception);
        }
    }

    public int getSelectForUpdateValue() {
        if (this.isOptimistic) {
            return 0;
        }
        try {
            Transaction transaction = this.tm.getTransaction();
            TransactionImpl transactionImpl = (TransactionImpl)transaction;
            Integer n = null;
            if (transactionImpl != null) {
                n = (Integer)transactionImpl.getProperty("SELECT_FOR_UPDATE");
            }
            if (n == null) {
                return 0;
            }
            return n;
        }
        catch (Exception exception) {
            throw new PersistenceRuntimeException(exception);
        }
    }

    public String selectForUpdate() {
        return RDBMSUtils.selectForUpdateToString(this.getSelectForUpdateValue());
    }

    public String selectForUpdateOrForUpdateNowait() {
        try {
            Transaction transaction = this.tm.getTransaction();
            TransactionImpl transactionImpl = (TransactionImpl)transaction;
            Integer n = null;
            if (transactionImpl != null) {
                n = (Integer)transactionImpl.getProperty("SELECT_FOR_UPDATE");
            }
            if (n == null) {
                return " FOR UPDATE ";
            }
            switch (n) {
                case 2: {
                    return " FOR UPDATE NOWAIT ";
                }
            }
            return " FOR UPDATE ";
        }
        catch (Exception exception) {
            throw new PersistenceRuntimeException(exception);
        }
    }

    public void disableTransactionStatusCheck() {
        try {
            this.beanManager.disableTransactionStatusCheck();
        }
        catch (Exception exception) {
            throw new PersistenceRuntimeException(exception);
        }
    }

    public void enableTransactionStatusCheck() {
        try {
            this.beanManager.enableTransactionStatusCheck();
        }
        catch (Exception exception) {
            throw new PersistenceRuntimeException(exception);
        }
    }

    public void registerModifiedBean(Object object) {
        try {
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            this.beanManager.registerModifiedBean(object, transaction);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void registerInvalidatedBean(Object object) {
        try {
            Object object2 = null;
            object2 = TxHelper.getTransactionManager().getTransaction();
            if (object2 == null) {
                object2 = Thread.currentThread();
            }
            this.beanManager.registerInvalidatedBean(object, object2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void unregisterModifiedBean(Object object) {
        try {
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            this.beanManager.unregisterModifiedBean(object, transaction);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void flushModifiedBeans() {
        try {
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            this.beanManager.flushModifiedBeans(transaction);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void registerM2NJoinTableInsert(String string, Object object) {
        try {
            Transaction transaction = TxHelper.getTransactionManager().getTransaction();
            this.beanManager.registerM2NJoinTableInsert(string, object, transaction);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void releaseResources(Connection connection, Statement statement, ResultSet resultSet) {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.releaseResources");
        }
        try {
            this.releaseResultSet(resultSet);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.releaseStatement(statement);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.releaseConnection(connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void releaseArrayResources(Connection connection, Statement[] statementArray, ResultSet[] resultSetArray) {
        int n;
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.releaseResources");
        }
        if (resultSetArray != null) {
            for (n = 0; n < resultSetArray.length; ++n) {
                try {
                    this.releaseResultSet(resultSetArray[n]);
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        if (statementArray != null) {
            for (n = 0; n < statementArray.length; ++n) {
                try {
                    this.releaseStatement(statementArray[n]);
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        try {
            this.releaseConnection(connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void releaseConnection(Connection connection) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.releaseConnection");
        }
        if (connection != null) {
            connection.close();
        }
    }

    public void releaseStatement(PreparedStatement preparedStatement) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.releaseStatement");
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
    }

    public void releaseStatement(Statement statement) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.releaseStatement");
        }
        if (statement != null) {
            statement.close();
        }
    }

    public void releaseResultSet(ResultSet resultSet) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugRuntime("RDBMSPersistenceManager.releaseResultSet");
        }
        if (resultSet != null) {
            resultSet.close();
        }
    }

    public boolean createDefaultDBMSTable(String string) throws WLDeploymentException {
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + string + " (");
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                if (!this.getSequenceTableColumns(string, stringBuffer) && !this.getBeanOrJoinTableColumns(string, stringBuffer)) {
                    throw new RDBMSException(" Unknown Error while attempting to get DB Columns for table '" + string + "'");
                }
                stringBuffer.append(",");
                stringBuffer.append("WLS_TEMP");
                stringBuffer.append(" int");
                if (this.databaseType == 5) {
                    stringBuffer.append(" NULL ");
                }
                stringBuffer.append(" )");
                String string2 = stringBuffer.toString();
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment(" full DEFAULT TABLE CREATE QUERY: '" + string2 + "'");
                }
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(string2);
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorCreatingDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                loggable.log();
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var8_7 = null;
            this.releaseResources(connection, statement, null);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseResources(connection, statement, null);
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAndCreateDefaultDBMSTable(String string) throws WLDeploymentException {
        StringBuffer stringBuffer = new StringBuffer("DROP TABLE " + string);
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Object var7_6 = null;
                this.releaseResources(connection, statement, null);
            }
            Object var7_5 = null;
            this.releaseResources(connection, statement, null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseResources(connection, statement, null);
            throw throwable;
        }
        this.createDefaultDBMSTable(string);
    }

    public void alterDefaultDBMSTable(String string, Set set, Set set2) throws WLDeploymentException {
        if (set.isEmpty() && set2.isEmpty()) {
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment("Table not changed so no alter table");
            }
            return;
        }
        switch (this.databaseType) {
            case 1: {
                this.alterOracleDefaultDBMSTable(string, set, set2);
                break;
            }
            case 2: 
            case 7: {
                this.alterMSSqlServerDefaultDBMSTable(string, set, set2);
                break;
            }
            case 5: {
                Loggable loggable = EJBLogger.logalterTableNotSupportedLoggable((String)"Sybase");
                loggable.log();
                throw new WLDeploymentException(loggable.getMessage());
            }
            case 3: {
                this.alterInformixDefaultDBMSTable(string, set, set2);
                break;
            }
            case 4: {
                Loggable loggable = EJBLogger.logalterTableNotSupportedLoggable((String)"DB2");
                loggable.log();
                throw new WLDeploymentException(loggable.getMessage());
            }
            case 6: {
                this.alterPointbaseDefaultDBMSTable(string, set, set2);
                break;
            }
            case 8: {
                this.alterMySQLDefaultDBMSTable(string, set, set2);
                break;
            }
            default: {
                this.alterOracleDefaultDBMSTable(string, set, set2);
            }
        }
    }

    private void alterPointbaseDefaultDBMSTable(String string, Set set, Set set2) throws WLDeploymentException {
        Set set3 = this.createPrimaryKeyCols(string);
        boolean bl = this.isAnyNewColAPKCol(set3, set);
        if (set3.size() > 1 && bl) {
            EJBLogger.logalterTableNotSupportedForPointbaseLoggable();
            return;
        }
        this.addPointbaseColumns(string, set, set3, bl);
        this.removePointbaseColumns(string, set2);
        this.dropMSSqlServerPrimaryKeyConstraint(string);
        this.createMSSqlServerPrimaryKeyConstraint(string);
    }

    private boolean isAnyNewColAPKCol(Set set, Set set2) {
        for (String string : set2) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    private List getOldPrimaryKeys(Connection connection, String string) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, string.toUpperCase(Locale.ENGLISH));
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("COLUMN_NAME"));
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addPointbaseColumns(String string, Set set, Set set2, boolean bl) throws WLDeploymentException {
        Statement statement;
        Connection connection;
        block12: {
            block11: {
                connection = null;
                statement = null;
                try {
                    try {
                        connection = this.getConnection();
                        List list = null;
                        boolean bl2 = false;
                        if (bl && (list = this.getOldPrimaryKeys(connection, string)) != null) {
                            if (list.size() > 1) {
                                EJBLogger.logalterTableNotSupportedForPointbaseLoggable();
                                Object var13_11 = null;
                                this.releaseResources(connection, statement, null);
                                return;
                            }
                            if (list.size() == 1) {
                                bl2 = true;
                            }
                        }
                        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
                        if (set.isEmpty()) break block11;
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            stringBuffer.append("add  ");
                            String string2 = (String)iterator.next();
                            stringBuffer.append(string2 + " " + this.getSqltypeForCol(string, string2));
                            if (bl && set2.contains(string2) && bl2) {
                                stringBuffer.append(" DEFAULT '" + list.get(0) + "' NOT NULL ");
                            }
                            if (!iterator.hasNext()) continue;
                            stringBuffer.append(",");
                        }
                        if (deploymentLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugDeployment("The alter table command is ..." + stringBuffer);
                        }
                        statement = connection.createStatement();
                        statement.executeUpdate(stringBuffer.toString());
                        break block12;
                    }
                    catch (Exception exception) {
                        Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                        loggable.log();
                        throw new WLDeploymentException(loggable.getMessage(), exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    this.releaseResources(connection, statement, null);
                    throw throwable;
                }
            }
            Object var13_12 = null;
            this.releaseResources(connection, statement, null);
            return;
        }
        Object var13_13 = null;
        this.releaseResources(connection, statement, null);
    }

    private void removePointbaseColumns(String string, Set set) throws WLDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
        if (!set.isEmpty()) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                stringBuffer.append("drop  ");
                object = (String)object2.next();
                stringBuffer.append((String)object);
                if (!object2.hasNext()) continue;
                stringBuffer.append(",");
            }
        } else {
            return;
        }
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("The alter table command is ..." + stringBuffer);
        }
        object2 = null;
        object = null;
        try {
            try {
                object2 = this.getConnection();
                object = object2.createStatement();
                object.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var9_6 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
            throw throwable;
        }
    }

    private void alterMySQLDefaultDBMSTable(String string, Set set, Set set2) throws WLDeploymentException {
        Set set3 = this.createPrimaryKeyCols(string);
        boolean bl = this.isAnyNewColAPKCol(set3, set);
        if (set3.size() > 1 && bl) {
            EJBLogger.logalterTableNotSupportedForPointbaseLoggable();
            return;
        }
        this.addMySQLColumns(string, set, set3, bl);
        this.removeMySQLColumns(string, set2);
        this.dropMSSqlServerPrimaryKeyConstraint(string);
        this.createMSSqlServerPrimaryKeyConstraint(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addMySQLColumns(String string, Set set, Set set2, boolean bl) throws WLDeploymentException {
        Statement statement;
        Connection connection;
        block12: {
            block11: {
                connection = null;
                statement = null;
                try {
                    try {
                        connection = this.getConnection();
                        List list = null;
                        boolean bl2 = false;
                        if (bl && (list = this.getOldPrimaryKeys(connection, string)) != null) {
                            if (list.size() > 1) {
                                EJBLogger.logalterTableNotSupportedForPointbaseLoggable();
                                Object var13_11 = null;
                                this.releaseResources(connection, statement, null);
                                return;
                            }
                            if (list.size() == 1) {
                                bl2 = true;
                            }
                        }
                        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
                        if (set.isEmpty()) break block11;
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            stringBuffer.append("add column ");
                            stringBuffer.append(string2 + " " + this.getSqltypeForCol(string, string2));
                            if (bl && set2.contains(string2) && bl2) {
                                stringBuffer.append(" DEFAULT '" + list.get(0) + "' NOT NULL ");
                            }
                            if (!iterator.hasNext()) continue;
                            stringBuffer.append(",");
                        }
                        if (deploymentLogger.isDebugEnabled()) {
                            RDBMSPersistenceManager.debugDeployment("The alter table command is ..." + stringBuffer);
                        }
                        statement = connection.createStatement();
                        statement.executeUpdate(stringBuffer.toString());
                        break block12;
                    }
                    catch (Exception exception) {
                        Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                        loggable.log();
                        throw new WLDeploymentException(loggable.getMessage(), exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    this.releaseResources(connection, statement, null);
                    throw throwable;
                }
            }
            Object var13_12 = null;
            this.releaseResources(connection, statement, null);
            return;
        }
        Object var13_13 = null;
        this.releaseResources(connection, statement, null);
    }

    private void removeMySQLColumns(String string, Set set) throws WLDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
        if (!set.isEmpty()) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append("drop column ");
                stringBuffer.append((String)object);
                if (!object2.hasNext()) continue;
                stringBuffer.append(",");
            }
        } else {
            return;
        }
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("The alter table command is ..." + stringBuffer);
        }
        object2 = null;
        object = null;
        try {
            try {
                object2 = this.getConnection();
                object = object2.createStatement();
                object.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var9_6 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
            throw throwable;
        }
    }

    private void alterMSSqlServerDefaultDBMSTable(String string, Set set, Set set2) throws WLDeploymentException {
        this.dropMSSqlServerPrimaryKeyConstraint(string);
        this.addMSSqlServerColumns(string, set);
        this.removeMSSqlServerColumns(string, set2);
        this.createMSSqlServerPrimaryKeyConstraint(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropMSSqlServerPrimaryKeyConstraint(String string) throws WLDeploymentException {
        StringBuffer stringBuffer = new StringBuffer("alter table ");
        stringBuffer.append(string);
        stringBuffer.append(" drop CONSTRAINT pk_" + string);
        Connection connection = null;
        Statement statement = null;
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("the alter table command is .." + stringBuffer);
        }
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Object var7_6 = null;
                this.releaseResources(connection, statement, null);
            }
            Object var7_5 = null;
            this.releaseResources(connection, statement, null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseResources(connection, statement, null);
            throw throwable;
        }
    }

    private void createMSSqlServerPrimaryKeyConstraint(String string) throws WLDeploymentException {
        Set set = this.createPrimaryKeyCols(string);
        if (set.size() > 0) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer("alter table ");
            stringBuffer.append(string);
            stringBuffer.append(" add constraint pk_" + string + " PRIMARY KEY(");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuffer.append((String)object);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment("the alter table command is .." + stringBuffer);
            }
            object = null;
            Statement statement = null;
            try {
                try {
                    object = this.getConnection();
                    statement = object.createStatement();
                    statement.executeUpdate(stringBuffer.toString());
                }
                catch (Exception exception) {
                    Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                    loggable.log();
                    throw new WLDeploymentException(loggable.getMessage(), exception);
                }
                Object var10_7 = null;
                this.releaseResources((Connection)object, statement, null);
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.releaseResources((Connection)object, statement, null);
                throw throwable;
            }
        }
    }

    private void removeMSSqlServerColumns(String string, Set set) throws WLDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
        if (!set.isEmpty()) {
            stringBuffer.append("drop column ");
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append((String)object);
                if (!object2.hasNext()) continue;
                stringBuffer.append(",");
            }
        } else {
            return;
        }
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("The alter table command is ..." + stringBuffer);
        }
        object2 = null;
        object = null;
        try {
            try {
                object2 = this.getConnection();
                object = object2.createStatement();
                object.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var9_6 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
            throw throwable;
        }
    }

    private void addMSSqlServerColumns(String string, Set set) throws WLDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
        if (!set.isEmpty()) {
            stringBuffer.append("add  ");
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append((String)object + " " + this.getSqltypeForCol(string, (String)object));
                if (!object2.hasNext()) continue;
                stringBuffer.append(",");
            }
        } else {
            return;
        }
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("The alter table command is ..." + stringBuffer);
        }
        object2 = null;
        object = null;
        try {
            try {
                object2 = this.getConnection();
                object = object2.createStatement();
                object.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var9_6 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
            throw throwable;
        }
    }

    private void alterInformixDefaultDBMSTable(String string, Set set, Set set2) throws WLDeploymentException {
        this.addOracleColumns(string, set);
        this.removeOracleColumns(string, set2);
        this.alterInformixPrimaryKeyConstraints(string);
    }

    private void alterOracleDefaultDBMSTable(String string, Set set, Set set2) throws WLDeploymentException {
        this.addOracleColumns(string, set);
        this.removeOracleColumns(string, set2);
        this.alterPrimaryKeyConstraints(string, set, set2);
    }

    private void alterInformixPrimaryKeyConstraints(String string) throws WLDeploymentException {
        Set set = this.createPrimaryKeyCols(string);
        if (set.size() > 0) {
            this.createInformixPrimaryKeyConstraint(string, set);
        }
    }

    private void createInformixPrimaryKeyConstraint(String string, Set set) throws WLDeploymentException {
        if (set.size() > 0) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer("alter table ");
            stringBuffer.append(string);
            stringBuffer.append(" add constraint PRIMARY KEY (");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuffer.append((String)object);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(") CONSTRAINT pk_" + string);
            object = null;
            Statement statement = null;
            try {
                try {
                    object = this.getConnection();
                    statement = object.createStatement();
                    statement.executeUpdate(stringBuffer.toString());
                }
                catch (Exception exception) {
                    Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                    throw new WLDeploymentException(loggable.getMessage(), exception);
                }
                Object var10_7 = null;
                this.releaseResources((Connection)object, statement, null);
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.releaseResources((Connection)object, statement, null);
                throw throwable;
            }
        }
    }

    private void alterPrimaryKeyConstraints(String string, Set set, Set set2) throws WLDeploymentException {
        Set set3 = this.createPrimaryKeyCols(string);
        if (set3.size() > 0) {
            this.dropOraclePrimaryKeyConstraint(string);
            this.createOraclePrimaryKeyConstraint(string, set3);
        }
    }

    private void createOraclePrimaryKeyConstraint(String string, Set set) throws WLDeploymentException {
        if (set.size() > 0) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer("alter table ");
            stringBuffer.append(string);
            stringBuffer.append(" add constraint pk_" + string + " PRIMARY KEY(");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuffer.append((String)object);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment("The alter command is ..." + stringBuffer.toString());
            }
            object = null;
            Statement statement = null;
            try {
                try {
                    object = this.getConnection();
                    statement = object.createStatement();
                    statement.executeUpdate(stringBuffer.toString());
                }
                catch (Exception exception) {
                    Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                    loggable.log();
                    throw new WLDeploymentException(loggable.getMessage(), exception);
                }
                Object var10_7 = null;
                this.releaseResources((Connection)object, statement, null);
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.releaseResources((Connection)object, statement, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropOraclePrimaryKeyConstraint(String string) throws WLDeploymentException {
        StringBuffer stringBuffer = new StringBuffer("alter table ");
        stringBuffer.append(string);
        stringBuffer.append(" drop PRIMARY KEY CASCADE");
        Connection connection = null;
        Statement statement = null;
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("the alter command is ..." + stringBuffer);
        }
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Object var7_6 = null;
                this.releaseResources(connection, statement, null);
            }
            Object var7_5 = null;
            this.releaseResources(connection, statement, null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseResources(connection, statement, null);
            throw throwable;
        }
    }

    private void removeOracleColumns(String string, Set set) throws WLDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
        if (!set.isEmpty()) {
            stringBuffer.append("drop ( ");
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append((String)object);
                if (!object2.hasNext()) continue;
                stringBuffer.append(",");
            }
        } else {
            return;
        }
        stringBuffer.append(" ) ");
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("The alter table command is ..." + stringBuffer);
        }
        object2 = null;
        object = null;
        try {
            try {
                object2 = this.getConnection();
                object = object2.createStatement();
                object.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var9_6 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
            throw throwable;
        }
    }

    private void addOracleColumns(String string, Set set) throws WLDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
        if (!set.isEmpty()) {
            stringBuffer.append("add ( ");
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append((String)object + " " + this.getSqltypeForCol(string, (String)object));
                if (!object2.hasNext()) continue;
                stringBuffer.append(",");
            }
        } else {
            return;
        }
        stringBuffer.append(" ) ");
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("The alter table command is ..." + stringBuffer);
        }
        object2 = null;
        object = null;
        try {
            try {
                object2 = this.getConnection();
                object = object2.createStatement();
                object.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                loggable.log();
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var9_6 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
            throw throwable;
        }
    }

    private static void debugDeployment(String string) {
        deploymentLogger.debug("[RDBMSPersistenceManager] " + string);
    }

    private static void debugRuntime(String string) {
        runtimeLogger.debug("[RDBMSPersistenceManager] " + string);
    }

    private static void debugRuntime(String string, Throwable throwable) {
        runtimeLogger.debug("[RDBMSPersistenceManager] " + string, throwable);
    }

    public RDBMSBean getRDBMSBean() {
        return this.rbean;
    }

    public int getDatabaseType() {
        return this.databaseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeDBProductAndDriverInfo() {
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                this.driverName = databaseMetaData.getDriverName();
                this.driverVersion = databaseMetaData.getDriverVersion();
                this.databaseProductName = databaseMetaData.getDatabaseProductName();
                this.databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.driverMajorVersion = databaseMetaData.getDriverMajorVersion();
                this.driverMinorVersion = databaseMetaData.getDriverMinorVersion();
            }
            catch (SQLException sQLException) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("SQLException while initializing DatabaseMetaData related product/driver info: " + sQLException.getMessage());
                }
                Object var4_6 = null;
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("Printing the DatabaseMetadata related product/driver info");
                    if (connection != null) {
                        RDBMSPersistenceManager.debugDeployment("Connection class is " + connection.getClass().getName());
                    }
                    RDBMSPersistenceManager.debugDeployment("DatabaseProductName is  :  " + this.databaseProductName);
                    RDBMSPersistenceManager.debugDeployment("DatabaseProductVersion is  :  " + this.databaseProductVersion);
                    RDBMSPersistenceManager.debugDeployment("DriverName is  :  " + this.driverName);
                    RDBMSPersistenceManager.debugDeployment("DriverVersion is  :  " + this.driverVersion);
                    RDBMSPersistenceManager.debugDeployment("DriverMajorVersion is  :  " + this.driverMajorVersion);
                    RDBMSPersistenceManager.debugDeployment("DriverMinorVersion is  :  " + this.driverMinorVersion);
                }
                this.releaseResources(connection, null, null);
                return;
            }
            catch (Throwable throwable) {
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("Exception while initializing DatabaseMetaData related product/driver info: " + throwable.getMessage());
                }
                Object var4_7 = null;
                if (deploymentLogger.isDebugEnabled()) {
                    RDBMSPersistenceManager.debugDeployment("Printing the DatabaseMetadata related product/driver info");
                    if (connection != null) {
                        RDBMSPersistenceManager.debugDeployment("Connection class is " + connection.getClass().getName());
                    }
                    RDBMSPersistenceManager.debugDeployment("DatabaseProductName is  :  " + this.databaseProductName);
                    RDBMSPersistenceManager.debugDeployment("DatabaseProductVersion is  :  " + this.databaseProductVersion);
                    RDBMSPersistenceManager.debugDeployment("DriverName is  :  " + this.driverName);
                    RDBMSPersistenceManager.debugDeployment("DriverVersion is  :  " + this.driverVersion);
                    RDBMSPersistenceManager.debugDeployment("DriverMajorVersion is  :  " + this.driverMajorVersion);
                    RDBMSPersistenceManager.debugDeployment("DriverMinorVersion is  :  " + this.driverMinorVersion);
                }
                this.releaseResources(connection, null, null);
                return;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (deploymentLogger.isDebugEnabled()) {
                RDBMSPersistenceManager.debugDeployment("Printing the DatabaseMetadata related product/driver info");
                if (connection != null) {
                    RDBMSPersistenceManager.debugDeployment("Connection class is " + connection.getClass().getName());
                }
                RDBMSPersistenceManager.debugDeployment("DatabaseProductName is  :  " + this.databaseProductName);
                RDBMSPersistenceManager.debugDeployment("DatabaseProductVersion is  :  " + this.databaseProductVersion);
                RDBMSPersistenceManager.debugDeployment("DriverName is  :  " + this.driverName);
                RDBMSPersistenceManager.debugDeployment("DriverVersion is  :  " + this.driverVersion);
                RDBMSPersistenceManager.debugDeployment("DriverMajorVersion is  :  " + this.driverMajorVersion);
                RDBMSPersistenceManager.debugDeployment("DriverMinorVersion is  :  " + this.driverMinorVersion);
            }
            this.releaseResources(connection, null, null);
            throw throwable;
        }
        if (deploymentLogger.isDebugEnabled()) {
            RDBMSPersistenceManager.debugDeployment("Printing the DatabaseMetadata related product/driver info");
            if (connection != null) {
                RDBMSPersistenceManager.debugDeployment("Connection class is " + connection.getClass().getName());
            }
            RDBMSPersistenceManager.debugDeployment("DatabaseProductName is  :  " + this.databaseProductName);
            RDBMSPersistenceManager.debugDeployment("DatabaseProductVersion is  :  " + this.databaseProductVersion);
            RDBMSPersistenceManager.debugDeployment("DriverName is  :  " + this.driverName);
            RDBMSPersistenceManager.debugDeployment("DriverVersion is  :  " + this.driverVersion);
            RDBMSPersistenceManager.debugDeployment("DriverMajorVersion is  :  " + this.driverMajorVersion);
            RDBMSPersistenceManager.debugDeployment("DriverMinorVersion is  :  " + this.driverMinorVersion);
        }
        this.releaseResources(connection, null, null);
    }

    public boolean perhapsUseSetStringForClobForOracle() {
        return this.driverName.equalsIgnoreCase(ORACLE_JDBC_DRIVER_NAME) && this.driverMajorVersion >= 10;
    }
}

