/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.persistence.spi.CmrField;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.RoleSource;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;

public final class RDBMSUtils
extends weblogic.ejb.spi.RDBMSUtils {
    public static final String ONE = "One";
    public static final String MANY = "Many";
    public static final String EJB_CREATE = "ejbCreate";
    public static final String EJB_POST_CREATE = "ejbPostCreate";
    public static final String COMMIT = "commit";
    public static final String DEFAULT_GROUP_NAME = "defaultGroup";
    public static final short STATE_INVALID = -2;
    public static final short STATE_VALID = 0;
    public static final String[] validRdbmsCmp20JarPublicIds = new String[]{"-//BEA Systems, Inc.//DTD WebLogic 6.0.0 EJB RDBMS Persistence//EN", "-//BEA Systems, Inc.//DTD WebLogic 7.0.0 EJB RDBMS Persistence//EN", "-//BEA Systems, Inc.//DTD WebLogic 8.1.0 EJB RDBMS Persistence//EN"};
    public static final String RDBMS_ERROR_BUNDLE = "weblogic.ejb.container.cmp.rdbms.compliance.RDBMSComplianceErrorBundle";
    public static final short GEN_KEY_PK_CLASS_INTEGER = 0;
    public static final short GEN_KEY_PK_CLASS_LONG = 1;
    public static final short IDENTITY = 1;
    public static final short SEQUENCE = 2;
    public static final short SEQUENCE_TABLE = 3;
    public static final short RELATIONSHIP_TYPE_NOT_APPLICABLE = -1;
    public static final short CMP_FIELD = 0;
    public static final short SINGLE_BEAN_NO_RELATION = 1;
    public static final short ONE_TO_ONE_RELATION_FK_ON_LHS = 2;
    public static final short ONE_TO_ONE_RELATION_FK_ON_RHS = 3;
    public static final short ONE_TO_MANY_RELATION = 4;
    public static final short MANY_TO_ONE_RELATION = 5;
    public static final short MANY_TO_MANY_RELATION = 6;
    public static final short REMOTE_RELATION_FK_ON_LHS = 7;
    public static final short REMOTE_RELATION_W_JOIN_TABLE = 8;
    private static final String CONTAINER_SEQUENCE_SUFFIX = "_WL";
    public static final String ACCESS_ORDER = "AccessOrder";
    public static final String VALUE_ORDER = "ValueOrder";

    public static String relationshipTypeToString(int n) {
        switch (n) {
            case -1: {
                return "relationship type unknown or not applicable";
            }
            case 0: {
                return "cmp-field";
            }
            case 1: {
                return "single bean only, no relationship";
            }
            case 2: {
                return "one-to-one relationship, foreign key on left hand side";
            }
            case 3: {
                return "one-to-one relationship, foreign key on right hand side";
            }
            case 4: {
                return "one-to-many relationship";
            }
            case 5: {
                return "many-to-one relationship";
            }
            case 6: {
                return "many-to-many relationship";
            }
            case 7: {
                return "remote relationship foreign key on left hand side";
            }
            case 8: {
                return "remote relationship involving a join table";
            }
        }
        return "unknown relationship type";
    }

    public static String getContainerSequenceName(String string) {
        Debug.assertion((!RDBMSUtils.isContainerSequenceName(string) ? 1 : 0) != 0, (String)("called getContainerSequenceName on '" + string + "' which is already a containerSequenceName"));
        return string + CONTAINER_SEQUENCE_SUFFIX;
    }

    public static boolean isContainerSequenceName(String string) {
        return string.indexOf(CONTAINER_SEQUENCE_SUFFIX) != -1;
    }

    public static String throwable2StackTrace(Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        return byteArrayOutputStream.toString();
    }

    public static String setterMethodName(String string) {
        return "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static String getterMethodName(String string) {
        return "get" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static String getCmrFieldName(EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2) {
        String string = null;
        CmrField cmrField = ejbRelationshipRole.getCmrField();
        if (cmrField != null) {
            string = cmrField.getName();
        } else {
            RoleSource roleSource = ejbRelationshipRole2.getRoleSource();
            String string2 = roleSource.getEjbName();
            CmrField cmrField2 = ejbRelationshipRole2.getCmrField();
            string = MethodUtils.decapitalize(ClassUtils.makeLegalName(string2)) + "_" + cmrField2.getName();
        }
        return string;
    }

    public static String escQuotedID(String string) {
        assert (string != null);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String head(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : string.substring(0, n);
    }

    public static String tail(String string) {
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    public static String sqlTypeToString(int n) {
        switch (n) {
            case 2003: {
                return "java.sql.Types.ARRAY";
            }
            case -5: {
                return "java.sql.Types.BIGINT";
            }
            case -2: {
                return "java.sql.Types.BINARY";
            }
            case -7: {
                return "java.sql.Types.BIT";
            }
            case 2004: {
                return "java.sql.Types.BLOB";
            }
            case 1: {
                return "java.sql.Types.CHAR";
            }
            case 2005: {
                return "java.sql.Types.CLOB";
            }
            case 91: {
                return "java.sql.Types.DATE";
            }
            case 3: {
                return "java.sql.Types.DECIMAL";
            }
            case 2001: {
                return "java.sql.Types.DISTINCT";
            }
            case 8: {
                return "java.sql.Types.DOUBLE";
            }
            case 6: {
                return "java.sql.Types.FLOAT";
            }
            case 4: {
                return "java.sql.Types.INTEGER";
            }
            case 2000: {
                return "java.sql.Types.JAVA_OBJECT";
            }
            case -4: {
                return "java.sql.Types.LONGVARBINARY";
            }
            case -1: {
                return "java.sql.Types.LONGVARCHAR";
            }
            case 0: {
                return "java.sql.Types.NULL";
            }
            case 2: {
                return "java.sql.Types.NUMERIC";
            }
            case 1111: {
                return "java.sql.Types.OTHER";
            }
            case 7: {
                return "java.sql.Types.REAL";
            }
            case 2006: {
                return "java.sql.Types.REF";
            }
            case 5: {
                return "java.sql.Types.SMALLINT";
            }
            case 2002: {
                return "java.sql.Types.STRUCT";
            }
            case 92: {
                return "java.sql.Types.TIME";
            }
            case 93: {
                return "java.sql.Types.TIMESTAMP";
            }
            case -6: {
                return "java.sql.Types.TINYINT";
            }
            case -3: {
                return "java.sql.Types.VARBINARY";
            }
            case 12: {
                return "java.sql.Types.VARCHAR";
            }
        }
        return "Invalid SQL type: " + n;
    }

    public static String selectForUpdateToString(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return " FOR UPDATE ";
            }
            case 2: {
                return " FOR UPDATE NOWAIT ";
            }
        }
        throw new AssertionError("Unknown selectForUpdate type: '" + n + "'");
    }

    public static boolean dbSupportForSingleLeftOuterJoin(int n) {
        return RDBMSUtils.dbSupportForSingleLeftOuterJoinANSI(n) || RDBMSUtils.dbSupportForSingleLeftOuterJoinInWhereClause(n);
    }

    public static boolean dbSupportForMultiLeftOuterJoin(int n) {
        return RDBMSUtils.dbSupportForMultiLeftOuterJoinANSI(n) || RDBMSUtils.dbSupportForMultiLeftOuterJoinInWhereClause(n);
    }

    public static boolean dbSupportForSingleLeftOuterJoinANSI(int n) {
        switch (n) {
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean dbSupportForMultiLeftOuterJoinANSI(int n) {
        switch (n) {
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static boolean dbSupportForSingleLeftOuterJoinInWhereClause(int n) {
        switch (n) {
            case 6: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: 
            case 5: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public static boolean dbSupportForMultiLeftOuterJoinInWhereClause(int n) {
        switch (n) {
            case 6: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: 
            case 5: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public static String getFROMClauseSelectForUpdate(int n, int n2) {
        switch (n) {
            case 2: 
            case 7: {
                if (n2 == 1) {
                    return " WITH(UPDLOCK) ";
                }
                if (n2 == 2) {
                    return "";
                }
                if (n2 != 0) break;
                return "";
            }
            case 5: {
                if (n2 == 1) {
                    return " HOLDLOCK ";
                }
                if (n2 == 2) {
                    return "";
                }
                if (n2 != 0) break;
                return "";
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                return "";
            }
            default: {
                Debug.assertion((boolean)false, (String)("Undefined database type " + n));
            }
        }
        return "";
    }

    public static void printEnvironment() {
        try {
            InitialContext initialContext = new InitialContext();
            NamingEnumeration<NameClassPair> namingEnumeration = initialContext.list("java:comp/env");
            Debug.say((String)"java:comp/env----------------------------");
            if (!namingEnumeration.hasMore()) {
                Debug.say((String)"Context is empty.");
            }
            while (namingEnumeration.hasMore()) {
                NameClassPair nameClassPair = namingEnumeration.next();
                Debug.say((String)("name- " + nameClassPair.getName() + ", " + "class- " + nameClassPair.getClassName()));
            }
            namingEnumeration.close();
        }
        catch (Exception exception) {
            Debug.say((String)"Error while printing Environment:");
            exception.printStackTrace();
        }
    }

    public static short getGenKeyTypeAsConstant(String string) {
        if (string.equalsIgnoreCase("Identity")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Sequence")) {
            return 2;
        }
        if (string.equalsIgnoreCase("SequenceTable")) {
            return 3;
        }
        return -1;
    }

    public static boolean isOracleNLSDataType(RDBMSBean rDBMSBean, String string, Map map) {
        Map map2;
        if (map == null || map.isEmpty() || string.indexOf(46) == -1) {
            return RDBMSUtils.isOracleNLSDataType(rDBMSBean, string);
        }
        int n = string.indexOf(46);
        String string2 = (String)map.get(string.substring(0, n));
        if (string2 != null && (map2 = rDBMSBean.getRdbmsBeanMap()) != null && !map2.isEmpty()) {
            Iterator iterator = map2.values().iterator();
            RDBMSBean rDBMSBean2 = null;
            while (iterator.hasNext()) {
                RDBMSBean rDBMSBean3 = (RDBMSBean)iterator.next();
                if (!string2.equals(rDBMSBean3.getAbstractSchemaName())) continue;
                rDBMSBean2 = rDBMSBean3;
                break;
            }
            if (rDBMSBean2 != null) {
                return RDBMSUtils.isOracleNLSDataType(rDBMSBean2, string.substring(n + 1));
            }
        }
        return RDBMSUtils.isOracleNLSDataType(rDBMSBean, string);
    }

    public static boolean isOracleNLSDataType(RDBMSBean rDBMSBean, String string) {
        if (rDBMSBean.getDatabaseType() != 1) {
            return false;
        }
        String string2 = rDBMSBean.getField(string);
        if (!string.equals(string2)) {
            int n;
            String string3 = null;
            if (string2 == null && (n = string.indexOf(".")) != -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            RDBMSBean rDBMSBean2 = rDBMSBean;
            while (string2 != null && rDBMSBean2.getCmrFieldNames().contains(string2)) {
                rDBMSBean2 = rDBMSBean2.getRelatedRDBMSBean(string2);
                if (string3 != null) {
                    int n2 = string3.indexOf(".");
                    if (n2 != -1) {
                        string2 = string3.substring(0, n2);
                        string3 = string3.substring(n2 + 1);
                        continue;
                    }
                } else {
                    String string4 = rDBMSBean.getCmpColumnForVariable(string);
                    if (string4 == null) break;
                    string3 = rDBMSBean.getRelatedPkFieldName(string2, string4);
                }
                return "NCHAR".equalsIgnoreCase(rDBMSBean2.getCmpColumnTypeForField(string3)) || "NVARCHAR2".equalsIgnoreCase(rDBMSBean2.getCmpColumnTypeForField(string3)) || "NCLOB".equalsIgnoreCase(rDBMSBean2.getCmpColumnTypeForField(string3));
            }
        }
        return "NCHAR".equalsIgnoreCase(rDBMSBean.getCmpColumnTypeForField(string)) || "NVARCHAR2".equalsIgnoreCase(rDBMSBean.getCmpColumnTypeForField(string)) || "NCLOB".equalsIgnoreCase(rDBMSBean.getCmpColumnTypeForField(string));
    }
}

