/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.codegen;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.persistence.spi.CMPCodeGenerator;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.utils.Getopt2;

public abstract class BaseCodeGenerator
extends CMPCodeGenerator {
    protected static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    public static String EOL = "\n";

    public String varPrefix() {
        return "__WL_";
    }

    protected BaseCodeGenerator(Getopt2 getopt2) {
        super(getopt2);
    }

    protected String lookupConvert(Class clazz) {
        if (clazz.equals(Boolean.class)) {
            return ".booleanValue()";
        }
        if (clazz.equals(Integer.class)) {
            return ".intValue()";
        }
        if (clazz.equals(Float.class)) {
            return ".floatValue()";
        }
        if (clazz.equals(Double.class)) {
            return ".doubleValue()";
        }
        if (clazz.equals(Long.class)) {
            return ".longValue()";
        }
        if (clazz.equals(Short.class)) {
            return ".shortValue()";
        }
        if (clazz.equals(Character.class)) {
            return ".charValue()";
        }
        if (clazz.equals(Byte.class)) {
            return ".byteValue()";
        }
        return "";
    }

    protected String perhapsConvert(Class clazz, Class clazz2, String string) {
        String string2 = null;
        if (clazz.equals(clazz2)) {
            string2 = string;
        } else if (clazz.isPrimitive()) {
            assert (ClassUtils.getObjectClass(clazz).equals(clazz2));
            string2 = string + this.lookupConvert(clazz2);
        } else {
            assert (clazz2.isPrimitive());
            assert (clazz.equals(ClassUtils.getObjectClass(clazz2)));
            string2 = "new " + this.javaCodeForType(ClassUtils.getObjectClass(clazz2)) + "(" + string + ")";
        }
        return string2;
    }

    protected String perhapsConvertPrimitive(Class clazz, String string) {
        String string2 = null;
        string2 = clazz.isPrimitive() ? "new " + this.javaCodeForType(ClassUtils.getObjectClass(clazz)) + "(" + string + ")" : string;
        return string2;
    }
}

