/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.codegen;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.codegen.BaseCodeGenerator;
import weblogic.ejb.container.cmp.rdbms.codegen.StatementBinder;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.EjbCodeGenerator;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;

public final class ManyToManyGenerator
extends BaseCodeGenerator {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private boolean keepgenerated = false;
    private RDBMSBean rbean = null;
    private CMPBeanDescriptor bd = null;
    private String cmrField;
    private String packageName = null;

    public ManyToManyGenerator(Getopt2 getopt2) {
        super(getopt2);
        this.keepgenerated = getopt2.hasOption("keepgenerated");
    }

    protected List typeSpecificTemplates() {
        throw new AssertionError("This method should never be called.");
    }

    public void setRDBMSBean(RDBMSBean rDBMSBean) {
        assert (rDBMSBean != null);
        this.rbean = rDBMSBean;
    }

    public void setCMPBeanDescriptor(CMPBeanDescriptor cMPBeanDescriptor) {
        this.bd = cMPBeanDescriptor;
        this.packageName = RDBMSUtils.head(cMPBeanDescriptor.getBeanClass().getName());
        Set set = cMPBeanDescriptor.getPrimaryKeyFieldNames();
    }

    public void setCmrFieldName(String string) {
        assert (string != null);
        this.cmrField = string;
    }

    protected void prepare(CodeGenerator.Output output) throws EJBCException, ClassNotFoundException {
        super.prepare(output);
        assert (this.rbean != null);
        if (debugLogger.isDebugEnabled()) {
            ManyToManyGenerator.debug("cmp.rdbms.codegen.ManyToManyGenerator.prepare() called");
        }
    }

    protected Enumeration outputs(List list) throws Exception {
        if (debugLogger.isDebugEnabled()) {
            ManyToManyGenerator.debug("ManyToManyGenerator.outputs() called");
        }
        assert (list.size() == 0);
        Vector vector = new Vector();
        this.addOutputs(vector);
        return vector.elements();
    }

    protected void addOutputs(List list) throws RDBMSException {
        if (debugLogger.isDebugEnabled()) {
            ManyToManyGenerator.debug("ManyToManyGenerator.addOutputs called");
        }
        EjbCodeGenerator.Output[] outputArray = new EjbCodeGenerator.Output[2];
        outputArray[0] = new EjbCodeGenerator.Output();
        outputArray[0].setOutputFile(this.setClassName() + ".java");
        outputArray[0].setTemplate("/weblogic/ejb/container/cmp/rdbms/codegen/ManyToManySet.j");
        outputArray[0].setPackage(this.packageName());
        list.add(outputArray[0]);
        outputArray[1] = new EjbCodeGenerator.Output();
        outputArray[1].setOutputFile(this.iteratorClassName() + ".java");
        outputArray[1].setTemplate("/weblogic/ejb/container/cmp/rdbms/codegen/OneToManyIterator.j");
        outputArray[1].setPackage(this.packageName());
        list.add(outputArray[1]);
    }

    public String varPrefix() {
        return "__WL_";
    }

    public String debugVar() {
        return this.varPrefix() + "debugLogger";
    }

    public String debugEnabled() {
        return this.debugVar() + ".isDebugEnabled()";
    }

    public String debugSay() {
        return this.varPrefix() + "debug";
    }

    public String beanVar() {
        return this.varPrefix() + "bean";
    }

    public String stmtVar() {
        return this.varPrefix() + "stmt";
    }

    public String conVar() {
        return this.varPrefix() + "con";
    }

    public String rsVar() {
        return this.varPrefix() + "rs";
    }

    public String pmVar() {
        return this.varPrefix() + "pm";
    }

    public String pkVar() {
        return this.varPrefix() + "pk";
    }

    public String pk1Var() {
        return this.varPrefix() + "pk1";
    }

    public String pk2Var() {
        return this.varPrefix() + "pk2";
    }

    public String fkVar() {
        return this.varPrefix() + "fk";
    }

    public String keyVar() {
        return this.varPrefix() + "key";
    }

    public String numVar() {
        return this.varPrefix() + "num";
    }

    public String iVar() {
        return this.varPrefix() + "i";
    }

    public String countVar() {
        return this.varPrefix() + "count";
    }

    public String ctxVar() {
        return this.varPrefix() + "ctx";
    }

    public String ceoVar() {
        return this.varPrefix() + "createEo";
    }

    public String cpkVar() {
        return this.varPrefix() + "createPk";
    }

    public String colVar() {
        return this.varPrefix() + "collection";
    }

    public String bmVar() {
        return this.varPrefix() + "bm";
    }

    public String finderVar() {
        return this.varPrefix() + "finder";
    }

    public String creatorVar() {
        return this.varPrefix() + "creator";
    }

    public String cacheVar() {
        return this.varPrefix() + "cache";
    }

    public String addVar() {
        return this.varPrefix() + "add";
    }

    public String removeVar() {
        return this.varPrefix() + "rem";
    }

    public String addIter() {
        return this.varPrefix() + "additer";
    }

    public String remIter() {
        return this.varPrefix() + "remiter";
    }

    public String wrapperVar() {
        return this.varPrefix() + "wrapper";
    }

    public String iterVar() {
        return this.varPrefix() + "iter";
    }

    public String queryVar() {
        return this.varPrefix() + "query";
    }

    public String symmetricVar() {
        return this.varPrefix() + "symmetric";
    }

    public String createTxIdVar() {
        return this.varPrefix() + "createTxId";
    }

    public String addSetVar() {
        return this.varPrefix() + "addSet";
    }

    public String ejbName() {
        return this.rbean.getEjbName();
    }

    public String cmrName() {
        return this.cmrField;
    }

    public String oldStateVar() {
        return this.varPrefix() + "oldState";
    }

    private String capitalize(String string) {
        assert (string.length() > 0);
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public String relatedEjbName() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        return cMPBeanDescriptor.getEJBName();
    }

    public String wrapperSetFinder() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "localWrapperSetFinder";
        }
        return "remoteWrapperSetFinder";
    }

    public String EJBObject() {
        if (this.bd.hasLocalClientView() || this.bd.isEJB30()) {
            return "EJBLocalObject";
        }
        return "EJBObject";
    }

    public String EJBObjectForField() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "EJBLocalObject";
        }
        return "EJBObject";
    }

    public String EoWrapper() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "EloWrapper";
        }
        return "EoWrapper";
    }

    public String getEJBObject() {
        if (this.bd.hasLocalClientView() || this.bd.isEJB30()) {
            return "getEJBLocalObject";
        }
        return "getEJBObject";
    }

    public String getEJBObjectForField() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "getEJBLocalObject";
        }
        return "getEJBObject";
    }

    public String setClassName() {
        return ClassUtils.setClassName(this.bd, this.cmrField);
    }

    public String iteratorClassName() {
        return ClassUtils.iteratorClassName(this.bd, this.cmrField);
    }

    public String owningBeanClassName() {
        return this.bd.getGeneratedBeanClassName();
    }

    public String owningBeanInterfaceName() {
        return this.bd.getGeneratedBeanInterfaceName();
    }

    public String remoteInterfaceName() {
        if (this.bd.hasLocalClientView()) {
            return this.bd.getLocalInterfaceName();
        }
        if (this.bd.isEJB30()) {
            return this.bd.getJavaClassName();
        }
        return this.bd.getRemoteInterfaceName();
    }

    public String relatedBeanClassName() {
        return this.rbean.getRelatedBeanClassName(this.cmrField);
    }

    public String relatedBeanInterfaceName() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        return cMPBeanDescriptor.getGeneratedBeanInterfaceName();
    }

    public String relatedRemoteInterfaceName() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView()) {
            return cMPBeanDescriptor.getLocalInterfaceName();
        }
        if (cMPBeanDescriptor.isEJB30()) {
            return this.bd.getJavaClassName();
        }
        return cMPBeanDescriptor.getRemoteInterfaceName();
    }

    private String declarePkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.bd.getPrimaryKeyClass().getName() + " " + this.pkVar() + " = ");
        if (this.bd.hasComplexPrimaryKey()) {
            stringBuffer.append("new " + this.bd.getPrimaryKeyClass().getName() + "();");
        } else {
            stringBuffer.append("null;");
        }
        return stringBuffer.toString();
    }

    public String perhapsDeclarePkVar() {
        if (this.bd.hasComplexPrimaryKey()) {
            return this.declarePkVar();
        }
        return "";
    }

    public String perhapsAssignPkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public String pkVarForBean() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public String declareAddSet() {
        return "private Set " + this.addSetVar() + " = null;";
    }

    private String setterMethodName(String string) {
        return "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public String relatedBeanSetMethod() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.setterMethodName(this.rbean.getRelatedFieldName(this.cmrField)));
        return stringBuffer.toString();
    }

    public String packageName() {
        assert (this.packageName != null);
        return this.packageName;
    }

    public String packageStatement() {
        return this.packageName == null || this.packageName.equals("") ? "" : "package " + this.packageName + ";";
    }

    public String symmetricRelationship() {
        RDBMSBean rDBMSBean = this.rbean.getRelatedRDBMSBean(this.cmrField);
        String string = this.rbean.getRelatedFieldName(this.cmrField);
        if (rDBMSBean == this.rbean && string.equals(this.cmrField)) {
            return "true";
        }
        return "false";
    }

    public String joinParamsSql() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.rbean.getForeignKeyColNames(this.cmrField).iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            arrayList.add((String)object);
            stringBuffer.append("(" + (String)object + " = ?)");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        object = this.rbean.getRelatedRDBMSBean(this.cmrField);
        String string = this.rbean.getRelatedFieldName(this.cmrField);
        iterator = object == this.rbean && string.equals(this.cmrField) ? ((RDBMSBean)object).getSymmetricKeyColNames(string).iterator() : ((RDBMSBean)object).getForeignKeyColNames(string).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (arrayList.contains(string2)) continue;
            stringBuffer.append(" AND ");
            stringBuffer.append("(" + string2 + " = ?)");
        }
        return stringBuffer.toString();
    }

    private void addPrimaryKeyBinding(StringBuffer stringBuffer, String string, int n, String string2, Class clazz, String string3) {
        stringBuffer.append(this.stmtVar() + ".set" + string + "(");
        stringBuffer.append(n).append(", ");
        stringBuffer.append(string2 + MethodUtils.convertToPrimitive(clazz, string3));
        stringBuffer.append(");" + EOL);
    }

    private int addPrimaryKeyBindings(StringBuffer stringBuffer, RDBMSBean rDBMSBean, CMPBeanDescriptor cMPBeanDescriptor, String string, int n, String string2, List list, boolean bl) throws CodeGenerationException {
        boolean bl2 = cMPBeanDescriptor.hasComplexPrimaryKey();
        Class<?> clazz = cMPBeanDescriptor.getPrimaryKeyClass();
        Iterator iterator = null;
        RDBMSBean rDBMSBean2 = rDBMSBean.getRelatedRDBMSBean(string);
        String string3 = rDBMSBean.getRelatedFieldName(string);
        boolean bl3 = bl && rDBMSBean2 == rDBMSBean && string3.equals(string);
        Map map = null;
        if (bl3) {
            iterator = rDBMSBean2.getSymmetricKeyColNames(string3).iterator();
            map = rDBMSBean2.getSymmetricColumn2FieldName(string3);
        } else {
            iterator = rDBMSBean.getForeignKeyColNames(string).iterator();
        }
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (list.contains(string4)) continue;
            list.add(string4);
            String string5 = null;
            string5 = bl3 ? (String)map.get(string4) : rDBMSBean.getRelatedPkFieldName(string, string4);
            String string6 = null;
            Class<?> clazz2 = null;
            String string7 = null;
            if (bl2) {
                string6 = "((" + clazz.getName() + ")" + string2 + ").";
                Field field = null;
                try {
                    field = clazz.getField(string5);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Loggable loggable = EJBLogger.logFieldNotFoundInClassLoggable((String)string5, (String)clazz.getName());
                    throw new CodeGenerationException(loggable.getMessage());
                }
                clazz2 = field.getType();
                string7 = StatementBinder.getStatementTypeNameForClass(clazz2);
            } else {
                string6 = "";
                clazz2 = clazz;
                string7 = StatementBinder.getStatementTypeNameForClass(clazz2);
                string5 = "((" + clazz.getName() + ")" + string2 + ")";
            }
            if (RDBMSUtils.isOracleNLSDataType(rDBMSBean2, string5)) {
                stringBuffer.append("if(").append(this.stmtVar()).append(" instanceof oracle.jdbc.OraclePreparedStatement) {" + EOL);
                stringBuffer.append("((oracle.jdbc.OraclePreparedStatement)").append(this.stmtVar()).append(").setFormOfUse(").append(n).append(", oracle.jdbc.OraclePreparedStatement.FORM_NCHAR);").append(EOL);
                stringBuffer.append("}" + EOL);
            }
            this.addPrimaryKeyBinding(stringBuffer, string7, n, string6, clazz2, string5);
            ++n;
        }
        return n;
    }

    public String setJoinTableParams() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        ArrayList arrayList = new ArrayList();
        n = this.addPrimaryKeyBindings(stringBuffer, this.rbean, this.bd, this.cmrField, n, this.pk1Var(), arrayList, false);
        RDBMSBean rDBMSBean = this.rbean.getRelatedRDBMSBean(this.cmrField);
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        String string = this.rbean.getRelatedFieldName(this.cmrField);
        this.addPrimaryKeyBindings(stringBuffer, rDBMSBean, cMPBeanDescriptor, string, n, this.pk2Var(), arrayList, true);
        return stringBuffer.toString();
    }

    public String joinColumnsSql() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.rbean.getForeignKeyColNames(this.cmrField).iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append((String)object);
            arrayList.add(object);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        object = this.rbean.getRelatedRDBMSBean(this.cmrField);
        String string = this.rbean.getRelatedFieldName(this.cmrField);
        iterator = object == this.rbean && string.equals(this.cmrField) ? ((RDBMSBean)object).getSymmetricKeyColNames(string).iterator() : ((RDBMSBean)object).getForeignKeyColNames(string).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (arrayList.contains(string2)) continue;
            stringBuffer.append(", ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String joinColsQMs() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.rbean.getForeignKeyColNames(this.cmrField).iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append("?");
            arrayList.add(object);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        object = this.rbean.getRelatedRDBMSBean(this.cmrField);
        String string = this.rbean.getRelatedFieldName(this.cmrField);
        iterator = object == this.rbean && string.equals(this.cmrField) ? ((RDBMSBean)object).getSymmetricKeyColNames(string).iterator() : ((RDBMSBean)object).getForeignKeyColNames(string).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (arrayList.contains(string2)) continue;
            stringBuffer.append(", ");
            stringBuffer.append("?");
        }
        return stringBuffer.toString();
    }

    public String joinTableName() {
        assert (this.rbean.getJoinTableName(this.cmrField) != null);
        return this.rbean.getJoinTableName(this.cmrField);
    }

    public String relatedGetMethodName() {
        String string = this.rbean.getRelatedFieldName(this.cmrField);
        return MethodUtils.getMethodName(string);
    }

    public String existsJoinTableQuery() {
        return this.existsJoinTableQuery(0);
    }

    public String existsJoinTableQueryForUpdate() {
        return this.existsJoinTableQuery(1);
    }

    public String existsJoinTableQueryForUpdateNoWait() {
        return this.existsJoinTableQuery(2);
    }

    private String existsJoinTableQuery(int n) {
        StringBuffer stringBuffer = new StringBuffer("SELECT 7 FROM ");
        stringBuffer.append(this.joinTableName());
        int n2 = this.rbean.getDatabaseType();
        switch (n2) {
            case 2: 
            case 7: {
                if (n == 1) {
                    stringBuffer.append(" WITH(UPDLOCK)");
                }
                stringBuffer.append(" WHERE ");
                stringBuffer.append(this.joinParamsSql());
                if (n == 2) {
                    stringBuffer.append(RDBMSUtils.selectForUpdateToString(n));
                    break;
                }
                if (n != 0) break;
                break;
            }
            case 5: {
                if (n == 1) {
                    stringBuffer.append(" HOLDLOCK");
                }
                stringBuffer.append(" WHERE ");
                stringBuffer.append(this.joinParamsSql());
                if (n == 2) {
                    stringBuffer.append(RDBMSUtils.selectForUpdateToString(n));
                    break;
                }
                if (n != 0) break;
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                stringBuffer.append(" WHERE ");
                stringBuffer.append(this.joinParamsSql());
                stringBuffer.append(RDBMSUtils.selectForUpdateToString(n));
                break;
            }
            default: {
                throw new AssertionError("Undefined database type " + n2);
            }
        }
        return stringBuffer.toString();
    }

    public String perhapsImplementQueryCachingMethods() throws CodeGenerationException {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        return this.parse(this.getProductionRule("queryCachingMethods"));
    }

    public String isLocal() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "true";
        }
        return "false";
    }

    public String perhapsPopulateFromQueryCache() {
        if (!this.rbean.isQueryCachingEnabledForCMRField(this.cmrField)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.cacheVar()).append(" = getFromQueryCache();").append(EOL);
        stringBuffer.append("if (").append(this.cacheVar()).append(" == null) {").append(EOL);
        return stringBuffer.toString();
    }

    public String perhapsPutInQueryCache() {
        if (!this.rbean.isQueryCachingEnabledForCMRField(this.cmrField)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("}");
        stringBuffer.append(EOL);
        stringBuffer.append("putInQueryCache(null);").append(EOL);
        return stringBuffer.toString();
    }

    public String readOnlyFinderRunsInItsOwnTransaction() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Transaction orgTx = TransactionHelper.getTransactionHelper().getTransaction();\n");
            stringBuffer.append("try {\n");
            stringBuffer.append("TransactionManager tms = TxHelper.getTransactionManager();\n");
            stringBuffer.append("tms.suspend();\n");
            stringBuffer.append("tms.begin();\n");
            stringBuffer.append("Transaction tx = tms.getTransaction();\n");
            stringBuffer.append(this.cacheVar() + " = " + this.bmVar() + "." + this.wrapperSetFinder() + "(" + this.finderVar() + ", new Object[] {" + this.cpkVar() + "}, true);\n");
            stringBuffer.append("tx.commit();\n");
            stringBuffer.append("} catch(Exception e) {\n");
            stringBuffer.append(" throw e; }\n");
            stringBuffer.append("finally {\n");
            stringBuffer.append("TxHelper.getTransactionManager().resume(orgTx);\n");
            stringBuffer.append("}\n");
            return stringBuffer.toString();
        }
        return this.cacheVar() + " = " + this.bmVar() + "." + this.wrapperSetFinder() + "(" + this.finderVar() + ", new Object[] {" + this.cpkVar() + "}, true);";
    }

    public String isReadOnly() {
        CMPBeanDescriptor cMPBeanDescriptor = this.rbean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.isReadOnly() || cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            return "true";
        }
        return "false";
    }

    private static void debug(String string) {
        debugLogger.debug("[ManyToManyGenerator] " + string);
    }
}

