/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.codegen;

import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.codegen.BaseCodeGenerator;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.EjbCodeGenerator;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.utils.AssertionError;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;

public final class OneToManyGenerator
extends BaseCodeGenerator {
    private boolean keepgenerated = false;
    private RDBMSBean bean = null;
    private CMPBeanDescriptor bd = null;
    private String cmrField;
    private String packageName = null;

    public OneToManyGenerator(Getopt2 getopt2) {
        super(getopt2);
        this.keepgenerated = getopt2.hasOption("keepgenerated");
    }

    protected List typeSpecificTemplates() {
        throw new AssertionError("This method should never be called.");
    }

    public void setRDBMSBean(RDBMSBean rDBMSBean) {
        assert (rDBMSBean != null);
        this.bean = rDBMSBean;
    }

    public void setCMPBeanDescriptor(CMPBeanDescriptor cMPBeanDescriptor) {
        this.bd = cMPBeanDescriptor;
        this.packageName = RDBMSUtils.head(cMPBeanDescriptor.getBeanClass().getName());
        Set set = cMPBeanDescriptor.getPrimaryKeyFieldNames();
    }

    public void setCmrFieldName(String string) {
        assert (string != null);
        this.cmrField = string;
    }

    protected void prepare(CodeGenerator.Output output) throws EJBCException, ClassNotFoundException {
        super.prepare(output);
        assert (this.bean != null);
        if (debugLogger.isDebugEnabled()) {
            OneToManyGenerator.debug("cmp.rdbms.codegen.OneToManyGenerator.prepare() called");
        }
    }

    protected Enumeration outputs(List list) throws Exception {
        if (debugLogger.isDebugEnabled()) {
            OneToManyGenerator.debug("OneToManyGenerator.outputs() called");
        }
        assert (list.size() == 0);
        Vector vector = new Vector();
        this.addOutputs(vector);
        return vector.elements();
    }

    protected void addOutputs(List list) throws RDBMSException {
        if (debugLogger.isDebugEnabled()) {
            OneToManyGenerator.debug("OneToManyGenerator.addOutputs called");
        }
        EjbCodeGenerator.Output[] outputArray = new EjbCodeGenerator.Output[2];
        outputArray[0] = new EjbCodeGenerator.Output();
        outputArray[0].setOutputFile(this.setClassName() + ".java");
        outputArray[0].setTemplate("/weblogic/ejb/container/cmp/rdbms/codegen/OneToManySet.j");
        outputArray[0].setPackage(this.packageName());
        list.add(outputArray[0]);
        outputArray[1] = new EjbCodeGenerator.Output();
        outputArray[1].setOutputFile(this.iteratorClassName() + ".java");
        outputArray[1].setTemplate("/weblogic/ejb/container/cmp/rdbms/codegen/OneToManyIterator.j");
        outputArray[1].setPackage(this.packageName());
        list.add(outputArray[1]);
    }

    public String varPrefix() {
        return "__WL_";
    }

    public String debugVar() {
        return this.varPrefix() + "debugLogger";
    }

    public String debugEnabled() {
        return this.debugVar() + ".isDebugEnabled()";
    }

    public String debugSay() {
        return this.varPrefix() + "debug";
    }

    public String beanVar() {
        return this.varPrefix() + "bean";
    }

    public String pkVar() {
        return this.varPrefix() + "pk";
    }

    public String fkVar() {
        return this.varPrefix() + "fk";
    }

    public String keyVar() {
        return this.varPrefix() + "key";
    }

    public String numVar() {
        return this.varPrefix() + "num";
    }

    public String iVar() {
        return this.varPrefix() + "i";
    }

    public String countVar() {
        return this.varPrefix() + "count";
    }

    public String ctxVar() {
        return this.varPrefix() + "ctx";
    }

    public String ceoVar() {
        return this.varPrefix() + "createEo";
    }

    public String cpkVar() {
        return this.varPrefix() + "createPk";
    }

    public String colVar() {
        return this.varPrefix() + "collection";
    }

    public String bmVar() {
        return this.varPrefix() + "bm";
    }

    public String finderVar() {
        return this.varPrefix() + "finder";
    }

    public String creatorVar() {
        return this.varPrefix() + "creator";
    }

    public String cacheVar() {
        return this.varPrefix() + "cache";
    }

    public String addVar() {
        return this.varPrefix() + "add";
    }

    public String removeVar() {
        return this.varPrefix() + "rem";
    }

    public String addIter() {
        return this.varPrefix() + "additer";
    }

    public String remIter() {
        return this.varPrefix() + "remiter";
    }

    public String wrapperVar() {
        return this.varPrefix() + "wrapper";
    }

    public String iterVar() {
        return this.varPrefix() + "iter";
    }

    public String pmVar() {
        return this.varPrefix() + "pm";
    }

    public String createTxIdVar() {
        return this.varPrefix() + "createTxId";
    }

    public String oldStateVar() {
        return this.varPrefix() + "oldState";
    }

    public String ejbName() {
        return this.bean.getEjbName();
    }

    public String relatedEjbName() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        return cMPBeanDescriptor.getEJBName();
    }

    public String cmrName() {
        return this.cmrField;
    }

    private String capitalize(String string) {
        assert (string.length() > 0);
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public String wrapperSetFinder() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "localWrapperSetFinder";
        }
        return "remoteWrapperSetFinder";
    }

    public String EJBObject() {
        if (this.bd.hasLocalClientView() || this.bd.isEJB30()) {
            return "EJBLocalObject";
        }
        return "EJBObject";
    }

    public String EJBObjectForField() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "EJBLocalObject";
        }
        return "EJBObject";
    }

    public String EoWrapper() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "EloWrapper";
        }
        return "EoWrapper";
    }

    public String getEJBObject() {
        if (this.bd.hasLocalClientView() || this.bd.isEJB30()) {
            return "getEJBLocalObject";
        }
        return "getEJBObject";
    }

    public String getEJBObjectForField() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "getEJBLocalObject";
        }
        return "getEJBObject";
    }

    public String getWLGetEJBObject() {
        if (this.bd.hasLocalClientView() || this.bd.isEJB30()) {
            return "__WL_getEJBLocalObject";
        }
        return "__WL_getEJBObject";
    }

    public String elementInterfaceName() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView()) {
            return cMPBeanDescriptor.getLocalInterfaceName();
        }
        if (cMPBeanDescriptor.isEJB30()) {
            return cMPBeanDescriptor.getJavaClassName();
        }
        return cMPBeanDescriptor.getRemoteInterfaceName();
    }

    public String remoteInterfaceName() {
        if (this.bd.hasLocalClientView()) {
            return this.bd.getLocalInterfaceName();
        }
        if (this.bd.isEJB30()) {
            return this.bd.getJavaClassName();
        }
        return this.bd.getRemoteInterfaceName();
    }

    public String owningBeanClassName() {
        return this.bd.getGeneratedBeanClassName();
    }

    public String owningBeanInterfaceName() {
        return this.bd.getGeneratedBeanInterfaceName();
    }

    public String relatedBeanClassName() {
        return this.bean.getRelatedBeanClassName(this.cmrField);
    }

    public String relatedBeanInterfaceName() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        return cMPBeanDescriptor.getGeneratedBeanInterfaceName();
    }

    private String declarePkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.bd.getPrimaryKeyClass().getName() + " " + this.pkVar() + " = null;");
        return stringBuffer.toString();
    }

    public String perhapsDeclarePkVar() {
        if (this.bd.hasComplexPrimaryKey()) {
            return this.declarePkVar();
        }
        return "";
    }

    public String perhapsAssignPkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bd.hasComplexPrimaryKey()) {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
            RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(this.cmrField);
            String string = this.bean.getRelatedFieldName(this.cmrField);
            String string2 = rDBMSBean.getTableForCmrField(string);
            boolean bl = false;
            for (String string3 : rDBMSBean.getForeignKeyColNames(string)) {
                object42 = rDBMSBean.getForeignKeyColClass(string, string3);
                if (!Object.class.isAssignableFrom((Class<?>)object42)) continue;
                bl = true;
            }
            if (bl) {
                stringBuffer.append("if (");
                boolean bl2 = true;
                for (Object object42 : rDBMSBean.getForeignKeyColNames(string)) {
                    object3 = rDBMSBean.variableForField(string, string2, (String)object42);
                    object2 = rDBMSBean.getForeignKeyColClass(string, (String)object42);
                    if (!Object.class.isAssignableFrom((Class<?>)object2)) continue;
                    object = this.beanVar() + "." + MethodUtils.getMethodName((String)object3) + "()";
                    if (!bl2) {
                        stringBuffer.append(" && ");
                    } else {
                        bl2 = false;
                    }
                    stringBuffer.append((String)object + "!=null");
                }
                stringBuffer.append(") {" + EOL);
            }
            stringBuffer.append(this.pkVar() + " = new " + this.bd.getPrimaryKeyClass().getName() + "();" + EOL);
            for (String string4 : rDBMSBean.getForeignKeyColNames(string)) {
                object42 = rDBMSBean.variableForField(string, string2, string4);
                object3 = rDBMSBean.getForeignKeyColClass(string, string4);
                object2 = rDBMSBean.getRelatedPkFieldName(string, string4);
                object = this.bd.getFieldClass((String)object2);
                String string5 = this.pkVar() + "." + (String)object2;
                String string6 = this.beanVar() + "." + MethodUtils.getMethodName((String)object42) + "()";
                if (((Class)object).isPrimitive()) {
                    string6 = MethodUtils.convertToPrimitive((Class)object, string6);
                }
                stringBuffer.append(string5 + " = " + string6 + ";" + EOL);
            }
            if (bl) {
                stringBuffer.append("}" + EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String pkVarForBean() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bd.hasComplexPrimaryKey()) {
            stringBuffer.append(this.pkVar());
        } else {
            if (debugLogger.isDebugEnabled()) {
                OneToManyGenerator.debug("cmrField is: " + this.cmrField);
            }
            RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(this.cmrField);
            String string = this.bean.getRelatedFieldName(this.cmrField);
            String string2 = rDBMSBean.getTableForCmrField(string);
            String string3 = (String)rDBMSBean.getForeignKeyColNames(string).iterator().next();
            String string4 = rDBMSBean.variableForField(string, string2, string3);
            Class clazz = rDBMSBean.getForeignKeyColClass(string, string3);
            stringBuffer.append(this.perhapsConvertPrimitive(clazz, this.beanVar() + "." + MethodUtils.getMethodName(string4) + "()"));
        }
        return stringBuffer.toString();
    }

    private String setterMethodName(String string) {
        return "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public String relatedBeanSetMethod() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.setterMethodName(this.bean.getRelatedFieldName(this.cmrField)));
        return stringBuffer.toString();
    }

    public String packageName() {
        assert (this.packageName != null);
        return this.packageName;
    }

    public String packageStatement() {
        return this.packageName == null || this.packageName.equals("") ? "" : "package " + this.packageName + ";";
    }

    public String setClassName() {
        return ClassUtils.setClassName(this.bd, this.cmrField);
    }

    public String iteratorClassName() {
        return ClassUtils.iteratorClassName(this.bd, this.cmrField);
    }

    public String perhapsInvokeFinder() throws CodeGenerationException {
        if (this.bean.getLoadRelatedBeansFromDbInPostCreate()) {
            return this.readOnlyFinderRunsInItsOwnTransaction();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parse(this.getProductionRule("loadIfNotPostCreate")));
        stringBuffer.append("\n else { \n");
        stringBuffer.append(this.readOnlyFinderRunsInItsOwnTransaction());
        stringBuffer.append("\n } \n");
        return stringBuffer.toString();
    }

    public String isLocal() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.hasLocalClientView()) {
            return "true";
        }
        return "false";
    }

    public String perhapsImplementQueryCachingMethods() throws CodeGenerationException {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        return this.parse(this.getProductionRule("queryCachingMethods"));
    }

    public String perhapsPopulateFromQueryCache() {
        if (!this.bean.isQueryCachingEnabledForCMRField(this.cmrField)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.cacheVar()).append(" = getFromQueryCache();").append(EOL);
        stringBuffer.append("if (").append(this.cacheVar()).append(" == null) {").append(EOL);
        return stringBuffer.toString();
    }

    public String perhapsPutInQueryCache() {
        if (!this.bean.isQueryCachingEnabledForCMRField(this.cmrField)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("}");
        stringBuffer.append(EOL);
        stringBuffer.append("putInQueryCache(null);").append(EOL);
        return stringBuffer.toString();
    }

    public String readOnlyFinderRunsInItsOwnTransaction() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Transaction orgTx = TransactionHelper.getTransactionHelper().getTransaction();\n");
            stringBuffer.append("try {\n");
            stringBuffer.append("TransactionManager tms = TxHelper.getTransactionManager();\n");
            stringBuffer.append("tms.suspend();\n");
            stringBuffer.append("tms.begin();\n");
            stringBuffer.append("Transaction tx = tms.getTransaction();\n");
            stringBuffer.append(this.cacheVar() + " = " + this.bmVar() + "." + this.wrapperSetFinder() + "(" + this.finderVar() + ", new Object[] {" + this.cpkVar() + "}, true);\n");
            stringBuffer.append("tx.commit();\n");
            stringBuffer.append("} catch(Exception e) {\n");
            stringBuffer.append(" throw e; }\n");
            stringBuffer.append("finally {\n");
            stringBuffer.append("TxHelper.getTransactionManager().resume(orgTx);\n");
            stringBuffer.append("}\n");
            return stringBuffer.toString();
        }
        return this.cacheVar() + " = " + this.bmVar() + "." + this.wrapperSetFinder() + "(" + this.finderVar() + ", new Object[] {" + this.cpkVar() + "}, true);";
    }

    public String isReadOnly() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (cMPBeanDescriptor.isReadOnly() || cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            return "true";
        }
        return "false";
    }

    public String perhapsDeclareReadWriteVars() {
        StringBuffer stringBuffer = new StringBuffer();
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (!cMPBeanDescriptor.isReadOnly() && cMPBeanDescriptor.getConcurrencyStrategy() != 4) {
            stringBuffer.append("private Set " + this.addVar() + ";" + EOL);
            stringBuffer.append("private Set " + this.removeVar() + ";" + EOL);
            stringBuffer.append("private RDBMSPersistenceManager " + this.pmVar() + ";" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsInitReadWriteVars() {
        StringBuffer stringBuffer = new StringBuffer();
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (!cMPBeanDescriptor.isReadOnly() && cMPBeanDescriptor.getConcurrencyStrategy() != 4) {
            stringBuffer.append(this.addVar() + " = new ArraySet(10);" + EOL);
            stringBuffer.append(this.removeVar() + " = new ArraySet(10);" + EOL);
            stringBuffer.append(this.pmVar() + " = (RDBMSPersistenceManager)" + this.creatorVar() + ".__WL_getPersistenceManager();" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsReconcileReadWriteChanges() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (!cMPBeanDescriptor.isReadOnly() && cMPBeanDescriptor.getConcurrencyStrategy() != 4) {
            stringBuffer.append(this.parse(this.getProductionRule("reconcileReadWriteChanges")));
        }
        return stringBuffer.toString();
    }

    public String perhapsDoAddForReadWrite() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (!cMPBeanDescriptor.isReadOnly() && cMPBeanDescriptor.getConcurrencyStrategy() != 4) {
            stringBuffer.append(this.parse(this.getProductionRule("doAddForReadWrite")));
        }
        return stringBuffer.toString();
    }

    public String perhapsDoRemoveForReadWrite() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.cmrField);
        if (!cMPBeanDescriptor.isReadOnly() && cMPBeanDescriptor.getConcurrencyStrategy() != 4) {
            stringBuffer.append(this.parse(this.getProductionRule("doRemoveForReadWrite")));
        }
        return stringBuffer.toString();
    }

    private static void debug(String string) {
        debugLogger.debug("[OneToManyGenerator] " + string);
    }
}

