/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.codegen;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.FieldGroup;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.RelationshipCaching;
import weblogic.ejb.container.cmp.rdbms.codegen.BaseCodeGenerator;
import weblogic.ejb.container.cmp.rdbms.codegen.CodeGenUtils;
import weblogic.ejb.container.cmp.rdbms.codegen.ManyToManyGenerator;
import weblogic.ejb.container.cmp.rdbms.codegen.OneToManyGenerator;
import weblogic.ejb.container.cmp.rdbms.codegen.StatementBinder;
import weblogic.ejb.container.cmp.rdbms.finders.EjbqlFinder;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.cmp.rdbms.finders.ParamNode;
import weblogic.ejb.container.cmp.rdbms.finders.SqlFinder;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.CMPCodeGenerator;
import weblogic.ejb.container.persistence.spi.EjbEntityRef;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.logging.Loggable;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;

public final class RDBMSCodeGenerator
extends BaseCodeGenerator {
    private RDBMSBean bean = null;
    private List cmpFieldNames = null;
    private List cmrFieldNames = null;
    private List pkFieldNames = null;
    private Map variableToClass = null;
    private Map variableToField = null;
    private List finderList = null;
    private Map beanMap = null;
    private List ejbSelectInternalList = null;
    private Map ejbSelectBeanTargetMap = null;
    private Map declaredManagerVars = new HashMap();
    private Finder curFinder = null;
    private String curField = null;
    private String curTableName = null;
    private int curTableIndex = 0;
    private FieldGroup curGroup = null;
    private String curTable = null;
    private String curSQL = null;
    private RelationshipCaching curRelationshipCaching = null;
    private int preparedStatementParamIndex = -1;
    private Map parameterMap = null;
    private char[] illegalJavaCharacters = new char[]{'@', '.', '-'};
    private boolean currFinderLoadsQueryCachingEnabledCMRFields = false;
    private Getopt2 options;
    private String currCachingElementCmrField = null;

    public RDBMSCodeGenerator(Getopt2 getopt2) {
        super(getopt2);
        this.options = getopt2;
    }

    public void setRDBMSBean(RDBMSBean rDBMSBean) {
        assert (rDBMSBean != null);
        assert (this.bd != null);
        this.bean = rDBMSBean;
        this.variableToClass = new HashMap();
        this.variableToField = new HashMap();
        this.cmpFieldNames = rDBMSBean.getCmpFieldNames();
        this.cmrFieldNames = rDBMSBean.getCmrFieldNames();
        for (Object object : this.cmpFieldNames) {
            this.variableToClass.put(object, rDBMSBean.getCmpFieldClass((String)object));
            this.variableToField.put(object, object);
        }
        this.pkFieldNames = new ArrayList(this.bd.getPrimaryKeyFieldNames());
        for (Object object : rDBMSBean.getForeignKeyFieldNames()) {
            if (!rDBMSBean.containsFkField((String)object)) continue;
            String string = rDBMSBean.getTableForCmrField((String)object);
            for (String string2 : rDBMSBean.getForeignKeyColNames((String)object)) {
                if (rDBMSBean.hasCmpField(string, string2)) continue;
                String string3 = rDBMSBean.variableForField((String)object, string, string2);
                Class clazz = rDBMSBean.getForeignKeyColClass((String)object, string2);
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("fkField: " + (String)object + " fkColumn: " + string2 + " fkVar: " + string3 + " fkClass: " + clazz.getName());
                }
                this.variableToClass.put(string3, clazz);
                this.variableToField.put(string3, object);
            }
        }
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("Variable to Class Map--------------------");
            for (String string : this.variableToClass.keySet()) {
                RDBMSCodeGenerator.debug("(" + string + ", \t" + ((Class)this.variableToClass.get(string)).getName());
            }
        }
        this.curTableName = rDBMSBean.getTableName();
        this.beanMap = rDBMSBean.getBeanMap();
    }

    public void setFinderList(List list) {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("RDBMSCodeGenerator.setFinderList(" + list + ")");
        }
        this.finderList = list;
        this.ejbSelectBeanTargetMap = new HashMap();
        for (Finder finder : list) {
            String string;
            RDBMSBean rDBMSBean;
            if (finder.getQueryType() != 4 || (rDBMSBean = finder.getSelectBeanTarget()) == null || this.ejbSelectBeanTargetMap.containsKey(string = rDBMSBean.getEjbName())) continue;
            this.ejbSelectBeanTargetMap.put(string, string);
        }
    }

    public void setEjbSelectInternalList(List list) {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("RDBMSCodeGenerator.setEjbSelectInternalList(" + list + ")");
        }
        this.ejbSelectInternalList = list;
    }

    public void setCMPBeanDescriptor(CMPBeanDescriptor cMPBeanDescriptor) {
        super.setCMPBeanDescriptor(cMPBeanDescriptor);
    }

    protected List typeSpecificTemplates() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("weblogic/ejb/container/cmp/rdbms/codegen/bean.j");
        arrayList.add("weblogic/ejb/container/cmp/rdbms/codegen/relationship.j");
        return arrayList;
    }

    public void setParameterMap(Map map) {
        this.parameterMap = map;
    }

    protected void prepare(CodeGenerator.Output output) throws EJBCException, ClassNotFoundException {
        super.prepare(output);
        assert (this.bean != null);
        assert (this.finderList != null);
        assert (this.pkFieldNames != null);
        assert (this.parameterMap != null);
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("cmp.rdbms.codegen.RDBMSCodeGenerator.prepare() called");
        }
    }

    public String getCategoryValueMethodBody() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.bean.getCategoryCmpField();
        if (string != null) {
            stringBuffer.append("return ");
            stringBuffer.append(string);
            stringBuffer.append(";");
            return stringBuffer.toString();
        }
        stringBuffer.append("throw new AssertionError(\"Categories not supported!\");");
        return stringBuffer.toString();
    }

    public String declareEjbSelectMethodVars() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (Finder finder : this.finderList) {
            boolean bl = finder.getQueryType() == 4 || finder.getQueryType() == 2 || finder instanceof SqlFinder && finder.isSelect();
            if (!bl) continue;
            stringBuffer.append("\n  public static java.lang.reflect.Method ");
            stringBuffer.append(this.ejbSelectMDName(finder));
            stringBuffer.append(";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    private String ejbSelectMDName(Finder finder) throws CodeGenerationException {
        return MethodUtils.ejbSelectMDName(finder);
    }

    public String implementEjbSelectMethods() throws CodeGenerationException {
        Iterator iterator = this.finderList.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string2;
            Class clazz;
            Finder finder = (Finder)iterator.next();
            int n = finder.getQueryType();
            if (finder.isSelect() && finder instanceof SqlFinder) {
                clazz = finder.getReturnClassType();
                string2 = this.varPrefix() + "ret";
                object4 = finder.getExternalMethodParmList();
                stringBuffer.append(MethodUtils.getFinderMethodDeclaration(finder, clazz.getName(), finder.getName(), (List)object4));
                stringBuffer.append("  {" + EOL);
                stringBuffer.append("Object " + string2 + " = ");
                stringBuffer.append(this.pmVar());
                stringBuffer.append(".processSqlFinder (");
                stringBuffer.append(this.ejbSelectMDName(finder));
                stringBuffer.append(", new Object [] {");
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (ParamNode)object3.next();
                    object = ((ParamNode)object2).getParamClass();
                    string = ((ParamNode)object2).getParamName();
                    stringBuffer.append(this.perhapsConvertPrimitive((Class)object, string));
                    if (!object3.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append("}, ");
                stringBuffer.append(finder.hasLocalResultType());
                stringBuffer.append(");");
                stringBuffer.append(EOL);
                stringBuffer.append(EOL);
                stringBuffer.append("if (" + string2 + "== null) {" + EOL);
                if (clazz.isPrimitive()) {
                    stringBuffer.append("throw new javax.ejb.FinderException (\"" + finder.getName() + " cannot return null.  Return type is " + ClassUtils.classToJavaSourceType(clazz) + ".\");" + EOL);
                } else {
                    stringBuffer.append("return null;" + EOL);
                }
                stringBuffer.append("}" + EOL);
                if (clazz.isPrimitive()) {
                    stringBuffer.append("return ((" + ClassUtils.classToJavaSourceType(ClassUtils.getObjectClass(clazz)) + ")" + string2 + ")" + this.lookupConvert(ClassUtils.getObjectClass(clazz)) + ";" + EOL);
                } else {
                    stringBuffer.append("return (" + ClassUtils.classToJavaSourceType(clazz) + ")" + string2 + ";" + EOL);
                }
                stringBuffer.append("}" + EOL);
                continue;
            }
            if (n == 4 || n == 2) {
                clazz = finder.getReturnClassType();
                string2 = this.varPrefix() + "ret";
                object4 = finder.getSelectBeanTarget().getEjbName();
                object3 = this.scalarFinder(finder);
                if (clazz.equals(Collection.class)) {
                    object3 = this.collectionFinder(finder);
                } else if (clazz.equals(Set.class)) {
                    object3 = this.setFinder(finder);
                }
                object2 = "";
                if (n == 4) {
                    object2 = this.bmVar((String)this.declaredManagerVars.get(object4));
                } else if (n == 2) {
                    object2 = "((CMPBeanManager) " + this.pmVar() + ".getBeanManager())";
                }
                stringBuffer.append("  ");
                object = finder.getExternalMethodParmList();
                string = MethodUtils.getFinderMethodDeclaration(finder, finder.getReturnClassType().getName(), finder.getName(), (List)object);
                stringBuffer.append(string);
                stringBuffer.append("  {" + EOL);
                stringBuffer.append("    ");
                stringBuffer.append(clazz.getName());
                stringBuffer.append(" " + string2 + " = null;");
                stringBuffer.append(EOL);
                if (finder.isSelectInEntity()) {
                    stringBuffer.append("Object ").append(this.selectInEntityPKVar()).append(" = ");
                    stringBuffer.append(" __WL_ctx.getPrimaryKey();");
                    stringBuffer.append(EOL);
                }
                stringBuffer.append("try {");
                stringBuffer.append("      ");
                stringBuffer.append(string2 + " = " + "(" + clazz.getName() + ")" + EOL);
                stringBuffer.append((String)object2);
                stringBuffer.append(".");
                stringBuffer.append((String)object3 + "(");
                stringBuffer.append(this.ejbSelectMDName(finder) + "," + EOL);
                stringBuffer.append("new Object[] { ");
                stringBuffer.append(this.wrapped_ejbSelect_params(finder.getExternalMethodAndInEntityParmList()));
                stringBuffer.append(" } ");
                stringBuffer.append(" ); " + EOL);
                stringBuffer.append(this.parse(this.getProductionRule("selectCatch")));
                stringBuffer.append("return " + string2 + ";" + EOL);
                stringBuffer.append("}");
                stringBuffer.append(EOL);
                continue;
            }
            if (n != 3 && n != 5) continue;
            stringBuffer.append(this.implementEJBSelectField(finder));
        }
        return stringBuffer.toString();
    }

    public String implementEjbSelectInternalMethods() throws CodeGenerationException {
        if (this.ejbSelectInternalList == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Finder finder : this.ejbSelectInternalList) {
            try {
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("generating ejbSelectInternal Finder: " + finder);
                }
                stringBuffer.append(this.implementFinderMethod(finder));
            }
            catch (EJBCException eJBCException) {
                Loggable loggable = EJBLogger.logCouldNotGenerateFinderLoggable((String)"ejbSelectInternal", (String)finder.toString(), (String)eJBCException.toString());
                throw new CodeGenerationException(loggable.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    private String implementEJBSelectField(Finder finder) throws CodeGenerationException {
        StringBuffer stringBuffer;
        block11: {
            if (debugLogger.isDebugEnabled()) {
                RDBMSCodeGenerator.debug("ejb.container.cmp.rdbms.codegen.RDBMSCodeGenerator.implementEJBSelectField(" + finder + ") called.");
            }
            assert (this.bd != null);
            this.curFinder = finder;
            if (this.curFinder == null) {
                Loggable loggable = EJBLogger.logNullFinderLoggable((String)"implementEJBSelectField");
                throw new CodeGenerationException(loggable.getMessage());
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(MethodUtils.getFinderMethodDeclaration(finder, finder.getReturnClassType()));
            stringBuffer.append("{" + EOL);
            try {
                if (finder.isResultSetFinder()) {
                    stringBuffer.append(this.parse(this.getProductionRule("ejbSelectFieldBodyResultSet")));
                    break block11;
                }
                if (finder.isMultiFinder()) {
                    stringBuffer.append(this.parse(this.getProductionRule("ejbSelectFieldBodyMulti")));
                    break block11;
                }
                try {
                    stringBuffer.append(this.parse(this.getProductionRule("ejbSelectFieldBodyScalar")));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new CodeGenerationException(throwable.getMessage());
                }
            }
            catch (CodeGenerationException codeGenerationException) {
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("finderMethod cought CodeGenerationException : " + (Object)((Object)codeGenerationException));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CodeGenerationException(exception.getMessage());
            }
        }
        stringBuffer.append("" + EOL + "}" + EOL);
        this.curFinder = null;
        return stringBuffer.toString();
    }

    public String implementClearCMRFields() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curField : this.bean.getCmrFieldNames()) {
            if (!this.addCMRClearForCurrentField()) continue;
            stringBuffer.append(this.fieldVarForField() + " = null;" + EOL);
        }
        return stringBuffer.toString();
    }

    private boolean addCMRClearForCurrentField() {
        return this.bean.isOneToOneRelation(this.curField) && this.bean.isForeignKeyField(this.curField) || this.bean.isOneToManyRelation(this.curField) && !this.bean.getRelatedMultiplicity(this.curField).equals("One") || this.bean.isManyToManyRelation(this.curField);
    }

    public String ejbSelectFieldResultVar() {
        return this.varPrefix() + "retVal";
    }

    public boolean validateEjbSelectFieldReturnType(String string) {
        return true;
    }

    public boolean validateEjbSelectFieldCollReturnType(String string) {
        return true;
    }

    public String declareEjbSelectFieldResultVar() {
        Class clazz = this.curFinder.getReturnClassType();
        String string = clazz.getName();
        this.validateEjbSelectFieldReturnType(string);
        return this.declareEjbSelectFieldResultVar(clazz);
    }

    public String declareEjbSelectFieldCollResultVar() {
        Class clazz = this.curFinder.getSelectFieldClass();
        if (clazz.isPrimitive()) {
            clazz = ClassUtils.getObjectClass(clazz);
        }
        String string = clazz.getName();
        this.validateEjbSelectFieldCollReturnType(string);
        return this.declareEjbSelectFieldResultVar(clazz);
    }

    public String declareEjbSelectFieldResultVar(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ClassUtils.classToJavaSourceType(clazz);
        stringBuffer.append("    ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.ejbSelectFieldResultVar());
        if (clazz.isPrimitive()) {
            stringBuffer.append(" = ");
            stringBuffer.append(ClassUtils.getDefaultValue(clazz));
            stringBuffer.append(";");
        } else {
            stringBuffer.append(" = null;");
        }
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String perhapsDeclareDistinctFilterVar() {
        if (this.curFinder.isMultiFinder() && !this.curFinder.isSetFinder() && this.curFinder.isSelectDistinct()) {
            return new String(this.declareSetVar() + EOL);
        }
        return "";
    }

    public String assignEjbSelectFieldResultVar() {
        Class clazz = this.curFinder.getReturnClassType();
        return this.assignEjbSelectFieldResultVar(clazz);
    }

    public String assignEjbSelectFieldCollResultVar() {
        Class clazz = this.curFinder.getSelectFieldClass();
        if (clazz.isPrimitive()) {
            clazz = ClassUtils.getObjectClass(clazz);
        }
        return this.assignEjbSelectFieldResultVar(clazz);
    }

    public String assignEjbSelectFieldResultVar(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    ");
        stringBuffer.append(this.ejbSelectFieldResultVar());
        stringBuffer.append(" = ");
        stringBuffer.append(this.resultSetToVariable(1, clazz, null));
        stringBuffer.append(";");
        if (!clazz.isPrimitive()) {
            stringBuffer.append("  if (").append(this.rsVar()).append(".wasNull()) { ");
            stringBuffer.append(this.ejbSelectFieldResultVar());
            stringBuffer.append(" = null; }").append(EOL);
        }
        return stringBuffer.toString();
    }

    public String checkNullForAggregateQuery() throws CodeGenerationException {
        Class clazz = this.curFinder.getReturnClassType();
        if (clazz.isPrimitive() && this.curFinder.isAggregateQuery()) {
            return this.parse(this.getProductionRule("checkNullForAggregateQueries"));
        }
        return "";
    }

    public String addEjbSelectFieldToList() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.curFinder.isSelectDistinct()) {
            stringBuffer.append("if (" + this.setVar() + ".add(" + this.ejbSelectFieldResultVar() + ")) {" + EOL);
            stringBuffer.append("list.add(" + this.ejbSelectFieldResultVar() + ");" + EOL);
            stringBuffer.append("}" + EOL);
        } else {
            stringBuffer.append("list.add(" + this.ejbSelectFieldResultVar() + ");" + EOL);
        }
        return stringBuffer.toString();
    }

    public String ejbSelect_result_set_to_collection_class() throws CodeGenerationException {
        assert (this.curFinder != null);
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = this.curFinder.getReturnClassType();
        if (clazz.equals(Collection.class)) {
            stringBuffer.append(this.parse(this.getProductionRule("ejbSelectFieldToCollection")));
        } else if (clazz.equals(Set.class)) {
            stringBuffer.append(this.parse(this.getProductionRule("ejbSelectFieldToSet")));
        } else {
            throw new AssertionError((Object)"Invalid return type for ejbSelect.");
        }
        return stringBuffer.toString();
    }

    private String wrapped_ejbSelect_params(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ParamNode paramNode : list) {
            if (paramNode.isBeanParam()) {
                stringBuffer.append(paramNode.getParamName());
                stringBuffer.append(", ");
                continue;
            }
            if (paramNode.isSelectInEntity()) {
                stringBuffer.append("__WL_ctx.getPrimaryKey(), ");
                continue;
            }
            stringBuffer.append(this.wrapped_param(paramNode.getParamClass().getName(), paramNode.getParamName()));
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private String wrapped_param(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = bl = !this.primConversion(string).equals(string);
        if (bl) {
            stringBuffer.append("new " + this.primConversion(string) + "(");
        }
        stringBuffer.append(" " + string2);
        if (bl) {
            stringBuffer.append(" )");
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private String primConversion(String string) {
        String string2 = string;
        if (string.equals("boolean")) {
            string2 = "Boolean";
        }
        if (string.equals("int")) {
            string2 = "Integer";
        }
        if (string.equals("short")) {
            string2 = "Short";
        }
        if (string.equals("long")) {
            string2 = "Long";
        }
        if (string.equals("double")) {
            string2 = "Double";
        }
        if (string.equals("float")) {
            string2 = "Float";
        }
        if (string.equals("char")) {
            string2 = "Character";
        }
        if (string.equals("byte")) {
            string2 = "Byte";
        }
        return string2;
    }

    private String primInitialization(String string) {
        String string2 = "null";
        if (string.equals("boolean")) {
            string2 = "false";
        }
        if (string.equals("int")) {
            string2 = "0";
        }
        if (string.equals("short")) {
            string2 = "0";
        }
        if (string.equals("long")) {
            string2 = "0";
        }
        if (string.equals("double")) {
            string2 = "0.0";
        }
        if (string.equals("float")) {
            string2 = "0.0";
        }
        if (string.equals("char")) {
            string2 = "0x00";
        }
        if (string.equals("byte")) {
            string2 = "0x00";
        }
        return string2;
    }

    public void checkCurFinder() throws CodeGenerationException {
        if (this.curFinder == null) {
            Loggable loggable = EJBLogger.logNullFinderLoggable((String)"checkCurFinder");
            throw new CodeGenerationException(loggable.getMessage());
        }
    }

    public String getRemoteHomeVarForFinder() throws CodeGenerationException {
        ParamNode paramNode;
        String string = null;
        EjbqlFinder ejbqlFinder = (EjbqlFinder)this.curFinder;
        if (ejbqlFinder.hasRemoteBeanParam() && (paramNode = ejbqlFinder.getRemoteBeanParam()) != null) {
            string = paramNode.getId();
        }
        if (string == null) {
            paramNode = EJBLogger.logNoCMRFieldForRemoteRelationshipLoggable((String)this.curFinder.getName());
            throw new CodeGenerationException(paramNode.getMessage());
        }
        return this.homeVar(string);
    }

    public String currentFinderName() throws CodeGenerationException {
        this.checkCurFinder();
        return this.curFinder.getName();
    }

    public String declarePkVarIfLoadsBean() throws CodeGenerationException {
        if (this.curFinder.finderLoadsBean()) {
            return this.declarePkVar();
        }
        return "";
    }

    public Class getRemotePKClass() throws CodeGenerationException {
        String string = null;
        assert (this.curFinder instanceof EjbqlFinder);
        EjbqlFinder ejbqlFinder = (EjbqlFinder)this.curFinder;
        if (!ejbqlFinder.hasRemoteBeanParam()) {
            Loggable loggable = EJBLogger.logNoRemoteHomeLoggable((String)ejbqlFinder.getName());
            throw new CodeGenerationException(loggable.getMessage());
        }
        Object object = ejbqlFinder.getRemoteBeanParam();
        string = ((ParamNode)object).getRemoteHomeName();
        object = null;
        object = this.loadClass(string);
        Method[] methodArray = ((Class)object).getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getName().compareTo("findByPrimaryKey") != 0) continue;
            method = methodArray[i];
            break;
        }
        if (method == null) {
            Loggable loggable = EJBLogger.logMethodNotFoundInInterfaceLoggable((String)"findByPrimaryKey", (String)string);
            throw new CodeGenerationException(loggable.getMessage());
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 1) {
            Loggable loggable = EJBLogger.logMethodHasWrongParamCountLoggable((String)"findByPrimaryKey", (String)string, (String)"1");
            throw new CodeGenerationException(loggable.getMessage());
        }
        Class<?> clazz = classArray[0];
        String string2 = classArray[0].getName();
        return clazz;
    }

    public String getRemotePKClassString() throws CodeGenerationException {
        Class clazz = this.getRemotePKClass();
        return clazz.getName();
    }

    public String getRemotePKObject() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = this.getRemotePKClass();
        String string = clazz.getName();
        if (string.startsWith("java.lang.")) {
            stringBuffer.append(this.parse(this.getProductionRule("remoteReadJavaLangEOColumn")));
        } else {
            stringBuffer.append(this.parse(this.getProductionRule("remoteReadJavaObjectEOColumn")));
        }
        return stringBuffer.toString();
    }

    public String PkOrGenBeanClassName() throws CodeGenerationException {
        if (this.curFinder.finderLoadsBean()) {
            return this.getGeneratedBeanClassName();
        }
        return this.pk_class();
    }

    public String PkVarOrWLBean() throws CodeGenerationException {
        if (this.curFinder.finderLoadsBean()) {
            return this.beanVar();
        }
        return this.pkVar();
    }

    public int getPKOrGroupColumnCount() {
        return ((EjbqlFinder)this.curFinder).getPKOrGroupColumnCount();
    }

    public int getGroupColumnCount(RDBMSBean rDBMSBean, String string) {
        FieldGroup fieldGroup = rDBMSBean.getFieldGroup(string);
        if (fieldGroup == null) {
            return rDBMSBean.getPrimaryKeyFields().size();
        }
        HashSet<String> hashSet = new HashSet<String>();
        TreeSet treeSet = new TreeSet(fieldGroup.getCmpFields());
        treeSet.addAll(rDBMSBean.getPrimaryKeyFields());
        for (Object object : treeSet) {
            hashSet.add(rDBMSBean.getCmpColumnForField((String)object));
        }
        for (String string2 : fieldGroup.getCmrFields()) {
            for (String string3 : rDBMSBean.getForeignKeyColNames(string2)) {
                hashSet.add(string3);
            }
        }
        return hashSet.size();
    }

    public String otherPkVar() {
        return this.pkVar() + "_2";
    }

    public String declareOtherPkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        stringBuffer.append(this.pk_class() + " " + this.otherPkVar() + " = ");
        if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
            stringBuffer.append("new " + this.pk_class() + "();");
        } else {
            stringBuffer.append("null;");
        }
        return stringBuffer.toString();
    }

    private Class loadClass(String string) throws CodeGenerationException {
        Class<?> clazz = null;
        try {
            clazz = this.bd.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Loggable loggable = EJBLogger.logUnableToLoadClassLoggable((String)"RDBMSCodeGenerator", (String)string);
            throw new CodeGenerationException(loggable.getMessage());
        }
        return clazz;
    }

    public String debugVar() {
        return this.varPrefix() + "debugLogger";
    }

    public String debugEnabled() {
        return this.debugVar() + ".isDebugEnabled()";
    }

    public String debugSay() {
        return this.varPrefix() + "debug";
    }

    public String beanVar() {
        return this.varPrefix() + "bean";
    }

    public String eoVar() {
        return this.varPrefix() + "eo";
    }

    public String eoRCVar() {
        return this.varPrefix() + "eo_rc";
    }

    public String pkVar() {
        return this.varPrefix() + "pk";
    }

    public String fkVar() {
        return this.varPrefix() + "fk";
    }

    public String conVar() {
        return this.varPrefix() + "con";
    }

    public String rsVar() {
        return this.varPrefix() + "rs";
    }

    public String rsInfoVar() {
        return this.varPrefix() + "rsInfo";
    }

    public String stmtVar() {
        return this.varPrefix() + "stmt";
    }

    public String currStmtArrayVar() {
        return this.stmtArrayElement(this.curTableIndex);
    }

    public String stmtArrayVar() {
        return this.varPrefix() + "stmt_array";
    }

    public String stmtArrayElement(int n) {
        return this.varPrefix() + "stmt_array[" + n + "]";
    }

    public String stmtTableVar(String string) {
        return this.varPrefix() + "stmt" + "_" + this.replaceIllegalJavaCharacters(string) + "_" + this.bean.tableIndex(string);
    }

    public String pmVar() {
        return this.varPrefix() + "pm";
    }

    public String keyVar() {
        return this.varPrefix() + "key";
    }

    public String numVar() {
        return this.varPrefix() + "num";
    }

    public String txVar() {
        return this.varPrefix() + "tx";
    }

    public String offsetVar() {
        return this.varPrefix() + "offset";
    }

    public String offsetIntObjVar() {
        return this.varPrefix() + "offsetIntObj";
    }

    public String pkMapVar() {
        return this.varPrefix() + "pkMap";
    }

    public String isMultiVar() {
        return this.varPrefix() + "isMulti";
    }

    public String queryVar() {
        return this.varPrefix() + "query";
    }

    public String queryArrayVar() {
        return this.varPrefix() + "query_array";
    }

    public String queryArrayElement(int n) {
        return this.varPrefix() + "query_array[" + n + "]";
    }

    public String iVar() {
        return this.varPrefix() + "i";
    }

    public String countVar() {
        return this.varPrefix() + "count";
    }

    public String totalVar() {
        return this.varPrefix() + "total";
    }

    public String blobClobCountVar() {
        return this.varPrefix() + "blobClob_count";
    }

    public String oldStateVar() {
        return this.varPrefix() + "oldState";
    }

    public String setBlobClobForOutputMethodName() {
        return this.varPrefix() + "set_" + this.curField + "ForOutput";
    }

    public String setBlobClobForInputMethodName() {
        return this.varPrefix() + "set_" + this.curField + "ForInput";
    }

    public String classLoaderVar() {
        return this.varPrefix() + "classLoader";
    }

    public String ctxVar() {
        return this.varPrefix() + "ctx";
    }

    public String jctxVar() {
        return this.varPrefix() + "initialCtx";
    }

    public String isModifiedVar() {
        return this.varPrefix() + "isModified";
    }

    public String beanIsModifiedVar() {
        return this.varPrefix() + "beanIsModified";
    }

    public String isModifiedUnionVar() {
        return this.varPrefix() + "isModifiedUnion";
    }

    public String modifiedBeanIsRegisteredVar() {
        return this.varPrefix() + "modifiedBeanIsRegistered";
    }

    public String beanIsLoadedVar() {
        return this.varPrefix() + "beanIsLoaded";
    }

    public String invalidatedBeanIsRegisteredVar() {
        return this.varPrefix() + "invalidatedBeanIsRegistered";
    }

    public String isLoadedVar() {
        return this.varPrefix() + "isLoaded";
    }

    public String colVar() {
        return this.varPrefix() + "collection";
    }

    public String setVar() {
        return this.varPrefix() + "set";
    }

    public String orderedSetVar() {
        return this.varPrefix() + "orderedSet";
    }

    public String selectInEntityPKVar() {
        return this.varPrefix() + "selectInEntityPK";
    }

    public String mapVar() {
        return this.varPrefix() + "map";
    }

    public String stringVar(int n) {
        return this.varPrefix() + "stringVar" + n;
    }

    public String tempVar(int n) {
        return this.varPrefix() + "tempVar" + n;
    }

    public String sqlTimestampVar(int n) {
        return this.varPrefix() + "sqlTimestampVar" + n;
    }

    private String bmVar(String string) {
        return this.varPrefix() + ClassUtils.makeLegalName(string) + "_bm";
    }

    private String genKeyVar() {
        return this.varPrefix() + "genKey";
    }

    private String byteArrayVar(String string) {
        return this.varPrefix() + "byteArray_" + string;
    }

    private String tableModifiedVar(String string) {
        if (this.bean.hasMultipleTables()) {
            return this.varPrefix() + "tableModified" + this.replaceIllegalJavaCharacters(string);
        }
        return this.modifiedBeanIsRegisteredVar();
    }

    public String tableModifiedVar() {
        return this.tableModifiedVar(this.curTable);
    }

    private String tableLoadedVar(String string) {
        if (this.bean.hasMultipleTables()) {
            return this.varPrefix() + "tableLoaded" + this.replaceIllegalJavaCharacters(string);
        }
        return this.beanIsLoadedVar();
    }

    public String tableLoadedVar() {
        return this.tableLoadedVar(this.curTable);
    }

    private String snapshotBufferVar() {
        return "sb_snap";
    }

    public String createMethodName() {
        return this.varPrefix() + "create";
    }

    public String existsMethodName() {
        return this.varPrefix() + "exists";
    }

    public String invalidVar() {
        return this.varPrefix() + "invalid";
    }

    public String rowSetFactoryVar() {
        return this.varPrefix() + "rowSetFactory";
    }

    public String rowSetVar() {
        return this.varPrefix() + "rowSet";
    }

    public String rowSetFactoryName() {
        return "weblogic.jdbc.rowset.RowSetFactory ";
    }

    public String replaceIllegalJavaCharacters(String string) {
        String string2 = string;
        for (int i = 0; i < this.illegalJavaCharacters.length; ++i) {
            string2 = string2.replace(this.illegalJavaCharacters[i], '_');
        }
        return string2;
    }

    public String perhapsDeclareRowSetFactoryVar() {
        if (this.bean.hasResultSetFinder()) {
            return "private static " + this.rowSetFactoryName() + " " + this.rowSetFactoryVar() + " = null;";
        }
        return "";
    }

    public String declareStmtArrayVars() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        stringBuffer.append("java.sql.PreparedStatement[] ").append(this.stmtArrayVar()).append(" = ");
        stringBuffer.append("new java.sql.PreparedStatement[").append(this.bean.tableCount()).append("];");
        stringBuffer.append(EOL).append(EOL);
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            this.curTableIndex = i;
            this.curTableName = this.bean.tableAt(i);
            stringBuffer.append("java.sql.PreparedStatement ").append(this.stmtTableVar(this.curTableName)).append(" = null;").append(EOL);
            stringBuffer.append(this.stmtArrayElement(i)).append(" = ").append(this.stmtTableVar(this.curTableName)).append(";").append(EOL);
        }
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String declareQueryArrayVars() {
        return EOL + "String[] " + this.queryArrayVar() + " = new String[" + this.bean.tableCount() + "];" + EOL;
    }

    public String declareContainerManagedFieldVars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.cmpFieldNames) {
            stringBuffer.append("public ");
            stringBuffer.append(ClassUtils.classToJavaSourceType(this.bean.getCmpFieldClass(string)) + " ");
            stringBuffer.append(string + ";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    private List foreignKeyVarNames(String string) {
        String string2 = this.bean.getTableForCmrField(string);
        Iterator iterator = this.bean.getForeignKeyColNames(string).iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            arrayList.add(this.bean.variableForField(string, string2, string3));
        }
        return arrayList;
    }

    public String declareForeignKeyFieldVars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getForeignKeyFieldNames()) {
            if (!this.bean.containsFkField(string) || this.bean.isForeignCmpField(string)) continue;
            String string2 = this.bean.getTableForCmrField(string);
            for (String string3 : this.bean.getForeignKeyColNames(string)) {
                String string4 = ClassUtils.classToJavaSourceType(this.bean.getForeignKeyColClass(string, string3));
                String string5 = this.bean.variableForField(string, string2, string3);
                stringBuffer.append("public ");
                stringBuffer.append(string4 + " ");
                stringBuffer.append(string5 + ";");
                stringBuffer.append(EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String declareRelationFieldVars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getCmrFieldNames()) {
            String string2 = CodeGenUtils.fieldVarName(string);
            String string3 = ClassUtils.classToJavaSourceType(this.bean.getCmrFieldClass(string));
            stringBuffer.append("public ");
            stringBuffer.append(string3 + " ");
            stringBuffer.append(string2 + ";");
            stringBuffer.append(EOL);
            if (!this.bean.isSelfRelationship(string)) continue;
            String string4 = CodeGenUtils.fieldRemovedVarName(string);
            stringBuffer.append("public ");
            stringBuffer.append(string3 + " ");
            stringBuffer.append(string4 + ";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    private String finderVarName(String string) {
        return this.varPrefix() + string + "_finder_";
    }

    public String declareStaticFinderVars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getCmrFieldNames()) {
            String string2 = this.relInterfaceNameForField(string);
            String string3 = this.bean.finderMethodName(this.bd, string);
            String string4 = this.finderVarName(string);
            stringBuffer.append("private static final java.lang.reflect.Method ");
            stringBuffer.append(string4);
            stringBuffer.append(";");
            stringBuffer.append(EOL);
        }
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String assignStaticFinderVars() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        if (iterator.hasNext()) {
            stringBuffer.append("static {");
            stringBuffer.append(EOL);
            stringBuffer.append("Method m = null;");
            stringBuffer.append(EOL);
            for (String string : this.bean.getCmrFieldNames()) {
                String string2 = this.relInterfaceNameForField(string);
                String string3 = this.finderVarName(string);
                String string4 = this.generateCMRFieldFinderMethodName(string);
                stringBuffer.append("try {");
                stringBuffer.append(EOL);
                stringBuffer.append("m = ");
                stringBuffer.append(string2);
                stringBuffer.append(".class.getMethod(\"");
                stringBuffer.append(string4);
                stringBuffer.append("\", ");
                if (this.bean.isManyToManyRelation(string)) {
                    stringBuffer.append(" new Class[] { Object.class } ");
                } else {
                    stringBuffer.append(this.primaryFieldClassesArray(string));
                }
                stringBuffer.append(");" + EOL);
                stringBuffer.append("} catch (NoSuchMethodException ignore) {");
                stringBuffer.append(EOL);
                stringBuffer.append("m = null;");
                stringBuffer.append(EOL);
                stringBuffer.append("}");
                stringBuffer.append(EOL);
                stringBuffer.append(string3);
                stringBuffer.append(" = m;");
                stringBuffer.append(EOL);
            }
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsInitializeIsModified() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(this.isModifiedVar());
            stringBuffer.append("[");
            stringBuffer.append(this.iVar());
            stringBuffer.append("] = false;");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsInitializeModifiedBeanIsRegisteredVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(this.modifiedBeanIsRegisteredVar());
            stringBuffer.append(" = false;");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsOrTermForIsModified() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append("|| ");
            stringBuffer.append(this.isModifiedVarForField());
        }
        return stringBuffer.toString();
    }

    public String declareIsModifiedVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append("private boolean[] " + this.isModifiedVar() + " = new boolean[" + this.bean.getFieldCount() + "];" + EOL);
            stringBuffer.append("private boolean " + this.modifiedBeanIsRegisteredVar() + "= false;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String declareisModifiedUnionVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isModifiedUnionVar() + " = new boolean[" + this.bean.getFieldCount() + "];" + EOL);
        return stringBuffer.toString();
    }

    public String perhapsComputeModifiedUnion() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(this.parse(this.getProductionRule("computeModifiedUnion")));
        }
        return stringBuffer.toString();
    }

    public String perhapsImplementResetIsModifiedVarsMethodBody() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(this.parse(this.getProductionRule("implementResetIsModifiedVarsMethodBody")));
        }
        return stringBuffer.toString();
    }

    public String fieldsWoFkColumns() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (n = 0; n < this.cmpFieldNames.size(); ++n) {
            stringBuffer.append("(" + this.iVar() + "==" + n2 + ") || ");
            ++n2;
        }
        for (n = 0; n < this.bean.tableCount(); ++n) {
            List list = this.bean.getCMRFields(n);
            for (String string : list) {
                if (this.bean.isSelfRelationship(string) && this.bean.containsFkField(string) && !this.bean.isForeignCmpField(string)) {
                    stringBuffer.append("(" + this.iVar() + "==" + n2 + ") || ");
                }
                ++n2;
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 4);
        return stringBuffer.toString();
    }

    public String perhapsIsFkColsNullableCheck(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.isOneToOneRelation(string) && !this.bean.isSelfRelationship(string) || this.bean.isOneToManyRelation(string)) {
            String string2 = null;
            string2 = this.bean.isSelfRelationship(string) ? CodeGenUtils.fieldRemovedVarName(string) : CodeGenUtils.fieldVarName(string);
            stringBuffer.append(" && (" + this.pmVar() + ".isFkColsNullable(\"" + string + "\") || " + string2 + " != null || !__WL_getIsRemoved())");
        }
        return stringBuffer.toString();
    }

    public String perhapsAddSelfRelatedBeansToInsertStmt() throws CodeGenerationException {
        if (!this.bean.getOrderDatabaseOperations() || !this.bean.isSelfRelationship()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getDeclaredFieldNames().iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        while (iterator.hasNext()) {
            this.curField = (String)iterator.next();
            if (!this.bean.isOneToManyRelation(this.curField) || !this.bean.isSelfRelationship(this.curField) || !this.bean.getRelatedMultiplicity(this.curField).equals("One")) continue;
            stringBuffer.append(this.parse(this.getProductionRule("implementAddSelfRelatedBeansToInsertStmtMethodBody")));
        }
        return stringBuffer.toString();
    }

    public String perhapsAddSelfRelatedBeansToDeleteStmt() throws CodeGenerationException {
        if (!this.bean.getOrderDatabaseOperations() || !this.bean.isSelfRelationship()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getDeclaredFieldNames().iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        while (iterator.hasNext()) {
            this.curField = (String)iterator.next();
            if (!this.bean.isOneToManyRelation(this.curField) || !this.bean.isSelfRelationship(this.curField) || !this.bean.getRelatedMultiplicity(this.curField).equals("Many")) continue;
            stringBuffer.append(this.parse(this.getProductionRule("implementAddSelfRelatedBeansToDeleteStmtMethodBody")));
        }
        return stringBuffer.toString();
    }

    public String perhapsImplementResetIsModifiedVarsMethodBodyOpnBased() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(this.parse(this.getProductionRule("implementResetIsModifiedVarsMethodBodyOpnBased")));
        }
        return stringBuffer.toString();
    }

    public String setBlobClobBasedOnOperation() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bean.hasBlobClobColumn()) {
            stringBuffer.append("// No blob/clob field is defined for this cmp bean ;" + EOL);
        } else {
            stringBuffer.append("if (operation == DDConstants.INSERT) { " + EOL);
            stringBuffer.append(this.setBlobClobForCreate());
            stringBuffer.append("} else{ " + EOL);
            stringBuffer.append(this.setBlobClobForStore());
            stringBuffer.append("} " + EOL);
        }
        return stringBuffer.toString();
    }

    public String determineBeanParamsForCreateArray() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bean.hasClobColumn()) {
            stringBuffer.append(this.setBeanParamsForCreateArray() + EOL);
        } else {
            stringBuffer.append("if(" + this.pmVar() + ".perhapsUseSetStringForClobForOracle()){" + EOL);
            stringBuffer.append(this.setBeanParamsForCreateArrayOptimizedForClobUpdate() + EOL);
            stringBuffer.append("} else{ " + EOL);
            stringBuffer.append(this.setBeanParamsForCreateArray() + EOL);
            stringBuffer.append("} " + EOL);
        }
        return stringBuffer.toString();
    }

    public String declareIsInvalidatedVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("private boolean " + this.invalidatedBeanIsRegisteredVar() + "= false;" + EOL);
        return stringBuffer.toString();
    }

    public String declareIsLoadedVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("private boolean[] ");
        stringBuffer.append(this.isLoadedVar());
        stringBuffer.append(" = new boolean[");
        stringBuffer.append(this.bean.getFieldCount());
        stringBuffer.append("];");
        stringBuffer.append(EOL);
        stringBuffer.append("private boolean " + this.beanIsLoadedVar() + "= false;" + EOL);
        return stringBuffer.toString();
    }

    public String isCmrLoadedVarName(String string) {
        return this.varPrefix() + string + "_isLoaded_";
    }

    public String isCmrLoadedVarNameForField() {
        return this.isCmrLoadedVarName(this.curField);
    }

    public String declareCmrIsLoadedVars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getCmrFieldNames()) {
            String string2 = this.isCmrLoadedVarName(string);
            stringBuffer.append("public ");
            stringBuffer.append("boolean ");
            stringBuffer.append(string2 + " = false;");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String assignCmrIsLoadedFalse() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(EOL);
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.isCmrLoadedVarName(string);
            stringBuffer.append(string2 + " = false;");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String declareEntityContextVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("private EntityContext " + this.ctxVar() + ";");
        return stringBuffer.toString();
    }

    public String perhapsDeclareInitialContext() {
        if (this.bean.getRemoteFieldNames().size() > 0) {
            return "Context " + this.jctxVar() + " = null;";
        }
        return "";
    }

    public String perhapsDeclareTableLoadedModifiedVars() {
        if (!this.bean.isOptimistic() && !this.bean.getVerifyReads()) {
            return "";
        }
        if (!this.bean.hasMultipleTables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            stringBuffer.append("private boolean " + this.tableModifiedVar(string) + " = false;" + EOL);
            stringBuffer.append("private boolean " + this.tableLoadedVar(string) + " = false;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsInitializeTableLoadedModifiedVars() {
        if (!this.bean.isOptimistic() && !this.bean.getVerifyReads()) {
            return "";
        }
        if (!this.bean.hasMultipleTables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            stringBuffer.append(this.tableModifiedVar(string) + " = false;" + EOL);
            stringBuffer.append(this.tableLoadedVar(string) + " = false;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsSetTableLoadedVarsForBean() {
        if (!this.bean.isOptimistic() && !this.bean.getVerifyReads()) {
            return "";
        }
        if (!this.bean.hasMultipleTables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            stringBuffer.append(this.tableLoadedVar(string) + " = true;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsSetTableLoadedVarsForGroup() {
        if (!this.bean.isOptimistic() && !this.bean.getVerifyReads()) {
            return "";
        }
        if (!this.bean.hasMultipleTables()) {
            return "";
        }
        assert (this.curGroup != null);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTableNamesForGroup(this.curGroup.getName())) {
            stringBuffer.append(this.tableLoadedVar(string) + " = true;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsSetTableModifiedVarForCmpField() {
        if (!this.bean.isOptimistic() && !this.bean.getVerifyReads()) {
            return "";
        }
        if (!this.bean.hasMultipleTables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.bean.getTableForCmpField(this.curField);
        stringBuffer.append(this.tableModifiedVar(string) + " = true;" + EOL);
        return stringBuffer.toString();
    }

    public String perhapsSetTableModifiedVarForCmrField() {
        if (!this.bean.isOptimistic() && !this.bean.getVerifyReads()) {
            return "";
        }
        if (!this.bean.hasMultipleTables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.bean.getTableForCmrField(this.curField);
        stringBuffer.append(this.tableModifiedVar(string) + " = true;" + EOL);
        return stringBuffer.toString();
    }

    public String perhapsSetTableModifiedVarsForBean() {
        if (!this.bean.isOptimistic() && !this.bean.getVerifyReads()) {
            return "";
        }
        if (!this.bean.hasMultipleTables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            stringBuffer.append(this.tableModifiedVar(string) + " = true;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsResetTableModifiedVarsForBean() {
        if (!this.bean.isOptimistic() && !this.bean.getVerifyReads()) {
            return "";
        }
        if (!this.bean.hasMultipleTables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            stringBuffer.append(this.tableModifiedVar(string) + " = false;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsOptFieldCheckForBatch() throws CodeGenerationException {
        String string;
        if (this.bd.isOptimistic() && (this.bean.getVerifyColumns(string = this.curTableName).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp"))) {
            String string2 = this.bean.getOptimisticColumn(string);
            String string3 = this.bean.getCmpField(string, string2);
            return "|| (" + this.isLoadedVar(string3) + " || " + this.isModifiedVar(string3) + ")";
        }
        return "";
    }

    public String perhapsAppendVerifySqlForBatch() throws CodeGenerationException {
        if (!this.bean.isOptimistic()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curTable : this.bean.getTables()) {
            stringBuffer.append(this.parse(this.getProductionRule("appendVerifySqlForTableForBatch")));
            this.curTable = null;
        }
        return stringBuffer.toString();
    }

    public String perhapsSetVerifyParamsForBatch() throws CodeGenerationException {
        if (!this.bean.isOptimistic()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curTable : this.bean.getTables()) {
            int n = this.bean.tableIndex(this.curTable);
            stringBuffer.append("if ((" + this.tableLoadedVar() + " && " + this.tableModifiedVar() + ") " + this.perhapsOptFieldCheckForBatch() + ") {" + EOL);
            stringBuffer.append("int " + this.numVar() + " = " + "verifyCount[" + n + "];" + EOL);
            String[] stringArray = this.pkFieldNames.toArray(new String[0]);
            stringBuffer.append(this.preparedStatementBindings(stringArray, "this", true, true, true, false, this.stmtArrayElement(n)));
            stringBuffer.append(this.setSnapshotParams());
            stringBuffer.append("verifyCount[" + n + "] = " + this.numVar() + ";" + EOL);
            stringBuffer.append("}" + EOL);
            this.curTable = null;
        }
        return stringBuffer.toString();
    }

    public String perhapsAppendVerifySql() throws CodeGenerationException {
        if (!this.bean.getVerifyReads()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curTable : this.bean.getTables()) {
            this.curTableIndex = this.bean.tableIndex(this.curTable);
            stringBuffer.append(this.parse(this.getProductionRule("appendVerifySqlForTable")));
            this.curTable = null;
        }
        return stringBuffer.toString();
    }

    private void needAndCheck(StringBuffer stringBuffer) {
        stringBuffer.append("if (needAnd) {" + EOL);
        stringBuffer.append("verifySql[" + this.bean.tableIndex(this.curTable) + "].append(\" AND \");" + EOL);
        stringBuffer.append("}" + EOL);
        stringBuffer.append("else {" + EOL);
        stringBuffer.append("needAnd = true;" + EOL);
        stringBuffer.append("}" + EOL);
    }

    public String verifySqlForTable() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("verifySql[" + this.bean.tableIndex(this.curTable) + "].append(\"(");
        Iterator iterator = this.pkFieldNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.bean.getPKColumnName(this.curTable, string);
            stringBuffer.append(string2 + " = ? ");
            if (!iterator.hasNext()) continue;
            stringBuffer.append("AND ");
        }
        if (this.bean.getVerifyColumns(this.curTable).equalsIgnoreCase("version") || this.bean.getVerifyColumns(this.curTable).equalsIgnoreCase("timestamp")) {
            stringBuffer.append(" AND " + this.bean.getOptimisticColumn(this.curTable) + " = ?)\");" + EOL);
        } else {
            stringBuffer.append("\");" + EOL);
            stringBuffer.append("StringBuffer " + this.snapshotBufferVar() + " = new StringBuffer();" + EOL);
            stringBuffer.append(this.perhapsConstructSnapshotPredicate());
            stringBuffer.append("verifySql[" + this.bean.tableIndex(this.curTable) + "].append(" + this.snapshotBufferVar() + ".toString() + \")\");" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsSetVerifyParams() throws CodeGenerationException {
        if (!this.bean.getVerifyReads()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curTable : this.bean.getTables()) {
            this.curTableIndex = this.bean.tableIndex(this.curTable);
            stringBuffer.append("if (" + this.tableLoadedVar() + " && !" + this.tableModifiedVar() + ") {" + EOL);
            stringBuffer.append("int " + this.numVar() + " = " + "verifyCount[" + this.curTableIndex + "];" + EOL);
            stringBuffer.append(this.bd.getPrimaryKeyClass().getName() + " " + this.pkVar() + " = (" + this.bd.getPrimaryKeyClass().getName() + ")((EntityEJBContextImpl)" + this.ctxVar() + ").__WL_getPrimaryKey();" + EOL);
            String[] stringArray = this.pkFieldNames.toArray(new String[0]);
            stringBuffer.append(this.preparedStatementBindings(stringArray, this.pkVar(), false, this.bd.hasComplexPrimaryKey(), true, false, this.currStmtArrayVar()));
            if (this.bean.getVerifyColumns(this.curTable).equalsIgnoreCase("version") || this.bean.getVerifyColumns(this.curTable).equalsIgnoreCase("timestamp")) {
                String string = this.bean.getOptimisticColumn(this.curTable);
                String string2 = this.bean.getCmpField(this.curTable, string);
                stringArray = new String[]{string2};
                stringBuffer.append(this.preparedStatementBindings(stringArray, "this", true, true, true, false, this.currStmtArrayVar()));
            } else {
                stringBuffer.append(this.setSnapshotParams());
            }
            stringBuffer.append("verifyCount[" + this.curTableIndex + "] = " + this.numVar() + ";" + EOL);
            stringBuffer.append("}" + EOL);
            this.curTable = null;
        }
        return stringBuffer.toString();
    }

    public String perhapsAssignInitialContext() throws CodeGenerationException {
        if (this.bean.getRemoteFieldNames().size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("try {");
            stringBuffer.append(this.jctxVar() + " = new InitialContext();" + EOL);
            stringBuffer.append(this.parse(this.getProductionRule("standardCatch")));
            return stringBuffer.toString();
        }
        return "";
    }

    private String homeVar(String string) {
        return this.varPrefix() + string + "_home";
    }

    public String homeVarForField() {
        return this.homeVar(this.curField);
    }

    public String declareHomeVars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getRemoteFieldNames()) {
            EjbEntityRef ejbEntityRef = this.bean.getEjbEntityRef(string);
            stringBuffer.append(ejbEntityRef.getHome() + " " + this.homeVar(string) + ";" + EOL);
        }
        return stringBuffer.toString();
    }

    public String declareManagerVars() {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("private RDBMSPersistenceManager " + this.pmVar() + ";" + EOL);
        stringBuffer.append("private ClassLoader " + this.classLoaderVar() + ";" + EOL);
        for (Object object2 : this.bean.getCmrFieldNames()) {
            if (this.bean.isRemoteField((String)object2)) continue;
            stringBuffer.append(this.declareManagerVarField((String)object2));
        }
        object2 = this.ejbSelectBeanTargetMap.keySet();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(this.declareManagerVarBean(string));
        }
        for (RelationshipCaching relationshipCaching : this.bean.getRelationshipCachings()) {
            Iterator iterator2 = relationshipCaching.getCachingElements().iterator();
            stringBuffer.append(this.declareManagerVarsForCachingElements(this.bean, iterator2));
        }
        return stringBuffer.toString();
    }

    private String declareManagerVarsForCachingElements(RDBMSBean rDBMSBean, Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            RelationshipCaching.CachingElement cachingElement = (RelationshipCaching.CachingElement)iterator.next();
            String string = cachingElement.getCmrField();
            String string2 = cachingElement.getGroupName();
            RDBMSBean rDBMSBean2 = rDBMSBean.getRelatedRDBMSBean(string);
            String string3 = rDBMSBean2.getEjbName();
            stringBuffer.append(this.declareManagerVarBean(string3));
            Iterator iterator2 = cachingElement.getCachingElements().iterator();
            if (!iterator2.hasNext()) continue;
            stringBuffer.append(this.declareManagerVarsForCachingElements(rDBMSBean2, iterator2));
        }
        return stringBuffer.toString();
    }

    private String declareManagerVarField(String string) {
        String string2 = this.bean.getRelatedRDBMSBean(string).getEjbName();
        if (!this.declaredManagerVars.containsKey(string)) {
            this.declaredManagerVars.put(string, string2);
            return this.managerVar(string);
        }
        return "";
    }

    private String declareManagerVarBean(String string) {
        if (!this.declaredManagerVars.containsKey(string)) {
            this.declaredManagerVars.put(string, string);
            return this.managerVar(string);
        }
        return "";
    }

    private String managerVar(String string) {
        return "private CMPBeanManager " + this.bmVar(string) + ";" + EOL;
    }

    public String initializePersistentVars() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.variableToClass.keySet().iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(EOL);
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Class clazz = (Class)this.variableToClass.get(string);
            if (this.bean.hasCmpField(string)) {
                stringBuffer.append(this.setCmpField(string, ClassUtils.getDefaultValue(clazz)) + ";" + EOL);
                continue;
            }
            stringBuffer.append("this." + string + " = " + ClassUtils.getDefaultValue(clazz) + ";" + EOL);
        }
        return stringBuffer.toString();
    }

    public String initializeRelationVars() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(EOL);
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = CodeGenUtils.fieldVarName(string);
            Class clazz = this.bean.getCmrFieldClass(string);
            stringBuffer.append("this." + string2 + " = " + ClassUtils.getDefaultValue(clazz) + ";" + EOL);
            if (!this.bean.isSelfRelationship(string)) continue;
            String string3 = CodeGenUtils.fieldRemovedVarName(string);
            stringBuffer.append("this." + string3 + " = " + ClassUtils.getDefaultValue(clazz) + ";" + EOL);
        }
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    private boolean doSnapshot(String string) {
        String string2 = (String)this.variableToField.get(string);
        String string3 = null;
        String string4 = null;
        if (this.bean.hasCmpField(string2)) {
            string3 = this.bean.getTableForCmpField(string2);
            string4 = this.bean.getColumnForCmpFieldAndTable(string2, string3);
            if (this.bean.getVerifyColumns(string3).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string3).equalsIgnoreCase("timestamp")) {
                return string4.equals(this.bean.getOptimisticColumn(string3));
            }
            return true;
        }
        string3 = this.bean.getTableForVariable(string);
        return !this.bean.getVerifyColumns(string3).equalsIgnoreCase("version") && !this.bean.getVerifyColumns(string3).equalsIgnoreCase("timestamp");
    }

    public String perhapsDeclareSnapshotVars() {
        if (!this.bd.isOptimistic()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            Class clazz;
            Object object;
            if (this.bean.getVerifyColumns(string).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp")) {
                String string2 = this.bean.getOptimisticColumn(string);
                String string3 = this.bean.getCmpField(string, string2);
                object = this.getVariableClass(string3);
                clazz = CodeGenUtils.getSnapshotClass(this.bean, (Class)object);
                stringBuffer.append("public ");
                stringBuffer.append(ClassUtils.classToJavaSourceType(clazz) + " ");
                stringBuffer.append(CodeGenUtils.snapshotNameForVar(string3) + ";");
                stringBuffer.append(EOL);
                continue;
            }
            for (String string3 : this.variableToField.keySet()) {
                object = (String)this.variableToField.get(string3);
                if (this.bean.isBlobCmpColumnTypeForField(string3) || this.bean.isClobCmpColumnTypeForField(string3) || this.bd.getPrimaryKeyFieldNames().contains(string3) || (!this.bean.hasCmpField((String)object) || !this.bean.getTableForCmpField((String)object).equals(string)) && (this.bean.hasCmpField((String)object) || !this.bean.getTableForVariable(string3).equals(string))) continue;
                clazz = this.getVariableClass(string3);
                Class clazz2 = CodeGenUtils.getSnapshotClass(this.bean, clazz);
                stringBuffer.append("public ");
                stringBuffer.append(ClassUtils.classToJavaSourceType(clazz2) + " ");
                stringBuffer.append(CodeGenUtils.snapshotNameForVar(string3) + ";");
                stringBuffer.append(EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String perhapsCreateSnapshotBuffer() {
        if (!this.bd.isOptimistic()) {
            return "";
        }
        return "StringBuffer " + this.snapshotBufferVar() + " = new StringBuffer();";
    }

    public String perhapsAssignOptimisticField() {
        if (this.bd.isOptimistic()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.bean.getTables()) {
                String string2;
                if (!this.bean.getVerifyColumns(string).equalsIgnoreCase("version") && (!this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp") || this.bean.getTriggerUpdatesOptimisticColumn(string))) continue;
                String string3 = this.bean.getOptimisticColumn(string);
                this.curField = string2 = this.bean.getCmpField(string, string3);
                stringBuffer.append("if (!" + this.isModifiedVar(string2) + ") {" + EOL);
                stringBuffer.append(this.setterMethodNameForField() + "(" + this.initialOptimisticValue(string) + ");" + EOL);
                stringBuffer.append("}" + EOL);
                this.curField = null;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public String perhapsResetOurOptimisticColumnVariable() {
        if (this.bd.isOptimistic()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.bean.getTables()) {
                String string2;
                if (!this.bean.getVerifyColumns(string).equalsIgnoreCase("version") && !this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp")) continue;
                String string3 = this.bean.getOptimisticColumn(string);
                this.curField = string2 = this.bean.getCmpField(string, string3);
                stringBuffer.append(this.curField + " = ");
                stringBuffer.append("this." + CodeGenUtils.snapshotNameForVar(this.curField));
                stringBuffer.append(";" + EOL);
                this.curField = null;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private String initialOptimisticValue(String string) {
        String string2 = this.bean.getVerifyColumns(string);
        if (string2.equalsIgnoreCase("version")) {
            return "new Long(" + this.bean.getVersionColumnInitialValue(string) + ")";
        }
        if (string2.equalsIgnoreCase("timestamp")) {
            return "new java.sql.Timestamp(System.currentTimeMillis())";
        }
        throw new AssertionError((Object)("Invalid verify-columns: " + string2));
    }

    public String updateOptimisticField(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.getVerifyColumns(string).equalsIgnoreCase("version")) {
            stringBuffer.append(this.setMethodNameForField() + "__WL_optimisticField" + "(new Long(" + this.getMethodNameForField() + "().longValue()+1));" + EOL);
        } else {
            stringBuffer.append("long cur = System.currentTimeMillis();" + EOL);
            stringBuffer.append("if ((cur-1000)<=" + this.getMethodNameForField() + "().getTime()) {" + EOL);
            stringBuffer.append("cur = " + this.getMethodNameForField() + "().getTime()+1000;" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append(this.setMethodNameForField() + "__WL_optimisticField" + "(new java.sql.Timestamp(cur));" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsUpdateOptimisticField() {
        if (this.bd.isOptimistic()) {
            String string = this.curTableName;
            boolean bl = this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp");
            boolean bl2 = this.bean.getVerifyColumns(string).equalsIgnoreCase("version");
            boolean bl3 = this.bean.getTriggerUpdatesOptimisticColumn(string);
            if (!(!bl2 && !bl || bl && bl3)) {
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                String string3 = this.bean.getOptimisticColumn(string);
                this.curField = string2 = this.bean.getCmpField(string, string3);
                stringBuffer.append("if (" + this.isLoadedVar(string2) + " || " + this.isModifiedVar(string2) + ") {" + EOL);
                stringBuffer.append(this.updateOptimisticField(string));
                if (!this.bean.getTriggerUpdatesOptimisticColumn(string)) {
                    if (this.useVersionOrTimestampCheckingForBlobClob(string)) {
                        stringBuffer.append("if (" + this.countVar() + " > 0) sb.append(\", \");" + EOL);
                        stringBuffer.append("sb.append(\" " + string3 + " = ? \");" + EOL);
                    } else {
                        stringBuffer.append("sb.append(\", " + string3 + " = ? \");" + EOL);
                    }
                }
                stringBuffer.append("}" + EOL);
                this.curField = null;
                return stringBuffer.toString();
            }
        }
        return "";
    }

    public String perhapsSetUpdateOptimisticFieldStringForBatch() {
        String string;
        if (this.bd.isOptimistic() && (this.bean.getVerifyColumns(string = this.curTableName).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp"))) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = this.bean.getOptimisticColumn(string);
            this.curField = string2 = this.bean.getCmpField(string, string3);
            stringBuffer.append("if (" + this.isLoadedVar(string2) + " || " + this.isModifiedVar(string2) + ") {" + EOL);
            stringBuffer.append(this.isModifiedVar(string2) + " = true;" + EOL);
            if (!this.bean.getTriggerUpdatesOptimisticColumn(string)) {
                if (this.useVersionOrTimestampCheckingForBlobClob(string)) {
                    stringBuffer.append("if (" + this.countVar() + " > 0) sb.append(\", \");" + EOL);
                    stringBuffer.append("sb.append(\" " + string3 + " = ? \");" + EOL);
                } else {
                    stringBuffer.append("sb.append(\", " + string3 + " = ? \");" + EOL);
                }
            }
            stringBuffer.append("}" + EOL);
            this.curField = null;
            return stringBuffer.toString();
        }
        return "";
    }

    public String perhapsUpdateOptimisticFieldForBatch() {
        if (this.bd.isOptimistic()) {
            String string = this.curTableName;
            boolean bl = this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp");
            boolean bl2 = this.bean.getVerifyColumns(string).equalsIgnoreCase("version");
            boolean bl3 = this.bean.getTriggerUpdatesOptimisticColumn(string);
            if (!(!bl2 && !bl || bl && bl3)) {
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                String string3 = this.bean.getOptimisticColumn(string);
                this.curField = string2 = this.bean.getCmpField(string, string3);
                stringBuffer.append("if (" + this.isLoadedVar(string2) + " || " + this.isModifiedVar(string2) + ") {" + EOL);
                stringBuffer.append(this.updateOptimisticField(string));
                stringBuffer.append("}" + EOL);
                this.curField = null;
                return stringBuffer.toString();
            }
        }
        return "";
    }

    public String perhapsUpdateOptimisticFieldInTables() {
        if (this.bd.isOptimistic()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.bean.hasMultipleTables()) {
                int n = 0;
                while (n < this.bean.tableCount()) {
                    this.curTableIndex = n++;
                    this.curTableName = this.bean.tableAt(this.curTableIndex);
                    stringBuffer.append("if (" + this.tableModifiedVar(this.curTableName) + ") {" + EOL);
                    stringBuffer.append(this.perhapsUpdateOptimisticFieldForBatch());
                    stringBuffer.append("}" + EOL);
                }
            } else {
                stringBuffer.append(this.perhapsUpdateOptimisticFieldForBatch());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public String declareByteArrayVars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.variableToField.keySet()) {
            Class clazz;
            if (this.bean.isBlobCmpColumnTypeForField(string) || this.bean.isClobCmpColumnTypeForField(string) || this.bd.getPrimaryKeyFieldNames().contains(string) || this.bean.isValidSQLType(clazz = this.getVariableClass(string))) continue;
            stringBuffer.append("byte[] " + this.byteArrayVar(string) + " = null;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsTransactionParam() {
        if (!this.bd.isOptimistic() || this.bean.getDatabaseType() == 1) {
            return "";
        }
        return this.txVar();
    }

    public String perhapsSuspendTransaction() {
        if (!this.bd.isOptimistic() || this.bean.getDatabaseType() == 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        stringBuffer.append("Integer isolation = ").append(this.pmVar()).append(".getTransactionIsolationLevel();").append(EOL);
        stringBuffer.append("boolean shouldSuspendTx = (isolation != null && (").append(EOL);
        stringBuffer.append("isolation.intValue() != ").append("Connection.TRANSACTION_READ_UNCOMMITTED &&").append(EOL);
        stringBuffer.append("isolation.intValue() != ").append("Connection.TRANSACTION_READ_COMMITTED));").append(EOL);
        stringBuffer.append("javax.transaction.Transaction " + this.txVar() + "= null;" + EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("try {" + EOL);
        stringBuffer.append("if (shouldSuspendTx) {").append(EOL);
        stringBuffer.append(this.txVar() + " = " + this.pmVar() + ".suspendTransaction();" + EOL);
        stringBuffer.append("}").append(EOL);
        return stringBuffer.toString();
    }

    public String perhapsResumeTransaction() {
        if (!this.bd.isOptimistic() || this.bean.getDatabaseType() == 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("} finally {" + EOL);
        stringBuffer.append("try {" + EOL);
        stringBuffer.append("if (shouldSuspendTx) {").append(EOL);
        stringBuffer.append(this.pmVar() + ".resumeTransaction(" + this.txVar() + ");" + EOL);
        stringBuffer.append("}").append(EOL);
        stringBuffer.append("} catch (weblogic.ejb20.persistence.spi.PersistenceRuntimeException e) {" + EOL);
        stringBuffer.append(this.pmVar() + ".releaseResources(__WL_con, " + this.stmtVar() + ", " + this.rsVar() + ");" + EOL);
        stringBuffer.append("throw e;" + EOL);
        stringBuffer.append("}" + EOL);
        stringBuffer.append("}" + EOL);
        return stringBuffer.toString();
    }

    public String perhapsGetNullSnapshotVariables() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isOptimistic()) {
            stringBuffer.append("return null;");
            return stringBuffer.toString();
        }
        stringBuffer.append("Collection nullSnapshotVariables = new HashSet();" + EOL);
        for (String string : this.bean.getTables()) {
            Object object;
            Object object2;
            Object object3;
            if (this.bean.getVerifyColumns(string).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp")) {
                String string2 = this.bean.getOptimisticColumn(string);
                String string3 = this.bean.getCmpField(string, string2);
                object3 = this.getVariableClass(string3);
                object2 = CodeGenUtils.snapshotNameForVar(string3);
                object = CodeGenUtils.getSnapshotClass(this.bean, (Class)object3);
                String string4 = ClassUtils.classToJavaSourceType((Class)object);
                if (((Class)object3).isPrimitive()) continue;
                stringBuffer.append("if ( this." + (String)object2 + " == null) {" + EOL);
                stringBuffer.append("  nullSnapshotVariables.add(\"" + string3 + "\");" + EOL);
                stringBuffer.append("}" + EOL);
                continue;
            }
            for (String string3 : this.variableToField.keySet()) {
                object3 = (String)this.variableToField.get(string3);
                if (this.bean.isBlobCmpColumnTypeForField(string3) || this.bean.isClobCmpColumnTypeForField(string3) || this.bd.getPrimaryKeyFieldNames().contains(object3) || (!this.bean.hasCmpField((String)object3) || !this.bean.getTableForCmpField((String)object3).equals(string)) && (this.bean.hasCmpField((String)object3) || !this.bean.getTableForVariable(string3).equals(string))) continue;
                object2 = this.getVariableClass(string3);
                object = CodeGenUtils.snapshotNameForVar(string3);
                if (((Class)object2).isPrimitive()) continue;
                stringBuffer.append("if ( this." + (String)object + " == null) {" + EOL);
                stringBuffer.append("  nullSnapshotVariables.add(\"" + string3 + "\");" + EOL);
                stringBuffer.append("}" + EOL);
            }
        }
        stringBuffer.append("return nullSnapshotVariables;" + EOL);
        return stringBuffer.toString();
    }

    public String perhapsInitializeSnapshotVars() {
        if (!this.bd.isOptimistic()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (this.bean.getVerifyColumns(string).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp")) {
                String string2 = this.bean.getOptimisticColumn(string);
                String string3 = this.bean.getCmpField(string, string2);
                object4 = this.getVariableClass(string3);
                object3 = CodeGenUtils.snapshotNameForVar(string3);
                object2 = CodeGenUtils.getSnapshotClass(this.bean, (Class)object4);
                object = ClassUtils.classToJavaSourceType((Class)object2);
                stringBuffer.append((String)object3 + " = " + ClassUtils.getDefaultValue((Class)object2) + ";" + EOL);
                continue;
            }
            for (String string3 : this.variableToField.keySet()) {
                object4 = (String)this.variableToField.get(string3);
                if (this.bean.isBlobCmpColumnTypeForField(string3) || this.bean.isClobCmpColumnTypeForField(string3) || this.bd.getPrimaryKeyFieldNames().contains(object4) || (!this.bean.hasCmpField((String)object4) || !this.bean.getTableForCmpField((String)object4).equals(string)) && (this.bean.hasCmpField((String)object4) || !this.bean.getTableForVariable(string3).equals(string))) continue;
                object3 = this.getVariableClass(string3);
                object2 = CodeGenUtils.snapshotNameForVar(string3);
                object = CodeGenUtils.getSnapshotClass(this.bean, (Class)object3);
                String string4 = ClassUtils.classToJavaSourceType((Class)object);
                stringBuffer.append((String)object2 + " = " + ClassUtils.getDefaultValue((Class)object) + ";" + EOL);
            }
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    private String takeSnapshotForVar(String string, String string2, boolean bl) {
        if (this.bean.isBlobCmpColumnTypeForField(string2) || this.bean.isClobCmpColumnTypeForField(string2)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.getPrimaryKeyFieldNames().contains(string2)) {
            Class clazz = this.getVariableClass(string2);
            String string3 = CodeGenUtils.snapshotNameForVar(string2);
            Class clazz2 = CodeGenUtils.getSnapshotClass(this.bean, clazz);
            String string4 = ClassUtils.classToJavaSourceType(clazz2);
            String string5 = null;
            string5 = bl ? string + "." + MethodUtils.getMethodName(string2) + "()" : string + "." + string2;
            if (java.util.Date.class.isAssignableFrom(clazz)) {
                stringBuffer.append("if (" + string5 + "==null) {" + EOL);
                stringBuffer.append(string + "." + string3 + " = null;" + EOL);
                stringBuffer.append("}" + EOL);
                stringBuffer.append("else {" + EOL);
                stringBuffer.append(string + "." + string3 + " = " + "(" + clazz.getName() + ")" + string5 + ".clone();" + EOL);
                stringBuffer.append("}" + EOL);
            } else {
                stringBuffer.append(string + "." + string3 + " = " + string5 + ";" + EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String perhapsTakeSnapshot() {
        if (!this.bd.isOptimistic()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            String string2;
            Object object;
            boolean bl = this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp");
            boolean bl2 = this.bean.getVerifyColumns(string).equalsIgnoreCase("version");
            if (bl2 || bl) {
                if (bl && this.bean.getTriggerUpdatesOptimisticColumn(string)) continue;
                object = this.bean.getOptimisticColumn(string);
                string2 = this.bean.getCmpField(string, (String)object);
                stringBuffer.append("if (" + this.isLoadedVar(string2) + " || " + this.isModifiedVar(string2) + ") {" + EOL);
                stringBuffer.append(this.takeSnapshotForVar("this", string2, !this.bd.isBeanClassAbstract() && this.bean.hasCmpField(string2)));
                stringBuffer.append("}" + EOL);
                continue;
            }
            object = this.variableToField.keySet().iterator();
            stringBuffer.append(EOL);
            while (object.hasNext()) {
                string2 = (String)object.next();
                String string3 = (String)this.variableToField.get(string2);
                if (this.bean.isBlobCmpColumnTypeForField(string2) || this.bean.isClobCmpColumnTypeForField(string2)) {
                    return "";
                }
                if (this.bd.getPrimaryKeyFieldNames().contains(string3) || (!this.bean.hasCmpField(string3) || !this.bean.getTableForCmpField(string3).equals(string)) && (this.bean.hasCmpField(string3) || !this.bean.getTableForVariable(string2).equals(string))) continue;
                Class clazz = this.getVariableClass(string2);
                stringBuffer.append("if (" + this.isLoadedVar(string3) + ")" + EOL);
                if (this.bean.isValidSQLType(clazz)) {
                    stringBuffer.append(this.takeSnapshotForVar("this", string2, !this.bd.isBeanClassAbstract() && this.bean.hasCmpField(string2)));
                    continue;
                }
                stringBuffer.append(CodeGenUtils.snapshotNameForVar(string2) + " = " + this.byteArrayVar(string2) + ";" + EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String perhapsInvalidateOptimisticColumnField() throws CodeGenerationException {
        if (!this.bd.isOptimistic()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : this.bean.getTables()) {
            if (!this.bean.getVerifyColumns((String)object).equalsIgnoreCase("timestamp") || !this.bean.getTriggerUpdatesOptimisticColumn((String)object)) continue;
            String string = this.bean.getOptimisticColumn((String)object);
            String string2 = this.bean.getCmpField((String)object, string);
            stringBuffer.append(this.isLoadedVar(string2) + " = false;" + EOL);
        }
        if (stringBuffer.length() > 0 && this.bd.getCacheBetweenTransactions()) {
            Object object;
            object = this.bean.getFieldGroup("optimisticTimestampTriggerGroup");
            stringBuffer.append("int oldState = __WL_method_state;" + EOL);
            stringBuffer.append("try {" + EOL);
            stringBuffer.append("__WL_method_state = STATE_EJBSTORE;" + EOL);
            stringBuffer.append(this.loadMethodName(this.getFieldGroupSuffix((FieldGroup)object)) + "();" + EOL);
            stringBuffer.append("} finally {" + EOL);
            stringBuffer.append("__WL_method_state = oldState;" + EOL);
            stringBuffer.append("}" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsReloadOptimisticColumn() throws CodeGenerationException {
        if (!this.bd.isOptimistic()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getTables()) {
            if (!this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp") || !this.bean.getTriggerUpdatesOptimisticColumn(string) || this.bd.getCacheBetweenTransactions()) continue;
            String string2 = this.bean.getOptimisticColumn(string);
            String string3 = this.bean.getCmpField(string, string2);
            stringBuffer.append("if (!" + this.isLoadedVar(string3) + " && !" + this.isModifiedVar(string3) + ") {" + EOL);
            FieldGroup fieldGroup = this.bean.getFieldGroup("optimisticTimestampTriggerGroup");
            stringBuffer.append(this.loadMethodName(this.getFieldGroupSuffix(fieldGroup)) + "();" + EOL);
            stringBuffer.append("}" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsConstructSnapshotPredicate() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bd.isOptimistic()) {
            String string = this.bean.tableAt(this.curTableIndex);
            stringBuffer.append(EOL);
            stringBuffer.append(this.snapshotBufferVar() + ".setLength(0);" + EOL);
            if (this.bean.getVerifyColumns(string).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp")) {
                String string2 = this.bean.getOptimisticColumn(string);
                String string3 = this.bean.getCmpField(string, string2);
                stringBuffer.append("if (" + this.isLoadedVar(string3) + " || " + this.isModifiedVar(string3) + ") {" + EOL);
                stringBuffer.append(this.snapshotBufferVar() + ".append(\" AND \" +" + this.pmVar() + ".getSnapshotPredicate(" + this.bean.getIsModifiedIndex(string3) + ", " + "this." + CodeGenUtils.snapshotNameForVar(string3) + "));" + EOL);
                stringBuffer.append("}" + EOL);
            } else {
                for (int i = 0; i < this.bean.getFieldCount(); ++i) {
                    Object object;
                    Object object2;
                    int n;
                    String string4 = this.isModifiedIndexToField(i);
                    if (this.bean.isCmpFieldName(string4)) {
                        if (this.bean.isBlobCmpColumnTypeForField(string4) || this.bean.isClobCmpColumnTypeForField(string4) || this.bd.getPrimaryKeyFieldNames().contains(string4)) continue;
                        n = this.bean.getTableIndexForCmpField(string4);
                        if (n == -1) {
                            throw new CodeGenerationException("perhapsConstructSnapshotPredicate: Could not find tableIndex for cmp-field: '" + string4 + "'");
                        }
                        if (n != this.curTableIndex) continue;
                        object2 = this.bean.getCmpFieldClass(string4);
                        object = CodeGenUtils.getSnapshotClass(this.bean, (Class)object2);
                        stringBuffer.append("if (" + this.isLoadedVar(string4));
                        if (this.bean.getVerifyColumns(string).equalsIgnoreCase("modified")) {
                            stringBuffer.append(" && " + this.isModifiedVar(string4));
                        }
                        stringBuffer.append(") {" + EOL);
                        if (((Class)object).isPrimitive()) {
                            stringBuffer.append(this.snapshotBufferVar() + ".append(\" AND \" +" + this.pmVar() + ".getSnapshotPredicate(" + this.bean.getIsModifiedIndex(string4) + "));" + EOL);
                        } else {
                            stringBuffer.append(this.snapshotBufferVar() + ".append(\" AND \" +" + this.pmVar() + ".getSnapshotPredicate(" + this.bean.getIsModifiedIndex(string4) + ", " + "this." + CodeGenUtils.snapshotNameForVar(string4) + "));" + EOL);
                        }
                        stringBuffer.append("}" + EOL);
                        continue;
                    }
                    if (!this.bean.containsFkField(string4) || this.bean.isForeignCmpField(string4)) continue;
                    n = this.bean.getTableIndexForCmrf(string4);
                    if (n == -1) {
                        throw new CodeGenerationException("perhapsConstructSnapshotPredicate: Could not find tableIndex for cmr-field: '" + string4 + "'");
                    }
                    if (n != this.curTableIndex) continue;
                    object2 = this.bean.getForeignKeyColNames(string4).iterator();
                    object = (String)object2.next();
                    String string5 = this.bean.variableForField(string4, string, (String)object);
                    Class clazz = this.bean.getForeignKeyColClass(string4, (String)object);
                    String string6 = CodeGenUtils.snapshotNameForVar(string5);
                    Class clazz2 = CodeGenUtils.getSnapshotClass(this.bean, clazz);
                    stringBuffer.append("if (" + this.isLoadedVar(string4));
                    if (this.bean.getVerifyColumns(string).equalsIgnoreCase("modified")) {
                        stringBuffer.append(" && " + this.isModifiedVar(string4));
                    }
                    stringBuffer.append(") {" + EOL);
                    if (clazz2.isPrimitive()) {
                        stringBuffer.append(this.snapshotBufferVar() + ".append(\" AND \" +" + this.pmVar() + ".getSnapshotPredicate(" + this.bean.getIsModifiedIndex(string4) + "));" + EOL);
                    } else {
                        stringBuffer.append(this.snapshotBufferVar() + ".append(\" AND \" +" + this.pmVar() + ".getSnapshotPredicate(" + this.bean.getIsModifiedIndex(string4) + ", " + "this." + string6 + "));" + EOL);
                    }
                    stringBuffer.append("}" + EOL);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String perhapsAddSnapshotPredicate() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bd.isOptimistic()) {
            stringBuffer.append("+ " + this.snapshotBufferVar() + ".toString()");
        }
        return stringBuffer.toString();
    }

    public String perhapsSetSnapshotParameters() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bd.isOptimistic()) {
            stringBuffer.append(this.setSnapshotParams());
        }
        return stringBuffer.toString();
    }

    public String setSnapshotParams() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        String string = this.bean.tableAt(this.curTableIndex);
        if (this.bean.getVerifyColumns(string).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp")) {
            String string2 = this.bean.getOptimisticColumn(string);
            String string3 = this.bean.getCmpField(string, string2);
            String string4 = CodeGenUtils.snapshotNameForVar(string3);
            stringBuffer.append("if (" + this.isLoadedVar(string3) + " || " + this.isModifiedVar(string3) + ") {" + EOL);
            stringBuffer.append("if(" + this.debugEnabled() + ") " + this.debugSay() + "(\"setting(\"+this+\") '" + string4 + "' using column \" +" + this.numVar() + " + \". Value is \" + this." + string4 + ");" + EOL);
            this.addSnapshotBinding(stringBuffer, string3, "this", this.numVar(), this.currStmtArrayVar());
            stringBuffer.append("}" + EOL);
        } else {
            for (int i = 0; i < this.bean.getFieldCount(); ++i) {
                int n;
                String string5 = this.isModifiedIndexToField(i);
                assert (string5 != null);
                if (this.bean.isCmpFieldName(string5)) {
                    if (this.bd.getPrimaryKeyFieldNames().contains(string5) || this.bean.isBlobCmpColumnTypeForField(string5) || this.bean.isClobCmpColumnTypeForField(string5)) continue;
                    n = this.bean.getTableIndexForCmpField(string5);
                    if (n == -1) {
                        throw new CodeGenerationException("perhapsSetSnapshotParameters: Could not find tableIndex for field: '" + string5 + "'");
                    }
                    if (n != this.curTableIndex) continue;
                    String string6 = CodeGenUtils.snapshotNameForVar(string5);
                    stringBuffer.append("if (" + this.isLoadedVar(string5));
                    if (this.bean.getVerifyColumns(string).equalsIgnoreCase("modified")) {
                        stringBuffer.append(" && " + this.isModifiedVar(string5));
                    }
                    stringBuffer.append(") {" + EOL);
                    stringBuffer.append("if(" + this.debugEnabled() + ") " + this.debugSay() + "(\"setting(\"+this+\") '" + (String)string6 + "' using column \" +" + this.numVar() + " + \". Value is \" + this." + (String)string6 + ");" + EOL);
                    this.addSnapshotBinding(stringBuffer, string5, "this", this.numVar(), this.currStmtArrayVar());
                    stringBuffer.append("}" + EOL);
                    continue;
                }
                n = this.bean.getTableIndexForCmrf(string5);
                if (n == -1) {
                    throw new CodeGenerationException("perhapsSetSnapshotParameters: Could not find tableIndex for field: '" + string5 + "'");
                }
                if (n != this.curTableIndex) continue;
                for (String string7 : this.bean.getForeignKeyColNames(string5)) {
                    String string8 = this.bean.variableForField(string5, string, string7);
                    String string9 = CodeGenUtils.snapshotNameForVar(string8);
                    stringBuffer.append("if (" + this.isLoadedVar(string5));
                    if (this.bean.getVerifyColumns(string).equalsIgnoreCase("modified")) {
                        stringBuffer.append(" && " + this.isModifiedVar(string5));
                    }
                    stringBuffer.append(") {" + EOL);
                    stringBuffer.append("if(" + this.debugEnabled() + ") " + this.debugSay() + "(\"setting(\"+this+\") '" + string9 + "' using column \" +" + this.numVar() + " + \". Value is \" + this." + string9 + ");" + EOL);
                    this.addSnapshotBinding(stringBuffer, string8, "this", this.numVar(), this.currStmtArrayVar());
                    stringBuffer.append("}" + EOL);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void addSnapshotBinding(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("Adding a snapshot binding: ");
            RDBMSCodeGenerator.debug("\t\tvar = " + string);
            RDBMSCodeGenerator.debug("\t\tobj = " + string2);
            RDBMSCodeGenerator.debug("\t\tparamIdx = " + string3);
        }
        if (this.bean.isBlobCmpColumnTypeForField(string) || this.bean.isClobCmpColumnTypeForField(string)) {
            stringBuffer.append("  ");
            return;
        }
        Class clazz = this.getVariableClass(string);
        String string5 = CodeGenUtils.snapshotNameForVar(string);
        Class clazz2 = CodeGenUtils.getSnapshotClass(this.bean, clazz);
        if (!clazz2.isPrimitive()) {
            stringBuffer.append("if (" + string5 + "!= null) {" + EOL);
        }
        this.snapshotBindingBody(stringBuffer, string2, string, clazz, string3, string4);
        stringBuffer.append(this.numVar() + "++;" + EOL);
        if (!clazz2.isPrimitive()) {
            stringBuffer.append("}" + EOL);
        }
    }

    private void snapshotBindingBody(StringBuffer stringBuffer, String string, String string2, Class clazz, String string3, String string4) {
        String string5 = CodeGenUtils.snapshotNameForVar(string2);
        Class clazz2 = CodeGenUtils.getSnapshotClass(this.bean, clazz);
        if (!this.bean.isValidSQLType(clazz) || ClassUtils.isByteArray(clazz)) {
            if (ClassUtils.isByteArray(clazz) && ("SybaseBinary".equalsIgnoreCase(this.bean.getCmpColumnTypeForField(string2)) || this.perhapsSybaseBinarySetForAnyCmpField())) {
                stringBuffer.append(string4 + ".setBytes(" + string3 + "," + string5 + ");" + EOL);
            } else {
                stringBuffer.append("InputStream inputStream  = new ByteArrayInputStream(" + string5 + ");" + EOL);
                stringBuffer.append(string4 + ".setBinaryStream(" + string3 + ", inputStream, " + string5 + ".length);" + EOL);
            }
        } else {
            String string6 = StatementBinder.getStatementTypeNameForClass(clazz);
            if (RDBMSUtils.isOracleNLSDataType(this.bean, string2)) {
                stringBuffer.append("if(").append(string4).append(" instanceof oracle.jdbc.OraclePreparedStatement) {" + EOL);
                stringBuffer.append("((oracle.jdbc.OraclePreparedStatement)").append(string4).append(").setFormOfUse(").append(string3).append(", oracle.jdbc.OraclePreparedStatement.FORM_NCHAR);").append(EOL);
                stringBuffer.append("}" + EOL);
            }
            stringBuffer.append(string4);
            stringBuffer.append(".set" + string6 + "(");
            stringBuffer.append(string3).append(", ");
            if (clazz == Character.TYPE) {
                stringBuffer.append("String.valueOf(" + string + "." + string5 + ")");
            } else if (clazz == Character.class) {
                stringBuffer.append("String.valueOf(" + string + "." + string5 + ".charValue())");
            } else if (clazz == java.util.Date.class) {
                stringBuffer.append("new java.sql.Timestamp(");
                stringBuffer.append(string + ".");
                stringBuffer.append(MethodUtils.convertToPrimitive(clazz, string5));
                stringBuffer.append(".getTime())");
            } else {
                stringBuffer.append(string + ".");
                stringBuffer.append(MethodUtils.convertToPrimitive(clazz, string5));
            }
            stringBuffer.append(");" + EOL);
        }
    }

    public String throwOperationFailedException() {
        if (this.bd.isOptimistic()) {
            return " Loggable l = EJBLogger.logoptimisticUpdateFailedLoggable( \"" + this.bd.getEJBName() + "\"," + this.pkVar() + ".toString());" + EOL + " throw new OptimisticConcurrencyException(l.getMessage());";
        }
        return " Loggable l = EJBLogger.logbeanDoesNotExistLoggable(\"" + this.bd.getEJBName() + "\"," + this.pkVar() + ".toString()); " + EOL + "throw new NoSuchEntityException(l.getMessage()); ";
    }

    public String primaryFieldClassesArray(String string) {
        CMPBeanDescriptor cMPBeanDescriptor = null;
        cMPBeanDescriptor = this.bean.isForeignKeyField(string) && this.bean.containsFkField(string) ? this.bean.getRelatedDescriptor(string) : this.bd;
        return "new Class[] {" + cMPBeanDescriptor.getPrimaryKeyClass().getName() + ".class }";
    }

    public String assignHomeVars() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = this.bean.getRemoteFieldNames().iterator();
        if (iterator.hasNext()) {
            stringBuffer.append("try {");
            bl = true;
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append("Context ctx = (Context)" + this.jctxVar() + ".lookup(\"java:comp/env\");" + EOL);
            stringBuffer.append("assert (ctx!=null);" + EOL);
            stringBuffer.append(this.debugSay() + "(\"Listing contents of java:comp/env\");" + EOL);
            stringBuffer.append("NamingEnumeration nenum = ctx.list(\"\");" + EOL);
            stringBuffer.append("while (nenum.hasMore()) {" + EOL);
            stringBuffer.append("NameClassPair ncp = (NameClassPair)nenum.next();" + EOL);
            stringBuffer.append(this.debugSay() + "(\"name bound- \" + ncp.getName());" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("}" + EOL);
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            EjbEntityRef ejbEntityRef = this.bean.getEjbEntityRef(string);
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"Looking up name- " + ejbEntityRef.getEjbRefName() + "\");" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append(this.homeVar(string) + " = (" + ejbEntityRef.getHome() + ")");
            stringBuffer.append(this.jctxVar() + ".lookup(\"java:comp/env/");
            stringBuffer.append(ejbEntityRef.getEjbRefName() + "\");" + EOL);
        }
        if (bl) {
            stringBuffer.append(this.parse(this.getProductionRule("standardCatch")));
        }
        return stringBuffer.toString();
    }

    public String assignManagerVars() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Set set = this.declaredManagerVars.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = (String)iterator.next();
            String string2 = (String)this.declaredManagerVars.get(string);
            if (hashMap.containsKey(string2)) {
                stringBuffer.append(this.bmVar(string)).append(" = ");
                stringBuffer.append(hashMap.get(string2)).append(";").append(EOL);
            } else {
                stringBuffer.append(this.bmVar(string) + " = ");
                stringBuffer.append("(CMPBeanManager)bmMap.get(\"");
                stringBuffer.append(string2);
                stringBuffer.append("\");" + EOL);
                stringBuffer.append("assert (bmMap.get(\"");
                stringBuffer.append(string2);
                stringBuffer.append("\")!=null);" + EOL + EOL);
                hashMap.put(string2, this.bmVar(string));
            }
            bl = true;
        }
        if (bl) {
            return "try {" + stringBuffer.toString() + this.parse(this.getProductionRule("standardCatch"));
        }
        return "";
    }

    public String assignEjbSelectMethodVars() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (Finder finder : this.finderList) {
            Object object;
            Object object2;
            if (finder.getQueryType() != 4 && finder.getQueryType() != 2 && (!finder.isSelect() || !(finder instanceof SqlFinder))) continue;
            if (!bl) {
                stringBuffer.append("static {");
                stringBuffer.append(EOL);
                stringBuffer.append("Method m = null;");
                stringBuffer.append(EOL);
                bl = true;
            }
            if (!finder.isSelect() || !(finder instanceof SqlFinder)) {
                object2 = finder.getSelectBeanTarget();
                if (object2 == null) {
                    object = EJBLogger.logGotNullXForFinderLoggable((String)"getSelectBeanTarget", (String)finder.toString());
                    throw new CodeGenerationException(object.getMessage());
                }
                object = (CMPBeanDescriptor)this.beanMap.get(((RDBMSBean)object2).getEjbName());
                if (object == null) {
                    Loggable loggable = EJBLogger.logGotNullBeanFromBeanMapLoggable((String)((RDBMSBean)object2).getEjbName());
                    throw new CodeGenerationException(loggable.getMessage());
                }
                String string = object.getGeneratedBeanInterfaceName();
                stringBuffer.append("try {");
                stringBuffer.append(EOL);
                stringBuffer.append("m = ");
                stringBuffer.append(string);
                stringBuffer.append(".class.getMethod(\"");
                stringBuffer.append(this.ejbSelectMDName(finder));
                stringBuffer.append("\", ");
                stringBuffer.append(EOL);
                stringBuffer.append("         ");
                stringBuffer.append("new Class[] { ");
                StringBuffer stringBuffer2 = new StringBuffer();
                for (ParamNode paramNode : finder.getExternalMethodAndInEntityParmList()) {
                    Class clazz = paramNode.getParamClass();
                    stringBuffer2.append(clazz.getName());
                    stringBuffer2.append(".class, ");
                    stringBuffer2.append(EOL);
                }
                if (stringBuffer2.length() > 2) {
                    stringBuffer2.setLength(stringBuffer2.length() - 2);
                }
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("} );");
                stringBuffer.append("} catch (NoSuchMethodException ignore) {");
                stringBuffer.append(EOL);
                stringBuffer.append("m = null;");
                stringBuffer.append(EOL);
                stringBuffer.append("}");
                stringBuffer.append(EOL);
                stringBuffer.append(this.ejbSelectMDName(finder));
                stringBuffer.append(" = m;");
                stringBuffer.append(EOL + EOL);
                continue;
            }
            object2 = this.bean.getCMPBeanDescriptor().getGeneratedBeanInterfaceName();
            stringBuffer.append("try {");
            stringBuffer.append(EOL);
            stringBuffer.append("m = ");
            stringBuffer.append((String)object2);
            stringBuffer.append(".class.getMethod(\"");
            stringBuffer.append(finder.getName());
            stringBuffer.append("\", ");
            stringBuffer.append("new Class[] { ");
            object = finder.getParameterClassTypes();
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringBuffer.append(ClassUtils.classToJavaSourceType((Class)object[i]));
                stringBuffer.append(".class");
                if (i >= ((Object)object).length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("});" + EOL);
            stringBuffer.append("} catch (NoSuchMethodException ignore) {");
            stringBuffer.append(EOL);
            stringBuffer.append("m = null;");
            stringBuffer.append(EOL);
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(this.ejbSelectMDName(finder));
            stringBuffer.append(" = m;");
            stringBuffer.append(EOL);
        }
        if (bl) {
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            return stringBuffer.toString();
        }
        return "";
    }

    public String fieldNameGetPrimaryKey() {
        return this.fieldNameForField() + ".getPrimaryKey()";
    }

    public String fieldVarGetPrimaryKey() {
        return this.fieldVarForField() + ".getPrimaryKey()";
    }

    public String fieldNameForField() {
        return this.curField;
    }

    public String assignFieldVarForFieldWithFieldNameForField() {
        return this.fieldVarForField() + " = " + this.fieldNameForField() + ";";
    }

    public String assignFieldVarForFieldWithAllocatedOneToManySet() {
        return this.fieldVarForField() + " = " + this.allocateOneToManySet() + ";";
    }

    public String assignFieldVarForFieldWithOneToManySetClone() {
        return this.fieldVarForField() + " = (Set)(((" + this.collectionClassForField() + ")" + EOL + "      " + this.fieldVarForField() + ").clone());";
    }

    public String assignFieldVarForFieldWithAllocatedManyToManySet() {
        return this.fieldVarForField() + " = " + this.allocateManyToManySet() + ";";
    }

    public String assignFieldVarForFieldWithNull() {
        return this.fieldVarForField() + " = null;";
    }

    public String setterMethodNameForField() {
        return "set" + this.curField.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.curField.substring(1);
    }

    public String doSetMethodNameForField() {
        return MethodUtils.doSetMethodName(this.curField);
    }

    public String setRestMethodNameForField() {
        assert (this.curField != null);
        return MethodUtils.setRestMethodName(this.curField);
    }

    public String getMethodNameForField() {
        return MethodUtils.getMethodName(this.curField);
    }

    public String setMethodNameForField() {
        return MethodUtils.setMethodName(this.curField);
    }

    public String getRelatedMethodNameForField() {
        String string = this.bean.getRelatedFieldName(this.curField);
        return MethodUtils.getMethodName(string);
    }

    public String javaClassCommonMethodPrefix() {
        String string;
        String string2 = this.method.getName();
        if ((string2.startsWith("get") || string2.startsWith("set")) && (this.cmpFieldNames.contains(string = MethodUtils.decapitalize(string2.substring(3))) || this.cmrFieldNames.contains(string))) {
            return "__WL_internal_";
        }
        return "__WL_super_";
    }

    public String declareCmpGettersAndSetters() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curField : this.cmpFieldNames) {
            stringBuffer.append(this.parse(this.getProductionRule("cmpGetMethod")));
            stringBuffer.append(this.parse(this.getProductionRule("cmpSetMethod")));
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String cmpSetMethodGuard() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            String string;
            if (this.bean.isDbmsDefaultValueField(this.curField)) {
                stringBuffer.append("if (__WL_method_state==STATE_EJB_CREATE ||");
                stringBuffer.append(EOL);
                if (!this.bean.getDelayInsertUntil().equals("ejbCreate")) {
                    stringBuffer.append("__WL_method_state==STATE_EJB_POSTCREATE ||");
                    stringBuffer.append(EOL);
                }
                Iterator iterator = this.bd.getPrimaryKeyFieldNames().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    stringBuffer.append(this.isModifiedVar(string));
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append("||").append(EOL);
                }
                stringBuffer.append(") {" + EOL);
                stringBuffer.append("Loggable l = EJBLogger.logCannotCallSetOnDBMSDefaultFieldBeforeInsertLoggable();");
                stringBuffer.append(EOL);
                stringBuffer.append("throw new IllegalStateException(l.getMessage());");
                stringBuffer.append(EOL);
                stringBuffer.append("}" + EOL);
            }
            if (this.bd.getPrimaryKeyFieldNames().contains(this.curField)) {
                stringBuffer.append("if (__WL_method_state!=STATE_EJB_CREATE) {" + EOL);
                stringBuffer.append("Loggable l = EJBLogger.logcannotCallSetOnPkLoggable();");
                stringBuffer.append("throw new IllegalStateException(l.getMessage());");
                stringBuffer.append("}" + EOL);
                stringBuffer.append(this.parse(this.getProductionRule("cmpSetMethodBody")));
            } else if (this.bean.isCmrMappedCmpField(this.curField)) {
                stringBuffer.append("Loggable l = EJBLogger.logcannotCallSetOnCmpCmrFieldLoggable();");
                stringBuffer.append("throw new EJBException(l.getMessage());" + EOL + EOL);
            } else if (this.bd.isOptimistic()) {
                boolean bl = false;
                string = null;
                String string2 = null;
                String string3 = null;
                for (int i = 0; i < this.bean.tableCount(); ++i) {
                    string = this.bean.tableAt(i);
                    if (!this.bean.getVerifyColumns(string).equalsIgnoreCase("version") && !this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp") || !(string3 = this.bean.getCmpField(string, string2 = this.bean.getOptimisticColumn(string))).equals(this.curField)) continue;
                    bl = true;
                    break;
                }
                String string4 = this.fieldNameForField();
                if (bl) {
                    stringBuffer.append(this.setMethodNameForField() + "__WL_optimisticField(" + string4 + ");" + EOL);
                    stringBuffer.append("if (!__WL_createAfterRemove) {" + EOL);
                    stringBuffer.append("this." + CodeGenUtils.snapshotNameForVar(this.curField) + " = ");
                    stringBuffer.append(string4 + ";" + EOL);
                    stringBuffer.append("}" + EOL);
                    stringBuffer.append("}" + EOL + EOL);
                    stringBuffer.append("public void " + this.setMethodNameForField() + "__WL_optimisticField(" + this.fieldClassForCmpField() + " " + string4 + ") {" + EOL);
                    stringBuffer.append(this.parse(this.getProductionRule("cmpSetMethodBody")));
                } else {
                    stringBuffer.append(this.parse(this.getProductionRule("cmpSetMethodBodyForOptimistic")));
                }
            } else {
                stringBuffer.append(this.parse(this.getProductionRule("cmpSetMethodBody")));
            }
        } else {
            stringBuffer.append("Loggable l = EJBLogger.logCannotCallSetForReadOnlyBeanLoggable(\"" + this.bean.getEjbName() + "\");" + EOL);
            stringBuffer.append("throw new javax.ejb.EJBException(l.getMessage());" + EOL);
        }
        return stringBuffer.toString();
    }

    public String cmpSetMethodCheck() {
        assert (this.curField != null);
        String string = "";
        if (this.bd.getPrimaryKeyFieldNames().contains(this.curField)) {
            return string;
        }
        String string2 = this.fieldNameForField();
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz = this.bean.getCmpFieldClass(this.curField);
        if (ClassUtils.isPrimitiveOrImmutable(clazz)) {
            stringBuffer.append("this." + this.fieldNameForField());
            stringBuffer.append(" == " + string2 + "  ");
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
            if (!clazz.isPrimitive()) {
                stringBuffer.append("(" + string + " || (");
                stringBuffer.append("this." + this.fieldNameForField());
                stringBuffer.append("!=null && ");
                stringBuffer.append("this." + this.fieldNameForField());
                stringBuffer.append(".equals(" + string2 + ")))  ");
                string = stringBuffer.toString();
            }
            string = "if (" + string + " && " + this.isLoadedVarForField() + ") return;" + EOL;
        }
        return string;
    }

    public String trimStringTypes() {
        if (this.bean.isStringTrimmingEnabled()) {
            Class clazz = this.bean.getCmpFieldClass(this.curField);
            String string = this.fieldNameForField();
            if (clazz == String.class) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("if(");
                stringBuffer.append(string);
                stringBuffer.append("!= null) {");
                stringBuffer.append(EOL);
                stringBuffer.append(this.trimStringTypedValue(string));
                stringBuffer.append("}");
                stringBuffer.append(EOL);
                return stringBuffer.toString();
            }
            if (this.bean.isCharArrayMappedToString(clazz)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("if(");
                stringBuffer.append(string);
                stringBuffer.append("!= null) {");
                stringBuffer.append(EOL);
                stringBuffer.append("int i = ");
                stringBuffer.append(string);
                stringBuffer.append(".length;\n");
                stringBuffer.append("while(i > 0 && Character.isWhitespace(");
                stringBuffer.append(string);
                stringBuffer.append("[i-1])) {i--;}\n");
                stringBuffer.append("if(i<");
                stringBuffer.append(string);
                stringBuffer.append(".length) {\n");
                stringBuffer.append("char[] temp = new char[i];\n");
                stringBuffer.append("for(int j=0;j<i;j++) {\n");
                stringBuffer.append("temp[j] = ");
                stringBuffer.append(string);
                stringBuffer.append("[j];\n");
                stringBuffer.append("}\n");
                stringBuffer.append(string);
                stringBuffer.append("= temp;\n");
                stringBuffer.append("}\n");
                stringBuffer.append("}\n");
                return stringBuffer.toString();
            }
        }
        return "";
    }

    public String trimStringTypedValue(String string) {
        if (!this.bean.isStringTrimmingEnabled()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int i = ");
        stringBuffer.append(string);
        stringBuffer.append(".length();");
        stringBuffer.append(EOL);
        stringBuffer.append("while(i > 0 && Character.isWhitespace(");
        stringBuffer.append(string);
        stringBuffer.append(".charAt(i-1))) {i--;}");
        stringBuffer.append(EOL);
        stringBuffer.append("if(i<");
        stringBuffer.append(string);
        stringBuffer.append(".length()) {");
        stringBuffer.append(EOL);
        stringBuffer.append(string);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append(".substring(0,i);");
        stringBuffer.append(EOL);
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String getFieldGroupSuffix(FieldGroup fieldGroup) {
        return "group" + fieldGroup.getIndex();
    }

    public String getMethodSuffix(String string) {
        String string2 = this.bean.getGroupNameForCmpField(string);
        return this.getFieldGroupSuffix(this.bean.getFieldGroup(string2));
    }

    public String implementGroupLoadMethods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (FieldGroup this.curGroup : this.bean.getFieldGroups()) {
            stringBuffer.append(EOL);
            stringBuffer.append("// loadGroup method for the '" + this.curGroup.getName() + "' group." + EOL);
            stringBuffer.append("public void " + this.loadMethodName(this.getFieldGroupSuffix(this.curGroup)) + "() ");
            stringBuffer.append("throws Exception {" + EOL);
            if (this.groupColumnCount() > 0) {
                stringBuffer.append(this.parse(this.getProductionRule("implementGroupLoadMethodBody")));
            }
            stringBuffer.append("}" + EOL);
        }
        return stringBuffer.toString();
    }

    public String constructorExceptionList() {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz = cMPBeanDescriptor.getBeanClass();
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            assert (constructor != null);
            Class<?>[] classArray = constructor.getExceptionTypes();
            if (classArray.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray.length; ++i) {
                    stringBuffer.append(this.javaCodeForType(classArray[i]));
                    if (i >= classArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Unable to find constructor on class '" + clazz.getName() + "'."));
        }
        return stringBuffer.toString();
    }

    public String ejbLoadExceptionList() {
        return this.ejbCallbackMethodExceptionList("ejbLoad");
    }

    public String ejbRemoveExceptionList() {
        return this.ejbCallbackMethodExceptionList("ejbRemove");
    }

    public String ejbStoreExceptionList() {
        return this.ejbCallbackMethodExceptionList("ejbStore");
    }

    public String ejbCallbackMethodExceptionList(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz = cMPBeanDescriptor.getBeanClass();
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            assert (method != null);
            Class<?>[] classArray = method.getExceptionTypes();
            if (classArray.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray.length; ++i) {
                    stringBuffer.append(this.javaCodeForType(classArray[i]));
                    if (i >= classArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Unable to find " + string + " on class '" + clazz.getName() + "'."));
        }
        return stringBuffer.toString();
    }

    private String declareBeanMethod(String string, Class[] classArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = this.bd.getBeanClass();
        try {
            Method method = clazz.getMethod(string, classArray);
            assert (method != null);
            MethodSignature methodSignature = new MethodSignature(method);
            stringBuffer.append(methodSignature.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (bl) {
                throw new AssertionError((Object)("Unable to find '" + string + "' method on class '" + clazz.getName() + "'."));
            }
            return null;
        }
        return stringBuffer.toString();
    }

    public String declareSetEntityContextMethod() {
        return this.declareBeanMethod("setEntityContext", new Class[]{EntityContext.class}, true);
    }

    public String declareEjbLoadMethod() {
        return this.declareBeanMethod("ejbLoad", new Class[0], true);
    }

    public String declareEjbStoreMethod() {
        return this.declareBeanMethod("ejbStore", new Class[0], true);
    }

    public String beanVarEjbStoreForField() {
        return this.beanVar() + ".ejbStore();";
    }

    private boolean beanHasEjbStoreMethod(CMPBeanDescriptor cMPBeanDescriptor) {
        Class clazz = cMPBeanDescriptor.getBeanClass();
        if (clazz != null) {
            try {
                Method method = clazz.getMethod("ejbStore", new Class[0]);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String declareEjbRemoveMethod() {
        return this.declareBeanMethod("ejbRemove", new Class[0], true);
    }

    public String declareEjbPassivateMethod() {
        return this.declareBeanMethod("ejbPassivate", new Class[0], true);
    }

    private boolean throwsCreateException(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(CreateException.class)) continue;
            return true;
        }
        return false;
    }

    public String returnPkPerhapsInsertBean() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        Class clazz = this.bd.getPrimaryKeyClass();
        stringBuffer.append(ClassUtils.classToJavaSourceType(clazz) + " " + this.pkVar() + " = null;" + EOL);
        if (this.bean.getDelayInsertUntil().equals("ejbCreate")) {
            stringBuffer.append("if (!" + this.pmVar() + ".getOrderDatabaseOperations() || " + "TransactionHelper.getTransactionHelper().getTransaction()==null) {" + EOL);
            stringBuffer.append(this.pkVar() + " = (" + ClassUtils.classToJavaSourceType(clazz) + ")" + this.createMethodName() + "();" + EOL);
            stringBuffer.append("} else {");
            stringBuffer.append(EOL);
        }
        stringBuffer.append(this.pkVar() + " = (" + ClassUtils.classToJavaSourceType(clazz) + ") __WL_getPrimaryKey();" + EOL);
        if (this.bean.getDelayInsertUntil().equals("ejbCreate")) {
            stringBuffer.append("}");
            stringBuffer.append(EOL);
        }
        stringBuffer.append("return " + this.pkVar() + ";" + EOL);
        stringBuffer.append(this.perhapsCatchCreateException());
        if (this.bean.getDelayInsertUntil().equals("ejbCreate") || !this.bean.hasAutoKeyGeneration()) {
            stringBuffer.append(this.parse(this.getProductionRule("standardCatch")));
        } else {
            stringBuffer.append("}" + EOL + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsCatchCreateException() {
        if (this.throwsCreateException(this.method)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("} catch (javax.ejb.CreateException ce) {" + EOL);
            stringBuffer.append("throw ce;" + EOL);
            return stringBuffer.toString();
        }
        return "";
    }

    public String perhapsInsertBean() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = this.bd.getPrimaryKeyClass();
        if (this.bean.getDelayInsertUntil().equals("ejbPostCreate")) {
            stringBuffer.append("if (!" + this.pmVar() + ".getOrderDatabaseOperations() || " + "TransactionHelper.getTransactionHelper().getTransaction()==null)" + EOL);
            stringBuffer.append(this.createMethodName() + "();" + EOL);
        }
        return stringBuffer.toString();
    }

    public String implementEjbCreateMethods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = this.bd.getBeanClass();
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            method = methodArray[i];
            if (!method.getName().startsWith("ejbCreate")) continue;
            this.setMethod(method, (short)0);
            stringBuffer.append(this.method_signature_no_throws());
            stringBuffer.append(this.beanmethod_throws_clause());
            stringBuffer.append("{");
            stringBuffer.append(EOL);
            if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                stringBuffer.append(this.parse(this.getProductionRule("ejbCreateMethodBody")));
            } else {
                stringBuffer.append("Loggable l = EJBLogger.logCannotCreateReadOnlyBeanLoggable(\"" + this.bean.getEjbName() + "\");" + EOL);
                stringBuffer.append("throw new javax.ejb.EJBException(l.getMessage());" + EOL);
            }
            stringBuffer.append("}");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String implementEjbPostCreateMethods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = this.bd.getBeanClass();
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            method = methodArray[i];
            if (!method.getName().startsWith("ejbPostCreate")) continue;
            this.setMethod(method, (short)0);
            stringBuffer.append(this.method_signature_no_throws());
            stringBuffer.append(this.beanmethod_throws_clause());
            stringBuffer.append("{");
            stringBuffer.append(EOL);
            if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                stringBuffer.append(this.parse(this.getProductionRule("ejbPostCreateMethod")));
            } else {
                stringBuffer.append("Loggable l = EJBLogger.logCannotCreateReadOnlyBeanLoggable(\"" + this.bean.getEjbName() + "\");" + EOL);
                stringBuffer.append("throw new javax.ejb.EJBException(l.getMessage());" + EOL);
            }
            stringBuffer.append("}");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String implementEjbRemoveMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.declareEjbRemoveMethod());
        stringBuffer.append(" {" + EOL);
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(this.parse(this.getProductionRule("implementEjbRemoveMethodBody")));
        } else {
            stringBuffer.append("Loggable l = EJBLogger.logCannotRemoveReadOnlyBeanLoggable(\"" + this.bean.getEjbName() + "\");" + EOL);
            stringBuffer.append("throw new javax.ejb.EJBException(l.getMessage());" + EOL);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String implementSetNullMethods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curField : this.bean.getCmrFieldNames()) {
            if (this.bean.isOneToOneRelation(this.curField) && !this.bean.isRemoteField(this.curField)) {
                stringBuffer.append("public void " + MethodUtils.setNullMethodName(this.curField) + "(boolean ejbStore) {" + EOL);
                if (this.bean.isForeignKeyField(this.curField)) {
                    stringBuffer.append(this.parse(this.getProductionRule("oneToOneSetNullBody_fkOwner")));
                } else {
                    stringBuffer.append(this.parse(this.getProductionRule("oneToOneSetNullBody")));
                }
                stringBuffer.append("}" + EOL + EOL);
            }
            this.curField = null;
        }
        return stringBuffer.toString();
    }

    public String implementMakeCascadeDelListMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.isCascadeDelete()) {
            stringBuffer.append(this.parse(this.getProductionRule("implementMakeCascadeDelListMethodBody")));
        } else {
            stringBuffer.append(this.parse(this.getProductionRule("implementMakeCascadeDelListMethodBody_AddThisBean")));
        }
        return stringBuffer.toString();
    }

    public String get11_RelBeans_RootBeanFKOwner() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        while (iterator.hasNext()) {
            String string;
            this.curField = string = (String)iterator.next();
            if (!this.bean.isCascadeDelete(string) || !this.bean.isOneToOneRelation(string) || this.bean.isRemoteField(string)) continue;
            RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(string);
            String string2 = this.bean.getRelatedFieldName(string);
            if (this.bean.relatedFieldIsFkOwner(string) || !rDBMSBean.relatedFieldIsFkOwner(string2)) continue;
            stringBuffer.append(EOL);
            stringBuffer.append(this.parse(this.getProductionRule("oneToOneCascadeDel")));
        }
        return stringBuffer.toString();
    }

    public String get1N11_RelBeans_RootBeanNotFKOwner() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        while (iterator.hasNext()) {
            String string;
            RDBMSBean rDBMSBean;
            String string2;
            this.curField = string2 = (String)iterator.next();
            if (!this.bean.isCascadeDelete(string2)) continue;
            if (this.bean.isOneToOneRelation(string2)) {
                if (this.bean.isRemoteField(string2)) continue;
                rDBMSBean = this.bean.getRelatedRDBMSBean(string2);
                string = this.bean.getRelatedFieldName(string2);
                if (!this.bean.relatedFieldIsFkOwner(string2) || rDBMSBean.relatedFieldIsFkOwner(string)) continue;
                stringBuffer.append(EOL);
                stringBuffer.append(this.parse(this.getProductionRule("oneToOneCascadeDel")));
                continue;
            }
            if (!this.bean.isOneToManyRelation(string2) || this.bean.isRemoteField(string2) || !this.bean.getRelatedMultiplicity(string2).equals("Many")) continue;
            rDBMSBean = this.bean.getRelatedRDBMSBean(string2);
            string = this.bean.getRelatedFieldName(string2);
            if (!this.bean.relatedFieldIsFkOwner(string2) || rDBMSBean.relatedFieldIsFkOwner(string)) continue;
            stringBuffer.append(EOL);
            stringBuffer.append(this.parse(this.getProductionRule("oneToManyCascadeDel")));
        }
        return stringBuffer.toString();
    }

    public String get11_RelBeans_EachOtherFKOwner() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        while (iterator.hasNext()) {
            String string;
            this.curField = string = (String)iterator.next();
            if (!this.bean.isCascadeDelete(string) || !this.bean.isOneToOneRelation(string) || this.bean.isRemoteField(string)) continue;
            RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(string);
            String string2 = this.bean.getRelatedFieldName(string);
            if (!this.bean.relatedFieldIsFkOwner(string) || !rDBMSBean.relatedFieldIsFkOwner(string2)) continue;
            stringBuffer.append(EOL);
            stringBuffer.append(this.parse(this.getProductionRule("oneToOneCascadeDel")));
        }
        return stringBuffer.toString();
    }

    public boolean isPrimaryKeyCMRField(String string) {
        if (this.bean.getForeignKeyColNames(string) == null) {
            return true;
        }
        Iterator iterator = this.bean.getForeignKeyColNames(string).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.bean.getCmpFieldForColumn(string2);
            if (string3 == null) {
                return false;
            }
            if (!this.bean.isPrimaryKeyField(string3)) break;
            ++n;
        }
        return n == this.bean.getForeignKeyColNames(string).size();
    }

    public String perhapsLoadDefaultGroup() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.bean.isCascadeDelete(string)) continue;
            if (!this.bean.isManyToManyRelation(string) && this.isPrimaryKeyCMRField(string) && this.bean.getRelationshipCaching(string) != null) {
                bl2 = true;
            }
            RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(string);
            if (this.bean.getLockOrder() >= rDBMSBean.getLockOrder()) continue;
            FieldGroup fieldGroup = this.bean.getFieldGroup("defaultGroup");
            stringBuffer.append(this.loadMethodName(this.getFieldGroupSuffix(fieldGroup)) + "();" + EOL);
            bl = true;
            break;
        }
        if (!bl && bl2) {
            stringBuffer.append(this.loadByRelationFinder());
        }
        return stringBuffer.toString();
    }

    public String listRelBeansVar() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.isDBCascadeDelete(this.curField)) {
            stringBuffer.append("listRelBeans_WithoutDBUpdate");
        } else {
            stringBuffer.append("listRelBeans");
        }
        return stringBuffer.toString();
    }

    public String addBeanToRelationships() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(EOL);
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.bean.isRemoteField(string) || !this.bean.isForeignPrimaryKeyField(string)) continue;
            stringBuffer.append(MethodUtils.postSetMethodName(string) + "();" + EOL);
        }
        return stringBuffer.toString();
    }

    public String loadByRelationFinder() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        String string = null;
        stringBuffer.append("//load related bean in join sql" + EOL);
        stringBuffer.append("boolean executed = false;" + EOL);
        stringBuffer.append("if((__WL_isModified() || !__WL_beanIsLoaded())){" + EOL);
        stringBuffer.append("Transaction currentTx = TransactionHelper.getTransactionHelper().getTransaction();" + EOL);
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!this.bean.isCascadeDelete(string) || this.bean.isManyToManyRelation(string) || !this.isPrimaryKeyCMRField(string) || this.bean.getRelationshipCaching(string) == null) continue;
            EjbqlFinder ejbqlFinder = (EjbqlFinder)this.bean.getRelatedFinder(string);
            if (this.bean.isManyToManyRelation(string)) {
                stringBuffer.append("if(!executed||" + CodeGenUtils.fieldVarName(string) + " == null ||(" + CodeGenUtils.fieldVarName(string) + "!=null && currentTx!=null && !(((RDBMSSet)" + CodeGenUtils.fieldVarName(string) + ").checkIfCurrentTxEqualsCreateTx(currentTx)))){" + EOL);
            } else {
                List list = this.bean.getPrimaryKeyFields();
                stringBuffer.append("if (!executed");
                for (String string2 : list) {
                    stringBuffer.append("||!" + this.isLoadedVar(string2));
                }
                stringBuffer.append(") {" + EOL);
            }
            stringBuffer.append(MethodUtils.convertToFinderName(ejbqlFinder.getName()) + "((" + this.bean.getCMPBeanDescriptor().getPrimaryKeyClass().getName() + ")" + this.ctxVar() + ".getPrimaryKey());" + EOL);
            stringBuffer.append("executed=true;" + EOL);
            stringBuffer.append("}" + EOL);
        }
        stringBuffer.append("}" + EOL);
        return stringBuffer.toString();
    }

    public String removeBeanFromRelationships() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getCmrFieldNames().iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(EOL);
        }
        while (iterator.hasNext()) {
            String string;
            String string2;
            RDBMSBean rDBMSBean;
            String string3;
            this.curField = string3 = (String)iterator.next();
            if (this.bean.isOneToOneRelation(string3)) {
                if (this.bean.isRemoteField(string3)) continue;
                rDBMSBean = this.bean.getRelatedRDBMSBean(string3);
                string2 = this.bean.getRelatedFieldName(string3);
                String string4 = string = this.bean.relatedFieldIsFkOwner(string3) && !rDBMSBean.isForeignPrimaryKeyField(string2) && !this.bean.isCascadeDelete(string3) ? "true" : "false";
                if (this.bean.isSelfRelationship(string3)) {
                    stringBuffer.append(this.fieldRemovedVarForField() + " = " + this.fieldVarForField() + ";" + EOL);
                }
                stringBuffer.append(MethodUtils.setNullMethodName(string3) + "(" + string + ");" + EOL);
                if (this.bean.isSelfRelationship(string3)) continue;
                stringBuffer.append(MethodUtils.doSetMethodName(string3) + "(null);" + EOL);
                continue;
            }
            if (this.bean.isOneToManyRelation(string3)) {
                if (!this.bean.isRemoteField(string3)) {
                    if (this.bean.getRelatedMultiplicity(string3).equals("Many")) {
                        rDBMSBean = this.bean.getRelatedRDBMSBean(string3);
                        string2 = this.bean.getRelatedFieldName(string3);
                        string = this.bean.relatedFieldIsFkOwner(string3) && !rDBMSBean.isForeignPrimaryKeyField(string2) && !this.bean.isCascadeDelete(string3) ? "true" : "false";
                        stringBuffer.append(MethodUtils.getMethodName(string3) + "();" + EOL);
                        if (this.bean.isSelfRelationship(string3)) {
                            stringBuffer.append("try {" + EOL);
                            stringBuffer.append("if (" + this.fieldRemovedVarForField() + " == null)" + EOL);
                            stringBuffer.append(this.fieldRemovedVarForField() + " = (Set)((" + this.collectionClassForField() + ")" + this.fieldVarForField() + ").clone();" + EOL);
                            stringBuffer.append("else" + EOL);
                            stringBuffer.append(this.fieldRemovedVarForField() + ".addAll((Set)((" + this.collectionClassForField() + ")" + this.fieldVarForField() + ").clone());" + EOL);
                            stringBuffer.append("} catch (CloneNotSupportedException e) {" + EOL);
                            stringBuffer.append("// clone() failed, do nothing" + EOL);
                            stringBuffer.append("}" + EOL);
                        }
                        stringBuffer.append("((" + ClassUtils.setClassName(this.bd, string3) + ")");
                        stringBuffer.append(CodeGenUtils.fieldVarName(string3));
                        stringBuffer.append(").clear(" + string + ");" + EOL);
                        continue;
                    }
                    stringBuffer.append(this.varPrefix() + MethodUtils.setMethodName(string3) + "(null, false);" + EOL);
                    continue;
                }
                stringBuffer.append(MethodUtils.setMethodName(string3) + "(null);" + EOL);
                continue;
            }
            stringBuffer.append(MethodUtils.getMethodName(string3) + "().clear();" + EOL);
        }
        return stringBuffer.toString();
    }

    public String implementEjbStoreMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        stringBuffer.append(this.declareEjbStoreMethod());
        stringBuffer.append(" { " + EOL);
        stringBuffer.append(this.parse(this.getProductionRule("implementEjbStoreMethodBody")));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String declareCmrGettersAndSetters() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curField : this.bean.getCmrFieldNames()) {
            stringBuffer.append(this.generateCmrGetterMethod());
            if (this.bean.isOneToOneRelation(this.curField)) {
                stringBuffer.append(this.oneToOneSetMethod());
                stringBuffer.append(this.oneToManyAddMethod());
                continue;
            }
            if (this.bean.isOneToManyRelation(this.curField)) {
                stringBuffer.append(this.oneToManySetMethod());
                stringBuffer.append(this.oneToManyAddMethod());
                continue;
            }
            if (this.bean.isManyToManyRelation(this.curField)) {
                stringBuffer.append(this.manyToManySetMethod());
                continue;
            }
            throw new AssertionError((Object)"Invalid  multiplicity for relation.");
        }
        return stringBuffer.toString();
    }

    public String implementCmrFieldPutInQueryCacheMethod() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Iterator iterator = this.bean.getCmrFieldNames().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.bean.getCmrFieldNames().size() > 1) {
                    if (!bl) {
                        stringBuffer.append("if (").append(this.cmrFieldNameVar()).append(".equals(\"");
                        bl = true;
                    } else {
                        stringBuffer.append("} else if (").append(this.cmrFieldNameVar()).append(".equals(\"");
                    }
                    stringBuffer.append(string).append("\")) {").append(EOL);
                }
                RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(string);
                String string2 = this.bean.getRelatedFieldName(string);
                CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(string);
                if (this.bean.isOneToOneRelation(string) && cMPBeanDescriptor.hasLocalClientView() && !rDBMSBean.relatedFieldIsFkOwner(string2)) {
                    String string3 = CodeGenUtils.fieldVarName(string);
                    String string4 = this.generateCMRFieldFinderMethodName(string);
                    stringBuffer.append("TTLManager roMgr = (TTLManager)");
                    stringBuffer.append(this.bmVar(string)).append(";").append(EOL);
                    stringBuffer.append("QueryCacheKey qckey = new QueryCacheKey(\"");
                    stringBuffer.append(string4).append("\", new Object[]{");
                    stringBuffer.append("__WL_getPrimaryKey()").append("}, roMgr, ");
                    stringBuffer.append("QueryCacheKey.RET_TYPE_SINGLETON);").append(EOL);
                    stringBuffer.append("if (").append(this.sourceQueryCacheKeyVar());
                    stringBuffer.append(" != null) {").append(EOL);
                    stringBuffer.append(this.sourceQueryCacheKeyVar()).append(".addDestinationQuery(");
                    stringBuffer.append("qckey);").append(EOL);
                    stringBuffer.append("qckey.addSourceQuery(").append(this.sourceQueryCacheKeyVar());
                    stringBuffer.append(");").append(EOL);
                    stringBuffer.append("}").append(EOL);
                    stringBuffer.append("QueryCacheElement qce = new QueryCacheElement(");
                    stringBuffer.append(string3);
                    stringBuffer.append(".getPrimaryKey(), roMgr);").append(EOL);
                    stringBuffer.append("roMgr.putInQueryCache(qckey, qce);").append(EOL);
                    continue;
                }
                if ((!this.bean.isOneToManyRelation(string) || rDBMSBean.relatedFieldIsFkOwner(string2)) && !this.bean.isManyToManyRelation(string)) continue;
                stringBuffer.append("((RDBMSSet)").append(CodeGenUtils.fieldVarName(string));
                stringBuffer.append(").putInQueryCache(").append(this.sourceQueryCacheKeyVar());
                stringBuffer.append(");").append(EOL);
            }
            if (this.bean.getCmrFieldNames().size() > 1) {
                stringBuffer.append("} else {").append(EOL);
                stringBuffer.append("throw new AssertionError(\"Unknown CMR field: \"");
                stringBuffer.append("+").append(this.cmrFieldNameVar()).append(");").append(EOL);
                stringBuffer.append("}").append(EOL);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
        return stringBuffer.toString();
    }

    public String cmrFieldQueryCachingMethodName() {
        return this.varPrefix() + "putCmrFieldInQueryCache";
    }

    public String cmrFieldNameVar() {
        return this.varPrefix() + "cmrFieldName";
    }

    public String sourceQueryCacheKeyVar() {
        return this.varPrefix() + "sourceQCKey";
    }

    public String loadCheckForCmrField() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.isForeignCmpField(this.curField)) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : this.bean.getForeignKeyColNames(this.curField)) {
                String string2 = this.bean.getCmpFieldForColumn(string);
                hashSet.add(this.getMethodSuffix(string2));
            }
            boolean bl = hashSet.size() > 1;
            for (String string2 : this.bean.getForeignKeyColNames(this.curField)) {
                String string = this.bean.getCmpFieldForColumn(string2);
                stringBuffer.append("if (!" + this.isLoadedVar(string) + ") ");
                stringBuffer.append(this.callLoadMethod(string) + EOL);
                if (bl) continue;
                break;
            }
        } else {
            stringBuffer.append(this.parse(this.getProductionRule("simpleLoadCheckForField")));
        }
        return stringBuffer.toString();
    }

    public String declareCmrVariableGetters() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (String string : this.bean.getForeignKeyFieldNames()) {
                if (!this.bean.isOneToManyRelation(string) || this.bean.isRemoteField(string)) continue;
                this.curField = string;
                String string2 = this.bean.getTableForCmrField(string);
                for (String string3 : this.bean.getForeignKeyColNames(string)) {
                    if (this.bean.hasCmpField(string2, string3)) continue;
                    String string4 = this.bean.variableForField(string, string2, string3);
                    Class clazz = this.bean.getForeignKeyColClass(string, string3);
                    String string5 = ClassUtils.classToJavaSourceType(clazz);
                    stringBuffer.append("public ");
                    stringBuffer.append(string5 + " ");
                    stringBuffer.append(MethodUtils.getMethodName(string4));
                    stringBuffer.append("() {" + EOL);
                    stringBuffer.append("try {" + EOL);
                    stringBuffer.append(this.loadCheckForCmrField());
                    stringBuffer.append(this.parse(this.getProductionRule("standardCatch")));
                    stringBuffer.append("return " + string4 + ";" + EOL);
                    stringBuffer.append("}" + EOL + EOL);
                }
                this.curField = null;
            }
            return stringBuffer.toString();
        }
        catch (CodeGenerationException codeGenerationException) {
            throw codeGenerationException;
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                exception.printStackTrace();
            }
            throw new CodeGenerationException("Error in RDBMSCodeGenerator.generateCmrVariableGetterMethods: " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
    }

    private String generateCmrGetterMethod() throws CodeGenerationException {
        StringBuffer stringBuffer;
        block13: {
            stringBuffer = new StringBuffer();
            String string = ClassUtils.classToJavaSourceType(this.bean.getCmrFieldClass(this.curField));
            boolean bl = this.bean.isQueryCachingEnabledForCMRField(this.curField);
            stringBuffer.append("public ");
            stringBuffer.append(string + " ");
            stringBuffer.append(this.getMethodNameForField());
            stringBuffer.append("() {");
            stringBuffer.append(EOL);
            try {
                if (this.bean.isOneToOneRelation(this.curField)) {
                    if (this.bean.isForeignKeyField(this.curField)) {
                        stringBuffer.append(this.parse(this.getProductionRule("oneToOneGetterBody_fkOwner")));
                    } else {
                        if (bl) {
                            stringBuffer.append(this.fieldVarForField()).append(" = ");
                            stringBuffer.append(this.bmVarForField()).append(".getFromQueryCache(");
                            stringBuffer.append(this.finderVarForField()).append(".getName(), new Object[]{");
                            stringBuffer.append(this.ctxVar()).append(".getPrimaryKey()});").append(EOL);
                            stringBuffer.append("if (").append(this.fieldVarForField()).append(" != null) ");
                            stringBuffer.append("return ").append(this.fieldVarForField());
                            stringBuffer.append(";").append(EOL);
                        }
                        stringBuffer.append(this.parse(this.getProductionRule("oneToOneGetterBody")));
                        if (bl) {
                            stringBuffer.append("QueryCacheKey qckey = new QueryCacheKey(");
                            stringBuffer.append(this.finderVarForField()).append(".getName(), ");
                            stringBuffer.append("new Object[] {").append(this.ctxVar());
                            stringBuffer.append(".getPrimaryKey()}, ").append("(TTLManager)");
                            stringBuffer.append(this.bmVarForField());
                            stringBuffer.append(", QueryCacheKey.RET_TYPE_SINGLETON);").append(EOL);
                            stringBuffer.append("QueryCacheElement qcelem = new QueryCacheElement(");
                            stringBuffer.append(this.fieldVarGetPrimaryKey()).append(", ");
                            stringBuffer.append(this.bmVarForField()).append(");").append(EOL);
                            stringBuffer.append(this.bmVarForField()).append(".putInQueryCache(qckey, ");
                            stringBuffer.append("qcelem);").append(EOL);
                        }
                    }
                    break block13;
                }
                if (this.bean.isOneToManyRelation(this.curField)) {
                    if (this.bean.getRelatedMultiplicity(this.curField).equals("One")) {
                        stringBuffer.append(this.parse(this.getProductionRule("oneToManyGetterBody_fkOwner")));
                    } else {
                        stringBuffer.append(this.parse(this.getProductionRule("oneToManyGetterBody")));
                        if (!this.bean.isRemoteField(this.curField)) {
                            this.generateOneToManyCollection();
                        }
                    }
                    break block13;
                }
                if (this.bean.isManyToManyRelation(this.curField)) {
                    stringBuffer.append(this.parse(this.getProductionRule("ManyToManyGetterBody")));
                    if (!this.bean.isRemoteField(this.curField)) {
                        this.generateManyToManyCollection();
                    }
                    break block13;
                }
                throw new AssertionError((Object)"Invalid  multiplicity for relation.");
            }
            catch (Exception exception) {
                throw new CodeGenerationException("Error in RDBMSCodeGenerator.generateCmrGetterMethod: " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
        }
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String allocateOneToManySet() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bean.isRemoteField(this.curField)) {
            stringBuffer.append("new " + this.collectionClassForField() + "(this, " + this.bmVarForField() + ", " + this.finderVarForField() + ")" + EOL);
        } else {
            stringBuffer.append("new " + this.collectionClassForField() + "(this, " + this.homeVarForField() + ", " + this.pmVar() + ")" + EOL);
        }
        return stringBuffer.toString();
    }

    private void generateOneToManyCollection() throws CodeGenerationException {
        try {
            OneToManyGenerator oneToManyGenerator = new OneToManyGenerator(this.options);
            oneToManyGenerator.setRootDirectoryName(this.getRootDirectoryName());
            oneToManyGenerator.setTargetDirectory(this.getRootDirectoryName());
            oneToManyGenerator.setRDBMSBean(this.bean);
            oneToManyGenerator.setCMPBeanDescriptor(this.bd);
            oneToManyGenerator.setCmrFieldName(this.curField);
            List list = oneToManyGenerator.generate(new ArrayList());
            this.getGeneratedOutputs().addAll(oneToManyGenerator.getGeneratedOutputs());
            this.currentOutput.addExtraOutputFiles(list);
        }
        catch (Exception exception) {
            Loggable loggable = EJBLogger.logErrorWhileGeneratingLoggable((String)"One to Many Collection", (Exception)exception);
            EJBLogger.logStackTraceAndMessage((String)loggable.getMessage(), (Throwable)exception);
            throw new CodeGenerationException(loggable.getMessage());
        }
    }

    public String allocateManyToManySet() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bean.isRemoteField(this.curField)) {
            stringBuffer.append("new " + this.collectionClassForField() + "(this, " + this.bmVarForField() + ", " + this.finderVarForField() + ", " + this.pmVar() + ")" + EOL);
        } else {
            stringBuffer.append("new " + this.collectionClassForField() + "(this, " + this.homeVarForField() + ", " + this.pmVar() + ")" + EOL);
        }
        return stringBuffer.toString();
    }

    private void generateManyToManyCollection() throws CodeGenerationException {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("called generateManyToManyCollection");
        }
        try {
            ManyToManyGenerator manyToManyGenerator = new ManyToManyGenerator(this.options);
            manyToManyGenerator.setRootDirectoryName(this.getRootDirectoryName());
            manyToManyGenerator.setTargetDirectory(this.getRootDirectoryName());
            manyToManyGenerator.setRDBMSBean(this.bean);
            manyToManyGenerator.setCMPBeanDescriptor(this.bd);
            manyToManyGenerator.setCmrFieldName(this.curField);
            List list = manyToManyGenerator.generate(new ArrayList());
            this.getGeneratedOutputs().addAll(manyToManyGenerator.getGeneratedOutputs());
            this.currentOutput.addExtraOutputFiles(list);
        }
        catch (Exception exception) {
            Loggable loggable = EJBLogger.logErrorWhileGeneratingLoggable((String)"One to Many Collection", (Exception)exception);
            EJBLogger.logStackTraceAndMessage((String)loggable.getMessage(), (Throwable)exception);
            throw new CodeGenerationException(loggable.getMessage());
        }
    }

    public String perhapsGetM2NSQL() throws CodeGenerationException {
        if (!this.bean.getOrderDatabaseOperations()) {
            return "return \"\";";
        }
        List list = this.bean.getDeclaredFieldNames();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = null;
        if (!iterator.hasNext()) {
            return "return \"\";";
        }
        stringBuffer = new StringBuffer();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.bean.isManyToManyRelation(string)) continue;
            this.curField = string;
            stringBuffer.append(this.parse(this.getProductionRule("manyToManyGetSQL")));
        }
        stringBuffer.append("throw new AssertionError(\" in __WL_getM2NSQL: unknown Many To Many cmr-field \"+cmrf+\".\");");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String perhapsGetCmrBeansForCmrField() throws CodeGenerationException {
        if (!this.bean.getOrderDatabaseOperations()) {
            return "return null;";
        }
        List list = this.bean.getDeclaredFieldNames();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = null;
        if (!iterator.hasNext()) {
            return "return null;";
        }
        stringBuffer = new StringBuffer();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.bean.isManyToManyRelation(string)) continue;
            this.curField = string;
            stringBuffer.append(this.parse(this.getProductionRule("getCmrBeansForCmrField")));
        }
        stringBuffer.append("throw new AssertionError(\" in __WL_getCmrBeansForCmrField: unknown Many To Many cmr-field \"+cmrf+\".\");");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String perhapsManyToManySetSymmetricBeanInsertParams() throws CodeGenerationException {
        if (!this.bean.getOrderDatabaseOperations()) {
            return "";
        }
        if (!this.bean.isSymmetricField(this.curField)) {
            return "";
        }
        return this.parse(this.getProductionRule("manyToManySetSymmetricBeanInsertParams"));
    }

    public String doCheckExistsOnMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        this.curGroup = this.bean.getFieldGroup("defaultGroup");
        stringBuffer.append(this.parse(this.getProductionRule("checkExistsOnMethodBody")));
        this.curGroup = null;
        return stringBuffer.toString();
    }

    public String perhapsDoCheckExistsOnMethod() throws CodeGenerationException {
        if (this.bean.getCheckExistsOnMethod()) {
            return "__WL_doCheckExistsOnMethod();";
        }
        return "";
    }

    public String perhapsCheckRelatedExistsOneMany() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(this.curField);
        if (rDBMSBean.getCheckExistsOnMethod()) {
            stringBuffer.append(this.parse(this.getProductionRule("checkRelatedExistsOneMany")));
        }
        return stringBuffer.toString();
    }

    public String perhapsCheckExistsOneOne() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.getCheckExistsOnMethod()) {
            stringBuffer.append(this.parse(this.getProductionRule("checkExistsOneOne")));
        }
        return stringBuffer.toString();
    }

    public String bmVarForField() {
        return this.bmVar(this.curField);
    }

    public String finderInvokerForField() {
        if (this.bean.isRemoteField(this.curField)) {
            return this.homeVarForField();
        }
        return this.bmVarForField();
    }

    public String finderVarForField() {
        return this.finderVarName(this.curField);
    }

    public String finderParamForField() {
        if (this.bean.isRemoteField(this.curField)) {
            return "";
        }
        return this.finderVarForField() + ", ";
    }

    public String fieldClassForCmpField() {
        return ClassUtils.classToJavaSourceType(this.bean.getCmpFieldClass(this.curField));
    }

    public String cmpColumnForCmpField() {
        return this.bean.getCmpColumnForField(this.curField);
    }

    public String collectionClassForField() {
        return ClassUtils.setClassName(this.bd, this.curField);
    }

    public String isLoadedVar(String string) {
        return this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]";
    }

    public String isLoadedVarForField() {
        return this.isLoadedVar(this.curField);
    }

    public String isModifiedVar(String string) {
        return this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]";
    }

    public String isModifiedVarForField() {
        return this.isModifiedVar(this.curField);
    }

    public String loadMethodNameForGroup() {
        return this.loadMethodName(this.getFieldGroupSuffix(this.curGroup));
    }

    public String loadMethodName(String string) {
        return this.varPrefix() + "load" + this.capitalize(string);
    }

    public String callLoadMethod(String string) {
        String string2 = this.getMethodSuffix(string);
        return this.loadMethodName(string2) + "();";
    }

    public String callLoadMethodForField() {
        return this.callLoadMethod(this.curField);
    }

    public String fieldVarForField() {
        return CodeGenUtils.fieldVarName(this.curField);
    }

    public String fieldRemovedVarForField() {
        return CodeGenUtils.fieldRemovedVarName(this.curField);
    }

    public String classNameForField() {
        return this.bean.getCmrFieldClass(this.curField).getName();
    }

    public String fkVarForFieldIsNull() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.bean.getTableForCmrField(this.curField);
        Iterator iterator = this.bean.getForeignKeyColNames(this.curField).iterator();
        boolean bl = false;
        stringBuffer.append("(");
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.bean.variableForField(this.curField, string, string2);
            Class clazz = this.bean.getForeignKeyColClass(this.curField, string2);
            if (clazz.isPrimitive()) continue;
            if (bl) {
                stringBuffer.append(" || ");
            } else {
                bl = true;
            }
            stringBuffer.append(string3 + "==null");
        }
        if (!bl) {
            stringBuffer.append("false");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String fkVarForField() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
            return this.fkVar();
        }
        String string = this.bean.getTableForCmrField(this.curField);
        String string2 = (String)this.bean.getForeignKeyColNames(this.curField).iterator().next();
        Class clazz = this.bean.getForeignKeyColClass(this.curField, string2);
        return this.perhapsConvertPrimitive(clazz, "this." + this.bean.variableForField(this.curField, string, string2));
    }

    private String capitalize(String string) {
        Debug.assertion((string.length() > 0 ? 1 : 0) != 0);
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public String declareFkVarForField() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        String string = cMPBeanDescriptor.getPrimaryKeyClass().getName();
        return string + " " + this.fkVar() + ";" + EOL;
    }

    public String perhapsDeclareFkVar() {
        CMPBeanDescriptor cMPBeanDescriptor;
        if (!this.bean.isRemoteField(this.curField) && (cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField)).hasComplexPrimaryKey()) {
            return this.declareFkVarForField();
        }
        return "";
    }

    public String allocateFkVarForField() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        String string = cMPBeanDescriptor.getPrimaryKeyClass().getName();
        return this.fkVar() + " = new " + string + "();" + EOL;
    }

    public String perhapsAllocateFkVar() {
        CMPBeanDescriptor cMPBeanDescriptor;
        if (!this.bean.isRemoteField(this.curField) && (cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField)).hasComplexPrimaryKey()) {
            return this.allocateFkVarForField();
        }
        return "";
    }

    public String assignFkVarForField() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getForeignKeyColNames(this.curField).iterator();
        String string = this.bean.getTableForCmrField(this.curField);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.bean.getRelatedPkFieldName(this.curField, string2);
            stringBuffer.append(this.fkVar()).append(".").append(string3).append(" = ");
            RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(this.curField);
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
            Class clazz = cMPBeanDescriptor.getFieldClass(string3);
            String string4 = this.bean.variableForField(this.curField, string, string2);
            Class clazz2 = this.bean.getForeignKeyColClass(this.curField, string2);
            String string5 = this.perhapsConvert(clazz, clazz2, string4);
            stringBuffer.append("this").append(".").append(string5).append(";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsAssignFkVar() {
        CMPBeanDescriptor cMPBeanDescriptor;
        if (!this.bean.isRemoteField(this.curField) && (cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField)).hasComplexPrimaryKey()) {
            return this.assignFkVarForField();
        }
        return "";
    }

    public String declarePkVar() {
        return this.pk_class() + " " + this.pkVar() + " = null;";
    }

    public String allocatePkVar() {
        if (this.bd.hasComplexPrimaryKey()) {
            return this.pkVar() + " = new " + this.pk_class() + "();";
        }
        return "";
    }

    public String perhapsDeclarePkVar() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
            return this.declarePkVar();
        }
        return "";
    }

    public String perhapsCopyKeyValuesToPkVar() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
            return this.copyKeyValuesToPkVar();
        }
        return "";
    }

    public String pkVarForField() {
        if (this.bd.hasComplexPrimaryKey()) {
            return this.pkVar();
        }
        return (String)this.pkFieldNames.iterator().next();
    }

    public String implementGetPrimaryKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.declarePkVar() + EOL);
        stringBuffer.append(this.allocatePkVar() + EOL);
        stringBuffer.append(this.assignPkFieldsToPkVar() + EOL);
        stringBuffer.append("return " + this.pkVar() + ";" + EOL);
        return stringBuffer.toString();
    }

    public String implementSetPrimaryKey() {
        return this.assignPkVarToPkFields() + EOL;
    }

    private String oneToOneSetMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ClassUtils.classToJavaSourceType(this.bean.getCmrFieldClass(this.curField));
        stringBuffer.append("public void ");
        stringBuffer.append(MethodUtils.setMethodName(this.curField));
        stringBuffer.append("(");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.curField);
        stringBuffer.append(") {");
        stringBuffer.append(EOL);
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            if (this.bean.isForeignKeyField(this.curField)) {
                stringBuffer.append(this.oneToOneSetBody_fkOwner());
            } else {
                stringBuffer.append(this.oneToOneSetBody());
            }
        } else {
            stringBuffer.append("Loggable l = EJBLogger.logCannotCallSetForReadOnlyBeanLoggable(\"" + this.bean.getEjbName() + "\");" + EOL);
            stringBuffer.append("throw new javax.ejb.EJBException(l.getMessage());" + EOL);
        }
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("public void ");
        stringBuffer.append(MethodUtils.doSetMethodName(this.curField));
        stringBuffer.append("(");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.curField);
        stringBuffer.append(") {");
        stringBuffer.append(EOL);
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            if (this.bean.isForeignKeyField(this.curField)) {
                stringBuffer.append(this.parse(this.getProductionRule("oneToOneDoSetBody_fkOwner")));
            } else {
                stringBuffer.append(this.oneToOneDoSetBody());
            }
        }
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        if (!this.bean.isForeignPrimaryKeyField(this.curField)) {
            stringBuffer.append("public boolean ");
            stringBuffer.append(MethodUtils.checkIsRemovedMethodName(this.curField));
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.curField);
            stringBuffer.append(") throws java.lang.Exception {");
            stringBuffer.append(EOL);
            stringBuffer.append(this.parse(this.getProductionRule("checkIsRemovedBody")));
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(EOL);
        }
        if (!this.bean.isRemoteField(this.curField)) {
            stringBuffer.append("private void ");
            stringBuffer.append(MethodUtils.postSetMethodName(this.curField));
            stringBuffer.append("() throws java.lang.Exception {");
            stringBuffer.append(EOL);
            if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                if (this.bean.isForeignKeyField(this.curField)) {
                    stringBuffer.append(this.parse(this.getProductionRule("oneToOnePostSetBody_fkOwner")));
                } else {
                    stringBuffer.append(this.parse(this.getProductionRule("oneToOnePostSetBody")));
                }
            }
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(EOL);
            stringBuffer.append("public void ");
            stringBuffer.append(MethodUtils.setRestMethodName(this.curField));
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.curField);
            stringBuffer.append(", int methodState) {");
            stringBuffer.append(EOL);
            if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                if (this.bean.isForeignKeyField(this.curField)) {
                    stringBuffer.append(this.parse(this.getProductionRule("oneToOneSetRestBody_fkOwner")));
                } else {
                    stringBuffer.append(this.parse(this.getProductionRule("oneToOneSetRestBody")));
                }
            }
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(EOL);
            stringBuffer.append("public void ");
            stringBuffer.append(MethodUtils.setCmrIsLoadedMethodName(this.curField));
            stringBuffer.append("(boolean b) {");
            stringBuffer.append(EOL);
            if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                stringBuffer.append(this.isCmrLoadedVarName(this.curField) + " = b;");
                stringBuffer.append(EOL);
            }
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsOptimizeOneToOne() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.isBiDirectional(this.curField)) {
            stringBuffer.append("if(methodState != WLEnterpriseBean.STATE_EJB_POSTCREATE)" + EOL);
            stringBuffer.append(this.getMethodNameForField() + "();" + EOL);
        } else {
            stringBuffer.append("if(this.__WL_getMethodState() != WLEnterpriseBean.STATE_EJB_POSTCREATE) " + EOL);
            stringBuffer.append(this.getMethodNameForField() + "();" + EOL);
        }
        return stringBuffer.toString();
    }

    public String relClassNameForField() {
        return this.bean.getRelatedBeanClassName(this.curField);
    }

    public String relInterfaceNameForField() {
        return this.relInterfaceNameForField(this.curField);
    }

    public String relInterfaceNameForField(String string) {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(string);
        return cMPBeanDescriptor.getGeneratedBeanInterfaceName();
    }

    public String relatedDoSetForField() {
        String string = this.bean.getRelatedFieldName(this.curField);
        return MethodUtils.doSetMethodName(string);
    }

    public String componentInterfaceForBean() {
        if (this.bd.hasLocalClientView()) {
            return this.bd.getLocalInterfaceClass().getName();
        }
        if (this.bd.isEJB30()) {
            return this.bd.getJavaClassName();
        }
        return this.bd.getRemoteInterfaceClass().getName();
    }

    public String relatedSetRestForField() {
        String string = this.bean.getRelatedFieldName(this.curField);
        return MethodUtils.setRestMethodName(string);
    }

    public String relatedIsCmrLoadedVarNameForField() {
        String string = this.bean.getRelatedFieldName(this.curField);
        return MethodUtils.setCmrIsLoadedMethodName(string);
    }

    public String oneToOneSetBody_fkOwner() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.isForeignPrimaryKeyField(this.curField)) {
            stringBuffer.append("Loggable l = EJBLogger.logsetCheckForCmrFieldAsPkLoggable();" + EOL);
            stringBuffer.append("throw new EJBException(l.getMessage());" + EOL + EOL);
        } else {
            stringBuffer.append("if (__WL_method_state==STATE_EJB_CREATE) {" + EOL);
            stringBuffer.append("Loggable l = EJBLogger.logsetCheckForCmrFieldDuringEjbCreateLoggable();" + EOL);
            stringBuffer.append("throw new IllegalStateException(l.getMessage());" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("try {" + EOL);
            stringBuffer.append("if (" + MethodUtils.checkIsRemovedMethodName(this.curField) + "(" + this.curField + ")) {" + EOL);
            stringBuffer.append("Loggable l = EJBLogger.logillegalAttemptToAssignRemovedBeanToCMRFieldLoggable(");
            stringBuffer.append(this.curField).append(".getPrimaryKey().toString());").append(EOL);
            stringBuffer.append("throw new IllegalArgumentException(l.getMessage());" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"[\" + " + this.ctxVar() + ".getPrimaryKey() + \"]called ");
            stringBuffer.append(MethodUtils.setMethodName(this.curField) + "...\");" + EOL);
            stringBuffer.append("}" + EOL);
            if (!this.bean.isRemoteField(this.curField)) {
                stringBuffer.append(MethodUtils.setNullMethodName(this.curField) + "(false);" + EOL);
            }
            stringBuffer.append(MethodUtils.doSetMethodName(this.curField) + "(" + this.curField + ");" + EOL);
            if (!this.bean.isRemoteField(this.curField)) {
                stringBuffer.append(MethodUtils.postSetMethodName(this.curField) + "();" + EOL);
            }
            stringBuffer.append(this.parse(this.getProductionRule("standardCatch")));
        }
        return stringBuffer.toString();
    }

    public String oneToOneSetBody() throws CodeGenerationException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(this.curField);
        if (rDBMSBean.isForeignPrimaryKeyField(string = this.bean.getRelatedFieldName(this.curField))) {
            stringBuffer.append("Loggable l = EJBLogger.logsetCheckForCmrFieldAsPkLoggable();" + EOL);
            stringBuffer.append("throw new EJBException(l.getMessage());" + EOL + EOL);
        } else {
            stringBuffer.append("if (__WL_method_state==STATE_EJB_CREATE) {" + EOL);
            stringBuffer.append("Loggable l = EJBLogger.logsetCheckForCmrFieldDuringEjbCreateLoggable();" + EOL);
            stringBuffer.append("throw new IllegalStateException(l.getMessage());" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("try {" + EOL);
            stringBuffer.append("if (" + MethodUtils.checkIsRemovedMethodName(this.curField) + "(" + this.curField + ")) {" + EOL);
            stringBuffer.append("Loggable l = EJBLogger.logillegalAttemptToAssignRemovedBeanToCMRFieldLoggable(");
            stringBuffer.append(this.curField).append(".getPrimaryKey().toString());").append(EOL);
            stringBuffer.append("throw new IllegalArgumentException(l.getMessage());" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append(MethodUtils.setNullMethodName(this.curField) + "(false);" + EOL);
            stringBuffer.append(MethodUtils.doSetMethodName(this.curField) + "(" + this.curField + ");" + EOL + EOL);
            stringBuffer.append(MethodUtils.postSetMethodName(this.curField) + "();" + EOL);
            stringBuffer.append(this.parse(this.getProductionRule("standardCatch")));
        }
        return stringBuffer.toString();
    }

    public String assignFkVarsNull_forField() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bean.isForeignPrimaryKeyField(this.curField)) {
            String string = this.bean.getTableForCmrField(this.curField);
            for (Object object : this.bean.getForeignKeyColNames(this.curField)) {
                String string2 = this.bean.variableForField(this.curField, string, (String)object);
                stringBuffer.append(string2 + " = null;" + EOL);
            }
            if (this.bean.isForeignCmpField(this.curField)) {
                for (String string2 : this.bean.getForeignKeyColNames(this.curField)) {
                    String string3 = this.bean.getCmpFieldForColumn(string2);
                    stringBuffer.append(this.isModifiedVar(string3) + " = true;" + EOL);
                }
            } else {
                stringBuffer.append(this.isModifiedVarForField() + " = true;" + EOL);
            }
            stringBuffer.append(this.perhapsSetTableModifiedVarForCmrField());
        }
        return stringBuffer.toString();
    }

    public String assignFkVarsFkField_forField() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bean.isForeignPrimaryKeyField(this.curField)) {
            String string;
            String string2;
            Object object3;
            Object object2;
            boolean bl = false;
            if (!this.bean.isRemoteField(this.curField)) {
                object2 = this.bean.getRelatedDescriptor(this.curField);
                object3 = object2.getPrimaryKeyClass();
                string2 = ((Class)object3).getName();
                if (object2.hasComplexPrimaryKey()) {
                    bl = true;
                    stringBuffer.append(this.declareFkVarForField());
                    stringBuffer.append(this.fkVar() + " = (" + string2 + ")");
                    stringBuffer.append(this.fieldVarGetPrimaryKey()).append(";").append(EOL);
                    string = this.bean.getTableForCmrField(this.curField);
                    for (String string3 : this.bean.getForeignKeyColNames(this.curField)) {
                        String string4 = this.bean.variableForField(this.curField, string, string3);
                        String string5 = this.bean.getRelatedPkFieldName(this.curField, string3);
                        Field field = null;
                        try {
                            field = ((Class)object3).getField(string5);
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Unable to access field '" + string5 + "' in class '" + string2 + "'. " + StackTraceUtils.throwable2StackTrace((Throwable)exception)));
                        }
                        stringBuffer.append(this.assignPkFieldToVariable(string4, this.fkVar(), field));
                    }
                }
            }
            if (!bl) {
                object2 = this.bean.getRelatedDescriptor(this.curField);
                object3 = this.bean.getTableForCmrField(this.curField);
                string2 = (String)this.bean.getForeignKeyColNames(this.curField).iterator().next();
                string = this.bean.variableForField(this.curField, (String)object3, string2);
                String string6 = ClassUtils.classToJavaSourceType((Class)this.variableToClass.get(string));
                stringBuffer.append(string + " = ");
                stringBuffer.append("(" + (String)string6 + ")");
                stringBuffer.append(this.fieldVarGetPrimaryKey()).append(";").append(EOL);
            }
            if (this.bean.isForeignCmpField(this.curField)) {
                for (Object object3 : this.bean.getForeignKeyColNames(this.curField)) {
                    string2 = this.bean.getCmpFieldForColumn((String)object3);
                    stringBuffer.append(this.isModifiedVar(string2) + " = true;" + EOL);
                }
            } else {
                stringBuffer.append(this.isModifiedVarForField() + " = true;" + EOL);
            }
            stringBuffer.append(this.perhapsSetTableModifiedVarForCmrField());
        }
        return stringBuffer.toString();
    }

    public String assignPkFieldToVariable(String string, String string2, Field field) {
        Class<?> clazz = field.getType();
        String string3 = string2 + "." + field.getName();
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                string3 = "new Boolean(" + string3 + ")";
            } else if (clazz == Byte.TYPE) {
                string3 = "new Byte(" + string3 + ")";
            } else if (clazz == Character.TYPE) {
                string3 = "new Character(" + string3 + ")";
            } else if (clazz == Double.TYPE) {
                string3 = "new Double(" + string3 + ")";
            } else if (clazz == Float.TYPE) {
                string3 = "new Float(" + string3 + ")";
            } else if (clazz == Integer.TYPE) {
                string3 = "new Integer(" + string3 + ")";
            } else if (clazz == Long.TYPE) {
                string3 = "new Long(" + string3 + ")";
            } else if (clazz == Short.TYPE) {
                string3 = "new Short(" + string3 + ")";
            } else {
                throw new AssertionError((Object)"Missing primitive in CommonRules.assignPkFieldToVariable");
            }
        }
        return string + " = " + string3 + ";" + EOL;
    }

    public String oneToOneDoSetBody() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.assignFieldVarForFieldWithFieldNameForField()).append(EOL);
        stringBuffer.append(this.isCmrLoadedVarName(this.curField) + " = true;" + EOL);
        stringBuffer.append(EOL);
        stringBuffer.append("  // whenever this bean's relationship with " + this.curField + " changes" + EOL);
        stringBuffer.append("  // this __WL_doSet method is invoked." + EOL);
        stringBuffer.append("  // so we mark the nonFKHolderRelationChange bit in this __WL_doSet method." + EOL);
        stringBuffer.append("  __WL_setNonFKHolderRelationChange(true);" + EOL);
        stringBuffer.append(this.parse(this.getProductionRule("registerInvalidatedBean")));
        return stringBuffer.toString();
    }

    private String oneToManySetMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = this.bean.getCmrFieldClass(this.curField);
        String string = ClassUtils.classToJavaSourceType(clazz);
        stringBuffer.append("public void ");
        stringBuffer.append(MethodUtils.setMethodName(this.curField));
        stringBuffer.append("(");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.curField);
        stringBuffer.append(") {");
        stringBuffer.append(EOL);
        if (this.bean.getRelatedMultiplicity(this.curField).equals("One")) {
            if (this.bean.isForeignPrimaryKeyField(this.curField)) {
                stringBuffer.append("Loggable l = EJBLogger.logsetCheckForCmrFieldAsPkLoggable();" + EOL);
                stringBuffer.append("throw new EJBException(l.getMessage());" + EOL + EOL);
            } else if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                stringBuffer.append("if (__WL_method_state==STATE_EJB_CREATE) {" + EOL);
                stringBuffer.append("Loggable l = EJBLogger.logsetCheckForCmrFieldDuringEjbCreateLoggable();" + EOL);
                stringBuffer.append("throw new IllegalStateException(l.getMessage());" + EOL);
                stringBuffer.append("}" + EOL);
                stringBuffer.append("try {" + EOL);
                stringBuffer.append("if (" + MethodUtils.checkIsRemovedMethodName(this.curField) + "(" + this.curField + ")) {" + EOL);
                stringBuffer.append("Loggable l = EJBLogger.logillegalAttemptToAssignRemovedBeanToCMRFieldLoggable(");
                stringBuffer.append(this.curField).append(".getPrimaryKey().toString());");
                stringBuffer.append(EOL);
                stringBuffer.append("throw new IllegalArgumentException(l.getMessage());" + EOL);
                stringBuffer.append("}" + EOL);
                stringBuffer.append(this.parse(this.getProductionRule("standardCatch")));
                stringBuffer.append(this.varPrefix() + MethodUtils.setMethodName(this.curField) + "(" + this.curField + ", false);" + EOL);
            } else {
                stringBuffer.append("Loggable l = EJBLogger.logCannotCallSetForReadOnlyBeanLoggable(\"" + this.bean.getEjbName() + "\");" + EOL);
                stringBuffer.append("throw new javax.ejb.EJBException(l.getMessage());" + EOL);
            }
            stringBuffer.append("}" + EOL);
            stringBuffer.append("public void ");
            stringBuffer.append(this.varPrefix() + MethodUtils.setMethodName(this.curField));
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.curField);
            stringBuffer.append(", boolean ejbStore) {");
            stringBuffer.append(EOL);
            stringBuffer.append(this.varPrefix() + MethodUtils.setMethodName(this.curField));
            stringBuffer.append("(").append(this.curField).append(", ejbStore, true);" + EOL);
            stringBuffer.append("}" + EOL + EOL);
            stringBuffer.append("// The flag 'remove' controls whether the Relationship's" + EOL);
            stringBuffer.append("// underlying __WL_cache does a remove() operation." + EOL);
            stringBuffer.append("// If an Iterator of the __WL_cache is used to effect a remove()" + EOL);
            stringBuffer.append("// then we must be sure to not to do a__WL_cache.remove()" + EOL);
            stringBuffer.append("//   that is the intended use of the 'remove' flag." + EOL + EOL);
            stringBuffer.append("public void ");
            stringBuffer.append(this.varPrefix() + MethodUtils.setMethodName(this.curField));
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.curField);
            stringBuffer.append(", boolean ejbStore");
            stringBuffer.append(", boolean remove) {");
            stringBuffer.append(EOL);
            if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                if (!this.bean.isRemoteField(this.curField)) {
                    stringBuffer.append(this.parse(this.getProductionRule("oneToManySetBody_local_fkOwner")));
                } else {
                    stringBuffer.append(this.parse(this.getProductionRule("oneToManySetBody_remote_fkOwner")));
                }
            }
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(EOL);
            if (!this.bean.isForeignPrimaryKeyField(this.curField)) {
                stringBuffer.append("public boolean ");
                stringBuffer.append(MethodUtils.checkIsRemovedMethodName(this.curField));
                stringBuffer.append("(");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(this.curField);
                stringBuffer.append(") throws java.lang.Exception {");
                stringBuffer.append(EOL);
                stringBuffer.append(this.parse(this.getProductionRule("checkIsRemovedBody")));
                stringBuffer.append("}");
                stringBuffer.append(EOL);
                stringBuffer.append(EOL);
            }
            if (!(this.bd.isReadOnly() && !this.bean.allowReadonlyCreateAndRemove() || this.bean.isRemoteField(this.curField))) {
                stringBuffer.append("private void " + MethodUtils.postSetMethodName(this.curField) + "() throws java.lang.Exception {" + EOL);
                stringBuffer.append(this.parse(this.getProductionRule("oneToManyPostSetBody")));
                stringBuffer.append("}");
                stringBuffer.append(EOL);
                stringBuffer.append(EOL);
            }
        } else {
            String string2;
            RDBMSBean rDBMSBean;
            boolean bl = false;
            if (!this.bean.isRemoteField(this.curField) && (rDBMSBean = this.bean.getRelatedRDBMSBean(this.curField)).isForeignPrimaryKeyField(string2 = this.bean.getRelatedFieldName(this.curField))) {
                bl = true;
                stringBuffer.append("Loggable l = EJBLogger.logsetCheckForCmrFieldAsPkLoggable();");
                stringBuffer.append("throw new EJBException(l.getMessage());" + EOL + EOL);
            }
            if (!bl) {
                if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                    stringBuffer.append("if (__WL_method_state==STATE_EJB_CREATE) {" + EOL);
                    stringBuffer.append("Loggable l = EJBLogger.logsetCheckForCmrFieldDuringEjbCreateLoggable();");
                    stringBuffer.append("throw new IllegalStateException(l.getMessage());" + EOL);
                    stringBuffer.append("}" + EOL);
                    stringBuffer.append(this.parse(this.getProductionRule("oneToManySetBody")));
                } else {
                    stringBuffer.append("Loggable l = EJBLogger.logCannotCallSetForReadOnlyBeanLoggable(\"" + this.bean.getEjbName() + "\");" + EOL);
                    stringBuffer.append("throw new javax.ejb.EJBException(l.getMessage());" + EOL);
                }
            }
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(EOL);
        }
        if (this.bean.getRelatedMultiplicity(this.curField).equals("One") && (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove())) {
            stringBuffer.append("public void ");
            stringBuffer.append(MethodUtils.doSetMethodName(this.curField));
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.curField);
            stringBuffer.append(") {");
            stringBuffer.append(EOL);
            stringBuffer.append(this.parse(this.getProductionRule("oneToOneDoSetBody_fkOwner")));
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsCallPostSetMethodForField() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bean.isForeignPrimaryKeyField(this.curField)) {
            stringBuffer.append(MethodUtils.postSetMethodName(this.curField) + "();" + EOL);
        }
        return stringBuffer.toString();
    }

    private String manyToManySetMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ClassUtils.classToJavaSourceType(this.bean.getCmrFieldClass(this.curField));
        stringBuffer.append("public void ");
        stringBuffer.append(MethodUtils.setMethodName(this.curField));
        stringBuffer.append("(");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.curField);
        stringBuffer.append(") {");
        stringBuffer.append(EOL);
        stringBuffer.append(this.parse(this.getProductionRule("oneToManySetBody")));
        stringBuffer.append("}");
        stringBuffer.append(EOL);
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String copyFromMethodBody() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.cmpBeanClassName() + " " + this.beanVar() + " = null;" + EOL);
        stringBuffer.append("try {" + EOL);
        stringBuffer.append(this.beanVar() + " = (" + this.cmpBeanClassName() + ")otherBean;" + EOL);
        stringBuffer.append(this.parse(this.getProductionRule("standardCatch")));
        for (String string : this.cmpFieldNames) {
            stringBuffer.append(this.checkFieldNotModifiedOrLoaded("this", string));
            stringBuffer.append("if (" + this.beanVar() + "." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]) {" + EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"copying field '" + string + "' to bean '\" +" + EOL + this.beanVar() + ".__WL_getPrimaryKey() + \"'.\");" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append(this.setCmpField(string, this.getCmpField(this.beanVar(), string)) + ";" + EOL);
            stringBuffer.append("this." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]");
            stringBuffer.append(" = true;" + EOL);
            if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                stringBuffer.append("if (!__WL_initSnapshotVars) {").append(EOL);
                stringBuffer.append("this." + this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]" + " = true;" + EOL);
                stringBuffer.append(this.beanIsModifiedVar()).append(" = true;").append(EOL);
                stringBuffer.append("}").append(EOL);
            }
            if (this.bd.isOptimistic() && !this.bd.getPrimaryKeyFieldNames().contains(string) && !this.bean.isBlobCmpColumnTypeForField(string) && !this.bean.isClobCmpColumnTypeForField(string) && this.doSnapshot(string)) {
                stringBuffer.append("if (__WL_initSnapshotVars) ");
                stringBuffer.append("this." + CodeGenUtils.snapshotNameForVar(string) + " = " + this.beanVar() + "." + CodeGenUtils.snapshotNameForVar(string) + ";" + EOL);
            }
            stringBuffer.append("}" + EOL);
            stringBuffer.append("}" + EOL + EOL);
        }
        for (String string : this.bean.getForeignKeyFieldNames()) {
            if (!this.bean.containsFkField(string) || this.bean.isForeignCmpField(string)) continue;
            stringBuffer.append(this.checkFieldNotModifiedOrLoaded("this", string));
            stringBuffer.append("if (" + this.beanVar() + "." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]==true) {" + EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"copying field '" + string + "' to bean '\" +" + EOL + this.beanVar() + ".__WL_getPrimaryKey() + \"'.\");" + EOL);
            stringBuffer.append("}" + EOL);
            String string2 = this.bean.getTableForCmrField(string);
            for (String string3 : this.bean.getForeignKeyColNames(string)) {
                String string4 = this.bean.variableForField(string, string2, string3);
                stringBuffer.append("this." + string4 + " = " + this.beanVar() + "." + string4 + ";" + EOL);
                if (!this.bd.isOptimistic() || !this.doSnapshot(string4)) continue;
                stringBuffer.append("if (__WL_initSnapshotVars) ");
                stringBuffer.append("this." + CodeGenUtils.snapshotNameForVar(string4) + " = " + this.beanVar() + "." + CodeGenUtils.snapshotNameForVar(string4) + ";" + EOL);
            }
            stringBuffer.append("this." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]");
            stringBuffer.append(" = true;" + EOL);
            if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
                stringBuffer.append("if (!__WL_initSnapshotVars) {").append(EOL);
                stringBuffer.append("this." + this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]" + " = true;" + EOL);
                stringBuffer.append(this.beanIsModifiedVar()).append(" = true;").append(EOL);
                stringBuffer.append("}").append(EOL);
            }
            stringBuffer.append("}" + EOL);
            stringBuffer.append("}" + EOL + EOL);
        }
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append("this." + this.modifiedBeanIsRegisteredVar() + " = " + this.beanVar() + "." + this.modifiedBeanIsRegisteredVar() + ";" + EOL);
        }
        stringBuffer.append("this." + this.beanIsLoadedVar() + " = " + this.beanVar() + "." + this.beanIsLoadedVar() + ";" + EOL + EOL);
        Iterator iterator = this.bean.getAllCmrFields().iterator();
        while (iterator.hasNext()) {
            String string;
            this.curField = string = (String)iterator.next();
            stringBuffer.append("if (!this." + this.isCmrLoadedVarName(string) + ") {" + EOL);
            stringBuffer.append("if (" + this.beanVar() + "." + this.isCmrLoadedVarName(string) + "==true) {" + EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"copying cmr field '" + string + "' to bean '\" +" + EOL + this.beanVar() + ".__WL_getPrimaryKey() + \"'.\");" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("this." + CodeGenUtils.fieldVarName(string) + " = " + this.beanVar() + "." + CodeGenUtils.fieldVarName(string) + ";" + EOL);
            stringBuffer.append("this." + this.isCmrLoadedVarName(string) + " = true;" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("}" + EOL + EOL);
        }
        return stringBuffer.toString();
    }

    public String tableName() {
        return this.bean.getQuotedTableName();
    }

    public String curTableName() {
        return this.curTableName;
    }

    public int curTableIndex() {
        return this.curTableIndex;
    }

    public String implementFinderMethods() throws EJBCException {
        Object object2;
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("ejb.container.cmp.rdbms.codegen.RDBMSCodeGenerator.implementFinderMethods() called.");
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        for (Object object2 : this.finderList) {
            if (((Finder)object2).getQueryType() != 0 || object2 instanceof SqlFinder) continue;
            try {
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("generating finder: " + object2);
                }
                stringBuffer.append(this.implementFinderMethod((Finder)object2));
            }
            catch (CodeGenerationException codeGenerationException) {
                Loggable loggable = EJBLogger.logCouldNotGenerateFinderLoggable((String)"finder", (String)((Finder)object2).toString(), (String)codeGenerationException.getMessage());
                throw new EJBCException(loggable.getMessage());
            }
        }
        object2 = this.bean.getRelationFinders();
        while (object2.hasNext()) {
            Finder finder = (Finder)object2.next();
            if (finder.getQueryType() != 0) continue;
            try {
                stringBuffer.append(this.implementFinderMethod(finder));
            }
            catch (CodeGenerationException codeGenerationException) {
                Loggable loggable = EJBLogger.logCouldNotGenerateFinderLoggable((String)" relation finder", (String)finder.toString(), (String)codeGenerationException.getMessage());
                throw new EJBCException(loggable.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    public String perhapsImplementRelCachingForDynamicFinders() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        List list = this.bean.getRelationshipCachings();
        Iterator iterator = list.iterator();
        if (list != null) {
            bl = list.iterator().hasNext();
        }
        if (!bl) {
            return "";
        }
        while (iterator.hasNext()) {
            RelationshipCaching relationshipCaching = (RelationshipCaching)iterator.next();
            String string = relationshipCaching.getCachingName();
            if (string == null && string == "") continue;
            stringBuffer.append(this.generateMethodsToLoadBeansForCachingNames(relationshipCaching, this.bean));
        }
        return stringBuffer.toString();
    }

    private String generateMethodsToLoadBeansForCachingNames(RelationshipCaching relationshipCaching, RDBMSBean rDBMSBean) throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = relationshipCaching.getCachingName();
        List list = relationshipCaching.getCachingElements();
        stringBuffer.append(EOL + "public void loadBeansFor" + this.replaceIllegalJavaCharacters(string) + "(java.sql.ResultSet " + this.rsVar() + ", CMPBean bean, " + "int groupColumnCount, QueryCachingHandler qcHandler) " + EOL);
        stringBuffer.append(" throws Exception {" + EOL + EOL);
        stringBuffer.append(EOL + "// load related beans " + EOL);
        stringBuffer.append(this.getGeneratedBeanClassName() + " " + this.beanVar() + " = (" + this.getGeneratedBeanClassName() + ") bean;" + EOL + EOL);
        this.perhapsRelationshipCachingPooledBeanVar(rDBMSBean, list.iterator(), null, 1, stringBuffer);
        stringBuffer.append(EOL);
        this.perhapsRelationshipCachingPooledBeanVar(rDBMSBean, list.iterator(), null, 2, stringBuffer);
        stringBuffer.append(EOL);
        stringBuffer.append("Integer " + this.offsetIntObjVar() + " = null;" + EOL);
        stringBuffer.append("Object " + this.eoRCVar() + " = null;" + EOL);
        stringBuffer.append("Object " + this.eoVar() + " = null;" + EOL);
        stringBuffer.append(EOL + "Map " + this.pkMapVar() + " = new HashMap();" + EOL);
        stringBuffer.append(this.declarePKMapVarForCachingElements(rDBMSBean, list.iterator(), null));
        stringBuffer.append(EOL + EOL);
        stringBuffer.append("int increment = groupColumnCount;" + EOL);
        this.invokeEagerCachingMethodsForCachingElements(rDBMSBean, list.iterator(), null, stringBuffer, true);
        stringBuffer.append("}" + EOL);
        return stringBuffer.toString();
    }

    public String implementLoaderMethodForDynamicFinders() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.bean.getRelationshipCachings();
        Iterator iterator = list.iterator();
        stringBuffer.append("public void __WL_loadBeansRelatedToCachingName(String cachingName, java.sql.ResultSet rs, CMPBean bean, int groupColumnCount, QueryCachingHandler qcHandler)" + EOL);
        stringBuffer.append("throws Exception {" + EOL);
        while (iterator.hasNext()) {
            RelationshipCaching relationshipCaching = (RelationshipCaching)iterator.next();
            String string = relationshipCaching.getCachingName();
            if (string == null && string != "") continue;
            stringBuffer.append("if(cachingName.equals(\"" + string + "\")) {" + EOL);
            stringBuffer.append("loadBeansFor" + this.replaceIllegalJavaCharacters(string) + "(rs, bean, groupColumnCount, qcHandler);" + EOL);
            stringBuffer.append("}" + EOL);
        }
        stringBuffer.append("}" + EOL);
        return stringBuffer.toString();
    }

    private String implementFinderMethod(Finder finder) throws EJBCException, CodeGenerationException {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("implementFinderMethod(" + finder + ") called.");
        }
        assert (this.bd != null);
        this.curFinder = finder;
        if (this.curFinder == null) {
            Loggable loggable = EJBLogger.logNullFinderLoggable((String)"implementFinderMethod");
            throw new EJBCException(loggable.getMessage());
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        string = finder.getQueryType() == 4 || finder.getQueryType() == 2 ? MethodUtils.getEjbSelectInternalMethodDeclaration(finder, this.bd.getPrimaryKeyClass()) : MethodUtils.getFinderMethodDeclaration(finder, this.bd.getPrimaryKeyClass());
        stringBuffer.append(string);
        stringBuffer.append("{" + EOL);
        try {
            if (this.curFinder.isMultiFinder()) {
                stringBuffer.append(this.parse(this.getProductionRule("finderMethodBodyMulti")));
            } else {
                stringBuffer.append(this.parse(this.getProductionRule("finderMethodBodyScalar")));
            }
        }
        catch (CodeGenerationException codeGenerationException) {
            if (debugLogger.isDebugEnabled()) {
                RDBMSCodeGenerator.debug("finderMethod cought CodeGenerationException : " + (Object)((Object)codeGenerationException));
            }
            if (debugLogger.isDebugEnabled()) {
                codeGenerationException.printStackTrace();
            }
            Loggable loggable = EJBLogger.logCouldNotProduceProductionRuleLoggable((String)"finder ");
            throw codeGenerationException;
        }
        stringBuffer.append("" + EOL + "}" + EOL + EOL);
        this.curFinder = null;
        return stringBuffer.toString();
    }

    public String finderMethodName() {
        assert (this.curFinder != null);
        return this.curFinder.getName();
    }

    public String firstPrimaryKeyColumn() {
        assert (this.curTableName != null);
        Map map = this.bean.getPKCmpf2ColumnForTable(this.curTableName);
        String string = (String)map.values().iterator().next();
        return string;
    }

    public String finderQuery() {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("ejb.container.cmp.rdbms.codegen.RDBMSCodeGenerator.finderQuery() called for method " + this.curFinder.getName());
        }
        assert (this.curFinder != null);
        assert (this.curFinder.getSQLQuery() != null);
        String string = this.curFinder.getSQLQuery();
        return string;
    }

    public String finderQueryForUpdate() {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("ejb.container.cmp.rdbms.codegen.RDBMSCodeGenerator.finderQueryForUpdate() called for method " + this.curFinder.getName());
        }
        assert (this.curFinder != null);
        assert (this.curFinder.getSQLQueryForUpdate() != null);
        String string = this.curFinder.getSQLQueryForUpdate();
        return string;
    }

    public String finderQueryForUpdateNoWait() {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("ejb.container.cmp.rdbms.codegen.RDBMSCodeGenerator.finderQueryForUpdateNoWait() called for method " + this.curFinder.getName());
        }
        assert (this.curFinder != null);
        assert (this.curFinder.getSQLQueryForUpdateNoWait() != null);
        String string = this.curFinder.getSQLQueryForUpdateNoWait();
        return string;
    }

    private String finderQueryForUpdateSelective() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("ejb.container.cmp.rdbms.codegen.RDBMSCodeGenerator.finderQueryForUpdateSelective() called for method " + this.curFinder.getName()));
        }
        if (debugLogger.isDebugEnabled()) {
            Debug.assertion((this.curFinder != null ? 1 : 0) != 0);
        }
        String string = this.curFinder.getSQLQueryForUpdateSelective();
        return string;
    }

    public String generateSqlQueryOrSqlQueryForUpdateOrSqlQueryForUpdateOf() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("ejb.container.cmp.rdbms.codegen.RDBMSCodeGenerator.generateSqlQueryOrSqlQueryForUpdateOrSqlQueryForUpdateOf called for method " + this.curFinder.getName()));
        }
        if (this.finderQueryForUpdateSelective() != null) {
            return this.queryVar() + " = \"" + this.finderQueryForUpdateSelective() + "\"";
        }
        if (this.bean.getUseSelectForUpdate()) {
            return this.queryVar() + " = \"" + this.finderQueryForUpdate() + "\"";
        }
        return this.queryVar() + " = \"" + this.finderQuery() + "\"";
    }

    public String perhapsSetMaxRows() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.curFinder.getMaxElements() != 0) {
            stringBuffer.append(this.stmtVar() + ".setMaxRows(" + this.curFinder.getMaxElements() + ");" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsFlushCaches() {
        StringBuffer stringBuffer = new StringBuffer();
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("perhaps flush caches for finder- " + this.curFinder.getName() + "include updates- " + this.curFinder.getIncludeUpdates());
        }
        if (this.curFinder.getIncludeUpdates() && !this.curFinder.isFindByPrimaryKey()) {
            stringBuffer.append(this.pmVar() + ".flushModifiedBeans();" + EOL);
        }
        return stringBuffer.toString();
    }

    public String findOrEjbSelectBeanNotFound() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("throw new ");
        stringBuffer.append("javax.ejb.ObjectNotFoundException(");
        if (this.curFinder.isFindByPrimaryKey()) {
            stringBuffer.append("\"Bean with primary key '\" + param0.toString() + \"' was not found by 'findByPrimaryKey'.\");");
        } else {
            stringBuffer.append("\"Bean not found in '");
            stringBuffer.append(this.finderMethodName()).append("'.\");");
        }
        return stringBuffer.toString();
    }

    public String declareResultVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.curFinder.isMultiFinder()) {
            if (this.curFinder.isSetFinder()) {
                stringBuffer.append(this.declareOrderedSetVar() + EOL);
            } else {
                stringBuffer.append(this.declareColVar() + EOL);
            }
        }
        if (this.curFinder.finderLoadsBean()) {
            stringBuffer.append(this.declareBeanVar());
            stringBuffer.append(this.declareEoVar());
        } else {
            stringBuffer.append(this.declarePkVar());
        }
        return stringBuffer.toString();
    }

    public String declareColVar() {
        return "java.util.Collection " + this.colVar() + " = new java.util.ArrayList();";
    }

    public String declareSetVar() {
        return "java.util.Set " + this.setVar() + " = new java.util.HashSet();";
    }

    public String declareOrderedSetVar() {
        return "java.util.Set " + this.orderedSetVar() + " = new weblogic.ejb20.utils.OrderedSet();";
    }

    public String resultVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.curFinder.isMultiFinder()) {
            if (this.curFinder.isSetFinder()) {
                stringBuffer.append(this.orderedSetVar());
            } else {
                stringBuffer.append(this.colVar());
            }
        } else if (this.curFinder.finderLoadsBean()) {
            stringBuffer.append(this.eoVar());
        } else {
            stringBuffer.append(this.pkVar());
        }
        return stringBuffer.toString();
    }

    public String getSimpleGeneratedBeanClassName() {
        return MethodUtils.tail(this.bd.getGeneratedBeanClassName());
    }

    public String getGeneratedBeanClassName() {
        return this.bd.getGeneratedBeanClassName();
    }

    public String getGeneratedBeanInterfaceName() {
        return this.bd.getGeneratedBeanInterfaceName();
    }

    public String declareBeanVar() {
        return this.getGeneratedBeanClassName() + " " + this.beanVar() + " = null;" + EOL;
    }

    public String getBeanFromRS() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RSInfo " + this.rsInfoVar() + " = new RSInfoImpl(" + this.rsVar() + ", " + this.curGroup.getIndex() + ", 0, " + this.pkVar() + ");" + EOL);
        stringBuffer.append(this.beanVar() + " = (" + this.getGeneratedBeanClassName() + ")" + this.pmVar() + ".getBeanFromRS(" + this.pkVar() + ", " + this.rsInfoVar() + ");");
        stringBuffer.append(EOL + EOL);
        return stringBuffer.toString();
    }

    public String allocateBeanVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.beanVar() + " = (" + this.getGeneratedBeanClassName() + ")" + this.pmVar() + ".getBeanFromPool();" + EOL);
        stringBuffer.append(this.beanVar() + ".__WL_initialize();" + EOL);
        return stringBuffer.toString();
    }

    public String declareEoVar() {
        return "Object " + this.eoVar() + " = null;" + EOL + "Object " + this.eoRCVar() + " = null;" + EOL;
    }

    public String finderColumnsSql() throws EJBCException {
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        list = this.curFinder.finderLoadsBean() ? this.cmpFieldNames : this.pkFieldNames;
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.bean.getCmpColumnForField(string);
            assert (string2 != null);
            stringBuffer.append(RDBMSUtils.escQuotedID(string2));
            if (n < list.size() - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String setFinderQueryParams() throws EJBCException {
        Object object;
        Object object2;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        Finder finder = this.curFinder;
        assert (finder != null);
        assert (finder.getSQLQuery() != null);
        int n = finder.getQueryType();
        Class[] classArray = null;
        String[] stringArray = null;
        ArrayList<Object> arrayList = null;
        if (finder instanceof EjbqlFinder) {
            EjbqlFinder ejbqlFinder = (EjbqlFinder)finder;
            if (ejbqlFinder.isKeyFinder() && ejbqlFinder.getKeyBean().getCMPBeanDescriptor().hasComplexPrimaryKey()) {
                arrayList = new ArrayList<Object>();
                RDBMSBean rDBMSBean = ejbqlFinder.getKeyBean();
                Object object4 = rDBMSBean.getCMPBeanDescriptor();
                object3 = object4.getPrimaryKeyFieldNames().toArray(new String[0]);
                classArray = new Class[((String[])object3).length];
                stringArray = new String[((Object)object3).length];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray[i] = object4.getFieldClass((String)object3[i]);
                    object2 = "param0." + (String)object3[i];
                    object = new ParamNode(rDBMSBean, (String)object2, i + 1, classArray[i], "", "", false, false, null, false, RDBMSUtils.isOracleNLSDataType(rDBMSBean, (String)object3[i]));
                    arrayList.add(object);
                }
            } else {
                arrayList = finder.getInternalQueryAndInEntityParmList();
            }
        }
        int n2 = 0;
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("\n  prepStmt setXX processing, parameterList is: " + arrayList);
        }
        for (Object object4 : arrayList) {
            Class clazz;
            String string;
            ParamNode paramNode;
            Iterator iterator;
            boolean bl;
            ++n2;
            if (((ParamNode)object4).isBeanParam()) {
                object3 = ((ParamNode)object4).getParamName();
                String string2 = this.varPrefix() + (String)object3 + "_PK";
                object2 = ((ParamNode)object4).getPrimaryKeyClass();
                object = ((Class)object2).getName();
                stringBuffer.append((String)object + " " + string2 + ";" + EOL);
                stringBuffer.append(string2 + " = " + "(" + (String)object + ")" + (String)object3 + ".getPrimaryKey();" + EOL + EOL);
                if (((ParamNode)object4).hasCompoundKey()) {
                    bl = false;
                    iterator = ((ParamNode)object4).getParamSubList().iterator();
                    while (iterator.hasNext()) {
                        paramNode = (ParamNode)iterator.next();
                        string = this.varPrefix() + (String)object3 + "_PK." + paramNode.getId();
                        clazz = paramNode.getParamClass();
                        this.writePrepStmtSet(stringBuffer, n2, string, clazz, paramNode.isOracleNLSDataType());
                        if (!iterator.hasNext()) continue;
                        ++n2;
                    }
                    continue;
                }
                this.writePrepStmtSet(stringBuffer, n2, string2, (Class)object2, ((ParamNode)object4).isOracleNLSDataType());
                continue;
            }
            if (((ParamNode)object4).isSelectInEntity()) {
                if (n == 5 || n == 3) {
                    for (ParamNode paramNode2 : ((ParamNode)object4).getParamSubList()) {
                        if (debugLogger.isDebugEnabled()) {
                            RDBMSCodeGenerator.debug(" process Select In Entity returning Field  param node: " + paramNode2.toString());
                        }
                        object2 = paramNode2.getId();
                        object = paramNode2.getParamClass();
                        if (object == null) {
                            Loggable loggable = EJBLogger.logCouldNotGetClassForParamLoggable((String)this.curFinder.getName(), (String)object2);
                            throw new EJBCException(loggable.getMessage());
                        }
                        String string3 = this.varPrefix() + (String)object2;
                        stringBuffer.append(((Class)object).getName());
                        stringBuffer.append(" ");
                        stringBuffer.append(string3 + " = ");
                        stringBuffer.append(MethodUtils.getMethodName((String)object2) + "();");
                        stringBuffer.append(EOL);
                        this.writePrepStmtSet(stringBuffer, n2, string3, (Class)object, paramNode2.isOracleNLSDataType());
                    }
                    continue;
                }
                object3 = ((ParamNode)object4).getParamName();
                String string4 = this.varPrefix() + (String)object3 + "_PK";
                object2 = ((ParamNode)object4).getPrimaryKeyClass();
                object = ((Class)object2).getName();
                stringBuffer.append((String)object).append(" ").append(string4).append(";");
                stringBuffer.append(EOL);
                stringBuffer.append(string4).append(" = ");
                stringBuffer.append("(").append((String)object).append(")");
                stringBuffer.append((String)object3).append(";");
                stringBuffer.append(EOL);
                if (((ParamNode)object4).hasCompoundKey()) {
                    bl = false;
                    iterator = ((ParamNode)object4).getParamSubList().iterator();
                    while (iterator.hasNext()) {
                        paramNode = (ParamNode)iterator.next();
                        string = this.varPrefix() + (String)object3 + "_PK." + paramNode.getId();
                        clazz = paramNode.getParamClass();
                        this.writePrepStmtSet(stringBuffer, n2, string, clazz, paramNode.isOracleNLSDataType());
                        if (!iterator.hasNext()) continue;
                        ++n2;
                    }
                    continue;
                }
                this.writePrepStmtSet(stringBuffer, n2, string4, (Class)object2, ((ParamNode)object4).isOracleNLSDataType());
                continue;
            }
            if (debugLogger.isDebugEnabled()) {
                RDBMSCodeGenerator.debug(" process param node: " + ((ParamNode)object4).toString());
            }
            this.writePrepStmtSet(stringBuffer, n2, ((ParamNode)object4).getParamName(), ((ParamNode)object4).getParamClass(), ((ParamNode)object4).isOracleNLSDataType());
        }
        return stringBuffer.toString();
    }

    private void writePrepStmtSet(StringBuffer stringBuffer, int n, String string, Class clazz, boolean bl) throws EJBCException {
        if (!clazz.isPrimitive()) {
            this.addNullCheck(stringBuffer, string, ClassUtils.getSQLTypeForClass(clazz), n);
        }
        this.preparedStatementBindingBody(stringBuffer, string, string, clazz, String.valueOf(n), false, false, false, false, bl);
        if (!clazz.isPrimitive()) {
            stringBuffer.append("}" + EOL);
        }
    }

    private void addNullCheck(StringBuffer stringBuffer, String string, String string2, String string3) {
        this.addNullCheck(stringBuffer, string, string2, string3, this.stmtVar());
    }

    private void addNullCheck(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        stringBuffer.append("if(!" + this.pmVar() + ".setParamNull(" + string4 + ", " + string3 + ", " + string + ", " + "\"" + string2 + "\"" + ")) {" + EOL);
    }

    private void addNullCheck(StringBuffer stringBuffer, String string, String string2, int n) {
        this.addNullCheck(stringBuffer, string, string2, n, this.stmtVar());
    }

    private void addNullCheck(StringBuffer stringBuffer, String string, String string2, int n, String string3) {
        stringBuffer.append("if (" + string + " == null) {" + EOL);
        stringBuffer.append(string3 + ".setNull(" + n + "," + string2 + ");" + EOL);
        stringBuffer.append("} else {" + EOL);
    }

    private String getCmpField(String string) {
        return this.getCmpField("this", string);
    }

    private String getCmpField(String string, String string2) {
        if (this.bd.isBeanClassAbstract()) {
            return string + "." + string2;
        }
        return string + "." + "__WL_super_" + MethodUtils.getMethodName(string2) + "()";
    }

    private String setCmpField(String string, String string2) {
        if (this.bd.isBeanClassAbstract()) {
            return "this." + string + " = " + string2;
        }
        return "__WL_super_" + MethodUtils.setMethodName(string) + "(" + string2 + ")";
    }

    public String assignPkFieldsToPkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bd.getPrimaryKeyFieldNames().iterator();
        if (this.bd.hasComplexPrimaryKey()) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(this.pkVar() + "." + string + " = " + this.getCmpField(string) + ";" + EOL);
            }
        } else {
            stringBuffer.append(this.pkVar() + " = " + this.getCmpField((String)iterator.next()) + ";");
        }
        return stringBuffer.toString();
    }

    public String assignPkVarToPkFields() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bd.getPrimaryKeyFieldNames().iterator();
        if (this.bd.hasComplexPrimaryKey()) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(this.setCmpField(string, this.pkVar() + "." + string) + ";" + EOL);
            }
        } else {
            stringBuffer.append(this.setCmpField((String)iterator.next(), this.pkVar()) + ";");
        }
        return stringBuffer.toString();
    }

    public String assignResultVar() throws CodeGenerationException {
        boolean bl;
        assert (this.curFinder != null);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = this.curFinder.isMultiFinder() && (this.curFinder.isSetFinder() || this.curFinder.isSelectDistinct());
        if (this.curFinder.finderLoadsBean()) {
            boolean bl3 = false;
            if (this.curFinder instanceof EjbqlFinder) {
                EjbqlFinder ejbqlFinder = (EjbqlFinder)this.curFinder;
                String string = ejbqlFinder.getGroupName();
                this.curGroup = this.bean.getFieldGroup(string);
                String string2 = ejbqlFinder.getCachingName();
                if (string2 != null) {
                    this.curRelationshipCaching = this.bean.getRelationshipCaching(string2);
                    if (this.curRelationshipCaching != null) {
                        bl3 = this.curRelationshipCaching.getCachingElements().iterator().hasNext();
                    }
                }
            }
            stringBuffer.append(EOL);
            stringBuffer.append("Integer " + this.offsetIntObjVar() + " = new Integer(0);" + EOL);
            stringBuffer.append("Object " + this.pkVar() + " = " + this.getPKFromRSMethodName() + this.getPKFromRSMethodParams() + EOL);
            stringBuffer.append(this.eoVar() + " = null;" + EOL);
            stringBuffer.append("if (" + this.pkVar() + " != null) { " + EOL);
            if (bl3) {
                stringBuffer.append("if (!" + this.pkMapVar() + ".containsKey(" + this.pkVar() + ")) {" + EOL);
            } else if (bl) {
                if (!this.bean.getUseSelectForUpdate()) {
                    stringBuffer.append("if (updateLockType == ").append("DDConstants.UPDATE_LOCK_NONE || ").append("updateLockType == ").append("DDConstants.UPDATE_LOCK_AS_GENERATED || ").append("(!" + this.pkMapVar() + ".containsKey(" + this.pkVar() + "))) {");
                } else {
                    stringBuffer.append("if ").append("(!" + this.pkMapVar() + ".containsKey(" + this.pkVar() + ")) {");
                }
                stringBuffer.append(EOL);
            }
            stringBuffer.append(this.perhapsLoadPKsForQueryCaching());
            stringBuffer.append(this.getBeanFromRS());
            stringBuffer.append(this.eoVar() + " = " + this.pmVar() + ".finderGetEoFromBeanOrPk(" + this.beanVar() + ", " + this.pkVar() + ", __WL_getIsLocal());" + EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") " + this.debugSay() + "(\"bean after finder load: \" + ((__WL_bean == null) ? \"null\" : __WL_bean.hashCode()));" + EOL);
            if (this.curFinder.isMultiFinder()) {
                stringBuffer.append("if( " + this.beanVar() + " == null || ( " + this.beanVar() + " != null &&" + " !" + this.beanVar() + ".__WL_getIsRemoved()))" + EOL);
                stringBuffer.append("{" + EOL);
                if (this.curFinder.isSetFinder()) {
                    stringBuffer.append(this.orderedSetVar() + ".add(" + this.eoVar() + ");" + EOL);
                } else {
                    stringBuffer.append(this.colVar() + ".add(" + this.eoVar() + ");" + EOL);
                }
                stringBuffer.append("}" + EOL);
            }
            stringBuffer.append("Object __WL_retVal = " + this.pkMapVar() + ".put(" + this.pkVar() + ", " + this.beanVar() + ");" + EOL);
            if (bl3) {
                for (String string : this.bean.getCmrFieldNames()) {
                    stringBuffer.append(this.beanVar() + "." + CodeGenUtils.fieldVarName(string) + " = null;" + EOL);
                }
            }
            if (!bl3 && !this.curFinder.isMultiFinder()) {
                stringBuffer.append("if (__WL_retVal!=null) " + this.isMultiVar() + "=true;" + EOL);
            }
            if (bl3) {
                stringBuffer.append("} else {" + EOL);
                stringBuffer.append(this.beanVar() + " = (" + this.getGeneratedBeanClassName() + ") " + this.pkMapVar() + ".get(" + this.pkVar() + ");" + EOL);
                stringBuffer.append(this.eoVar() + " = " + this.pmVar() + ".finderGetEoFromBeanOrPk(" + this.beanVar() + ", " + this.pkVar() + ", __WL_getIsLocal());" + EOL);
                stringBuffer.append("}" + EOL);
            } else if (bl) {
                stringBuffer.append("}").append(EOL);
            }
            if (this.curFinder.isMultiFinder()) {
                stringBuffer.append("} else {").append(EOL);
                stringBuffer.append("if (").append(this.pmVar()).append(".isFindersReturnNulls()) {").append(EOL);
                if (this.curFinder.isSetFinder()) {
                    stringBuffer.append(this.orderedSetVar()).append(".add(null);").append(EOL);
                } else {
                    stringBuffer.append(this.colVar()).append(".add(null);").append(EOL);
                }
                stringBuffer.append("}");
            } else if (!this.curFinder.isFindByPrimaryKey()) {
                stringBuffer.append("} else {").append(EOL);
                stringBuffer.append("if (").append(this.pmVar()).append(".isFindersReturnNulls()) {").append(EOL);
                stringBuffer.append(this.pkMapVar()).append(".put(null, null); ").append(EOL);
                stringBuffer.append("}");
            }
            stringBuffer.append("}").append(EOL).append(EOL);
            if (bl3) {
                stringBuffer.append(this.invokeEagerCachingMethods() + EOL);
            }
            this.curGroup = null;
        } else {
            if (this.bd.hasComplexPrimaryKey()) {
                stringBuffer.append(this.pkVar()).append(" = new ");
                stringBuffer.append(this.pk_class()).append("();").append(EOL);
            }
            this.assignToVars(stringBuffer, this.pkVar(), this.bd.hasComplexPrimaryKey(), this.pkFieldNames, 1, false);
            if (bl) {
                if (!this.bean.getUseSelectForUpdate()) {
                    stringBuffer.append("if (updateLockType == ").append("DDConstants.UPDATE_LOCK_NONE || ").append("updateLockType == ").append("DDConstants.UPDATE_LOCK_AS_GENERATED || ").append("(!" + this.pkMapVar() + ".containsKey(" + this.pkVar() + "))) {");
                } else {
                    stringBuffer.append("if ").append("(!" + this.pkMapVar() + ".containsKey(" + this.pkVar() + ")) {");
                }
            }
            stringBuffer.append(this.perhapsLoadPKsForQueryCaching());
            if (this.curFinder.isMultiFinder()) {
                stringBuffer.append("if (").append(this.rsVar()).append(".wasNull()) {").append(EOL);
                stringBuffer.append("if (").append(this.pmVar()).append(".isFindersReturnNulls()) {").append(EOL);
                stringBuffer.append(this.pkVar()).append(" = null;").append(EOL);
                if (this.curFinder.isSetFinder()) {
                    stringBuffer.append(this.orderedSetVar() + ".add(" + this.pkVar() + ");" + EOL);
                } else {
                    stringBuffer.append(this.colVar() + ".add(" + this.pkVar() + ");").append(EOL);
                }
                stringBuffer.append("}").append(EOL);
                stringBuffer.append("}").append(EOL);
                stringBuffer.append("else {").append(EOL);
                if (this.curFinder.isSetFinder()) {
                    stringBuffer.append(this.orderedSetVar() + ".add(" + this.pkVar() + ");" + EOL);
                } else {
                    stringBuffer.append(this.colVar() + ".add(" + this.pkVar() + ");").append(EOL);
                }
                stringBuffer.append("}").append(EOL);
            } else if (!this.curFinder.isFindByPrimaryKey()) {
                stringBuffer.append("if (").append(this.rsVar()).append(".wasNull()) {").append(EOL);
                stringBuffer.append(this.pkVar()).append(" = null;").append(EOL);
                stringBuffer.append("if (").append(this.pmVar()).append(".isFindersReturnNulls()) {").append(EOL);
                stringBuffer.append(this.pkMapVar()).append(".put(null, null);").append(EOL);
                stringBuffer.append("}").append(EOL);
                stringBuffer.append("}").append(EOL);
            }
            stringBuffer.append("if (" + this.pkVar() + " != null) {");
            stringBuffer.append("Object __WL_retVal = " + this.pkMapVar() + ".put(" + this.pkVar() + ", " + this.pkVar() + ");" + EOL);
            if (!this.curFinder.isMultiFinder()) {
                stringBuffer.append("if (__WL_retVal!=null) " + this.isMultiVar() + "=true;" + EOL);
            }
            stringBuffer.append("}" + EOL);
            if (bl) {
                stringBuffer.append("}").append(EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String invokeLoadGroupMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.loadGroupFromRSMethodName(this.curGroup) + "(" + this.rsVar() + ", " + this.offsetIntObjVar() + ", " + this.pkVar() + ", " + this.beanVar() + ");" + EOL);
        return stringBuffer.toString();
    }

    private String perhapsLoadPKsForQueryCaching() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.shouldImplementQueryCaching(this.curFinder)) {
            stringBuffer.append("// Load PK for query-caching - start").append(EOL);
            stringBuffer.append("QueryCacheElement ").append(this.queryCacheElementVar());
            stringBuffer.append(" = null;").append(EOL);
            stringBuffer.append("if (").append(this.pkVar()).append(" == null && ");
            stringBuffer.append(this.pmVar()).append(".isFindersReturnNulls()) {").append(EOL);
            stringBuffer.append(this.queryCacheElementVar()).append(" = new QueryCacheElement(");
            stringBuffer.append("null);").append(EOL);
            stringBuffer.append("} else if (").append(this.pkVar()).append(" != null) {");
            stringBuffer.append(EOL);
            stringBuffer.append(this.queryCacheElementVar()).append(" = new QueryCacheElement(");
            stringBuffer.append(this.pkVar()).append(", (TTLManager)").append(this.pmVar());
            stringBuffer.append(".getBeanManager());").append(EOL);
            stringBuffer.append("}").append(EOL);
            stringBuffer.append("if (").append(this.queryCacheElementVar()).append(" != null) {");
            stringBuffer.append(EOL);
            if (this.curFinder.isMultiFinder()) {
                stringBuffer.append(this.queryCacheElementsVar()).append(".add(");
                stringBuffer.append(this.queryCacheElementVar()).append(");").append(EOL);
            } else {
                stringBuffer.append(this.queryCacheElementsVar()).append(" = ");
                stringBuffer.append(this.queryCacheElementVar()).append(";").append(EOL);
            }
            stringBuffer.append("}").append(EOL);
            stringBuffer.append("// Load PK for query-caching - end").append(EOL);
        }
        return stringBuffer.toString();
    }

    private Class getVariableClass(String string) {
        return (Class)this.variableToClass.get(string);
    }

    private String checkFieldNotModifiedOrLoaded(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("if (!(" + string + "." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string2) + "]");
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(" || " + string + "." + this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(string2) + "]");
        }
        stringBuffer.append(")) {" + EOL);
        return stringBuffer.toString();
    }

    private void assignToVars(StringBuffer stringBuffer, String string, boolean bl, List list, int n, boolean bl2) throws CodeGenerationException {
        Iterator iterator = list.iterator();
        int n2 = list.size();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            Class<Character> clazz = this.getVariableClass(string3);
            boolean bl3 = bl2 && !this.bd.isBeanClassAbstract() && this.bean.hasCmpField(string3);
            String string4 = null;
            string4 = bl ? string + "." + string3 : string;
            boolean bl4 = this.bean.isCharArrayMappedToString(clazz);
            if (bl4) {
                clazz = Character.TYPE;
            }
            String string5 = this.getFromResultSet(n, clazz, this.bean.getCmpColumnTypeForField(string3));
            if (bl2) {
                stringBuffer.append(this.checkFieldNotModifiedOrLoaded(string, (String)this.variableToField.get(string3)));
            }
            if (!(!this.bean.hasCmpColumnType(string3) || "SybaseBinary".equals(this.bean.getCmpColumnTypeForField(string3)) || "LongString".equals(this.bean.getCmpColumnTypeForField(string3)) || "NChar".equals(this.bean.getCmpColumnTypeForField(string3)) || "NVarchar2".equals(this.bean.getCmpColumnTypeForField(string3)) || "SQLXML".equals(this.bean.getCmpColumnTypeForField(string3)))) {
                if (!this.bean.isBlobCmpColumnTypeForField(string3) && !this.bean.isClobCmpColumnTypeForField(string3)) {
                    throw new AssertionError((Object)("Unrecognized Cmp Column Type " + this.bean.getCmpColumnTypeForField(string3) + " for field " + string3));
                }
                this.curField = string3;
                stringBuffer.append("\n" + this.setBlobClobForInputMethodName() + "(" + this.rsVar() + "," + string + ");");
                if (bl2) {
                    stringBuffer.append("}" + EOL);
                }
                ++n;
                continue;
            }
            boolean bl5 = false;
            if (this.bean.hasCmpColumnType(string3) && "SQLXML".equals(this.bean.getCmpColumnTypeForField(string3))) {
                if (clazz == String.class) {
                    bl5 = true;
                } else {
                    throw new CodeGenerationException("only String can be mapped into SQLXML : " + string3);
                }
            }
            if (!this.bean.isValidSQLType(clazz)) {
                stringBuffer.append("byte[] byteArray = " + string5 + ";" + EOL);
                stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
                stringBuffer.append(this.debugSay() + "(\"returned bytes\" + byteArray " + ");" + EOL);
                stringBuffer.append("if (byteArray!=null) {" + EOL);
                stringBuffer.append(this.debugSay() + "(\"length- \" + byteArray.length);" + EOL);
                stringBuffer.append("}" + EOL);
                stringBuffer.append("}" + EOL);
                stringBuffer.append("if (byteArray==null || byteArray.length==0) { " + EOL);
                this.doSimpleAssignment(stringBuffer, string4, string3, "null", bl3);
                if (bl2 && this.bd.isOptimistic() && this.doSnapshot(string3)) {
                    stringBuffer.append(string + "." + CodeGenUtils.snapshotNameForVar(string3) + " = null;" + EOL);
                }
                stringBuffer.append("}" + EOL);
                string2 = "(" + this.javaCodeForType(clazz) + ")";
                stringBuffer.append("else { " + EOL);
                if (bl2 && this.bd.isOptimistic() && this.doSnapshot(string3)) {
                    stringBuffer.append(string + "." + CodeGenUtils.snapshotNameForVar(string3) + " = byteArray;" + EOL);
                }
                stringBuffer.append("ByteArrayInputStream bstr = new java.io.ByteArrayInputStream(byteArray);" + EOL);
                stringBuffer.append("RDBMSObjectInputStream ostr = new RDBMSObjectInputStream(bstr, " + this.classLoaderVar() + ");" + EOL);
                if (EJBHome.class.isAssignableFrom(clazz)) {
                    stringBuffer.append("HomeHandle handle = (HomeHandle)ostr.readObject();" + EOL);
                    this.doSimpleAssignment(stringBuffer, string4, string3, string2 + "handle.getEJBHome();", bl3);
                } else if (EJBObject.class.isAssignableFrom(clazz)) {
                    stringBuffer.append("Handle handle = (Handle)ostr.readObject();" + EOL);
                    this.doSimpleAssignment(stringBuffer, string4, string3, string2 + "handle.getEJBObject();", bl3);
                } else {
                    this.doSimpleAssignment(stringBuffer, string4, string3, string2 + "ostr.readObject();", bl3);
                }
                stringBuffer.append("}" + EOL);
            } else {
                String string6;
                string2 = this.resultSetToVariable(n, clazz, this.bean.getCmpColumnTypeForField(string3));
                if (bl4) {
                    stringBuffer.append("String " + this.stringVar(n) + " = " + string2 + ";" + EOL);
                    stringBuffer.append("if (" + this.stringVar(n) + "==null ) { " + EOL);
                    this.doSimpleAssignment(stringBuffer, string4, string3, "null", bl3);
                    stringBuffer.append("}" + EOL);
                    stringBuffer.append("else { " + EOL);
                    stringBuffer.append(this.trimStringTypedValue(this.stringVar(n)));
                    this.doSimpleAssignment(stringBuffer, string4, string3, this.stringVar(n) + ".toCharArray();", bl3);
                    stringBuffer.append("}" + EOL);
                } else if (clazz == Character.class || clazz == Character.TYPE) {
                    stringBuffer.append("String " + this.stringVar(n) + " = " + string2 + ";" + EOL);
                    stringBuffer.append("if (" + this.stringVar(n) + "==null || " + this.stringVar(n) + ".length()==0) { " + EOL);
                    this.doSimpleAssignment(stringBuffer, string4, string3, ClassUtils.getDefaultValue(clazz), bl3);
                    stringBuffer.append("}" + EOL);
                    stringBuffer.append("else { " + EOL);
                    if (clazz == Character.class) {
                        this.doSimpleAssignment(stringBuffer, string4, string3, "new Character(" + this.stringVar(n) + ".charAt(0))", bl3);
                    } else {
                        this.doSimpleAssignment(stringBuffer, string4, string3, this.stringVar(n) + ".charAt(0);", bl3);
                    }
                    stringBuffer.append("}" + EOL);
                } else if (clazz == java.util.Date.class) {
                    stringBuffer.append("java.sql.Timestamp " + this.sqlTimestampVar(n) + " = " + string2 + ";" + EOL);
                    stringBuffer.append("if (" + this.sqlTimestampVar(n) + "==null) { " + EOL);
                    this.doSimpleAssignment(stringBuffer, string4, string3, ClassUtils.getDefaultValue(clazz), bl3);
                    stringBuffer.append("}" + EOL);
                    stringBuffer.append("else { " + EOL);
                    this.doSimpleAssignment(stringBuffer, string4, string3, "new java.util.Date(" + this.sqlTimestampVar(n) + ".getTime())", bl3);
                    stringBuffer.append("}" + EOL);
                } else if (clazz == String.class) {
                    string6 = null;
                    if (bl3) {
                        string6 = this.stringVar(n);
                        stringBuffer.append("String ");
                    } else {
                        string6 = string4;
                    }
                    if (bl5) {
                        string2 = string2 + " != null ? " + string2 + ".getString() : null";
                    }
                    stringBuffer.append(string6 + " = " + string2 + ";" + EOL);
                    stringBuffer.append("if(");
                    stringBuffer.append(string6);
                    stringBuffer.append(" != null) {");
                    stringBuffer.append(EOL);
                    stringBuffer.append(this.trimStringTypedValue(string6));
                    stringBuffer.append("}");
                    stringBuffer.append(EOL);
                    if (bl3) {
                        stringBuffer.append(MethodUtils.setMethodName(string3) + "(" + string6 + ");" + EOL);
                    }
                } else if (clazz == BigDecimal.class || clazz == Date.class || clazz == Timestamp.class) {
                    string6 = null;
                    if (bl3) {
                        string6 = this.tempVar(n);
                        stringBuffer.append(clazz.getName()).append(" ");
                    } else {
                        string6 = string4;
                    }
                    stringBuffer.append(string6 + " = " + string2 + ";" + EOL);
                    if (bl3) {
                        stringBuffer.append(MethodUtils.setMethodName(string3) + "(" + string6 + ");" + EOL);
                    }
                } else {
                    this.doAssignment(stringBuffer, string4, n, string3, clazz, string2, bl3);
                }
                if (bl2 && this.bd.isOptimistic() && this.doSnapshot(string3)) {
                    stringBuffer.append(this.takeSnapshotForVar(string, string3, bl3));
                }
            }
            if (bl2) {
                stringBuffer.append("}" + EOL);
                stringBuffer.append("else {" + EOL);
                stringBuffer.append(string5 + ";" + EOL);
                stringBuffer.append("}" + EOL);
            }
            ++n;
        }
    }

    private void doAssignment(StringBuffer stringBuffer, String string, int n, String string2, Class clazz, String string3, boolean bl) {
        if (bl) {
            if (clazz.isPrimitive()) {
                stringBuffer.append("__WL_super_");
                stringBuffer.append(MethodUtils.setMethodName(string2) + "(" + string3 + ");" + EOL);
            } else {
                stringBuffer.append(this.javaCodeForType(clazz) + " " + this.tempVar(n) + " = " + string3 + ";" + EOL);
                stringBuffer.append("if (" + this.rsVar() + ".wasNull()) { " + EOL);
                stringBuffer.append("__WL_super_");
                stringBuffer.append(MethodUtils.setMethodName(string2) + "(null);" + EOL);
                stringBuffer.append("} else {" + EOL);
                stringBuffer.append("__WL_super_");
                stringBuffer.append(MethodUtils.setMethodName(string2) + "(" + this.tempVar(n) + ");" + EOL);
                stringBuffer.append("}" + EOL);
            }
        } else {
            stringBuffer.append(string + " = " + string3 + ";" + EOL);
            if (!clazz.isPrimitive()) {
                stringBuffer.append("if (" + this.rsVar() + ".wasNull()) { " + EOL);
                stringBuffer.append(string + " = null;" + EOL);
                stringBuffer.append("}" + EOL);
            }
        }
    }

    private void doSimpleAssignment(StringBuffer stringBuffer, String string, String string2, String string3, boolean bl) {
        if (bl) {
            stringBuffer.append("__WL_super_");
            stringBuffer.append(MethodUtils.setMethodName(string2) + "(" + string3 + ");" + EOL);
        } else {
            stringBuffer.append(string + " = " + string3 + ";" + EOL);
        }
    }

    private String resultSetToVariable(int n, Class clazz, String string) {
        String string2 = "";
        String string3 = this.getFromResultSet(n, clazz, string);
        if (clazz == Boolean.class) {
            return "new Boolean(" + string3 + ")";
        }
        if (clazz == Byte.class) {
            return "new Byte(" + string3 + ")";
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return "(java.lang.String)" + string3;
        }
        if (clazz == Double.class) {
            return "new Double(" + string3 + ")";
        }
        if (clazz == Float.class) {
            return "new Float(" + string3 + ")";
        }
        if (clazz == Integer.class) {
            return "new Integer(" + string3 + ")";
        }
        if (clazz == Long.class) {
            return "new Long(" + string3 + ")";
        }
        if (clazz == Short.class) {
            return "new Short(" + string3 + ")";
        }
        if (clazz == java.util.Date.class) {
            string2 = "(java.sql.Timestamp)";
            return string2 + string3;
        }
        return string2 + string3;
    }

    private String getFromResultSet(int n, Class clazz, String string) {
        String string2 = string != null && "SQLXML".equals(string) ? "SQLXML" : MethodUtils.getResultSetMethodPostfix(clazz);
        String string3 = this.rsVar() + ".get" + string2 + "(" + n + "+" + this.offsetVar() + ")";
        return string3;
    }

    public String indexForTable() {
        return String.valueOf(this.bean.tableIndex(this.curTable));
    }

    public String updateBeanColumnsSqlForTable(String string) {
        List list = this.bean.getNonPKFields(this.bean.tableIndex(string));
        assert (list != null);
        String[] stringArray = list.toArray(new String[0]);
        return this.attrsAsColumnsAsParamsForTable(string, stringArray, ", ");
    }

    public String idParamsSqlForCurTable() {
        return this.idParamsSqlForTable(this.curTableName);
    }

    public String idParamsSqlForTable(String string) {
        String[] stringArray = this.pkFieldNames.toArray(new String[0]);
        return this.attrsAsColumnsAsParamsForTable(string, stringArray, " AND ");
    }

    public String idParamsSql() {
        String[] stringArray = this.pkFieldNames.toArray(new String[0]);
        assert (stringArray != null);
        return this.attrsAsColumnsAsParams(stringArray, " AND ");
    }

    public String idColumnsSql() {
        String[] stringArray = this.pkFieldNames.toArray(new String[0]);
        assert (stringArray != null);
        return StringUtils.join((String[])stringArray, (String)", ");
    }

    private List getAllVarNames() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.cmpFieldNames);
        for (String string : this.bean.getForeignKeyFieldNames()) {
            if (!this.bean.containsFkField(string)) continue;
            arrayList.addAll(this.foreignKeyVarNames(string));
        }
        return arrayList;
    }

    public String groupSqlNonFinder() throws CodeGenerationException {
        try {
            return EjbqlFinder.generateGroupSQLNonFinder(this.bean, this.curGroup.getName(), 0);
        }
        catch (Exception exception) {
            throw new CodeGenerationException("Internal Error while attempting to generate an Internal Finder for FieldGroup: '" + this.curGroup.getName());
        }
    }

    public String groupSqlNonFinderPerhapsForUpdate() throws CodeGenerationException {
        if (this.bean.getUseSelectForUpdate()) {
            return this.groupSqlNonFinderForUpdate();
        }
        return this.groupSqlNonFinder();
    }

    public String groupSqlNonFinderForUpdate() throws CodeGenerationException {
        try {
            return EjbqlFinder.generateGroupSQLNonFinder(this.bean, this.curGroup.getName(), 1);
        }
        catch (Exception exception) {
            throw new CodeGenerationException("Internal Error while attempting to generate an Internal Finder for FieldGroup: '" + this.curGroup.getName());
        }
    }

    public String groupSqlNonFinderForUpdateNoWait() throws CodeGenerationException {
        try {
            return EjbqlFinder.generateGroupSQLNonFinder(this.bean, this.curGroup.getName(), 2);
        }
        catch (Exception exception) {
            throw new CodeGenerationException("Internal Error while attempting to generate an Internal Finder for FieldGroup: '" + this.curGroup.getName());
        }
    }

    public String groupColumnsSql() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : this.curGroup.getCmpFields()) {
            String string = RDBMSUtils.escQuotedID(this.bean.getCmpColumnForField((String)object));
            assert (string != null);
            stringBuffer.append(string);
            stringBuffer.append(", ");
        }
        for (String string : this.curGroup.getCmrFields()) {
            if (this.bean.isForeignCmpField(string)) continue;
            for (String string2 : this.bean.getForeignKeyColNames(string)) {
                stringBuffer.append(RDBMSUtils.escQuotedID(string2));
                stringBuffer.append(", ");
            }
        }
        if (stringBuffer.length() > 1) {
            stringBuffer.setCharAt(stringBuffer.length() - 2, ' ');
        }
        return stringBuffer.toString();
    }

    public int groupColumnCount() {
        int n = 0;
        Iterator iterator = this.curGroup.getCmpFields().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        for (String string : this.curGroup.getCmrFields()) {
            if (this.bean.isForeignCmpField(string)) continue;
            Iterator iterator2 = this.bean.getForeignKeyColNames(string).iterator();
            while (iterator2.hasNext()) {
                iterator2.next();
                ++n;
            }
        }
        return n;
    }

    public String createColumnsQMs() {
        String[] stringArray = this.cmpFieldNames.toArray(new String[0]);
        int n = stringArray.length;
        if (this.bean.genKeyExcludePKColumn()) {
            --n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            stringBuffer.append(this.getInsertQuoteStringForField(string));
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        for (String string : this.bean.getForeignKeyFieldNames()) {
            if (!this.bean.containsFkField(string) || this.bean.isForeignCmpField(string)) continue;
            Iterator iterator = this.bean.getForeignKeyColNames(string).iterator();
            stringBuffer.append(", ");
            while (iterator.hasNext()) {
                stringBuffer.append("?");
                iterator.next();
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public String copyKeyValuesToPkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        String[] stringArray = this.pkFieldNames.toArray(new String[0]);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (ClassUtils.isObjectPrimitive(this.bd.getPrimaryKeyClass())) {
                assert (i == 0) : "Too many fields for an object primitive PK class";
                Class clazz = this.bean.getCmpFieldClass(stringArray[i]);
                stringBuffer.append(this.pkVar());
                stringBuffer.append(" = ");
                stringBuffer.append(this.getCmpField(stringArray[i])).append(";");
            } else {
                if (this.bd.hasComplexPrimaryKey()) {
                    stringBuffer.append(this.pkVar()).append(".").append(string);
                } else {
                    stringBuffer.append(this.pkVar());
                }
                stringBuffer.append(" = ").append(this.getCmpField(string)).append(";");
            }
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String copyBeanToComplexFk_forField() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.bean.getTableForCmrField(this.curField);
        for (String string2 : this.bean.getForeignKeyColNames(this.curField)) {
            String string3 = this.bean.getRelatedPkFieldName(this.curField, string2);
            stringBuffer.append(this.fkVar()).append(".").append(string3);
            stringBuffer.append(" = ").append("this").append(".").append(this.bean.variableForField(this.curField, string, string2)).append(";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhaps_include_result_set_to_collection() throws CodeGenerationException {
        Serializable serializable;
        boolean bl = true;
        try {
            serializable = Class.forName("java.util.Collection");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        serializable = new StringBuffer();
        if (bl) {
            ((StringBuffer)serializable).append(this.parse(this.getProductionRule("resultSetToCollection")));
        }
        return ((StringBuffer)serializable).toString();
    }

    public String perhapsImplementWLStoreMethodBody() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(this.parse(this.getProductionRule("implementWLStoreMethodBody")));
        } else {
            stringBuffer.append("throw new AssertionError(\"internal error: ejbStore called ");
            stringBuffer.append("for bean '");
            stringBuffer.append(this.bd.getEJBName());
            stringBuffer.append("' which uses ReadOnly concurrency.\");");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String wlStoreToTables() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.bean.tableCount()) {
            this.curTableIndex = n++;
            this.curTableName = this.bean.tableAt(this.curTableIndex);
            stringBuffer.append(this.parse(this.getProductionRule("implementStoreTable")));
        }
        return stringBuffer.toString();
    }

    public String needsStoreOptimisticField() {
        return this.useVersionOrTimestampCheckingForBlobClob(this.curTableName) ? "true" : "false";
    }

    public String iVarIsNotPK() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  if (! (");
        Iterator iterator = this.bean.getIsModifiedIndices_PK().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            stringBuffer.append(this.iVar()).append(" == ").append(n.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" || ");
        }
        stringBuffer.append(" ) )  ").append("//  ").append(this.iVar()).append(" does not point to a PK field").append(EOL);
        return stringBuffer.toString();
    }

    public String perhapsIVarContinueOnTableCheck() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.iVarIsNotPK());
        stringBuffer.append("            if (").append(this.isModifiedToTableMethodName()).append("(").append(this.iVar()).append(") != ");
        stringBuffer.append(this.curTableIndex).append(")").append(EOL);
        stringBuffer.append("              continue;  // this Field's Column is not in the current Table").append(EOL).append(EOL);
        return stringBuffer.toString();
    }

    public String isModifiedIndexToField(int n) {
        return this.bean.getFieldName(new Integer(n));
    }

    public String isModifiedToTableMethodName() {
        return "isModifiedToTableIndex";
    }

    public String isModifiedToTableMethod() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int ").append(this.isModifiedToTableMethodName()).append("(int isModifiedIndex) {").append(EOL);
        stringBuffer.append("    switch (isModifiedIndex) {").append(EOL);
        Iterator iterator = this.bean.getIsModifiedIndexToTableNumber().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            stringBuffer.append("     case ").append(Integer.toString(n)).append(EOL);
            stringBuffer.append("       return ").append(n2.toString()).append(";").append(EOL).append(EOL);
            ++n;
        }
        stringBuffer.append("      default:").append(EOL);
        stringBuffer.append("        throw new RuntimeException(");
        stringBuffer.append("\" Internal Error attempt to call " + this.isModifiedToTableMethodName() + ", with isModifiedIndex = \"+").append(EOL);
        stringBuffer.append("           \" '\"+isModifiedIndex+\"', this exceeds the expected size limit: '" + this.bean.getFieldNameToIsModifiedIndex().size() + "'. \"); ").append(EOL);
        stringBuffer.append("    }").append(EOL);
        stringBuffer.append("  }").append(EOL);
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String constructModifiedFieldStoreColumnStrings() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        stringBuffer.append("sb.setLength(0);" + EOL);
        List list = this.bean.getForeignKeyFieldNames();
        for (int i = 0; i < this.bean.getFieldCount(); ++i) {
            Object object2;
            if (this.bean.getIsModifiedIndices_PK().contains(new Integer(i))) continue;
            Integer n = this.bean.getTableNumber(i);
            Debug.assertion((n != null ? 1 : 0) != 0);
            int n2 = n;
            if (n2 != this.curTableIndex) continue;
            String string = this.isModifiedIndexToField(i);
            Debug.assertion((string != null ? 1 : 0) != 0);
            StringBuffer stringBuffer2 = new StringBuffer();
            String string2 = "";
            boolean bl = false;
            if (this.bean.isCmpFieldName(string)) {
                String string3 = this.bean.getColumnForCmpFieldAndTable(string, this.curTableName);
                if (this.bean.hasOptimisticColumn(this.curTableName) && this.bean.getOptimisticColumn(this.curTableName).equals(string3)) {
                    bl = true;
                } else {
                    if (list != null) {
                        object2 = null;
                        for (Object object2 : list) {
                            if (!this.bean.getForeignKeyColNames((String)object2).contains(string3)) continue;
                            string2 = this.perhapsIsFkColsNullableCheck((String)object2);
                            break;
                        }
                    }
                    stringBuffer2.append(string3 + " = ? ");
                }
            } else {
                Debug.assertion((boolean)this.bean.isForeignKeyField(string));
                if (this.bean.containsFkField(string) && !this.bean.isForeignCmpField(string)) {
                    string2 = this.perhapsIsFkColsNullableCheck(string);
                    object2 = this.bean.getForeignKeyColNames(string).iterator();
                    while (object2.hasNext()) {
                        String string4 = (String)object2.next();
                        stringBuffer2.append((String)string4 + " = ? ");
                        if (!object2.hasNext()) continue;
                        stringBuffer2.append(", ");
                    }
                }
            }
            if (bl) continue;
            stringBuffer.append("if (" + this.isModifiedVar() + "[" + i + "]" + string2 + ")  {" + EOL);
            if (this.bean.isBlobCmpColumnTypeForField(string) || this.bean.isClobCmpColumnTypeForField(string)) {
                stringBuffer.append(this.blobClobCountVar() + "++;" + EOL);
            } else {
                stringBuffer.append("if (" + this.countVar() + " > 0) sb.append(\", \");" + EOL);
                stringBuffer.append("sb.append(\"" + stringBuffer2.toString() + "\");" + EOL);
                stringBuffer.append(this.countVar() + "++;" + EOL);
            }
            stringBuffer.append("}" + EOL + EOL);
        }
        return stringBuffer.toString();
    }

    public String implementStoreUtilities() {
        String[] stringArray = this.cmpFieldNames.toArray(new String[0]);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("private void setParam" + stringArray[i]);
            stringBuffer.append("(PreparedStatement " + this.stmtVar() + ", ");
            stringBuffer.append("int " + this.numVar() + ", ");
            stringBuffer.append(this.bean.getCmpFieldClass(stringArray[i]).getName() + " ");
            stringBuffer.append(stringArray[i] + ") {" + EOL);
            this.addPreparedStatementBinding(stringBuffer, stringArray[i], stringArray[i], this.numVar(), true, false, false, false);
            stringBuffer.append(EOL);
            stringBuffer.append("}" + EOL + EOL);
        }
        return stringBuffer.toString();
    }

    public String createUpdateFailureMsg() {
        StringBuffer stringBuffer = new StringBuffer("Failed to CREATE Bean.");
        if (this.bean.hasAutoKeyGeneration() && !this.bean.getGenKeyBeforeInsert()) {
            return stringBuffer.toString();
        }
        stringBuffer.append("  Primary Key Value: '\" + ").append(this.pkVar()).append(" + \"'");
        return stringBuffer.toString();
    }

    public String createExceptionCheckForDuplicateKey() throws CodeGenerationException {
        if (this.bean.hasAutoKeyGeneration() && !this.bean.getGenKeyBeforeInsert()) {
            return "throw se;   // not possible for there to be duplicate key with DBMS Identity Column, skip dup key check.";
        }
        return this.parse(this.getProductionRule("createMethodDuplicateKeyCheck"));
    }

    public String implementLoadIndexedGroupFromRSMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (FieldGroup this.curGroup : this.bean.getFieldGroups()) {
            stringBuffer.append("case " + this.curGroup.getIndex() + ": " + this.loadGroupFromRSMethodName(this.curGroup) + "(rs, offset, " + this.pkVar() + ", (" + this.getGeneratedBeanClassName() + ")eb); break;" + EOL);
        }
        stringBuffer.append("default: throw new AssertionError(\"Bad Group index: \"+index);" + EOL);
        return stringBuffer.toString();
    }

    public String implementLoadGroupFromRSMethods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (FieldGroup this.curGroup : this.bean.getFieldGroups()) {
            stringBuffer.append(EOL);
            stringBuffer.append("// loadGroup from ResultSet to bean method for the '" + this.curGroup.getName() + "' group." + EOL);
            stringBuffer.append("public void " + this.loadGroupFromRSMethodName(this.curGroup) + EOL + "(java.sql.ResultSet " + this.rsVar() + ", " + EOL + "java.lang.Integer " + this.offsetIntObjVar() + ", " + EOL + "Object " + this.pkVar() + "," + EOL + this.getGeneratedBeanInterfaceName() + " beanIntf)" + EOL);
            stringBuffer.append("throws java.sql.SQLException, java.lang.Exception" + EOL);
            stringBuffer.append("{" + EOL);
            stringBuffer.append(this.getGeneratedBeanClassName());
            stringBuffer.append(" ");
            stringBuffer.append(this.beanVar());
            stringBuffer.append(" = (");
            stringBuffer.append(this.getGeneratedBeanClassName());
            stringBuffer.append(")beanIntf;");
            stringBuffer.append(EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"" + this.loadGroupFromRSMethodName(this.curGroup) + "\");" + EOL);
            stringBuffer.append("}" + EOL + EOL);
            stringBuffer.append(this.assignOffsetVar() + EOL);
            stringBuffer.append(this.assignGroupColumnsToBean() + EOL);
            stringBuffer.append(this.beanIsLoadedVar() + " = true;" + EOL);
            stringBuffer.append(this.perhapsSetTableLoadedVarsForGroup());
            stringBuffer.append("}" + EOL);
        }
        return stringBuffer.toString();
    }

    public String implementLoadCMRFieldFromRSMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getAllCmrFields()) {
            stringBuffer.append("if (\"" + string + "\".equalsIgnoreCase(cmrField)) " + this.loadCMRFieldFromRSMethodName(string) + "(rs, offset,(" + this.getGeneratedBeanClassName() + ")eb);" + EOL);
        }
        return stringBuffer.toString();
    }

    public String implementLoadCMRFieldFromRSMethods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.bean.getAllCmrFields()) {
            stringBuffer.append(EOL);
            stringBuffer.append("public void " + this.loadCMRFieldFromRSMethodName(string) + EOL + "(java.sql.ResultSet " + this.rsVar() + ", " + EOL + "java.lang.Integer " + this.offsetIntObjVar() + ", " + EOL + this.getGeneratedBeanInterfaceName() + " beanIntf) " + EOL);
            stringBuffer.append("throws java.sql.SQLException, java.lang.Exception" + EOL);
            stringBuffer.append("{" + EOL);
            stringBuffer.append(this.getGeneratedBeanClassName());
            stringBuffer.append(" ");
            stringBuffer.append(this.beanVar());
            stringBuffer.append(" = (");
            stringBuffer.append(this.getGeneratedBeanClassName());
            stringBuffer.append(")beanIntf;");
            stringBuffer.append(EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"" + this.loadCMRFieldFromRSMethodName(string) + "\");" + EOL);
            stringBuffer.append("}" + EOL + EOL);
            stringBuffer.append(this.assignOffsetVar() + EOL);
            RDBMSBean rDBMSBean = this.bean.getRelatedRDBMSBean(string);
            String string2 = this.bean.getRelatedFieldName(string);
            if (this.lhsBeanHasFKForLocal11or1NPath(rDBMSBean, string2)) {
                stringBuffer.append(this.assignCMRFieldPKColumns(this.beanVar()) + EOL);
            } else {
                stringBuffer.append(this.assignCMRFieldFKColumns(this.beanVar(), string) + EOL);
            }
            stringBuffer.append("}" + EOL);
        }
        return stringBuffer.toString();
    }

    public String assignRSToPkVar() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList(this.bd.getPrimaryKeyFieldNames());
        if (this.bd.hasComplexPrimaryKey()) {
            this.assignToVars(stringBuffer, this.pkVar(), true, arrayList, 1, false);
        } else {
            this.assignToVars(stringBuffer, this.pkVar(), false, arrayList, 1, false);
        }
        return stringBuffer.toString();
    }

    public String genIsPKNull() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bd.hasComplexPrimaryKey()) {
            for (String string : this.bd.getPrimaryKeyFieldNames()) {
                Class clazz = this.getVariableClass(string);
                if (clazz.isPrimitive()) continue;
                stringBuffer.append("if (" + this.pkVar() + "." + string + " == null) return null;" + EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String invokeEagerCachingMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int increment = " + this.getGroupColumnCount(this.bean, this.curGroup.getName()) + ";" + EOL);
        Iterator iterator = this.curRelationshipCaching.getCachingElements().iterator();
        this.invokeEagerCachingMethodsForCachingElements(this.bean, iterator, null, stringBuffer, false);
        return stringBuffer.toString();
    }

    public void invokeEagerCachingMethodsForCachingElements(RDBMSBean rDBMSBean, Iterator iterator, String string, StringBuffer stringBuffer, boolean bl) {
        while (iterator.hasNext()) {
            String string2;
            Iterator iterator2;
            RelationshipCaching.CachingElement cachingElement = (RelationshipCaching.CachingElement)iterator.next();
            String string3 = cachingElement.getCmrField();
            String string4 = cachingElement.getGroupName();
            this.setCurrCachingElementCmrField(string3);
            RDBMSBean rDBMSBean2 = rDBMSBean.getRelatedRDBMSBean(string3);
            String string5 = this.bmVar((String)this.declaredManagerVars.get(rDBMSBean2.getEjbName()));
            CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean2.getEjbName());
            String string6 = cMPBeanDescriptor.getGeneratedBeanInterfaceName();
            stringBuffer.append("// load " + string3 + " bean from RS" + EOL);
            stringBuffer.append(this.offsetIntObjVar() + " = new Integer(increment" + ");" + EOL);
            stringBuffer.append("Object " + this.cmrFieldPKVar(string) + " = " + this.cmrFieldBeanVar() + "_pooledBean." + this.getPKFromRSMethodName() + "Instance" + this.getPKFromRSMethodParams() + EOL);
            stringBuffer.append(string6 + " " + this.cmrFieldBeanVar() + " = null;" + EOL);
            stringBuffer.append(this.eoRCVar() + " = null;" + EOL);
            stringBuffer.append("if (" + this.cmrFieldPKVar(string) + " != null) {" + EOL);
            stringBuffer.append("if (!" + this.cmrFieldPKMapVar(string) + ".containsKey(" + this.cmrFieldPKVar(string) + ")) {" + EOL);
            String string7 = rDBMSBean.getRelatedFieldName(string3);
            int n = this.getGroupColumnCount(rDBMSBean2, string4);
            stringBuffer.append("RSInfo " + this.rsInfoVar() + " = new RSInfoImpl(" + this.rsVar() + ", " + this.loadGroupFromRSIndex(rDBMSBean2, string4) + ", " + "increment, \"" + string7 + "\", " + "increment + " + n + ", " + this.cmrFieldPKVar(string) + ");" + EOL);
            stringBuffer.append(this.cmrFieldBeanVar() + " = (" + string6 + ") " + string5 + ".getBeanFromRS(" + this.cmrFieldPKVar(string) + ", " + this.rsInfoVar() + ");" + EOL);
            int n2 = n;
            if (debugLogger.isDebugEnabled()) {
                RDBMSCodeGenerator.debug(rDBMSBean.getEjbName() + " is relationship caching " + rDBMSBean2.getEjbName() + " through cmrField " + string3 + ", " + rDBMSBean2.getEjbName() + " has cmrField " + string7);
            }
            n2 = this.lhsBeanHasFKForLocal11or1NPath(rDBMSBean, string3) ? (n2 += rDBMSBean.getForeignKeyColNames(string3).size()) : (n2 += rDBMSBean2.getForeignKeyColNames(string7).size());
            stringBuffer.append(this.cmrFieldPKMapVar(string) + ".put(" + this.cmrFieldPKVar(string) + ", " + this.cmrFieldBeanVar() + ");" + EOL);
            stringBuffer.append(this.eoRCVar() + " = " + string5 + ".finderGetEoFromBeanOrPk((javax.ejb.EntityBean)" + this.cmrFieldBeanVar() + ", " + this.cmrFieldPKVar(string) + ", true);" + EOL);
            String string8 = "";
            if (string != null) {
                int n3 = string.lastIndexOf("_");
                string8 = n3 == -1 ? string : string.substring(n3 + 1);
            }
            stringBuffer.append("// set *_isLoaded_ flag even when " + this.eoRCVar() + " is null" + EOL);
            stringBuffer.append("if (" + this.cmrFieldBeanVar(string8) + " != null) {" + EOL);
            stringBuffer.append(this.cmrFieldBeanVar(string8) + "." + CodeGenUtils.cacheRelationshipMethodName(string3) + "(" + this.eoRCVar() + ");" + EOL);
            if (bl) {
                if (!rDBMSBean.isQueryCachingEnabledForCMRField(string3)) {
                    stringBuffer.append("if (qcHandler.isQueryCachingEnabledForFinder()) {");
                    stringBuffer.append(EOL);
                }
                String string9 = this.generateCMRFieldFinderMethodName(string3);
                stringBuffer.append("TTLManager roMgr = (TTLManager)");
                stringBuffer.append(string5).append(";").append(EOL);
                iterator2 = rDBMSBean.getCmrFieldClass(string3);
                stringBuffer.append("QueryCacheKey qckey = new QueryCacheKey(\"");
                stringBuffer.append(string9).append("\", new Object[]{");
                stringBuffer.append("__WL_getPrimaryKey()").append("}, roMgr, ");
                if (Set.class.isAssignableFrom((Class<?>)((Object)iterator2))) {
                    stringBuffer.append("QueryCacheKey.RET_TYPE_SET);").append(EOL);
                } else {
                    stringBuffer.append("QueryCacheKey.RET_TYPE_SINGLETON);").append(EOL);
                }
                stringBuffer.append("QueryCacheElement qce = new QueryCacheElement(");
                stringBuffer.append("((CMPBean)").append(this.cmrFieldBeanVar());
                stringBuffer.append(").__WL_getPrimaryKey(), roMgr);").append(EOL);
                stringBuffer.append("qcHandler.addQueryCachingEntry(roMgr, qckey, qce);");
                stringBuffer.append(EOL);
                if (!rDBMSBean.isQueryCachingEnabledForCMRField(string3)) {
                    stringBuffer.append("}").append(EOL);
                }
            } else if (rDBMSBean.isQueryCachingEnabledForCMRField(string3) || this.shouldImplementQueryCaching(this.curFinder)) {
                this.currFinderLoadsQueryCachingEnabledCMRFields = true;
                stringBuffer.append("if (").append(this.beanMapVar()).append(" == null) {");
                stringBuffer.append(EOL);
                stringBuffer.append(this.beanMapVar()).append(" = new MultiMap();");
                stringBuffer.append(EOL);
                stringBuffer.append("}").append(EOL);
                stringBuffer.append("if (").append(this.beanMapVar()).append(".get(");
                stringBuffer.append(this.cmrFieldBeanVar(string8)).append(", \"");
                stringBuffer.append(string3).append("\") == null) {");
                stringBuffer.append(EOL);
                stringBuffer.append(this.beanMapVar()).append(".put(");
                stringBuffer.append(this.cmrFieldBeanVar(string8)).append(", \"");
                stringBuffer.append(string3).append("\");").append(EOL);
                stringBuffer.append("}").append(EOL);
            }
            String string10 = null;
            if (string != null) {
                string10 = this.bmVar((String)this.declaredManagerVars.get(rDBMSBean.getEjbName()));
                stringBuffer.append(this.eoRCVar() + " = " + string10 + ".finderGetEoFromBeanOrPk((javax.ejb.EntityBean)" + this.cmrFieldBeanVar(string8) + ", null, true);" + EOL);
            } else {
                stringBuffer.append(this.eoRCVar() + " = " + this.eoVar() + ";" + EOL);
            }
            stringBuffer.append("} else {" + EOL);
            stringBuffer.append(this.eoRCVar() + " = null;" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("if (" + this.cmrFieldBeanVar() + " != null) {" + EOL);
            if (bl) {
                if (!rDBMSBean.relatedFieldIsFkOwner(string3) || rDBMSBean.isManyToManyRelation(string3)) {
                    if (!rDBMSBean2.isQueryCachingEnabledForCMRField(string7)) {
                        stringBuffer.append("if (qcHandler.isQueryCachingEnabledForFinder()) {");
                        stringBuffer.append(EOL);
                    }
                    iterator2 = CodeGenUtils.fieldVarName(string7);
                    string2 = this.generateCMRFieldFinderMethodName(string7);
                    stringBuffer.append("TTLManager roMgr = (TTLManager)");
                    if (string != null) {
                        stringBuffer.append(string10).append(";").append(EOL);
                    } else {
                        stringBuffer.append(this.pmVar()).append(".getBeanManager();").append(EOL);
                    }
                    Class clazz = rDBMSBean2.getCmrFieldClass(string7);
                    stringBuffer.append("QueryCacheKey qckey = new QueryCacheKey(\"");
                    stringBuffer.append(string2).append("\", new Object[]{");
                    stringBuffer.append("((CMPBean)").append(this.cmrFieldBeanVar());
                    stringBuffer.append(").__WL_getPrimaryKey()").append("}, roMgr, ");
                    if (Set.class.isAssignableFrom(clazz)) {
                        stringBuffer.append("QueryCacheKey.RET_TYPE_SET);").append(EOL);
                    } else {
                        stringBuffer.append("QueryCacheKey.RET_TYPE_SINGLETON);").append(EOL);
                    }
                    stringBuffer.append("QueryCacheElement qce = new QueryCacheElement(");
                    if (string != null) {
                        stringBuffer.append(this.cmrFieldBeanVar(string8));
                        stringBuffer.append(".__WL_getPrimaryKey(), roMgr);").append(EOL);
                    } else {
                        stringBuffer.append("__WL_getPrimaryKey(), roMgr);").append(EOL);
                    }
                    stringBuffer.append("qcHandler.addQueryCachingEntry(roMgr, qckey, qce);");
                    stringBuffer.append(EOL);
                    if (!rDBMSBean2.isQueryCachingEnabledForCMRField(string7)) {
                        stringBuffer.append("}").append(EOL);
                    }
                }
            } else if (this.shouldImplementQueryCaching(this.curFinder) && (!rDBMSBean.relatedFieldIsFkOwner(string3) || rDBMSBean.isManyToManyRelation(string3)) || rDBMSBean2.isQueryCachingEnabledForCMRField(string7)) {
                this.currFinderLoadsQueryCachingEnabledCMRFields = true;
                stringBuffer.append("if (").append(this.beanMapVar()).append(" == null) {");
                stringBuffer.append(EOL);
                stringBuffer.append(this.beanMapVar()).append(" = new MultiMap();");
                stringBuffer.append(EOL);
                stringBuffer.append("}").append(EOL);
                stringBuffer.append("if (").append(this.beanMapVar()).append(".get(");
                stringBuffer.append(this.cmrFieldBeanVar()).append(", \"");
                stringBuffer.append(string7).append("\") == null) {");
                stringBuffer.append(EOL);
                stringBuffer.append(this.beanMapVar()).append(".put(");
                stringBuffer.append(this.cmrFieldBeanVar()).append(", \"");
                stringBuffer.append(string7).append("\");").append(EOL);
                stringBuffer.append("}").append(EOL);
            }
            stringBuffer.append(this.cmrFieldBeanVar() + "." + CodeGenUtils.cacheRelationshipMethodName(string7) + "(" + this.eoRCVar() + ");" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("} else {" + EOL);
            stringBuffer.append(this.cmrFieldBeanVar() + " = (" + string6 + ") " + this.cmrFieldPKMapVar(string) + ".get(" + this.cmrFieldPKVar(string) + ");" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("}" + EOL + EOL);
            stringBuffer.append("increment = increment + " + n2 + ";" + EOL);
            iterator2 = cachingElement.getCachingElements().iterator();
            if (!iterator2.hasNext()) continue;
            string2 = null;
            string2 = string == null ? string3 : string + "_" + string3;
            this.invokeEagerCachingMethodsForCachingElements(rDBMSBean2, iterator2, string2, stringBuffer, bl);
        }
    }

    public String perhapsPostFinderCleanupForEagerCaching() {
        if (!(this.curFinder instanceof EjbqlFinder)) {
            return "";
        }
        EjbqlFinder ejbqlFinder = (EjbqlFinder)this.curFinder;
        String string = ejbqlFinder.getCachingName();
        if (string == null) {
            return "";
        }
        List list = this.curRelationshipCaching.getCachingElements();
        if (list.size() <= 0) {
            return "";
        }
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// After all related beans have been loaded into cache").append(EOL);
        stringBuffer.append("// we run postFinderCleanup on the related beans here.").append(EOL);
        stringBuffer.append("// postFinderCleanup on the primary beans is done in the beanManager.");
        stringBuffer.append(EOL).append(EOL);
        this.postFinderCleanupForEagerCaching(this.bean, iterator, null, stringBuffer);
        return stringBuffer.toString();
    }

    private void postFinderCleanupForEagerCaching(RDBMSBean rDBMSBean, Iterator iterator, String string, StringBuffer stringBuffer) {
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            RelationshipCaching.CachingElement cachingElement = (RelationshipCaching.CachingElement)iterator.next();
            String string2 = cachingElement.getCmrField();
            String string3 = cachingElement.getGroupName();
            this.setCurrCachingElementCmrField(string2);
            RDBMSBean rDBMSBean2 = rDBMSBean.getRelatedRDBMSBean(string2);
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getRelatedDescriptor(string2);
            String string4 = this.bmVar((String)this.declaredManagerVars.get(rDBMSBean2.getEjbName()));
            boolean bl = cMPBeanDescriptor.hasLocalClientView();
            stringBuffer.append(string4).append(".postFinderCleanup(");
            stringBuffer.append("null,  // Object argument").append(EOL);
            stringBuffer.append(this.cmrFieldPKMapVar(string)).append(".keySet(),  // Collection of the pks").append(EOL);
            stringBuffer.append("true,  // related cached pks").append(EOL);
            stringBuffer.append(bl).append("  // isLocal ?").append(EOL);
            stringBuffer.append(");").append(EOL).append(EOL);
            Iterator iterator2 = cachingElement.getCachingElements().iterator();
            if (!iterator2.hasNext()) continue;
            String string5 = null;
            string5 = string == null ? string2 : string + "_" + string2;
            this.postFinderCleanupForEagerCaching(rDBMSBean2, iterator2, string5, stringBuffer);
        }
        stringBuffer.append(EOL);
    }

    public String perhapsDeclareRelationshipCachingPooledBeanVar() {
        return this.perhapsRelationshipCachingPooledBeanVar(1);
    }

    public String perhapsAllocateRelationshipCachingPooledBeanVar() {
        return this.perhapsRelationshipCachingPooledBeanVar(2);
    }

    public String perhapsRemoveRelationshipCachingPooledBeanVar() {
        return this.perhapsRelationshipCachingPooledBeanVar(3);
    }

    public String perhapsRelationshipCachingPooledBeanVar(int n) {
        Object object;
        Object object2;
        boolean bl = false;
        if (this.curFinder instanceof EjbqlFinder && (object2 = ((EjbqlFinder)(object = (EjbqlFinder)this.curFinder)).getCachingName()) != null) {
            this.curRelationshipCaching = this.bean.getRelationshipCaching((String)object2);
            if (this.curRelationshipCaching != null) {
                bl = this.curRelationshipCaching.getCachingElements().iterator().hasNext();
            }
        }
        if (!bl) {
            return "";
        }
        object = new StringBuffer();
        object2 = this.curRelationshipCaching.getCachingElements().iterator();
        this.perhapsRelationshipCachingPooledBeanVar(this.bean, (Iterator)object2, null, n, (StringBuffer)object);
        return ((StringBuffer)object).toString();
    }

    public void perhapsRelationshipCachingPooledBeanVar(RDBMSBean rDBMSBean, Iterator iterator, String string, int n, StringBuffer stringBuffer) {
        while (iterator.hasNext()) {
            Iterator iterator2;
            RelationshipCaching.CachingElement cachingElement = (RelationshipCaching.CachingElement)iterator.next();
            String string2 = cachingElement.getCmrField();
            this.setCurrCachingElementCmrField(string2);
            RDBMSBean rDBMSBean2 = rDBMSBean.getRelatedRDBMSBean(string2);
            String string3 = this.bmVar((String)this.declaredManagerVars.get(rDBMSBean2.getEjbName()));
            CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean2.getEjbName());
            String string4 = cMPBeanDescriptor.getGeneratedBeanInterfaceName();
            if (n == 1) {
                stringBuffer.append(string4 + " " + this.cmrFieldBeanVar() + "_pooledBean = null;" + EOL);
            } else if (n == 2) {
                stringBuffer.append(this.cmrFieldBeanVar() + "_pooledBean = (" + string4 + ") " + string3 + ".getBeanFromPool();" + EOL);
            } else if (n == 3) {
                stringBuffer.append("if (" + this.cmrFieldBeanVar() + "_pooledBean!=null) " + "((weblogic.ejb.container.manager.BaseEntityManager)" + string3 + ").releaseBeanToPool(((javax.ejb.EntityBean)" + this.cmrFieldBeanVar() + "_pooledBean));" + EOL);
            }
            if (!(iterator2 = cachingElement.getCachingElements().iterator()).hasNext()) continue;
            String string5 = null;
            string5 = string == null ? string2 : string + "_" + string2;
            this.perhapsRelationshipCachingPooledBeanVar(rDBMSBean2, iterator2, string5, n, stringBuffer);
        }
    }

    public String declarePKMapVar() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL + "Map " + this.pkMapVar() + " = new HashMap();" + EOL);
        String string = null;
        if (this.curFinder instanceof EjbqlFinder) {
            object = (EjbqlFinder)this.curFinder;
            string = ((EjbqlFinder)object).getCachingName();
        }
        if (string == null) {
            return stringBuffer.toString();
        }
        object = this.bean.getRelationshipCaching(string);
        if (object == null) {
            return stringBuffer.toString();
        }
        Iterator iterator = ((RelationshipCaching)object).getCachingElements().iterator();
        stringBuffer.append(this.declarePKMapVarForCachingElements(this.bean, iterator, null));
        return stringBuffer.toString();
    }

    public String declarePKMapVarForCachingElements(RDBMSBean rDBMSBean, Iterator iterator, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            RelationshipCaching.CachingElement cachingElement = (RelationshipCaching.CachingElement)iterator.next();
            String string2 = cachingElement.getCmrField();
            String string3 = cachingElement.getGroupName();
            this.setCurrCachingElementCmrField(string2);
            RDBMSBean rDBMSBean2 = rDBMSBean.getRelatedRDBMSBean(string2);
            stringBuffer.append("Map " + this.cmrFieldPKMapVar(string) + " = new HashMap();" + EOL);
            Iterator iterator2 = cachingElement.getCachingElements().iterator();
            if (!iterator2.hasNext()) continue;
            String string4 = null;
            string4 = string == null ? string2 : string + "_" + string2;
            stringBuffer.append(this.declarePKMapVarForCachingElements(rDBMSBean2, iterator2, string4));
        }
        return stringBuffer.toString();
    }

    private void setCurrCachingElementCmrField(String string) {
        this.currCachingElementCmrField = string;
    }

    private String cmrFieldBeanVar() {
        return this.beanVar() + "_" + this.currCachingElementCmrField;
    }

    private String cmrFieldBeanVar(String string) {
        if ("".equals(string)) {
            return this.beanVar();
        }
        return this.beanVar() + "_" + string;
    }

    private String cmrFieldPKVar(String string) {
        if (string == null) {
            return this.pkVar() + "_" + this.currCachingElementCmrField;
        }
        return this.pkVar() + "_" + string + "_" + this.currCachingElementCmrField;
    }

    private String cmrFieldPKMapVar(String string) {
        if (string == null) {
            return this.pkMapVar() + "_" + this.currCachingElementCmrField;
        }
        return this.pkMapVar() + "_" + string + "_" + this.currCachingElementCmrField;
    }

    private String cmrFieldClassLoaderVar() {
        return this.classLoaderVar() + "_" + this.currCachingElementCmrField;
    }

    public String assignOffsetIntObjVar(int n) {
        return this.offsetIntObjVar() + " = new Integer(" + n + ");" + EOL;
    }

    public String assignOffsetVar() {
        return "int " + this.offsetVar() + " = " + this.offsetIntObjVar() + ".intValue();" + EOL;
    }

    public String getPKFromRSMethodName() {
        return this.varPrefix() + "getPKFromRS";
    }

    private String getPKFromRSMethodParams() {
        return "(" + this.rsVar() + ", " + this.offsetIntObjVar() + ", " + this.classLoaderVar() + ");";
    }

    private int loadGroupFromRSIndex(RDBMSBean rDBMSBean, String string) {
        return rDBMSBean.getFieldGroup(string).getIndex();
    }

    private String loadGroupFromRSMethodName(RDBMSBean rDBMSBean, String string) {
        return this.loadGroupFromRSMethodName(rDBMSBean.getFieldGroup(string));
    }

    private String loadGroupFromRSMethodName(FieldGroup fieldGroup) {
        return this.loadMethodName(this.getFieldGroupSuffix(fieldGroup) + "FromRS");
    }

    private String loadCMRFieldFromRSMethodName(String string) {
        return this.varPrefix() + "loadCMRFieldFromRS_" + string;
    }

    private String loadFromRSMethodParams() {
        return "(" + this.rsVar() + ", " + this.offsetIntObjVar() + ", " + this.cmrFieldBeanVar() + ");";
    }

    private boolean lhsBeanHasFKForLocal11or1NPath(RDBMSBean rDBMSBean, String string) {
        return rDBMSBean.isForeignKeyField(string);
    }

    private String oneToManyAddMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public void " + CodeGenUtils.cacheRelationshipMethodName(this.curField) + "(Object " + this.curField + ") {" + EOL);
        if (this.bean.getRelatedMultiplicity(this.curField).equals("One")) {
            String string = ClassUtils.classToJavaSourceType(this.bean.getCmrFieldClass(this.curField));
            stringBuffer.append("if (" + this.curField + " != null) {" + EOL);
            stringBuffer.append(CodeGenUtils.fieldVarName(this.curField) + " = (" + string + ") " + this.curField + ";" + EOL);
            stringBuffer.append("}" + EOL);
        } else {
            stringBuffer.append("if (");
            stringBuffer.append(CodeGenUtils.fieldVarName(this.curField));
            stringBuffer.append(" == null) {" + EOL);
            stringBuffer.append(CodeGenUtils.fieldVarName(this.curField) + " = " + this.allocateOneToManySet() + ";" + EOL);
            stringBuffer.append("}" + EOL);
            if (this.bean.isReadOnly() || this.bean.getCacheBetweenTransactions()) {
                stringBuffer.append("else {").append(EOL);
                stringBuffer.append("Transaction currentTx = TransactionHelper");
                stringBuffer.append(".getTransactionHelper().getTransaction();").append(EOL);
                stringBuffer.append("if (currentTx == null || !((RDBMSSet)");
                stringBuffer.append(CodeGenUtils.fieldVarName(this.curField));
                stringBuffer.append(").checkIfCurrentTxEqualsCreateTx(currentTx)) {");
                stringBuffer.append(EOL);
                stringBuffer.append(CodeGenUtils.fieldVarName(this.curField)).append(" = ");
                stringBuffer.append(this.allocateOneToManySet()).append(";").append(EOL);
                stringBuffer.append("}").append(EOL);
                stringBuffer.append("}").append(EOL);
            }
            stringBuffer.append("((RDBMSSet)");
            stringBuffer.append(CodeGenUtils.fieldVarName(this.curField));
            stringBuffer.append(").doAddToCache(" + this.curField + ");" + EOL);
        }
        stringBuffer.append(this.isCmrLoadedVarName(this.curField) + " = true;" + EOL);
        stringBuffer.append("}" + EOL + EOL);
        return stringBuffer.toString();
    }

    public String perhapsGenKeyBeforeInsert() throws CodeGenerationException {
        if (this.bean.hasAutoKeyGeneration() && this.bean.getGenKeyBeforeInsert()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(EOL);
            stringBuffer.append(this.genKeyQuery()).append(EOL);
            stringBuffer.append(this.genKeyCallSetPK()).append(EOL);
            return stringBuffer.toString();
        }
        return "";
    }

    public String perhapsDeclarePkCheckMethod() throws CodeGenerationException {
        if (!this.bean.hasAutoKeyGeneration()) {
            return this.parse(this.getProductionRule("declarePkCheckMethod"));
        }
        return "";
    }

    public String implementPkCheckMethodBody() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            Iterator iterator = this.pkFieldNames.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append("// check that '" + string + "' was set" + EOL);
                stringBuffer.append("if (!" + this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]) {" + EOL);
                stringBuffer.append("Loggable l = EJBLogger.logpkNotSetLoggable(\"" + this.bean.getEjbName() + "\",\"" + string + "\");");
                stringBuffer.append("throw new javax.ejb.CreateException(l.getMessage());" + EOL);
                stringBuffer.append("}");
                if (!iterator.hasNext()) continue;
                stringBuffer.append(EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String perhapsImplementCreateMethodBody() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.bd.isReadOnly() || this.bean.allowReadonlyCreateAndRemove()) {
            stringBuffer.append(this.parse(this.getProductionRule("implementCreateMethodBody")));
        } else {
            stringBuffer.append("Loggable l = EJBLogger.logCannotCreateReadOnlyBeanLoggable(\"" + this.bean.getEjbName() + "\");" + EOL);
            stringBuffer.append("throw new javax.ejb.CreateException(l.getMessage());" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsCallPkCheck() {
        if (!this.bean.hasAutoKeyGeneration()) {
            return EOL + "pkCheck();" + EOL;
        }
        return "";
    }

    public String genKeyQuery() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        short s = this.bean.getGenKeyType();
        String string = this.genKeyGetPKClassName();
        stringBuffer.append(string).append(" ").append(this.genKeyVar());
        if (s == 2) {
            stringBuffer.append(" = (").append(string).append(") __WL_pm.getNextSequenceKey();");
        } else if (s == 3) {
            stringBuffer.append(" = (").append(string).append(") __WL_pm.getNextSequenceTableKey();");
        } else {
            throw new AssertionError((Object)("Unknown prefetch auto-key generator for " + this.bd.getEJBName()));
        }
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    private String genKeyCallSetPK() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)this.bd.getPrimaryKeyFieldNames().iterator().next();
        Class clazz = this.bd.getFieldClass(string);
        String string2 = this.genKeyVar();
        if (clazz.equals(Integer.TYPE)) {
            string2 = string2 + ".intValue()";
        } else if (clazz.equals(Long.TYPE)) {
            string2 = string2 + ".longValue()";
        }
        stringBuffer.append(RDBMSUtils.setterMethodName(this.bean.getGenKeyPKField()));
        stringBuffer.append("(").append(string2).append(");").append(EOL);
        return stringBuffer.toString();
    }

    private String genKeyGetPKClassName() throws CodeGenerationException {
        switch (this.bean.getGenKeyPKFieldClassType()) {
            case 0: {
                return "java.lang.Integer";
            }
            case 1: {
                return "java.lang.Long";
            }
        }
        throw new CodeGenerationException(" Internal Error, unknown genKeyPKFieldClassType: " + this.bean.getGenKeyPKFieldClassType());
    }

    private String attrsAsColumnsAsParamsForTable(String string, String[] stringArray, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = RDBMSUtils.escQuotedID(this.bean.getColumnForCmpFieldAndTable(stringArray[i], string));
            stringBuffer.append(string3).append(" = ?");
            if (i >= n - 1) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String attrsAsColumnsAsParams(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = RDBMSUtils.escQuotedID(this.bean.getCmpColumnForField(stringArray[i]));
            stringBuffer.append(string2).append(" = ?");
            if (i >= n - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private Field nameToField(String string) throws NoSuchFieldException {
        return this.ejbClass.getField(string);
    }

    public String resetParams() {
        this.preparedStatementParamIndex = 1;
        return "// preparedStatementParamIndex reset.";
    }

    public String getTableCount() {
        return Integer.toString(this.bean.tableCount());
    }

    public String setCreateQueryArray() throws CodeGenerationException {
        return this.setCreateQueryArray(false);
    }

    public String setCreateQueryArrayWoFkColumns() throws CodeGenerationException {
        return this.setCreateQueryArray(true);
    }

    public String setCreateQueryArray(boolean bl) throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            this.curTableName = this.bean.tableAt(i);
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = this.getCreateQueryColumnSQLForTable(i, stringBuffer2, bl);
            stringBuffer.append(this.queryArrayElement(i)).append(" = \"INSERT INTO ");
            stringBuffer.append(this.curTableName).append(" (");
            stringBuffer.append(string);
            stringBuffer.append(") VALUES (");
            stringBuffer.append(stringBuffer2);
            if (this.bean.getGenKeyType() == 1 && (this.bean.getDatabaseType() == 2 || this.bean.getDatabaseType() == 7)) {
                stringBuffer.append(") " + this.bean.getGenKeyGeneratorQuery() + "\";").append(EOL);
                continue;
            }
            stringBuffer.append(")\";").append(EOL);
        }
        return stringBuffer.toString();
    }

    public String executeUpdateOrExecuteQuery() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        short s = this.bean.getGenKeyType();
        Class clazz = this.bd.getPrimaryKeyClass();
        if (s == 1) {
            stringBuffer.append(this.genKeyGetPKClassName()).append(" " + this.genKeyVar() + " = null;");
            stringBuffer.append(EOL);
        }
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            if (s == 1 && (this.bean.getDatabaseType() == 2 || this.bean.getDatabaseType() == 7)) {
                stringBuffer.append(this.rsVar() + " = " + this.stmtArrayElement(i)).append(".executeQuery();").append(EOL);
            } else {
                stringBuffer.append("if (" + this.stmtArrayElement(i)).append(".executeUpdate() != 1)").append(EOL);
                stringBuffer.append("throw new java.lang.Exception(\"" + this.createUpdateFailureMsg() + "\");").append(EOL);
                if (s == 1) {
                    stringBuffer.append(this.rsVar() + " = " + this.stmtArrayElement(i));
                    stringBuffer.append(".getGeneratedKeys();").append(EOL);
                }
            }
            if (s != 1) continue;
            stringBuffer.append("if (" + this.rsVar() + ".next()) {").append(EOL);
            stringBuffer.append(this.genKeyVar());
            stringBuffer.append(" = new ").append(this.genKeyGetPKClassName() + "(" + this.rsVar() + ".get");
            if (this.genKeyGetPKClassName().equals("java.lang.Integer")) {
                stringBuffer.append("Int(1)");
            } else if (this.genKeyGetPKClassName().equals("java.lang.Long")) {
                stringBuffer.append("Long(1)");
            }
            stringBuffer.append(");").append(EOL);
            stringBuffer.append("this.").append(this.bean.getGenKeyPKField()).append(" = ");
            stringBuffer.append(this.genKeyVar()).append(";").append(EOL);
            stringBuffer.append(this.pkVar());
            stringBuffer.append(" = (").append(ClassUtils.classToJavaSourceType(clazz)).append(") __WL_getPrimaryKey();").append(EOL);
            stringBuffer.append("} else {").append(EOL);
            stringBuffer.append("Loggable l = EJBLogger.logNoGeneratedPKReturnedLoggable();").append(EOL);
            stringBuffer.append("throw new javax.ejb.CreateException(l.getMessage());" + EOL);
            stringBuffer.append("}").append(EOL);
            stringBuffer.append("if (" + this.rsVar() + ".next()) {").append(EOL);
            stringBuffer.append("Loggable l = EJBLogger.logMultiplGeneratedKeysReturnedLoggable();").append(EOL);
            stringBuffer.append("throw new javax.ejb.CreateException(l.getMessage());" + EOL);
            stringBuffer.append("}").append(EOL);
        }
        return stringBuffer.toString();
    }

    public String setUpdateQueryArray() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            this.curTableIndex = i;
            this.curTableName = this.bean.tableAt(i);
            stringBuffer.append(this.perhapsResetBlobClobCountVar()).append(EOL);
            stringBuffer.append(this.countVar() + " = 0;");
            stringBuffer.append(this.constructModifiedFieldStoreColumnStrings());
            if (this.useVersionOrTimestampCheckingForBlobClob(this.curTableName)) {
                stringBuffer.append("if ( (").append(this.countVar()).append(" != 0) || ");
                stringBuffer.append("(").append(this.blobClobCountVarOrZero()).append(" > 0) ) {").append(EOL);
            } else {
                stringBuffer.append("if (").append(this.countVar()).append(" != 0) {").append(EOL);
            }
            stringBuffer.append(this.perhapsSetUpdateOptimisticFieldStringForBatch());
            stringBuffer.append(this.perhapsConstructSnapshotPredicate());
            stringBuffer.append("if (sb.length() != 0) {").append(EOL);
            stringBuffer.append(this.queryArrayElement(i)).append(" = \"UPDATE ");
            stringBuffer.append(this.curTableName);
            stringBuffer.append(" SET \" + ");
            stringBuffer.append("sb.toString() + ");
            stringBuffer.append("\" WHERE " + this.idParamsSqlForCurTable() + "\"");
            stringBuffer.append(this.perhapsAddSnapshotPredicate() + ";").append(EOL);
            stringBuffer.append("}").append(EOL);
            stringBuffer.append("}").append(EOL);
        }
        return stringBuffer.toString();
    }

    public String setBeanParamsForUpdateArray() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.declareByteArrayVars());
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            this.curTableIndex = i;
            this.curTableName = this.bean.tableAt(i);
            stringBuffer.append(this.parse(this.getProductionRule("implementSetBeanParamsForUpdateArrayMethodBody")));
        }
        return stringBuffer.toString();
    }

    private boolean appendComma(boolean bl, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer2.append(", ");
        } else {
            bl = true;
        }
        return bl;
    }

    private String getCreateQueryColumnSQLForTable(int n, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        this.curTableIndex = n;
        this.curTableName = this.bean.tableAt(n);
        ArrayList arrayList = new ArrayList(this.bean.getFields(n));
        String string = null;
        String string2 = null;
        if (this.bean.hasAutoKeyGeneration()) {
            string = this.bean.getGenKeyPKField();
            string2 = this.bean.getGenKeyDefaultColumnVal();
        }
        if (this.bean.hasAutoKeyGeneration() && this.bean.genKeyExcludePKColumn()) {
            assert (arrayList.contains(string));
            arrayList.remove(string);
        }
        if (this.bean.getTriggerUpdatesOptimisticColumn(this.curTableName)) {
            String string3 = this.bean.getOptimisticColumn(this.curTableName);
            String string4 = this.bean.getCmpField(this.curTableName, string3);
            assert (arrayList.contains(string4));
            arrayList.remove(string4);
        }
        boolean bl2 = false;
        for (String string5 : arrayList) {
            if (this.bean.isCmpFieldName(string5)) {
                if (string5.equals(string) && string2 != null) {
                    bl2 = this.appendComma(bl2, stringBuffer2, stringBuffer);
                    stringBuffer2.append(string2);
                    stringBuffer.append(string2);
                    if (!debugLogger.isDebugEnabled()) continue;
                    RDBMSCodeGenerator.debug("substitute default column value '" + string2 + "'");
                    continue;
                }
                if (this.bean.isDbmsDefaultValueField(string5)) continue;
                bl2 = this.appendComma(bl2, stringBuffer2, stringBuffer);
                stringBuffer2.append(this.getInsertColumnStringForField(string5, n));
                stringBuffer.append(this.getInsertQuoteStringForField(string5));
                continue;
            }
            if (!this.bean.isSelfRelationship(string5) || !this.bean.containsFkField(string5) || this.bean.isForeignCmpField(string5)) continue;
            for (String string6 : this.bean.getForeignKeyColNames(string5)) {
                bl2 = this.appendComma(bl2, stringBuffer2, stringBuffer);
                stringBuffer2.append(RDBMSUtils.escQuotedID(string6));
                stringBuffer.append("?");
            }
        }
        for (String string5 : arrayList) {
            if (this.bean.isCmpFieldName(string5) || bl || this.bean.isSelfRelationship(string5) || !this.bean.containsFkField(string5) || this.bean.isForeignCmpField(string5)) continue;
            for (String string6 : this.bean.getForeignKeyColNames(string5)) {
                bl2 = this.appendComma(bl2, stringBuffer2, stringBuffer);
                stringBuffer2.append(RDBMSUtils.escQuotedID(string6));
                stringBuffer.append("?");
            }
        }
        return stringBuffer2.toString();
    }

    private String getInsertColumnStringForField(String string, int n) {
        this.curTableName = this.bean.tableAt(n);
        String string2 = this.bean.getColumnForCmpFieldAndTable(string, this.curTableName);
        assert (string2 != null);
        return RDBMSUtils.escQuotedID(string2);
    }

    private String getInsertQuoteStringForField(String string) {
        if (this.bean.isBlobCmpColumnTypeForField(string) && this.bean.getDatabaseType() == 1) {
            return "EMPTY_BLOB()";
        }
        if (this.bean.isClobCmpColumnTypeForField(string) && this.bean.getDatabaseType() == 1) {
            return "\"+((" + this.pmVar() + ".perhapsUseSetStringForClobForOracle()) ? \"?\":\"EMPTY_CLOB()\")+\"";
        }
        return "?";
    }

    public String prepareCreateStmtArray() {
        if (this.bean.getGenKeyType() == 1 && this.bean.getDatabaseType() != 2 && this.bean.getDatabaseType() != 7) {
            return this.prepareStmtArray(true);
        }
        return this.prepareStmtArray(false);
    }

    public String prepareStmtArray() {
        return this.prepareStmtArray(false);
    }

    public String prepareStmtArray(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            stringBuffer.append("if (" + this.queryArrayElement(i) + " != null) ");
            stringBuffer.append(this.stmtArrayElement(i)).append(" = ");
            stringBuffer.append(this.conVar()).append(".prepareStatement(").append(this.queryArrayElement(i));
            if (bl) {
                stringBuffer.append(", java.sql.Statement.RETURN_GENERATED_KEYS");
            }
            stringBuffer.append(");").append(EOL);
        }
        return stringBuffer.toString();
    }

    public String setBeanParamsForCreateArray() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int " + this.numVar() + " = 0;" + EOL);
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            Object object;
            String string;
            Object object2;
            Object object3;
            String[] stringArray;
            Object object4;
            Iterator iterator;
            Object object5;
            String string2;
            stringBuffer.append(this.resetParams() + EOL);
            stringBuffer.append(this.numVar() + " = 1;" + EOL);
            ArrayList<String> arrayList = new ArrayList<String>(this.bean.getCMPFields(i));
            if (this.bean.genKeyExcludePKColumn()) {
                string2 = this.bean.getGenKeyPKField();
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("CreateBeanParams Exclude PK field: " + string2);
                }
                arrayList.remove(string2);
            }
            if (this.bean.getTriggerUpdatesOptimisticColumn(string2 = this.bean.tableAt(i))) {
                object5 = this.bean.getOptimisticColumn(string2);
                iterator = this.bean.getCmpField(string2, (String)object5);
                assert (arrayList.contains(iterator));
                arrayList.remove(iterator);
            }
            object5 = new ArrayList(this.bean.getCMPFields(i));
            iterator = object5.iterator();
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                if ((this.bean.isBlobCmpColumnTypeForField((String)object4) || this.bean.isClobCmpColumnTypeForField((String)object4)) && this.bean.getDatabaseType() == 1) {
                    arrayList.remove(object4);
                    continue;
                }
                if (!this.bean.isDbmsDefaultValueField((String)object4)) continue;
                arrayList.remove(object4);
            }
            object4 = this.bean.getCMRFields(i);
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                if (!this.bean.isSelfRelationship((String)stringArray) || !this.bean.containsFkField((String)stringArray) || this.bean.isForeignCmpField((String)stringArray)) continue;
                object3 = this.bean.getTableForCmrField((String)stringArray);
                object2 = this.bean.getForeignKeyColNames((String)stringArray).iterator();
                while (object2.hasNext()) {
                    string = RDBMSUtils.escQuotedID((String)object2.next());
                    object = this.bean.variableForField((String)stringArray, (String)object3, string);
                    arrayList.add((String)object);
                }
            }
            stringArray = arrayList.toArray(new String[0]);
            stringBuffer.append(this.preparedStatementBindings(stringArray, "this", true, true, true, this.bd.isOptimistic(), this.stmtArrayElement(i)));
            object3 = new ArrayList();
            object4 = this.bean.getCMRFields(i);
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                if (this.bean.isSelfRelationship((String)object2) || !this.bean.containsFkField((String)object2) || this.bean.isForeignCmpField((String)object2)) continue;
                string = this.bean.getTableForCmrField((String)object2);
                object = this.bean.getForeignKeyColNames((String)object2).iterator();
                while (object.hasNext()) {
                    String string3 = RDBMSUtils.escQuotedID((String)object.next());
                    String string4 = this.bean.variableForField((String)object2, string, string3);
                    object3.add(string4);
                }
            }
            object2 = object3.toArray(new String[0]);
            stringBuffer.append("if (!woFkCols) {");
            stringBuffer.append(this.preparedStatementBindings((String[])object2, "this", true, true, true, this.bd.isOptimistic(), this.stmtArrayElement(i)));
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }

    public String setBeanParamsForCreateArrayOptimizedForClobUpdate() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int " + this.numVar() + " = 0;" + EOL);
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            Object object;
            String string;
            Object object2;
            Object object3;
            String[] stringArray;
            Object object4;
            Iterator iterator;
            Object object5;
            String string2;
            stringBuffer.append(this.resetParams() + EOL);
            stringBuffer.append(this.numVar() + " = 1;" + EOL);
            ArrayList<String> arrayList = new ArrayList<String>(this.bean.getCMPFields(i));
            if (this.bean.genKeyExcludePKColumn()) {
                string2 = this.bean.getGenKeyPKField();
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("CreateBeanParams Exclude PK field: " + string2);
                }
                arrayList.remove(string2);
            }
            if (this.bean.getTriggerUpdatesOptimisticColumn(string2 = this.bean.tableAt(i))) {
                object5 = this.bean.getOptimisticColumn(string2);
                iterator = this.bean.getCmpField(string2, (String)object5);
                assert (arrayList.contains(iterator));
                arrayList.remove(iterator);
            }
            object5 = new ArrayList(this.bean.getCMPFields(i));
            iterator = object5.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                ++n;
                if (this.bean.isBlobCmpColumnTypeForField((String)object4) && this.bean.getDatabaseType() == 1) {
                    --n;
                    arrayList.remove(object4);
                    continue;
                }
                if (this.bean.isClobCmpColumnTypeForField((String)object4) && this.bean.getDatabaseType() == 1) {
                    stringBuffer.append(this.doPreparedStmtBindingForClob((String)object4, n, "this", true, false, this.bd.isOptimistic(), this.stmtArrayElement(i)));
                    continue;
                }
                if (!this.bean.isDbmsDefaultValueField((String)object4)) continue;
                --n;
                arrayList.remove(object4);
            }
            object4 = this.bean.getCMRFields(i);
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                if (!this.bean.isSelfRelationship((String)stringArray) || !this.bean.containsFkField((String)stringArray) || this.bean.isForeignCmpField((String)stringArray)) continue;
                object3 = this.bean.getTableForCmrField((String)stringArray);
                object2 = this.bean.getForeignKeyColNames((String)stringArray).iterator();
                while (object2.hasNext()) {
                    string = RDBMSUtils.escQuotedID((String)object2.next());
                    object = this.bean.variableForField((String)stringArray, (String)object3, string);
                    arrayList.add((String)object);
                }
            }
            stringArray = arrayList.toArray(new String[0]);
            stringBuffer.append(this.preparedStatementBindings(stringArray, "this", true, true, true, this.bd.isOptimistic(), this.stmtArrayElement(i)));
            object3 = new ArrayList();
            object4 = this.bean.getCMRFields(i);
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                if (this.bean.isSelfRelationship((String)object2) || !this.bean.containsFkField((String)object2) || this.bean.isForeignCmpField((String)object2)) continue;
                string = this.bean.getTableForCmrField((String)object2);
                object = this.bean.getForeignKeyColNames((String)object2).iterator();
                while (object.hasNext()) {
                    String string3 = RDBMSUtils.escQuotedID((String)object.next());
                    String string4 = this.bean.variableForField((String)object2, string, string3);
                    object3.add(string4);
                }
            }
            object2 = object3.toArray(new String[0]);
            stringBuffer.append("if (!woFkCols) {");
            stringBuffer.append(this.preparedStatementBindings((String[])object2, "this", true, true, true, this.bd.isOptimistic(), this.stmtArrayElement(i)));
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }

    public String setBeanParamsForCreate() {
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>(this.cmpFieldNames);
        if (this.bean.genKeyExcludePKColumn()) {
            String string = this.bean.getGenKeyPKField();
            if (debugLogger.isDebugEnabled()) {
                RDBMSCodeGenerator.debug("CreateBeanParams Exclude PK field: " + (String)string);
            }
            arrayList.remove(string);
        }
        for (Object object : this.cmpFieldNames) {
            if (!this.bean.isBlobCmpColumnTypeForField((String)object) && !this.bean.isClobCmpColumnTypeForField((String)object)) continue;
            arrayList.remove(object);
        }
        for (String[] stringArray2 : this.bean.getForeignKeyFieldNames()) {
            if (!this.bean.containsFkField((String)stringArray2) || this.bean.isForeignCmpField((String)stringArray2)) continue;
            String string = this.bean.getTableForCmrField((String)stringArray2);
            Iterator iterator = this.bean.getForeignKeyColNames((String)stringArray2).iterator();
            while (iterator.hasNext()) {
                String string2 = RDBMSUtils.escQuotedID((String)iterator.next());
                String string3 = this.bean.variableForField((String)stringArray2, string, string2);
                arrayList.add(string3);
            }
        }
        stringArray2 = arrayList.toArray(new String[0]);
        return this.preparedStatementBindings(stringArray2, "this", true, true, false, this.bd.isOptimistic());
    }

    public String setRemoveQueryArray() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            this.curTableIndex = i;
            this.curTableName = this.bean.tableAt(this.curTableIndex);
            stringBuffer.append(this.perhapsConstructSnapshotPredicate());
            stringBuffer.append(this.queryArrayElement(i)).append(" = \"DELETE FROM ");
            stringBuffer.append(this.curTableName).append(" WHERE ");
            stringBuffer.append(this.idParamsSqlForTable(this.curTableName) + "\" ");
            stringBuffer.append(this.perhapsAddSnapshotPredicate());
            stringBuffer.append(";").append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsDeclareSetBlobClobForOutputMethod() throws CodeGenerationException {
        if (!this.bean.hasBlobClobColumn()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.cmpFieldNames.toArray(new String[0]);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!this.bean.hasCmpColumnType(string)) continue;
            if (this.bean.isBlobCmpColumnTypeForField(string)) {
                this.curField = stringArray[i];
                this.curTableName = this.bean.getTableForCmpField(this.curField);
                this.curTableIndex = this.bean.tableIndex(this.curTableName);
                stringBuffer.append(this.parse(this.getProductionRule("setBlobForOutputBody")));
                stringBuffer.append(this.parse(this.getProductionRule("setBlobForInputBody")));
            }
            if (!this.bean.isClobCmpColumnTypeForField(string)) continue;
            this.curField = stringArray[i];
            this.curTableName = this.bean.getTableForCmpField(this.curField);
            this.curTableIndex = this.bean.tableIndex(this.curTableName);
            stringBuffer.append(this.parse(this.getProductionRule("setClobForOutputBody")));
            stringBuffer.append(this.parse(this.getProductionRule("setClobForInputBody")));
        }
        return stringBuffer.toString();
    }

    public String perhapsTruncateClob() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.getDatabaseType() == 1) {
            stringBuffer.append(this.parse(this.getProductionRule("truncateOracleClob")));
        } else {
            stringBuffer.append(this.parse(this.getProductionRule("truncateGenericClob")));
        }
        return stringBuffer.toString();
    }

    public String getClobWriter() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.getDatabaseType() == 1) {
            stringBuffer.append(this.parse(this.getProductionRule("getOracleClobWriter")));
        } else {
            stringBuffer.append(this.parse(this.getProductionRule("getGenericClobWriter")));
        }
        return stringBuffer.toString();
    }

    public String perhapsUpdateClob() throws CodeGenerationException {
        if (this.bean.getDatabaseType() == 4) {
            return this.parse(this.getProductionRule("updateClob"));
        }
        return "";
    }

    public String setClobParam() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.stmtVar());
        stringBuffer.append(".setClob(");
        stringBuffer.append(this.preparedStatementParamIndex++).append(", lob");
        stringBuffer.append(");" + EOL);
        return stringBuffer.toString();
    }

    public String setLobAsTypeParam() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addPreparedStatementBinding(stringBuffer, this.curField, "this", String.valueOf(this.preparedStatementParamIndex), true, true, false, false, this.stmtVar());
        ++this.preparedStatementParamIndex;
        return stringBuffer.toString();
    }

    public String perhapsTruncateBlob() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.getDatabaseType() == 1) {
            stringBuffer.append(this.parse(this.getProductionRule("truncateOracleBlob")));
        } else {
            stringBuffer.append(this.parse(this.getProductionRule("truncateGenericBlob")));
        }
        return stringBuffer.toString();
    }

    public String setBlobParam() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.stmtVar());
        stringBuffer.append(".setBlob(");
        stringBuffer.append(this.preparedStatementParamIndex++).append(", lob");
        stringBuffer.append(");" + EOL);
        return stringBuffer.toString();
    }

    public String writeBlobToOutputStream() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bean.getDatabaseType() == 1) {
            stringBuffer.append(this.parse(this.getProductionRule("writeOracleBlobToOutputStream")));
        } else {
            stringBuffer.append(this.parse(this.getProductionRule("writeGenericBlobToOutputStream")));
        }
        return stringBuffer.toString();
    }

    public String perhapsUpdateBlob() throws CodeGenerationException {
        if (this.bean.getDatabaseType() == 4) {
            return this.parse(this.getProductionRule("updateBlob"));
        }
        return "";
    }

    public String setBlobClobForCreate() throws CodeGenerationException {
        if (!this.bean.hasBlobClobColumn() || this.bean.getDatabaseType() != 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.cmpFieldNames.toArray(new String[0]);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!this.bean.hasCmpColumnType(string)) continue;
            this.curField = stringArray[i];
            this.curTableName = this.bean.getTableForCmpField(this.curField);
            this.curTableIndex = this.bean.tableIndex(this.curTableName);
            if (this.bean.isBlobCmpColumnTypeForField(string)) {
                stringBuffer.append("\n" + this.setBlobClobForOutputMethodName() + "(" + this.conVar() + "," + this.pkVar() + ");");
                continue;
            }
            if (!this.bean.isClobCmpColumnTypeForField(string)) continue;
            stringBuffer.append(EOL + "if(!" + this.pmVar() + ".perhapsUseSetStringForClobForOracle()){" + EOL);
            stringBuffer.append("// Using 3 step procedure to insert Clob column as the  setStringForClob API is not supported by current driver " + EOL);
            stringBuffer.append(this.setBlobClobForOutputMethodName() + "(" + this.conVar() + "," + this.pkVar() + ");" + EOL);
            stringBuffer.append("}" + EOL);
        }
        return stringBuffer.toString();
    }

    public String setBlobClobForStore() throws CodeGenerationException {
        if (!this.bean.hasBlobClobColumn()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.cmpFieldNames.toArray(new String[0]);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!this.bean.hasCmpColumnType(string) || !this.bean.isBlobCmpColumnTypeForField(string) && !this.bean.isClobCmpColumnTypeForField(string)) continue;
            this.curField = stringArray[i];
            this.curTableName = this.bean.getTableForCmpField(this.curField);
            this.curTableIndex = this.bean.tableIndex(this.curTableName);
            stringBuffer.append(EOL);
            stringBuffer.append("if (" + this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(string) + "]) {" + EOL);
            stringBuffer.append("if(" + this.debugEnabled() + ") " + this.debugSay() + "(\"setting(\"+this+\") '" + string + "' using column \" +" + this.numVar() + " + \". Value is \" + this." + string + ");" + EOL);
            stringBuffer.append(this.setBlobClobForOutputMethodName() + "(" + this.conVar() + "," + this.pkVar() + ");\n");
            stringBuffer.append("}").append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsDeclareBlobClobCountVar() {
        if (this.bean.hasBlobClobColumn()) {
            return "int " + this.blobClobCountVar() + " = 0;";
        }
        return "";
    }

    public String perhapsResetBlobClobCountVar() {
        if (this.bean.hasBlobClobColumn()) {
            return this.blobClobCountVar() + " = 0;";
        }
        return "";
    }

    public String blobClobCountVarOrZero() {
        if (this.bean.hasBlobClobColumn()) {
            return this.blobClobCountVar();
        }
        return "0";
    }

    public String perhapsByteArrayIsSerializedToBlob() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.fieldNameForField();
        Class clazz = this.bean.getCmpFieldClass(string);
        if (ClassUtils.isByteArray(clazz) && !this.bean.getByteArrayIsSerializedToOracleBlob()) {
            stringBuffer.append("byte[] outByteArray = ").append(string).append(";");
            stringBuffer.append(EOL);
        } else {
            stringBuffer.append(this.parse(this.getProductionRule("convertFieldToByteArray")));
        }
        return stringBuffer.toString();
    }

    public String perhapsByteArrayIsDeserializedFromBlob() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.fieldNameForField();
        Class clazz = this.bean.getCmpFieldClass(string);
        if (ClassUtils.isByteArray(clazz) && !this.bean.getByteArrayIsSerializedToOracleBlob()) {
            stringBuffer.append(string + " = inByteArray;");
        } else {
            stringBuffer.append("ByteArrayInputStream bais = new ByteArrayInputStream(inByteArray, 0, length);").append(EOL);
            stringBuffer.append("ObjectInputStream ois = new ObjectInputStream(bais);").append(EOL);
            stringBuffer.append("try {").append(EOL);
            stringBuffer.append(string + " = (" + this.fieldClassForCmpField() + ") ois.readObject();").append(EOL);
            stringBuffer.append("} catch (ClassNotFoundException cnfe) {").append(EOL).append(EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") {").append(EOL);
            stringBuffer.append(this.debugSay() + "(\"ClassNotFoundException for Blob-Clob\" + " + "cnfe.getMessage());").append(EOL);
            stringBuffer.append("}").append(EOL);
            stringBuffer.append("throw cnfe;").append(EOL);
            stringBuffer.append("}").append(EOL);
            stringBuffer.append("bais.close();").append(EOL);
            stringBuffer.append("ois.close();").append(EOL);
        }
        return stringBuffer.toString();
    }

    private boolean useVersionOrTimestampCheckingForBlobClob(String string) {
        return this.bean.hasBlobClobColumn() && this.bd.isOptimistic() && (this.bean.getVerifyColumns(string).equalsIgnoreCase("version") || this.bean.getVerifyColumns(string).equalsIgnoreCase("timestamp"));
    }

    public String setPrimaryKeyParamsArray() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int " + this.numVar() + " = 0;" + EOL);
        for (int i = 0; i < this.bean.tableCount(); ++i) {
            this.curTableIndex = i;
            this.curTableName = this.bean.tableAt(i);
            this.resetParams();
            stringBuffer.append(this.numVar() + " = 1;" + EOL);
            stringBuffer.append(this.setPrimaryKeyParamsUsingNum());
            stringBuffer.append(this.perhapsSetSnapshotParameters());
        }
        return stringBuffer.toString();
    }

    public String setPrimaryKeyParamsForTableIndex(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.pkFieldNames.toArray(new String[0]);
        return this.preparedStatementBindings(stringArray, this.pkVar(), false, this.bd.hasComplexPrimaryKey(), false, false, this.stmtArrayElement(n));
    }

    public String setPrimaryKeyParamsForTableUsingNum(String string) {
        return "whoa..  setPrimaryKeyParamsForTableUsingNum  needs to be implemented";
    }

    public String setPrimaryKeyParams() {
        String[] stringArray = this.pkFieldNames.toArray(new String[0]);
        return this.preparedStatementBindings(stringArray, this.pkVar(), false, this.bd.hasComplexPrimaryKey(), false, false);
    }

    public String setPrimaryKeyParamsUsingNum() {
        String[] stringArray = this.pkFieldNames.toArray(new String[0]);
        return this.preparedStatementBindings(stringArray, this.pkVar(), false, this.bd.hasComplexPrimaryKey(), true, false, this.stmtArrayElement(this.curTableIndex));
    }

    private String preparedStatementBindings(String[] stringArray, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.preparedStatementBindings(stringArray, string, bl, bl2, bl3, bl4, this.stmtVar());
    }

    private String preparedStatementBindings(String[] stringArray, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i];
            String string4 = bl3 ? this.numVar() : String.valueOf(this.preparedStatementParamIndex);
            this.addPreparedStatementBinding(stringBuffer, string3, string, string4, bl, bl2, bl4 && !this.bd.getPrimaryKeyFieldNames().contains(string3), false, string2);
            if (bl3) {
                stringBuffer.append(this.numVar() + "++;" + EOL);
            } else {
                ++this.preparedStatementParamIndex;
            }
            if (i >= n - 1) continue;
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    private void addPreparedStatementBinding(StringBuffer stringBuffer, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.addPreparedStatementBinding(stringBuffer, string, string2, string3, bl, bl2, bl3, bl4, this.stmtVar());
    }

    private void addPreparedStatementBinding(StringBuffer stringBuffer, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string4) {
        if (this.bean.isClobCmpColumnTypeForField(string) && this.bean.getDatabaseType() == 1) {
            stringBuffer.append("// Clob column " + string + " is already binded in " + "PreparedStatement as first variable, but we still need to increment " + "local variable to keep correct indexing." + EOL);
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("Adding a prepared statement binding: ");
            RDBMSCodeGenerator.debug("\t\tfield = " + string);
            RDBMSCodeGenerator.debug("\t\tobj = " + string2);
            RDBMSCodeGenerator.debug("\t\tparamIdx = " + string3);
            RDBMSCodeGenerator.debug("\t\tobjIsCompound = " + bl2);
        }
        String string5 = null;
        string5 = bl && this.bean.hasCmpField(string) ? this.getCmpField(string2, string) : (bl2 ? string2 + "." + string : string2);
        Class clazz = this.getVariableClass(string);
        assert (clazz != null);
        if (!clazz.isPrimitive()) {
            this.addNullCheck(stringBuffer, string5, string, string3, string4);
        }
        this.preparedStatementBindingBody(stringBuffer, string2, string, clazz, string3, bl, bl2, bl3, bl4, RDBMSUtils.isOracleNLSDataType(this.bean, string), string4);
        if (!clazz.isPrimitive()) {
            stringBuffer.append("}" + EOL);
            if (bl3 && this.doSnapshot(string) && !this.bean.isClobCmpColumnTypeForField(string) && !this.bean.isBlobCmpColumnTypeForField(string)) {
                stringBuffer.append("else {" + EOL);
                stringBuffer.append(string2 + "." + CodeGenUtils.snapshotNameForVar(string) + " = null;" + EOL);
                stringBuffer.append("}" + EOL);
            }
        }
    }

    private void preparedStatementBindingBody(StringBuffer stringBuffer, String string, String string2, Class clazz, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.preparedStatementBindingBody(stringBuffer, string, string2, clazz, string3, bl, bl2, bl3, bl4, bl5, this.stmtVar());
    }

    private void preparedStatementBindingBody(StringBuffer stringBuffer, String string, String string2, Class clazz, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string4) {
        String string5 = this.bean.getCmpColumnTypeForField(string2);
        if (this.bean.hasCmpColumnType(string2) && (string5.equalsIgnoreCase("Blob") || string5.equalsIgnoreCase("Clob")) && this.bean.getDatabaseType() == 1) {
            stringBuffer.append("  ");
            return;
        }
        boolean bl6 = bl && !this.bd.isBeanClassAbstract() && this.bean.hasCmpField(string2);
        String string6 = null;
        string6 = bl6 ? string + "." + "__WL_super_" + MethodUtils.getMethodName(string2) + "()" : (bl2 ? string + "." + string2 : string);
        boolean bl7 = this.bean.isCharArrayMappedToString(clazz);
        if (bl7) {
            clazz = Character.TYPE;
        }
        if (!this.bean.isValidSQLType(clazz)) {
            stringBuffer.append("ByteArrayOutputStream bstr = new ByteArrayOutputStream();" + EOL);
            stringBuffer.append("ObjectOutputStream ostr = new ObjectOutputStream(bstr);" + EOL);
            if (EJBHome.class.isAssignableFrom(clazz)) {
                stringBuffer.append("HomeHandle handle = " + string6 + ".getHomeHandle();" + EOL);
                stringBuffer.append("ostr.writeObject(handle);" + EOL);
            } else if (EJBObject.class.isAssignableFrom(clazz)) {
                stringBuffer.append("Handle handle = " + string6 + ".getHandle();" + EOL);
                stringBuffer.append("ostr.writeObject(handle);" + EOL);
            } else {
                stringBuffer.append("ostr.writeObject(" + string6 + ");" + EOL);
            }
            String string7 = null;
            if (bl4) {
                string7 = this.byteArrayVar(string2);
            } else {
                string7 = "byteArray";
                stringBuffer.append("byte[] ");
            }
            stringBuffer.append(string7 + " = bstr.toByteArray();" + EOL);
            stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"writing bytes: \" + " + string7 + ");" + EOL);
            stringBuffer.append("if (" + string7 + "!=null) {" + EOL);
            stringBuffer.append(this.debugSay() + "(\"bytes length: \" + " + string7 + ".length);" + EOL);
            stringBuffer.append("}" + EOL);
            stringBuffer.append("}" + EOL);
            if (bl3 && this.doSnapshot(string2) && !this.bean.isBlobCmpColumnTypeForField(string2)) {
                stringBuffer.append(string + "." + CodeGenUtils.snapshotNameForVar(string2) + " = " + string7 + ";" + EOL);
            }
            if ("SybaseBinary".equalsIgnoreCase(this.bean.getCmpColumnTypeForField(string2)) || this.perhapsSybaseBinarySetForAnyCmpField()) {
                stringBuffer.append(string4 + ".setBytes(" + string3 + "," + string7 + ");" + EOL);
            } else {
                stringBuffer.append("InputStream inputStream  = new ByteArrayInputStream(" + string7 + ");" + EOL);
                stringBuffer.append(string4 + ".setBinaryStream(" + string3 + ", inputStream, " + string7 + ".length);" + EOL);
            }
        } else {
            if (bl3 && this.doSnapshot(string2)) {
                stringBuffer.append(this.takeSnapshotForVar(string, string2, bl6));
            }
            if (ClassUtils.isByteArray(clazz)) {
                if ("SybaseBinary".equalsIgnoreCase(this.bean.getCmpColumnTypeForField(string2)) || this.perhapsSybaseBinarySetForAnyCmpField()) {
                    stringBuffer.append(string4 + ".setBytes(" + string3 + "," + string6 + ");" + EOL);
                } else {
                    stringBuffer.append("InputStream inputStream  = new ByteArrayInputStream(" + string6 + ");" + EOL);
                    stringBuffer.append(string4 + ".setBinaryStream(" + string3 + ", inputStream, " + string6 + ".length);" + EOL);
                }
            } else {
                String string8 = StatementBinder.getStatementTypeNameForClass(clazz);
                if (String.class.equals(clazz) && "LongString".equals(this.bean.getCmpColumnTypeForField(string2))) {
                    stringBuffer.append("java.io.StringReader stringReader  = new java.io.StringReader(" + string6 + ");" + EOL);
                    stringBuffer.append(string4 + ".setCharacterStream(" + string3 + ", stringReader, " + string6 + ".length());" + EOL);
                } else if (String.class.equals(clazz) && "SQLXML".equals(this.bean.getCmpColumnTypeForField(string2))) {
                    stringBuffer.append("java.sql.SQLXML sqlXml  = " + string4 + ".getConnection().createSQLXML();" + EOL);
                    stringBuffer.append("sqlXml.setString(" + string6 + ");" + EOL);
                    stringBuffer.append(string4 + ".setSQLXML(" + string3 + ", sqlXml);" + EOL);
                } else {
                    if (bl5) {
                        stringBuffer.append("if(").append(string4).append(" instanceof oracle.jdbc.OraclePreparedStatement) {" + EOL);
                        stringBuffer.append("((oracle.jdbc.OraclePreparedStatement)").append(string4).append(").setFormOfUse(").append(string3).append(", oracle.jdbc.OraclePreparedStatement.FORM_NCHAR);").append(EOL);
                        stringBuffer.append("}" + EOL);
                    }
                    stringBuffer.append(string4);
                    stringBuffer.append(".set" + string8 + "(");
                    stringBuffer.append(string3).append(", ");
                    if (bl2) {
                        if (clazz == Character.TYPE) {
                            if (bl7) {
                                stringBuffer.append("new String(" + string6 + ")");
                            } else {
                                stringBuffer.append("String.valueOf(" + string6 + ")");
                            }
                        } else if (clazz == Character.class) {
                            stringBuffer.append("String.valueOf(" + string6 + ".charValue())");
                        } else if (clazz == java.util.Date.class) {
                            stringBuffer.append("new java.sql.Timestamp(");
                            stringBuffer.append(string6);
                            stringBuffer.append(".getTime())");
                        } else {
                            stringBuffer.append(MethodUtils.convertToPrimitive(clazz, string6));
                        }
                    } else if (clazz == Character.TYPE) {
                        if (bl7) {
                            stringBuffer.append("new String(" + string + ")");
                        } else {
                            stringBuffer.append("String.valueOf(" + string + ")");
                        }
                    } else if (clazz == Character.class) {
                        stringBuffer.append("String.valueOf(" + string + ".charValue())");
                    } else if (clazz == java.util.Date.class) {
                        stringBuffer.append("new java.sql.Timestamp(");
                        stringBuffer.append(string + ".getTime())");
                    } else {
                        stringBuffer.append(MethodUtils.convertToPrimitive(clazz, string));
                    }
                    stringBuffer.append(");" + EOL);
                }
                stringBuffer.append("if (" + this.debugEnabled() + ") {" + EOL);
                stringBuffer.append(this.debugSay() + "(\"paramIdx :\"+" + string3 + "+\" binded with value :\"+" + string6 + ");" + EOL);
                stringBuffer.append("}" + EOL);
            }
        }
    }

    private boolean perhapsSybaseBinarySetForAnyCmpField() {
        boolean bl = false;
        List list = this.bean.getCmpFieldNames();
        for (String string : list) {
            if (!"SybaseBinary".equalsIgnoreCase(this.bean.getCmpColumnTypeForField(string))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String setUpdateBeanParams() throws CodeGenerationException {
        String string;
        String[] stringArray = this.cmpFieldNames.toArray(new String[0]);
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.bean.getForeignKeyFieldNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.bean.isBlobCmpColumnTypeForField(stringArray[i]) || this.bean.isClobCmpColumnTypeForField(stringArray[i]) || this.bd.getPrimaryKeyFieldNames().contains(stringArray[i])) continue;
            int n = this.bean.getTableIndexForCmpField(stringArray[i]);
            assert (n >= 0);
            if (n != this.curTableIndex) continue;
            String string2 = this.bean.getTableForCmpField(stringArray[i]);
            string = this.bean.getColumnForCmpFieldAndTable(stringArray[i], string2);
            if (this.bean.hasOptimisticColumn(string2) && this.bean.getOptimisticColumn(string2).equals(string)) continue;
            Object object = "";
            if (list != null) {
                String string32 = null;
                for (String string32 : list) {
                    if (!this.bean.getForeignKeyColNames(string32).contains(string)) continue;
                    object = this.perhapsIsFkColsNullableCheck(string32);
                    break;
                }
            }
            stringBuffer.append("if (" + this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(stringArray[i]) + "] " + (String)object + ") {" + EOL);
            stringBuffer.append("if(" + this.debugEnabled() + ") " + this.debugSay() + "(\"setting(\"+this+\") '" + stringArray[i] + "' using column \" +" + this.numVar() + " + \". Value is \" +" + this.getCmpField(stringArray[i]) + ");" + EOL);
            this.addPreparedStatementBinding(stringBuffer, stringArray[i], "this", this.numVar(), true, true, false, !this.bd.getPrimaryKeyFieldNames().contains(stringArray[i]), this.stmtArrayElement(this.curTableIndex));
            stringBuffer.append(this.numVar() + "++;" + EOL);
            stringBuffer.append("};" + EOL + EOL);
        }
        for (String string4 : this.bean.getForeignKeyFieldNames()) {
            if (!this.bean.containsFkField(string4) || this.bean.isForeignCmpField(string4)) continue;
            int n = this.bean.getTableIndexForCmrf(string4);
            Debug.assertion((n >= 0 ? 1 : 0) != 0);
            if (n != this.curTableIndex) continue;
            string = this.bean.getTableForCmrField(string4);
            for (String string32 : this.bean.getForeignKeyColNames(string4)) {
                String string5 = this.bean.variableForField(string4, string, string32);
                stringBuffer.append("if (" + this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(string4) + "]" + this.perhapsIsFkColsNullableCheck(string4) + ") {" + EOL);
                stringBuffer.append("if(" + this.debugEnabled() + ") " + this.debugSay() + "(\"setting(\"+this+\") '" + (String)string5 + "' using column \" +" + this.numVar() + " + \". Value is \" + this." + (String)string5 + ");" + EOL);
                this.addPreparedStatementBinding(stringBuffer, string5, "this", this.numVar(), true, true, false, true, this.stmtArrayElement(this.curTableIndex));
                stringBuffer.append(this.numVar() + "++;" + EOL);
                stringBuffer.append("};" + EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String perhapsVerifyOptimistic() {
        assert (this.curGroup != null);
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.bean.getTableNamesForGroup(this.curGroup.getName());
        for (String string : set) {
            if (!this.bean.hasOptimisticColumn(string) || !this.bean.getTriggerUpdatesOptimisticColumn(string)) continue;
            String string2 = this.bean.getOptimisticColumn(string);
            String string3 = this.bean.getCmpField(string, string2);
            stringBuffer.append("if (this.");
            stringBuffer.append(string3);
            stringBuffer.append(" == null) {");
            stringBuffer.append(EOL);
            stringBuffer.append("Loggable l = EJBLogger.logoptimisticColumnIsNullLoggable(\"");
            stringBuffer.append(this.bean.getEjbName());
            stringBuffer.append("\", \"");
            stringBuffer.append(string);
            stringBuffer.append("\", \"");
            stringBuffer.append(string2);
            stringBuffer.append("\");");
            stringBuffer.append(EOL);
            stringBuffer.append("throw new EJBException(l.getMessage());");
            stringBuffer.append(EOL);
            stringBuffer.append("}");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsSetOptimisticColumnParam() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.bean.tableAt(this.curTableIndex);
        if (this.bean.hasOptimisticColumn(string) && !this.bean.getTriggerUpdatesOptimisticColumn(string)) {
            String string2 = this.bean.getOptimisticColumn(string);
            String string3 = this.bean.getCmpField(string, string2);
            stringBuffer.append("if (" + this.isModifiedVar() + "[" + this.bean.getIsModifiedIndex(string3) + "]) {" + EOL);
            stringBuffer.append("if(" + this.debugEnabled() + ") " + this.debugSay() + "(\"setting(\"+this+\") '" + string3 + "' using column \" +" + this.numVar() + " + \". Value is \" + " + this.getCmpField(string3) + ");" + EOL);
            this.addPreparedStatementBinding(stringBuffer, string3, "this", this.numVar(), true, true, false, !this.bd.getPrimaryKeyFieldNames().contains(string3), this.stmtArrayElement(this.curTableIndex));
            stringBuffer.append(this.numVar() + "++;" + EOL);
            stringBuffer.append("};" + EOL + EOL);
        }
        return stringBuffer.toString();
    }

    public String assignGroupColumnsToThis() throws CodeGenerationException {
        return this.assignGroupColumns("this", false);
    }

    public String assignGroupColumnsToBean() throws CodeGenerationException {
        return this.assignGroupColumns(this.beanVar(), true);
    }

    public String assignGroupColumns(String string, boolean bl) throws CodeGenerationException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        if (bl) {
            arrayList.addAll(this.bd.getPrimaryKeyFieldNames());
            stringBuffer.append("if (" + this.pkVar() + " == null) {" + EOL);
            this.assignToVars(stringBuffer, string, true, arrayList, 1, true);
            stringBuffer.append("} else {" + EOL);
            stringBuffer.append(this.beanVar() + ".__WL_setPrimaryKey((" + this.pk_class() + ") " + this.pkVar() + ");" + EOL);
            stringBuffer.append("}" + EOL);
        }
        TreeSet treeSet2 = new TreeSet(this.curGroup.getCmpFields());
        for (Object object : treeSet2) {
            if (arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        treeSet.addAll(arrayList);
        for (String iterator : treeSet) {
            hashSet.add(this.bean.getCmpColumnForField(iterator));
        }
        for (String string3 : this.curGroup.getCmrFields()) {
            string2 = this.bean.getTableForCmrField(string3);
            for (String string4 : this.bean.getForeignKeyColNames(string3)) {
                if (hashSet.contains(string4)) continue;
                arrayList.add(this.bean.variableForField(string3, string2, string4));
            }
        }
        if (bl) {
            arrayList.removeAll(this.bd.getPrimaryKeyFieldNames());
            this.assignToVars(stringBuffer, string, true, arrayList, 1 + this.bd.getPrimaryKeyFieldNames().size(), true);
        } else {
            this.assignToVars(stringBuffer, string, true, arrayList, 1, true);
        }
        for (String string5 : treeSet) {
            stringBuffer.append(string + "." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string5) + "]");
            stringBuffer.append(" = true;" + EOL);
        }
        for (String string6 : this.curGroup.getCmrFields()) {
            String string4;
            string2 = this.bean.getTableForCmrField(string6);
            String string7 = (String)this.bean.getForeignKeyColNames(string6).iterator().next();
            if (hashSet.contains(string7)) continue;
            string4 = this.bean.variableForField(string6, string2, string7);
            stringBuffer.append(string + "." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex((String)this.variableToField.get(string4)) + "]");
            stringBuffer.append(" = true;" + EOL);
        }
        stringBuffer.append(string + "." + this.beanIsLoadedVar() + " = true;");
        return stringBuffer.toString();
    }

    public String assignCMRFieldFKColumns(String string, String string2) throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = this.bean.getTableForCmrField(string2);
        for (Object object : this.bean.getForeignKeyColNames(string2)) {
            arrayList.add(this.bean.variableForField(string2, string3, (String)object));
        }
        this.assignToVars(stringBuffer, string, true, arrayList, 1, true);
        for (String string4 : arrayList) {
            if (this.bean.getIsModifiedIndex(string4) != null) {
                stringBuffer.append(string + "." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string4) + "]");
            } else {
                stringBuffer.append(string + "." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string2) + "]");
            }
            stringBuffer.append(" = true;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String assignCMRFieldPKColumns(String string) throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.bd.getPrimaryKeyFieldNames());
        this.assignToVars(stringBuffer, string, true, arrayList, 1, true);
        for (String string2 : arrayList) {
            stringBuffer.append(string + "." + this.isLoadedVar() + "[" + this.bean.getIsModifiedIndex(string2) + "]");
            stringBuffer.append(" = true;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String allFieldsCount() {
        return String.valueOf(this.bean.getFieldCount());
    }

    public String refresh_bean_from_key() {
        if (this.isContainerManagedBean) {
            return "loadByPrimaryKey(ctx);";
        }
        return "((" + this.ejbClass.getName() + ")(ctx.getBean())).ejbFindByPrimaryKey(pk);";
    }

    public String home_methods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (this.homeMethods != null) {
            for (int i = 0; i < this.homeMethods.length; ++i) {
                try {
                    String string = null;
                    string = this.homeToBeanName("ejbHome", this.homeMethods[i].getName());
                    Method method = this.ejbClass.getMethod(string, this.homeMethods[i].getParameterTypes());
                    this.setMethod(method, (short)0);
                    stringBuffer.append(this.parse(this.getProductionRule("home_method")));
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)noSuchMethodException);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String homeToBeanName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string + string2);
        stringBuffer.setCharAt(string.length(), Character.toUpperCase(stringBuffer.charAt(string.length())));
        return stringBuffer.toString();
    }

    public String getEJBObject() {
        if (this.bd.hasLocalClientView() || this.bd.isEJB30()) {
            return "getEJBLocalObject";
        }
        return "getEJBObject";
    }

    public String EJBObjectForField() {
        assert (this.curField != null);
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        if (cMPBeanDescriptor.hasLocalClientView() || this.bd.isEJB30()) {
            return "javax.ejb.EJBLocalObject";
        }
        return "javax.ejb.EJBObject";
    }

    public String findByPrimaryKeyForField() {
        assert (this.curField != null);
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        if (cMPBeanDescriptor.hasLocalClientView() || cMPBeanDescriptor.isEJB30()) {
            return "localFindByPrimaryKey";
        }
        return "remoteFindByPrimaryKey";
    }

    public String scalarFinderForField() {
        assert (this.curField != null);
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        if (cMPBeanDescriptor.hasLocalClientView() || this.bd.isEJB30()) {
            return "localScalarFinder";
        }
        return "remoteScalarFinder";
    }

    public String scalarFinder(Finder finder) {
        RDBMSBean rDBMSBean = finder.getSelectBeanTarget();
        CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
        if (finder.hasLocalResultType()) {
            if (cMPBeanDescriptor.hasLocalClientView() || this.bd.isEJB30()) {
                return "localScalarFinder";
            }
            return "remoteScalarFinder";
        }
        assert (cMPBeanDescriptor.hasRemoteClientView());
        return "remoteScalarFinder";
    }

    public String collectionFinder(Finder finder) {
        RDBMSBean rDBMSBean = finder.getSelectBeanTarget();
        CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
        if (finder.hasLocalResultType()) {
            if (cMPBeanDescriptor.hasLocalClientView() || this.bd.isEJB30()) {
                return "localCollectionFinder";
            }
            return "remoteCollectionFinder";
        }
        assert (cMPBeanDescriptor.hasRemoteClientView());
        return "remoteCollectionFinder";
    }

    public String setFinder(Finder finder) {
        RDBMSBean rDBMSBean = finder.getSelectBeanTarget();
        CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
        if (finder.hasLocalResultType()) {
            if (cMPBeanDescriptor.hasLocalClientView() || this.bd.isEJB30()) {
                return "localSetFinder";
            }
            return "remoteSetFinder";
        }
        assert (cMPBeanDescriptor.hasRemoteClientView());
        return "remoteSetFinder";
    }

    public String registerInvalidationBean() {
        EntityBeanInfo entityBeanInfo = this.bi;
        StringBuffer stringBuffer = new StringBuffer();
        if (entityBeanInfo.getInvalidationTargetEJBName() != null) {
            stringBuffer.append(this.pmVar() + ".registerModifiedBean(" + this.ctxVar() + ".getPrimaryKey());" + EOL);
        }
        return stringBuffer.toString();
    }

    public String readOnlyFinderOneToOneGetterBody() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        StringBuffer stringBuffer = new StringBuffer();
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            stringBuffer.append("TransactionManager tms = TxHelper.getTransactionManager();\n");
            stringBuffer.append("tms.suspend();\n");
            stringBuffer.append("tms.begin();\n");
            stringBuffer.append("Transaction tx = tms.getTransaction();\n");
            stringBuffer.append("try { " + EOL);
        }
        stringBuffer.append(this.fieldVarForField() + " = (" + this.classNameForField() + ")" + this.bmVarForField() + "." + this.scalarFinderForField() + "(\n");
        stringBuffer.append(this.finderVarForField() + ",new Object[]{" + this.ctxVar() + ".getPrimaryKey()});\n");
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            stringBuffer.append("} finally { " + EOL);
            stringBuffer.append("// Dont need to worry for rollback call etc, " + EOL);
            stringBuffer.append("// as this is readonly tx and this is used only for a finder call. " + EOL);
            stringBuffer.append("tx.commit();\n");
            stringBuffer.append("} " + EOL);
        }
        return stringBuffer.toString();
    }

    public String readOnlyOneToOneGetterBody_fkOwner() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        StringBuffer stringBuffer = new StringBuffer();
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            stringBuffer.append("TransactionManager tms = TxHelper.getTransactionManager();\n");
            stringBuffer.append("tms.suspend();\n");
            stringBuffer.append("tms.begin();\n");
            stringBuffer.append("Transaction tx = tms.getTransaction();\n");
            stringBuffer.append("try { " + EOL);
        }
        stringBuffer.append(this.fieldVarForField() + " = (" + this.classNameForField() + ")" + this.finderInvokerForField() + "." + this.findByPrimaryKeyForField() + "(\n");
        stringBuffer.append(this.finderParamForField() + this.fkVarForField() + ");\n");
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            stringBuffer.append("} finally { " + EOL);
            stringBuffer.append("// Dont need to worry for rollback call etc, " + EOL);
            stringBuffer.append("// as this is readonly tx and this is used only for a finder call. " + EOL);
            stringBuffer.append("tx.commit();\n");
            stringBuffer.append("} " + EOL);
        }
        return stringBuffer.toString();
    }

    public String readOnlyOneToManyGetterBody_fkOwner() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        StringBuffer stringBuffer = new StringBuffer();
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            stringBuffer.append("TransactionManager tms = TxHelper.getTransactionManager();" + EOL);
            stringBuffer.append("tms.suspend();" + EOL);
            stringBuffer.append("tms.begin();" + EOL);
            stringBuffer.append("Transaction tx = tms.getTransaction();" + EOL);
            stringBuffer.append("try { " + EOL);
        }
        stringBuffer.append(this.fieldVarForField() + " = (" + this.classNameForField() + ")" + this.finderInvokerForField() + "." + this.findByPrimaryKeyForField() + "(" + EOL);
        stringBuffer.append(this.finderParamForField() + this.fkVarForField() + ");" + EOL);
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            stringBuffer.append("} finally { " + EOL);
            stringBuffer.append("// Dont need to worry for rollback call etc, " + EOL);
            stringBuffer.append("// as this is readonly tx and this is used only for a finder call. " + EOL);
            stringBuffer.append("tx.commit(); " + EOL);
            stringBuffer.append("} " + EOL);
        }
        return stringBuffer.toString();
    }

    public String readOnlyResumeTx() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        if (cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TxHelper.getTransactionManager().resume(orgTx);\n");
            return stringBuffer.toString();
        }
        return "";
    }

    public String preReadOnlyStateChange() {
        if (this.bd.isReadOnly()) {
            return "synchronized(this) {" + EOL;
        }
        return "";
    }

    public String postReadOnlyStateChange() {
        if (this.bd.isReadOnly()) {
            return "}" + EOL;
        }
        return "";
    }

    public String perhapsUpdateLastLoadTimeDueToEJBStore() {
        EntityBeanInfo entityBeanInfo = this.bi;
        if (entityBeanInfo.isOptimistic() && entityBeanInfo.getCacheBetweenTransactions()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("else {");
            stringBuffer.append(EOL);
            stringBuffer.append("  __WL_setLastLoadTime(System.currentTimeMillis());");
            stringBuffer.append(EOL);
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            return stringBuffer.toString();
        }
        return "";
    }

    public String perhapsUpdateLastLoadTime() {
        EntityBeanInfo entityBeanInfo = this.bi;
        if (entityBeanInfo.isReadOnly() || entityBeanInfo.isOptimistic() && entityBeanInfo.getCacheBetweenTransactions()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("if(!__WL_beanIsLoaded()) {");
            stringBuffer.append(EOL);
            stringBuffer.append("  __WL_setLastLoadTime(System.currentTimeMillis());");
            stringBuffer.append(EOL);
            stringBuffer.append("}");
            stringBuffer.append(EOL);
            return stringBuffer.toString();
        }
        return "";
    }

    public String isReadOnly() {
        CMPBeanDescriptor cMPBeanDescriptor = this.bean.getRelatedDescriptor(this.curField);
        if (cMPBeanDescriptor.isReadOnly() || cMPBeanDescriptor.getConcurrencyStrategy() == 4) {
            return "true";
        }
        return "false";
    }

    public String declare_bean_interface_methods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(super.declare_bean_interface_methods());
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.bean.getCmrFieldNames());
        arrayList.removeAll(this.bean.getDeclaredFieldNames());
        stringBuffer.append(this.declareCmrVariableGetterMethods(arrayList));
        stringBuffer.append(this.declareCmrVariableSetterMethods(arrayList));
        stringBuffer.append(this.declareRelationshipFinderMethods());
        stringBuffer.append(this.declareRelationshipSelectMethods());
        stringBuffer.append("public Object ");
        stringBuffer.append(this.getPKFromRSMethodName());
        stringBuffer.append("Instance(java.sql.ResultSet rs, java.lang.Integer offset, ClassLoader cl)");
        stringBuffer.append(EOL);
        stringBuffer.append("throws java.sql.SQLException, java.lang.Exception;");
        stringBuffer.append(EOL);
        for (FieldGroup this.curGroup : this.bean.getFieldGroups()) {
            stringBuffer.append("public void ");
            stringBuffer.append(this.loadGroupFromRSMethodName(this.curGroup));
            stringBuffer.append(EOL);
            stringBuffer.append("(java.sql.ResultSet rs, java.lang.Integer offset, ");
            stringBuffer.append("Object " + this.pkVar() + ", ");
            stringBuffer.append(this.getGeneratedBeanInterfaceName());
            stringBuffer.append(" var) ");
            stringBuffer.append(EOL);
            stringBuffer.append("throws java.sql.SQLException, java.lang.Exception;");
            stringBuffer.append(EOL);
        }
        for (Object object : this.bean.getAllCmrFields()) {
            stringBuffer.append("public void " + this.loadCMRFieldFromRSMethodName((String)object) + EOL + "(java.sql.ResultSet rs, java.lang.Integer offset, " + this.getGeneratedBeanInterfaceName() + " var) " + EOL);
            stringBuffer.append("throws java.sql.SQLException, java.lang.Exception;" + EOL);
        }
        stringBuffer.append("public boolean ");
        stringBuffer.append(this.existsMethodName());
        stringBuffer.append("(Object key);");
        stringBuffer.append(EOL);
        stringBuffer.append("public boolean __WL_beanIsLoaded();");
        stringBuffer.append(EOL);
        for (Finder finder : this.finderList) {
            if (finder.getQueryType() != 0 || !(finder instanceof EjbqlFinder)) continue;
            stringBuffer.append(MethodUtils.getFinderMethodDeclaration(finder, this.bd.getPrimaryKeyClass()));
            stringBuffer.append(";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String declareRelationshipSelectMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Finder finder : this.ejbSelectInternalList) {
            if (finder.getQueryType() != 4 && finder.getQueryType() != 2) continue;
            stringBuffer.append(MethodUtils.getEjbSelectInternalMethodDeclaration(finder, this.bd.getPrimaryKeyClass()));
            stringBuffer.append(";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String declareRelationshipFinderMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bean.getRelationFinders();
        while (iterator.hasNext()) {
            Finder finder = (Finder)iterator.next();
            if (finder.getQueryType() != 0) continue;
            stringBuffer.append(MethodUtils.getFinderMethodDeclaration(finder, this.bd.getPrimaryKeyClass()));
            stringBuffer.append(";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String declareCmrVariableGetterMethods(List list) throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curField : list) {
            Class clazz = this.bean.getCmrFieldClass(this.curField);
            String string = ClassUtils.classToJavaSourceType(clazz);
            stringBuffer.append("public ");
            stringBuffer.append(string + " ");
            stringBuffer.append(this.getMethodNameForField());
            stringBuffer.append("();");
            stringBuffer.append(EOL);
        }
        for (String string : this.bean.getForeignKeyFieldNames()) {
            if (!this.bean.isOneToManyRelation(string) || this.bean.isRemoteField(string)) continue;
            this.curField = string;
            String string2 = this.bean.getTableForCmrField(string);
            for (String string3 : this.bean.getForeignKeyColNames(string)) {
                if (this.bean.hasCmpField(string2, string3)) continue;
                String string4 = this.bean.variableForField(string, string2, string3);
                Class clazz = this.bean.getForeignKeyColClass(string, string3);
                String string5 = ClassUtils.classToJavaSourceType(clazz);
                stringBuffer.append("public ");
                stringBuffer.append(string5 + " ");
                stringBuffer.append(MethodUtils.getMethodName(string4));
                stringBuffer.append("();" + EOL);
            }
            this.curField = null;
        }
        return stringBuffer.toString();
    }

    public String declareCmrVariableSetterMethods(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String this.curField : this.bean.getCmrFieldNames()) {
            Class clazz = this.bean.getCmrFieldClass(this.curField);
            String string = ClassUtils.classToJavaSourceType(clazz);
            if (this.bean.isOneToManyRelation(this.curField)) {
                stringBuffer.append("public void ");
                stringBuffer.append(CodeGenUtils.cacheRelationshipMethodName(this.curField));
                stringBuffer.append("(Object obj);");
                if (list.contains(this.curField)) {
                    stringBuffer.append("public void ");
                    stringBuffer.append(this.setMethodNameForField());
                    stringBuffer.append("(");
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                    stringBuffer.append(this.curField);
                    stringBuffer.append(");");
                    stringBuffer.append(EOL);
                }
                if (!this.bean.getRelatedMultiplicity(this.curField).equals("One")) continue;
                stringBuffer.append("public void ");
                stringBuffer.append(this.varPrefix() + this.setMethodNameForField());
                stringBuffer.append("(");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(this.curField);
                stringBuffer.append(", boolean ejbStore");
                stringBuffer.append(", boolean remove);");
                stringBuffer.append(EOL);
                continue;
            }
            if (!this.bean.isOneToOneRelation(this.curField)) continue;
            stringBuffer.append("public void ");
            stringBuffer.append(this.doSetMethodNameForField());
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.curField);
            stringBuffer.append(");");
            stringBuffer.append(EOL);
            stringBuffer.append("public void ");
            stringBuffer.append(this.setRestMethodNameForField());
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.curField);
            stringBuffer.append(", int methodState);");
            stringBuffer.append(EOL);
            stringBuffer.append("public void ");
            stringBuffer.append(MethodUtils.setCmrIsLoadedMethodName(this.curField));
            stringBuffer.append("(boolean b);");
            stringBuffer.append(EOL);
            stringBuffer.append("public void ");
            stringBuffer.append(CodeGenUtils.cacheRelationshipMethodName(this.curField));
            stringBuffer.append("(Object obj);");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String doPreparedStmtBindingForClob(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        String string4 = null;
        string4 = bl ? string2 + "." + string : string2;
        bl3 = bl3 && !this.bd.getPrimaryKeyFieldNames().contains(string);
        Class clazz = this.getVariableClass(string);
        if (!clazz.isPrimitive()) {
            this.addNullCheck(stringBuffer, string4, string, "" + n, string3);
        }
        stringBuffer.append("    if (" + this.debugEnabled() + ") {" + EOL);
        stringBuffer.append("      Debug.say(\"Adding a prepared statement binding: \");" + EOL);
        stringBuffer.append("      Debug.say(\"\\t\\tfield = \" +" + string + ");" + EOL);
        stringBuffer.append("      Debug.say(\"\\t\\tobj = \" +" + string2 + ");" + EOL);
        stringBuffer.append("      Debug.say(\"\\t\\tparamIdx = \" +" + n + ");" + EOL);
        stringBuffer.append("      Debug.say(\"\\t\\tobjIsCompound = \" +" + bl + ");" + EOL);
        stringBuffer.append("    }" + EOL);
        if (debugLogger.isDebugEnabled()) {
            Debug.assertion((clazz != null ? 1 : 0) != 0);
        }
        if (this.bean.isNClobCmpColumnTypeForField(string)) {
            stringBuffer.append("    if(" + string3 + " instanceof oracle.jdbc.OraclePreparedStatement) {" + EOL);
            stringBuffer.append("      ((oracle.jdbc.OraclePreparedStatement)" + string3 + ").setFormOfUse(" + n + ", oracle.jdbc.OraclePreparedStatement.FORM_NCHAR);" + EOL);
            stringBuffer.append("    }" + EOL);
        }
        stringBuffer.append("      java.lang.reflect.Method[] meths = " + string3 + ".getClass().getMethods();\n");
        stringBuffer.append("      java.lang.reflect.Method meth = null;\n");
        stringBuffer.append("      for (int i = 0; i < meths.length; i++) {\n");
        stringBuffer.append("        if (meths[i].getName().equalsIgnoreCase(\"setStringForClob\"))\n");
        stringBuffer.append("        {\n" + EOL);
        stringBuffer.append("          meth = meths[i];\n");
        stringBuffer.append("          break;\n");
        stringBuffer.append("        }\n");
        stringBuffer.append("      }\n");
        stringBuffer.append("      if (meth != null) {\n");
        stringBuffer.append("        meth.invoke(" + string3 + ", new Object[]{ Integer.valueOf(\"" + n + "\") , " + string4 + " });\n");
        stringBuffer.append("      }\n");
        if (!clazz.isPrimitive()) {
            stringBuffer.append("}" + EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsDeclareQueryCachingVars() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.shouldImplementQueryCaching(this.curFinder)) {
            stringBuffer.append("QueryCacheKey ").append(this.queryCacheKeyVar());
            stringBuffer.append(" = new QueryCacheKey(\"");
            stringBuffer.append(this.curFinder.getFinderIndex()).append("\", new Object[] {");
            stringBuffer.append(this.getParametersAsArray(this.curFinder)).append("}, ");
            stringBuffer.append("(TTLManager)").append(this.pmVar()).append(".getBeanManager(), ");
            if (Collection.class.isAssignableFrom(this.curFinder.getReturnClassType())) {
                stringBuffer.append("QueryCacheKey.RET_TYPE_COLLECTION);").append(EOL);
            } else {
                stringBuffer.append("QueryCacheKey.RET_TYPE_SINGLETON);").append(EOL);
            }
            if (this.curFinder.isMultiFinder()) {
                stringBuffer.append("    Collection ").append(this.queryCacheElementsVar());
                stringBuffer.append(" = new ArrayList();").append(EOL);
            } else {
                stringBuffer.append("    QueryCacheElement ").append(this.queryCacheElementsVar());
                stringBuffer.append(" = null;").append(EOL);
            }
        }
        if (bl = this.isRelationshipCaching(this.curFinder)) {
            stringBuffer.append("MultiMap ").append(this.beanMapVar()).append(" = ");
            stringBuffer.append("null;").append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhapsPutInQueryCache() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.isRelationshipCaching(this.curFinder);
        if (this.currFinderLoadsQueryCachingEnabledCMRFields) {
            stringBuffer.append("Iterator iterator = ").append(this.beanMapVar());
            stringBuffer.append(".keySet().iterator();").append(EOL);
            stringBuffer.append("while (iterator.hasNext()) {").append(EOL);
            stringBuffer.append("CMPBean __WL_relBean = (CMPBean)iterator.next();").append(EOL);
            stringBuffer.append("List list = ").append(this.beanMapVar()).append(".get(__WL_relBean);");
            stringBuffer.append(EOL);
            stringBuffer.append("for (int i=0; i<list.size(); i++) {").append(EOL);
            stringBuffer.append("__WL_relBean.").append(this.cmrFieldQueryCachingMethodName());
            if (this.shouldImplementQueryCaching(this.curFinder)) {
                stringBuffer.append("((String)list.get(i), ").append(this.queryCacheKeyVar());
            } else {
                stringBuffer.append("((String)list.get(i), null");
            }
            stringBuffer.append(");").append(EOL);
            stringBuffer.append("}").append(EOL);
            stringBuffer.append("}").append(EOL);
        }
        if (this.shouldImplementQueryCaching(this.curFinder)) {
            stringBuffer.append("((TTLManager)").append(this.pmVar()).append(".getBeanManager())");
            stringBuffer.append(".putInQueryCache(").append(this.queryCacheKeyVar());
            stringBuffer.append(", ").append(this.queryCacheElementsVar()).append(");").append(EOL);
        }
        this.currFinderLoadsQueryCachingEnabledCMRFields = false;
        return stringBuffer.toString();
    }

    private String queryCacheKeyVar() {
        return this.varPrefix() + "qckey";
    }

    private String queryCacheElementVar() {
        return this.varPrefix() + "querycacheelement";
    }

    private String queryCacheElementsVar() {
        return this.varPrefix() + "qcelements";
    }

    private String cmrFieldVar(String string) {
        return this.varPrefix() + string + "_field_";
    }

    private String beanMapVar() {
        return this.varPrefix() + "beanMap";
    }

    private boolean shouldImplementQueryCaching(Finder finder) {
        if (!finder.isFindByPrimaryKey()) {
            return finder.isQueryCachingEnabled();
        }
        return false;
    }

    private String getParametersAsArray(Finder finder) {
        Class[] classArray = finder.getParameterClassTypes();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (classArray[i].equals(Boolean.TYPE)) {
                stringBuffer.append("new Boolean(param").append(i).append(")");
                continue;
            }
            if (classArray[i].equals(Character.TYPE)) {
                stringBuffer.append("new Character(param").append(i).append(")");
                continue;
            }
            if (classArray[i].equals(Byte.TYPE)) {
                stringBuffer.append("new Byte(param").append(i).append(")");
                continue;
            }
            if (classArray[i].equals(Short.TYPE)) {
                stringBuffer.append("new Short(param").append(i).append(")");
                continue;
            }
            if (classArray[i].equals(Integer.TYPE)) {
                stringBuffer.append("new Integer(param").append(i).append(")");
                continue;
            }
            if (classArray[i].equals(Long.TYPE)) {
                stringBuffer.append("new Long(param").append(i).append(")");
                continue;
            }
            if (classArray[i].equals(Float.TYPE)) {
                stringBuffer.append("new Float(param").append(i).append(")");
                continue;
            }
            if (classArray[i].equals(Double.TYPE)) {
                stringBuffer.append("new Double(param").append(i).append(")");
                continue;
            }
            stringBuffer.append("param").append(i);
        }
        return stringBuffer.toString();
    }

    private String generateCMRFieldFinderMethodName(String string) {
        return CodeGenUtils.getCMRFieldFinderMethodName(this.bean, string);
    }

    private boolean isRelationshipCaching(Finder finder) {
        RelationshipCaching relationshipCaching;
        EjbqlFinder ejbqlFinder;
        String string;
        if (finder instanceof EjbqlFinder && (string = (ejbqlFinder = (EjbqlFinder)finder).getCachingName()) != null && (relationshipCaching = this.bean.getRelationshipCaching(string)) != null) {
            return relationshipCaching.getCachingElements().iterator().hasNext();
        }
        return false;
    }

    private static void debug(String string) {
        debugLogger.debug("[RDBMSCodeGenerator] " + string);
    }

    private void p(String string) {
        System.err.println("\n" + string + "\n");
    }
}

