/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.compliance;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.FieldGroup;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSRelation;
import weblogic.ejb.container.cmp.rdbms.RelationshipCaching;
import weblogic.ejb.container.cmp.rdbms.SqlShape;
import weblogic.ejb.container.cmp.rdbms.finders.RDBMSFinder;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.EntityBeanQuery;
import weblogic.ejb.container.persistence.PersistenceUtils;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.CmrField;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.RoleSource;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;
import weblogic.j2ee.validation.ComplianceException;
import weblogic.utils.AssertionError;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StackTraceUtils;

public final class RDBMSBeanChecker
extends BaseComplianceChecker {
    private Map beanMap = null;
    private Map relationMap = null;
    private Map rdbmsBeanMap = null;
    private Map rdbmsRelationMap = null;
    private Method[] methods = null;
    private WeblogicRdbmsJarBean cmpDesc = null;
    Set fieldNames = null;
    Set cmrFieldNames = null;
    private CMPBeanDescriptor testCMPB = null;
    private ErrorCollectionException errors = null;

    RDBMSBeanChecker(Map map, Map map2, Map map3, Map map4, WeblogicRdbmsJarBean weblogicRdbmsJarBean) {
        this.beanMap = map;
        this.relationMap = map2;
        this.rdbmsBeanMap = map3;
        this.rdbmsRelationMap = map4;
        this.cmpDesc = weblogicRdbmsJarBean;
        this.methods = this.getClass().getMethods();
        this.errors = new ErrorCollectionException();
    }

    public void runComplianceCheck() throws ErrorCollectionException {
        for (CMPBeanDescriptor this.testCMPB : this.beanMap.values()) {
            this.computeFieldNames();
            for (int i = 0; i < this.methods.length; ++i) {
                if (!this.methods[i].getName().startsWith("check")) continue;
                try {
                    this.methods[i].invoke((Object)this, (Object[])null);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof ErrorCollectionException) {
                        this.errors.addCollection((ErrorCollectionException)throwable);
                        continue;
                    }
                    if (throwable instanceof Exception) {
                        this.errors.add((Throwable)((Exception)throwable));
                        continue;
                    }
                    this.errors.add((Throwable)new Exception(StackTraceUtils.throwable2StackTrace((Throwable)throwable)));
                    continue;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        this.errors.add((Throwable)((Exception)throwable));
                        continue;
                    }
                    this.errors.add((Throwable)new Exception(StackTraceUtils.throwable2StackTrace((Throwable)throwable)));
                }
            }
        }
        if (!this.errors.isEmpty()) {
            throw this.errors;
        }
    }

    private void computeFieldNames() {
        this.fieldNames = new HashSet();
        this.cmrFieldNames = new HashSet();
        for (EjbRelation ejbRelation : this.relationMap.values()) {
            Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
            EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator.next();
            EjbRelationshipRole ejbRelationshipRole2 = (EjbRelationshipRole)iterator.next();
            RoleSource roleSource = ejbRelationshipRole.getRoleSource();
            RoleSource roleSource2 = ejbRelationshipRole2.getRoleSource();
            CmrField cmrField = ejbRelationshipRole.getCmrField();
            CmrField cmrField2 = ejbRelationshipRole2.getCmrField();
            this.perhapsAddCmrField(this.cmrFieldNames, roleSource, cmrField);
            this.perhapsAddCmrField(this.cmrFieldNames, roleSource2, cmrField2);
        }
        this.fieldNames.addAll(this.testCMPB.getCMFieldNames());
        this.fieldNames.addAll(this.cmrFieldNames);
    }

    private void perhapsAddCmrField(Set set, RoleSource roleSource, CmrField cmrField) {
        if (roleSource.getEjbName().equals(this.testCMPB.getEJBName()) && cmrField != null) {
            set.add(cmrField.getName());
        }
    }

    public void checkBean() throws ComplianceException {
        this.checkEjBeanHasWLBean();
        this.checkNoExtraAbstractMethods();
        this.checkCMPFieldsForFieldMaps();
        this.checkMultiTableNoDupCMPFields();
        this.checkMultiTableAllHavePKFields();
        this.checkFieldGroupsHaveValidFields();
        this.checkRelationshipCachingRequireDatabaseType();
        this.checkDelayDatabaseInsertUntilConflictDelayUpdatesUntilEndOfTx();
        this.checkWeblogicQueriesHaveEjbQuery();
        this.checkQueriesHaveValidGroupNamesAndCachingNames();
        this.checkNoSqlSelectDistinctWithBlobClob();
        this.checkSupportedDatabaseForKeyGenerator();
        this.checkGenKeyPKIsIntegerOrLong();
        this.checkBlobClobSupportedDatabase();
        this.checkBatchOperations();
        this.checkOptimisticConcurrency();
        this.checkUseSelectForUpdate();
        this.checkValuesForTableAutoCreation();
        this.checkWLFindByPrimaryKey();
        this.checkTableAndColumnNames();
        this.checkFieldGroupsUnused();
        this.checkRelationshipCachesUnused();
        this.checkSqlShapeExists();
    }

    public static boolean validateCategoryFieldAvailible(RDBMSBean rDBMSBean) {
        if (rDBMSBean == null) {
            return false;
        }
        String string = rDBMSBean.getCategoryCmpField();
        if (string != null) {
            boolean bl = true;
            if (!rDBMSBean.getCmpFieldNames().contains(string)) {
                log.logInfo("The field " + string + " specified in <category-cmp-field> of EJB " + rDBMSBean.getEjbName() + " isn't a cmp field.");
                bl = false;
            }
            if (!rDBMSBean.isReadOnly()) {
                log.logInfo("The <category-cmp-field> " + string + " should be specified on Readonly Entity Bean only. " + rDBMSBean.getEjbName() + " isn't a Readonly Entity Bean");
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private void checkSqlShapeExists() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        for (RDBMSFinder rDBMSFinder : rDBMSBean.getRdbmsFinders().values()) {
            Object object;
            String string2 = rDBMSFinder.getSqlShapeName();
            if (string2 != null && rDBMSBean.getSqlShape(string2) == null) {
                object = "";
                if (rDBMSBean.getSqlShapes() != null) {
                    Iterator iterator = rDBMSBean.getSqlShapes().values().iterator();
                    while (iterator.hasNext()) {
                        SqlShape sqlShape = (SqlShape)iterator.next();
                        object = (String)object + sqlShape.getSqlShapeName();
                        if (!iterator.hasNext()) continue;
                        object = (String)object + ", ";
                    }
                }
                this.errors.add((Throwable)new ComplianceException(this.fmt.SQL_SHAPE_DOES_NOT_EXIST(string, rDBMSFinder.toString(), string2, (String)object)));
            }
            if (!rDBMSFinder.usesSql() || (object = rDBMSFinder.getSqlQueries()).size() != 0) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.SQL_QUERY_NOT_SPECIFIED(string, rDBMSFinder.toString())));
        }
    }

    private void checkTableAndColumnNames() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        Map map = rDBMSBean.getTableName2CmpField2ColumnMap();
        for (String string2 : map.keySet()) {
            if (DDConstants.reservedWords.contains(string2.toUpperCase(Locale.ENGLISH))) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.RESERVED_WORD_USED_FOR_COLUMN_OR_TABLE(string, string2)));
            }
            Map map2 = (Map)map.get(string2);
            for (String string3 : map2.keySet()) {
                String string4 = (String)map2.get(string3);
                if (!DDConstants.reservedWords.contains(string4.toUpperCase(Locale.ENGLISH))) continue;
                this.errors.add((Throwable)new ComplianceException(this.fmt.RESERVED_WORD_USED_FOR_COLUMN_OR_TABLE(string, string4)));
            }
        }
    }

    private void checkValuesForTableAutoCreation() throws ComplianceException {
        String string = this.cmpDesc.getCreateDefaultDbmsTables();
        if (!(string == null || string.equalsIgnoreCase("DropAndCreate") || string.equalsIgnoreCase("DropAndCreateAlways") || string.equalsIgnoreCase("AlterOrCreate") || string.equalsIgnoreCase("CreateOnly") || string.equalsIgnoreCase("Disabled"))) {
            throw new ComplianceException(this.fmt.WRONG_VALUE_FOR_DBMS_TABLE());
        }
    }

    private void checkEjBeanHasWLBean() throws ComplianceException {
        String string = this.testCMPB.getEJBName();
        if (!this.rdbmsBeanMap.containsKey(string)) {
            throw new ComplianceException(this.fmt.NO_MATCHING_BEAN(string), new DescriptorErrorInfo("<entity>", (Object)string, (Object)string));
        }
    }

    private void checkSupportedDatabaseForKeyGenerator() throws ComplianceException {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        if (!rDBMSBean.hasAutoKeyGeneration()) {
            return;
        }
        if (rDBMSBean.getGenKeyType() == 2) {
            switch (rDBMSBean.getDatabaseType()) {
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new ComplianceException(this.fmt.GENKEY_PK_SEQUENCE_WITH_UNSUPPORTED_DB(this.testCMPB.getEJBName(), DDConstants.getDBNameForType(rDBMSBean.getDatabaseType())), new DescriptorErrorInfo("<automatic-key-generation>", (Object)string, (Object)string));
                }
            }
        }
        if (rDBMSBean.getGenKeyType() == 1 && rDBMSBean.getDatabaseType() == 1) {
            throw new ComplianceException(this.fmt.GENKEY_PK_IDENTITY_WITH_UNSUPPORTED_DB(this.testCMPB.getEJBName(), DDConstants.getDBNameForType(rDBMSBean.getDatabaseType())), new DescriptorErrorInfo("<automatic-key-generation>", (Object)string, (Object)string));
        }
    }

    private void checkGenKeyPKIsIntegerOrLong() throws ComplianceException {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        if (!rDBMSBean.hasAutoKeyGeneration()) {
            return;
        }
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
        if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
            String string2;
            Class clazz;
            if (cMPBeanDescriptor.getPrimaryKeyFieldNames().size() == 1 && ((clazz = cMPBeanDescriptor.getFieldClass(string2 = (String)cMPBeanDescriptor.getPrimaryKeyFieldNames().iterator().next())).equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE))) {
                return;
            }
            throw new ComplianceException(this.fmt.GENKEY_PK_IS_INTEGER_OR_LONG(this.testCMPB.getEJBName()), new DescriptorErrorInfo("<automatic-key-generation>", (Object)string, (Object)string));
        }
        Iterator iterator = cMPBeanDescriptor.getPrimaryKeyFieldNames().iterator();
        String string3 = (String)iterator.next();
        String string4 = ClassUtils.classToJavaSourceType(cMPBeanDescriptor.getFieldClass(string3));
        if (!string4.equals("java.lang.Integer") && !string4.equals("java.lang.Long")) {
            throw new ComplianceException(this.fmt.GENKEY_PK_IS_INTEGER_OR_LONG(this.testCMPB.getEJBName()), new DescriptorErrorInfo("<automatic-key-generation>", (Object)string, (Object)string));
        }
        if ((rDBMSBean.getGenKeyType() == 2 || rDBMSBean.getGenKeyType() == 3) && rDBMSBean.getGenKeyCacheSize() == 0) {
            throw new ComplianceException(this.fmt.AUTO_PK_KEY_CACHE_SIZE_NOT_SPECIFIED(this.testCMPB.getEJBName()), new DescriptorErrorInfo("<automatic-key-generation>", (Object)string, (Object)string));
        }
    }

    private void checkBlobClobSupportedDatabase() throws ComplianceException {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        if (!rDBMSBean.hasBlobClobColumn()) {
            return;
        }
        switch (rDBMSBean.getDatabaseType()) {
            case 1: 
            case 4: {
                break;
            }
            case 0: {
                throw new ComplianceException(this.fmt.BLOB_CLOB_WITH_UNKNOWN_DB(string), new DescriptorErrorInfo("<dbms-column-type>", (Object)string, (Object)string));
            }
            default: {
                throw new ComplianceException(this.fmt.BLOB_CLOB_WITH_UNSUPPORTED_DB(string, DDConstants.getDBNameForType(rDBMSBean.getDatabaseType())), new DescriptorErrorInfo("<dbms-column-type>", (Object)string, (Object)string));
            }
        }
    }

    private void checkBatchOperations() throws ComplianceException {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        if (!rDBMSBean.getEnableBatchOperations() && !rDBMSBean.getOrderDatabaseOperations()) {
            return;
        }
        if (rDBMSBean.hasAutoKeyGeneration() && rDBMSBean.getGenKeyType() == 1) {
            EJBLogger eJBLogger = new EJBLogger();
            EJBLogger.logWarningBatchOperationOffForAutoKeyGen((String)string, (String)"Identity");
        }
    }

    private void checkOptimisticConcurrency() throws ComplianceException {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
        for (Object object42 : rDBMSBean.getTables()) {
            Object object5 = rDBMSBean.getVerifyColumns((String)object42);
            object3 = rDBMSBean.getVerifyRows((String)object42);
            object2 = rDBMSBean.getOptimisticColumn((String)object42);
            if (cMPBeanDescriptor.isOptimistic()) {
                if (object5 == null) {
                    throw new ComplianceException(this.fmt.MISSING_VERIFY_COLUMNS(string, (String)object42), new DescriptorErrorInfo("<verify-fields>", (Object)string, object42));
                }
                if (!(((String)object5).equalsIgnoreCase("read") || ((String)object5).equalsIgnoreCase("modified") || ((String)object5).equalsIgnoreCase("version") || ((String)object5).equalsIgnoreCase("timestamp"))) {
                    throw new ComplianceException(this.fmt.ILLEGAL_VERIFY_COLUMNS(string, (String)object42, (String)object5), new DescriptorErrorInfo("<verify-fields>", (Object)string, object42));
                }
                if (object3 != null) {
                    if (!((String)object3).equalsIgnoreCase("read") && !((String)object3).equalsIgnoreCase("modified")) {
                        throw new ComplianceException(this.fmt.ILLEGAL_VERIFY_ROWS(string, (String)object42, (String)object3), new DescriptorErrorInfo("<verify-fields>", (Object)string, object42));
                    }
                    if (((String)object3).equalsIgnoreCase("read") && ((String)object5).equalsIgnoreCase("modified")) {
                        throw new ComplianceException(this.fmt.ILLEGAL_VERIFY_READ_MODIFIED(string, (String)object42), new DescriptorErrorInfo("<verify-fields>", (Object)string, object42));
                    }
                }
                if (((String)object5).equalsIgnoreCase("version") || ((String)object5).equalsIgnoreCase("timestamp")) {
                    if (!rDBMSBean.hasOptimisticColumn((String)object42)) {
                        throw new ComplianceException(this.fmt.MISSING_OPTIMISTIC_COLUMN(string, (String)object42, (String)object5), new DescriptorErrorInfo("<optimistic-column>", (Object)string, object42));
                    }
                    object = rDBMSBean.getCmpField((String)object42, (String)object2);
                    if (object != null) {
                        Class clazz = this.testCMPB.getFieldClass((String)object);
                        if (((String)object5).equalsIgnoreCase("version")) {
                            if (!clazz.equals(Long.class)) {
                                throw new ComplianceException(this.fmt.VERSION_FIELD_WRONG_TYPE(string, (String)object, (String)object42, (String)object2, clazz.getName()));
                            }
                        } else if (!clazz.equals(Timestamp.class)) {
                            throw new ComplianceException(this.fmt.TIMESTAMP_FIELD_WRONG_TYPE(string, (String)object, (String)object42, (String)object2, clazz.getName()));
                        }
                    }
                }
                if (!rDBMSBean.hasBlobClobColumn() || ((String)object5).equalsIgnoreCase("version") || ((String)object5).equalsIgnoreCase("timestamp")) continue;
                object = new EJBLogger();
                EJBLogger.logWarningOptimisticBlobBeanHasNoVersionTimestamp((String)string);
                continue;
            }
            if (object5 != null) {
                EJBLogger.logWarningNonOptimisticBeanUsesVerifyColumns((String)string);
                rDBMSBean.setVerifyColumns((String)object42, null);
            }
            if (object3 != null) {
                EJBLogger.logWarningNonOptimisticBeanUsesVerifyRows((String)string);
                rDBMSBean.setVerifyRows((String)object42, null);
            }
            if (object2 == null) continue;
            EJBLogger.logWarningNonOptimisticBeanUsesOptimisticColumn((String)string);
            rDBMSBean.setOptimisticColumn((String)object42, null);
        }
        if (cMPBeanDescriptor.isOptimistic()) {
            if (rDBMSBean.getDatabaseType() != 1) {
                for (Object object5 : this.testCMPB.getAllQueries()) {
                    object3 = new RDBMSFinder.FinderKey(object5.getMethodName(), object5.getMethodParams());
                    object2 = (RDBMSFinder)rDBMSBean.getRdbmsFinders().get(object3);
                    if (object2 != null && !((RDBMSFinder)object2).getIncludeUpdates()) continue;
                    object = new EJBLogger();
                    EJBLogger.logWarningOptimisticBeanUsesIncludeUpdate((String)string, (String)DDUtils.getMethodSignature(object5.getMethodName(), object5.getMethodParams()), (String)DDConstants.getDBNameForType(rDBMSBean.getDatabaseType()));
                }
            }
            if (rDBMSBean.getUseSelectForUpdate()) {
                object42 = new EJBLogger();
                EJBLogger.logWarningOptimisticBeanUsesUseSelectForUpdate((String)string);
                rDBMSBean.setUseSelectForUpdate(false);
            }
            if (rDBMSBean.isClusterInvalidationDisabled() && !rDBMSBean.getVerifyReads()) {
                object42 = new EJBLogger();
                EJBLogger.logWarningOCBeanIsVerifyModAndNoClustInvalidate((String)string);
            }
        } else if (rDBMSBean.isClusterInvalidationDisabled() && !cMPBeanDescriptor.isReadOnly()) {
            object42 = new EJBLogger();
            EJBLogger.logWarningNonOCOrROBeanDisablesClustInvalidate((String)string);
            rDBMSBean.setClusterInvalidationDisabled(false);
        }
    }

    private void checkUseSelectForUpdate() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        if (rDBMSBean.getUseSelectForUpdate()) {
            CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
            if (cMPBeanDescriptor.isReadOnly()) {
                EJBLogger.logWarningReadOnlyBeanUsesUseSelectForUpdate((String)string);
            }
            if (cMPBeanDescriptor.getConcurrencyStrategy() == 1) {
                EJBLogger.logWarningExclusiveBeanUsesUseSelectForUpdate((String)string);
            }
        }
    }

    private void checkNoExtraAbstractMethods() {
        Class clazz = this.testCMPB.getBeanClass();
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = PersistenceUtils.getAbstractMethodCollection(clazz);
        for (Method method : collection) {
            int n = method.getModifiers();
            if (hashSet.contains(method.getName())) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.OVERLOADED_ABSTRACT_METHOD(this.testCMPB.getEJBName(), method.getName())));
            }
            boolean bl = false;
            if (method.getName().startsWith("ejbSelect")) {
                bl = true;
            } else if (method.getName().startsWith("get") || method.getName().startsWith("set")) {
                hashSet.add(method.getName());
                String string = method.getName().substring(3);
                string = MethodUtils.decapitalize(string);
                bl = this.fieldNames.contains(string);
            } else {
                bl = false;
            }
            if (bl) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.EXTRA_ABSTRACT_METHOD(this.testCMPB.getEJBName(), DDUtils.getMethodSignature(method))));
        }
    }

    private void checkCMPFieldsForFieldMaps() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
        Map map = rDBMSBean.getCmpFieldToColumnMap();
        Map map2 = rDBMSBean.getCmpFieldToColumnTypeMap();
        for (Object object : this.testCMPB.getCMFieldNames()) {
            String string2;
            if (!map.containsKey(object)) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.NO_MATCHING_FIELD_MAP(string, (String)object), new DescriptorErrorInfo("<field-map>", (Object)string, object)));
            }
            if (!map2.containsKey(object) || !rDBMSBean.isClobCmpColumnTypeForField((String)object) || (string2 = ClassUtils.classToJavaSourceType(cMPBeanDescriptor.getFieldClass((String)object))).equals("java.lang.String")) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.FIELDCLASSTYPE_MUST_BE_STRING_FOR_ORACLECLOB_COLUMNTYPE(string, (String)object, string2), new DescriptorErrorInfo("<dbms-column-type>", (Object)string, object)));
        }
        for (String string2 : map.keySet()) {
            if (this.testCMPB.getCMFieldNames().contains(string2)) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.NO_MATCHING_CMP_FIELD(string, string2), new DescriptorErrorInfo("<cmp-field>", (Object)string, (Object)string2)));
        }
    }

    private void checkMultiTableNoDupCMPFields() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        if (!rDBMSBean.hasMultipleTables()) {
            return;
        }
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
        Map map = rDBMSBean.getCmpFieldToColumnMap();
        Set set = cMPBeanDescriptor.getPrimaryKeyFieldNames();
        for (String string2 : this.testCMPB.getCMFieldNames()) {
            if (set.contains(string2)) continue;
            int n = 0;
            String string3 = "";
            for (String string4 : rDBMSBean.getTables()) {
                Map map2 = rDBMSBean.getCmpField2ColumnMap(string4);
                if (!map2.containsKey(string2)) continue;
                string3 = string3 + (n > 0 ? ", " : "") + string4;
                ++n;
            }
            if (n <= true) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.NON_PK_CMP_FIELD_MAPPED_TO_MORE_THAN_ONE_TABLE(string, string2, n, string3), new DescriptorErrorInfo("<cmp-field>", (Object)string, (Object)string2)));
        }
    }

    private void checkMultiTableAllHavePKFields() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        if (!rDBMSBean.hasMultipleTables()) {
            return;
        }
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
        Map map = rDBMSBean.getCmpFieldToColumnMap();
        Set set = cMPBeanDescriptor.getPrimaryKeyFieldNames();
        for (String string2 : rDBMSBean.getTables()) {
            Map map2 = rDBMSBean.getCmpField2ColumnMap(string2);
            for (String string3 : set) {
                if (map2.containsKey(string3)) continue;
                this.errors.add((Throwable)new ComplianceException(this.fmt.MISSING_MULTITABLE_PK_FIELD_MAP(string, string2, string3), new DescriptorErrorInfo("TableNameForOneCMP", (Object)string, (Object)string2)));
            }
        }
    }

    private void checkFieldGroupsHaveValidFields() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        for (FieldGroup fieldGroup : rDBMSBean.getFieldGroups()) {
            Object object2;
            for (Object object2 : fieldGroup.getCmpFields()) {
                if (rDBMSBean.hasCmpField((String)object2)) continue;
                this.errors.add((Throwable)new ComplianceException(this.fmt.GROUP_CONTAINS_UNDEFINED_CMP_FIELD(string, fieldGroup.getName(), (String)object2), new DescriptorErrorInfo("<field-group>", (Object)string, (Object)fieldGroup.getName())));
            }
            object2 = fieldGroup.getCmrFields().iterator();
            while (object2.hasNext()) {
                String string2 = (String)object2.next();
                if (this.cmrFieldNames.contains(string2)) continue;
                this.errors.add((Throwable)new ComplianceException(this.fmt.GROUP_CONTAINS_UNDEFINED_CMR_FIELD(string, fieldGroup.getName(), string2), new DescriptorErrorInfo("<field-group>", (Object)string, (Object)fieldGroup.getName())));
            }
        }
    }

    private void checkRelationshipCachingRequireDatabaseType() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        Iterator iterator = rDBMSBean.getRelationshipCachings().iterator();
        if (iterator.hasNext() && this.cmpDesc.getDatabaseType() == null) {
            this.errors.add((Throwable)new ComplianceException(this.fmt.RELATIONSHIP_CACHING_REQUIRE_DATABASETYPE(string), new DescriptorErrorInfo("<relationship-caching>", (Object)string, (Object)string)));
        }
    }

    private void checkDelayDatabaseInsertUntilConflictDelayUpdatesUntilEndOfTx() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
        if (!cMPBeanDescriptor.getBoxCarUpdates() && this.cmpDesc.isEnableBatchOperations() || !cMPBeanDescriptor.getBoxCarUpdates() && this.cmpDesc.isOrderDatabaseOperations()) {
            this.errors.add((Throwable)new ComplianceException(this.fmt.DelayDatabaseInsertUntilConflictEnableBatchOperations(string), new DescriptorErrorInfo("<delay-updates-until-end-of-tx>", (Object)string, (Object)string)));
        }
    }

    private void checkGroupHasAllPkFields() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        Set set = this.testCMPB.getPrimaryKeyFieldNames();
        for (FieldGroup fieldGroup : rDBMSBean.getFieldGroups()) {
            TreeSet treeSet = fieldGroup.getCmpFields();
            Iterator iterator = fieldGroup.getCmpFields().iterator();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                if (!set.contains(iterator.next())) continue;
                bl = true;
            }
            if (!bl || treeSet.containsAll(set)) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.GROUP_CONTAINS_PK_SUBSET(string, fieldGroup.getName()), new DescriptorErrorInfo("<field-group>", (Object)string, (Object)fieldGroup.getName())));
        }
    }

    private void checkWeblogicQueriesHaveEjbQuery() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        Iterator iterator = this.testCMPB.getAllQueries().iterator();
        HashSet<RDBMSFinder.FinderKey> hashSet = new HashSet<RDBMSFinder.FinderKey>();
        while (iterator.hasNext()) {
            EntityBeanQuery entityBeanQuery = (EntityBeanQuery)iterator.next();
            RDBMSFinder.FinderKey finderKey = new RDBMSFinder.FinderKey(entityBeanQuery.getMethodName(), entityBeanQuery.getMethodParams());
            hashSet.add(finderKey);
        }
        hashSet.add(new RDBMSFinder.FinderKey("findByPrimaryKey", new String[]{this.testCMPB.getPrimaryKeyClassName()}));
        for (RDBMSFinder.FinderKey finderKey : rDBMSBean.getRdbmsFinders().keySet()) {
            if (hashSet.contains(finderKey)) continue;
            EJBLogger eJBLogger = new EJBLogger();
            EJBLogger.logWarningWeblogicQueryHasNoMatchingEjbQuery((String)string, (String)DDUtils.getMethodSignature(finderKey.getFinderName(), finderKey.getFinderParams()));
        }
    }

    private void checkQueriesHaveValidGroupNamesAndCachingNames() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        for (RDBMSFinder rDBMSFinder : rDBMSBean.getRdbmsFinders().values()) {
            if (rDBMSFinder.getGroupName() != null && rDBMSBean.getFieldGroup(rDBMSFinder.getGroupName()) == null) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.QUERY_CONTAINS_UNDEFINED_GROUP(string, rDBMSFinder.getGroupName()), new DescriptorErrorInfo("<group-name>", (Object)string, (Object)rDBMSFinder.getFinderName())));
            }
            if (rDBMSFinder.getCachingName() == null || rDBMSBean.getRelationshipCaching(rDBMSFinder.getCachingName()) != null) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.QUERY_CONTAINS_UNDEFINED_CACHING_NAME(string, rDBMSFinder.getCachingName()), new DescriptorErrorInfo("<caching-name>", (Object)string, (Object)rDBMSFinder.getFinderName())));
        }
    }

    private void checkNoSqlSelectDistinctWithBlobClob() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        for (RDBMSFinder rDBMSFinder : rDBMSBean.getRdbmsFinders().values()) {
            if (!rDBMSFinder.getSqlSelectDistinct()) continue;
            String string2 = rDBMSFinder.getGroupName();
            if (string2 != null) {
                for (String string3 : rDBMSBean.getFieldGroup(string2).getCmpFields()) {
                    if (!rDBMSBean.isBlobCmpColumnTypeForField(string3) && !rDBMSBean.isClobCmpColumnTypeForField(string3)) continue;
                    this.errors.add((Throwable)new ComplianceException(this.fmt.NoSqlSelectDistinctWithBlobClobField(string, rDBMSFinder.getFinderName(), string2)));
                }
                continue;
            }
            if (!rDBMSBean.hasBlobClobColumn()) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.NoSqlSelectDistinctWithBlobClobField(string, rDBMSFinder.getFinderName(), "defaultGroup")));
        }
    }

    private void checkWLFindByPrimaryKey() {
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        String string2 = "findByPrimaryKey";
        String[] stringArray = new String[]{this.testCMPB.getPrimaryKeyClassName()};
        RDBMSFinder rDBMSFinder = (RDBMSFinder)rDBMSBean.getRdbmsFinders().get(new RDBMSFinder.FinderKey(string2, stringArray));
        if (rDBMSFinder != null && rDBMSFinder.getEjbQlQuery() != null) {
            this.errors.add((Throwable)new ComplianceException(this.fmt.WLQL_CANNOT_OVERRIDE_FINDBYPK_QL(string, rDBMSFinder.getEjbQlQuery())));
            return;
        }
    }

    private void checkFieldGroupsUnused() {
        Object object;
        Object object22;
        Object object32;
        FieldGroup fieldGroup;
        String string;
        Object object4;
        String string2 = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string2);
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(string2);
        boolean bl = cMPBeanDescriptor.getIsDynamicQueriesEnabled();
        if (bl) {
            return;
        }
        List list = rDBMSBean.getFieldGroups();
        if (list.size() <= 0) {
            return;
        }
        LinkedList linkedList = new LinkedList();
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        Map map = rDBMSBean.getRdbmsFinders();
        Iterator iterator2 = map.keySet().iterator();
        while (iterator2.hasNext()) {
            object4 = (RDBMSFinder)map.get(iterator2.next());
            string = ((RDBMSFinder)object4).getGroupName();
            if (string == null || string.length() <= 0 || (fieldGroup = this.getFieldGroupByName(string, linkedList)) == null) continue;
            linkedList.remove(fieldGroup);
        }
        object4 = this.rdbmsBeanMap.keySet().iterator();
        while (object4.hasNext()) {
            object32 = (RDBMSBean)this.rdbmsBeanMap.get(object4.next());
            for (Object object22 : ((RDBMSBean)object32).getRelationshipCachings()) {
                object = ((RelationshipCaching)object22).getCachingElements();
                if (object.size() <= 0) continue;
                this.filterFieldGroupInCachingElements(linkedList, (List)object);
            }
        }
        for (Object object32 : this.rdbmsRelationMap.values()) {
            object22 = ((RDBMSRelation)object32).getRole1();
            object = ((RDBMSRelation)object32).getRole2();
            if (object22 != null && (string = ((RDBMSRelation.RDBMSRole)object22).getGroupName()) != null && string.length() > 0 && (fieldGroup = this.getFieldGroupByName(string, linkedList)) != null) {
                linkedList.remove(fieldGroup);
            }
            if (object == null || (string = ((RDBMSRelation.RDBMSRole)object).getGroupName()) == null || string.length() <= 0 || (fieldGroup = this.getFieldGroupByName(string, linkedList)) == null) continue;
            linkedList.remove(fieldGroup);
        }
        if (linkedList.size() > 0) {
            object32 = new StringBuffer();
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                fieldGroup = (FieldGroup)iterator.next();
                ((StringBuffer)object32).append(fieldGroup.getName());
                if (!iterator.hasNext()) continue;
                ((StringBuffer)object32).append(", ");
            }
            object22 = new EJBLogger();
            EJBLogger.logWarningUnusedFieldGroups((String)string2, (String)((StringBuffer)object32).toString());
        }
    }

    private void filterFieldGroupInCachingElements(List list, List list2) {
        if (list2.size() > 0) {
            for (RelationshipCaching.CachingElement cachingElement : list2) {
                FieldGroup fieldGroup;
                String string = cachingElement.getGroupName();
                if (string != null && string.length() > 0 && (fieldGroup = this.getFieldGroupByName(string, list)) != null) {
                    list.remove(fieldGroup);
                }
                this.filterFieldGroupInCachingElements(list, cachingElement.getCachingElements());
            }
        }
    }

    private FieldGroup getFieldGroupByName(String string, List list) {
        if (string == null || list == null) {
            return null;
        }
        for (FieldGroup fieldGroup : list) {
            if (!fieldGroup.getName().equals(string)) continue;
            return fieldGroup;
        }
        return null;
    }

    private void checkRelationshipCachesUnused() {
        RelationshipCaching relationshipCaching;
        Object object;
        String string = this.testCMPB.getEJBName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(string);
        boolean bl = cMPBeanDescriptor.getIsDynamicQueriesEnabled();
        if (bl) {
            return;
        }
        List list = rDBMSBean.getRelationshipCachings();
        if (list.size() <= 0) {
            return;
        }
        LinkedList linkedList = new LinkedList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        Map map = rDBMSBean.getRdbmsFinders();
        Iterator iterator2 = map.keySet().iterator();
        while (iterator2.hasNext()) {
            object = (RDBMSFinder)map.get(iterator2.next());
            String string2 = ((RDBMSFinder)object).getCachingName();
            if (string2 == null || string2.length() <= 0 || (relationshipCaching = this.getRelationshipCachingByName(string2, linkedList)) == null) continue;
            linkedList.remove(relationshipCaching);
        }
        if (linkedList.size() > 0) {
            object = new StringBuffer();
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                relationshipCaching = (RelationshipCaching)iterator.next();
                ((StringBuffer)object).append(relationshipCaching.getCachingName());
                if (!iterator.hasNext()) continue;
                ((StringBuffer)object).append(", ");
            }
            EJBLogger eJBLogger = new EJBLogger();
            EJBLogger.logWarningUnusedRelationshipCachings((String)string, (String)((StringBuffer)object).toString());
        }
    }

    private RelationshipCaching getRelationshipCachingByName(String string, List list) {
        if (string == null || list == null) {
            return null;
        }
        for (RelationshipCaching relationshipCaching : list) {
            if (!relationshipCaching.getCachingName().equals(string)) continue;
            return relationshipCaching;
        }
        return null;
    }
}

