/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.compliance;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.compliance.RDBMSBeanChecker;
import weblogic.ejb.container.cmp.rdbms.compliance.RDBMSRelationChecker;
import weblogic.ejb.container.cmp.rdbms.finders.RDBMSFinder;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.EJBComplianceChecker;
import weblogic.ejb.container.interfaces.EntityBeanQuery;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.container.persistence.spi.RoleSource;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;
import weblogic.j2ee.validation.ComplianceException;
import weblogic.utils.ErrorCollectionException;

public final class RDBMSComplianceChecker
extends BaseComplianceChecker {
    private Map beanMap = null;
    private Relationships relationships = null;
    private Map dependentMap = null;
    private Map rdbmsBeanMap = null;
    private Map rdbmsRelationMap = null;
    private Map rdbmsDependentMap = null;
    private WeblogicRdbmsJarBean cmpDesc = null;
    private ErrorCollectionException errors = null;

    public RDBMSComplianceChecker(Map map, Relationships relationships, Map map2, Map map3, Map map4, Map map5, WeblogicRdbmsJarBean weblogicRdbmsJarBean) {
        this.beanMap = map;
        this.relationships = relationships;
        this.dependentMap = map2;
        this.rdbmsBeanMap = map3;
        this.rdbmsRelationMap = map4;
        this.rdbmsDependentMap = map5;
        this.cmpDesc = weblogicRdbmsJarBean;
        this.errors = new ErrorCollectionException();
    }

    public void checkCompliance() throws ErrorCollectionException {
        if (EJBComplianceChecker.isNeedCheck) {
            return;
        }
        if (this.dependentMap != null) {
            this.errors.add((Throwable)new ComplianceException(this.fmt.DEPENDENT_OBJECTS_NOT_SUPPORTED()));
        }
        if (!this.errors.isEmpty()) {
            throw this.errors;
        }
        this.checkConnectedSubGraph();
        if (!this.errors.isEmpty()) {
            throw this.errors;
        }
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.calculateEjbMaps(hashMap, hashMap2);
        if (!this.errors.isEmpty()) {
            throw this.errors;
        }
        RDBMSBeanChecker rDBMSBeanChecker = null;
        RDBMSRelationChecker rDBMSRelationChecker = null;
        rDBMSBeanChecker = new RDBMSBeanChecker(hashMap, hashMap2, this.rdbmsBeanMap, this.rdbmsRelationMap, this.cmpDesc);
        rDBMSRelationChecker = new RDBMSRelationChecker(hashMap, hashMap2, this.rdbmsBeanMap, this.rdbmsRelationMap);
        try {
            rDBMSBeanChecker.runComplianceCheck();
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.errors.addCollection(errorCollectionException);
        }
        try {
            rDBMSRelationChecker.runComplianceCheck();
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.errors.addCollection(errorCollectionException);
        }
        if (!this.errors.isEmpty()) {
            throw this.errors;
        }
    }

    private void calculateEjbMaps(Map map, Map map2) {
        for (Object object : this.rdbmsBeanMap.keySet()) {
            Object object2 = (CMPBeanDescriptor)this.beanMap.get(object);
            if (object2 == null) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.NO_MATCHING_CMP_BEAN((String)object), new DescriptorErrorInfo("<entity>", object, object)));
            } else {
                map.put(object, object2);
            }
            this.checkFinderQuery((CMPBeanDescriptor)object2, (RDBMSBean)this.rdbmsBeanMap.get(object));
        }
        for (Object object2 : this.rdbmsRelationMap.keySet()) {
            EjbRelation ejbRelation = this.relationships.getEjbRelation((String)object2);
            if (ejbRelation == null) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.NO_MATCHING_EJB_RELATION_IN_EJB_DD((String)object2), new DescriptorErrorInfo("<ejb-relation>", object2, object2)));
                continue;
            }
            map2.put(object2, ejbRelation);
        }
    }

    private void checkFinderQuery(CMPBeanDescriptor cMPBeanDescriptor, RDBMSBean rDBMSBean) {
        Collection collection = cMPBeanDescriptor.getAllQueries();
        if (collection == null) {
            return;
        }
        for (EntityBeanQuery entityBeanQuery : collection) {
            if (entityBeanQuery.getQueryText() != null && entityBeanQuery.getQueryText().trim().length() > 0) continue;
            RDBMSFinder rDBMSFinder = (RDBMSFinder)rDBMSBean.getRdbmsFinders().get(new RDBMSFinder.FinderKey(entityBeanQuery.getMethodName(), entityBeanQuery.getMethodParams()));
            if (rDBMSFinder == null) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.EJBQLCANNOTBENULL(cMPBeanDescriptor.getEJBName(), entityBeanQuery.getMethodName())));
                return;
            }
            if (rDBMSFinder.getSqlQueries() != null || rDBMSFinder.getEjbQlQuery() != null && rDBMSFinder.getEjbQlQuery().trim().length() != 0) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.EJBANDWLQLCANNOTBENULL(cMPBeanDescriptor.getEJBName(), entityBeanQuery.getMethodName())));
        }
    }

    private void checkConnectedSubGraph() {
        if (this.relationships != null) {
            Map map = this.relationships.getAllEjbRelations();
            HashSet hashSet = new HashSet(this.rdbmsBeanMap.keySet());
            HashSet hashSet2 = new HashSet(this.rdbmsRelationMap.keySet());
            for (EjbRelation ejbRelation : map.values()) {
                Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
                EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator.next();
                EjbRelationshipRole ejbRelationshipRole2 = (EjbRelationshipRole)iterator.next();
                RoleSource roleSource = ejbRelationshipRole.getRoleSource();
                RoleSource roleSource2 = ejbRelationshipRole2.getRoleSource();
                this.checkConnection(hashSet, hashSet2, ejbRelation, roleSource, roleSource2);
                this.checkConnection(hashSet, hashSet2, ejbRelation, roleSource2, roleSource);
            }
        }
    }

    private void checkConnection(Set set, Set set2, EjbRelation ejbRelation, RoleSource roleSource, RoleSource roleSource2) {
        if (set.contains(roleSource.getEjbName())) {
            if (!set2.contains(ejbRelation.getEjbRelationName())) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.MISSING_RELATION_FOR_BEAN(roleSource.getEjbName(), ejbRelation.getEjbRelationName()), new DescriptorErrorInfo("<weblogic-rdbms-relation>", (Object)ejbRelation.getEjbRelationName(), (Object)roleSource.getEjbName())));
            }
            if (!set.contains(roleSource2.getEjbName())) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.MISSING_BEAN_FOR_BEAN(roleSource.getEjbName(), roleSource2.getEjbName()), new DescriptorErrorInfo("<weblogic-rdbms-bean>", (Object)ejbRelation.getEjbRelationName(), (Object)roleSource2.getEjbName())));
            }
        }
    }
}

