/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.compliance;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.cmp.rdbms.FieldGroup;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSRelation;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.RoleSource;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.j2ee.validation.ComplianceException;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;

public final class RDBMSRelationChecker
extends BaseComplianceChecker {
    public static final boolean verbose = false;
    public static final boolean debug = false;
    private Map beanMap = null;
    private Map relationMap = null;
    private Map rdbmsBeanMap = null;
    private Map rdbmsRelationMap = null;
    private Method[] methods = null;
    private EjbRelation testEjbRel = null;
    private RDBMSRelation testRDBMSRel = null;
    private ErrorCollectionException errors = null;
    private static final short REL_IS_UNKNOWN = 0;
    private static final short REL_IS_1_1 = 1;
    private static final short REL_IS_1_N = 2;
    private static final short REL_IS_M_N = 3;

    RDBMSRelationChecker(Map map, Map map2, Map map3, Map map4) {
        this.beanMap = map;
        this.relationMap = map2;
        this.rdbmsBeanMap = map3;
        this.rdbmsRelationMap = map4;
        this.methods = this.getClass().getMethods();
        this.errors = new ErrorCollectionException();
    }

    public void runComplianceCheck() throws ErrorCollectionException {
        this.runWLDrivenCheck();
        if (!this.errors.isEmpty()) {
            throw this.errors;
        }
        this.runEJBDrivenCheck();
        if (!this.errors.isEmpty()) {
            throw this.errors;
        }
    }

    private void runWLDrivenCheck() {
        for (RDBMSRelation this.testRDBMSRel : this.rdbmsRelationMap.values()) {
            try {
                this.checkWLRelHasEjbRel();
                this.checkWLRelRolesHaveEJBRelRoles();
                if (!this.errors.isEmpty()) {
                    return;
                }
                this.checkWLMNHasBothRoles();
                this.checkWLMNRelHasTableName();
                this.checkWLRolesHaveValidGroup();
                this.checkWLRolesHaveValidMap();
                this.checkWLDBCascadeDelete();
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.errors.add((Throwable)errorCollectionException);
            }
        }
    }

    private void runEJBDrivenCheck() {
        for (EjbRelation this.testEjbRel : this.relationMap.values()) {
            try {
                this.checkEjbRelHasWLRel();
                this.checkEjb1NRoleHasWLRole();
                this.checkEjbNo1MappingOn1N();
                this.checkEjb1To1RelHasWLRoleMap();
                this.checkRelatedBeansSameDataSource();
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.errors.add((Throwable)errorCollectionException);
            }
        }
    }

    private void checkEjb1NRoleHasWLRole() throws ErrorCollectionException {
        if (this.getRelType(this.testEjbRel) != 2) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        EjbRelationshipRole ejbRelationshipRole = this.getManyEjbRole(this.testEjbRel);
        if (ejbRelationshipRole == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.roleNotFound(this.testEjbRel.getEjbRelationName())));
            throw errorCollectionException;
        }
        String string = ejbRelationshipRole.getName();
        RDBMSRelation.RDBMSRole rDBMSRole = this.getRDBMSRoleForEjbRole(this.testEjbRel, ejbRelationshipRole);
        if (rDBMSRole == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NO_MATCHING_WL_RELATIONSHIP_ROLE(this.testEjbRel.getEjbRelationName(), string), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)this.testEjbRel.getEjbRelationName(), (Object)string)));
            throw errorCollectionException;
        }
        Map map = rDBMSRole.getColumnMap();
        if (map == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MANY_SIDE_OF_M_1_MUST_HAVE_FOREIGN_KEY_MAP(rDBMSRole.getName()), new DescriptorErrorInfo("<column-map>", (Object)this.testEjbRel.getEjbRelationName(), (Object)rDBMSRole.getName())));
        } else if (map.size() < 1) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MANY_SIDE_OF_M_1_MUST_HAVE_FOREIGN_KEY_MAP(rDBMSRole.getName()), new DescriptorErrorInfo("<column-map>", (Object)this.testEjbRel.getEjbRelationName(), (Object)rDBMSRole.getName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkEjbNo1MappingOn1N() throws ErrorCollectionException {
        if (this.getRelType(this.testEjbRel) != 2) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        EjbRelationshipRole ejbRelationshipRole = this.getOneEjbRole(this.testEjbRel);
        EjbRelationshipRole ejbRelationshipRole2 = this.getManyEjbRole(this.testEjbRel);
        if (ejbRelationshipRole == null) {
            throw new AssertionError(this.testEjbRel.getEjbRelationName() + ": " + " checker could not find the EjbRelationShip ONE ROLE " + "in a 1-N Relationship");
        }
        if (ejbRelationshipRole2 == null) {
            throw new AssertionError(this.testEjbRel.getEjbRelationName() + ": " + " checker could not find the EjbRelationShip MANY ROLE " + "in a 1-N Relationship");
        }
        RoleSource roleSource = ejbRelationshipRole2.getRoleSource();
        String string = ejbRelationshipRole.getName();
        RDBMSRelation.RDBMSRole rDBMSRole = this.getRDBMSRoleForEjbRole(this.testEjbRel, ejbRelationshipRole);
        if (rDBMSRole == null) {
            return;
        }
        Map map = rDBMSRole.getColumnMap();
        if (map != null && map.size() > 0) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ONE_SIDE_OF_M_1_MUST_NOT_HAVE_FOREIGN_KEY_MAP(rDBMSRole.getName()), new DescriptorErrorInfo("<column-map>", (Object)this.testEjbRel.getEjbRelationName(), (Object)rDBMSRole.getName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkEjb1To1RelHasWLRoleMap() throws ErrorCollectionException {
        if (this.getRelType(this.testEjbRel) != 1) {
            return;
        }
        for (EjbRelationshipRole ejbRelationshipRole : this.testEjbRel.getAllEjbRelationshipRoles()) {
            Map map;
            RDBMSRelation.RDBMSRole rDBMSRole = this.getRDBMSRoleForEjbRole(this.testEjbRel, ejbRelationshipRole);
            if (rDBMSRole == null || (map = rDBMSRole.getColumnMap()) == null || map.size() <= 0) continue;
            return;
        }
        this.errors.add((Throwable)new ComplianceException(this.fmt.missingRelationshipRoleMap(this.testEjbRel.getEjbRelationName())));
    }

    private void checkEjbRelHasWLRel() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        String string = this.testEjbRel.getEjbRelationName();
        if (!this.rdbmsRelationMap.containsKey(string)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NO_MATCHING_WL_RELATION(string), new DescriptorErrorInfo("<weblogic-rdbms-relation>", (Object)this.testEjbRel.getEjbRelationName(), (Object)string)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkWLRelHasEjbRel() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        String string = this.testRDBMSRel.getName();
        if (!this.relationMap.containsKey(string)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NO_MATCHING_EJB_RELATION_IN_EJB_DD(string)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkWLRelRolesHaveEJBRelRoles() {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        String string = this.testRDBMSRel.getName();
        EjbRelation ejbRelation = (EjbRelation)this.relationMap.get(string);
        RDBMSRelation.RDBMSRole rDBMSRole = this.testRDBMSRel.getRole1();
        if (rDBMSRole != null) {
            this.doWLRoleCheck(rDBMSRole, ejbRelation, this.errors);
        }
        if ((rDBMSRole = this.testRDBMSRel.getRole2()) != null) {
            this.doWLRoleCheck(rDBMSRole, ejbRelation, this.errors);
        }
    }

    private void checkWLMNHasBothRoles() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        String string = this.testRDBMSRel.getName();
        EjbRelation ejbRelation = (EjbRelation)this.relationMap.get(string);
        if (this.getRelType(ejbRelation) == 3) {
            RDBMSRelation.RDBMSRole rDBMSRole = this.testRDBMSRel.getRole1();
            if (rDBMSRole == null) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MANY_TO_MANY_RELATIONSHIP_MUST_HAVE_BOTH_WL_ROLES(string), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)ejbRelation.getEjbRelationName(), (Object)string)));
                throw errorCollectionException;
            }
            rDBMSRole = this.testRDBMSRel.getRole2();
            if (rDBMSRole == null) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MANY_TO_MANY_RELATIONSHIP_MUST_HAVE_BOTH_WL_ROLES(string), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)ejbRelation.getEjbRelationName(), (Object)string)));
                throw errorCollectionException;
            }
        }
    }

    private void checkWLMNRelHasTableName() throws ErrorCollectionException {
        String string;
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        String string2 = this.testRDBMSRel.getName();
        EjbRelation ejbRelation = (EjbRelation)this.relationMap.get(string2);
        if (this.getRelType(ejbRelation) == 3 && (string = this.testRDBMSRel.getTableName()) == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MANY_TO_MANY_RELATIONSHIP_MISSING_TABLE_NAME(string2), new DescriptorErrorInfo("<table-name>", (Object)ejbRelation.getEjbRelationName(), (Object)string2)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkWLRolesHaveValidGroup() {
        String string = this.testRDBMSRel.getName();
        EjbRelation ejbRelation = (EjbRelation)this.relationMap.get(string);
        for (EjbRelationshipRole ejbRelationshipRole : ejbRelation.getAllEjbRelationshipRoles()) {
            String string2;
            RDBMSRelation.RDBMSRole rDBMSRole = this.getRDBMSRoleForEjbRole(ejbRelation, ejbRelationshipRole);
            if (rDBMSRole == null || (string2 = rDBMSRole.getGroupName()) == null) continue;
            RoleSource roleSource = ejbRelationshipRole.getRoleSource();
            FieldGroup fieldGroup = null;
            RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(roleSource.getEjbName());
            fieldGroup = rDBMSBean.getFieldGroup(string2);
            if (fieldGroup != null) continue;
            this.errors.add((Throwable)new ComplianceException(this.fmt.RELATIONSHIP_ROLE_HAS_INVALID_GROUP(string, string2), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)ejbRelation.getEjbRelationName(), (Object)string)));
        }
    }

    private void checkWLRolesHaveValidMap() throws ErrorCollectionException {
        String string = this.testRDBMSRel.getName();
        EjbRelation ejbRelation = (EjbRelation)this.relationMap.get(string);
        Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
        EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator.next();
        EjbRelationshipRole ejbRelationshipRole2 = (EjbRelationshipRole)iterator.next();
        RDBMSRelation.RDBMSRole rDBMSRole = this.getRDBMSRoleForEjbRole(ejbRelation, ejbRelationshipRole);
        RDBMSRelation.RDBMSRole rDBMSRole2 = this.getRDBMSRoleForEjbRole(ejbRelation, ejbRelationshipRole2);
        this.checkWLRoleHasValidTableName(ejbRelation, ejbRelationshipRole, ejbRelationshipRole2, rDBMSRole);
        this.checkWLRoleHasValidTableName(ejbRelation, ejbRelationshipRole2, ejbRelationshipRole, rDBMSRole2);
        this.checkWLRolesHaveMap(ejbRelation, ejbRelationshipRole, ejbRelationshipRole2, rDBMSRole, rDBMSRole2);
        if (!this.errors.isEmpty()) {
            return;
        }
        this.checkWLRoleHasValidMap(ejbRelation, ejbRelationshipRole, ejbRelationshipRole2, rDBMSRole);
        this.checkWLRoleHasValidMap(ejbRelation, ejbRelationshipRole2, ejbRelationshipRole, rDBMSRole2);
        this.checkWLRoleHasValidFkColumns(ejbRelation, ejbRelationshipRole, rDBMSRole, ejbRelationshipRole2);
        this.checkWLRoleHasValidFkColumns(ejbRelation, ejbRelationshipRole2, rDBMSRole2, ejbRelationshipRole);
        this.checkForeignKeyTableSpecified(ejbRelation, ejbRelationshipRole, rDBMSRole);
        this.checkForeignKeyTableSpecified(ejbRelation, ejbRelationshipRole2, rDBMSRole2);
    }

    private void checkWLDBCascadeDelete() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        String string = this.testRDBMSRel.getName();
        EjbRelation ejbRelation = (EjbRelation)this.relationMap.get(string);
        short s = this.getRelType(ejbRelation);
        Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
        if (s == 3) {
            return;
        }
        while (iterator.hasNext()) {
            EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator.next();
            RDBMSRelation.RDBMSRole rDBMSRole = this.getRDBMSRoleForEjbRole(ejbRelation, ejbRelationshipRole);
            if (rDBMSRole == null) continue;
            if (rDBMSRole.getDBCascadeDelete() && !ejbRelationshipRole.getCascadeDelete()) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CASCADE_DELETE_MUST_SPECIFIED_IF_DB_CASCADE_DELETE_SPECIFIED(string), new DescriptorErrorInfo("<cascade-delete>", (Object)ejbRelation.getEjbRelationName(), (Object)string)));
            }
            if (!rDBMSRole.getDBCascadeDelete()) continue;
            Map map = rDBMSRole.getColumnMap();
            if (map == null) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CASCADE_DELETE_MUST_HAVE_FOREIGN_KEY_MAP(rDBMSRole.getName()), new DescriptorErrorInfo("<foreign-key-column>", (Object)rDBMSRole.getName(), (Object)rDBMSRole.getName())));
            }
            if (map == null || map.size() >= 1) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CASCADE_DELETE_MUST_HAVE_FOREIGN_KEY_MAP(rDBMSRole.getName()), new DescriptorErrorInfo("<foreign-key-column>", (Object)rDBMSRole.getName(), (Object)rDBMSRole.getName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkWLRolesHaveMap(EjbRelation ejbRelation, EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, RDBMSRelation.RDBMSRole rDBMSRole, RDBMSRelation.RDBMSRole rDBMSRole2) {
        String string = ejbRelation.getEjbRelationName();
        short s = this.getRelType(ejbRelation);
        if (s == 1) {
            int n = 0;
            if (rDBMSRole != null && rDBMSRole.getColumnMap().size() > 0) {
                ++n;
            }
            if (rDBMSRole2 != null && rDBMSRole2.getColumnMap().size() > 0) {
                ++n;
            }
            if (n == 0) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.ONE_ONE_MISSING_COLUMN_MAP(string)));
            }
        } else if (s == 3) {
            int n = 0;
            if (rDBMSRole != null && rDBMSRole.getColumnMap().size() > 0) {
                ++n;
            }
            if (rDBMSRole2 != null && rDBMSRole2.getColumnMap().size() > 0) {
                ++n;
            }
            if (n < 2) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.MANY_MANY_MISSING_COLUMN_MAP(string)));
            }
        }
    }

    private void checkWLRoleHasValidTableName(EjbRelation ejbRelation, EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, RDBMSRelation.RDBMSRole rDBMSRole) throws ErrorCollectionException {
        String string;
        EjbRelationshipRole ejbRelationshipRole3;
        RDBMSBean rDBMSBean;
        if (rDBMSRole == null) {
            return;
        }
        boolean bl = false;
        short s = this.getRelType(ejbRelation);
        String string2 = ejbRelation.getEjbRelationName();
        String string3 = ejbRelationshipRole.getName();
        RoleSource roleSource = ejbRelationshipRole.getRoleSource();
        String string4 = roleSource.getEjbName();
        RDBMSBean rDBMSBean2 = (RDBMSBean)this.rdbmsBeanMap.get(string4);
        RoleSource roleSource2 = ejbRelationshipRole2.getRoleSource();
        String string5 = roleSource2.getEjbName();
        RDBMSBean rDBMSBean3 = (RDBMSBean)this.rdbmsBeanMap.get(string5);
        String string6 = null;
        String string7 = null;
        string6 = rDBMSRole.getPrimaryKeyTableName();
        string7 = rDBMSRole.getForeignKeyTableName();
        if (string6 != null) {
            if (s == 1) {
                if (!rDBMSBean2.hasTable(string6) && !rDBMSBean3.hasTable(string6)) {
                    this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_11_SPECIFIES_INVALID_PK_TABLE_NAME(string2, string3, string6, string4, string5), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)string2, (Object)string3)));
                    bl = true;
                }
            } else if (s == 2) {
                rDBMSBean = null;
                ejbRelationshipRole3 = this.getOneEjbRole(ejbRelation);
                Debug.assertion((ejbRelationshipRole3 != null ? 1 : 0) != 0);
                string = ejbRelationshipRole3.getName();
                rDBMSBean = string3.equals(string) ? rDBMSBean2 : rDBMSBean3;
                if (!rDBMSBean.hasTable(string6)) {
                    this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_1N_SPECIFIES_INVALID_PK_TABLE_NAME(string2, string, string6, rDBMSBean.getEjbName()), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)string2, (Object)string3)));
                    bl = true;
                }
            } else if (s == 3 && !rDBMSBean2.hasTable(string6)) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_MN_SPECIFIES_INVALID_PK_TABLE_NAME(string2, string3, string6, string4), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)string2, (Object)string3)));
                bl = true;
            }
        }
        if (string7 != null) {
            if (s == 1) {
                if (!rDBMSBean2.hasTable(string7) && !rDBMSBean3.hasTable(string7)) {
                    this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_11_SPECIFIES_INVALID_FK_TABLE_NAME(string2, string3, string7, string4, string5), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)string2, (Object)string3)));
                    bl = true;
                }
            } else if (s == 2) {
                rDBMSBean = null;
                ejbRelationshipRole3 = this.getManyEjbRole(ejbRelation);
                Debug.assertion((ejbRelationshipRole3 != null ? 1 : 0) != 0);
                string = ejbRelationshipRole3.getName();
                rDBMSBean = string3.equals(string) ? rDBMSBean2 : rDBMSBean3;
                if (!rDBMSBean.hasTable(string7)) {
                    this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_1N_SPECIFIES_INVALID_FK_TABLE_NAME(string2, string, string7, rDBMSBean.getEjbName()), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)string2, (Object)string3)));
                    bl = true;
                }
            } else if (s == 3) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_MN_SPECIFIES_INVALID_FK_TABLE_NAME(string2, string3, string7), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)string2, (Object)string3)));
                bl = true;
            }
        }
        if (bl) {
            throw this.errors;
        }
        boolean bl2 = false;
        if (s == 1 && string7 != null && string6 != null) {
            bl2 = true;
            if (rDBMSBean2.hasTable(string7)) {
                if (rDBMSBean3.hasTable(string6)) {
                    bl2 = false;
                }
            } else if (rDBMSBean3.hasTable(string7) && rDBMSBean2.hasTable(string6)) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_11_SPECIFIES_FK_AND_PK_TABLE_NAMES_NOT_IN_DIFFERENT_ROLES(string2, string3, string6, string7), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)string2, (Object)string3)));
            throw this.errors;
        }
    }

    private void checkWLRoleHasValidMap(EjbRelation ejbRelation, EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, RDBMSRelation.RDBMSRole rDBMSRole) {
        String string = ejbRelation.getEjbRelationName();
        short s = this.getRelType(ejbRelation);
        RoleSource roleSource = ejbRelationshipRole.getRoleSource();
        RoleSource roleSource2 = ejbRelationshipRole2.getRoleSource();
        RoleSource roleSource3 = null;
        Set set = null;
        String string2 = null;
        Map map = null;
        if (rDBMSRole != null) {
            map = rDBMSRole.getColumnMap();
            string2 = rDBMSRole.getPrimaryKeyTableName();
        }
        if (s == 3) {
            roleSource3 = roleSource;
            set = this.getPrimaryKeyColumns(roleSource.getEjbName(), string2);
        } else if ((s == 2 || s == 1) && rDBMSRole != null && rDBMSRole.getColumnMap().size() > 0) {
            roleSource3 = roleSource2;
            set = this.getPrimaryKeyColumns(roleSource2.getEjbName(), string2);
        }
        if (set != null) {
            if (map == null) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_HAS_NO_COLUMN_MAP(string, ejbRelationshipRole.getName()), new DescriptorErrorInfo("<column-map>", (Object)string, (Object)ejbRelationshipRole.getName())));
                return;
            }
            if (set.size() != map.size()) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_HAS_WRONG_NUMBER_OF_COLUMNS_IN_MAP(string, ejbRelationshipRole.getName()), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)ejbRelation.getEjbRelationName(), (Object)ejbRelationshipRole.getName())));
            } else {
                for (String string3 : map.values()) {
                    if (set.contains(string3)) continue;
                    this.errors.add((Throwable)new ComplianceException(this.fmt.ROLE_HAS_INVALID_KEY_COLUMN_IN_MAP2(string, ejbRelationshipRole.getName(), string3, roleSource2.getEjbName()), new DescriptorErrorInfo("<column-map>", (Object)string, (Object)ejbRelationshipRole.getName())));
                }
            }
        }
    }

    private void checkWLRoleHasValidFkColumns(EjbRelation ejbRelation, EjbRelationshipRole ejbRelationshipRole, RDBMSRelation.RDBMSRole rDBMSRole, EjbRelationshipRole ejbRelationshipRole2) {
        String string = ejbRelation.getEjbRelationName();
        short s = this.getRelType(ejbRelation);
        RoleSource roleSource = ejbRelationshipRole.getRoleSource();
        if ((s == 2 || s == 1) && rDBMSRole != null && rDBMSRole.getColumnMap().size() > 0) {
            Set set;
            Set set2;
            String string2 = null;
            RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(roleSource.getEjbName());
            if (rDBMSBean.hasMultipleTables()) {
                string2 = rDBMSRole.getForeignKeyTableName();
                if (string2 == null) {
                    this.errors.add((Throwable)new ComplianceException(this.fmt.MISSING_FK_TABLE_NAME_FOR_MULTITABLE_BEAN(string, ejbRelationshipRole.getName(), roleSource.getEjbName()), new DescriptorErrorInfo("<foreign-key-column>", (Object)string, (Object)ejbRelationshipRole.getName())));
                    return;
                }
                set2 = this.getPrimaryKeyColumns(roleSource.getEjbName(), string2);
                set = this.getCmpColumns(roleSource.getEjbName(), string2);
            } else {
                set2 = this.getPrimaryKeyColumns(roleSource.getEjbName());
                set = this.getCmpColumns(roleSource.getEjbName());
            }
            Iterator iterator = rDBMSRole.getColumnMap().keySet().iterator();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                Class clazz;
                String string3;
                String string4;
                String string5 = (String)iterator.next();
                if (set2.contains(string5)) {
                    ++n;
                }
                if (!set2.contains(string5) && set.contains(string5)) {
                    ++n2;
                }
                if (!set.contains(string5)) continue;
                RDBMSBean rDBMSBean2 = (RDBMSBean)this.rdbmsBeanMap.get(ejbRelationshipRole2.getRoleSource().getEjbName());
                CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean2.getEjbName());
                CMPBeanDescriptor cMPBeanDescriptor2 = (CMPBeanDescriptor)this.beanMap.get(rDBMSBean.getEjbName());
                if (string2 == null) {
                    string2 = rDBMSBean.getTableName();
                }
                String string6 = rDBMSBean.getCmpField(string2, string5);
                Class clazz2 = cMPBeanDescriptor2.getFieldClass(string6);
                String string7 = rDBMSRole.getPrimaryKeyTableName();
                if (string7 == null) {
                    string7 = rDBMSBean2.getTableName();
                }
                if ((string4 = (String)rDBMSRole.getColumnMap().get(string5)) == null || (string3 = rDBMSBean2.getCmpField(string7, string4)) == null || (clazz = cMPBeanDescriptor.getFieldClass(string3)).equals(clazz2)) continue;
                if (clazz.isPrimitive()) {
                    clazz = ClassUtils.getObjectClass(clazz);
                }
                if (clazz2.isPrimitive()) {
                    clazz2 = ClassUtils.getObjectClass(clazz2);
                }
                if (clazz2.isAssignableFrom(clazz) && clazz.isAssignableFrom(clazz2)) continue;
                this.errors.add((Throwable)new ComplianceException(this.fmt.INVALID_FOREIGN_KEY_FIELD_CLASS(rDBMSBean.getEjbName(), string6, rDBMSBean2.getEjbName(), string3), new DescriptorErrorInfo("<foreign-key-column>", (Object)string, (Object)ejbRelationshipRole.getName())));
            }
            if (n != 0 && n2 != 0) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.FKCOLUMNS_MIX_OF_PK_NONPK_COLUMNS(string, ejbRelationshipRole.getName()), new DescriptorErrorInfo("<foreign-key-column>", (Object)string, (Object)ejbRelationshipRole.getName())));
            }
        }
    }

    private void checkForeignKeyTableSpecified(EjbRelation ejbRelation, EjbRelationshipRole ejbRelationshipRole, RDBMSRelation.RDBMSRole rDBMSRole) {
        String string = ejbRelation.getEjbRelationName();
        short s = this.getRelType(ejbRelation);
        if ((s == 2 || s == 1) && rDBMSRole != null && rDBMSRole.getColumnMap().size() > 0) {
            RoleSource roleSource = ejbRelationshipRole.getRoleSource();
            RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(roleSource.getEjbName());
            String string2 = null;
            if (rDBMSBean.hasMultipleTables() && (string2 = rDBMSRole.getForeignKeyTableName()) == null) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.MISSING_FK_TABLE_NAME_FOR_MULTITABLE_BEAN(string, ejbRelationshipRole.getName(), roleSource.getEjbName()), new DescriptorErrorInfo("<foreign-key-column>", (Object)string, (Object)ejbRelationshipRole.getName())));
                return;
            }
        }
    }

    private void checkRelatedBeansSameDataSource() {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        String string = this.testEjbRel.getEjbRelationName();
        EjbRelation ejbRelation = (EjbRelation)this.relationMap.get(string);
        Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
        EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator.next();
        if (!iterator.hasNext()) {
            return;
        }
        EjbRelationshipRole ejbRelationshipRole2 = (EjbRelationshipRole)iterator.next();
        RoleSource roleSource = ejbRelationshipRole.getRoleSource();
        RoleSource roleSource2 = ejbRelationshipRole2.getRoleSource();
        String string2 = roleSource.getEjbName();
        String string3 = roleSource2.getEjbName();
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string2);
        RDBMSBean rDBMSBean2 = (RDBMSBean)this.rdbmsBeanMap.get(string3);
        String string4 = rDBMSBean.getDataSourceName();
        String string5 = rDBMSBean2.getDataSourceName();
        if (string4 == null || string5 == null) {
            return;
        }
        if (!string4.equals(string5)) {
            this.errors.add((Throwable)new ComplianceException(this.fmt.RELATED_BEANS_MUST_SHARE_DATASOURCE(string, ejbRelationshipRole.getName(), string2, string4, ejbRelationshipRole2.getName(), string3, string5), new DescriptorErrorInfo("<weblogic-relationship-role>", (Object)string, (Object)ejbRelationshipRole.getName())));
            return;
        }
    }

    private Set getPrimaryKeyColumns(String string) {
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(string);
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : cMPBeanDescriptor.getPrimaryKeyFieldNames()) {
            String string3 = rDBMSBean.getCmpColumnForField(string2);
            hashSet.add(string3);
        }
        return hashSet;
    }

    private Set getPrimaryKeyColumns(String string, String string2) {
        if (string2 == null) {
            return this.getPrimaryKeyColumns(string);
        }
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)this.beanMap.get(string);
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : cMPBeanDescriptor.getPrimaryKeyFieldNames()) {
            String string4 = rDBMSBean.getColumnForCmpFieldAndTable(string3, string2);
            if (string4 == null) continue;
            hashSet.add(string4);
        }
        return hashSet;
    }

    private Set getCmpColumns(String string) {
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        return new HashSet(rDBMSBean.getCmpFieldToColumnMap().values());
    }

    private Set getCmpColumns(String string, String string2) {
        if (string2 == null) {
            return this.getCmpColumns(string);
        }
        RDBMSBean rDBMSBean = (RDBMSBean)this.rdbmsBeanMap.get(string);
        HashSet hashSet = new HashSet();
        Map map = rDBMSBean.getCmpField2ColumnMap(string2);
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    private void doWLRoleCheck(RDBMSRelation.RDBMSRole rDBMSRole, EjbRelation ejbRelation, ErrorCollectionException errorCollectionException) {
        EjbRelationshipRole ejbRelationshipRole = ejbRelation.getEjbRelationshipRole(rDBMSRole.getName());
        if (ejbRelationshipRole == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NO_MATCHING_EJB_RELATIONSHIP_ROLE(ejbRelation.getEjbRelationName(), rDBMSRole.getName()), new DescriptorErrorInfo("<ejb-relationship-role>", (Object)ejbRelation.getEjbRelationName(), (Object)rDBMSRole.getName())));
        }
    }

    private EjbRelationshipRole getManyEjbRole(EjbRelation ejbRelation) {
        for (EjbRelationshipRole ejbRelationshipRole : ejbRelation.getAllEjbRelationshipRoles()) {
            if (!ejbRelationshipRole.getMultiplicity().equalsIgnoreCase("many")) continue;
            return ejbRelationshipRole;
        }
        return null;
    }

    private EjbRelationshipRole getOneEjbRole(EjbRelation ejbRelation) {
        for (EjbRelationshipRole ejbRelationshipRole : ejbRelation.getAllEjbRelationshipRoles()) {
            if (!ejbRelationshipRole.getMultiplicity().equalsIgnoreCase("one")) continue;
            return ejbRelationshipRole;
        }
        return null;
    }

    private RDBMSRelation.RDBMSRole getRDBMSRoleForEjbRole(EjbRelation ejbRelation, EjbRelationshipRole ejbRelationshipRole) {
        RDBMSRelation rDBMSRelation = (RDBMSRelation)this.rdbmsRelationMap.get(ejbRelation.getEjbRelationName());
        if (rDBMSRelation == null) {
            return null;
        }
        String string = ejbRelationshipRole.getName();
        RDBMSRelation.RDBMSRole rDBMSRole = rDBMSRelation.getRole1();
        if (rDBMSRole != null && rDBMSRole.getName().compareTo(string) == 0) {
            return rDBMSRole;
        }
        rDBMSRole = rDBMSRelation.getRole2();
        if (rDBMSRole != null && rDBMSRole.getName().compareTo(string) == 0) {
            return rDBMSRole;
        }
        return null;
    }

    private short getRelType(EjbRelation ejbRelation) {
        Collection collection = ejbRelation.getAllEjbRelationshipRoles();
        if (collection.size() == 2) {
            int n = 0;
            int n2 = 0;
            for (EjbRelationshipRole ejbRelationshipRole : collection) {
                if (ejbRelationshipRole.getMultiplicity().equalsIgnoreCase("one")) {
                    n = (short)(n + 1);
                    continue;
                }
                if (!ejbRelationshipRole.getMultiplicity().equalsIgnoreCase("many")) continue;
                n2 = (short)(n2 + 1);
            }
            if (n == 2) {
                return 1;
            }
            if (n2 == 2) {
                return 3;
            }
            if (n == 1 && n2 == 1) {
                return 2;
            }
        }
        return 0;
    }
}

